package tests::ConfigObjectTest;

use strict;

use tests::ConfigValuesTest;
use Lire::Config::TypeSpec;
use Lire::Config::Object;

use base qw/tests::ConfigValueTest/;

sub new {
    my $self = shift->SUPER::new( @_ );

    $self->{'object_spec'} =
      new Lire::Config::ObjectSpec( 'name' =>'object',
                                    'class'=>'tests::ConfigObjectTest::Mock',
                                  );
    $self->{'object_spec'}->add( new Lire::Config::StringSpec('name'=>'s1'));
    $self->{'object_spec'}->add( new Lire::Config::StringSpec('name'=>'s2'));
    $self->{'config_spec'}->add( $self->{'object_spec'} );

    return $self;
}

sub type {
    return "Lire::Config::Object";
}

sub spec {
    return $_[0]{'object_spec'};
}

sub test_as_value {
    my $self = $_[0];

    my $e_object = bless( { 's1' => '', 's2' => '' },
                        'tests::ConfigObjectTest::Mock' );

    local $SIG{'__WARN__'} = sub { $self->annotate( @_ ) };
    my $object = $self->{'object_spec'}->instance()->as_value() || '<undef>';
    $self->assert_isa( 'tests::ConfigObjectTest::Mock', $object );
    $self->assert_deep_equals( $e_object, $object );
}

package tests::ConfigObjectTest::Mock;

sub new_from_config {
    return bless ( $_[1]->Lire::Config::Dictionary::as_value(), $_[0] );
}

$INC{'tests/ConfigObjectTest/Mock.pm'} = __FILE__;

1;
