;; Test Scheme procedures related to picture objects.

(use-modules (unit-test)
             (lepton object)
             ((geda object) #:renamer (symbol-prefix-proc 'geda:)))

(define test-image
  (map char->integer (string->list
"/* XPM */
static char * test_image_xpm[] = {
\"2 1 1 1\",
\" 	c None\",
\"  \"};
")))

(begin-test 'pictures
  (let* ((a (make-picture/vector test-image "test_image.xpm"
                                 '(1 . 2) '(5 . 4) 0 #f))
         (b (copy-object a)))

    (assert-equal 'picture (object-type a))
    (assert-true (picture? a))

    (assert-equal "test_image.xpm" (picture-filename a))
    (assert-equal '(1 . 4) (picture-top-left a))
    (assert-equal '(5 . 2) (picture-bottom-right a))
    (assert-equal 0 (picture-angle a))
    (assert-equal #f (picture-mirror? a))

    (assert-equal (list (picture-filename a)
                        (picture-top-left a)
                        (picture-bottom-right a)
                        (picture-angle a)
                        (picture-mirror? a))
                  (picture-info a))

    (assert-equal (picture-info a) (picture-info b))

    ;; Check setting some parameters. We simulate a rotation by 90
    ;; degrees anti-clockwise about (3,2). This doesn't test the image
    ;; dimensions snapping yet.
    (assert-equal a (set-picture! a '(2 . 0) '(4 . 4) 90 #t))
    (assert-equal '(2 . 4) (picture-top-left a))
    (assert-equal '(4 . 0) (picture-bottom-right a))
    (assert-equal 90 (picture-angle a))
    (assert-equal #t (picture-mirror? a))

    ;; Check mirroring.
    (assert-equal (list a) (mirror-objects! 4 a))
    (assert-equal '(4 . 4) (picture-top-left a))
    (assert-equal '(6 . 0) (picture-bottom-right a))
    (assert-equal 270 (picture-angle a))
    (assert-equal #f (picture-mirror? a))

    ;; Check rotating.
    (assert-equal (list a) (rotate-objects! '(5 . 2) 90 a))
    (assert-equal '(3 . 3) (picture-top-left a))
    (assert-equal '(7 . 1) (picture-bottom-right a))
    (assert-equal 0 (picture-angle a))
    (assert-equal #f (picture-mirror? a))

    ;; Bad angle
    (assert-thrown 'misc-error (set-picture! a '(1 . 2) '(5 . 4) 45 #f))
    ;; Bad data
    (assert-thrown 'misc-error
                   (make-picture/vector
                    (map char->integer (string->list "THIS IS NOT AN IMAGE"))
                    "not_an_image" '(1 . 2) '(5 . 4) 0 #f))
))

;;; The same tests for the deprecated (geda object) module
;;; functions.

(begin-test 'geda:pictures
  (let* ((a (geda:make-picture/vector test-image "test_image.xpm"
                                 '(1 . 2) '(5 . 4) 0 #f))
         (b (geda:copy-object a)))

    (assert-equal 'picture (geda:object-type a))
    (assert-true (geda:picture? a))

    (assert-equal "test_image.xpm" (geda:picture-filename a))
    (assert-equal '(1 . 4) (geda:picture-top-left a))
    (assert-equal '(5 . 2) (geda:picture-bottom-right a))
    (assert-equal 0 (geda:picture-angle a))
    (assert-equal #f (geda:picture-mirror? a))

    (assert-equal (list (geda:picture-filename a)
                        (geda:picture-top-left a)
                        (geda:picture-bottom-right a)
                        (geda:picture-angle a)
                        (geda:picture-mirror? a))
                  (geda:picture-info a))

    (assert-equal (geda:picture-info a) (geda:picture-info b))

    ;; Check setting some parameters. We simulate a rotation by 90
    ;; degrees anti-clockwise about (3,2). This doesn't test the image
    ;; dimensions snapping yet.
    (assert-equal a (geda:set-picture! a '(2 . 0) '(4 . 4) 90 #t))
    (assert-equal '(2 . 4) (geda:picture-top-left a))
    (assert-equal '(4 . 0) (geda:picture-bottom-right a))
    (assert-equal 90 (geda:picture-angle a))
    (assert-equal #t (geda:picture-mirror? a))

    ;; Check mirroring.
    (assert-equal (list a) (geda:mirror-objects! 4 a))
    (assert-equal '(4 . 4) (geda:picture-top-left a))
    (assert-equal '(6 . 0) (geda:picture-bottom-right a))
    (assert-equal 270 (geda:picture-angle a))
    (assert-equal #f (geda:picture-mirror? a))

    ;; Check rotating.
    (assert-equal (list a) (geda:rotate-objects! '(5 . 2) 90 a))
    (assert-equal '(3 . 3) (geda:picture-top-left a))
    (assert-equal '(7 . 1) (geda:picture-bottom-right a))
    (assert-equal 0 (geda:picture-angle a))
    (assert-equal #f (geda:picture-mirror? a))

    ;; Bad angle
    (assert-thrown 'misc-error (geda:set-picture! a '(1 . 2) '(5 . 4) 45 #f))
    ;; Bad data
    (assert-thrown 'misc-error
                   (geda:make-picture/vector
                    (map char->integer (string->list "THIS IS NOT AN IMAGE"))
                    "not_an_image" '(1 . 2) '(5 . 4) 0 #f))
))
