%define texmf_local %(kpsewhich --expand-var='\$TEXMFLOCAL')
Name:           LaTeXML
Version:        0.8.0
Release:        1%{?dist}
Summary:        Converter that transforms TeX and LaTeX into XML/HTML/MathML
License:        CC0
Group:          Applications/Publishing
URL:            http://dlmf.nist.gov/LaTeXML/
Source0:        http://search.cpan.org/CPAN/authors/id/B/BR/BRMILLER/LaTeXML-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch
BuildRequires:  perl >= 0:5.008001
BuildRequires:  perl(Archive::Zip)
BuildRequires:  perl(DB_File)
BuildRequires:  perl(ExtUtils::MakeMaker)
BuildRequires:  perl(File::Which)
BuildRequires:  perl(Getopt::Long) >= 2.37
BuildRequires:  perl(Image::Size)
BuildRequires:  perl(IO::String)
BuildRequires:  perl(JSON::XS)
BuildRequires:  perl(LWP)
BuildRequires:  perl(Parse::RecDescent)
BuildRequires:  perl(Pod::Parser)
BuildRequires:  perl(Test::More)
BuildRequires:  perl(Time::HiRes)
BuildRequires:  perl(URI)
BuildRequires:  perl(XML::LibXML) >= 1.61
BuildRequires:  perl(XML::LibXSLT) >= 1.58
BuildRequires:  tex(tex), tex(latex)
Requires:       perl(Archive::Zip)
Requires:       perl(DB_File)
Requires:       perl(File::Which)
Requires:       perl(Getopt::Long) >= 2.37
Requires:       perl(Image::Size)
Requires:       perl(IO::String)
Requires:       perl(JSON::XS)
Requires:       perl(LWP)
Requires:       perl(Parse::RecDescent)
Requires:       perl(Pod::Parser)
Requires:       perl(Test::More)
Requires:       perl(Time::HiRes)
Requires:       perl(URI)
%if 0%{?fedora} >= 18
BuildRequires:  perl(UUID::Tiny)
Requires:       perl(UUID::Tiny)
%endif
Requires:       perl(XML::LibXML) >= 1.61
Requires:       perl(XML::LibXSLT) >= 1.58
Requires:       perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))
Requires:       perl(Image::Magick)
Requires:       tex(tex), tex(latex)
Requires(post): tex(tex)
Requires(postun): tex(tex)

%description
LaTeXML is a converter that transforms TeX and LaTeX into XML/HTML/MathML
and other formats.

%prep
%setup -q

%build
%{__perl} Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT

make pure_install DESTDIR=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null \;

%{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc Changes LICENSE manual.pdf META.json README
%{_bindir}/*
%{perl_vendorlib}/*
%{_mandir}/man1/*
%{_mandir}/man3/*
%{texmf_local}/tex/latex/latexml/*

%post
mktexlsr >/dev/null 2>&1 || :

%postun
mktexlsr >/dev/null 2>&1 || :

%changelog
* Fri May 02 2014 Bruce Miller <bruce.miller@nist.gov> 0.8.0-1
- Specfile autogenerated by cpanspec 1.78.
