/*
    SPDX-FileCopyrightText: 2015 Martin Gräßlin <mgraesslin@kde.org>
    SPDX-FileCopyrightText: 2015 Marco Martin <mart@kde.org>
    SPDX-FileCopyrightText: 2020 David Edmundson <davidedmundson@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/
#pragma once

#include <QObject>

#include <KWaylandServer/kwaylandserver_export.h>

struct wl_resource;

namespace KWaylandServer
{
class Display;
class BlurManagerInterfacePrivate;
class BlurInterfacePrivate;

/**
 * @brief Represents the Global for org_kde_kwin_blur_manager interface.
 *
 * This class creates BlurInterfaces and attaches them to SurfaceInterfaces.
 *
 * @see BlurInterface
 * @see SurfaceInterface
 */
class KWAYLANDSERVER_EXPORT BlurManagerInterface : public QObject
{
    Q_OBJECT
public:
    explicit BlurManagerInterface(Display *display, QObject *parent = nullptr);
    ~BlurManagerInterface() override;

    void remove();

private:
    QScopedPointer<BlurManagerInterfacePrivate> d;
};

/**
 * @brief Represents the Resource for the org_kde_kwin_blur interface.
 *
 * Instances of this class are only generated by the BlurManagerInterface.
 * The BlurInterface gets attached to a SurfaceInterface and can be assessed
 * from there using @link SurfaceInterface::blur() @endlink. Please note that
 * the BlurInterface is only available on the SurfaceInterface after it has been
 * committed.
 *
 * Lifespan matches the underlying client resource
 *
 * @see BlurManagerInterface
 * @see SurfaceInterface
 */
class KWAYLANDSERVER_EXPORT BlurInterface : public QObject
{
    Q_OBJECT
public:
    ~BlurInterface() override;

    /**
     * @returns The region or the SurfaceInterface which should be blurred, null Region implies complete surface.
     */
    QRegion region();

private:
    explicit BlurInterface(wl_resource *resource);
    friend class BlurManagerInterfacePrivate;

    QScopedPointer<BlurInterfacePrivate> d;
};

}
