/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include <QWidget>
#include <QTextEdit>
#include <QLabel>
#include <QScrollArea>
#include <QListWidget>
#include <QGridLayout>
#include <QStringListModel>
#include <QGroupBox>
#include <QCompleter>
#include <QDateTime>
#include <QSplitter>
#include <QPushButton>
#include <QStandardItemModel>
#include <QStandardItem>
#include "defined_command.h"
#include "../../core/bean/os_characteristic.h"
#include "../../core/bean/folder.h"
#include "../../core/bean/command.h"
#include "../../../commons/constants.h"

class ExecShell : public QFrame
{
    Q_OBJECT

public:
    ExecShell(int clientNbr, OsCharacteristic *characteristics, QWidget *parent);
    void set_remote_path(QString remote_path);
    QTextEdit *textBrowser;
    int id_server;
    void set_commands_list(QList<Command*> *commands_list);
    void save_command(QString command);

public slots:
    void executeDefinedCommand(QString command);
    void execute();
    void set_command_results(QString result);
    void clic_command();
    void double_clic_command();
signals:
    void sendCommand(QString command, QString path);
    void add_command_to_database(Command *command);
private:
    OsCharacteristic *osInfo;
    QLineEdit *commandLineEdit;
    QCompleter *completer;
    QLabel *path;
    QListView *list;
    QStandardItemModel *command_list_model;
    QString remote_path;
    QList<Command*> *commands_list;
    int nbr;
};

