/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.plus.PlusWebAppContext;
import org.mortbay.jetty.plus.Service;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;

public class Server
extends org.mortbay.jetty.Server {
    private static final String[] _configClassNames = new String[]{"org.mortbay.jetty.plus.PlusWebAppContext$Configuration", "org.mortbay.jetty.servlet.JettyWebConfiguration"};
    static Log log = LogFactory.getLog(Server.class);
    private ArrayList _serviceList;

    public Server() {
        this.setWebApplicationConfigurationClassNames(_configClassNames);
    }

    public Server(String configuration) throws IOException {
        super(configuration);
        this.setWebApplicationConfigurationClassNames(_configClassNames);
    }

    public Server(Resource configuration) throws IOException {
        super(configuration);
        this.setWebApplicationConfigurationClassNames(_configClassNames);
    }

    public Server(URL configuration) throws IOException {
        super(configuration);
        this.setWebApplicationConfigurationClassNames(_configClassNames);
    }

    public void addService(Service service) {
        if (this._serviceList == null) {
            this._serviceList = new ArrayList(5);
        }
        this._serviceList.add(service);
        this.addComponent(service);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service List contains: " + this._serviceList.size() + " services"));
        }
    }

    protected synchronized void doStart() throws Exception {
        if (this._serviceList != null) {
            MultiException mex = new MultiException();
            Iterator itor = this._serviceList.iterator();
            while (itor.hasNext()) {
                try {
                    ((Service)itor.next()).start();
                }
                catch (Exception e) {
                    mex.add(e);
                }
            }
            mex.ifExceptionThrowMulti();
        }
        super.doStart();
    }

    protected synchronized void doStop() throws InterruptedException {
        super.doStop();
        if (this._serviceList != null && this._serviceList.size() > 0) {
            ListIterator listItor = this._serviceList.listIterator(this._serviceList.size());
            while (listItor.hasPrevious()) {
                Service s = (Service)listItor.previous();
                if (s == null) continue;
                s.stop();
            }
        }
    }

    public static void main(String[] arg) {
        int i;
        Server[] servers;
        block10: {
            String[] dftConfig = new String[]{"etc/jetty.xml"};
            if (arg.length == 0) {
                log.info((Object)"Using default configuration: etc/jetty.xml");
                arg = dftConfig;
            }
            servers = new Server[arg.length];
            for (i = 0; i < arg.length; ++i) {
                try {
                    servers[i] = new Server(arg[i]);
                    servers[i].start();
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                }
            }
            if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK")) {
                try {
                    Method shutdownHook = Runtime.class.getMethod("addShutdownHook", Thread.class);
                    Thread hook = new Thread(){

                        public void run() {
                            this.setName("Shutdown");
                            log.info((Object)"Shutdown hook executing");
                            for (int i = 0; i < servers.length; ++i) {
                                if (servers[i] == null) continue;
                                try {
                                    servers[i].stop();
                                    continue;
                                }
                                catch (Exception e) {
                                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                                }
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception e) {
                                log.warn((Object)"EXCEPTION ", (Throwable)e);
                            }
                        }
                    };
                    shutdownHook.invoke((Object)Runtime.getRuntime(), hook);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block10;
                    log.debug((Object)"No shutdown hook in JVM ", (Throwable)e);
                }
            }
        }
        for (i = 0; i < arg.length; ++i) {
            try {
                servers[i].join();
                continue;
            }
            catch (Exception e) {
                LogSupport.ignore((Log)log, (Throwable)e);
            }
        }
    }

    protected WebApplicationContext newWebApplicationContext(String webApp) {
        return new PlusWebAppContext(webApp);
    }
}

