/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 * 
 * Contributions from:
 *     Ryan Wagoner <ryan@wgnrs.dynu.com>, 2006
 *          
 * Released under the GPL v2. */

#include <stdlib.h>
#include <stdio.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <glob.h>
#include <syslog.h>
#include <pwd.h>
#include <grp.h> 
#include <unistd.h>
#include <signal.h>
#include <stdarg.h>
#include <netdb.h>
#include <limits.h>
#include <iconv.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <sys/errno.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include <net/if.h>

#include <netinet/in.h>

#include <arpa/inet.h>

#ifdef HAVE_SSL
#include <openssl/ssl.h>
#include <openssl/bio.h>
#include <openssl/err.h>
#endif

#if defined(__linux__)
#include <linux/types.h>
#include <linux/netfilter_ipv4.h>
#define LINUX_NETFILTER 1
#endif

#if defined(__FreeBSD__) || defined(__OpenBSD__)
#include <net/pfvar.h>
#define PF_TRANSPARENT 1
#endif

#include <algorithm>
#include <string>
#include <vector>
#include <map>
#include <fstream>
#include <iostream>

#define STRING_SIZE 1024
#define BUFFER_SIZE 65536

#define TRACE_DIR "/tmp/trace"

#ifndef UNIX_PATH_MAX
#define UNIX_PATH_MAX 108
#endif

#define TYPE_NULL 0
#define TYPE_MSG 1
#define TYPE_FILE 2
#define TYPE_TYPING 3
#define TYPE_WEBCAM 4

struct messageextent
{
	int start;
	int length;
};

struct imevent
{
	time_t timestamp;						/* UNIX timestamp. */
	std::string clientaddress;				/* IP:Port */
	std::string protocolname;				/* From the protocol plugin. */
	bool outgoing;							/* Event is local->remote. */
	int type;								/* One of TYPE_ */
	std::string localid;					/* Local party. */
	std::string remoteid;					/* Remote party. */
	bool filtered;							/* Filter plugin blocked event. */
	std::string categories;					/* Filter plugins append here. */
	std::string eventdata;					/* Usually message text. */
	/* Not used by logging plugins. */
	struct messageextent messageextent;
};

struct response
{
	bool outgoing;
	std::string text;
};

#include "socket.h"
#include "options.h"
#include "tools.h"
#include "sslstate.h"
#include "protocolplugin.h"
#include "loggingplugin.h"
#include "filterplugin.h"
#include "responderplugin.h"
