/* 
 * File: buttons.h
 *
 * GKrellM 2 Plugin to control XMMS2
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * requires GKrellM 2.0.0 or better and XMMS2 DR1 or better
 *
 * Released under the GNU General Public License v2
 */

#ifndef _BUTTONS_H
#define _BUTTONS_H

typedef struct
{
	GkrellmDecalbutton	*button_prev,  *button_next, *button_play;
	GkrellmDecalbutton	*button_pause, *button_stop, *button_menu;

	GkrellmPiximage     *image_prev,   *image_next,  *image_play;
	GkrellmPiximage     *image_pause,  *image_stop,  *image_menu;
} ControlButtons;

void control_buttons_create(ControlButtons *cb, GkrellmPanel *panel,
                            gint y,             void(*cb_button)());
void control_buttons_set_play_pause_button(ControlButtons *cb, gint status);

enum { PREV_BUTTON = 0, PLAY_BUTTON, PAUSE_BUTTON, NEXT_BUTTON, STOP_BUTTON,
       MENU_BUTTON };

#endif
