//**************************************************************************************************
//                                         CmdGnuCapDC.hpp                                         *
//                                        -----------------                                        *
// Description : This class contains values associated with the GNU-Cap DC command. It inherits    *
//               from the class CmdBase.                                                           *
// Started     : 2008-01-29                                                                        *
// Last Update : 2015-03-07                                                                        *
// Copyright   : (C) 2008 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef CMDGCPDC_HPP
#define CMDGCPDC_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "base/CmdBase.hpp"
#include "ngspice/commands/CmdNgSpiceDC.hpp"
#include "utility/CnvtType.hpp"

class CmdNgSpiceDC;

// wxWidgets Includes

#include <wx/tokenzr.h>

//**************************************************************************************************

class CmdGnuCapDC : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    wxString    m_osStart;   // Sweep start value
    wxString    m_osStop;    // Sweep stop  value
    wxString    m_osStep;    // Sweep step  value
    eTypeScale  m_eScale;    // Step scale
    wxString    m_osSource;  // Sweep source
    wxString    m_osTempC;   // Analysis temperature in Celcius

                   CmdGnuCapDC( void );
    virtual       ~CmdGnuCapDC( );

    virtual  bool  bSetDefaults( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdGnuCapDC & operator = ( const CmdNgSpiceDC & roCmdDC );

             void  Print( const wxString & rosPrefix=wxT("  ") );
};

//**************************************************************************************************

#endif // CMDGCPDC_HPP
