/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

#ifndef PSK31_FFT_H_INCLUDED
#define PSK31_FFT_H_INCLUDED
#include "stdio.h"
#include "hansis_fft.h"

class psk31_fft {
public:
	static const int MODE_RXDATA=0;
	static const int MODE_NARROWIF=1;
	void set_parameters(int len, int _overlap, int _mode);
	void get_parameters(int *len, int *over, int *mode);
	void add_rx_sample(int sample);
	void add_if_sample(float I, float Q);
	int has_new_data();
	int get_abs_data(float *data, int start, int len, int delta);
	psk31_fft() {
		rxdata = NULL;
		Idata = Qdata = NULL;
		fft = NULL;
		window = NULL;
		N = valid_counter=-1;
	}
private:
	inline float sqr(float x) {
		return x * x;
	}
	int N;
	int overlap;
	int mode;
	int *rxdata;
	float *Idata, *Qdata;
	int cnt;
	int valid_counter;
	FFTer *fft;
	float *window;
};
#endif
