#
# cmap.py -- color maps for fits viewing
#
# This is open-source software licensed under a BSD license.
# Please see the file LICENSE.txt for details.
#
from __future__ import absolute_import, print_function
from .util import six

import warnings

import numpy as np

__all__ = ['ColorMap', 'add_cmap', 'get_cmap', 'has_cmap', 'get_names',
           'matplotlib_to_ginga_cmap', 'add_matplotlib_cmap',
           'add_matplotlib_cmaps']


# Some built in colormaps

cmap_soss = (
    (0.000000, 0.000000, 0.000000),
    (0.003922, 0.003007, 0.000000),
    (0.007843, 0.006013, 0.000000),
    (0.011765, 0.009020, 0.000000),
    (0.015686, 0.012026, 0.000000),
    (0.019608, 0.015033, 0.000000),
    (0.023529, 0.018039, 0.000000),
    (0.027451, 0.021046, 0.000000),
    (0.031373, 0.024052, 0.000000),
    (0.035294, 0.027059, 0.000000),
    (0.039216, 0.030065, 0.000000),
    (0.043137, 0.033072, 0.000000),
    (0.047059, 0.036078, 0.000000),
    (0.050980, 0.039085, 0.000000),
    (0.054902, 0.042092, 0.000000),
    (0.058824, 0.045098, 0.000000),
    (0.062745, 0.048105, 0.000000),
    (0.066667, 0.051111, 0.000000),
    (0.070588, 0.054118, 0.000000),
    (0.074510, 0.057124, 0.000000),
    (0.078431, 0.060131, 0.000000),
    (0.082353, 0.063137, 0.000000),
    (0.086275, 0.066144, 0.000000),
    (0.090196, 0.069150, 0.000000),
    (0.094118, 0.072157, 0.000000),
    (0.098039, 0.075163, 0.000000),
    (0.101961, 0.078170, 0.000000),
    (0.105882, 0.081176, 0.000000),
    (0.109804, 0.084183, 0.000000),
    (0.113725, 0.087190, 0.000000),
    (0.117647, 0.090196, 0.000000),
    (0.121569, 0.093203, 0.000000),
    (0.125490, 0.096209, 0.000000),
    (0.129412, 0.099216, 0.000000),
    (0.133333, 0.102222, 0.000000),
    (0.137255, 0.105229, 0.000000),
    (0.141176, 0.108235, 0.000000),
    (0.145098, 0.111242, 0.000000),
    (0.149020, 0.114248, 0.000000),
    (0.152941, 0.117255, 0.000000),
    (0.156863, 0.120261, 0.000000),
    (0.160784, 0.123268, 0.000000),
    (0.164706, 0.126275, 0.000000),
    (0.168627, 0.129281, 0.000000),
    (0.172549, 0.132288, 0.000000),
    (0.176471, 0.135294, 0.000000),
    (0.180392, 0.138301, 0.000000),
    (0.184314, 0.141307, 0.000000),
    (0.188235, 0.144314, 0.000000),
    (0.192157, 0.147320, 0.000000),
    (0.196078, 0.150327, 0.000000),
    (0.200000, 0.153333, 0.000000),
    (0.203922, 0.156340, 0.000000),
    (0.207843, 0.159346, 0.000000),
    (0.211765, 0.162353, 0.000000),
    (0.215686, 0.165359, 0.000000),
    (0.219608, 0.168366, 0.000000),
    (0.223529, 0.171373, 0.000000),
    (0.227451, 0.174379, 0.000000),
    (0.231373, 0.177386, 0.000000),
    (0.235294, 0.180392, 0.000000),
    (0.239216, 0.183399, 0.000000),
    (0.243137, 0.186405, 0.000000),
    (0.247059, 0.189412, 0.000000),
    (0.250980, 0.192418, 0.000000),
    (0.254902, 0.195425, 0.000000),
    (0.258824, 0.198431, 0.000000),
    (0.262745, 0.201438, 0.000000),
    (0.266667, 0.204444, 0.000000),
    (0.270588, 0.207451, 0.000000),
    (0.274510, 0.210458, 0.000000),
    (0.278431, 0.213464, 0.000000),
    (0.282353, 0.216471, 0.000000),
    (0.286275, 0.219477, 0.000000),
    (0.290196, 0.222484, 0.000000),
    (0.294118, 0.225490, 0.000000),
    (0.298039, 0.228497, 0.000000),
    (0.301961, 0.231503, 0.000000),
    (0.305882, 0.234510, 0.000000),
    (0.309804, 0.237516, 0.000000),
    (0.313725, 0.240523, 0.000000),
    (0.317647, 0.243529, 0.000000),
    (0.321569, 0.246536, 0.000000),
    (0.325490, 0.249542, 0.000000),
    (0.329412, 0.252549, 0.000000),
    (0.333333, 0.255556, 0.000000),
    (0.337255, 0.258562, 0.000000),
    (0.341176, 0.261569, 0.000000),
    (0.345098, 0.264575, 0.000000),
    (0.349020, 0.267582, 0.000000),
    (0.352941, 0.270588, 0.000000),
    (0.356863, 0.273595, 0.000000),
    (0.360784, 0.276601, 0.000000),
    (0.364706, 0.279608, 0.000000),
    (0.368627, 0.282614, 0.000000),
    (0.372549, 0.285621, 0.000000),
    (0.376471, 0.288627, 0.000000),
    (0.380392, 0.291634, 0.000000),
    (0.384314, 0.294641, 0.000000),
    (0.388235, 0.297647, 0.000000),
    (0.392157, 0.300654, 0.000000),
    (0.396078, 0.303660, 0.000000),
    (0.400000, 0.306667, 0.000000),
    (0.403922, 0.309673, 0.000000),
    (0.407843, 0.312680, 0.000000),
    (0.411765, 0.315686, 0.000000),
    (0.415686, 0.318693, 0.000000),
    (0.419608, 0.321699, 0.000000),
    (0.423529, 0.324706, 0.000000),
    (0.427451, 0.327712, 0.000000),
    (0.431373, 0.330719, 0.000000),
    (0.435294, 0.333725, 0.000000),
    (0.439216, 0.336732, 0.000000),
    (0.443137, 0.339739, 0.000000),
    (0.447059, 0.342745, 0.000000),
    (0.450980, 0.345752, 0.000000),
    (0.454902, 0.348758, 0.000000),
    (0.458824, 0.351765, 0.000000),
    (0.462745, 0.354771, 0.000000),
    (0.466667, 0.357778, 0.000000),
    (0.470588, 0.360784, 0.000000),
    (0.474510, 0.363791, 0.000000),
    (0.478431, 0.366797, 0.000000),
    (0.482353, 0.369804, 0.000000),
    (0.486275, 0.372810, 0.000000),
    (0.490196, 0.375817, 0.000000),
    (0.494118, 0.378824, 0.000000),
    (0.498039, 0.381830, 0.000000),
    (0.501961, 0.384837, 0.000000),
    (0.505882, 0.387843, 0.000000),
    (0.509804, 0.390850, 0.000000),
    (0.513725, 0.393856, 0.000000),
    (0.517647, 0.396863, 0.000000),
    (0.521569, 0.399869, 0.000000),
    (0.525490, 0.402876, 0.000000),
    (0.529412, 0.405882, 0.000000),
    (0.533333, 0.408889, 0.000000),
    (0.537255, 0.411895, 0.000000),
    (0.541176, 0.414902, 0.000000),
    (0.545098, 0.417908, 0.000000),
    (0.549020, 0.420915, 0.000000),
    (0.552941, 0.423922, 0.000000),
    (0.556863, 0.426928, 0.000000),
    (0.560784, 0.429935, 0.000000),
    (0.564706, 0.432941, 0.000000),
    (0.568627, 0.435948, 0.000000),
    (0.572549, 0.438954, 0.000000),
    (0.576471, 0.441961, 0.000000),
    (0.580392, 0.444967, 0.000000),
    (0.584314, 0.447974, 0.000000),
    (0.588235, 0.450980, 0.000000),
    (0.592157, 0.453987, 0.000000),
    (0.596078, 0.456993, 0.000000),
    (0.600000, 0.460000, 0.000000),
    (0.603922, 0.463007, 0.000000),
    (0.607843, 0.466013, 0.000000),
    (0.611765, 0.469020, 0.000000),
    (0.615686, 0.472026, 0.000000),
    (0.619608, 0.475033, 0.000000),
    (0.623529, 0.478039, 0.000000),
    (0.627451, 0.481046, 0.000000),
    (0.631373, 0.484052, 0.000000),
    (0.635294, 0.487059, 0.000000),
    (0.639216, 0.490065, 0.000000),
    (0.643137, 0.493072, 0.000000),
    (0.647059, 0.496078, 0.000000),
    (0.650980, 0.499085, 0.000000),
    (0.654902, 0.502092, 0.000000),
    (0.658824, 0.505098, 0.000000),
    (0.662745, 0.508105, 0.000000),
    (0.666667, 0.511111, 0.000000),
    (0.670588, 0.514118, 0.000000),
    (0.674510, 0.517124, 0.000000),
    (0.678431, 0.520131, 0.000000),
    (0.682353, 0.523137, 0.000000),
    (0.686275, 0.526144, 0.000000),
    (0.690196, 0.529150, 0.000000),
    (0.694118, 0.532157, 0.000000),
    (0.698039, 0.535163, 0.000000),
    (0.701961, 0.538170, 0.000000),
    (0.705882, 0.541176, 0.000000),
    (0.709804, 0.544183, 0.000000),
    (0.713725, 0.547190, 0.000000),
    (0.717647, 0.550196, 0.000000),
    (0.721569, 0.553203, 0.000000),
    (0.725490, 0.556209, 0.000000),
    (0.729412, 0.559216, 0.000000),
    (0.733333, 0.562222, 0.000000),
    (0.737255, 0.565229, 0.000000),
    (0.741176, 0.568235, 0.000000),
    (0.745098, 0.571242, 0.000000),
    (0.749020, 0.574248, 0.000000),
    (0.752941, 0.577255, 0.000000),
    (0.756863, 0.580261, 0.000000),
    (0.760784, 0.583268, 0.000000),
    (0.764706, 0.586275, 0.000000),
    (0.768627, 0.589281, 0.000000),
    (0.772549, 0.592288, 0.000000),
    (0.776471, 0.595294, 0.000000),
    (0.780392, 0.598301, 0.000000),
    (0.784314, 0.601307, 0.000000),
    (0.788235, 0.604314, 0.000000),
    (0.792157, 0.607320, 0.000000),
    (0.796078, 0.610327, 0.000000),
    (0.800000, 0.613333, 0.000000),
    (0.803922, 0.616340, 0.000000),
    (0.807843, 0.619346, 0.000000),
    (0.811765, 0.622353, 0.000000),
    (0.815686, 0.625359, 0.000000),
    (0.819608, 0.628366, 0.000000),
    (0.823529, 0.631373, 0.000000),
    (0.827451, 0.634379, 0.000000),
    (0.831373, 0.637386, 0.000000),
    (0.835294, 0.640392, 0.000000),
    (0.839216, 0.643399, 0.000000),
    (0.843137, 0.646405, 0.000000),
    (0.847059, 0.649412, 0.000000),
    (0.850980, 0.652418, 0.000000),
    (0.854902, 0.655425, 0.000000),
    (0.858824, 0.658431, 0.000000),
    (0.862745, 0.661438, 0.000000),
    (0.866667, 0.664444, 0.000000),
    (0.870588, 0.677451, 0.000000),
    (0.874510, 0.680458, 0.000000),
    (0.878431, 0.693464, 0.000000),
    (0.882353, 0.706471, 0.000000),
    (0.886275, 0.719477, 0.000000),
    (0.890196, 0.722484, 0.000000),
    (0.894118, 0.735490, 0.000000),
    (0.898039, 0.748497, 0.000000),
    (0.901961, 0.751503, 0.000000),
    (0.905882, 0.764510, 0.000000),
    (0.909804, 0.777516, 0.000000),
    (0.913725, 0.780523, 0.000000),
    (0.917647, 0.793529, 0.000000),
    (0.921569, 0.806536, 0.000000),
    (0.925490, 0.819542, 0.000000),
    (0.929412, 0.822549, 0.000000),
    (0.933333, 0.835556, 0.000000),
    (0.937255, 0.848562, 0.000000),
    (0.941176, 0.851569, 0.000000),
    (0.945098, 0.864575, 0.000000),
    (0.949020, 0.877582, 0.000000),
    (0.952941, 0.880588, 0.000000),
    (0.956863, 0.893595, 0.000000),
    (0.960784, 0.906601, 0.000000),
    (0.964706, 0.919608, 0.000000),
    (0.968627, 0.922614, 0.000000),
    (0.972549, 0.935621, 0.000000),
    (0.976471, 0.948627, 0.000000),
    (0.980392, 0.951634, 0.000000),
    (0.984314, 0.964641, 0.000000),
    (0.988235, 0.977647, 0.000000),
    (0.992157, 0.980654, 0.000000),
    (0.996078, 0.993660, 0.000000),
    (1.00000, 1.00000, 1.00000),
)

cmap_idl2 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.14118, 0.00000),
                (0.00000, 0.28235, 0.00000),
                (0.00000, 0.29412, 0.00000),
                (0.00000, 0.30980, 0.00000),
                (0.00000, 0.32157, 0.00000),
                (0.00000, 0.33725, 0.00000),
                (0.00000, 0.35294, 0.00000),
                (0.00000, 0.36471, 0.00000),
                (0.00000, 0.38039, 0.00000),
                (0.00000, 0.39216, 0.00000),
                (0.00000, 0.40784, 0.00000),
                (0.00000, 0.42353, 0.00000),
                (0.00000, 0.45882, 0.00000),
                (0.00000, 0.49412, 0.00000),
                (0.00000, 0.52941, 0.00000),
                (0.00000, 0.56471, 0.00000),
                (0.00000, 0.60000, 0.00000),
                (0.00000, 0.63529, 0.00000),
                (0.00000, 0.67059, 0.00000),
                (0.00000, 0.70588, 0.00000),
                (0.00000, 0.74118, 0.00000),
                (0.00000, 0.77647, 0.00000),
                (0.00000, 0.81176, 0.00000),
                (0.00000, 0.84706, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.91765, 0.00000),
                (0.00000, 0.95294, 0.00000),
                (0.00000, 0.98824, 0.00000),
                (0.02353, 0.97647, 0.00000),
                (0.04706, 0.96471, 0.00000),
                (0.07059, 0.95294, 0.00000),
                (0.09412, 0.94118, 0.00000),
                (0.11765, 0.91765, 0.00000),
                (0.14118, 0.89412, 0.00000),
                (0.16471, 0.87059, 0.00000),
                (0.18824, 0.84706, 0.00000),
                (0.21176, 0.82353, 0.00000),
                (0.23529, 0.80000, 0.00000),
                (0.25882, 0.77647, 0.00000),
                (0.28235, 0.75294, 0.00000),
                (0.30588, 0.72941, 0.00000),
                (0.32941, 0.70588, 0.00000),
                (0.35294, 0.68235, 0.00000),
                (0.37647, 0.65882, 0.00000),
                (0.40000, 0.63529, 0.00000),
                (0.42353, 0.61176, 0.00000),
                (0.44706, 0.58824, 0.00000),
                (0.47059, 0.56471, 0.00000),
                (0.49412, 0.54118, 0.00000),
                (0.51765, 0.51765, 0.00000),
                (0.54118, 0.49412, 0.00000),
                (0.56471, 0.47059, 0.00000),
                (0.58824, 0.44706, 0.00000),
                (0.61176, 0.42353, 0.00000),
                (0.63529, 0.40000, 0.00000),
                (0.65882, 0.37647, 0.00000),
                (0.68235, 0.35294, 0.00000),
                (0.70588, 0.32941, 0.00000),
                (0.72941, 0.30588, 0.00000),
                (0.75294, 0.28235, 0.00000),
                (0.77647, 0.25882, 0.00000),
                (0.80000, 0.23529, 0.00000),
                (0.82353, 0.21176, 0.00000),
                (0.84706, 0.18824, 0.00000),
                (0.87059, 0.16471, 0.00000),
                (0.89412, 0.14118, 0.00000),
                (0.91765, 0.11765, 0.00000),
                (0.94118, 0.09412, 0.00000),
                (0.95294, 0.07059, 0.00000),
                (0.96471, 0.04706, 0.00000),
                (0.97647, 0.02353, 0.00000),
                (0.98824, 0.00000, 0.00000),
                (0.98824, 0.00000, 0.00000),
                (0.98824, 0.00000, 0.00000),
                (0.98824, 0.00000, 0.00000),
                (0.98824, 0.00000, 0.00392),
                (0.98431, 0.00000, 0.01176),
                (0.98039, 0.00000, 0.01961),
                (0.97647, 0.00000, 0.02745),
                (0.97255, 0.00000, 0.03529),
                (0.97255, 0.00000, 0.03922),
                (0.97255, 0.00000, 0.04706),
                (0.97255, 0.00000, 0.05490),
                (0.97255, 0.00000, 0.06275),
                (0.96863, 0.00000, 0.07059),
                (0.96471, 0.00000, 0.07843),
                (0.96078, 0.00000, 0.08627),
                (0.95686, 0.00000, 0.09804),
                (0.95294, 0.00000, 0.10588),
                (0.94902, 0.00000, 0.11373),
                (0.94510, 0.00000, 0.12157),
                (0.94118, 0.00000, 0.13333),
                (0.94118, 0.00000, 0.13725),
                (0.93725, 0.00000, 0.14510),
                (0.93333, 0.00000, 0.15294),
                (0.92941, 0.00000, 0.16078),
                (0.92549, 0.00000, 0.16863),
                (0.92549, 0.00000, 0.17647),
                (0.92549, 0.00000, 0.18431),
                (0.92549, 0.00000, 0.19608),
                (0.92157, 0.00000, 0.20392),
                (0.91765, 0.00000, 0.21176),
                (0.91373, 0.00000, 0.21961),
                (0.90980, 0.00000, 0.23137),
                (0.90588, 0.00000, 0.23922),
                (0.90196, 0.00000, 0.24706),
                (0.89804, 0.00000, 0.25490),
                (0.89412, 0.00000, 0.26275),
                (0.89412, 0.00000, 0.26667),
                (0.89412, 0.00000, 0.27451),
                (0.89412, 0.00000, 0.28235),
                (0.89412, 0.00000, 0.29020),
                (0.89020, 0.00000, 0.29804),
                (0.88627, 0.00000, 0.30588),
                (0.88235, 0.00000, 0.31373),
                (0.87843, 0.00000, 0.32549),
                (0.87451, 0.00000, 0.33333),
                (0.87059, 0.00000, 0.34118),
                (0.86667, 0.00000, 0.34902),
                (0.86275, 0.00392, 0.36078),
                (0.85882, 0.00392, 0.36863),
                (0.85490, 0.00392, 0.37647),
                (0.85098, 0.00392, 0.38431),
                (0.84706, 0.00000, 0.39608),
                (0.84706, 0.00000, 0.40000),
                (0.84706, 0.00000, 0.40784),
                (0.84706, 0.00000, 0.41569),
                (0.84706, 0.00000, 0.42353),
                (0.84314, 0.00000, 0.43137),
                (0.83922, 0.00000, 0.43922),
                (0.83529, 0.00000, 0.44706),
                (0.83137, 0.00000, 0.45490),
                (0.82745, 0.00000, 0.46275),
                (0.82353, 0.00000, 0.47059),
                (0.81961, 0.00000, 0.47843),
                (0.81569, 0.00000, 0.49020),
                (0.81176, 0.00000, 0.49804),
                (0.80784, 0.00000, 0.50588),
                (0.80392, 0.00000, 0.51373),
                (0.80000, 0.00000, 0.52549),
                (0.80000, 0.00000, 0.52941),
                (0.80000, 0.00000, 0.53725),
                (0.80000, 0.00000, 0.54510),
                (0.80000, 0.00000, 0.55294),
                (0.79608, 0.00000, 0.56078),
                (0.79216, 0.00000, 0.56863),
                (0.78824, 0.00000, 0.57647),
                (0.78431, 0.00000, 0.58824),
                (0.78039, 0.00000, 0.59608),
                (0.77647, 0.00000, 0.60392),
                (0.77255, 0.00000, 0.61176),
                (0.76863, 0.00000, 0.62353),
                (0.76863, 0.00000, 0.62745),
                (0.76863, 0.00000, 0.63529),
                (0.76863, 0.00000, 0.63922),
                (0.76863, 0.00000, 0.64706),
                (0.76471, 0.00000, 0.65490),
                (0.76078, 0.00000, 0.66275),
                (0.75686, 0.00000, 0.67059),
                (0.75294, 0.00000, 0.68235),
                (0.74902, 0.00000, 0.69020),
                (0.74510, 0.00000, 0.69804),
                (0.74118, 0.00000, 0.70588),
                (0.73725, 0.00000, 0.71765),
                (0.73333, 0.00000, 0.72549),
                (0.72941, 0.00000, 0.73333),
                (0.72549, 0.00000, 0.74118),
                (0.72157, 0.00000, 0.75294),
                (0.72157, 0.00000, 0.75686),
                (0.72157, 0.00000, 0.76471),
                (0.72157, 0.00000, 0.77255),
                (0.72157, 0.00000, 0.78039),
                (0.71765, 0.00000, 0.78824),
                (0.71373, 0.00000, 0.79608),
                (0.70980, 0.00000, 0.80392),
                (0.70588, 0.00000, 0.81569),
                (0.70196, 0.00000, 0.82353),
                (0.69804, 0.00000, 0.83137),
                (0.69412, 0.00000, 0.83922),
                (0.69020, 0.00000, 0.84706),
                (0.69020, 0.00000, 0.85098),
                (0.69020, 0.00000, 0.85882),
                (0.69020, 0.00000, 0.86667),
                (0.69020, 0.00000, 0.87451),
                (0.68627, 0.00000, 0.88235),
                (0.68235, 0.00000, 0.89020),
                (0.67843, 0.00000, 0.89804),
                (0.67451, 0.00000, 0.90980),
                (0.67059, 0.00000, 0.91765),
                (0.66667, 0.00000, 0.92549),
                (0.66275, 0.00000, 0.93333),
                (0.65882, 0.00000, 0.94510),
                (0.65490, 0.00000, 0.95294),
                (0.65098, 0.00000, 0.96078),
                (0.64706, 0.00000, 0.96863),
                (0.64314, 0.00000, 0.98039),
                (0.64314, 0.00000, 0.98431),
                (0.64314, 0.00000, 0.98824),
                (0.64314, 0.00000, 0.99216),
                (0.64314, 0.00000, 1.00000),
                (0.63922, 0.00000, 1.00000),
                (0.63529, 0.00000, 1.00000),
                (0.63137, 0.00000, 1.00000),
                (0.62745, 0.00000, 1.00000),
                (0.62353, 0.00000, 1.00000),
                (0.61961, 0.00000, 1.00000),
                (0.61569, 0.00000, 1.00000),
                (0.61176, 0.00000, 1.00000),
                (0.60784, 0.00000, 1.00000),
                (0.60392, 0.00000, 1.00000),
                (0.60000, 0.00000, 1.00000),
                (0.59608, 0.00000, 1.00000),
                (0.59608, 0.00000, 1.00000),
                (0.59608, 0.00000, 1.00000),
                (0.59608, 0.00000, 1.00000),
                (0.59608, 0.00000, 1.00000),
                (0.59216, 0.00000, 1.00000),
                (0.58824, 0.00000, 1.00000),
                (0.58431, 0.00000, 1.00000),
                (0.58039, 0.00000, 1.00000),
                (0.59216, 0.03137, 1.00000),
                (0.60392, 0.06275, 1.00000),
                (0.61569, 0.09412, 1.00000),
                (0.62745, 0.12549, 1.00000),
                (0.63922, 0.15686, 1.00000),
                (0.65098, 0.18824, 1.00000),
                (0.66275, 0.21961, 1.00000),
                (0.67451, 0.25098, 1.00000),
                (0.69020, 0.28235, 1.00000),
                (0.70588, 0.31373, 1.00000),
                (0.72157, 0.34510, 1.00000),
                (0.73725, 0.37647, 1.00000),
                (0.74902, 0.40784, 1.00000),
                (0.76078, 0.43922, 1.00000),
                (0.77255, 0.47059, 1.00000),
                (0.78431, 0.50196, 1.00000),
                (0.79608, 0.52941, 1.00000),
                (0.80784, 0.55686, 1.00000),
                (0.81961, 0.58431, 1.00000),
                (0.83137, 0.61176, 1.00000),
                (0.84314, 0.64314, 1.00000),
                (0.85490, 0.67451, 1.00000),
                (0.86667, 0.70588, 1.00000),
                (0.87843, 0.73725, 1.00000),
                (0.89412, 0.76863, 1.00000),
                (0.90980, 0.80000, 1.00000),
                (0.92549, 0.83137, 1.00000),
                (0.94118, 0.86275, 1.00000),
                (0.95294, 0.89412, 1.00000),
                (0.96471, 0.92549, 1.00000),
                (0.97647, 0.95686, 1.00000),
                (0.98824, 0.98824, 1.00000),
                (0.99216, 0.99216, 1.00000),
                (0.99608, 0.99608, 1.00000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_rainbow4 = (
                (0.00000, 0.00000, 0.01176),
                (0.00000, 0.00000, 0.02745),
                (0.00000, 0.00000, 0.04314),
                (0.00000, 0.00000, 0.05882),
                (0.00000, 0.00000, 0.07451),
                (0.00000, 0.00000, 0.09020),
                (0.00000, 0.00000, 0.10588),
                (0.00000, 0.00000, 0.12157),
                (0.00000, 0.00000, 0.13725),
                (0.00000, 0.00000, 0.15294),
                (0.00000, 0.00000, 0.16863),
                (0.00000, 0.00000, 0.18431),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.21176),
                (0.00000, 0.00000, 0.22745),
                (0.00000, 0.00000, 0.24314),
                (0.00000, 0.00000, 0.25882),
                (0.00000, 0.00000, 0.27451),
                (0.00000, 0.00000, 0.29020),
                (0.00000, 0.00000, 0.30588),
                (0.00000, 0.00000, 0.32157),
                (0.00000, 0.00000, 0.33725),
                (0.00000, 0.00000, 0.35294),
                (0.00000, 0.00000, 0.36863),
                (0.00000, 0.00000, 0.38431),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.41176),
                (0.00000, 0.00000, 0.42745),
                (0.00000, 0.00000, 0.44314),
                (0.00000, 0.00000, 0.45882),
                (0.00000, 0.00000, 0.47451),
                (0.00000, 0.00000, 0.49020),
                (0.00000, 0.00000, 0.50588),
                (0.00000, 0.00000, 0.52157),
                (0.00000, 0.00000, 0.53725),
                (0.00000, 0.00000, 0.55294),
                (0.00000, 0.00000, 0.56863),
                (0.00000, 0.00000, 0.58431),
                (0.00000, 0.00000, 0.60000),
                (0.00000, 0.00000, 0.61176),
                (0.00000, 0.00000, 0.62745),
                (0.00000, 0.00000, 0.64314),
                (0.00000, 0.00000, 0.65882),
                (0.00000, 0.00000, 0.67451),
                (0.00000, 0.00000, 0.69020),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.72157),
                (0.00000, 0.00000, 0.73725),
                (0.00000, 0.00000, 0.75294),
                (0.00000, 0.00000, 0.76863),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.80000),
                (0.00000, 0.00000, 0.81176),
                (0.00000, 0.00000, 0.82745),
                (0.00000, 0.00000, 0.84314),
                (0.00000, 0.00000, 0.85882),
                (0.00000, 0.00000, 0.87451),
                (0.00000, 0.00000, 0.89020),
                (0.00000, 0.00000, 0.90588),
                (0.00000, 0.00000, 0.92157),
                (0.00000, 0.00000, 0.93725),
                (0.00000, 0.00000, 0.95294),
                (0.00000, 0.00000, 0.96863),
                (0.00000, 0.00000, 0.98431),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.03529, 1.00000),
                (0.00000, 0.07059, 1.00000),
                (0.00000, 0.10980, 1.00000),
                (0.00000, 0.14510, 1.00000),
                (0.00000, 0.18039, 1.00000),
                (0.00000, 0.21961, 1.00000),
                (0.00000, 0.25490, 1.00000),
                (0.00000, 0.29412, 1.00000),
                (0.00000, 0.32941, 1.00000),
                (0.00000, 0.36471, 1.00000),
                (0.00000, 0.40392, 1.00000),
                (0.00000, 0.43922, 1.00000),
                (0.00000, 0.47843, 1.00000),
                (0.00000, 0.50196, 1.00000),
                (0.00000, 0.52549, 1.00000),
                (0.00000, 0.54902, 1.00000),
                (0.00000, 0.57255, 1.00000),
                (0.00000, 0.59608, 1.00000),
                (0.00000, 0.61961, 1.00000),
                (0.00000, 0.64314, 1.00000),
                (0.00000, 0.66667, 1.00000),
                (0.00000, 0.69020, 1.00000),
                (0.00000, 0.71373, 1.00000),
                (0.00000, 0.73725, 1.00000),
                (0.00000, 0.76078, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.80000, 1.00000),
                (0.00000, 0.81569, 1.00000),
                (0.00000, 0.83137, 1.00000),
                (0.00000, 0.84706, 1.00000),
                (0.00000, 0.86667, 1.00000),
                (0.00000, 0.88235, 1.00000),
                (0.00000, 0.89804, 1.00000),
                (0.00000, 0.91373, 1.00000),
                (0.00000, 0.93333, 1.00000),
                (0.00000, 0.94902, 1.00000),
                (0.00000, 0.96471, 1.00000),
                (0.00000, 0.98039, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 0.97647),
                (0.00000, 1.00000, 0.95294),
                (0.00000, 1.00000, 0.92941),
                (0.00000, 1.00000, 0.90588),
                (0.00000, 1.00000, 0.88627),
                (0.00000, 1.00000, 0.86275),
                (0.00000, 1.00000, 0.83922),
                (0.00000, 1.00000, 0.81569),
                (0.00000, 1.00000, 0.79608),
                (0.00000, 1.00000, 0.77255),
                (0.00000, 1.00000, 0.74902),
                (0.00000, 1.00000, 0.72549),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.65098),
                (0.00000, 1.00000, 0.59608),
                (0.00000, 1.00000, 0.54118),
                (0.00000, 1.00000, 0.48627),
                (0.00000, 1.00000, 0.43137),
                (0.00000, 1.00000, 0.37647),
                (0.00000, 1.00000, 0.32549),
                (0.00000, 1.00000, 0.27059),
                (0.00000, 1.00000, 0.21569),
                (0.00000, 1.00000, 0.16078),
                (0.00000, 1.00000, 0.10588),
                (0.00000, 1.00000, 0.05098),
                (0.00000, 1.00000, 0.00000),
                (0.05098, 1.00000, 0.00000),
                (0.10588, 1.00000, 0.00000),
                (0.16078, 1.00000, 0.00000),
                (0.21569, 1.00000, 0.00000),
                (0.27059, 1.00000, 0.00000),
                (0.32549, 1.00000, 0.00000),
                (0.37647, 1.00000, 0.00000),
                (0.43137, 1.00000, 0.00000),
                (0.48627, 1.00000, 0.00000),
                (0.54118, 1.00000, 0.00000),
                (0.59608, 1.00000, 0.00000),
                (0.65098, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.72549, 1.00000, 0.00000),
                (0.74902, 1.00000, 0.00000),
                (0.77255, 1.00000, 0.00000),
                (0.79608, 1.00000, 0.00000),
                (0.81569, 1.00000, 0.00000),
                (0.83922, 1.00000, 0.00000),
                (0.86275, 1.00000, 0.00000),
                (0.88627, 1.00000, 0.00000),
                (0.90588, 1.00000, 0.00000),
                (0.92941, 1.00000, 0.00000),
                (0.95294, 1.00000, 0.00000),
                (0.97647, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.99608, 0.97647, 0.00000),
                (0.99608, 0.95686, 0.00000),
                (0.99608, 0.93333, 0.00000),
                (0.99608, 0.91373, 0.00000),
                (0.99216, 0.89412, 0.00000),
                (0.99216, 0.87059, 0.00000),
                (0.99216, 0.85098, 0.00000),
                (0.99216, 0.82745, 0.00000),
                (0.98824, 0.80784, 0.00000),
                (0.98824, 0.78824, 0.00000),
                (0.98824, 0.76471, 0.00000),
                (0.98824, 0.74510, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.70588, 0.00000),
                (0.98824, 0.68627, 0.00000),
                (0.98824, 0.66667, 0.00000),
                (0.98824, 0.64706, 0.00000),
                (0.99216, 0.62745, 0.00000),
                (0.99216, 0.60784, 0.00000),
                (0.99216, 0.58824, 0.00000),
                (0.99216, 0.56863, 0.00000),
                (0.99608, 0.54902, 0.00000),
                (0.99608, 0.52941, 0.00000),
                (0.99608, 0.50980, 0.00000),
                (0.99608, 0.49020, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.43137, 0.00000),
                (1.00000, 0.39608, 0.00000),
                (1.00000, 0.36078, 0.00000),
                (1.00000, 0.32549, 0.00000),
                (1.00000, 0.28627, 0.00000),
                (1.00000, 0.25098, 0.00000),
                (1.00000, 0.21569, 0.00000),
                (1.00000, 0.18039, 0.00000),
                (1.00000, 0.14118, 0.00000),
                (1.00000, 0.10588, 0.00000),
                (1.00000, 0.07059, 0.00000),
                (1.00000, 0.03529, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.05098),
                (1.00000, 0.00000, 0.10588),
                (1.00000, 0.00000, 0.16078),
                (1.00000, 0.00000, 0.21569),
                (1.00000, 0.00000, 0.27059),
                (1.00000, 0.00000, 0.32549),
                (1.00000, 0.00000, 0.37647),
                (1.00000, 0.00000, 0.43137),
                (1.00000, 0.00000, 0.48627),
                (1.00000, 0.00000, 0.54118),
                (1.00000, 0.00000, 0.59608),
                (1.00000, 0.00000, 0.65098),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.72549),
                (1.00000, 0.00000, 0.74902),
                (1.00000, 0.00000, 0.77255),
                (1.00000, 0.00000, 0.79608),
                (1.00000, 0.00000, 0.81569),
                (1.00000, 0.00000, 0.83922),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.88627),
                (1.00000, 0.00000, 0.90588),
                (1.00000, 0.00000, 0.92941),
                (1.00000, 0.00000, 0.95294),
                (1.00000, 0.00000, 0.97647),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.03529, 1.00000),
                (1.00000, 0.07059, 1.00000),
                (1.00000, 0.10588, 1.00000),
                (1.00000, 0.14118, 1.00000),
                (1.00000, 0.18039, 1.00000),
                (1.00000, 0.21569, 1.00000),
                (1.00000, 0.25098, 1.00000),
                (1.00000, 0.28627, 1.00000),
                (1.00000, 0.32549, 1.00000),
                (1.00000, 0.36078, 1.00000),
                (1.00000, 0.39608, 1.00000),
                (1.00000, 0.43137, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.48627, 1.00000),
                (1.00000, 0.50588, 1.00000),
                (1.00000, 0.52157, 1.00000),
                (1.00000, 0.54118, 1.00000),
                (1.00000, 0.56078, 1.00000),
                (1.00000, 0.57647, 1.00000),
                (1.00000, 0.59608, 1.00000),
                (1.00000, 0.61176, 1.00000),
                (1.00000, 0.63137, 1.00000),
                (1.00000, 0.65098, 1.00000),
                (1.00000, 0.66667, 1.00000),
                (1.00000, 0.68627, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.74510, 1.00000),
                (1.00000, 0.78824, 1.00000),
                (1.00000, 0.83137, 1.00000),
                (1.00000, 0.87059, 1.00000),
                (1.00000, 0.91373, 1.00000),
                (1.00000, 0.95686, 1.00000),
                (1.00000, 1.00000, 1.00000),
)

cmap_idl4 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00784),
                (0.00000, 0.00000, 0.01569),
                (0.00000, 0.00000, 0.02353),
                (0.00000, 0.00000, 0.03137),
                (0.00000, 0.00000, 0.03922),
                (0.00000, 0.00000, 0.04706),
                (0.00000, 0.00000, 0.05490),
                (0.00000, 0.00000, 0.06275),
                (0.00000, 0.00000, 0.07059),
                (0.00000, 0.00000, 0.07843),
                (0.00000, 0.00000, 0.08627),
                (0.00000, 0.00000, 0.09804),
                (0.00000, 0.00000, 0.10588),
                (0.00000, 0.00000, 0.11373),
                (0.00000, 0.00000, 0.12157),
                (0.00000, 0.00000, 0.12941),
                (0.00000, 0.00000, 0.13725),
                (0.00000, 0.00000, 0.14510),
                (0.00000, 0.00000, 0.15294),
                (0.00000, 0.00000, 0.16078),
                (0.00000, 0.00000, 0.16863),
                (0.00000, 0.00000, 0.17647),
                (0.00000, 0.00000, 0.18431),
                (0.00000, 0.00000, 0.19608),
                (0.00000, 0.00000, 0.20392),
                (0.00000, 0.00000, 0.21176),
                (0.00000, 0.00000, 0.21961),
                (0.00000, 0.00000, 0.22745),
                (0.00000, 0.00000, 0.23529),
                (0.00000, 0.00000, 0.24314),
                (0.00000, 0.00000, 0.25098),
                (0.00000, 0.00000, 0.25882),
                (0.00000, 0.01176, 0.26667),
                (0.00000, 0.02353, 0.27451),
                (0.00000, 0.03529, 0.28235),
                (0.00000, 0.04706, 0.29412),
                (0.00000, 0.05882, 0.30196),
                (0.00000, 0.07059, 0.30980),
                (0.00000, 0.08235, 0.31765),
                (0.00000, 0.09804, 0.32549),
                (0.00000, 0.10980, 0.33333),
                (0.00000, 0.12157, 0.34118),
                (0.00000, 0.13333, 0.34902),
                (0.00000, 0.14510, 0.35686),
                (0.00000, 0.15686, 0.36471),
                (0.00000, 0.16863, 0.37255),
                (0.00000, 0.18039, 0.38039),
                (0.00000, 0.19608, 0.39216),
                (0.00000, 0.20784, 0.39216),
                (0.00000, 0.21961, 0.39216),
                (0.00000, 0.23137, 0.39216),
                (0.00000, 0.24314, 0.39216),
                (0.00000, 0.25490, 0.39216),
                (0.00000, 0.26667, 0.39216),
                (0.00000, 0.27843, 0.39216),
                (0.00000, 0.29412, 0.39216),
                (0.00000, 0.30588, 0.39216),
                (0.00000, 0.31765, 0.39216),
                (0.00000, 0.32941, 0.39216),
                (0.00000, 0.34118, 0.39216),
                (0.00000, 0.35294, 0.39216),
                (0.00000, 0.36471, 0.39216),
                (0.00000, 0.37647, 0.39216),
                (0.00000, 0.39216, 0.39216),
                (0.00000, 0.40392, 0.39216),
                (0.00000, 0.41569, 0.39216),
                (0.00000, 0.42745, 0.39216),
                (0.00000, 0.43922, 0.39216),
                (0.00000, 0.45098, 0.39216),
                (0.00000, 0.46275, 0.39216),
                (0.00000, 0.47451, 0.39216),
                (0.00000, 0.49020, 0.39216),
                (0.00000, 0.50196, 0.39216),
                (0.00000, 0.51373, 0.39216),
                (0.00000, 0.52549, 0.39216),
                (0.00000, 0.53725, 0.39216),
                (0.00000, 0.54902, 0.39216),
                (0.00000, 0.56078, 0.39216),
                (0.00000, 0.57255, 0.39216),
                (0.00000, 0.58824, 0.39216),
                (0.00000, 0.58824, 0.37647),
                (0.00000, 0.58824, 0.36471),
                (0.00000, 0.58824, 0.35294),
                (0.00000, 0.58824, 0.34118),
                (0.00000, 0.58824, 0.32941),
                (0.00000, 0.58824, 0.31765),
                (0.00000, 0.58824, 0.30588),
                (0.00000, 0.58824, 0.29412),
                (0.00000, 0.58824, 0.27843),
                (0.00000, 0.58824, 0.26667),
                (0.00000, 0.58824, 0.25490),
                (0.00000, 0.58824, 0.24314),
                (0.00000, 0.58824, 0.23137),
                (0.00000, 0.58824, 0.21961),
                (0.00000, 0.58824, 0.20784),
                (0.00000, 0.58824, 0.19608),
                (0.00000, 0.58431, 0.18039),
                (0.00000, 0.58039, 0.16863),
                (0.00000, 0.58039, 0.15686),
                (0.00000, 0.57647, 0.14510),
                (0.00000, 0.57255, 0.13333),
                (0.00000, 0.57255, 0.12157),
                (0.00000, 0.56863, 0.10980),
                (0.00000, 0.56863, 0.09804),
                (0.00000, 0.56471, 0.08235),
                (0.00000, 0.56078, 0.07059),
                (0.00000, 0.56078, 0.05882),
                (0.00000, 0.55686, 0.04706),
                (0.00000, 0.55294, 0.03529),
                (0.00000, 0.55294, 0.02353),
                (0.00000, 0.54902, 0.01176),
                (0.00000, 0.54902, 0.00000),
                (0.02745, 0.53725, 0.00000),
                (0.05882, 0.52941, 0.00000),
                (0.08627, 0.51765, 0.00000),
                (0.11765, 0.50980, 0.00000),
                (0.14510, 0.49804, 0.00000),
                (0.17647, 0.49020, 0.00000),
                (0.20392, 0.47843, 0.00000),
                (0.23529, 0.47059, 0.00000),
                (0.26275, 0.45882, 0.00000),
                (0.29412, 0.45098, 0.00000),
                (0.32157, 0.43922, 0.00000),
                (0.35294, 0.43137, 0.00000),
                (0.38039, 0.41961, 0.00000),
                (0.41176, 0.41176, 0.00000),
                (0.43922, 0.40000, 0.00000),
                (0.47059, 0.39216, 0.00000),
                (0.49020, 0.36471, 0.00000),
                (0.50980, 0.34118, 0.00000),
                (0.52941, 0.31765, 0.00000),
                (0.54902, 0.29412, 0.00000),
                (0.56863, 0.26667, 0.00000),
                (0.58824, 0.24314, 0.00000),
                (0.60784, 0.21961, 0.00000),
                (0.62745, 0.19608, 0.00000),
                (0.64706, 0.16863, 0.00000),
                (0.66667, 0.14510, 0.00000),
                (0.68627, 0.12157, 0.00000),
                (0.70588, 0.09804, 0.00000),
                (0.72549, 0.07059, 0.00000),
                (0.74510, 0.04706, 0.00000),
                (0.76471, 0.02353, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00784, 0.00000),
                (0.78824, 0.01569, 0.00000),
                (0.78824, 0.02353, 0.00000),
                (0.79216, 0.03529, 0.00000),
                (0.79216, 0.04314, 0.00000),
                (0.79608, 0.05098, 0.00000),
                (0.79608, 0.06275, 0.00000),
                (0.80000, 0.07059, 0.00000),
                (0.80000, 0.07843, 0.00000),
                (0.80392, 0.09020, 0.00000),
                (0.80392, 0.09804, 0.00000),
                (0.80784, 0.10588, 0.00000),
                (0.80784, 0.11373, 0.00000),
                (0.81176, 0.12549, 0.00000),
                (0.81176, 0.13333, 0.00000),
                (0.81569, 0.14118, 0.00000),
                (0.81569, 0.15294, 0.00000),
                (0.81961, 0.16078, 0.00000),
                (0.81961, 0.16863, 0.00000),
                (0.82353, 0.18039, 0.00000),
                (0.82353, 0.18824, 0.00000),
                (0.82745, 0.19608, 0.00000),
                (0.82745, 0.20784, 0.00000),
                (0.83137, 0.21569, 0.00000),
                (0.83137, 0.22353, 0.00000),
                (0.83529, 0.23137, 0.00000),
                (0.83529, 0.24314, 0.00000),
                (0.83922, 0.25098, 0.00000),
                (0.83922, 0.25882, 0.00000),
                (0.84314, 0.27059, 0.00000),
                (0.84314, 0.27843, 0.00000),
                (0.84706, 0.28627, 0.00000),
                (0.84706, 0.29804, 0.00000),
                (0.85098, 0.30588, 0.00000),
                (0.85098, 0.31373, 0.00000),
                (0.85490, 0.32549, 0.00000),
                (0.85490, 0.33333, 0.00000),
                (0.85882, 0.34118, 0.00000),
                (0.85882, 0.34902, 0.00000),
                (0.86275, 0.36078, 0.00000),
                (0.86275, 0.36863, 0.00000),
                (0.86667, 0.37647, 0.00000),
                (0.86667, 0.38824, 0.00000),
                (0.87059, 0.39608, 0.00000),
                (0.87059, 0.40392, 0.00000),
                (0.87451, 0.41569, 0.00000),
                (0.87451, 0.42353, 0.00000),
                (0.87843, 0.43137, 0.00000),
                (0.87843, 0.44314, 0.00000),
                (0.88235, 0.45098, 0.00000),
                (0.88235, 0.45882, 0.00000),
                (0.88627, 0.46667, 0.00000),
                (0.88627, 0.47843, 0.00000),
                (0.89020, 0.48627, 0.00000),
                (0.89020, 0.49412, 0.00000),
                (0.89412, 0.50588, 0.00000),
                (0.89412, 0.51373, 0.00000),
                (0.89804, 0.52157, 0.00000),
                (0.89804, 0.53333, 0.00000),
                (0.90196, 0.54118, 0.00000),
                (0.90196, 0.54902, 0.00000),
                (0.90588, 0.55686, 0.00000),
                (0.90588, 0.56863, 0.00000),
                (0.90980, 0.57647, 0.00000),
                (0.90980, 0.58431, 0.00000),
                (0.91373, 0.59608, 0.00000),
                (0.91373, 0.60392, 0.00000),
                (0.91765, 0.61176, 0.00000),
                (0.91765, 0.62353, 0.00000),
                (0.92157, 0.63137, 0.00000),
                (0.92157, 0.63922, 0.00000),
                (0.92549, 0.65098, 0.00000),
                (0.92549, 0.65882, 0.00000),
                (0.92941, 0.66667, 0.00000),
                (0.92941, 0.67451, 0.00000),
                (0.93333, 0.68627, 0.00000),
                (0.93333, 0.69412, 0.00000),
                (0.93725, 0.70196, 0.00000),
                (0.93725, 0.71373, 0.00000),
                (0.94118, 0.72157, 0.00000),
                (0.94118, 0.72941, 0.00000),
                (0.94510, 0.74118, 0.00000),
                (0.94510, 0.74902, 0.00000),
                (0.94902, 0.75686, 0.00000),
                (0.94902, 0.76863, 0.00000),
                (0.95294, 0.77647, 0.00000),
                (0.95294, 0.78431, 0.00000),
                (0.95686, 0.79216, 0.00000),
                (0.95686, 0.80392, 0.00000),
                (0.96078, 0.81176, 0.00000),
                (0.96078, 0.81961, 0.00000),
                (0.96471, 0.83137, 0.00000),
                (0.96471, 0.83922, 0.00000),
                (0.96863, 0.84706, 0.00000),
                (0.96863, 0.85882, 0.00000),
                (0.97255, 0.86667, 0.00000),
                (0.97255, 0.87451, 0.00000),
                (0.97647, 0.88627, 0.00000),
                (0.97647, 0.89412, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90980, 0.00000),
                (0.98431, 0.92157, 0.00000),
                (0.98431, 0.92941, 0.00000),
                (0.98824, 0.93725, 0.00000),
                (0.98824, 0.94902, 0.00000),
                (0.99216, 0.95686, 0.00000),
                (0.99216, 0.96471, 0.00000),
                (0.99608, 0.97647, 0.00000),
                (0.99608, 0.98431, 0.00000),
                (1.00000, 0.99216, 0.00000),
                (1.00000, 1.00000, 0.00000),
        )

cmap_idl5 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.01961),
                (0.00000, 0.00000, 0.03922),
                (0.00000, 0.00000, 0.05882),
                (0.00000, 0.00000, 0.07843),
                (0.00000, 0.00000, 0.10196),
                (0.00000, 0.00000, 0.12157),
                (0.00000, 0.00000, 0.14118),
                (0.00000, 0.00000, 0.16078),
                (0.00000, 0.00000, 0.18039),
                (0.00000, 0.00000, 0.20392),
                (0.00000, 0.00000, 0.22353),
                (0.00000, 0.00000, 0.24314),
                (0.00000, 0.00000, 0.26275),
                (0.00000, 0.00000, 0.28235),
                (0.00000, 0.00000, 0.30588),
                (0.00000, 0.00000, 0.32549),
                (0.00000, 0.00000, 0.34510),
                (0.00000, 0.00000, 0.36471),
                (0.00000, 0.00000, 0.38431),
                (0.00000, 0.00000, 0.40784),
                (0.00000, 0.00000, 0.42745),
                (0.00000, 0.00000, 0.44706),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.48627),
                (0.00000, 0.00000, 0.50980),
                (0.00000, 0.00000, 0.52941),
                (0.00000, 0.00000, 0.54902),
                (0.00000, 0.00000, 0.56863),
                (0.00000, 0.00000, 0.58824),
                (0.00000, 0.00000, 0.61176),
                (0.00000, 0.00000, 0.63137),
                (0.00000, 0.00000, 0.65098),
                (0.00000, 0.00000, 0.67059),
                (0.00000, 0.00000, 0.69020),
                (0.00000, 0.00000, 0.71373),
                (0.00000, 0.00000, 0.73333),
                (0.00000, 0.00000, 0.75294),
                (0.00000, 0.00000, 0.77255),
                (0.00000, 0.00000, 0.79216),
                (0.00000, 0.00000, 0.81569),
                (0.00000, 0.00000, 0.83529),
                (0.00000, 0.00000, 0.85490),
                (0.00000, 0.00000, 0.87451),
                (0.00000, 0.00000, 0.89412),
                (0.00000, 0.00000, 0.91765),
                (0.00000, 0.00000, 0.93725),
                (0.00000, 0.00000, 0.95686),
                (0.01569, 0.00000, 0.97647),
                (0.03529, 0.00000, 1.00000),
                (0.05490, 0.00000, 0.98039),
                (0.07451, 0.00000, 0.96078),
                (0.09020, 0.00000, 0.93725),
                (0.10980, 0.00000, 0.91765),
                (0.12941, 0.00000, 0.89412),
                (0.14902, 0.00000, 0.87451),
                (0.16471, 0.00000, 0.85490),
                (0.18431, 0.00000, 0.83137),
                (0.20392, 0.00000, 0.81176),
                (0.22353, 0.00000, 0.78824),
                (0.23922, 0.00000, 0.76863),
                (0.25882, 0.00000, 0.74510),
                (0.27843, 0.00000, 0.72549),
                (0.29804, 0.00000, 0.70588),
                (0.31765, 0.00000, 0.68235),
                (0.31765, 0.00000, 0.66275),
                (0.31765, 0.00000, 0.63922),
                (0.31765, 0.00000, 0.61961),
                (0.31765, 0.00000, 0.59608),
                (0.31765, 0.00000, 0.57647),
                (0.31765, 0.00000, 0.55686),
                (0.31765, 0.00000, 0.53333),
                (0.31373, 0.00000, 0.51373),
                (0.31373, 0.00000, 0.49020),
                (0.31373, 0.00000, 0.47059),
                (0.31373, 0.00000, 0.44706),
                (0.31373, 0.00000, 0.42745),
                (0.31373, 0.00000, 0.40784),
                (0.31373, 0.00000, 0.38431),
                (0.30980, 0.00000, 0.36471),
                (0.32941, 0.00000, 0.34118),
                (0.34902, 0.00000, 0.32157),
                (0.36863, 0.00000, 0.29804),
                (0.38824, 0.00000, 0.27843),
                (0.40784, 0.00000, 0.25882),
                (0.42745, 0.00000, 0.23529),
                (0.44706, 0.00000, 0.21569),
                (0.46667, 0.00000, 0.19216),
                (0.48627, 0.00000, 0.17255),
                (0.50588, 0.00000, 0.14902),
                (0.52549, 0.00000, 0.12941),
                (0.54510, 0.00000, 0.10980),
                (0.56471, 0.00000, 0.08627),
                (0.58431, 0.00000, 0.06667),
                (0.60392, 0.00000, 0.04314),
                (0.62353, 0.00000, 0.02353),
                (0.64314, 0.00000, 0.00000),
                (0.66275, 0.00000, 0.00000),
                (0.68235, 0.00000, 0.00000),
                (0.70588, 0.00000, 0.00000),
                (0.72549, 0.00000, 0.00000),
                (0.74510, 0.00000, 0.00000),
                (0.76863, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.80784, 0.00000, 0.00000),
                (0.83137, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.87059, 0.00000, 0.00000),
                (0.89412, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.01961, 0.00000),
                (1.00000, 0.03922, 0.00000),
                (1.00000, 0.06275, 0.00000),
                (1.00000, 0.08235, 0.00000),
                (1.00000, 0.10588, 0.00000),
                (1.00000, 0.12549, 0.00000),
                (1.00000, 0.14510, 0.00000),
                (1.00000, 0.16863, 0.00000),
                (1.00000, 0.18824, 0.00000),
                (1.00000, 0.21176, 0.00000),
                (1.00000, 0.23137, 0.00000),
                (1.00000, 0.25098, 0.00000),
                (1.00000, 0.27451, 0.00000),
                (1.00000, 0.29412, 0.00000),
                (1.00000, 0.31765, 0.00000),
                (1.00000, 0.33333, 0.01569),
                (1.00000, 0.35294, 0.03529),
                (1.00000, 0.37255, 0.05490),
                (1.00000, 0.39216, 0.07451),
                (1.00000, 0.41176, 0.09412),
                (1.00000, 0.42745, 0.10980),
                (1.00000, 0.44706, 0.12941),
                (1.00000, 0.46667, 0.14902),
                (1.00000, 0.48627, 0.16863),
                (1.00000, 0.50588, 0.18824),
                (1.00000, 0.52549, 0.20784),
                (1.00000, 0.54118, 0.22353),
                (1.00000, 0.56078, 0.24314),
                (1.00000, 0.58039, 0.26275),
                (1.00000, 0.60000, 0.28235),
                (1.00000, 0.61961, 0.30196),
                (1.00000, 0.63922, 0.32157),
                (1.00000, 0.63922, 0.30196),
                (1.00000, 0.63922, 0.27843),
                (1.00000, 0.63922, 0.25490),
                (1.00000, 0.63922, 0.23137),
                (1.00000, 0.63922, 0.20784),
                (1.00000, 0.63922, 0.18431),
                (1.00000, 0.63922, 0.16078),
                (1.00000, 0.63922, 0.14118),
                (1.00000, 0.63922, 0.11765),
                (1.00000, 0.63922, 0.09412),
                (1.00000, 0.63922, 0.07059),
                (1.00000, 0.63922, 0.04706),
                (1.00000, 0.63922, 0.02353),
                (1.00000, 0.63922, 0.00000),
                (1.00000, 0.63922, 0.00000),
                (1.00000, 0.63922, 0.00000),
                (1.00000, 0.63922, 0.00000),
                (0.97255, 0.63922, 0.00000),
                (0.94118, 0.63922, 0.00000),
                (0.90980, 0.63922, 0.00000),
                (0.88235, 0.63922, 0.00000),
                (0.85098, 0.63922, 0.00000),
                (0.81961, 0.63922, 0.00000),
                (0.79216, 0.63922, 0.00000),
                (0.76078, 0.63922, 0.00000),
                (0.72941, 0.63922, 0.00000),
                (0.70196, 0.63922, 0.00000),
                (0.67059, 0.63922, 0.00000),
                (0.63922, 0.63922, 0.00000),
                (0.65882, 0.63922, 0.00000),
                (0.67843, 0.63922, 0.00000),
                (0.69804, 0.66275, 0.01176),
                (0.71765, 0.68627, 0.02353),
                (0.73725, 0.70980, 0.03529),
                (0.75686, 0.73333, 0.04706),
                (0.77647, 0.75686, 0.06275),
                (0.79608, 0.78039, 0.07451),
                (0.81961, 0.80392, 0.08627),
                (0.83922, 0.83137, 0.09804),
                (0.85882, 0.85490, 0.11373),
                (0.87843, 0.87843, 0.12549),
                (0.89804, 0.90196, 0.13725),
                (0.91765, 0.92549, 0.14902),
                (0.93725, 0.94902, 0.16078),
                (0.95686, 0.97255, 0.17647),
                (0.97647, 1.00000, 0.18824),
                (1.00000, 1.00000, 0.20000),
                (1.00000, 1.00000, 0.21176),
                (1.00000, 1.00000, 0.22745),
                (1.00000, 1.00000, 0.23922),
                (1.00000, 1.00000, 0.25098),
                (1.00000, 1.00000, 0.26275),
                (1.00000, 1.00000, 0.27843),
                (1.00000, 1.00000, 0.29020),
                (1.00000, 1.00000, 0.30196),
                (1.00000, 1.00000, 0.31373),
                (1.00000, 1.00000, 0.32549),
                (1.00000, 1.00000, 0.34118),
                (1.00000, 1.00000, 0.35294),
                (1.00000, 1.00000, 0.36471),
                (1.00000, 1.00000, 0.37647),
                (1.00000, 1.00000, 0.39216),
                (1.00000, 1.00000, 0.40392),
                (1.00000, 1.00000, 0.41569),
                (1.00000, 1.00000, 0.42745),
                (1.00000, 1.00000, 0.43922),
                (1.00000, 1.00000, 0.45490),
                (1.00000, 1.00000, 0.46667),
                (1.00000, 1.00000, 0.47843),
                (1.00000, 1.00000, 0.49020),
                (1.00000, 1.00000, 0.50588),
                (1.00000, 1.00000, 0.51765),
                (1.00000, 1.00000, 0.52941),
                (1.00000, 1.00000, 0.54118),
                (1.00000, 1.00000, 0.55686),
                (1.00000, 1.00000, 0.56863),
                (1.00000, 1.00000, 0.58039),
                (1.00000, 1.00000, 0.59216),
                (1.00000, 1.00000, 0.60392),
                (1.00000, 1.00000, 0.61961),
                (1.00000, 1.00000, 0.63137),
                (1.00000, 1.00000, 0.64314),
                (1.00000, 1.00000, 0.65490),
                (1.00000, 1.00000, 0.67059),
                (1.00000, 1.00000, 0.68235),
                (1.00000, 1.00000, 0.69412),
                (1.00000, 1.00000, 0.70588),
                (1.00000, 1.00000, 0.71765),
                (1.00000, 1.00000, 0.73333),
                (1.00000, 1.00000, 0.74510),
                (1.00000, 1.00000, 0.75686),
                (1.00000, 1.00000, 0.76863),
                (1.00000, 1.00000, 0.78431),
                (1.00000, 1.00000, 0.79608),
                (1.00000, 1.00000, 0.80784),
                (1.00000, 1.00000, 0.81961),
                (1.00000, 1.00000, 0.83529),
                (1.00000, 1.00000, 0.84706),
                (1.00000, 1.00000, 0.85882),
                (1.00000, 1.00000, 0.87059),
                (1.00000, 1.00000, 0.88235),
                (1.00000, 1.00000, 0.89804),
                (1.00000, 1.00000, 0.90980),
                (1.00000, 1.00000, 0.92157),
                (1.00000, 1.00000, 0.93333),
                (1.00000, 1.00000, 0.94902),
                (1.00000, 1.00000, 0.96078),
                (1.00000, 1.00000, 0.97255),
                (1.00000, 1.00000, 0.98431),
                (1.00000, 1.00000, 1.00000),
        )

cmap_idl6 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.01176, 0.00000, 0.00000),
                (0.02745, 0.00000, 0.00000),
                (0.04314, 0.00000, 0.00000),
                (0.05882, 0.00000, 0.00000),
                (0.07451, 0.00000, 0.00000),
                (0.08627, 0.00000, 0.00000),
                (0.10196, 0.00000, 0.00000),
                (0.11765, 0.00000, 0.00000),
                (0.13333, 0.00000, 0.00000),
                (0.14902, 0.00000, 0.00000),
                (0.16078, 0.00000, 0.00000),
                (0.17647, 0.00000, 0.00000),
                (0.19216, 0.00000, 0.00000),
                (0.20784, 0.00000, 0.00000),
                (0.22353, 0.00000, 0.00000),
                (0.23529, 0.00000, 0.00000),
                (0.25098, 0.00000, 0.00000),
                (0.26667, 0.00000, 0.00000),
                (0.28235, 0.00000, 0.00000),
                (0.29804, 0.00000, 0.00000),
                (0.30980, 0.00000, 0.00000),
                (0.32549, 0.00000, 0.00000),
                (0.34118, 0.00000, 0.00000),
                (0.35686, 0.00000, 0.00000),
                (0.37255, 0.00000, 0.00000),
                (0.38431, 0.00000, 0.00000),
                (0.40000, 0.00000, 0.00000),
                (0.41569, 0.00000, 0.00000),
                (0.43137, 0.00000, 0.00000),
                (0.44706, 0.00000, 0.00000),
                (0.45882, 0.00000, 0.00000),
                (0.47451, 0.00000, 0.00000),
                (0.49020, 0.00000, 0.00000),
                (0.50588, 0.00000, 0.00000),
                (0.52157, 0.00000, 0.00000),
                (0.53725, 0.00000, 0.00000),
                (0.54902, 0.00000, 0.00000),
                (0.56471, 0.00000, 0.00000),
                (0.58039, 0.00000, 0.00000),
                (0.59608, 0.00000, 0.00000),
                (0.61176, 0.00000, 0.00000),
                (0.62353, 0.00000, 0.00000),
                (0.63922, 0.00000, 0.00000),
                (0.65490, 0.00000, 0.00000),
                (0.67059, 0.00000, 0.00000),
                (0.68627, 0.00000, 0.00000),
                (0.69804, 0.00000, 0.00000),
                (0.71373, 0.00000, 0.00000),
                (0.72941, 0.00000, 0.00000),
                (0.74510, 0.00000, 0.00000),
                (0.76078, 0.00000, 0.00000),
                (0.77255, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.80392, 0.00000, 0.00000),
                (0.81961, 0.00000, 0.00000),
                (0.83529, 0.00000, 0.00000),
                (0.84706, 0.00000, 0.00000),
                (0.86275, 0.00000, 0.00000),
                (0.87843, 0.00000, 0.00000),
                (0.89412, 0.00000, 0.00000),
                (0.90980, 0.00000, 0.00000),
                (0.92157, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.95294, 0.00000, 0.00000),
                (0.96863, 0.01176, 0.00000),
                (0.98431, 0.02745, 0.00000),
                (1.00000, 0.04314, 0.00000),
                (0.98431, 0.05882, 0.00000),
                (0.96863, 0.07451, 0.00000),
                (0.95294, 0.09020, 0.00000),
                (0.93725, 0.10588, 0.00000),
                (0.92157, 0.12157, 0.00000),
                (0.90196, 0.13725, 0.00000),
                (0.88627, 0.15294, 0.00000),
                (0.87059, 0.16863, 0.00000),
                (0.85490, 0.18431, 0.00000),
                (0.83922, 0.20000, 0.00000),
                (0.82353, 0.21569, 0.00000),
                (0.80392, 0.23137, 0.00000),
                (0.78824, 0.24706, 0.00000),
                (0.77255, 0.26275, 0.00000),
                (0.75686, 0.27843, 0.00000),
                (0.74118, 0.29412, 0.00000),
                (0.72157, 0.30980, 0.00000),
                (0.70588, 0.32549, 0.00000),
                (0.69020, 0.34118, 0.00000),
                (0.67451, 0.35686, 0.00000),
                (0.65882, 0.37255, 0.00000),
                (0.64314, 0.38824, 0.00000),
                (0.62353, 0.40392, 0.00000),
                (0.60784, 0.41961, 0.00000),
                (0.59216, 0.43529, 0.00000),
                (0.57647, 0.45098, 0.00000),
                (0.56078, 0.46667, 0.00000),
                (0.54118, 0.48235, 0.00000),
                (0.52549, 0.49804, 0.00000),
                (0.50980, 0.51373, 0.00000),
                (0.49412, 0.52941, 0.00000),
                (0.47843, 0.54510, 0.00000),
                (0.46275, 0.56078, 0.00000),
                (0.44314, 0.57647, 0.00000),
                (0.42745, 0.59216, 0.00000),
                (0.41176, 0.60784, 0.00000),
                (0.39608, 0.62353, 0.00000),
                (0.38039, 0.63922, 0.00000),
                (0.36078, 0.65490, 0.00000),
                (0.34510, 0.67059, 0.00000),
                (0.32941, 0.68627, 0.00000),
                (0.31373, 0.70196, 0.00000),
                (0.29804, 0.71765, 0.00000),
                (0.28235, 0.73333, 0.00000),
                (0.26275, 0.74902, 0.00000),
                (0.24706, 0.76471, 0.00000),
                (0.23137, 0.78039, 0.00000),
                (0.21569, 0.79608, 0.00000),
                (0.20000, 0.81176, 0.00000),
                (0.18039, 0.82745, 0.00000),
                (0.16471, 0.84314, 0.00000),
                (0.14902, 0.85882, 0.00000),
                (0.13333, 0.87451, 0.00000),
                (0.11765, 0.89020, 0.00000),
                (0.10196, 0.90588, 0.00000),
                (0.08235, 0.92157, 0.00000),
                (0.06667, 0.93725, 0.00000),
                (0.05098, 0.95294, 0.00000),
                (0.03529, 0.96863, 0.00000),
                (0.01961, 0.98431, 0.01176),
                (0.00000, 1.00000, 0.02745),
                (0.00000, 0.98431, 0.04314),
                (0.00000, 0.96863, 0.05882),
                (0.00000, 0.95294, 0.07451),
                (0.00000, 0.93725, 0.09020),
                (0.00000, 0.92157, 0.10588),
                (0.00000, 0.90588, 0.11765),
                (0.00000, 0.89020, 0.13333),
                (0.00000, 0.87451, 0.14902),
                (0.00000, 0.85882, 0.16471),
                (0.00000, 0.84314, 0.18039),
                (0.00000, 0.82745, 0.19608),
                (0.00000, 0.81176, 0.21176),
                (0.00000, 0.79608, 0.22353),
                (0.00000, 0.78039, 0.23922),
                (0.00000, 0.76471, 0.25490),
                (0.00000, 0.74902, 0.27059),
                (0.00000, 0.73333, 0.28627),
                (0.00000, 0.71765, 0.30196),
                (0.00000, 0.70196, 0.31765),
                (0.00000, 0.68627, 0.33333),
                (0.00000, 0.66667, 0.34510),
                (0.00000, 0.65098, 0.36078),
                (0.00000, 0.63529, 0.37647),
                (0.00000, 0.61961, 0.39216),
                (0.00000, 0.60392, 0.40784),
                (0.00000, 0.58824, 0.42353),
                (0.00000, 0.57255, 0.43922),
                (0.00000, 0.55686, 0.45098),
                (0.00000, 0.54118, 0.46667),
                (0.00000, 0.52549, 0.48235),
                (0.00000, 0.50980, 0.49804),
                (0.00000, 0.49412, 0.51373),
                (0.00000, 0.47843, 0.52941),
                (0.00000, 0.46275, 0.54510),
                (0.00000, 0.44706, 0.55686),
                (0.00000, 0.43137, 0.57255),
                (0.00000, 0.41569, 0.58824),
                (0.00000, 0.40000, 0.60392),
                (0.00000, 0.38431, 0.61961),
                (0.00000, 0.36863, 0.63529),
                (0.00000, 0.35294, 0.65098),
                (0.00000, 0.33333, 0.66667),
                (0.00000, 0.31765, 0.67843),
                (0.00000, 0.30196, 0.69412),
                (0.00000, 0.28627, 0.70980),
                (0.00000, 0.27059, 0.72549),
                (0.00000, 0.25490, 0.74118),
                (0.00000, 0.23922, 0.75686),
                (0.00000, 0.22353, 0.77255),
                (0.00000, 0.20784, 0.78431),
                (0.00000, 0.19216, 0.80000),
                (0.00000, 0.17647, 0.81569),
                (0.00000, 0.16078, 0.83137),
                (0.00000, 0.14510, 0.84706),
                (0.00000, 0.12941, 0.86275),
                (0.00000, 0.11373, 0.87843),
                (0.00000, 0.09804, 0.89020),
                (0.00000, 0.08235, 0.90588),
                (0.00000, 0.06667, 0.92157),
                (0.00000, 0.05098, 0.93725),
                (0.00000, 0.03529, 0.95294),
                (0.00000, 0.01961, 0.96863),
                (0.00000, 0.00000, 0.98431),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 0.98431),
                (0.00000, 0.00000, 0.96863),
                (0.00000, 0.00000, 0.95294),
                (0.00000, 0.00000, 0.93725),
                (0.00000, 0.00000, 0.92157),
                (0.00000, 0.00000, 0.90588),
                (0.00000, 0.00000, 0.89020),
                (0.00000, 0.00000, 0.87451),
                (0.00000, 0.00000, 0.85882),
                (0.00000, 0.00000, 0.84314),
                (0.00000, 0.00000, 0.82745),
                (0.00000, 0.00000, 0.81176),
                (0.00000, 0.00000, 0.79608),
                (0.00000, 0.00000, 0.78039),
                (0.00000, 0.00000, 0.76471),
                (0.00000, 0.00000, 0.74902),
                (0.00000, 0.00000, 0.73333),
                (0.00000, 0.00000, 0.71765),
                (0.00000, 0.00000, 0.70196),
                (0.00000, 0.00000, 0.68627),
                (0.00000, 0.00000, 0.66667),
                (0.00000, 0.00000, 0.65098),
                (0.00000, 0.00000, 0.63529),
                (0.00000, 0.00000, 0.61961),
                (0.00000, 0.00000, 0.60392),
                (0.00000, 0.00000, 0.58824),
                (0.00000, 0.00000, 0.57255),
                (0.00000, 0.00000, 0.55686),
                (0.00000, 0.00000, 0.54118),
                (0.00000, 0.00000, 0.52549),
                (0.00000, 0.00000, 0.50980),
                (0.00000, 0.00000, 0.49412),
                (0.00000, 0.00000, 0.47843),
                (0.00000, 0.00000, 0.46275),
                (0.00000, 0.00000, 0.44706),
                (0.00000, 0.00000, 0.43137),
                (0.00000, 0.00000, 0.41569),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.38431),
                (0.00000, 0.00000, 0.36863),
                (0.00000, 0.00000, 0.35294),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.31765),
                (0.00000, 0.00000, 0.30196),
                (0.00000, 0.00000, 0.28627),
                (0.00000, 0.00000, 0.27059),
                (0.00000, 0.00000, 0.25490),
                (0.00000, 0.00000, 0.23922),
                (0.00000, 0.00000, 0.22353),
                (0.00000, 0.00000, 0.20784),
                (0.00000, 0.00000, 0.19216),
                (0.00000, 0.00000, 0.17647),
                (0.00000, 0.00000, 0.16078),
                (0.00000, 0.00000, 0.14510),
                (0.00000, 0.00000, 0.12941),
                (0.00000, 0.00000, 0.11373),
                (0.00000, 0.00000, 0.09804),
                (0.00000, 0.00000, 0.08235),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.05098),
                (0.00000, 0.00000, 0.03529),
                (0.00000, 0.00000, 0.01961),
                (0.00000, 0.00000, 0.00000),
        )

cmap_smooth1 = (
                (0.30980, 0.29020, 0.22353),  # noqa
                (0.32157, 0.30196, 0.23922),
                (0.33333, 0.31765, 0.25490),
                (0.34510, 0.32941, 0.27059),
                (0.35686, 0.34510, 0.29020),
                (0.36863, 0.36078, 0.30588),
                (0.38039, 0.37647, 0.32549),
                (0.39216, 0.38824, 0.34510),
                (0.40392, 0.40392, 0.36471),
                (0.41569, 0.41961, 0.38431),
                (0.42745, 0.43529, 0.40392),
                (0.43922, 0.45098, 0.42353),
                (0.45098, 0.46667, 0.44314),
                (0.46275, 0.48235, 0.46667),
                (0.47451, 0.49804, 0.48627),
                (0.49020, 0.51765, 0.50980),
                (0.50196, 0.53333, 0.53333),
                (0.51373, 0.54902, 0.55686),
                (0.52549, 0.56863, 0.58039),
                (0.54118, 0.58431, 0.60392),
                (0.55294, 0.60000, 0.62745),
                (0.56863, 0.61961, 0.65098),
                (0.58039, 0.63529, 0.67843),
                (0.59216, 0.65490, 0.70196),
                (0.60784, 0.67059, 0.72941),
                (0.61961, 0.69020, 0.75686),
                (0.63529, 0.70980, 0.78431),
                (0.64706, 0.72549, 0.75686),
                (0.66275, 0.74510, 0.72941),
                (0.67843, 0.76471, 0.70588),
                (0.69020, 0.78431, 0.68235),
                (0.70588, 0.80392, 0.65882),
                (0.71765, 0.82353, 0.64314),
                (0.73333, 0.80392, 0.62353),
                (0.74902, 0.78824, 0.60392),
                (0.76471, 0.77255, 0.58824),
                (0.77647, 0.75686, 0.57255),
                (0.79216, 0.74118, 0.55686),
                (0.80784, 0.73333, 0.54118),
                (0.82353, 0.71765, 0.52941),
                (0.83922, 0.70588, 0.51373),
                (0.85490, 0.69804, 0.50588),
                (0.87059, 0.68235, 0.49412),
                (0.85490, 0.67451, 0.48627),
                (0.83922, 0.66667, 0.47843),
                (0.82745, 0.65882, 0.47059),
                (0.81569, 0.65098, 0.46275),
                (0.80392, 0.63922, 0.45882),
                (0.79216, 0.63529, 0.45490),
                (0.78431, 0.62745, 0.45098),
                (0.77255, 0.61961, 0.44706),
                (0.76078, 0.61176, 0.44706),
                (0.74902, 0.60784, 0.44706),
                (0.74510, 0.60392, 0.44706),
                (0.73333, 0.60000, 0.44706),
                (0.72941, 0.59608, 0.45098),
                (0.71765, 0.59216, 0.45490),
                (0.70980, 0.58824, 0.45882),
                (0.70588, 0.58824, 0.46275),
                (0.69412, 0.58431, 0.47059),
                (0.69020, 0.58039, 0.47843),
                (0.68235, 0.58039, 0.48627),
                (0.67843, 0.58039, 0.49412),
                (0.67451, 0.57647, 0.50588),
                (0.66667, 0.58039, 0.51373),
                (0.66275, 0.57647, 0.52941),
                (0.65490, 0.58039, 0.54118),
                (0.65098, 0.58039, 0.55686),
                (0.64706, 0.58039, 0.57255),
                (0.64314, 0.58431, 0.58824),
                (0.63529, 0.58824, 0.60392),
                (0.63529, 0.58824, 0.62353),
                (0.63137, 0.59216, 0.64314),
                (0.62745, 0.59608, 0.65882),
                (0.62745, 0.60000, 0.68235),
                (0.62353, 0.60392, 0.70588),
                (0.62353, 0.60784, 0.72941),
                (0.61961, 0.61176, 0.75686),
                (0.61961, 0.61961, 0.78431),
                (0.61569, 0.62745, 0.75686),
                (0.61569, 0.63529, 0.72941),
                (0.61176, 0.63922, 0.70588),
                (0.61176, 0.65098, 0.68235),
                (0.61176, 0.65882, 0.65882),
                (0.61176, 0.66667, 0.64314),
                (0.61176, 0.67451, 0.62353),
                (0.61176, 0.68235, 0.60392),
                (0.61176, 0.69804, 0.58824),
                (0.61176, 0.70588, 0.57255),
                (0.61569, 0.71765, 0.55686),
                (0.61569, 0.73333, 0.54118),
                (0.61961, 0.74118, 0.52941),
                (0.61961, 0.75686, 0.51373),
                (0.62353, 0.77255, 0.50588),
                (0.62353, 0.78824, 0.49412),
                (0.62745, 0.80392, 0.48627),
                (0.62745, 0.82353, 0.47843),
                (0.63137, 0.80392, 0.47059),
                (0.63529, 0.78824, 0.46275),
                (0.63529, 0.77255, 0.45882),
                (0.64314, 0.75686, 0.45490),
                (0.64706, 0.74118, 0.45098),
                (0.65098, 0.73333, 0.44706),
                (0.65490, 0.71765, 0.44706),
                (0.66275, 0.70588, 0.44706),
                (0.66667, 0.69804, 0.44706),
                (0.67451, 0.68235, 0.44706),
                (0.67843, 0.67451, 0.45098),
                (0.68235, 0.66667, 0.45490),
                (0.69020, 0.65882, 0.45882),
                (0.69412, 0.65098, 0.46275),
                (0.70588, 0.63922, 0.47059),
                (0.70980, 0.63529, 0.47843),
                (0.71765, 0.62745, 0.48627),
                (0.72941, 0.61961, 0.49412),
                (0.73333, 0.61176, 0.50588),
                (0.74510, 0.60784, 0.51373),
                (0.74902, 0.60392, 0.52941),
                (0.76078, 0.60000, 0.54118),
                (0.77647, 0.59608, 0.55686),
                (0.79216, 0.59216, 0.57255),
                (0.80392, 0.58824, 0.58824),
                (0.81961, 0.58824, 0.60392),
                (0.83922, 0.58431, 0.62353),
                (0.85490, 0.58039, 0.64314),
                (0.87451, 0.58039, 0.65882),
                (0.89804, 0.58039, 0.68235),
                (0.92157, 0.57647, 0.70588),
                (0.91373, 0.58039, 0.72941),
                (0.90588, 0.57647, 0.75686),
                (0.89804, 0.58039, 0.78431),
                (0.89412, 0.58039, 0.75686),
                (0.88627, 0.58039, 0.72941),
                (0.88235, 0.58431, 0.70588),
                (0.87843, 0.58824, 0.68235),
                (0.87451, 0.58824, 0.65882),
                (0.87059, 0.59216, 0.64314),
                (0.86275, 0.59608, 0.62353),
                (0.86275, 0.60000, 0.60392),
                (0.85882, 0.60392, 0.58824),
                (0.85882, 0.60784, 0.57255),
                (0.85490, 0.61176, 0.55686),
                (0.85098, 0.61961, 0.54118),
                (0.85490, 0.62745, 0.52941),
                (0.85098, 0.63529, 0.51373),
                (0.85098, 0.63922, 0.50588),
                (0.85098, 0.65490, 0.49412),
                (0.85098, 0.67059, 0.48627),
                (0.85490, 0.68235, 0.47843),
                (0.85098, 0.69804, 0.47059),
                (0.85490, 0.71373, 0.46275),
                (0.85098, 0.74118, 0.45882),
                (0.85490, 0.75686, 0.45490),
                (0.85882, 0.78039, 0.45098),
                (0.86275, 0.80392, 0.44706),
                (0.86275, 0.82353, 0.44706),
                (0.86667, 0.85098, 0.44706),
                (0.87059, 0.87843, 0.44706),
                (0.87451, 0.90980, 0.44706),
                (0.87843, 0.93725, 0.45098),
                (0.88235, 0.97255, 0.45490),
                (0.88627, 0.96471, 0.45882),
                (0.89020, 0.96078, 0.46275),
                (0.89804, 0.95686, 0.47059),
                (0.90196, 0.95294, 0.47843),
                (0.90588, 0.94902, 0.48627),
                (0.91373, 0.94902, 0.49412),
                (0.91765, 0.94510, 0.50588),
                (0.92549, 0.94118, 0.51373),
                (0.92941, 0.94510, 0.52941),
                (0.94118, 0.94118, 0.54118),
                (0.94902, 0.94510, 0.55686),
                (0.95294, 0.94510, 0.57255),
                (0.96078, 0.94510, 0.58824),
                (0.97255, 0.94902, 0.60392),
                (0.98039, 0.94902, 0.62745),
                (0.98824, 0.95294, 0.65098),
                (0.99608, 0.95686, 0.67451),
                (1.00000, 0.95686, 0.70588),
                (1.00000, 0.96078, 0.73333),
                (1.00000, 0.96863, 0.76863),
                (1.00000, 0.97255, 0.80392),
                (1.00000, 0.98039, 0.84314),
                (1.00000, 0.98431, 0.82353),
                (0.98824, 0.99216, 0.80784),
                (0.96078, 0.99608, 0.79608),
                (0.93333, 1.00000, 0.78431),
                (0.90980, 1.00000, 0.77255),
                (0.88235, 1.00000, 0.76471),
                (0.85882, 1.00000, 0.75686),
                (0.83137, 1.00000, 0.74902),
                (0.80784, 1.00000, 0.74118),
                (0.78039, 1.00000, 0.73725),
                (0.75686, 1.00000, 0.73333),
                (0.73333, 1.00000, 0.72941),
                (0.70588, 1.00000, 0.72941),
                (0.69020, 1.00000, 0.72941),
                (0.66667, 0.97255, 0.72941),
                (0.64314, 0.93725, 0.73333),
                (0.62353, 0.90196, 0.73725),
                (0.60392, 0.86667, 0.74118),
                (0.58431, 0.83137, 0.74510),
                (0.56078, 0.79608, 0.75294),
                (0.54510, 0.76078, 0.75686),
                (0.52941, 0.73333, 0.76863),
                (0.51373, 0.69804, 0.77647),
                (0.50196, 0.67059, 0.78824),
                (0.48627, 0.63922, 0.80392),
                (0.47059, 0.61176, 0.81569),
                (0.45490, 0.58039, 0.83137),
                (0.44314, 0.55294, 0.84706),
                (0.43529, 0.52941, 0.86667),
                (0.42353, 0.50588, 0.88235),
                (0.41569, 0.47843, 0.90196),
                (0.41176, 0.45490, 0.92549),
                (0.40392, 0.43529, 0.87843),
                (0.40000, 0.41569, 0.83922),
                (0.39216, 0.39216, 0.79608),
                (0.38824, 0.37647, 0.75686),
                (0.38431, 0.35686, 0.72157),
                (0.38039, 0.34118, 0.67843),
                (0.38039, 0.32941, 0.65098),
                (0.37255, 0.31765, 0.61569),
                (0.37255, 0.30588, 0.58431),
                (0.37255, 0.29804, 0.55686),
                (0.37255, 0.29412, 0.52549),
                (0.37647, 0.28627, 0.50196),
                (0.37647, 0.28235, 0.47843),
                (0.38039, 0.28235, 0.45882),
                (0.38431, 0.27843, 0.43922),
                (0.38824, 0.27843, 0.41961),
                (0.39608, 0.27843, 0.40784),
                (0.40000, 0.28235, 0.40000),
                (0.40784, 0.28627, 0.38824),
                (0.41569, 0.29020, 0.38431),
                (0.42353, 0.29804, 0.38039),
                (0.43529, 0.30588, 0.37647),
                (0.44706, 0.31765, 0.37647),
                (0.45882, 0.32549, 0.38039),
                (0.47059, 0.34118, 0.38431),
                (0.48235, 0.35294, 0.39216),
                (0.50196, 0.37255, 0.40000),
                (0.51765, 0.39216, 0.40784),
                (0.53725, 0.41176, 0.42353),
                (0.55686, 0.43922, 0.43529),
                (0.57647, 0.46667, 0.45098),
                (0.60000, 0.49804, 0.47451),
                (0.62745, 0.52941, 0.49804),
                (0.65490, 0.56078, 0.52549),
                (0.68235, 0.59216, 0.54902),
                (0.70980, 0.62745, 0.58431),
                (0.74118, 0.66275, 0.61569),
                (0.77255, 0.70196, 0.65098),
                (0.80392, 0.74118, 0.69020),
                (0.83529, 0.78039, 0.73333),
                (0.87059, 0.82353, 0.78431),
        )

cmap_smooth = (
                (0.00000, 0.00000, 1.00000),  # noqa
                (0.01569, 0.00000, 0.98431),
                (0.03529, 0.00000, 0.96471),
                (0.05098, 0.00000, 0.94902),
                (0.06667, 0.00000, 0.93333),
                (0.08627, 0.00000, 0.91373),
                (0.10196, 0.00000, 0.89804),
                (0.11765, 0.00000, 0.88235),
                (0.13725, 0.00000, 0.86275),
                (0.15294, 0.00000, 0.84706),
                (0.16863, 0.00000, 0.83137),
                (0.18824, 0.00000, 0.81176),
                (0.20392, 0.00000, 0.79608),
                (0.21961, 0.00000, 0.78039),
                (0.23922, 0.00000, 0.76078),
                (0.25490, 0.00000, 0.74510),
                (0.27059, 0.00000, 0.72941),
                (0.28627, 0.00000, 0.71373),
                (0.30588, 0.00000, 0.69412),
                (0.32157, 0.00000, 0.67843),
                (0.33725, 0.00000, 0.66275),
                (0.35686, 0.00000, 0.64314),
                (0.37255, 0.00000, 0.62745),
                (0.38824, 0.00000, 0.61176),
                (0.40784, 0.00000, 0.59216),
                (0.42353, 0.00000, 0.57647),
                (0.43922, 0.00000, 0.56078),
                (0.45882, 0.00000, 0.54118),
                (0.47451, 0.00000, 0.52549),
                (0.49020, 0.00000, 0.50980),
                (0.50980, 0.00000, 0.49020),
                (0.52549, 0.00000, 0.47451),
                (0.54118, 0.00000, 0.45882),
                (0.56078, 0.00000, 0.43922),
                (0.57647, 0.00000, 0.42353),
                (0.59216, 0.00000, 0.40784),
                (0.61176, 0.00000, 0.38824),
                (0.62745, 0.00000, 0.37255),
                (0.64314, 0.00000, 0.35686),
                (0.66275, 0.00000, 0.33725),
                (0.67843, 0.00000, 0.32157),
                (0.69412, 0.00000, 0.30588),
                (0.71373, 0.00000, 0.28627),
                (0.72941, 0.00000, 0.27059),
                (0.74510, 0.00000, 0.25490),
                (0.76078, 0.00000, 0.23922),
                (0.78039, 0.00000, 0.21961),
                (0.79608, 0.00000, 0.20392),
                (0.81176, 0.00000, 0.18824),
                (0.83137, 0.00000, 0.16863),
                (0.84706, 0.00000, 0.15294),
                (0.86275, 0.00000, 0.13725),
                (0.88235, 0.00000, 0.11765),
                (0.89804, 0.00000, 0.10196),
                (0.91373, 0.00000, 0.08627),
                (0.93333, 0.00000, 0.06667),
                (0.94902, 0.00000, 0.05098),
                (0.96471, 0.00000, 0.03529),
                (0.98431, 0.00000, 0.01569),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.01176, 0.00000),
                (1.00000, 0.01961, 0.00000),
                (1.00000, 0.03137, 0.00000),
                (1.00000, 0.03922, 0.00000),
                (1.00000, 0.05098, 0.00000),
                (1.00000, 0.05882, 0.00000),
                (1.00000, 0.07059, 0.00000),
                (1.00000, 0.08235, 0.00000),
                (1.00000, 0.09020, 0.00000),
                (1.00000, 0.10196, 0.00000),
                (1.00000, 0.10980, 0.00000),
                (1.00000, 0.12157, 0.00000),
                (1.00000, 0.12941, 0.00000),
                (1.00000, 0.14118, 0.00000),
                (0.99608, 0.15294, 0.00000),
                (0.99608, 0.16078, 0.00000),
                (0.99608, 0.17255, 0.00000),
                (0.99608, 0.18039, 0.00000),
                (0.99608, 0.19216, 0.00000),
                (0.99608, 0.20392, 0.00000),
                (0.99608, 0.21176, 0.00000),
                (0.99608, 0.22353, 0.00000),
                (0.99608, 0.23137, 0.00000),
                (0.99608, 0.24314, 0.00000),
                (0.99608, 0.25098, 0.00000),
                (0.99608, 0.26275, 0.00000),
                (0.99608, 0.27451, 0.00000),
                (0.99608, 0.28235, 0.00000),
                (0.99608, 0.29412, 0.00000),
                (0.99608, 0.30196, 0.00000),
                (0.99608, 0.31373, 0.00000),
                (0.99608, 0.32157, 0.00000),
                (0.99608, 0.33333, 0.00000),
                (0.99608, 0.34510, 0.00000),
                (0.99608, 0.35294, 0.00000),
                (0.99608, 0.36471, 0.00000),
                (0.99608, 0.37255, 0.00000),
                (0.99608, 0.38431, 0.00000),
                (0.99608, 0.39216, 0.00000),
                (0.99608, 0.40392, 0.00000),
                (0.99608, 0.41569, 0.00000),
                (0.99608, 0.42353, 0.00000),
                (0.99608, 0.43529, 0.00000),
                (0.99608, 0.44314, 0.00000),
                (0.99216, 0.45490, 0.00000),
                (0.99216, 0.46667, 0.00000),
                (0.99216, 0.47451, 0.00000),
                (0.99216, 0.48627, 0.00000),
                (0.99216, 0.49412, 0.00000),
                (0.99216, 0.50588, 0.00000),
                (0.99216, 0.51373, 0.00000),
                (0.99216, 0.52549, 0.00000),
                (0.99216, 0.53725, 0.00000),
                (0.99216, 0.54510, 0.00000),
                (0.99216, 0.55686, 0.00000),
                (0.99216, 0.56471, 0.00000),
                (0.99216, 0.57647, 0.00000),
                (0.99216, 0.58431, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.60000, 0.00000),
                (0.99216, 0.60784, 0.00000),
                (0.99216, 0.61176, 0.00000),
                (0.99216, 0.61569, 0.00000),
                (0.99216, 0.61961, 0.00000),
                (0.99216, 0.62745, 0.00000),
                (0.99216, 0.63137, 0.00000),
                (0.99216, 0.63529, 0.00000),
                (0.99216, 0.64314, 0.00000),
                (0.98824, 0.64706, 0.00000),
                (0.98824, 0.65098, 0.00000),
                (0.98824, 0.65882, 0.00000),
                (0.98824, 0.66275, 0.00000),
                (0.98824, 0.66667, 0.00000),
                (0.98824, 0.67451, 0.00000),
                (0.98824, 0.67843, 0.00000),
                (0.98824, 0.68235, 0.00000),
                (0.98824, 0.68627, 0.00000),
                (0.98824, 0.69412, 0.00000),
                (0.98824, 0.69804, 0.00000),
                (0.98824, 0.70196, 0.00000),
                (0.98824, 0.70980, 0.00000),
                (0.98824, 0.71373, 0.00000),
                (0.98824, 0.71765, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72941, 0.00000),
                (0.98824, 0.73333, 0.00000),
                (0.98824, 0.73725, 0.00000),
                (0.98824, 0.74510, 0.00000),
                (0.98824, 0.74902, 0.00000),
                (0.98431, 0.75294, 0.00000),
                (0.98431, 0.76078, 0.00000),
                (0.98431, 0.76471, 0.00000),
                (0.98431, 0.76863, 0.00000),
                (0.98431, 0.77255, 0.00000),
                (0.98431, 0.78039, 0.00000),
                (0.98431, 0.78431, 0.00000),
                (0.98431, 0.78824, 0.00000),
                (0.98431, 0.79608, 0.00000),
                (0.98431, 0.80000, 0.00000),
                (0.98431, 0.80392, 0.00000),
                (0.98431, 0.81176, 0.00000),
                (0.98431, 0.81569, 0.00000),
                (0.98431, 0.81961, 0.00000),
                (0.98431, 0.82745, 0.00000),
                (0.98431, 0.83137, 0.00000),
                (0.98431, 0.83529, 0.00000),
                (0.98431, 0.83922, 0.00000),
                (0.98431, 0.84706, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98039, 0.85490, 0.00000),
                (0.98039, 0.86275, 0.00000),
                (0.98039, 0.86667, 0.00000),
                (0.98039, 0.87059, 0.00000),
                (0.98039, 0.87843, 0.00000),
                (0.98039, 0.88235, 0.00000),
                (0.98039, 0.88627, 0.00000),
                (0.98039, 0.89020, 0.00000),
                (0.98039, 0.89804, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.96471, 0.88627, 0.00000),
                (0.94902, 0.87059, 0.00000),
                (0.92941, 0.85490, 0.00000),
                (0.91373, 0.83922, 0.00000),
                (0.89804, 0.82745, 0.00000),
                (0.88235, 0.81176, 0.00000),
                (0.86275, 0.79608, 0.00000),
                (0.84706, 0.78039, 0.00000),
                (0.83137, 0.76471, 0.00000),
                (0.81569, 0.74902, 0.00000),
                (0.79608, 0.73333, 0.00000),
                (0.78039, 0.71765, 0.00000),
                (0.76471, 0.70196, 0.00000),
                (0.74902, 0.68627, 0.00000),
                (0.72941, 0.67451, 0.00000),
                (0.71373, 0.65882, 0.00000),
                (0.69804, 0.64314, 0.00000),
                (0.68235, 0.62745, 0.00000),
                (0.66275, 0.61176, 0.00000),
                (0.64706, 0.59608, 0.00000),
                (0.63137, 0.58039, 0.00000),
                (0.61569, 0.56471, 0.00000),
                (0.60000, 0.54902, 0.00000),
                (0.58039, 0.53333, 0.00000),
                (0.56471, 0.52157, 0.00000),
                (0.54902, 0.50588, 0.00000),
                (0.53333, 0.49020, 0.00000),
                (0.51373, 0.47451, 0.00000),
                (0.49804, 0.45882, 0.00000),
                (0.48235, 0.44314, 0.00000),
                (0.46667, 0.42745, 0.00000),
                (0.44706, 0.41176, 0.00000),
                (0.43137, 0.39608, 0.00000),
                (0.41569, 0.38039, 0.00000),
                (0.40000, 0.36863, 0.00000),
                (0.38039, 0.35294, 0.00000),
                (0.36471, 0.33725, 0.00000),
                (0.34902, 0.32157, 0.00000),
                (0.33333, 0.30588, 0.00000),
                (0.31765, 0.29020, 0.00000),
                (0.29804, 0.27451, 0.00000),
                (0.28235, 0.25882, 0.00000),
                (0.26667, 0.24314, 0.00000),
                (0.25098, 0.22745, 0.00000),
                (0.23137, 0.21569, 0.00000),
                (0.21569, 0.20000, 0.00000),
                (0.20000, 0.18431, 0.00000),
                (0.18431, 0.16863, 0.00000),
                (0.16471, 0.15294, 0.00000),
                (0.14902, 0.13725, 0.00000),
                (0.13333, 0.12157, 0.00000),
                (0.11765, 0.10588, 0.00000),
                (0.09804, 0.09020, 0.00000),
                (0.08235, 0.07451, 0.00000),
                (0.06667, 0.06275, 0.00000),
                (0.05098, 0.04706, 0.00000),
                (0.03137, 0.03137, 0.00000),
                (0.01569, 0.01569, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
        )

cmap_isophot = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.03922),
                (0.00000, 0.00000, 0.07843),
                (0.00000, 0.00000, 0.11765),
                (0.00000, 0.00000, 0.15686),
                (0.00000, 0.00000, 0.19608),
                (0.00000, 0.00000, 0.23529),
                (0.00000, 0.00000, 0.27843),
                (0.00000, 0.00000, 0.31765),
                (0.00000, 0.00000, 0.35686),
                (0.00000, 0.00000, 0.39608),
                (0.00000, 0.00000, 0.43529),
                (0.00000, 0.00000, 0.47451),
                (0.00000, 0.00000, 0.51765),
                (0.00000, 0.00000, 0.55686),
                (0.00000, 0.00000, 0.59608),
                (0.00000, 0.00000, 0.63529),
                (0.00000, 0.00000, 0.67451),
                (0.00000, 0.00000, 0.71765),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (0.00000, 0.00000, 0.87843),
                (0.00000, 0.00000, 0.91765),
                (0.00000, 0.00000, 0.95686),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.03137, 1.00000),
                (0.00000, 0.06275, 1.00000),
                (0.00000, 0.09412, 1.00000),
                (0.00000, 0.12549, 1.00000),
                (0.00000, 0.15686, 1.00000),
                (0.00000, 0.18824, 1.00000),
                (0.00000, 0.21961, 1.00000),
                (0.00000, 0.25490, 1.00000),
                (0.00000, 0.28627, 1.00000),
                (0.00000, 0.31765, 1.00000),
                (0.00000, 0.34902, 1.00000),
                (0.00000, 0.38039, 1.00000),
                (0.00000, 0.41176, 1.00000),
                (0.00000, 0.44314, 1.00000),
                (0.00000, 0.47843, 1.00000),
                (0.00000, 0.49804, 1.00000),
                (0.00000, 0.51765, 1.00000),
                (0.00000, 0.53725, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (0.00000, 0.61961, 1.00000),
                (0.00000, 0.63922, 1.00000),
                (0.00000, 0.65882, 1.00000),
                (0.00000, 0.67843, 1.00000),
                (0.00000, 0.70196, 1.00000),
                (0.00000, 0.72157, 1.00000),
                (0.00000, 0.74118, 1.00000),
                (0.00000, 0.76078, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.79608, 1.00000),
                (0.00000, 0.81176, 1.00000),
                (0.00000, 0.82353, 1.00000),
                (0.00000, 0.83922, 1.00000),
                (0.00000, 0.85490, 1.00000),
                (0.00000, 0.86667, 1.00000),
                (0.00000, 0.88235, 1.00000),
                (0.00000, 0.89412, 1.00000),
                (0.00000, 0.90980, 1.00000),
                (0.00000, 0.92549, 1.00000),
                (0.00000, 0.93725, 1.00000),
                (0.00000, 0.95294, 1.00000),
                (0.00000, 0.96863, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 0.96078),
                (0.00000, 1.00000, 0.94118),
                (0.00000, 1.00000, 0.92157),
                (0.00000, 1.00000, 0.90196),
                (0.00000, 1.00000, 0.88235),
                (0.00000, 1.00000, 0.86275),
                (0.00000, 1.00000, 0.84314),
                (0.00000, 1.00000, 0.82353),
                (0.00000, 1.00000, 0.80392),
                (0.00000, 1.00000, 0.78431),
                (0.00000, 1.00000, 0.76471),
                (0.00000, 1.00000, 0.74510),
                (0.00000, 1.00000, 0.72549),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.65490),
                (0.00000, 1.00000, 0.60784),
                (0.00000, 1.00000, 0.56078),
                (0.00000, 1.00000, 0.51373),
                (0.00000, 1.00000, 0.46667),
                (0.00000, 1.00000, 0.41961),
                (0.00000, 1.00000, 0.37255),
                (0.00000, 1.00000, 0.32549),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 0.13725),
                (0.00000, 1.00000, 0.09020),
                (0.00000, 1.00000, 0.04314),
                (0.00000, 1.00000, 0.00000),
                (0.04706, 1.00000, 0.00000),
                (0.09412, 1.00000, 0.00000),
                (0.14118, 1.00000, 0.00000),
                (0.18824, 1.00000, 0.00000),
                (0.23529, 1.00000, 0.00000),
                (0.28235, 1.00000, 0.00000),
                (0.32941, 1.00000, 0.00000),
                (0.37647, 1.00000, 0.00000),
                (0.42353, 1.00000, 0.00000),
                (0.47059, 1.00000, 0.00000),
                (0.51765, 1.00000, 0.00000),
                (0.56471, 1.00000, 0.00000),
                (0.61176, 1.00000, 0.00000),
                (0.65882, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.72549, 1.00000, 0.00000),
                (0.74510, 1.00000, 0.00000),
                (0.76471, 1.00000, 0.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (0.84314, 1.00000, 0.00000),
                (0.86275, 1.00000, 0.00000),
                (0.88235, 1.00000, 0.00000),
                (0.90196, 1.00000, 0.00000),
                (0.92157, 1.00000, 0.00000),
                (0.94118, 1.00000, 0.00000),
                (0.96078, 1.00000, 0.00000),
                (0.98039, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.99608, 0.98039, 0.00000),
                (0.99608, 0.96078, 0.00000),
                (0.99608, 0.94118, 0.00000),
                (0.99608, 0.92549, 0.00000),
                (0.99216, 0.90588, 0.00000),
                (0.99216, 0.88627, 0.00000),
                (0.99216, 0.87059, 0.00000),
                (0.99216, 0.85098, 0.00000),
                (0.98824, 0.83137, 0.00000),
                (0.98824, 0.81569, 0.00000),
                (0.98824, 0.79608, 0.00000),
                (0.98824, 0.77647, 0.00000),
                (0.98824, 0.76078, 0.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (0.98824, 0.69020, 0.00000),
                (0.98824, 0.67059, 0.00000),
                (0.98824, 0.65490, 0.00000),
                (0.98824, 0.63922, 0.00000),
                (0.98824, 0.61961, 0.00000),
                (0.99216, 0.60392, 0.00000),
                (0.99216, 0.58824, 0.00000),
                (0.99216, 0.56863, 0.00000),
                (0.99216, 0.55294, 0.00000),
                (0.99608, 0.53725, 0.00000),
                (0.99608, 0.51765, 0.00000),
                (0.99608, 0.50196, 0.00000),
                (0.99608, 0.48627, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.43529, 0.00000),
                (1.00000, 0.40392, 0.00000),
                (1.00000, 0.37255, 0.00000),
                (1.00000, 0.34118, 0.00000),
                (1.00000, 0.30980, 0.00000),
                (1.00000, 0.27843, 0.00000),
                (1.00000, 0.24706, 0.00000),
                (1.00000, 0.21569, 0.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 0.09020, 0.00000),
                (1.00000, 0.05882, 0.00000),
                (1.00000, 0.02745, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.04706),
                (1.00000, 0.00000, 0.09412),
                (1.00000, 0.00000, 0.14118),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 0.00000, 0.32941),
                (1.00000, 0.00000, 0.37647),
                (1.00000, 0.00000, 0.42353),
                (1.00000, 0.00000, 0.47059),
                (1.00000, 0.00000, 0.51765),
                (1.00000, 0.00000, 0.56471),
                (1.00000, 0.00000, 0.61176),
                (1.00000, 0.00000, 0.65882),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.72549),
                (1.00000, 0.00000, 0.74902),
                (1.00000, 0.00000, 0.77255),
                (1.00000, 0.00000, 0.79608),
                (1.00000, 0.00000, 0.81569),
                (1.00000, 0.00000, 0.83922),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.88627),
                (1.00000, 0.00000, 0.90588),
                (1.00000, 0.00000, 0.92941),
                (1.00000, 0.00000, 0.95294),
                (1.00000, 0.00000, 0.97647),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 0.14118, 1.00000),
                (1.00000, 0.17647, 1.00000),
                (1.00000, 0.21176, 1.00000),
                (1.00000, 0.25098, 1.00000),
                (1.00000, 0.28627, 1.00000),
                (1.00000, 0.32157, 1.00000),
                (1.00000, 0.36078, 1.00000),
                (1.00000, 0.39608, 1.00000),
                (1.00000, 0.43137, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.48627, 1.00000),
                (1.00000, 0.50588, 1.00000),
                (1.00000, 0.52157, 1.00000),
                (1.00000, 0.54118, 1.00000),
                (1.00000, 0.56078, 1.00000),
                (1.00000, 0.57647, 1.00000),
                (1.00000, 0.59608, 1.00000),
                (1.00000, 0.61176, 1.00000),
                (1.00000, 0.63137, 1.00000),
                (1.00000, 0.65098, 1.00000),
                (1.00000, 0.66667, 1.00000),
                (1.00000, 0.68627, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.74510, 1.00000),
                (1.00000, 0.78824, 1.00000),
                (1.00000, 0.83137, 1.00000),
                (1.00000, 0.87059, 1.00000),
                (1.00000, 0.91373, 1.00000),
                (1.00000, 0.95686, 1.00000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_smooth2 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.13333),
                (0.00000, 0.00000, 0.13333),
                (0.00000, 0.00000, 0.13333),
                (0.00000, 0.00000, 0.13333),
                (0.00000, 0.00000, 0.13333),
                (0.00000, 0.00000, 0.13333),
                (0.00000, 0.00000, 0.13333),
                (0.00000, 0.00000, 0.13333),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.26667),
                (0.00000, 0.00000, 0.26667),
                (0.00000, 0.00000, 0.26667),
                (0.00000, 0.00000, 0.26667),
                (0.00000, 0.00000, 0.26667),
                (0.00000, 0.00000, 0.26667),
                (0.00000, 0.00000, 0.26667),
                (0.00000, 0.00000, 0.26667),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.53333),
                (0.00000, 0.00000, 0.53333),
                (0.00000, 0.00000, 0.53333),
                (0.00000, 0.00000, 0.53333),
                (0.00000, 0.00000, 0.53333),
                (0.00000, 0.00000, 0.53333),
                (0.00000, 0.00000, 0.53333),
                (0.00000, 0.00000, 0.53333),
                (0.06667, 0.00000, 0.53333),
                (0.06667, 0.00000, 0.53333),
                (0.06667, 0.00000, 0.53333),
                (0.06667, 0.00000, 0.53333),
                (0.06667, 0.00000, 0.53333),
                (0.06667, 0.00000, 0.53333),
                (0.06667, 0.00000, 0.53333),
                (0.06667, 0.00000, 0.53333),
                (0.13333, 0.00000, 0.53333),
                (0.13333, 0.00000, 0.53333),
                (0.13333, 0.00000, 0.53333),
                (0.13333, 0.00000, 0.53333),
                (0.13333, 0.00000, 0.53333),
                (0.13333, 0.00000, 0.53333),
                (0.13333, 0.00000, 0.53333),
                (0.13333, 0.00000, 0.53333),
                (0.20000, 0.00000, 0.53333),
                (0.20000, 0.00000, 0.53333),
                (0.20000, 0.00000, 0.53333),
                (0.20000, 0.00000, 0.53333),
                (0.20000, 0.00000, 0.53333),
                (0.20000, 0.00000, 0.53333),
                (0.20000, 0.00000, 0.53333),
                (0.20000, 0.00000, 0.53333),
                (0.26667, 0.00000, 0.53333),
                (0.26667, 0.00000, 0.53333),
                (0.26667, 0.00000, 0.53333),
                (0.26667, 0.00000, 0.53333),
                (0.26667, 0.00000, 0.53333),
                (0.26667, 0.00000, 0.53333),
                (0.26667, 0.00000, 0.53333),
                (0.26667, 0.00000, 0.53333),
                (0.33333, 0.00000, 0.53333),
                (0.33333, 0.00000, 0.53333),
                (0.33333, 0.00000, 0.53333),
                (0.33333, 0.00000, 0.53333),
                (0.33333, 0.00000, 0.53333),
                (0.33333, 0.00000, 0.53333),
                (0.33333, 0.00000, 0.53333),
                (0.33333, 0.00000, 0.53333),
                (0.40000, 0.00000, 0.53333),
                (0.40000, 0.00000, 0.53333),
                (0.40000, 0.00000, 0.53333),
                (0.40000, 0.00000, 0.53333),
                (0.40000, 0.00000, 0.53333),
                (0.40000, 0.00000, 0.53333),
                (0.40000, 0.00000, 0.53333),
                (0.40000, 0.00000, 0.53333),
                (0.46667, 0.00000, 0.53333),
                (0.46667, 0.00000, 0.53333),
                (0.46667, 0.00000, 0.53333),
                (0.46667, 0.00000, 0.53333),
                (0.46667, 0.00000, 0.53333),
                (0.46667, 0.00000, 0.53333),
                (0.46667, 0.00000, 0.53333),
                (0.46667, 0.00000, 0.53333),
                (0.53333, 0.00000, 0.53333),
                (0.53333, 0.00000, 0.53333),
                (0.53333, 0.00000, 0.53333),
                (0.53333, 0.00000, 0.53333),
                (0.53333, 0.00000, 0.46667),
                (0.53333, 0.00000, 0.46667),
                (0.53333, 0.00000, 0.46667),
                (0.53333, 0.00000, 0.46667),
                (0.60000, 0.00000, 0.40000),
                (0.60000, 0.00000, 0.40000),
                (0.60000, 0.00000, 0.40000),
                (0.60000, 0.00000, 0.40000),
                (0.60000, 0.00000, 0.33333),
                (0.60000, 0.00000, 0.33333),
                (0.60000, 0.00000, 0.33333),
                (0.60000, 0.00000, 0.33333),
                (0.66667, 0.00000, 0.26667),
                (0.66667, 0.00000, 0.26667),
                (0.66667, 0.00000, 0.26667),
                (0.66667, 0.00000, 0.26667),
                (0.66667, 0.00000, 0.20000),
                (0.66667, 0.00000, 0.20000),
                (0.66667, 0.00000, 0.20000),
                (0.66667, 0.00000, 0.20000),
                (0.73333, 0.00000, 0.13333),
                (0.73333, 0.00000, 0.13333),
                (0.73333, 0.00000, 0.13333),
                (0.73333, 0.00000, 0.13333),
                (0.73333, 0.00000, 0.06667),
                (0.73333, 0.00000, 0.06667),
                (0.73333, 0.00000, 0.06667),
                (0.73333, 0.00000, 0.06667),
                (0.80000, 0.00000, 0.00000),
                (0.80000, 0.00000, 0.00000),
                (0.80000, 0.00000, 0.00000),
                (0.80000, 0.00000, 0.00000),
                (0.80000, 0.00000, 0.00000),
                (0.80000, 0.00000, 0.00000),
                (0.80000, 0.00000, 0.00000),
                (0.80000, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.93333, 0.00000, 0.00000),
                (0.93333, 0.00000, 0.00000),
                (0.93333, 0.00000, 0.00000),
                (0.93333, 0.00000, 0.00000),
                (0.93333, 0.00000, 0.00000),
                (0.93333, 0.00000, 0.00000),
                (0.93333, 0.00000, 0.00000),
                (0.93333, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.06667, 0.00000),
                (1.00000, 0.06667, 0.00000),
                (1.00000, 0.13333, 0.00000),
                (1.00000, 0.13333, 0.00000),
                (1.00000, 0.20000, 0.00000),
                (1.00000, 0.20000, 0.00000),
                (1.00000, 0.26667, 0.00000),
                (1.00000, 0.26667, 0.00000),
                (1.00000, 0.33333, 0.00000),
                (1.00000, 0.33333, 0.00000),
                (1.00000, 0.40000, 0.00000),
                (1.00000, 0.40000, 0.00000),
                (1.00000, 0.46667, 0.00000),
                (1.00000, 0.46667, 0.00000),
                (1.00000, 0.53333, 0.00000),
                (1.00000, 0.53333, 0.00000),
                (1.00000, 0.60000, 0.00000),
                (1.00000, 0.60000, 0.00000),
                (1.00000, 0.66667, 0.00000),
                (1.00000, 0.66667, 0.00000),
                (1.00000, 0.73333, 0.00000),
                (1.00000, 0.73333, 0.00000),
                (1.00000, 0.80000, 0.00000),
                (1.00000, 0.80000, 0.00000),
                (1.00000, 0.86667, 0.00000),
                (1.00000, 0.86667, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.06667),
                (1.00000, 1.00000, 0.06667),
                (1.00000, 1.00000, 0.13333),
                (1.00000, 1.00000, 0.13333),
                (1.00000, 1.00000, 0.20000),
                (1.00000, 1.00000, 0.20000),
                (1.00000, 1.00000, 0.26667),
                (1.00000, 1.00000, 0.26667),
                (1.00000, 1.00000, 0.33333),
                (1.00000, 1.00000, 0.33333),
                (1.00000, 1.00000, 0.40000),
                (1.00000, 1.00000, 0.40000),
                (1.00000, 1.00000, 0.46667),
                (1.00000, 1.00000, 0.46667),
                (1.00000, 1.00000, 0.53333),
                (1.00000, 1.00000, 0.53333),
                (1.00000, 1.00000, 0.60000),
                (1.00000, 1.00000, 0.60000),
                (1.00000, 1.00000, 0.66667),
                (1.00000, 1.00000, 0.66667),
                (1.00000, 1.00000, 0.73333),
                (1.00000, 1.00000, 0.73333),
                (1.00000, 1.00000, 0.80000),
                (1.00000, 1.00000, 0.80000),
                (1.00000, 1.00000, 0.86667),
                (1.00000, 1.00000, 1.00000),
        )

cmap_heat = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.01176, 0.00392, 0.00000),
                (0.02353, 0.00784, 0.00000),
                (0.03529, 0.01176, 0.00000),
                (0.04706, 0.01569, 0.00000),
                (0.05882, 0.01961, 0.00000),
                (0.07059, 0.02353, 0.00000),
                (0.08235, 0.02745, 0.00000),
                (0.09412, 0.03137, 0.00000),
                (0.10588, 0.03529, 0.00000),
                (0.11765, 0.03922, 0.00000),
                (0.12941, 0.04314, 0.00000),
                (0.14118, 0.04706, 0.00000),
                (0.15294, 0.05098, 0.00000),
                (0.16471, 0.05490, 0.00000),
                (0.17647, 0.05882, 0.00000),
                (0.18824, 0.06275, 0.00000),
                (0.20000, 0.06667, 0.00000),
                (0.21176, 0.07059, 0.00000),
                (0.22353, 0.07451, 0.00000),
                (0.23529, 0.07843, 0.00000),
                (0.24706, 0.08235, 0.00000),
                (0.25882, 0.08627, 0.00000),
                (0.27059, 0.09020, 0.00000),
                (0.28235, 0.09412, 0.00000),
                (0.29412, 0.09804, 0.00000),
                (0.30588, 0.10196, 0.00000),
                (0.31765, 0.10588, 0.00000),
                (0.32941, 0.10980, 0.00000),
                (0.34118, 0.11373, 0.00000),
                (0.35294, 0.11765, 0.00000),
                (0.36471, 0.12157, 0.00000),
                (0.37647, 0.12549, 0.00000),
                (0.38824, 0.12941, 0.00000),
                (0.40000, 0.13333, 0.00000),
                (0.41176, 0.13725, 0.00000),
                (0.42353, 0.14118, 0.00000),
                (0.43529, 0.14510, 0.00000),
                (0.44706, 0.14902, 0.00000),
                (0.45882, 0.15294, 0.00000),
                (0.47059, 0.15686, 0.00000),
                (0.48235, 0.16078, 0.00000),
                (0.49412, 0.16471, 0.00000),
                (0.50588, 0.16863, 0.00000),
                (0.51765, 0.17255, 0.00000),
                (0.52941, 0.17647, 0.00000),
                (0.54118, 0.18039, 0.00000),
                (0.55294, 0.18431, 0.00000),
                (0.56471, 0.18824, 0.00000),
                (0.57647, 0.19216, 0.00000),
                (0.58824, 0.19608, 0.00000),
                (0.60000, 0.20000, 0.00000),
                (0.61176, 0.20392, 0.00000),
                (0.62353, 0.20784, 0.00000),
                (0.63529, 0.21176, 0.00000),
                (0.64706, 0.21569, 0.00000),
                (0.65882, 0.21961, 0.00000),
                (0.67059, 0.22353, 0.00000),
                (0.68235, 0.22745, 0.00000),
                (0.69412, 0.23137, 0.00000),
                (0.70588, 0.23529, 0.00000),
                (0.71765, 0.23922, 0.00000),
                (0.72941, 0.24314, 0.00000),
                (0.74118, 0.24706, 0.00000),
                (0.75294, 0.25098, 0.00000),
                (0.76471, 0.25490, 0.00000),
                (0.77647, 0.25882, 0.00000),
                (0.78824, 0.26275, 0.00000),
                (0.80000, 0.26667, 0.00000),
                (0.81176, 0.27059, 0.00000),
                (0.82353, 0.27451, 0.00000),
                (0.83529, 0.27843, 0.00000),
                (0.84706, 0.28235, 0.00000),
                (0.85882, 0.28627, 0.00000),
                (0.87059, 0.29020, 0.00000),
                (0.88235, 0.29412, 0.00000),
                (0.89412, 0.29804, 0.00000),
                (0.90588, 0.30196, 0.00000),
                (0.91765, 0.30588, 0.00000),
                (0.92941, 0.30980, 0.00000),
                (0.94118, 0.31373, 0.00000),
                (0.95294, 0.31765, 0.00000),
                (0.96471, 0.32157, 0.00000),
                (0.97647, 0.32549, 0.00000),
                (0.98824, 0.32941, 0.00000),
                (1.00000, 0.33333, 0.00000),
                (1.00000, 0.33725, 0.00000),
                (1.00000, 0.34118, 0.00000),
                (1.00000, 0.34510, 0.00000),
                (1.00000, 0.34902, 0.00000),
                (1.00000, 0.35294, 0.00000),
                (1.00000, 0.35686, 0.00000),
                (1.00000, 0.36078, 0.00000),
                (1.00000, 0.36471, 0.00000),
                (1.00000, 0.36863, 0.00000),
                (1.00000, 0.37255, 0.00000),
                (1.00000, 0.37647, 0.00000),
                (1.00000, 0.38039, 0.00000),
                (1.00000, 0.38431, 0.00000),
                (1.00000, 0.38824, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.39608, 0.00000),
                (1.00000, 0.40000, 0.00000),
                (1.00000, 0.40392, 0.00000),
                (1.00000, 0.40784, 0.00000),
                (1.00000, 0.41176, 0.00000),
                (1.00000, 0.41569, 0.00000),
                (1.00000, 0.41961, 0.00000),
                (1.00000, 0.42353, 0.00000),
                (1.00000, 0.42745, 0.00000),
                (1.00000, 0.43137, 0.00000),
                (1.00000, 0.43529, 0.00000),
                (1.00000, 0.43922, 0.00000),
                (1.00000, 0.44314, 0.00000),
                (1.00000, 0.44706, 0.00000),
                (1.00000, 0.45098, 0.00000),
                (1.00000, 0.45490, 0.00000),
                (1.00000, 0.45882, 0.00000),
                (1.00000, 0.46275, 0.00000),
                (1.00000, 0.46667, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47451, 0.00000),
                (1.00000, 0.47843, 0.00000),
                (1.00000, 0.48235, 0.00000),
                (1.00000, 0.48627, 0.00000),
                (1.00000, 0.49020, 0.00000),
                (1.00000, 0.49412, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.50196, 0.00000),
                (1.00000, 0.50588, 0.00000),
                (1.00000, 0.50980, 0.00000),
                (1.00000, 0.51373, 0.00000),
                (1.00000, 0.51765, 0.00000),
                (1.00000, 0.52157, 0.00000),
                (1.00000, 0.52549, 0.00000),
                (1.00000, 0.52941, 0.00000),
                (1.00000, 0.53333, 0.00000),
                (1.00000, 0.53725, 0.00000),
                (1.00000, 0.54118, 0.00000),
                (1.00000, 0.54510, 0.00000),
                (1.00000, 0.54902, 0.00000),
                (1.00000, 0.55294, 0.00000),
                (1.00000, 0.55686, 0.00000),
                (1.00000, 0.56078, 0.00000),
                (1.00000, 0.56471, 0.00000),
                (1.00000, 0.56863, 0.00000),
                (1.00000, 0.57255, 0.00000),
                (1.00000, 0.57647, 0.00000),
                (1.00000, 0.58039, 0.00000),
                (1.00000, 0.58431, 0.00000),
                (1.00000, 0.58824, 0.00000),
                (1.00000, 0.59216, 0.00000),
                (1.00000, 0.59608, 0.00000),
                (1.00000, 0.60000, 0.00000),
                (1.00000, 0.60392, 0.00000),
                (1.00000, 0.60784, 0.00000),
                (1.00000, 0.61176, 0.00000),
                (1.00000, 0.61569, 0.00000),
                (1.00000, 0.61961, 0.00000),
                (1.00000, 0.62353, 0.00000),
                (1.00000, 0.62745, 0.00000),
                (1.00000, 0.63137, 0.00000),
                (1.00000, 0.63529, 0.00000),
                (1.00000, 0.63922, 0.00000),
                (1.00000, 0.64314, 0.00000),
                (1.00000, 0.64706, 0.00000),
                (1.00000, 0.65098, 0.01176),
                (1.00000, 0.65490, 0.02353),
                (1.00000, 0.65882, 0.03529),
                (1.00000, 0.66275, 0.04706),
                (1.00000, 0.66667, 0.05882),
                (1.00000, 0.67059, 0.07059),
                (1.00000, 0.67451, 0.08235),
                (1.00000, 0.67843, 0.09412),
                (1.00000, 0.68235, 0.10588),
                (1.00000, 0.68627, 0.11765),
                (1.00000, 0.69020, 0.12941),
                (1.00000, 0.69412, 0.14118),
                (1.00000, 0.69804, 0.15294),
                (1.00000, 0.70196, 0.16471),
                (1.00000, 0.70588, 0.17647),
                (1.00000, 0.70980, 0.18824),
                (1.00000, 0.71373, 0.20000),
                (1.00000, 0.71765, 0.21176),
                (1.00000, 0.72157, 0.22353),
                (1.00000, 0.72549, 0.23529),
                (1.00000, 0.72941, 0.24706),
                (1.00000, 0.73333, 0.25882),
                (1.00000, 0.73725, 0.27059),
                (1.00000, 0.74118, 0.28235),
                (1.00000, 0.74510, 0.29412),
                (1.00000, 0.74902, 0.30588),
                (1.00000, 0.75294, 0.31765),
                (1.00000, 0.75686, 0.32941),
                (1.00000, 0.76078, 0.34118),
                (1.00000, 0.76471, 0.35294),
                (1.00000, 0.76863, 0.36471),
                (1.00000, 0.77255, 0.37647),
                (1.00000, 0.77647, 0.38824),
                (1.00000, 0.78039, 0.40000),
                (1.00000, 0.78431, 0.41176),
                (1.00000, 0.78824, 0.42353),
                (1.00000, 0.79216, 0.43529),
                (1.00000, 0.79608, 0.44706),
                (1.00000, 0.80000, 0.45882),
                (1.00000, 0.80392, 0.47059),
                (1.00000, 0.80784, 0.48235),
                (1.00000, 0.81176, 0.49412),
                (1.00000, 0.81569, 0.50588),
                (1.00000, 0.81961, 0.51765),
                (1.00000, 0.82353, 0.52941),
                (1.00000, 0.82745, 0.54118),
                (1.00000, 0.83137, 0.55294),
                (1.00000, 0.83529, 0.56471),
                (1.00000, 0.83922, 0.57647),
                (1.00000, 0.84314, 0.58824),
                (1.00000, 0.84706, 0.60000),
                (1.00000, 0.85098, 0.61176),
                (1.00000, 0.85490, 0.62353),
                (1.00000, 0.85882, 0.63529),
                (1.00000, 0.86275, 0.64706),
                (1.00000, 0.86667, 0.65882),
                (1.00000, 0.87059, 0.67059),
                (1.00000, 0.87451, 0.68235),
                (1.00000, 0.87843, 0.69412),
                (1.00000, 0.88235, 0.70588),
                (1.00000, 0.88627, 0.71765),
                (1.00000, 0.89020, 0.72941),
                (1.00000, 0.89412, 0.74118),
                (1.00000, 0.89804, 0.75294),
                (1.00000, 0.90196, 0.76471),
                (1.00000, 0.90588, 0.77647),
                (1.00000, 0.90980, 0.78824),
                (1.00000, 0.91373, 0.80000),
                (1.00000, 0.91765, 0.81176),
                (1.00000, 0.92157, 0.82353),
                (1.00000, 0.92549, 0.83529),
                (1.00000, 0.92941, 0.84706),
                (1.00000, 0.93333, 0.85882),
                (1.00000, 0.93725, 0.87059),
                (1.00000, 0.94118, 0.88235),
                (1.00000, 0.94510, 0.89412),
                (1.00000, 0.94902, 0.90588),
                (1.00000, 0.95294, 0.91765),
                (1.00000, 0.95686, 0.92941),
                (1.00000, 0.96078, 0.94118),
                (1.00000, 0.96471, 0.95294),
                (1.00000, 0.96863, 0.96471),
                (1.00000, 0.97255, 0.97647),
                (1.00000, 0.97647, 0.98824),
                (1.00000, 0.98039, 1.00000),
                (1.00000, 0.98431, 1.00000),
                (1.00000, 0.98824, 1.00000),
                (1.00000, 0.99216, 1.00000),
                (1.00000, 0.99608, 1.00000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_smooth3 = (
                (0.00000, 0.00000, 0.00784),  # noqa
                (0.00000, 0.00000, 0.01795),
                (0.00000, 0.00000, 0.03087),
                (0.00000, 0.00000, 0.04434),
                (0.00000, 0.00000, 0.05781),
                (0.00000, 0.00000, 0.07128),
                (0.00000, 0.00000, 0.08475),
                (0.00000, 0.00000, 0.09822),
                (0.00000, 0.00000, 0.11170),
                (0.00000, 0.00000, 0.12231),
                (0.00000, 0.00000, 0.13472),
                (0.00000, 0.00000, 0.14819),
                (0.00000, 0.00000, 0.16166),
                (0.00000, 0.00000, 0.17513),
                (0.00000, 0.00000, 0.18851),
                (0.00000, 0.00000, 0.19862),
                (0.00000, 0.00000, 0.21163),
                (0.00000, 0.00000, 0.22510),
                (0.00000, 0.00000, 0.23857),
                (0.00000, 0.00000, 0.25080),
                (0.00000, 0.00000, 0.26228),
                (0.00000, 0.00000, 0.27885),
                (0.00000, 0.00000, 0.28895),
                (0.00000, 0.00000, 0.30201),
                (0.00000, 0.00000, 0.31308),
                (0.00000, 0.00000, 0.32503),
                (0.00000, 0.00000, 0.33850),
                (0.00000, 0.00000, 0.35197),
                (0.00000, 0.00000, 0.36526),
                (0.00000, 0.00000, 0.37536),
                (0.00000, 0.00000, 0.39146),
                (0.00000, 0.00000, 0.40341),
                (0.00000, 0.00000, 0.41541),
                (0.00000, 0.00000, 0.42754),
                (0.00000, 0.00000, 0.43922),
                (0.00000, 0.00000, 0.45559),
                (0.00000, 0.00000, 0.46570),
                (0.00000, 0.00000, 0.47885),
                (0.00000, 0.00000, 0.49232),
                (0.00000, 0.00000, 0.50579),
                (0.00000, 0.00000, 0.51788),
                (0.00000, 0.00000, 0.52881),
                (0.00000, 0.00000, 0.54228),
                (0.00000, 0.00000, 0.55576),
                (0.00000, 0.00000, 0.56923),
                (0.00000, 0.00000, 0.58016),
                (0.00397, 0.00000, 0.59225),
                (0.01356, 0.00000, 0.60572),
                (0.02791, 0.00000, 0.61919),
                (0.04507, 0.00000, 0.63234),
                (0.06528, 0.00000, 0.64245),
                (0.08235, 0.00000, 0.65569),
                (0.10178, 0.00000, 0.66916),
                (0.12198, 0.00000, 0.68263),
                (0.14219, 0.00000, 0.69462),
                (0.16240, 0.00000, 0.70565),
                (0.18261, 0.00000, 0.71912),
                (0.20281, 0.00000, 0.73259),
                (0.21984, 0.00000, 0.74607),
                (0.23668, 0.00000, 0.75954),
                (0.25559, 0.00000, 0.77093),
                (0.27580, 0.00000, 0.78256),
                (0.29504, 0.00000, 0.79603),
                (0.31063, 0.00000, 0.80909),
                (0.31737, 0.00000, 0.81919),
                (0.31765, 0.00000, 0.83575),
                (0.31765, 0.00000, 0.84992),
                (0.31765, 0.00000, 0.86339),
                (0.31765, 0.00000, 0.87686),
                (0.31765, 0.00000, 0.88932),
                (0.31719, 0.00000, 0.89942),
                (0.31382, 0.00000, 0.90953),
                (0.31373, 0.00000, 0.92291),
                (0.31373, 0.00000, 0.93638),
                (0.31373, 0.00000, 0.94985),
                (0.31373, 0.00000, 0.96332),
                (0.31373, 0.00000, 0.97573),
                (0.40250, 0.05175, 0.86307),
                (0.99189, 0.39528, 0.05813),
                (1.00000, 0.40000, 0.04706),
                (0.84776, 0.30312, 0.04983),
                (0.55402, 0.11438, 0.05319),
                (0.38644, 0.00000, 0.05988),
                (0.40664, 0.00000, 0.07442),
                (0.42685, 0.00000, 0.09799),
                (0.44706, 0.00000, 0.12157),
                (0.46727, 0.00000, 0.13841),
                (0.48466, 0.00000, 0.15806),
                (0.50376, 0.00000, 0.17827),
                (0.52397, 0.00000, 0.20018),
                (0.54417, 0.00000, 0.22261),
                (0.56438, 0.00000, 0.24281),
                (0.58459, 0.00000, 0.26302),
                (0.60480, 0.00000, 0.28323),
                (0.62501, 0.00000, 0.30344),
                (0.64521, 0.00000, 0.32364),
                (0.66542, 0.00000, 0.34385),
                (0.68563, 0.00000, 0.36406),
                (0.70584, 0.00000, 0.38491),
                (0.72604, 0.00000, 0.40840),
                (0.74625, 0.00000, 0.42860),
                (0.76937, 0.00000, 0.44881),
                (0.79059, 0.00000, 0.46667),
                (0.81260, 0.00000, 0.48711),
                (0.83493, 0.00000, 0.50944),
                (0.85513, 0.00000, 0.52964),
                (0.87576, 0.00000, 0.54985),
                (0.90607, 0.00000, 0.57006),
                (0.93933, 0.00000, 0.59027),
                (0.96821, 0.00000, 0.61047),
                (0.98777, 0.00000, 0.63068),
                (0.99737, 0.00000, 0.65089),
                (1.00000, 0.00000, 0.67110),
                (1.00000, 0.00092, 0.69149),
                (1.00000, 0.01776, 0.71506),
                (1.00000, 0.03760, 0.73564),
                (1.00000, 0.05781, 0.75585),
                (1.00000, 0.07802, 0.77606),
                (1.00000, 0.09822, 0.79626),
                (1.00000, 0.11922, 0.81647),
                (1.00000, 0.14279, 0.83668),
                (1.00000, 0.16637, 0.85689),
                (1.00000, 0.18690, 0.88014),
                (1.00000, 0.20960, 0.90122),
                (1.00000, 0.23124, 0.92143),
                (1.00000, 0.25144, 0.94164),
                (1.00000, 0.27165, 0.96185),
                (1.00000, 0.29214, 0.98178),
                (1.00000, 0.31571, 0.99862),
                (1.00000, 0.33310, 0.98454),
                (1.00000, 0.35248, 0.96517),
                (1.00000, 0.37269, 0.94496),
                (1.00000, 0.39290, 0.92332),
                (1.00000, 0.41223, 0.89974),
                (1.00000, 0.42907, 0.87649),
                (1.00000, 0.44591, 0.85628),
                (1.00000, 0.46588, 0.83294),
                (1.00000, 0.48609, 0.81195),
                (1.00000, 0.50630, 0.79174),
                (1.00000, 0.52503, 0.77006),
                (1.00000, 0.54279, 0.74740),
                (1.00000, 0.56263, 0.72720),
                (1.00000, 0.57947, 0.70699),
                (1.00000, 0.59949, 0.68360),
                (1.00000, 0.61707, 0.66265),
                (1.00000, 0.62976, 0.64037),
                (1.00000, 0.63682, 0.61831),
                (1.00000, 0.63922, 0.59811),
                (1.00000, 0.63922, 0.57790),
                (1.00000, 0.63922, 0.55769),
                (1.00000, 0.63922, 0.53425),
                (1.00000, 0.63922, 0.51335),
                (1.00000, 0.63922, 0.49102),
                (1.00000, 0.63922, 0.46902),
                (1.00000, 0.63922, 0.44881),
                (1.00000, 0.63922, 0.42860),
                (1.00000, 0.63922, 0.40839),
                (1.00000, 0.63922, 0.38491),
                (1.00000, 0.63922, 0.36406),
                (1.00000, 0.63922, 0.34168),
                (0.99838, 0.63922, 0.31972),
                (0.99077, 0.63922, 0.29845),
                (0.97241, 0.63922, 0.27589),
                (0.94546, 0.63922, 0.25905),
                (0.91520, 0.63922, 0.23557),
                (0.88489, 0.63922, 0.21476),
                (0.85457, 0.63922, 0.19234),
                (0.82426, 0.63922, 0.16876),
                (0.79395, 0.63922, 0.14629),
                (0.76309, 0.63922, 0.12664),
                (0.72941, 0.63922, 0.10980),
                (0.70583, 0.63922, 0.08622),
                (0.69070, 0.63922, 0.06265),
                (0.67949, 0.63922, 0.04133),
                (0.67793, 0.64092, 0.02113),
                (0.68582, 0.64545, 0.00554),
                (0.69772, 0.65278, 0.00000),
                (0.71793, 0.66307, 0.00000),
                (0.73814, 0.68665, 0.00000),
                (0.75834, 0.71022, 0.00000),
                (0.77855, 0.73380, 0.00000),
                (0.79876, 0.75738, 0.00000),
                (0.81897, 0.78095, 0.00000),
                (0.83982, 0.80517, 0.00000),
                (0.86330, 0.83202, 0.00000),
                (0.88351, 0.85560, 0.00000),
                (0.90372, 0.88208, 0.00000),
                (0.92393, 0.90667, 0.00000),
                (0.94413, 0.93025, 0.00000),
                (0.96434, 0.95382, 0.00000),
                (0.98386, 0.97740, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00305),
                (1.00000, 1.00000, 0.01638),
                (1.00000, 1.00000, 0.03322),
                (1.00000, 1.00000, 0.05006),
                (1.00000, 1.00000, 0.06773),
                (1.00000, 1.00000, 0.08794),
                (1.00000, 1.00000, 0.10815),
                (1.00000, 1.00000, 0.12526),
                (1.00000, 1.00000, 0.14464),
                (1.00000, 1.00000, 0.16485),
                (1.00000, 1.00000, 0.18506),
                (1.00000, 1.00000, 0.20439),
                (1.00000, 1.00000, 0.22155),
                (1.00000, 1.00000, 0.24176),
                (1.00000, 1.00000, 0.25883),
                (1.00000, 1.00000, 0.27567),
                (1.00000, 1.00000, 0.28642),
                (1.00000, 1.00000, 0.28872),
                (1.00000, 1.00000, 0.28350),
                (1.00000, 1.00000, 0.27229),
                (1.00000, 1.00000, 0.25208),
                (1.00000, 1.00000, 0.22869),
                (1.00000, 1.00000, 0.20511),
                (1.00000, 1.00000, 0.18154),
                (1.00000, 1.00000, 0.15796),
                (1.00000, 1.00000, 0.13536),
                (1.00000, 1.00000, 0.11473),
                (1.00000, 1.00000, 0.09116),
                (1.00000, 1.00000, 0.06435),
                (1.00000, 1.00000, 0.04008),
                (1.00000, 1.00000, 0.02076),
                (1.00000, 1.00000, 0.00706),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.09305),
                (1.00000, 1.00000, 0.33136),
                (1.00000, 1.00000, 0.60966),
                (1.00000, 1.00000, 0.83605),
                (0.96674, 1.00000, 0.96343),
                (0.75749, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
        )

cmap_rainbow = (
                (0.00000, 0.00000, 0.16471),  # noqa
                (0.02745, 0.00000, 0.18431),
                (0.05882, 0.00000, 0.20000),
                (0.08627, 0.00000, 0.21961),
                (0.11373, 0.00000, 0.23922),
                (0.14510, 0.00000, 0.25882),
                (0.17647, 0.00000, 0.27843),
                (0.20392, 0.00000, 0.29804),
                (0.23137, 0.00000, 0.31765),
                (0.26275, 0.00000, 0.33725),
                (0.29412, 0.00000, 0.35686),
                (0.32157, 0.00000, 0.37647),
                (0.35294, 0.00000, 0.39608),
                (0.38039, 0.00000, 0.41569),
                (0.41176, 0.00000, 0.43529),
                (0.43922, 0.00000, 0.45490),
                (0.47059, 0.00000, 0.47451),
                (0.49804, 0.00000, 0.49412),
                (0.52941, 0.00000, 0.51373),
                (0.55686, 0.00000, 0.53725),
                (0.58824, 0.00000, 0.55686),
                (0.55686, 0.00000, 0.57647),
                (0.52941, 0.00000, 0.59608),
                (0.49804, 0.00000, 0.61569),
                (0.47059, 0.00000, 0.63922),
                (0.43922, 0.00000, 0.65882),
                (0.41176, 0.00000, 0.67843),
                (0.38039, 0.00000, 0.70196),
                (0.35294, 0.00000, 0.72157),
                (0.32157, 0.00000, 0.74118),
                (0.29412, 0.00000, 0.76471),
                (0.26275, 0.00000, 0.78431),
                (0.23137, 0.00000, 0.80392),
                (0.20392, 0.00000, 0.82745),
                (0.17647, 0.00000, 0.84706),
                (0.14510, 0.00000, 0.87059),
                (0.11373, 0.00000, 0.89020),
                (0.08627, 0.00000, 0.91373),
                (0.05882, 0.00000, 0.93333),
                (0.02745, 0.00000, 0.95686),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.02353, 0.97647),
                (0.00000, 0.04706, 0.95686),
                (0.00000, 0.06275, 0.93333),
                (0.00000, 0.08235, 0.91373),
                (0.00000, 0.09804, 0.89020),
                (0.00000, 0.11373, 0.87059),
                (0.00000, 0.12941, 0.84706),
                (0.00000, 0.14118, 0.82745),
                (0.00000, 0.15686, 0.80392),
                (0.00000, 0.16863, 0.78431),
                (0.00000, 0.18431, 0.76471),
                (0.00000, 0.19608, 0.74118),
                (0.00000, 0.21176, 0.72157),
                (0.00000, 0.22353, 0.70196),
                (0.00000, 0.23529, 0.67843),
                (0.00000, 0.25098, 0.65882),
                (0.00000, 0.26275, 0.63922),
                (0.00000, 0.27451, 0.61569),
                (0.00000, 0.28627, 0.59608),
                (0.00000, 0.29804, 0.57647),
                (0.00000, 0.30980, 0.55686),
                (0.00000, 0.32157, 0.53725),
                (0.00000, 0.33333, 0.51373),
                (0.00000, 0.34510, 0.49412),
                (0.00000, 0.35686, 0.47451),
                (0.00000, 0.36863, 0.45490),
                (0.00000, 0.38039, 0.43529),
                (0.00000, 0.39216, 0.41569),
                (0.00000, 0.40392, 0.39608),
                (0.00000, 0.41176, 0.37647),
                (0.00000, 0.42353, 0.35686),
                (0.00000, 0.43529, 0.33725),
                (0.00000, 0.44706, 0.31765),
                (0.00000, 0.45882, 0.29804),
                (0.00000, 0.46667, 0.27843),
                (0.00000, 0.47843, 0.25882),
                (0.00000, 0.49020, 0.23922),
                (0.00000, 0.49804, 0.21961),
                (0.00000, 0.50980, 0.20000),
                (0.00000, 0.52157, 0.18431),
                (0.00000, 0.52941, 0.16471),
                (0.00000, 0.54118, 0.14510),
                (0.00000, 0.55294, 0.12941),
                (0.00000, 0.56078, 0.10980),
                (0.00000, 0.57255, 0.09412),
                (0.00000, 0.58431, 0.07451),
                (0.00000, 0.59216, 0.05882),
                (0.00000, 0.60392, 0.04314),
                (0.00000, 0.61176, 0.02745),
                (0.00000, 0.62353, 0.01176),
                (0.00000, 0.63137, 0.00000),
                (0.00000, 0.64314, 0.00000),
                (0.00000, 0.65098, 0.00000),
                (0.00000, 0.66275, 0.00000),
                (0.00000, 0.67059, 0.00000),
                (0.00000, 0.68235, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.70196, 0.00000),
                (0.00000, 0.70980, 0.00000),
                (0.00000, 0.72157, 0.00000),
                (0.00000, 0.72941, 0.00000),
                (0.00000, 0.74118, 0.00000),
                (0.00000, 0.74902, 0.00000),
                (0.00000, 0.76078, 0.00000),
                (0.00000, 0.76863, 0.00000),
                (0.00000, 0.77647, 0.00000),
                (0.00000, 0.78824, 0.00000),
                (0.00000, 0.79608, 0.00000),
                (0.00000, 0.80784, 0.00000),
                (0.00000, 0.81569, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.83529, 0.00000),
                (0.00000, 0.84314, 0.00000),
                (0.00000, 0.85490, 0.00000),
                (0.00000, 0.86275, 0.00000),
                (0.00000, 0.87059, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.89020, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.90980, 0.00000),
                (0.00000, 0.91765, 0.00000),
                (0.00000, 0.92549, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.94510, 0.00000),
                (0.00000, 0.95294, 0.00000),
                (0.00000, 0.96078, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.98039, 0.00000),
                (0.00000, 0.98824, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 0.98824, 0.00000),
                (0.00000, 0.98039, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.96078, 0.00000),
                (0.00000, 0.95294, 0.00000),
                (0.00000, 0.94510, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.92549, 0.00000),
                (0.00000, 0.91765, 0.00000),
                (0.00000, 0.90980, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.89020, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.87059, 0.00000),
                (0.00000, 0.86275, 0.00000),
                (0.00000, 0.85490, 0.00000),
                (0.00000, 0.84314, 0.00000),
                (0.00000, 0.83529, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.81569, 0.00000),
                (0.00000, 0.80784, 0.00000),
                (0.00000, 0.79608, 0.00000),
                (0.00000, 0.78824, 0.00000),
                (0.00000, 0.77647, 0.00000),
                (0.00784, 0.76863, 0.00000),
                (0.03529, 0.77647, 0.00000),
                (0.06667, 0.78824, 0.00000),
                (0.09804, 0.80000, 0.00000),
                (0.12941, 0.81176, 0.00000),
                (0.16471, 0.82745, 0.00000),
                (0.20000, 0.84314, 0.00000),
                (0.23529, 0.85882, 0.00000),
                (0.26667, 0.87059, 0.00000),
                (0.30588, 0.89020, 0.00000),
                (0.34118, 0.90196, 0.00000),
                (0.37647, 0.92157, 0.00000),
                (0.41176, 0.93333, 0.00000),
                (0.44706, 0.95294, 0.00000),
                (0.48627, 0.96863, 0.00000),
                (0.52157, 0.98824, 0.00000),
                (0.56078, 1.00000, 0.00000),
                (0.59608, 1.00000, 0.00000),
                (0.63529, 1.00000, 0.00000),
                (0.67059, 1.00000, 0.00000),
                (0.70980, 1.00000, 0.00000),
                (0.74902, 1.00000, 0.00000),
                (0.78431, 1.00000, 0.00000),
                (0.82353, 1.00000, 0.00000),
                (0.85882, 1.00000, 0.00000),
                (0.89804, 1.00000, 0.00000),
                (0.93333, 1.00000, 0.00000),
                (0.97647, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.99608, 1.00000, 0.00000),
                (0.98039, 1.00000, 0.00000),
                (0.96078, 0.97647, 0.00000),
                (0.94510, 0.93725, 0.00000),
                (0.92549, 0.89804, 0.00000),
                (0.90980, 0.85882, 0.00000),
                (0.89412, 0.81961, 0.00000),
                (0.87451, 0.78039, 0.00000),
                (0.85882, 0.74118, 0.00000),
                (0.83922, 0.70196, 0.00000),
                (0.82353, 0.66275, 0.00000),
                (0.80392, 0.62353, 0.00000),
                (0.78824, 0.58431, 0.00000),
                (0.76863, 0.54510, 0.00000),
                (0.75686, 0.50980, 0.00000),
                (0.74118, 0.46667, 0.00000),
                (0.72549, 0.43137, 0.00000),
                (0.70980, 0.39216, 0.00000),
                (0.69412, 0.35294, 0.00000),
                (0.68235, 0.31765, 0.00000),
                (0.66275, 0.27451, 0.00000),
                (0.65098, 0.23922, 0.00000),
                (0.63529, 0.20000, 0.00000),
                (0.62745, 0.16863, 0.00000),
                (0.61569, 0.12941, 0.00000),
                (0.60784, 0.09804, 0.00000),
                (0.61961, 0.08235, 0.00000),
                (0.62745, 0.06275, 0.00000),
                (0.63922, 0.04706, 0.00000),
                (0.64706, 0.02353, 0.00000),
                (0.65882, 0.00000, 0.00000),
                (0.66667, 0.00000, 0.00000),
                (0.67843, 0.00000, 0.00000),
                (0.68627, 0.00000, 0.00000),
                (0.69804, 0.00000, 0.00000),
                (0.70980, 0.00000, 0.00000),
                (0.71765, 0.00000, 0.00000),
                (0.72941, 0.00000, 0.00000),
                (0.73725, 0.00000, 0.00000),
                (0.74902, 0.00000, 0.00000),
                (0.75686, 0.00000, 0.00000),
                (0.76863, 0.00000, 0.00000),
                (0.77647, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.80000, 0.00784, 0.00784),
                (0.80784, 0.02745, 0.02745),
                (0.81961, 0.05098, 0.05098),
                (0.82745, 0.08235, 0.08235),
                (0.83922, 0.11373, 0.11373),
                (0.84706, 0.14902, 0.14902),
                (0.85882, 0.19216, 0.19216),
                (0.86667, 0.23137, 0.23137),
                (0.87843, 0.27843, 0.27843),
                (0.88627, 0.32549, 0.32549),
                (0.89804, 0.37647, 0.37647),
                (0.90980, 0.43137, 0.43137),
                (0.91765, 0.48627, 0.48627),
                (0.92941, 0.54118, 0.54118),
                (0.93725, 0.60000, 0.60000),
                (0.94902, 0.66275, 0.66275),
                (0.95686, 0.72549, 0.72549),
                (0.96863, 0.79216, 0.79216),
                (0.97647, 0.85882, 0.85882),
                (0.98824, 0.92941, 0.92941),
                (1.00000, 1.00000, 1.00000),
        )

cmap_manycol = (
                (0.34902, 0.34902, 0.34902),  # noqa
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.34902, 0.34902, 0.34902),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.44706, 0.78431, 0.92549),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 0.69020, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.72549, 0.00000, 0.72549),
                (0.72549, 0.00000, 0.72549),
        )

cmap_gray = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00392, 0.00392, 0.00392),
                (0.00784, 0.00784, 0.00784),
                (0.01176, 0.01176, 0.01176),
                (0.01569, 0.01569, 0.01569),
                (0.01961, 0.01961, 0.01961),
                (0.02353, 0.02353, 0.02353),
                (0.02745, 0.02745, 0.02745),
                (0.03137, 0.03137, 0.03137),
                (0.03529, 0.03529, 0.03529),
                (0.03922, 0.03922, 0.03922),
                (0.04314, 0.04314, 0.04314),
                (0.04706, 0.04706, 0.04706),
                (0.05098, 0.05098, 0.05098),
                (0.05490, 0.05490, 0.05490),
                (0.05882, 0.05882, 0.05882),
                (0.06275, 0.06275, 0.06275),
                (0.06667, 0.06667, 0.06667),
                (0.07059, 0.07059, 0.07059),
                (0.07451, 0.07451, 0.07451),
                (0.07843, 0.07843, 0.07843),
                (0.08235, 0.08235, 0.08235),
                (0.08627, 0.08627, 0.08627),
                (0.09020, 0.09020, 0.09020),
                (0.09412, 0.09412, 0.09412),
                (0.09804, 0.09804, 0.09804),
                (0.10196, 0.10196, 0.10196),
                (0.10588, 0.10588, 0.10588),
                (0.10980, 0.10980, 0.10980),
                (0.11373, 0.11373, 0.11373),
                (0.11765, 0.11765, 0.11765),
                (0.12157, 0.12157, 0.12157),
                (0.12549, 0.12549, 0.12549),
                (0.12941, 0.12941, 0.12941),
                (0.13333, 0.13333, 0.13333),
                (0.13725, 0.13725, 0.13725),
                (0.14118, 0.14118, 0.14118),
                (0.14510, 0.14510, 0.14510),
                (0.14902, 0.14902, 0.14902),
                (0.15294, 0.15294, 0.15294),
                (0.15686, 0.15686, 0.15686),
                (0.16078, 0.16078, 0.16078),
                (0.16471, 0.16471, 0.16471),
                (0.16863, 0.16863, 0.16863),
                (0.17255, 0.17255, 0.17255),
                (0.17647, 0.17647, 0.17647),
                (0.18039, 0.18039, 0.18039),
                (0.18431, 0.18431, 0.18431),
                (0.18824, 0.18824, 0.18824),
                (0.19216, 0.19216, 0.19216),
                (0.19608, 0.19608, 0.19608),
                (0.20000, 0.20000, 0.20000),
                (0.20392, 0.20392, 0.20392),
                (0.20784, 0.20784, 0.20784),
                (0.21176, 0.21176, 0.21176),
                (0.21569, 0.21569, 0.21569),
                (0.21961, 0.21961, 0.21961),
                (0.22353, 0.22353, 0.22353),
                (0.22745, 0.22745, 0.22745),
                (0.23137, 0.23137, 0.23137),
                (0.23529, 0.23529, 0.23529),
                (0.23922, 0.23922, 0.23922),
                (0.24314, 0.24314, 0.24314),
                (0.24706, 0.24706, 0.24706),
                (0.25098, 0.25098, 0.25098),
                (0.25490, 0.25490, 0.25490),
                (0.25882, 0.25882, 0.25882),
                (0.26275, 0.26275, 0.26275),
                (0.26667, 0.26667, 0.26667),
                (0.27059, 0.27059, 0.27059),
                (0.27451, 0.27451, 0.27451),
                (0.27843, 0.27843, 0.27843),
                (0.28235, 0.28235, 0.28235),
                (0.28627, 0.28627, 0.28627),
                (0.29020, 0.29020, 0.29020),
                (0.29412, 0.29412, 0.29412),
                (0.29804, 0.29804, 0.29804),
                (0.30196, 0.30196, 0.30196),
                (0.30588, 0.30588, 0.30588),
                (0.30980, 0.30980, 0.30980),
                (0.31373, 0.31373, 0.31373),
                (0.31765, 0.31765, 0.31765),
                (0.32157, 0.32157, 0.32157),
                (0.32549, 0.32549, 0.32549),
                (0.32941, 0.32941, 0.32941),
                (0.33333, 0.33333, 0.33333),
                (0.33725, 0.33725, 0.33725),
                (0.34118, 0.34118, 0.34118),
                (0.34510, 0.34510, 0.34510),
                (0.34902, 0.34902, 0.34902),
                (0.35294, 0.35294, 0.35294),
                (0.35686, 0.35686, 0.35686),
                (0.36078, 0.36078, 0.36078),
                (0.36471, 0.36471, 0.36471),
                (0.36863, 0.36863, 0.36863),
                (0.37255, 0.37255, 0.37255),
                (0.37647, 0.37647, 0.37647),
                (0.38039, 0.38039, 0.38039),
                (0.38431, 0.38431, 0.38431),
                (0.38824, 0.38824, 0.38824),
                (0.39216, 0.39216, 0.39216),
                (0.39608, 0.39608, 0.39608),
                (0.40000, 0.40000, 0.40000),
                (0.40392, 0.40392, 0.40392),
                (0.40784, 0.40784, 0.40784),
                (0.41176, 0.41176, 0.41176),
                (0.41569, 0.41569, 0.41569),
                (0.41961, 0.41961, 0.41961),
                (0.42353, 0.42353, 0.42353),
                (0.42745, 0.42745, 0.42745),
                (0.43137, 0.43137, 0.43137),
                (0.43529, 0.43529, 0.43529),
                (0.43922, 0.43922, 0.43922),
                (0.44314, 0.44314, 0.44314),
                (0.44706, 0.44706, 0.44706),
                (0.45098, 0.45098, 0.45098),
                (0.45490, 0.45490, 0.45490),
                (0.45882, 0.45882, 0.45882),
                (0.46275, 0.46275, 0.46275),
                (0.46667, 0.46667, 0.46667),
                (0.47059, 0.47059, 0.47059),
                (0.47451, 0.47451, 0.47451),
                (0.47843, 0.47843, 0.47843),
                (0.48235, 0.48235, 0.48235),
                (0.48627, 0.48627, 0.48627),
                (0.49020, 0.49020, 0.49020),
                (0.49412, 0.49412, 0.49412),
                (0.49804, 0.49804, 0.49804),
                (0.50196, 0.50196, 0.50196),
                (0.50588, 0.50588, 0.50588),
                (0.50980, 0.50980, 0.50980),
                (0.51373, 0.51373, 0.51373),
                (0.51765, 0.51765, 0.51765),
                (0.52157, 0.52157, 0.52157),
                (0.52549, 0.52549, 0.52549),
                (0.52941, 0.52941, 0.52941),
                (0.53333, 0.53333, 0.53333),
                (0.53725, 0.53725, 0.53725),
                (0.54118, 0.54118, 0.54118),
                (0.54510, 0.54510, 0.54510),
                (0.54902, 0.54902, 0.54902),
                (0.55294, 0.55294, 0.55294),
                (0.55686, 0.55686, 0.55686),
                (0.56078, 0.56078, 0.56078),
                (0.56471, 0.56471, 0.56471),
                (0.56863, 0.56863, 0.56863),
                (0.57255, 0.57255, 0.57255),
                (0.57647, 0.57647, 0.57647),
                (0.58039, 0.58039, 0.58039),
                (0.58431, 0.58431, 0.58431),
                (0.58824, 0.58824, 0.58824),
                (0.59608, 0.59608, 0.59608),
                (0.60000, 0.60000, 0.60000),
                (0.59608, 0.59608, 0.59608),
                (0.60392, 0.60392, 0.60392),
                (0.60784, 0.60784, 0.60784),
                (0.61176, 0.61176, 0.61176),
                (0.61569, 0.61569, 0.61569),
                (0.61961, 0.61961, 0.61961),
                (0.62353, 0.62353, 0.62353),
                (0.62745, 0.62745, 0.62745),
                (0.63137, 0.63137, 0.63137),
                (0.63529, 0.63529, 0.63529),
                (0.63922, 0.63922, 0.63922),
                (0.64314, 0.64314, 0.64314),
                (0.64706, 0.64706, 0.64706),
                (0.65098, 0.65098, 0.65098),
                (0.65490, 0.65490, 0.65490),
                (0.65882, 0.65882, 0.65882),
                (0.66275, 0.66275, 0.66275),
                (0.66667, 0.66667, 0.66667),
                (0.67059, 0.67059, 0.67059),
                (0.67451, 0.67451, 0.67451),
                (0.67843, 0.67843, 0.67843),
                (0.68235, 0.68235, 0.68235),
                (0.68627, 0.68627, 0.68627),
                (0.69020, 0.69020, 0.69020),
                (0.69412, 0.69412, 0.69412),
                (0.69804, 0.69804, 0.69804),
                (0.70196, 0.70196, 0.70196),
                (0.70588, 0.70588, 0.70588),
                (0.70980, 0.70980, 0.70980),
                (0.71373, 0.71373, 0.71373),
                (0.71765, 0.71765, 0.71765),
                (0.72157, 0.72157, 0.72157),
                (0.72549, 0.72549, 0.72549),
                (0.72941, 0.72941, 0.72941),
                (0.73333, 0.73333, 0.73333),
                (0.73725, 0.73725, 0.73725),
                (0.74118, 0.74118, 0.74118),
                (0.74510, 0.74510, 0.74510),
                (0.74902, 0.74902, 0.74902),
                (0.75294, 0.75294, 0.75294),
                (0.75686, 0.75686, 0.75686),
                (0.76078, 0.76078, 0.76078),
                (0.76471, 0.76471, 0.76471),
                (0.76863, 0.76863, 0.76863),
                (0.77255, 0.77255, 0.77255),
                (0.77647, 0.77647, 0.77647),
                (0.78039, 0.78039, 0.78039),
                (0.78431, 0.78431, 0.78431),
                (0.78824, 0.78824, 0.78824),
                (0.79216, 0.79216, 0.79216),
                (0.79608, 0.79608, 0.79608),
                (0.80000, 0.80000, 0.80000),
                (0.80392, 0.80392, 0.80392),
                (0.80784, 0.80784, 0.80784),
                (0.81176, 0.81176, 0.81176),
                (0.81569, 0.81569, 0.81569),
                (0.81961, 0.81961, 0.81961),
                (0.82353, 0.82353, 0.82353),
                (0.82745, 0.82745, 0.82745),
                (0.83137, 0.83137, 0.83137),
                (0.83529, 0.83529, 0.83529),
                (0.83922, 0.83922, 0.83922),
                (0.84314, 0.84314, 0.84314),
                (0.84706, 0.84706, 0.84706),
                (0.85098, 0.85098, 0.85098),
                (0.85490, 0.85490, 0.85490),
                (0.85882, 0.85882, 0.85882),
                (0.86275, 0.86275, 0.86275),
                (0.86667, 0.86667, 0.86667),
                (0.87059, 0.87059, 0.87059),
                (0.87451, 0.87451, 0.87451),
                (0.87843, 0.87843, 0.87843),
                (0.88235, 0.88235, 0.88235),
                (0.88627, 0.88627, 0.88627),
                (0.89020, 0.89020, 0.89020),
                (0.89412, 0.89412, 0.89412),
                (0.89804, 0.89804, 0.89804),
                (0.90196, 0.90196, 0.90196),
                (0.90588, 0.90588, 0.90588),
                (0.90980, 0.90980, 0.90980),
                (0.91373, 0.91373, 0.91373),
                (0.91765, 0.91765, 0.91765),
                (0.92157, 0.92157, 0.92157),
                (0.92549, 0.92549, 0.92549),
                (0.92941, 0.92941, 0.92941),
                (0.93333, 0.93333, 0.93333),
                (0.93725, 0.93725, 0.93725),
                (0.94118, 0.94118, 0.94118),
                (0.94510, 0.94510, 0.94510),
                (0.94902, 0.94902, 0.94902),
                (0.95294, 0.95294, 0.95294),
                (0.95686, 0.95686, 0.95686),
                (0.96078, 0.96078, 0.96078),
                (0.96471, 0.96471, 0.96471),
                (0.96863, 0.96863, 0.96863),
                (0.97255, 0.97255, 0.97255),
                (0.97647, 0.97647, 0.97647),
                (0.98039, 0.98039, 0.98039),
                (0.98431, 0.98431, 0.98431),
                (0.98824, 0.98824, 0.98824),
                (0.99216, 0.99216, 0.99216),
                (0.99608, 0.99608, 0.99608),
                (1.00000, 1.00000, 1.00000),
        )

cmap_grayclip = (
    # Like gray, but shows clipping of top and bottom 5%
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.01961, 0.01961, 0.01961),
                (0.02353, 0.02353, 0.02353),
                (0.02745, 0.02745, 0.02745),
                (0.03137, 0.03137, 0.03137),
                (0.03529, 0.03529, 0.03529),
                (0.03922, 0.03922, 0.03922),
                (0.04314, 0.04314, 0.04314),
                (0.04706, 0.04706, 0.04706),
                (0.05098, 0.05098, 0.05098),
                (0.05490, 0.05490, 0.05490),
                (0.05882, 0.05882, 0.05882),
                (0.06275, 0.06275, 0.06275),
                (0.06667, 0.06667, 0.06667),
                (0.07059, 0.07059, 0.07059),
                (0.07451, 0.07451, 0.07451),
                (0.07843, 0.07843, 0.07843),
                (0.08235, 0.08235, 0.08235),
                (0.08627, 0.08627, 0.08627),
                (0.09020, 0.09020, 0.09020),
                (0.09412, 0.09412, 0.09412),
                (0.09804, 0.09804, 0.09804),
                (0.10196, 0.10196, 0.10196),
                (0.10588, 0.10588, 0.10588),
                (0.10980, 0.10980, 0.10980),
                (0.11373, 0.11373, 0.11373),
                (0.11765, 0.11765, 0.11765),
                (0.12157, 0.12157, 0.12157),
                (0.12549, 0.12549, 0.12549),
                (0.12941, 0.12941, 0.12941),
                (0.13333, 0.13333, 0.13333),
                (0.13725, 0.13725, 0.13725),
                (0.14118, 0.14118, 0.14118),
                (0.14510, 0.14510, 0.14510),
                (0.14902, 0.14902, 0.14902),
                (0.15294, 0.15294, 0.15294),
                (0.15686, 0.15686, 0.15686),
                (0.16078, 0.16078, 0.16078),
                (0.16471, 0.16471, 0.16471),
                (0.16863, 0.16863, 0.16863),
                (0.17255, 0.17255, 0.17255),
                (0.17647, 0.17647, 0.17647),
                (0.18039, 0.18039, 0.18039),
                (0.18431, 0.18431, 0.18431),
                (0.18824, 0.18824, 0.18824),
                (0.19216, 0.19216, 0.19216),
                (0.19608, 0.19608, 0.19608),
                (0.20000, 0.20000, 0.20000),
                (0.20392, 0.20392, 0.20392),
                (0.20784, 0.20784, 0.20784),
                (0.21176, 0.21176, 0.21176),
                (0.21569, 0.21569, 0.21569),
                (0.21961, 0.21961, 0.21961),
                (0.22353, 0.22353, 0.22353),
                (0.22745, 0.22745, 0.22745),
                (0.23137, 0.23137, 0.23137),
                (0.23529, 0.23529, 0.23529),
                (0.23922, 0.23922, 0.23922),
                (0.24314, 0.24314, 0.24314),
                (0.24706, 0.24706, 0.24706),
                (0.25098, 0.25098, 0.25098),
                (0.25490, 0.25490, 0.25490),
                (0.25882, 0.25882, 0.25882),
                (0.26275, 0.26275, 0.26275),
                (0.26667, 0.26667, 0.26667),
                (0.27059, 0.27059, 0.27059),
                (0.27451, 0.27451, 0.27451),
                (0.27843, 0.27843, 0.27843),
                (0.28235, 0.28235, 0.28235),
                (0.28627, 0.28627, 0.28627),
                (0.29020, 0.29020, 0.29020),
                (0.29412, 0.29412, 0.29412),
                (0.29804, 0.29804, 0.29804),
                (0.30196, 0.30196, 0.30196),
                (0.30588, 0.30588, 0.30588),
                (0.30980, 0.30980, 0.30980),
                (0.31373, 0.31373, 0.31373),
                (0.31765, 0.31765, 0.31765),
                (0.32157, 0.32157, 0.32157),
                (0.32549, 0.32549, 0.32549),
                (0.32941, 0.32941, 0.32941),
                (0.33333, 0.33333, 0.33333),
                (0.33725, 0.33725, 0.33725),
                (0.34118, 0.34118, 0.34118),
                (0.34510, 0.34510, 0.34510),
                (0.34902, 0.34902, 0.34902),
                (0.35294, 0.35294, 0.35294),
                (0.35686, 0.35686, 0.35686),
                (0.36078, 0.36078, 0.36078),
                (0.36471, 0.36471, 0.36471),
                (0.36863, 0.36863, 0.36863),
                (0.37255, 0.37255, 0.37255),
                (0.37647, 0.37647, 0.37647),
                (0.38039, 0.38039, 0.38039),
                (0.38431, 0.38431, 0.38431),
                (0.38824, 0.38824, 0.38824),
                (0.39216, 0.39216, 0.39216),
                (0.39608, 0.39608, 0.39608),
                (0.40000, 0.40000, 0.40000),
                (0.40392, 0.40392, 0.40392),
                (0.40784, 0.40784, 0.40784),
                (0.41176, 0.41176, 0.41176),
                (0.41569, 0.41569, 0.41569),
                (0.41961, 0.41961, 0.41961),
                (0.42353, 0.42353, 0.42353),
                (0.42745, 0.42745, 0.42745),
                (0.43137, 0.43137, 0.43137),
                (0.43529, 0.43529, 0.43529),
                (0.43922, 0.43922, 0.43922),
                (0.44314, 0.44314, 0.44314),
                (0.44706, 0.44706, 0.44706),
                (0.45098, 0.45098, 0.45098),
                (0.45490, 0.45490, 0.45490),
                (0.45882, 0.45882, 0.45882),
                (0.46275, 0.46275, 0.46275),
                (0.46667, 0.46667, 0.46667),
                (0.47059, 0.47059, 0.47059),
                (0.47451, 0.47451, 0.47451),
                (0.47843, 0.47843, 0.47843),
                (0.48235, 0.48235, 0.48235),
                (0.48627, 0.48627, 0.48627),
                (0.49020, 0.49020, 0.49020),
                (0.49412, 0.49412, 0.49412),
                (0.49804, 0.49804, 0.49804),
                (0.50196, 0.50196, 0.50196),
                (0.50588, 0.50588, 0.50588),
                (0.50980, 0.50980, 0.50980),
                (0.51373, 0.51373, 0.51373),
                (0.51765, 0.51765, 0.51765),
                (0.52157, 0.52157, 0.52157),
                (0.52549, 0.52549, 0.52549),
                (0.52941, 0.52941, 0.52941),
                (0.53333, 0.53333, 0.53333),
                (0.53725, 0.53725, 0.53725),
                (0.54118, 0.54118, 0.54118),
                (0.54510, 0.54510, 0.54510),
                (0.54902, 0.54902, 0.54902),
                (0.55294, 0.55294, 0.55294),
                (0.55686, 0.55686, 0.55686),
                (0.56078, 0.56078, 0.56078),
                (0.56471, 0.56471, 0.56471),
                (0.56863, 0.56863, 0.56863),
                (0.57255, 0.57255, 0.57255),
                (0.57647, 0.57647, 0.57647),
                (0.58039, 0.58039, 0.58039),
                (0.58431, 0.58431, 0.58431),
                (0.58824, 0.58824, 0.58824),
                (0.59608, 0.59608, 0.59608),
                (0.60000, 0.60000, 0.60000),
                (0.59608, 0.59608, 0.59608),
                (0.60392, 0.60392, 0.60392),
                (0.60784, 0.60784, 0.60784),
                (0.61176, 0.61176, 0.61176),
                (0.61569, 0.61569, 0.61569),
                (0.61961, 0.61961, 0.61961),
                (0.62353, 0.62353, 0.62353),
                (0.62745, 0.62745, 0.62745),
                (0.63137, 0.63137, 0.63137),
                (0.63529, 0.63529, 0.63529),
                (0.63922, 0.63922, 0.63922),
                (0.64314, 0.64314, 0.64314),
                (0.64706, 0.64706, 0.64706),
                (0.65098, 0.65098, 0.65098),
                (0.65490, 0.65490, 0.65490),
                (0.65882, 0.65882, 0.65882),
                (0.66275, 0.66275, 0.66275),
                (0.66667, 0.66667, 0.66667),
                (0.67059, 0.67059, 0.67059),
                (0.67451, 0.67451, 0.67451),
                (0.67843, 0.67843, 0.67843),
                (0.68235, 0.68235, 0.68235),
                (0.68627, 0.68627, 0.68627),
                (0.69020, 0.69020, 0.69020),
                (0.69412, 0.69412, 0.69412),
                (0.69804, 0.69804, 0.69804),
                (0.70196, 0.70196, 0.70196),
                (0.70588, 0.70588, 0.70588),
                (0.70980, 0.70980, 0.70980),
                (0.71373, 0.71373, 0.71373),
                (0.71765, 0.71765, 0.71765),
                (0.72157, 0.72157, 0.72157),
                (0.72549, 0.72549, 0.72549),
                (0.72941, 0.72941, 0.72941),
                (0.73333, 0.73333, 0.73333),
                (0.73725, 0.73725, 0.73725),
                (0.74118, 0.74118, 0.74118),
                (0.74510, 0.74510, 0.74510),
                (0.74902, 0.74902, 0.74902),
                (0.75294, 0.75294, 0.75294),
                (0.75686, 0.75686, 0.75686),
                (0.76078, 0.76078, 0.76078),
                (0.76471, 0.76471, 0.76471),
                (0.76863, 0.76863, 0.76863),
                (0.77255, 0.77255, 0.77255),
                (0.77647, 0.77647, 0.77647),
                (0.78039, 0.78039, 0.78039),
                (0.78431, 0.78431, 0.78431),
                (0.78824, 0.78824, 0.78824),
                (0.79216, 0.79216, 0.79216),
                (0.79608, 0.79608, 0.79608),
                (0.80000, 0.80000, 0.80000),
                (0.80392, 0.80392, 0.80392),
                (0.80784, 0.80784, 0.80784),
                (0.81176, 0.81176, 0.81176),
                (0.81569, 0.81569, 0.81569),
                (0.81961, 0.81961, 0.81961),
                (0.82353, 0.82353, 0.82353),
                (0.82745, 0.82745, 0.82745),
                (0.83137, 0.83137, 0.83137),
                (0.83529, 0.83529, 0.83529),
                (0.83922, 0.83922, 0.83922),
                (0.84314, 0.84314, 0.84314),
                (0.84706, 0.84706, 0.84706),
                (0.85098, 0.85098, 0.85098),
                (0.85490, 0.85490, 0.85490),
                (0.85882, 0.85882, 0.85882),
                (0.86275, 0.86275, 0.86275),
                (0.86667, 0.86667, 0.86667),
                (0.87059, 0.87059, 0.87059),
                (0.87451, 0.87451, 0.87451),
                (0.87843, 0.87843, 0.87843),
                (0.88235, 0.88235, 0.88235),
                (0.88627, 0.88627, 0.88627),
                (0.89020, 0.89020, 0.89020),
                (0.89412, 0.89412, 0.89412),
                (0.89804, 0.89804, 0.89804),
                (0.90196, 0.90196, 0.90196),
                (0.90588, 0.90588, 0.90588),
                (0.90980, 0.90980, 0.90980),
                (0.91373, 0.91373, 0.91373),
                (0.91765, 0.91765, 0.91765),
                (0.92157, 0.92157, 0.92157),
                (0.92549, 0.92549, 0.92549),
                (0.92941, 0.92941, 0.92941),
                (0.93333, 0.93333, 0.93333),
                (0.93725, 0.93725, 0.93725),
                (0.94118, 0.94118, 0.94118),
                (0.94510, 0.94510, 0.94510),
                (0.94902, 0.94902, 0.94902),
                (0.95294, 0.95294, 0.95294),
                (0.95686, 0.95686, 0.95686),
                (0.96078, 0.96078, 0.96078),
                (0.96471, 0.96471, 0.96471),
                (0.96863, 0.96863, 0.96863),
                (0.97255, 0.97255, 0.97255),
                (0.97647, 0.97647, 0.97647),
                (0.98039, 0.98039, 0.98039),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
)

cmap_pastel = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 1.00000),
                (0.01961, 0.00000, 0.98039),
                (0.05490, 0.00000, 0.94510),
                (0.08627, 0.00392, 0.91373),
                (0.10980, 0.00392, 0.89020),
                (0.13725, 0.00392, 0.86275),
                (0.15686, 0.00392, 0.84314),
                (0.18039, 0.00392, 0.81961),
                (0.20000, 0.00784, 0.80000),
                (0.21569, 0.00784, 0.78431),
                (0.23529, 0.00784, 0.76471),
                (0.25098, 0.00784, 0.74902),
                (0.26275, 0.01176, 0.73725),
                (0.28235, 0.01176, 0.71765),
                (0.29412, 0.01176, 0.70588),
                (0.30588, 0.01176, 0.69412),
                (0.31765, 0.01176, 0.68235),
                (0.33333, 0.01569, 0.66667),
                (0.34118, 0.01569, 0.65882),
                (0.35294, 0.01569, 0.64706),
                (0.36078, 0.01569, 0.63922),
                (0.37255, 0.01961, 0.62745),
                (0.38431, 0.01961, 0.61569),
                (0.39216, 0.01961, 0.60784),
                (0.40000, 0.01961, 0.60000),
                (0.41176, 0.02353, 0.58824),
                (0.41961, 0.02353, 0.58039),
                (0.43137, 0.02353, 0.56863),
                (0.43529, 0.02745, 0.56471),
                (0.44314, 0.02745, 0.55686),
                (0.45098, 0.02745, 0.54902),
                (0.45882, 0.02745, 0.54118),
                (0.46667, 0.03137, 0.53333),
                (0.47059, 0.03137, 0.52941),
                (0.48235, 0.03137, 0.51765),
                (0.48627, 0.03529, 0.51373),
                (0.49412, 0.03529, 0.50588),
                (0.50196, 0.03529, 0.49804),
                (0.50588, 0.03529, 0.49412),
                (0.50980, 0.04314, 0.49020),
                (0.51765, 0.04314, 0.48235),
                (0.52157, 0.04314, 0.47843),
                (0.53333, 0.04706, 0.46667),
                (0.53725, 0.04706, 0.46275),
                (0.54118, 0.04706, 0.45882),
                (0.54902, 0.05098, 0.45098),
                (0.55294, 0.05098, 0.44706),
                (0.55686, 0.05098, 0.44314),
                (0.56078, 0.05490, 0.43922),
                (0.56471, 0.05490, 0.43529),
                (0.57255, 0.05490, 0.42745),
                (0.58039, 0.05882, 0.41961),
                (0.58431, 0.05882, 0.41569),
                (0.58824, 0.05882, 0.41176),
                (0.59216, 0.06275, 0.40784),
                (0.59608, 0.06275, 0.40392),
                (0.60000, 0.06275, 0.40000),
                (0.60392, 0.06667, 0.39608),
                (0.60784, 0.06667, 0.39216),
                (0.61176, 0.06667, 0.38824),
                (0.61569, 0.07059, 0.38431),
                (0.61961, 0.07059, 0.38039),
                (0.62745, 0.07451, 0.37255),
                (0.63137, 0.07451, 0.36863),
                (0.63529, 0.07451, 0.36471),
                (0.63922, 0.07843, 0.36078),
                (0.64314, 0.07843, 0.35686),
                (0.64706, 0.08235, 0.35294),
                (0.65098, 0.08235, 0.34902),
                (0.65490, 0.08235, 0.34510),
                (0.65490, 0.08627, 0.34510),
                (0.65882, 0.08627, 0.34118),
                (0.66275, 0.09020, 0.33725),
                (0.66667, 0.09020, 0.33333),
                (0.67059, 0.09020, 0.32941),
                (0.67843, 0.09412, 0.32157),
                (0.67843, 0.09412, 0.32157),
                (0.68235, 0.09804, 0.31765),
                (0.68627, 0.09804, 0.31373),
                (0.69020, 0.10196, 0.30980),
                (0.69020, 0.10196, 0.30980),
                (0.69412, 0.10588, 0.30588),
                (0.69804, 0.10588, 0.30196),
                (0.70196, 0.10980, 0.29804),
                (0.70196, 0.10980, 0.29804),
                (0.70588, 0.10980, 0.29412),
                (0.70980, 0.11765, 0.29020),
                (0.71373, 0.11765, 0.28627),
                (0.71373, 0.12157, 0.28627),
                (0.71765, 0.12157, 0.28235),
                (0.72157, 0.12549, 0.27843),
                (0.72157, 0.12549, 0.27843),
                (0.72941, 0.12941, 0.27059),
                (0.73333, 0.12941, 0.26667),
                (0.73333, 0.13333, 0.26667),
                (0.73725, 0.13725, 0.26275),
                (0.74118, 0.13725, 0.25882),
                (0.74118, 0.14118, 0.25882),
                (0.74510, 0.14118, 0.25490),
                (0.74510, 0.14510, 0.25490),
                (0.74902, 0.14510, 0.25098),
                (0.75294, 0.14902, 0.24706),
                (0.75294, 0.14902, 0.24706),
                (0.75686, 0.15294, 0.24314),
                (0.76078, 0.15686, 0.23922),
                (0.76078, 0.15686, 0.23922),
                (0.76471, 0.16078, 0.23529),
                (0.76471, 0.16078, 0.23529),
                (0.76863, 0.16471, 0.23137),
                (0.76863, 0.16863, 0.23137),
                (0.77255, 0.16863, 0.22745),
                (0.78039, 0.17255, 0.21961),
                (0.78039, 0.17255, 0.21961),
                (0.78431, 0.17647, 0.21569),
                (0.78431, 0.18039, 0.21569),
                (0.78824, 0.18039, 0.21176),
                (0.78824, 0.18431, 0.21176),
                (0.79216, 0.18824, 0.20784),
                (0.79216, 0.18824, 0.20784),
                (0.79608, 0.19608, 0.20392),
                (0.79608, 0.20000, 0.20392),
                (0.80000, 0.20000, 0.20000),
                (0.80000, 0.20392, 0.20000),
                (0.80392, 0.20784, 0.19608),
                (0.80392, 0.20784, 0.19608),
                (0.80784, 0.21176, 0.19216),
                (0.80784, 0.21569, 0.19216),
                (0.81176, 0.21961, 0.18824),
                (0.81176, 0.21961, 0.18824),
                (0.81569, 0.22353, 0.18431),
                (0.81569, 0.22745, 0.18431),
                (0.81961, 0.23137, 0.18039),
                (0.81961, 0.23137, 0.18039),
                (0.82745, 0.23529, 0.17255),
                (0.82745, 0.23922, 0.17255),
                (0.83137, 0.24314, 0.16863),
                (0.83137, 0.24314, 0.16863),
                (0.83529, 0.24706, 0.16471),
                (0.83529, 0.25098, 0.16471),
                (0.83922, 0.25490, 0.16078),
                (0.83922, 0.25882, 0.16078),
                (0.83922, 0.26275, 0.16078),
                (0.84314, 0.26275, 0.15686),
                (0.84314, 0.27059, 0.15686),
                (0.84706, 0.27451, 0.15294),
                (0.84706, 0.27843, 0.15294),
                (0.85098, 0.28235, 0.14902),
                (0.85098, 0.28627, 0.14902),
                (0.85490, 0.29020, 0.14510),
                (0.85490, 0.29412, 0.14510),
                (0.85490, 0.29804, 0.14510),
                (0.85882, 0.29804, 0.14118),
                (0.85882, 0.30196, 0.14118),
                (0.86275, 0.30588, 0.13725),
                (0.86275, 0.30980, 0.13725),
                (0.86275, 0.31373, 0.13725),
                (0.86667, 0.31765, 0.13333),
                (0.86667, 0.32157, 0.13333),
                (0.87059, 0.32549, 0.12941),
                (0.87059, 0.33333, 0.12941),
                (0.87059, 0.33725, 0.12941),
                (0.87843, 0.34118, 0.12157),
                (0.87843, 0.34510, 0.12157),
                (0.88235, 0.34902, 0.11765),
                (0.88235, 0.35294, 0.11765),
                (0.88235, 0.35686, 0.11765),
                (0.88627, 0.36078, 0.11373),
                (0.88627, 0.36471, 0.11373),
                (0.89020, 0.37255, 0.10980),
                (0.89020, 0.37647, 0.10980),
                (0.89020, 0.38039, 0.10980),
                (0.89412, 0.38431, 0.10588),
                (0.89412, 0.38824, 0.10588),
                (0.89412, 0.39216, 0.10588),
                (0.89804, 0.40000, 0.10196),
                (0.89804, 0.40392, 0.10196),
                (0.89804, 0.40784, 0.10196),
                (0.90196, 0.41176, 0.09804),
                (0.90196, 0.41961, 0.09804),
                (0.90588, 0.42353, 0.09412),
                (0.90588, 0.42745, 0.09412),
                (0.90588, 0.43529, 0.09412),
                (0.90980, 0.43922, 0.09020),
                (0.90980, 0.44314, 0.09020),
                (0.90980, 0.45098, 0.09020),
                (0.91373, 0.45490, 0.08627),
                (0.91373, 0.45882, 0.08627),
                (0.91373, 0.46667, 0.08627),
                (0.91765, 0.47059, 0.08235),
                (0.91765, 0.47843, 0.08235),
                (0.91765, 0.48235, 0.08235),
                (0.92157, 0.49020, 0.07843),
                (0.92157, 0.49412, 0.07843),
                (0.92157, 0.50196, 0.07843),
                (0.92941, 0.50588, 0.07059),
                (0.92941, 0.51373, 0.07059),
                (0.92941, 0.51765, 0.07059),
                (0.93333, 0.52549, 0.06667),
                (0.93333, 0.52941, 0.06667),
                (0.93333, 0.53725, 0.06667),
                (0.93725, 0.54118, 0.06275),
                (0.93725, 0.54902, 0.06275),
                (0.93725, 0.55686, 0.06275),
                (0.94118, 0.56078, 0.05882),
                (0.94118, 0.56863, 0.05882),
                (0.94118, 0.57647, 0.05882),
                (0.94118, 0.58039, 0.05882),
                (0.94510, 0.58824, 0.05490),
                (0.94510, 0.59608, 0.05490),
                (0.94510, 0.60000, 0.05490),
                (0.94902, 0.60784, 0.05098),
                (0.94902, 0.61569, 0.05098),
                (0.94902, 0.62353, 0.05098),
                (0.95294, 0.63137, 0.04706),
                (0.95294, 0.63529, 0.04706),
                (0.95294, 0.64314, 0.04706),
                (0.95686, 0.65098, 0.04314),
                (0.95686, 0.65882, 0.04314),
                (0.95686, 0.66667, 0.04314),
                (0.95686, 0.67451, 0.04314),
                (0.96078, 0.68235, 0.03922),
                (0.96078, 0.69020, 0.03922),
                (0.96078, 0.69804, 0.03922),
                (0.96471, 0.70588, 0.03529),
                (0.96471, 0.71373, 0.03529),
                (0.96471, 0.72157, 0.03529),
                (0.96471, 0.72941, 0.03529),
                (0.96863, 0.73725, 0.03137),
                (0.96863, 0.74510, 0.03137),
                (0.96863, 0.75294, 0.03137),
                (0.97255, 0.76078, 0.02745),
                (0.97255, 0.77255, 0.02745),
                (0.97255, 0.78039, 0.02745),
                (0.97255, 0.78824, 0.02745),
                (0.98039, 0.79608, 0.01961),
                (0.98039, 0.80392, 0.01961),
                (0.98039, 0.81569, 0.01961),
                (0.98039, 0.82353, 0.01961),
                (0.98431, 0.83137, 0.01569),
                (0.98431, 0.84314, 0.01569),
                (0.98431, 0.85098, 0.01569),
                (0.98824, 0.86275, 0.01176),
                (0.98824, 0.87059, 0.01176),
                (0.98824, 0.87843, 0.01176),
                (0.98824, 0.89020, 0.01176),
                (0.99216, 0.89804, 0.00784),
                (0.99216, 0.90980, 0.00784),
                (0.99216, 0.91765, 0.00784),
                (0.99216, 0.92941, 0.00784),
                (0.99608, 0.94118, 0.00392),
                (0.99608, 0.94902, 0.00392),
                (0.99608, 0.96078, 0.00392),
                (0.99608, 0.97255, 0.00392),
                (1.00000, 0.98039, 0.00000),
                (1.00000, 0.99216, 0.00000),
        )

cmap_light = (
                (0.00000, 0.00392, 0.00000),  # noqa
                (0.00000, 0.00784, 0.01961),
                (0.00000, 0.01176, 0.05490),
                (0.00000, 0.01569, 0.08627),
                (0.00000, 0.01961, 0.10980),
                (0.00000, 0.02353, 0.13725),
                (0.00000, 0.02745, 0.15686),
                (0.00000, 0.03137, 0.18039),
                (0.00000, 0.03529, 0.20000),
                (0.00000, 0.03922, 0.21569),
                (0.00000, 0.04314, 0.23529),
                (0.00000, 0.04706, 0.25098),
                (0.00000, 0.05098, 0.26275),
                (0.00000, 0.05490, 0.28235),
                (0.00000, 0.05882, 0.29412),
                (0.00000, 0.06275, 0.30588),
                (0.00000, 0.06667, 0.31765),
                (0.00000, 0.07059, 0.33333),
                (0.00000, 0.07451, 0.34118),
                (0.00000, 0.07843, 0.35294),
                (0.00000, 0.08235, 0.36078),
                (0.00000, 0.08627, 0.37255),
                (0.00000, 0.09020, 0.38431),
                (0.00000, 0.09412, 0.39216),
                (0.00392, 0.09804, 0.40000),
                (0.00784, 0.10196, 0.41176),
                (0.01176, 0.10588, 0.41961),
                (0.01569, 0.10980, 0.43137),
                (0.01569, 0.11373, 0.43529),
                (0.01961, 0.11765, 0.44314),
                (0.02353, 0.12157, 0.45098),
                (0.02745, 0.12549, 0.45882),
                (0.02745, 0.12941, 0.46667),
                (0.03137, 0.13333, 0.47059),
                (0.03529, 0.13725, 0.48235),
                (0.04314, 0.14118, 0.48627),
                (0.04706, 0.14510, 0.49412),
                (0.05098, 0.14902, 0.50196),
                (0.05882, 0.15294, 0.50588),
                (0.06667, 0.15686, 0.50980),
                (0.07451, 0.16078, 0.51765),
                (0.08235, 0.16471, 0.52157),
                (0.09020, 0.16863, 0.53333),
                (0.09804, 0.17255, 0.53725),
                (0.10588, 0.17647, 0.54118),
                (0.11765, 0.18039, 0.54902),
                (0.12941, 0.18431, 0.55294),
                (0.14118, 0.18824, 0.55686),
                (0.15294, 0.19216, 0.56078),
                (0.16471, 0.19608, 0.56471),
                (0.18039, 0.20000, 0.57255),
                (0.18824, 0.20392, 0.58039),
                (0.20000, 0.20784, 0.58431),
                (0.21569, 0.21176, 0.58824),
                (0.23137, 0.21569, 0.59216),
                (0.24706, 0.21961, 0.59608),
                (0.26275, 0.22353, 0.60000),
                (0.27843, 0.22745, 0.60392),
                (0.29412, 0.23137, 0.60784),
                (0.30980, 0.23529, 0.61176),
                (0.32941, 0.23922, 0.61569),
                (0.34902, 0.24314, 0.61961),
                (0.36863, 0.24706, 0.62745),
                (0.38431, 0.25098, 0.63137),
                (0.40392, 0.25490, 0.63529),
                (0.41569, 0.25882, 0.63922),
                (0.43529, 0.26275, 0.64314),
                (0.45490, 0.26667, 0.64706),
                (0.47059, 0.27059, 0.65098),
                (0.48627, 0.27451, 0.65490),
                (0.50196, 0.27843, 0.65490),
                (0.51765, 0.28235, 0.65882),
                (0.52941, 0.28627, 0.66275),
                (0.54902, 0.29020, 0.66667),
                (0.56471, 0.29412, 0.67059),
                (0.58039, 0.29804, 0.67843),
                (0.59216, 0.30196, 0.67843),
                (0.60392, 0.30588, 0.68235),
                (0.61961, 0.30980, 0.68627),
                (0.63137, 0.31373, 0.69020),
                (0.63922, 0.31765, 0.69020),
                (0.65098, 0.32157, 0.69412),
                (0.65882, 0.32549, 0.69804),
                (0.67059, 0.32941, 0.70196),
                (0.67843, 0.33333, 0.70196),
                (0.69020, 0.33725, 0.70588),
                (0.69804, 0.34118, 0.70980),
                (0.70588, 0.34510, 0.71373),
                (0.71373, 0.34902, 0.71373),
                (0.72157, 0.35294, 0.71765),
                (0.72941, 0.35686, 0.72157),
                (0.73725, 0.36078, 0.72157),
                (0.74510, 0.36471, 0.72941),
                (0.75294, 0.36863, 0.73333),
                (0.76078, 0.37255, 0.73333),
                (0.76863, 0.37647, 0.73725),
                (0.77647, 0.38039, 0.74118),
                (0.78039, 0.38431, 0.74118),
                (0.78824, 0.38824, 0.74510),
                (0.79608, 0.39216, 0.74510),
                (0.80392, 0.39608, 0.74902),
                (0.80784, 0.40000, 0.75294),
                (0.81176, 0.40392, 0.75294),
                (0.81961, 0.40784, 0.75686),
                (0.82353, 0.41176, 0.76078),
                (0.82745, 0.41569, 0.76078),
                (0.83529, 0.41961, 0.76471),
                (0.83922, 0.42353, 0.76471),
                (0.84314, 0.42745, 0.76863),
                (0.84706, 0.43137, 0.76863),
                (0.85098, 0.43529, 0.77255),
                (0.85490, 0.43922, 0.78039),
                (0.85882, 0.44314, 0.78039),
                (0.86275, 0.44706, 0.78431),
                (0.86667, 0.45098, 0.78431),
                (0.87059, 0.45490, 0.78824),
                (0.87451, 0.45882, 0.78824),
                (0.87843, 0.46275, 0.79216),
                (0.88235, 0.46667, 0.79216),
                (0.88627, 0.47059, 0.79608),
                (0.89020, 0.47451, 0.79608),
                (0.89412, 0.47843, 0.80000),
                (0.89804, 0.48235, 0.80000),
                (0.89804, 0.48627, 0.80392),
                (0.90196, 0.49020, 0.80392),
                (0.90588, 0.49412, 0.80784),
                (0.90980, 0.49804, 0.80784),
                (0.91373, 0.50196, 0.81176),
                (0.91373, 0.50588, 0.81176),
                (0.91765, 0.50980, 0.81569),
                (0.92157, 0.51373, 0.81569),
                (0.92157, 0.51765, 0.81961),
                (0.92549, 0.52157, 0.81961),
                (0.92941, 0.52549, 0.82745),
                (0.92941, 0.52941, 0.82745),
                (0.93333, 0.53333, 0.83137),
                (0.93725, 0.53725, 0.83137),
                (0.93725, 0.54118, 0.83529),
                (0.93725, 0.54510, 0.83529),
                (0.94118, 0.54902, 0.83922),
                (0.94118, 0.55294, 0.83922),
                (0.94510, 0.55686, 0.83922),
                (0.94510, 0.56078, 0.84314),
                (0.94902, 0.56471, 0.84314),
                (0.94902, 0.56863, 0.84706),
                (0.95294, 0.57255, 0.84706),
                (0.95294, 0.57647, 0.85098),
                (0.95294, 0.58039, 0.85098),
                (0.95686, 0.58431, 0.85490),
                (0.95686, 0.58824, 0.85490),
                (0.96078, 0.59216, 0.85490),
                (0.96078, 0.59608, 0.85882),
                (0.96078, 0.60000, 0.85882),
                (0.96471, 0.60392, 0.86275),
                (0.96471, 0.60784, 0.86275),
                (0.96471, 0.61176, 0.86275),
                (0.96863, 0.61569, 0.86667),
                (0.96863, 0.61961, 0.86667),
                (0.97255, 0.62353, 0.87059),
                (0.97255, 0.62745, 0.87059),
                (0.97255, 0.63137, 0.87059),
                (0.97647, 0.63529, 0.87843),
                (0.97647, 0.63922, 0.87843),
                (0.98039, 0.64314, 0.88235),
                (0.98039, 0.64706, 0.88235),
                (0.98039, 0.65098, 0.88235),
                (0.98431, 0.65490, 0.88627),
                (0.98431, 0.65882, 0.88627),
                (0.98431, 0.66275, 0.89020),
                (0.98824, 0.66667, 0.89020),
                (0.98824, 0.67059, 0.89020),
                (0.98824, 0.67451, 0.89412),
                (0.99216, 0.67843, 0.89412),
                (0.99216, 0.68235, 0.89412),
                (0.99216, 0.68627, 0.89804),
                (0.99216, 0.69020, 0.89804),
                (0.99216, 0.69412, 0.89804),
                (0.99608, 0.69804, 0.90196),
                (0.99608, 0.70196, 0.90196),
                (0.99608, 0.70588, 0.90588),
                (0.99608, 0.70980, 0.90588),
                (0.99608, 0.71373, 0.90588),
                (0.99608, 0.71765, 0.90980),
                (0.99608, 0.72157, 0.90980),
                (0.99608, 0.72549, 0.90980),
                (0.99608, 0.72941, 0.91373),
                (0.99608, 0.73333, 0.91373),
                (0.99608, 0.73725, 0.91373),
                (0.99608, 0.74118, 0.91765),
                (0.99608, 0.74510, 0.91765),
                (0.99608, 0.74902, 0.91765),
                (0.99608, 0.75294, 0.92157),
                (0.99608, 0.75686, 0.92157),
                (0.99608, 0.76078, 0.92157),
                (0.99608, 0.76471, 0.92941),
                (0.99608, 0.76863, 0.92941),
                (0.99608, 0.77255, 0.92941),
                (0.99608, 0.77647, 0.93333),
                (0.99608, 0.78039, 0.93333),
                (0.99608, 0.78431, 0.93333),
                (0.99608, 0.78824, 0.93725),
                (1.00000, 0.79216, 0.93725),
                (1.00000, 0.79608, 0.93725),
                (1.00000, 0.80000, 0.94118),
                (1.00000, 0.80392, 0.94118),
                (1.00000, 0.80784, 0.94118),
                (1.00000, 0.81176, 0.94118),
                (1.00000, 0.81569, 0.94510),
                (1.00000, 0.81961, 0.94510),
                (1.00000, 0.82353, 0.94510),
                (1.00000, 0.82745, 0.94902),
                (1.00000, 0.83137, 0.94902),
                (1.00000, 0.83529, 0.94902),
                (1.00000, 0.83922, 0.95294),
                (1.00000, 0.84314, 0.95294),
                (1.00000, 0.84706, 0.95294),
                (1.00000, 0.85098, 0.95686),
                (1.00000, 0.85490, 0.95686),
                (1.00000, 0.85882, 0.95686),
                (1.00000, 0.86275, 0.95686),
                (1.00000, 0.86667, 0.96078),
                (1.00000, 0.87059, 0.96078),
                (1.00000, 0.87451, 0.96078),
                (1.00000, 0.87843, 0.96471),
                (1.00000, 0.88235, 0.96471),
                (1.00000, 0.88627, 0.96471),
                (1.00000, 0.89020, 0.96471),
                (1.00000, 0.89412, 0.96863),
                (1.00000, 0.89804, 0.96863),
                (1.00000, 0.90196, 0.96863),
                (1.00000, 0.90588, 0.97255),
                (1.00000, 0.90980, 0.97255),
                (1.00000, 0.91373, 0.97255),
                (1.00000, 0.91765, 0.97255),
                (1.00000, 0.92157, 0.98039),
                (1.00000, 0.92549, 0.98039),
                (1.00000, 0.92941, 0.98039),
                (1.00000, 0.93333, 0.98039),
                (1.00000, 0.93725, 0.98431),
                (1.00000, 0.94118, 0.98431),
                (1.00000, 0.94510, 0.98431),
                (1.00000, 0.94902, 0.98824),
                (1.00000, 0.95294, 0.98824),
                (1.00000, 0.95686, 0.98824),
                (1.00000, 0.96078, 0.98824),
                (1.00000, 0.96471, 0.99216),
                (1.00000, 0.96863, 0.99216),
                (1.00000, 0.97255, 0.99216),
                (1.00000, 0.97647, 0.99216),
                (1.00000, 0.98039, 0.99608),
                (1.00000, 0.98431, 0.99608),
                (1.00000, 0.98824, 0.99608),
                (1.00000, 0.99216, 0.99608),
                (1.00000, 0.99608, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_random1 = (
                (0.00000, 0.00000, 0.16471),  # noqa
                (0.00000, 0.00000, 0.16471),
                (0.00000, 0.00000, 0.16471),
                (0.00000, 0.00000, 0.16471),
                (0.00000, 0.00000, 0.16471),
                (0.00000, 0.00000, 0.16471),
                (0.00000, 0.00000, 0.16471),
                (0.00000, 0.00000, 0.16471),
                (0.23137, 0.00000, 0.31765),
                (0.23137, 0.00000, 0.31765),
                (0.23137, 0.00000, 0.31765),
                (0.23137, 0.00000, 0.31765),
                (0.23137, 0.00000, 0.31765),
                (0.23137, 0.00000, 0.31765),
                (0.23137, 0.00000, 0.31765),
                (0.23137, 0.00000, 0.31765),
                (0.47059, 0.00000, 0.47451),
                (0.47059, 0.00000, 0.47451),
                (0.47059, 0.00000, 0.47451),
                (0.47059, 0.00000, 0.47451),
                (0.47059, 0.00000, 0.47451),
                (0.47059, 0.00000, 0.47451),
                (0.47059, 0.00000, 0.47451),
                (0.47059, 0.00000, 0.47451),
                (0.47059, 0.00000, 0.63922),
                (0.47059, 0.00000, 0.63922),
                (0.47059, 0.00000, 0.63922),
                (0.47059, 0.00000, 0.63922),
                (0.47059, 0.00000, 0.63922),
                (0.47059, 0.00000, 0.63922),
                (0.47059, 0.00000, 0.63922),
                (0.47059, 0.00000, 0.63922),
                (0.23137, 0.00000, 0.80392),
                (0.23137, 0.00000, 0.80392),
                (0.23137, 0.00000, 0.80392),
                (0.23137, 0.00000, 0.80392),
                (0.23137, 0.00000, 0.80392),
                (0.23137, 0.00000, 0.80392),
                (0.23137, 0.00000, 0.80392),
                (0.23137, 0.00000, 0.80392),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.05098, 0.85098),
                (0.00000, 0.05098, 0.85098),
                (0.00000, 0.05098, 0.85098),
                (0.00000, 0.05098, 0.85098),
                (0.00000, 0.05098, 0.85098),
                (0.00000, 0.05098, 0.85098),
                (0.00000, 0.05098, 0.85098),
                (0.00000, 0.05098, 0.85098),
                (0.00000, 0.19608, 0.69412),
                (0.00000, 0.19608, 0.69412),
                (0.00000, 0.19608, 0.69412),
                (0.00000, 0.19608, 0.69412),
                (0.00000, 0.19608, 0.69412),
                (0.00000, 0.19608, 0.69412),
                (0.00000, 0.19608, 0.69412),
                (0.00000, 0.19608, 0.69412),
                (0.00000, 0.33333, 0.56471),
                (0.00000, 0.33333, 0.56471),
                (0.00000, 0.33333, 0.56471),
                (0.00000, 0.33333, 0.56471),
                (0.00000, 0.33333, 0.56471),
                (0.00000, 0.33333, 0.56471),
                (0.00000, 0.33333, 0.56471),
                (0.00000, 0.33333, 0.56471),
                (0.00000, 0.42353, 0.44706),
                (0.00000, 0.42353, 0.44706),
                (0.00000, 0.42353, 0.44706),
                (0.00000, 0.42353, 0.44706),
                (0.00000, 0.42353, 0.44706),
                (0.00000, 0.42353, 0.44706),
                (0.00000, 0.42353, 0.44706),
                (0.00000, 0.42353, 0.44706),
                (0.00000, 0.50980, 0.35294),
                (0.00000, 0.50980, 0.35294),
                (0.00000, 0.50980, 0.35294),
                (0.00000, 0.50980, 0.35294),
                (0.00000, 0.50980, 0.35294),
                (0.00000, 0.50980, 0.35294),
                (0.00000, 0.50980, 0.35294),
                (0.00000, 0.50980, 0.35294),
                (0.00000, 0.59216, 0.25882),
                (0.00000, 0.59216, 0.25882),
                (0.00000, 0.59216, 0.25882),
                (0.00000, 0.59216, 0.25882),
                (0.00000, 0.59216, 0.25882),
                (0.00000, 0.59216, 0.25882),
                (0.00000, 0.59216, 0.25882),
                (0.00000, 0.59216, 0.25882),
                (0.00000, 0.67059, 0.16471),
                (0.00000, 0.67059, 0.16471),
                (0.00000, 0.67059, 0.16471),
                (0.00000, 0.67059, 0.16471),
                (0.00000, 0.67059, 0.16471),
                (0.00000, 0.67059, 0.16471),
                (0.00000, 0.67059, 0.16471),
                (0.00000, 0.67059, 0.16471),
                (0.00000, 0.74902, 0.05490),
                (0.00000, 0.74902, 0.05490),
                (0.00000, 0.74902, 0.05490),
                (0.00000, 0.74902, 0.05490),
                (0.00000, 0.74902, 0.05490),
                (0.00000, 0.74902, 0.05490),
                (0.00000, 0.74902, 0.05490),
                (0.00000, 0.74902, 0.05490),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.05490, 0.95294, 0.00000),
                (0.05490, 0.95294, 0.00000),
                (0.05490, 0.95294, 0.00000),
                (0.05490, 0.95294, 0.00000),
                (0.05490, 0.95294, 0.00000),
                (0.05490, 0.95294, 0.00000),
                (0.05490, 0.95294, 0.00000),
                (0.05490, 0.95294, 0.00000),
                (0.14902, 0.88235, 0.00000),
                (0.14902, 0.88235, 0.00000),
                (0.14902, 0.88235, 0.00000),
                (0.14902, 0.88235, 0.00000),
                (0.14902, 0.88235, 0.00000),
                (0.14902, 0.88235, 0.00000),
                (0.14902, 0.88235, 0.00000),
                (0.14902, 0.88235, 0.00000),
                (0.41176, 0.80784, 0.00000),
                (0.41176, 0.80784, 0.00000),
                (0.41176, 0.80784, 0.00000),
                (0.41176, 0.80784, 0.00000),
                (0.41176, 0.80784, 0.00000),
                (0.41176, 0.80784, 0.00000),
                (0.41176, 0.80784, 0.00000),
                (0.41176, 0.80784, 0.00000),
                (0.70980, 0.81176, 0.00000),
                (0.70980, 0.81176, 0.00000),
                (0.70980, 0.81176, 0.00000),
                (0.70980, 0.81176, 0.00000),
                (0.70980, 0.81176, 0.00000),
                (0.70980, 0.81176, 0.00000),
                (0.70980, 0.81176, 0.00000),
                (0.70980, 0.81176, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.09804, 0.00000),
                (1.00000, 0.09804, 0.00000),
                (1.00000, 0.09804, 0.00000),
                (1.00000, 0.09804, 0.00000),
                (1.00000, 0.09804, 0.00000),
                (1.00000, 0.09804, 0.00000),
                (1.00000, 0.09804, 0.00000),
                (1.00000, 0.09804, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
        )

cmap_random2 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.47059, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.62745, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 0.78431, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 1.00000, 0.00392),
                (0.00392, 0.86275, 0.47059),
                (0.00392, 0.86275, 0.47059),
                (0.00392, 0.86275, 0.47059),
                (0.00392, 0.86275, 0.47059),
                (0.00392, 0.86275, 0.47059),
                (0.00392, 0.86275, 0.47059),
                (0.00392, 0.86275, 0.47059),
                (0.00392, 0.86275, 0.47059),
                (0.00392, 0.86275, 0.47059),
                (0.00392, 0.86275, 0.47059),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.78431, 0.62745),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.70588, 0.78431),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.47059, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.23529, 0.00392, 1.00000),
                (0.47059, 0.00392, 0.78431),
                (0.47059, 0.00392, 0.78431),
                (0.47059, 0.00392, 0.78431),
                (0.47059, 0.00392, 0.78431),
                (0.47059, 0.00392, 0.78431),
                (0.47059, 0.00392, 0.78431),
                (0.47059, 0.00392, 0.78431),
                (0.47059, 0.00392, 0.78431),
                (0.47059, 0.00392, 0.78431),
                (0.47059, 0.00392, 0.78431),
                (0.62745, 0.00392, 0.62745),
                (0.62745, 0.00392, 0.62745),
                (0.62745, 0.00392, 0.62745),
                (0.62745, 0.00392, 0.62745),
                (0.62745, 0.00392, 0.62745),
                (0.62745, 0.00392, 0.62745),
                (0.62745, 0.00392, 0.62745),
                (0.62745, 0.00392, 0.62745),
                (0.62745, 0.00392, 0.62745),
                (0.62745, 0.00392, 0.62745),
                (0.78431, 0.00392, 0.47059),
                (0.78431, 0.00392, 0.47059),
                (0.78431, 0.00392, 0.47059),
                (0.78431, 0.00392, 0.47059),
                (0.78431, 0.00392, 0.47059),
                (0.78431, 0.00392, 0.47059),
                (0.78431, 0.00392, 0.47059),
                (0.78431, 0.00392, 0.47059),
                (0.78431, 0.00392, 0.47059),
                (0.78431, 0.00392, 0.47059),
                (0.90196, 0.11765, 0.23529),
                (0.90196, 0.11765, 0.23529),
                (0.90196, 0.11765, 0.23529),
                (0.90196, 0.11765, 0.23529),
                (0.90196, 0.11765, 0.23529),
                (0.90196, 0.11765, 0.23529),
                (0.90196, 0.11765, 0.23529),
                (0.90196, 0.11765, 0.23529),
                (0.90196, 0.11765, 0.23529),
                (0.90196, 0.11765, 0.23529),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.23529, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.99216, 0.59608, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.90196, 0.00000),
                (0.98039, 0.98039, 0.47059),
                (0.98039, 0.98039, 0.47059),
                (0.98039, 0.98039, 0.47059),
                (0.98039, 0.98039, 0.47059),
                (0.98039, 0.98039, 0.47059),
                (0.98039, 0.98039, 0.47059),
                (0.98039, 0.98039, 0.47059),
                (0.98039, 0.98039, 0.47059),
                (0.98039, 0.98039, 0.47059),
                (0.98039, 0.98039, 0.47059),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_random3 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_random4 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_random5 = (
                (0.00000, 0.00000, 1.00000),  # noqa
                (0.00000, 0.00000, 0.99216),
                (0.00000, 0.00000, 0.98824),
                (0.00392, 0.00000, 0.98431),
                (0.00392, 0.00000, 0.98039),
                (0.00784, 0.00000, 0.97647),
                (0.00784, 0.00000, 0.96863),
                (0.01176, 0.00000, 0.96471),
                (0.01569, 0.00000, 0.96078),
                (0.01569, 0.00000, 0.95686),
                (0.01961, 0.00000, 0.95294),
                (0.01961, 0.00000, 0.94510),
                (0.02353, 0.00784, 0.94118),
                (0.02745, 0.01569, 0.93725),
                (0.02745, 0.02745, 0.93333),
                (0.03137, 0.03922, 0.92941),
                (0.03529, 0.05098, 0.92157),
                (0.03529, 0.06667, 0.91765),
                (0.03922, 0.08235, 0.91373),
                (0.04314, 0.09804, 0.90980),
                (0.04706, 0.11765, 0.90588),
                (0.04706, 0.09804, 0.90196),
                (0.05098, 0.08235, 0.89412),
                (0.05490, 0.06667, 0.89020),
                (0.05490, 0.05098, 0.88627),
                (0.05882, 0.03922, 0.88235),
                (0.06275, 0.02745, 0.87843),
                (0.06667, 0.01569, 0.87059),
                (0.07059, 0.00784, 0.86667),
                (0.07059, 0.00000, 0.86275),
                (0.07451, 0.00000, 0.85882),
                (0.07843, 0.00392, 0.85490),
                (0.08235, 0.01176, 0.85098),
                (0.08235, 0.02353, 0.84314),
                (0.08627, 0.03922, 0.83922),
                (0.09020, 0.05490, 0.83529),
                (0.09412, 0.07059, 0.83137),
                (0.09804, 0.09020, 0.82745),
                (0.09804, 0.10980, 0.82353),
                (0.10196, 0.13333, 0.81569),
                (0.10588, 0.15686, 0.81176),
                (0.10980, 0.13333, 0.80784),
                (0.11373, 0.10980, 0.80392),
                (0.11765, 0.09020, 0.80000),
                (0.11765, 0.07059, 0.79608),
                (0.12157, 0.05490, 0.79216),
                (0.12549, 0.03922, 0.78431),
                (0.12941, 0.02353, 0.78039),
                (0.13333, 0.01176, 0.77647),
                (0.13725, 0.00392, 0.77255),
                (0.14118, 0.00000, 0.76863),
                (0.14118, 0.00392, 0.76471),
                (0.14510, 0.01569, 0.75686),
                (0.14902, 0.03137, 0.75294),
                (0.15294, 0.04706, 0.74902),
                (0.15686, 0.06667, 0.74510),
                (0.16078, 0.09020, 0.74118),
                (0.16471, 0.11373, 0.73725),
                (0.16863, 0.13725, 0.73333),
                (0.17255, 0.16471, 0.72549),
                (0.17255, 0.19608, 0.72157),
                (0.17647, 0.16471, 0.71765),
                (0.18039, 0.13725, 0.71373),
                (0.18431, 0.11373, 0.70980),
                (0.18824, 0.09020, 0.70588),
                (0.19216, 0.06667, 0.70196),
                (0.19608, 0.04706, 0.69804),
                (0.20000, 0.03137, 0.69020),
                (0.20392, 0.01569, 0.68627),
                (0.20784, 0.00392, 0.68235),
                (0.21176, 0.00000, 0.67843),
                (0.21176, 0.00784, 0.67451),
                (0.21569, 0.02353, 0.67059),
                (0.21961, 0.04314, 0.66667),
                (0.22353, 0.06667, 0.66275),
                (0.22745, 0.09412, 0.65490),
                (0.23137, 0.12549, 0.65098),
                (0.23529, 0.15686, 0.64706),
                (0.23922, 0.19608, 0.64314),
                (0.24314, 0.23137, 0.63922),
                (0.24706, 0.27451, 0.63529),
                (0.25098, 0.23137, 0.63137),
                (0.25490, 0.19608, 0.62745),
                (0.25882, 0.15686, 0.61961),
                (0.26275, 0.12549, 0.61569),
                (0.26667, 0.09412, 0.61176),
                (0.27059, 0.06667, 0.60784),
                (0.27451, 0.04314, 0.60392),
                (0.27843, 0.02353, 0.60000),
                (0.28235, 0.00784, 0.59608),
                (0.28627, 0.00000, 0.59216),
                (0.29020, 0.00784, 0.58824),
                (0.29412, 0.03137, 0.58431),
                (0.29804, 0.05490, 0.57647),
                (0.29804, 0.08627, 0.57255),
                (0.30196, 0.12157, 0.56863),
                (0.30588, 0.16078, 0.56471),
                (0.30980, 0.20392, 0.56078),
                (0.31373, 0.25098, 0.55686),
                (0.31765, 0.29804, 0.55294),
                (0.32157, 0.35294, 0.54902),
                (0.32549, 0.29804, 0.54510),
                (0.32941, 0.25098, 0.54118),
                (0.33333, 0.20392, 0.53725),
                (0.33725, 0.16078, 0.52941),
                (0.34118, 0.12157, 0.52549),
                (0.34510, 0.08627, 0.52157),
                (0.34902, 0.05490, 0.51765),
                (0.35294, 0.03137, 0.51373),
                (0.35686, 0.00784, 0.50980),
                (0.36078, 0.00000, 0.50588),
                (0.36471, 0.01176, 0.50196),
                (0.37255, 0.03529, 0.49804),
                (0.37647, 0.07059, 0.49412),
                (0.38039, 0.10588, 0.49020),
                (0.38431, 0.14902, 0.48627),
                (0.38824, 0.20000, 0.48235),
                (0.39216, 0.25098, 0.47843),
                (0.39608, 0.30588, 0.47059),
                (0.40000, 0.36471, 0.46667),
                (0.40392, 0.43137, 0.46275),
                (0.40784, 0.36471, 0.45882),
                (0.41176, 0.30588, 0.45490),
                (0.41569, 0.25098, 0.45098),
                (0.41961, 0.20000, 0.44706),
                (0.42353, 0.14902, 0.44314),
                (0.42745, 0.10588, 0.43922),
                (0.43137, 0.07059, 0.43529),
                (0.43529, 0.03529, 0.43137),
                (0.43922, 0.01176, 0.42745),
                (0.44314, 0.00000, 0.42353),
                (0.44706, 0.01569, 0.41961),
                (0.45098, 0.04314, 0.41569),
                (0.45490, 0.08235, 0.41176),
                (0.45882, 0.12549, 0.40784),
                (0.46275, 0.17647, 0.40392),
                (0.46667, 0.23529, 0.40000),
                (0.47059, 0.29804, 0.39608),
                (0.47843, 0.36471, 0.39216),
                (0.48235, 0.43137, 0.38824),
                (0.48627, 0.50980, 0.38431),
                (0.49020, 0.43137, 0.38039),
                (0.49412, 0.36471, 0.37647),
                (0.49804, 0.29804, 0.37255),
                (0.50196, 0.23529, 0.36471),
                (0.50588, 0.17647, 0.36078),
                (0.50980, 0.12549, 0.35686),
                (0.51373, 0.08235, 0.35294),
                (0.51765, 0.04314, 0.34902),
                (0.52157, 0.01569, 0.34510),
                (0.52549, 0.00000, 0.34118),
                (0.52941, 0.01569, 0.33725),
                (0.53725, 0.05098, 0.33333),
                (0.54118, 0.09412, 0.32941),
                (0.54510, 0.14510, 0.32549),
                (0.54902, 0.20784, 0.32157),
                (0.55294, 0.27059, 0.31765),
                (0.55686, 0.34118, 0.31373),
                (0.56078, 0.41961, 0.30980),
                (0.56471, 0.50196, 0.30588),
                (0.56863, 0.58824, 0.30196),
                (0.57255, 0.50196, 0.29804),
                (0.57647, 0.41961, 0.29804),
                (0.58431, 0.34118, 0.29412),
                (0.58824, 0.27059, 0.29020),
                (0.59216, 0.20784, 0.28627),
                (0.59608, 0.14510, 0.28235),
                (0.60000, 0.09412, 0.27843),
                (0.60392, 0.05098, 0.27451),
                (0.60784, 0.01569, 0.27059),
                (0.61176, 0.00000, 0.26667),
                (0.61569, 0.01961, 0.26275),
                (0.61961, 0.05882, 0.25882),
                (0.62745, 0.10588, 0.25490),
                (0.63137, 0.16863, 0.25098),
                (0.63529, 0.23529, 0.24706),
                (0.63922, 0.30980, 0.24314),
                (0.64314, 0.38824, 0.23922),
                (0.64706, 0.47451, 0.23529),
                (0.65098, 0.56863, 0.23137),
                (0.65490, 0.66667, 0.22745),
                (0.66275, 0.56863, 0.22353),
                (0.66667, 0.47451, 0.21961),
                (0.67059, 0.38824, 0.21569),
                (0.67451, 0.30980, 0.21176),
                (0.67843, 0.23529, 0.21176),
                (0.68235, 0.16863, 0.20784),
                (0.68627, 0.10588, 0.20392),
                (0.69020, 0.05882, 0.20000),
                (0.69804, 0.01961, 0.19608),
                (0.70196, 0.00000, 0.19216),
                (0.70588, 0.02353, 0.18824),
                (0.70980, 0.06275, 0.18431),
                (0.71373, 0.12157, 0.18039),
                (0.71765, 0.18824, 0.17647),
                (0.72157, 0.26275, 0.17255),
                (0.72549, 0.34510, 0.17255),
                (0.73333, 0.43529, 0.16863),
                (0.73725, 0.52941, 0.16471),
                (0.74118, 0.63529, 0.16078),
                (0.74510, 0.74510, 0.15686),
                (0.74902, 0.63529, 0.15294),
                (0.75294, 0.52941, 0.14902),
                (0.75686, 0.43529, 0.14510),
                (0.76471, 0.34510, 0.14118),
                (0.76863, 0.26275, 0.14118),
                (0.77255, 0.18824, 0.13725),
                (0.77647, 0.12157, 0.13333),
                (0.78039, 0.06275, 0.12941),
                (0.78431, 0.02353, 0.12549),
                (0.79216, 0.00000, 0.12157),
                (0.79608, 0.02353, 0.11765),
                (0.80000, 0.07059, 0.11765),
                (0.80392, 0.13333, 0.11373),
                (0.80784, 0.20784, 0.10980),
                (0.81176, 0.29020, 0.10588),
                (0.81569, 0.38039, 0.10196),
                (0.82353, 0.47843, 0.09804),
                (0.82745, 0.58824, 0.09804),
                (0.83137, 0.70196, 0.09412),
                (0.83529, 0.82353, 0.09020),
                (0.83922, 0.70196, 0.08627),
                (0.84314, 0.58824, 0.08235),
                (0.85098, 0.47843, 0.08235),
                (0.85490, 0.38039, 0.07843),
                (0.85882, 0.29020, 0.07451),
                (0.86275, 0.20784, 0.07059),
                (0.86667, 0.13333, 0.07059),
                (0.87059, 0.07059, 0.06667),
                (0.87843, 0.02353, 0.06275),
                (0.88235, 0.00000, 0.05882),
                (0.88627, 0.02745, 0.05490),
                (0.89020, 0.07843, 0.05490),
                (0.89412, 0.14510, 0.05098),
                (0.90196, 0.22745, 0.04706),
                (0.90588, 0.31765, 0.04706),
                (0.90980, 0.41569, 0.04314),
                (0.91373, 0.52549, 0.03922),
                (0.91765, 0.64314, 0.03529),
                (0.92157, 0.76863, 0.03529),
                (0.92941, 0.90196, 0.03137),
                (0.93333, 0.76863, 0.02745),
                (0.93725, 0.64314, 0.02745),
                (0.94118, 0.52549, 0.02353),
                (0.94510, 0.41569, 0.01961),
                (0.95294, 0.31765, 0.01961),
                (0.95686, 0.25882, 0.01569),
                (0.96078, 0.23137, 0.01569),
                (0.96471, 0.23922, 0.01176),
                (0.96863, 0.27843, 0.00784),
                (0.97647, 0.35294, 0.00784),
                (0.98039, 0.46275, 0.00392),
                (0.98431, 0.58431, 0.00392),
                (0.98824, 0.71373, 0.00000),
                (0.99216, 0.85098, 0.00000),
                (1.00000, 1.00000, 0.00000),
        )

cmap_random6 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.14118, 0.00000),
                (0.00000, 0.28235, 0.00000),
                (0.00000, 0.42353, 0.00000),
                (0.00000, 0.56471, 0.00000),
                (0.00000, 0.70588, 0.00000),
                (0.00000, 0.84706, 0.00000),
                (0.00000, 0.98824, 0.00000),
                (0.00000, 0.00000, 0.14118),
                (0.00000, 0.14118, 0.14118),
                (0.00000, 0.28235, 0.14118),
                (0.00000, 0.42353, 0.14118),
                (0.00000, 0.56471, 0.14118),
                (0.00000, 0.70588, 0.14118),
                (0.00000, 0.84706, 0.14118),
                (0.00000, 0.98824, 0.14118),
                (0.00000, 0.00000, 0.28235),
                (0.00000, 0.14118, 0.28235),
                (0.00000, 0.28235, 0.28235),
                (0.00000, 0.42353, 0.28235),
                (0.00000, 0.56471, 0.28235),
                (0.00000, 0.70588, 0.28235),
                (0.00000, 0.84706, 0.28235),
                (0.00000, 0.98824, 0.28235),
                (0.00000, 0.00000, 0.42353),
                (0.00000, 0.14118, 0.42353),
                (0.00000, 0.28235, 0.42353),
                (0.00000, 0.42353, 0.42353),
                (0.00000, 0.56471, 0.42353),
                (0.00000, 0.70588, 0.42353),
                (0.00000, 0.84706, 0.42353),
                (0.00000, 0.98824, 0.42353),
                (0.00000, 0.00000, 0.56471),
                (0.00000, 0.14118, 0.56471),
                (0.00000, 0.28235, 0.56471),
                (0.00000, 0.42353, 0.56471),
                (0.00000, 0.56471, 0.56471),
                (0.00000, 0.70588, 0.56471),
                (0.00000, 0.84706, 0.56471),
                (0.00000, 0.98824, 0.56471),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.14118, 0.70588),
                (0.00000, 0.28235, 0.70588),
                (0.00000, 0.42353, 0.70588),
                (0.00000, 0.56471, 0.70588),
                (0.00000, 0.70588, 0.70588),
                (0.00000, 0.84706, 0.70588),
                (0.00000, 0.98824, 0.70588),
                (0.00000, 0.00000, 0.84706),
                (0.00000, 0.14118, 0.84706),
                (0.00000, 0.28235, 0.84706),
                (0.00000, 0.42353, 0.84706),
                (0.00000, 0.56471, 0.84706),
                (0.00000, 0.70588, 0.84706),
                (0.00000, 0.84706, 0.84706),
                (0.00000, 0.98824, 0.84706),
                (0.00000, 0.00000, 0.98824),
                (0.00000, 0.14118, 0.98824),
                (0.00000, 0.28235, 0.98824),
                (0.00000, 0.42353, 0.98824),
                (0.00000, 0.56471, 0.98824),
                (0.00000, 0.70588, 0.98824),
                (0.00000, 0.84706, 0.98824),
                (0.00000, 0.98824, 0.98824),
                (0.00000, 0.00000, 0.00000),
                (0.32941, 0.14118, 0.00000),
                (0.32941, 0.28235, 0.00000),
                (0.32941, 0.42353, 0.00000),
                (0.32941, 0.56471, 0.00000),
                (0.32941, 0.70588, 0.00000),
                (0.32941, 0.84706, 0.00000),
                (0.32941, 0.98824, 0.00000),
                (0.32941, 0.00000, 0.14118),
                (0.32941, 0.14118, 0.14118),
                (0.32941, 0.28235, 0.14118),
                (0.32941, 0.42353, 0.14118),
                (0.32941, 0.56471, 0.14118),
                (0.32941, 0.70588, 0.14118),
                (0.32941, 0.84706, 0.14118),
                (0.32941, 0.98824, 0.14118),
                (0.32941, 0.00000, 0.28235),
                (0.32941, 0.14118, 0.28235),
                (0.32941, 0.28235, 0.28235),
                (0.32941, 0.42353, 0.28235),
                (0.32941, 0.56471, 0.28235),
                (0.32941, 0.70588, 0.28235),
                (0.32941, 0.84706, 0.28235),
                (0.32941, 0.98824, 0.28235),
                (0.32941, 0.00000, 0.42353),
                (0.32941, 0.14118, 0.42353),
                (0.32941, 0.28235, 0.42353),
                (0.32941, 0.42353, 0.42353),
                (0.32941, 0.56471, 0.42353),
                (0.32941, 0.70588, 0.42353),
                (0.32941, 0.84706, 0.42353),
                (0.32941, 0.98824, 0.42353),
                (0.32941, 0.00000, 0.56471),
                (0.32941, 0.14118, 0.56471),
                (0.32941, 0.28235, 0.56471),
                (0.32941, 0.42353, 0.56471),
                (0.32941, 0.56471, 0.56471),
                (0.32941, 0.70588, 0.56471),
                (0.32941, 0.84706, 0.56471),
                (0.32941, 0.98824, 0.56471),
                (0.32941, 0.00000, 0.70588),
                (0.32941, 0.14118, 0.70588),
                (0.32941, 0.28235, 0.70588),
                (0.32941, 0.42353, 0.70588),
                (0.32941, 0.56471, 0.70588),
                (0.32941, 0.70588, 0.70588),
                (0.32941, 0.84706, 0.70588),
                (0.32941, 0.98824, 0.70588),
                (0.32941, 0.00000, 0.84706),
                (0.32941, 0.14118, 0.84706),
                (0.32941, 0.28235, 0.84706),
                (0.32941, 0.42353, 0.84706),
                (0.32941, 0.56471, 0.84706),
                (0.32941, 0.70588, 0.84706),
                (0.32941, 0.84706, 0.84706),
                (0.32941, 0.98824, 0.84706),
                (0.32941, 0.00000, 0.98824),
                (0.32941, 0.14118, 0.98824),
                (0.32941, 0.28235, 0.98824),
                (0.32941, 0.42353, 0.98824),
                (0.32941, 0.56471, 0.98824),
                (0.32941, 0.70588, 0.98824),
                (0.32941, 0.84706, 0.98824),
                (0.32941, 0.98824, 0.98824),
                (0.32941, 0.00000, 0.00000),
                (0.65882, 0.14118, 0.00000),
                (0.65882, 0.28235, 0.00000),
                (0.65882, 0.42353, 0.00000),
                (0.65882, 0.56471, 0.00000),
                (0.65882, 0.70588, 0.00000),
                (0.65882, 0.84706, 0.00000),
                (0.65882, 0.98824, 0.00000),
                (0.65882, 0.00000, 0.14118),
                (0.65882, 0.14118, 0.14118),
                (0.65882, 0.28235, 0.14118),
                (0.65882, 0.42353, 0.14118),
                (0.65882, 0.56471, 0.14118),
                (0.65882, 0.70588, 0.14118),
                (0.65882, 0.84706, 0.14118),
                (0.65882, 0.98824, 0.14118),
                (0.65882, 0.00000, 0.28235),
                (0.65882, 0.14118, 0.28235),
                (0.65882, 0.28235, 0.28235),
                (0.65882, 0.42353, 0.28235),
                (0.65882, 0.56471, 0.28235),
                (0.65882, 0.70588, 0.28235),
                (0.65882, 0.84706, 0.28235),
                (0.65882, 0.98824, 0.28235),
                (0.65882, 0.00000, 0.42353),
                (0.65882, 0.14118, 0.42353),
                (0.65882, 0.28235, 0.42353),
                (0.65882, 0.42353, 0.42353),
                (0.65882, 0.56471, 0.42353),
                (0.65882, 0.70588, 0.42353),
                (0.65882, 0.84706, 0.42353),
                (0.65882, 0.98824, 0.42353),
                (0.65882, 0.00000, 0.56471),
                (0.65882, 0.14118, 0.56471),
                (0.65882, 0.28235, 0.56471),
                (0.65882, 0.42353, 0.56471),
                (0.65882, 0.56471, 0.56471),
                (0.65882, 0.70588, 0.56471),
                (0.65882, 0.84706, 0.56471),
                (0.65882, 0.98824, 0.56471),
                (0.65882, 0.00000, 0.70588),
                (0.65882, 0.14118, 0.70588),
                (0.65882, 0.28235, 0.70588),
                (0.65882, 0.42353, 0.70588),
                (0.65882, 0.56471, 0.70588),
                (0.65882, 0.70588, 0.70588),
                (0.65882, 0.84706, 0.70588),
                (0.65882, 0.98824, 0.70588),
                (0.65882, 0.00000, 0.84706),
                (0.65882, 0.14118, 0.84706),
                (0.65882, 0.28235, 0.84706),
                (0.65882, 0.42353, 0.84706),
                (0.65882, 0.56471, 0.84706),
                (0.65882, 0.70588, 0.84706),
                (0.65882, 0.84706, 0.84706),
                (0.65882, 0.98824, 0.84706),
                (0.65882, 0.00000, 0.98824),
                (0.65882, 0.14118, 0.98824),
                (0.65882, 0.28235, 0.98824),
                (0.65882, 0.42353, 0.98824),
                (0.65882, 0.56471, 0.98824),
                (0.65882, 0.70588, 0.98824),
                (0.65882, 0.84706, 0.98824),
                (0.65882, 0.98824, 0.98824),
                (0.65882, 0.00000, 0.00000),
                (0.98824, 0.14118, 0.00000),
                (0.98824, 0.28235, 0.00000),
                (0.98824, 0.42353, 0.00000),
                (0.98824, 0.56471, 0.00000),
                (0.98824, 0.70588, 0.00000),
                (0.98824, 0.84706, 0.00000),
                (0.98824, 0.98824, 0.00000),
                (0.98824, 0.00000, 0.14118),
                (0.98824, 0.14118, 0.14118),
                (0.98824, 0.28235, 0.14118),
                (0.98824, 0.42353, 0.14118),
                (0.98824, 0.56471, 0.14118),
                (0.98824, 0.70588, 0.14118),
                (0.98824, 0.84706, 0.14118),
                (0.98824, 0.98824, 0.14118),
                (0.98824, 0.00000, 0.28235),
                (0.98824, 0.14118, 0.28235),
                (0.98824, 0.28235, 0.28235),
                (0.98824, 0.42353, 0.28235),
                (0.98824, 0.56471, 0.28235),
                (0.98824, 0.70588, 0.28235),
                (0.98824, 0.84706, 0.28235),
                (0.98824, 0.98824, 0.28235),
                (0.98824, 0.00000, 0.42353),
                (0.98824, 0.14118, 0.42353),
                (0.98824, 0.28235, 0.42353),
                (0.98824, 0.42353, 0.42353),
                (0.98824, 0.56471, 0.42353),
                (0.98824, 0.70588, 0.42353),
                (0.98824, 0.84706, 0.42353),
                (0.98824, 0.98824, 0.42353),
                (0.98824, 0.00000, 0.56471),
                (0.98824, 0.14118, 0.56471),
                (0.98824, 0.28235, 0.56471),
                (0.98824, 0.42353, 0.56471),
                (0.98824, 0.56471, 0.56471),
                (0.98824, 0.70588, 0.56471),
                (0.98824, 0.84706, 0.56471),
                (0.98824, 0.98824, 0.56471),
                (0.98824, 0.00000, 0.70588),
                (0.98824, 0.14118, 0.70588),
                (0.98824, 0.28235, 0.70588),
                (0.98824, 0.42353, 0.70588),
                (0.98824, 0.56471, 0.70588),
                (0.98824, 0.70588, 0.70588),
                (0.98824, 0.84706, 0.70588),
                (0.98824, 0.98824, 0.70588),
                (0.98824, 0.00000, 0.84706),
                (0.98824, 0.14118, 0.84706),
                (0.98824, 0.28235, 0.84706),
                (0.98824, 0.42353, 0.84706),
                (0.98824, 0.56471, 0.84706),
                (0.98824, 0.70588, 0.84706),
                (0.98824, 0.84706, 0.84706),
                (0.98824, 0.98824, 0.84706),
                (0.98824, 0.00000, 0.98824),
                (0.98824, 0.14118, 0.98824),
                (0.98824, 0.28235, 0.98824),
                (0.98824, 0.42353, 0.98824),
                (0.98824, 0.56471, 0.98824),
                (0.98824, 0.70588, 0.98824),
                (0.98824, 0.84706, 0.98824),
                (0.98824, 0.98824, 0.98824),
        )

cmap_color = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.18431, 0.18431, 0.18431),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.37255, 0.37255, 0.37255),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.56078, 0.56078, 0.56078),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.74902, 0.74902, 0.74902),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.93725, 0.93725, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.18431, 0.93725),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.37255, 0.74902),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.74902, 0.30980),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.30980, 0.62353, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.49804, 0.49804, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.62353, 0.30980, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
                (0.74902, 0.00000, 0.30980),
        )

cmap_standard = (
                (0.00392, 0.00392, 0.33333),
                (0.00784, 0.00784, 0.34118),
                (0.01176, 0.01176, 0.34902),
                (0.01569, 0.01569, 0.35686),
                (0.01961, 0.01961, 0.36471),
                (0.02353, 0.02353, 0.37255),
                (0.02745, 0.02745, 0.38039),
                (0.03137, 0.03137, 0.38824),
                (0.03529, 0.03529, 0.39608),
                (0.03922, 0.03922, 0.40392),
                (0.04314, 0.04314, 0.41176),
                (0.04706, 0.04706, 0.41961),
                (0.05098, 0.05098, 0.42745),
                (0.05490, 0.05490, 0.43529),
                (0.05882, 0.05882, 0.44314),
                (0.06275, 0.06275, 0.45098),
                (0.06667, 0.06667, 0.45882),
                (0.07059, 0.07059, 0.46667),
                (0.07451, 0.07451, 0.47451),
                (0.07843, 0.07843, 0.48235),
                (0.08235, 0.08235, 0.49020),
                (0.08627, 0.08627, 0.49804),
                (0.09020, 0.09020, 0.50588),
                (0.09412, 0.09412, 0.51373),
                (0.09804, 0.09804, 0.52157),
                (0.10196, 0.10196, 0.52941),
                (0.10588, 0.10588, 0.53725),
                (0.10980, 0.10980, 0.54510),
                (0.11373, 0.11373, 0.55294),
                (0.11765, 0.11765, 0.56078),
                (0.12157, 0.12157, 0.56863),
                (0.12549, 0.12549, 0.57647),
                (0.12941, 0.12941, 0.58431),
                (0.13333, 0.13333, 0.59216),
                (0.13725, 0.13725, 0.60000),
                (0.14118, 0.14118, 0.60784),
                (0.14510, 0.14510, 0.61569),
                (0.14902, 0.14902, 0.62353),
                (0.15294, 0.15294, 0.63137),
                (0.15686, 0.15686, 0.63922),
                (0.16078, 0.16078, 0.64706),
                (0.16471, 0.16471, 0.65490),
                (0.16863, 0.16863, 0.66275),
                (0.17255, 0.17255, 0.67059),
                (0.17647, 0.17647, 0.67843),
                (0.18039, 0.18039, 0.68627),
                (0.18431, 0.18431, 0.69412),
                (0.18824, 0.18824, 0.70196),
                (0.19216, 0.19216, 0.70980),
                (0.19608, 0.19608, 0.71765),
                (0.20000, 0.20000, 0.72549),
                (0.20392, 0.20392, 0.73333),
                (0.20784, 0.20784, 0.74118),
                (0.21176, 0.21176, 0.74902),
                (0.21569, 0.21569, 0.75686),
                (0.21961, 0.21961, 0.76471),
                (0.22353, 0.22353, 0.77255),
                (0.22745, 0.22745, 0.78039),
                (0.23137, 0.23137, 0.78824),
                (0.23529, 0.23529, 0.79608),
                (0.23922, 0.23922, 0.80392),
                (0.24314, 0.24314, 0.81176),
                (0.24706, 0.24706, 0.81961),
                (0.25098, 0.25098, 0.82745),
                (0.25490, 0.25490, 0.83529),
                (0.25882, 0.25882, 0.84314),
                (0.26275, 0.26275, 0.85098),
                (0.26667, 0.26667, 0.85882),
                (0.27059, 0.27059, 0.86667),
                (0.27451, 0.27451, 0.87451),
                (0.27843, 0.27843, 0.88235),
                (0.28235, 0.28235, 0.89020),
                (0.28627, 0.28627, 0.89804),
                (0.29020, 0.29020, 0.90588),
                (0.29412, 0.29412, 0.91373),
                (0.29804, 0.29804, 0.92157),
                (0.30196, 0.30196, 0.92941),
                (0.30588, 0.30588, 0.93725),
                (0.30980, 0.30980, 0.94510),
                (0.31373, 0.31373, 0.95294),
                (0.31765, 0.31765, 0.96078),
                (0.32157, 0.32157, 0.96863),
                (0.32549, 0.32549, 0.97647),
                (0.32941, 0.32941, 0.98431),
                (0.33333, 0.33333, 0.99216),
                (0.00392, 0.33333, 0.00392),
                (0.00784, 0.34118, 0.00784),
                (0.01176, 0.34902, 0.01176),
                (0.01569, 0.35686, 0.01569),
                (0.01961, 0.36471, 0.01961),
                (0.02353, 0.37255, 0.02353),
                (0.02745, 0.38039, 0.02745),
                (0.03137, 0.38824, 0.03137),
                (0.03529, 0.39608, 0.03529),
                (0.03922, 0.40392, 0.03922),
                (0.04314, 0.41176, 0.04314),
                (0.04706, 0.41961, 0.04706),
                (0.05098, 0.42745, 0.05098),
                (0.05490, 0.43529, 0.05490),
                (0.05882, 0.44314, 0.05882),
                (0.06275, 0.45098, 0.06275),
                (0.06667, 0.45882, 0.06667),
                (0.07059, 0.46667, 0.07059),
                (0.07451, 0.47451, 0.07451),
                (0.07843, 0.48235, 0.07843),
                (0.08235, 0.49020, 0.08235),
                (0.08627, 0.49804, 0.08627),
                (0.09020, 0.50588, 0.09020),
                (0.09412, 0.51373, 0.09412),
                (0.09804, 0.52157, 0.09804),
                (0.10196, 0.52941, 0.10196),
                (0.10588, 0.53725, 0.10588),
                (0.10980, 0.54510, 0.10980),
                (0.11373, 0.55294, 0.11373),
                (0.11765, 0.56078, 0.11765),
                (0.12157, 0.56863, 0.12157),
                (0.12549, 0.57647, 0.12549),
                (0.12941, 0.58431, 0.12941),
                (0.13333, 0.59216, 0.13333),
                (0.13725, 0.60000, 0.13725),
                (0.14118, 0.60784, 0.14118),
                (0.14510, 0.61569, 0.14510),
                (0.14902, 0.62353, 0.14902),
                (0.15294, 0.63137, 0.15294),
                (0.15686, 0.63922, 0.15686),
                (0.16078, 0.64706, 0.16078),
                (0.16471, 0.65490, 0.16471),
                (0.16863, 0.66275, 0.16863),
                (0.17255, 0.67059, 0.17255),
                (0.17647, 0.67843, 0.17647),
                (0.18039, 0.68627, 0.18039),
                (0.18431, 0.69412, 0.18431),
                (0.18824, 0.70196, 0.18824),
                (0.19216, 0.70980, 0.19216),
                (0.19608, 0.71765, 0.19608),
                (0.20000, 0.72549, 0.20000),
                (0.20392, 0.73333, 0.20392),
                (0.20784, 0.74118, 0.20784),
                (0.21176, 0.74902, 0.21176),
                (0.21569, 0.75686, 0.21569),
                (0.21961, 0.76471, 0.21961),
                (0.22353, 0.77255, 0.22353),
                (0.22745, 0.78039, 0.22745),
                (0.23137, 0.78824, 0.23137),
                (0.23529, 0.79608, 0.23529),
                (0.23922, 0.80392, 0.23922),
                (0.24314, 0.81176, 0.24314),
                (0.24706, 0.81961, 0.24706),
                (0.25098, 0.82745, 0.25098),
                (0.25490, 0.83529, 0.25490),
                (0.25882, 0.84314, 0.25882),
                (0.26275, 0.85098, 0.26275),
                (0.26667, 0.85882, 0.26667),
                (0.27059, 0.86667, 0.27059),
                (0.27451, 0.87451, 0.27451),
                (0.27843, 0.88235, 0.27843),
                (0.28235, 0.89020, 0.28235),
                (0.28627, 0.89804, 0.28627),
                (0.29020, 0.90588, 0.29020),
                (0.29412, 0.91373, 0.29412),
                (0.29804, 0.92157, 0.29804),
                (0.30196, 0.92941, 0.30196),
                (0.30588, 0.93725, 0.30588),
                (0.30980, 0.94510, 0.30980),
                (0.31373, 0.95294, 0.31373),
                (0.31765, 0.96078, 0.31765),
                (0.32157, 0.96863, 0.32157),
                (0.32549, 0.97647, 0.32549),
                (0.32941, 0.98431, 0.32941),
                (0.33333, 0.99216, 0.33333),
                (0.33333, 0.00392, 0.00392),
                (0.34118, 0.00784, 0.00784),
                (0.34902, 0.01176, 0.01176),
                (0.35686, 0.01569, 0.01569),
                (0.36471, 0.01961, 0.01961),
                (0.37255, 0.02353, 0.02353),
                (0.38039, 0.02745, 0.02745),
                (0.38824, 0.03137, 0.03137),
                (0.39608, 0.03529, 0.03529),
                (0.40392, 0.03922, 0.03922),
                (0.41176, 0.04314, 0.04314),
                (0.41961, 0.04706, 0.04706),
                (0.42745, 0.05098, 0.05098),
                (0.43529, 0.05490, 0.05490),
                (0.44314, 0.05882, 0.05882),
                (0.45098, 0.06275, 0.06275),
                (0.45882, 0.06667, 0.06667),
                (0.46667, 0.07059, 0.07059),
                (0.47451, 0.07451, 0.07451),
                (0.48235, 0.07843, 0.07843),
                (0.49020, 0.08235, 0.08235),
                (0.49804, 0.08627, 0.08627),
                (0.50588, 0.09020, 0.09020),
                (0.51373, 0.09412, 0.09412),
                (0.52157, 0.09804, 0.09804),
                (0.52941, 0.10196, 0.10196),
                (0.53725, 0.10588, 0.10588),
                (0.54510, 0.10980, 0.10980),
                (0.55294, 0.11373, 0.11373),
                (0.56078, 0.11765, 0.11765),
                (0.56863, 0.12157, 0.12157),
                (0.57647, 0.12549, 0.12549),
                (0.58431, 0.12941, 0.12941),
                (0.59216, 0.13333, 0.13333),
                (0.60000, 0.13725, 0.13725),
                (0.60784, 0.14118, 0.14118),
                (0.61569, 0.14510, 0.14510),
                (0.62353, 0.14902, 0.14902),
                (0.63137, 0.15294, 0.15294),
                (0.63922, 0.15686, 0.15686),
                (0.64706, 0.16078, 0.16078),
                (0.65490, 0.16471, 0.16471),
                (0.66275, 0.16863, 0.16863),
                (0.67059, 0.17255, 0.17255),
                (0.67843, 0.17647, 0.17647),
                (0.68627, 0.18039, 0.18039),
                (0.69412, 0.18431, 0.18431),
                (0.70196, 0.18824, 0.18824),
                (0.70980, 0.19216, 0.19216),
                (0.71765, 0.19608, 0.19608),
                (0.72549, 0.20000, 0.20000),
                (0.73333, 0.20392, 0.20392),
                (0.74118, 0.20784, 0.20784),
                (0.74902, 0.21176, 0.21176),
                (0.75686, 0.21569, 0.21569),
                (0.76471, 0.21961, 0.21961),
                (0.77255, 0.22353, 0.22353),
                (0.78039, 0.22745, 0.22745),
                (0.78824, 0.23137, 0.23137),
                (0.79608, 0.23529, 0.23529),
                (0.80392, 0.23922, 0.23922),
                (0.81176, 0.24314, 0.24314),
                (0.81961, 0.24706, 0.24706),
                (0.82745, 0.25098, 0.25098),
                (0.83529, 0.25490, 0.25490),
                (0.84314, 0.25882, 0.25882),
                (0.85098, 0.26275, 0.26275),
                (0.85882, 0.26667, 0.26667),
                (0.86667, 0.27059, 0.27059),
                (0.87451, 0.27451, 0.27451),
                (0.88235, 0.27843, 0.27843),
                (0.89020, 0.28235, 0.28235),
                (0.89804, 0.28627, 0.28627),
                (0.90588, 0.29020, 0.29020),
                (0.91373, 0.29412, 0.29412),
                (0.92157, 0.29804, 0.29804),
                (0.92941, 0.30196, 0.30196),
                (0.93725, 0.30588, 0.30588),
                (0.94510, 0.30980, 0.30980),
                (0.95294, 0.31373, 0.31373),
                (0.96078, 0.31765, 0.31765),
                (0.96863, 0.32157, 0.32157),
                (0.97647, 0.32549, 0.32549),
                (0.98431, 0.32941, 0.32941),
                (0.99216, 0.33333, 0.33333),
                (1.00000, 0.33725, 0.33725),
)

cmap_blulut = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00392),
                (0.00000, 0.00000, 0.00784),
                (0.00000, 0.00000, 0.01176),
                (0.00000, 0.00000, 0.01569),
                (0.00000, 0.00000, 0.01961),
                (0.00000, 0.00000, 0.02353),
                (0.00000, 0.00000, 0.02745),
                (0.00000, 0.00000, 0.03137),
                (0.00000, 0.00000, 0.03529),
                (0.00000, 0.00000, 0.03922),
                (0.00000, 0.00000, 0.04314),
                (0.00000, 0.00000, 0.04706),
                (0.00001, 0.00001, 0.05098),
                (0.00001, 0.00001, 0.05490),
                (0.00001, 0.00001, 0.05882),
                (0.00002, 0.00002, 0.06275),
                (0.00002, 0.00002, 0.06667),
                (0.00002, 0.00002, 0.07059),
                (0.00003, 0.00003, 0.07451),
                (0.00004, 0.00004, 0.07843),
                (0.00005, 0.00005, 0.08235),
                (0.00006, 0.00006, 0.08627),
                (0.00007, 0.00007, 0.09020),
                (0.00008, 0.00008, 0.09412),
                (0.00009, 0.00009, 0.09804),
                (0.00011, 0.00011, 0.10196),
                (0.00013, 0.00013, 0.10588),
                (0.00015, 0.00015, 0.10980),
                (0.00017, 0.00017, 0.11373),
                (0.00019, 0.00019, 0.11765),
                (0.00022, 0.00022, 0.12157),
                (0.00025, 0.00025, 0.12549),
                (0.00028, 0.00028, 0.12941),
                (0.00032, 0.00032, 0.13333),
                (0.00035, 0.00035, 0.13725),
                (0.00040, 0.00040, 0.14118),
                (0.00044, 0.00044, 0.14510),
                (0.00049, 0.00049, 0.14902),
                (0.00055, 0.00055, 0.15294),
                (0.00061, 0.00061, 0.15686),
                (0.00067, 0.00067, 0.16078),
                (0.00074, 0.00074, 0.16471),
                (0.00081, 0.00081, 0.16863),
                (0.00089, 0.00089, 0.17255),
                (0.00097, 0.00097, 0.17647),
                (0.00106, 0.00106, 0.18039),
                (0.00115, 0.00115, 0.18431),
                (0.00126, 0.00126, 0.18824),
                (0.00136, 0.00136, 0.19216),
                (0.00148, 0.00148, 0.19608),
                (0.00160, 0.00160, 0.20000),
                (0.00173, 0.00173, 0.20392),
                (0.00187, 0.00187, 0.20784),
                (0.00201, 0.00201, 0.21176),
                (0.00216, 0.00216, 0.21569),
                (0.00233, 0.00233, 0.21961),
                (0.00250, 0.00250, 0.22353),
                (0.00268, 0.00268, 0.22745),
                (0.00287, 0.00287, 0.23137),
                (0.00307, 0.00307, 0.23529),
                (0.00327, 0.00327, 0.23922),
                (0.00349, 0.00349, 0.24314),
                (0.00373, 0.00373, 0.24706),
                (0.00397, 0.00397, 0.25098),
                (0.00422, 0.00422, 0.25490),
                (0.00449, 0.00449, 0.25882),
                (0.00477, 0.00477, 0.26275),
                (0.00506, 0.00506, 0.26667),
                (0.00536, 0.00536, 0.27059),
                (0.00568, 0.00568, 0.27451),
                (0.00601, 0.00601, 0.27843),
                (0.00636, 0.00636, 0.28235),
                (0.00672, 0.00672, 0.28627),
                (0.00709, 0.00709, 0.29020),
                (0.00748, 0.00748, 0.29412),
                (0.00789, 0.00789, 0.29804),
                (0.00831, 0.00831, 0.30196),
                (0.00875, 0.00875, 0.30588),
                (0.00921, 0.00921, 0.30980),
                (0.00969, 0.00969, 0.31373),
                (0.01018, 0.01018, 0.31765),
                (0.01069, 0.01069, 0.32157),
                (0.01122, 0.01122, 0.32549),
                (0.01177, 0.01177, 0.32941),
                (0.01235, 0.01235, 0.33333),
                (0.01294, 0.01294, 0.33725),
                (0.01355, 0.01355, 0.34118),
                (0.01418, 0.01418, 0.34510),
                (0.01484, 0.01484, 0.34902),
                (0.01552, 0.01552, 0.35294),
                (0.01622, 0.01622, 0.35686),
                (0.01694, 0.01694, 0.36078),
                (0.01769, 0.01769, 0.36471),
                (0.01847, 0.01847, 0.36863),
                (0.01926, 0.01926, 0.37255),
                (0.02009, 0.02009, 0.37647),
                (0.02094, 0.02094, 0.38039),
                (0.02181, 0.02181, 0.38431),
                (0.02272, 0.02272, 0.38824),
                (0.02365, 0.02365, 0.39216),
                (0.02461, 0.02461, 0.39608),
                (0.02560, 0.02560, 0.40000),
                (0.02662, 0.02662, 0.40392),
                (0.02767, 0.02767, 0.40784),
                (0.02875, 0.02875, 0.41176),
                (0.02986, 0.02986, 0.41569),
                (0.03100, 0.03100, 0.41961),
                (0.03218, 0.03218, 0.42353),
                (0.03338, 0.03338, 0.42745),
                (0.03463, 0.03463, 0.43137),
                (0.03590, 0.03590, 0.43529),
                (0.03721, 0.03721, 0.43922),
                (0.03856, 0.03856, 0.44314),
                (0.03994, 0.03994, 0.44706),
                (0.04136, 0.04136, 0.45098),
                (0.04282, 0.04282, 0.45490),
                (0.04432, 0.04432, 0.45882),
                (0.04585, 0.04585, 0.46275),
                (0.04743, 0.04743, 0.46667),
                (0.04904, 0.04904, 0.47059),
                (0.05070, 0.05070, 0.47451),
                (0.05239, 0.05239, 0.47843),
                (0.05413, 0.05413, 0.48235),
                (0.05591, 0.05591, 0.48627),
                (0.05774, 0.05774, 0.49020),
                (0.05961, 0.05961, 0.49412),
                (0.06153, 0.06153, 0.49804),
                (0.06349, 0.06349, 0.50196),
                (0.06549, 0.06549, 0.50588),
                (0.06755, 0.06755, 0.50980),
                (0.06965, 0.06965, 0.51373),
                (0.07180, 0.07180, 0.51765),
                (0.07400, 0.07400, 0.52157),
                (0.07625, 0.07625, 0.52549),
                (0.07856, 0.07856, 0.52941),
                (0.08091, 0.08091, 0.53333),
                (0.08331, 0.08331, 0.53725),
                (0.08577, 0.08577, 0.54118),
                (0.08829, 0.08829, 0.54510),
                (0.09086, 0.09086, 0.54902),
                (0.09348, 0.09348, 0.55294),
                (0.09616, 0.09616, 0.55686),
                (0.09890, 0.09890, 0.56078),
                (0.10169, 0.10169, 0.56471),
                (0.10455, 0.10455, 0.56863),
                (0.10746, 0.10746, 0.57255),
                (0.11044, 0.11044, 0.57647),
                (0.11347, 0.11347, 0.58039),
                (0.11657, 0.11657, 0.58431),
                (0.11973, 0.11973, 0.58824),
                (0.12296, 0.12296, 0.59216),
                (0.12624, 0.12624, 0.59608),
                (0.12960, 0.12960, 0.60000),
                (0.13302, 0.13302, 0.60392),
                (0.13651, 0.13651, 0.60784),
                (0.14007, 0.14007, 0.61176),
                (0.14369, 0.14369, 0.61569),
                (0.14739, 0.14739, 0.61961),
                (0.15116, 0.15116, 0.62353),
                (0.15500, 0.15500, 0.62745),
                (0.15891, 0.15891, 0.63137),
                (0.16289, 0.16289, 0.63529),
                (0.16695, 0.16695, 0.63922),
                (0.17109, 0.17109, 0.64314),
                (0.17530, 0.17530, 0.64706),
                (0.17959, 0.17959, 0.65098),
                (0.18395, 0.18395, 0.65490),
                (0.18840, 0.18840, 0.65882),
                (0.19292, 0.19292, 0.66275),
                (0.19753, 0.19753, 0.66667),
                (0.20222, 0.20222, 0.67059),
                (0.20699, 0.20699, 0.67451),
                (0.21185, 0.21185, 0.67843),
                (0.21679, 0.21679, 0.68235),
                (0.22182, 0.22182, 0.68627),
                (0.22693, 0.22693, 0.69020),
                (0.23213, 0.23213, 0.69412),
                (0.23742, 0.23742, 0.69804),
                (0.24280, 0.24280, 0.70196),
                (0.24827, 0.24827, 0.70588),
                (0.25384, 0.25384, 0.70980),
                (0.25949, 0.25949, 0.71373),
                (0.26524, 0.26524, 0.71765),
                (0.27109, 0.27109, 0.72157),
                (0.27703, 0.27703, 0.72549),
                (0.28307, 0.28307, 0.72941),
                (0.28920, 0.28920, 0.73333),
                (0.29544, 0.29544, 0.73725),
                (0.30178, 0.30178, 0.74118),
                (0.30821, 0.30821, 0.74510),
                (0.31476, 0.31476, 0.74902),
                (0.32140, 0.32140, 0.75294),
                (0.32815, 0.32815, 0.75686),
                (0.33500, 0.33500, 0.76078),
                (0.34196, 0.34196, 0.76471),
                (0.34903, 0.34903, 0.76863),
                (0.35621, 0.35621, 0.77255),
                (0.36350, 0.36350, 0.77647),
                (0.37090, 0.37090, 0.78039),
                (0.37841, 0.37841, 0.78431),
                (0.38603, 0.38603, 0.78824),
                (0.39377, 0.39377, 0.79216),
                (0.40163, 0.40163, 0.79608),
                (0.40960, 0.40960, 0.80000),
                (0.41769, 0.41769, 0.80392),
                (0.42590, 0.42590, 0.80784),
                (0.43423, 0.43423, 0.81176),
                (0.44268, 0.44268, 0.81569),
                (0.45126, 0.45126, 0.81961),
                (0.45996, 0.45996, 0.82353),
                (0.46878, 0.46878, 0.82745),
                (0.47773, 0.47773, 0.83137),
                (0.48681, 0.48681, 0.83529),
                (0.49601, 0.49601, 0.83922),
                (0.50535, 0.50535, 0.84314),
                (0.51482, 0.51482, 0.84706),
                (0.52442, 0.52442, 0.85098),
                (0.53415, 0.53415, 0.85490),
                (0.54402, 0.54402, 0.85882),
                (0.55403, 0.55403, 0.86275),
                (0.56417, 0.56417, 0.86667),
                (0.57445, 0.57445, 0.87059),
                (0.58487, 0.58487, 0.87451),
                (0.59543, 0.59543, 0.87843),
                (0.60613, 0.60613, 0.88235),
                (0.61698, 0.61698, 0.88627),
                (0.62798, 0.62798, 0.89020),
                (0.63911, 0.63911, 0.89412),
                (0.65040, 0.65040, 0.89804),
                (0.66184, 0.66184, 0.90196),
                (0.67342, 0.67342, 0.90588),
                (0.68516, 0.68516, 0.90980),
                (0.69705, 0.69705, 0.91373),
                (0.70909, 0.70909, 0.91765),
                (0.72129, 0.72129, 0.92157),
                (0.73365, 0.73365, 0.92549),
                (0.74616, 0.74616, 0.92941),
                (0.75883, 0.75883, 0.93333),
                (0.77167, 0.77167, 0.93725),
                (0.78466, 0.78466, 0.94118),
                (0.79782, 0.79782, 0.94510),
                (0.81115, 0.81115, 0.94902),
                (0.82464, 0.82464, 0.95294),
                (0.83830, 0.83830, 0.95686),
                (0.85213, 0.85213, 0.96078),
                (0.86612, 0.86612, 0.96471),
                (0.88029, 0.88029, 0.96863),
                (0.89464, 0.89464, 0.97255),
                (0.90915, 0.90915, 0.97647),
                (0.92385, 0.92385, 0.98039),
                (0.93872, 0.93872, 0.98431),
                (0.95377, 0.95377, 0.98824),
                (0.96899, 0.96899, 0.99216),
                (0.98441, 0.98441, 0.99608),
                (1.00000, 1.00000, 1.00000),
        )

cmap_green = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00392, 0.00000),
                (0.00000, 0.00784, 0.00000),
                (0.00000, 0.01176, 0.00000),
                (0.00000, 0.01569, 0.00000),
                (0.00000, 0.01961, 0.00000),
                (0.00000, 0.02353, 0.00000),
                (0.00000, 0.02745, 0.00000),
                (0.00000, 0.03137, 0.00000),
                (0.00000, 0.03529, 0.00000),
                (0.00000, 0.03922, 0.00000),
                (0.00000, 0.04314, 0.00000),
                (0.00000, 0.04706, 0.00000),
                (0.00000, 0.05098, 0.00000),
                (0.00000, 0.05490, 0.00000),
                (0.00000, 0.05882, 0.00000),
                (0.00000, 0.06275, 0.00000),
                (0.00000, 0.06667, 0.00000),
                (0.00000, 0.07059, 0.00000),
                (0.00000, 0.07451, 0.00000),
                (0.00000, 0.07843, 0.00000),
                (0.00000, 0.08235, 0.00000),
                (0.00000, 0.08627, 0.00000),
                (0.00000, 0.09020, 0.00000),
                (0.00000, 0.09412, 0.00000),
                (0.00000, 0.09804, 0.00000),
                (0.00000, 0.10196, 0.00000),
                (0.00000, 0.10588, 0.00000),
                (0.00000, 0.10980, 0.00000),
                (0.00000, 0.11373, 0.00000),
                (0.00000, 0.11765, 0.00000),
                (0.00000, 0.12157, 0.00000),
                (0.00000, 0.12549, 0.00000),
                (0.00000, 0.12941, 0.00000),
                (0.00000, 0.13333, 0.00000),
                (0.00000, 0.13725, 0.00000),
                (0.00000, 0.14118, 0.00000),
                (0.00000, 0.14510, 0.00000),
                (0.00000, 0.14902, 0.00000),
                (0.00000, 0.15294, 0.00000),
                (0.00000, 0.15686, 0.00000),
                (0.00000, 0.16078, 0.00000),
                (0.00000, 0.16471, 0.00000),
                (0.00000, 0.16863, 0.00000),
                (0.00000, 0.17255, 0.00000),
                (0.00000, 0.17647, 0.00000),
                (0.00000, 0.18039, 0.00000),
                (0.00000, 0.18431, 0.00000),
                (0.00000, 0.18824, 0.00000),
                (0.00000, 0.19216, 0.00000),
                (0.00000, 0.19608, 0.00000),
                (0.00000, 0.20000, 0.00000),
                (0.00000, 0.20392, 0.00000),
                (0.00000, 0.20784, 0.00000),
                (0.00000, 0.21176, 0.00000),
                (0.00000, 0.21569, 0.00000),
                (0.00000, 0.21961, 0.00000),
                (0.00000, 0.22353, 0.00000),
                (0.00000, 0.22745, 0.00000),
                (0.00000, 0.23137, 0.00000),
                (0.00000, 0.23529, 0.00000),
                (0.00000, 0.23922, 0.00000),
                (0.00000, 0.24314, 0.00000),
                (0.00000, 0.24706, 0.00000),
                (0.00000, 0.25098, 0.00000),
                (0.00000, 0.25490, 0.00000),
                (0.00000, 0.25882, 0.00000),
                (0.00000, 0.26275, 0.00000),
                (0.00000, 0.26667, 0.00000),
                (0.00000, 0.27059, 0.00000),
                (0.00000, 0.27451, 0.00000),
                (0.00000, 0.27843, 0.00000),
                (0.00000, 0.28235, 0.00000),
                (0.00000, 0.28627, 0.00000),
                (0.00000, 0.29020, 0.00000),
                (0.00000, 0.29412, 0.00000),
                (0.00000, 0.29804, 0.00000),
                (0.00000, 0.30196, 0.00000),
                (0.00000, 0.30588, 0.00000),
                (0.00000, 0.30980, 0.00000),
                (0.00000, 0.31373, 0.00000),
                (0.00000, 0.31765, 0.00000),
                (0.00000, 0.32157, 0.00000),
                (0.00000, 0.32549, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.33333, 0.00000),
                (0.00000, 0.33725, 0.00000),
                (0.00000, 0.34118, 0.00000),
                (0.00000, 0.34510, 0.00000),
                (0.00000, 0.34902, 0.00000),
                (0.00000, 0.35294, 0.00000),
                (0.00000, 0.35686, 0.00000),
                (0.00000, 0.36078, 0.00000),
                (0.00000, 0.36471, 0.00000),
                (0.00000, 0.36863, 0.00000),
                (0.00000, 0.37255, 0.00000),
                (0.00000, 0.37647, 0.00000),
                (0.00000, 0.38039, 0.00000),
                (0.00000, 0.38431, 0.00000),
                (0.00000, 0.38824, 0.00000),
                (0.00000, 0.39216, 0.00000),
                (0.00000, 0.39608, 0.00000),
                (0.00000, 0.40000, 0.00000),
                (0.00000, 0.40392, 0.00000),
                (0.00000, 0.40784, 0.00000),
                (0.00000, 0.41176, 0.00000),
                (0.00000, 0.41569, 0.00000),
                (0.00000, 0.41961, 0.00000),
                (0.00000, 0.42353, 0.00000),
                (0.00000, 0.42745, 0.00000),
                (0.00000, 0.43137, 0.00000),
                (0.00000, 0.43529, 0.00000),
                (0.00000, 0.43922, 0.00000),
                (0.00000, 0.44314, 0.00000),
                (0.00000, 0.44706, 0.00000),
                (0.00000, 0.45098, 0.00000),
                (0.00000, 0.45490, 0.00000),
                (0.00000, 0.45882, 0.00000),
                (0.00000, 0.46275, 0.00000),
                (0.00000, 0.46667, 0.00000),
                (0.00000, 0.47059, 0.00000),
                (0.00000, 0.47451, 0.00000),
                (0.00000, 0.47843, 0.00000),
                (0.00000, 0.48235, 0.00000),
                (0.00000, 0.48627, 0.00000),
                (0.00000, 0.49020, 0.00000),
                (0.00000, 0.49412, 0.00000),
                (0.00000, 0.49804, 0.00000),
                (0.00000, 0.50196, 0.00000),
                (0.00000, 0.50588, 0.00000),
                (0.00000, 0.50980, 0.00000),
                (0.00000, 0.51373, 0.00000),
                (0.00000, 0.51765, 0.00000),
                (0.00000, 0.52157, 0.00000),
                (0.00000, 0.52549, 0.00000),
                (0.00000, 0.52941, 0.00000),
                (0.00000, 0.53333, 0.00000),
                (0.00000, 0.53725, 0.00000),
                (0.00000, 0.54118, 0.00000),
                (0.00000, 0.54510, 0.00000),
                (0.00000, 0.54902, 0.00000),
                (0.00000, 0.55294, 0.00000),
                (0.00000, 0.55686, 0.00000),
                (0.00000, 0.56078, 0.00000),
                (0.00000, 0.56471, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.57255, 0.00000),
                (0.00000, 0.57647, 0.00000),
                (0.00000, 0.58039, 0.00000),
                (0.00000, 0.58431, 0.00000),
                (0.00000, 0.58824, 0.00000),
                (0.00000, 0.59216, 0.00000),
                (0.00000, 0.59608, 0.00000),
                (0.00000, 0.60000, 0.00000),
                (0.00000, 0.60392, 0.00000),
                (0.00000, 0.60784, 0.00000),
                (0.00000, 0.61176, 0.00000),
                (0.00000, 0.61569, 0.00000),
                (0.00000, 0.61961, 0.00000),
                (0.00000, 0.62353, 0.00000),
                (0.00000, 0.62745, 0.00000),
                (0.00000, 0.63137, 0.00000),
                (0.00000, 0.63529, 0.00000),
                (0.00000, 0.63922, 0.00000),
                (0.00000, 0.64314, 0.00000),
                (0.00000, 0.64706, 0.00000),
                (0.00000, 0.65098, 0.00000),
                (0.00000, 0.65490, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.66275, 0.00000),
                (0.00000, 0.66667, 0.00000),
                (0.00000, 0.67059, 0.00000),
                (0.00000, 0.67451, 0.00000),
                (0.00000, 0.67843, 0.00000),
                (0.00000, 0.68235, 0.00000),
                (0.00000, 0.68627, 0.00000),
                (0.00000, 0.69020, 0.00000),
                (0.00000, 0.69412, 0.00000),
                (0.00000, 0.69804, 0.00000),
                (0.00000, 0.70196, 0.00000),
                (0.00000, 0.70588, 0.00000),
                (0.00000, 0.70980, 0.00000),
                (0.00000, 0.71373, 0.00000),
                (0.00000, 0.71765, 0.00000),
                (0.00000, 0.72157, 0.00000),
                (0.00000, 0.72549, 0.00000),
                (0.00000, 0.72941, 0.00000),
                (0.00000, 0.73333, 0.00000),
                (0.00000, 0.73725, 0.00000),
                (0.00000, 0.74118, 0.00000),
                (0.00000, 0.74510, 0.00000),
                (0.00000, 0.74902, 0.00000),
                (0.00000, 0.75294, 0.00000),
                (0.00000, 0.75686, 0.00000),
                (0.00000, 0.76078, 0.00000),
                (0.00000, 0.76471, 0.00000),
                (0.00000, 0.76863, 0.00000),
                (0.00000, 0.77255, 0.00000),
                (0.00000, 0.77647, 0.00000),
                (0.00000, 0.78039, 0.00000),
                (0.00000, 0.78431, 0.00000),
                (0.00000, 0.78824, 0.00000),
                (0.00000, 0.79216, 0.00000),
                (0.00000, 0.79608, 0.00000),
                (0.00000, 0.80000, 0.00000),
                (0.00000, 0.80392, 0.00000),
                (0.00000, 0.80784, 0.00000),
                (0.00000, 0.81176, 0.00000),
                (0.00000, 0.81569, 0.00000),
                (0.00000, 0.81961, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.82745, 0.00000),
                (0.00000, 0.83137, 0.00000),
                (0.00000, 0.83529, 0.00000),
                (0.00000, 0.83922, 0.00000),
                (0.00000, 0.84314, 0.00000),
                (0.00000, 0.84706, 0.00000),
                (0.00000, 0.85098, 0.00000),
                (0.00000, 0.85490, 0.00000),
                (0.00000, 0.85882, 0.00000),
                (0.00000, 0.86275, 0.00000),
                (0.00000, 0.86667, 0.00000),
                (0.00000, 0.87059, 0.00000),
                (0.00000, 0.87451, 0.00000),
                (0.00000, 0.87843, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.88627, 0.00000),
                (0.00000, 0.89020, 0.00000),
                (0.00000, 0.89412, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.90196, 0.00000),
                (0.00000, 0.90588, 0.00000),
                (0.00000, 0.90980, 0.00000),
                (0.00000, 0.91373, 0.00000),
                (0.00000, 0.91765, 0.00000),
                (0.00000, 0.92157, 0.00000),
                (0.00000, 0.92549, 0.00000),
                (0.00000, 0.92941, 0.00000),
                (0.00000, 0.93333, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.94118, 0.00000),
                (0.00000, 0.94510, 0.00000),
                (0.00000, 0.94902, 0.00000),
                (0.00000, 0.95294, 0.00000),
                (0.00000, 0.95686, 0.00000),
                (0.00000, 0.96078, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96863, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.97647, 0.00000),
                (0.00000, 0.98039, 0.00000),
                (0.00000, 0.98431, 0.00000),
                (0.00000, 0.98824, 0.00000),
                (0.00000, 0.99216, 0.00000),
                (0.00000, 0.99608, 0.00392),
                (0.00000, 1.00000, 0.00784),
        )

cmap_staircase = (
                (0.00392, 0.00392, 0.31373),  # noqa
                (0.00784, 0.00784, 0.31373),
                (0.01176, 0.01176, 0.31373),
                (0.01569, 0.01569, 0.31373),
                (0.01961, 0.01961, 0.31373),
                (0.02353, 0.02353, 0.31373),
                (0.02745, 0.02745, 0.31373),
                (0.03137, 0.03137, 0.31373),
                (0.03529, 0.03529, 0.31373),
                (0.03922, 0.03922, 0.31373),
                (0.04314, 0.04314, 0.31373),
                (0.04706, 0.04706, 0.31373),
                (0.05098, 0.05098, 0.31373),
                (0.05490, 0.05490, 0.31373),
                (0.05882, 0.05882, 0.31373),
                (0.06275, 0.06275, 0.31373),
                (0.06667, 0.06667, 0.47059),
                (0.07059, 0.07059, 0.47059),
                (0.07451, 0.07451, 0.47059),
                (0.07843, 0.07843, 0.47059),
                (0.08235, 0.08235, 0.47059),
                (0.08627, 0.08627, 0.47059),
                (0.09020, 0.09020, 0.47059),
                (0.09412, 0.09412, 0.47059),
                (0.09804, 0.09804, 0.47059),
                (0.10196, 0.10196, 0.47059),
                (0.10588, 0.10588, 0.47059),
                (0.10980, 0.10980, 0.47059),
                (0.11373, 0.11373, 0.47059),
                (0.11765, 0.11765, 0.47059),
                (0.12157, 0.12157, 0.47059),
                (0.12549, 0.12549, 0.47059),
                (0.12941, 0.12941, 0.62745),
                (0.13333, 0.13333, 0.62745),
                (0.13725, 0.13725, 0.62745),
                (0.14118, 0.14118, 0.62745),
                (0.14510, 0.14510, 0.62745),
                (0.14902, 0.14902, 0.62745),
                (0.15294, 0.15294, 0.62745),
                (0.15686, 0.15686, 0.62745),
                (0.16078, 0.16078, 0.62745),
                (0.16471, 0.16471, 0.62745),
                (0.16863, 0.16863, 0.62745),
                (0.17255, 0.17255, 0.62745),
                (0.17647, 0.17647, 0.62745),
                (0.18039, 0.18039, 0.62745),
                (0.18431, 0.18431, 0.62745),
                (0.18824, 0.18824, 0.62745),
                (0.19216, 0.19216, 0.78431),
                (0.19608, 0.19608, 0.78431),
                (0.20000, 0.20000, 0.78431),
                (0.20392, 0.20392, 0.78431),
                (0.20784, 0.20784, 0.78431),
                (0.21176, 0.21176, 0.78431),
                (0.21569, 0.21569, 0.78431),
                (0.21961, 0.21961, 0.78431),
                (0.22353, 0.22353, 0.78431),
                (0.22745, 0.22745, 0.78431),
                (0.23137, 0.23137, 0.78431),
                (0.23529, 0.23529, 0.78431),
                (0.23922, 0.23922, 0.78431),
                (0.24314, 0.24314, 0.78431),
                (0.24706, 0.24706, 0.78431),
                (0.25098, 0.25098, 0.78431),
                (0.25490, 0.25490, 0.94118),
                (0.25882, 0.25882, 0.94118),
                (0.26275, 0.26275, 0.94118),
                (0.26667, 0.26667, 0.94118),
                (0.27059, 0.27059, 0.94118),
                (0.27451, 0.27451, 0.94118),
                (0.27843, 0.27843, 0.94118),
                (0.28235, 0.28235, 0.94118),
                (0.28627, 0.28627, 0.94118),
                (0.29020, 0.29020, 0.94118),
                (0.29412, 0.29412, 0.94118),
                (0.29804, 0.29804, 0.94118),
                (0.30196, 0.30196, 0.94118),
                (0.30588, 0.30588, 0.94118),
                (0.30980, 0.30980, 0.94118),
                (0.31373, 0.31373, 0.94118),
                (0.31765, 0.31765, 0.95294),
                (0.32157, 0.32157, 0.96471),
                (0.32549, 0.32549, 0.97647),
                (0.32941, 0.32941, 0.98824),
                (0.33333, 0.33333, 1.00000),
                (0.00392, 0.31373, 0.00392),
                (0.00784, 0.31373, 0.00784),
                (0.01176, 0.31373, 0.01176),
                (0.01569, 0.31373, 0.01569),
                (0.01961, 0.31373, 0.01961),
                (0.02353, 0.31373, 0.02353),
                (0.02745, 0.31373, 0.02745),
                (0.03137, 0.31373, 0.03137),
                (0.03529, 0.31373, 0.03529),
                (0.03922, 0.31373, 0.03922),
                (0.04314, 0.31373, 0.04314),
                (0.04706, 0.31373, 0.04706),
                (0.05098, 0.31373, 0.05098),
                (0.05490, 0.31373, 0.05490),
                (0.05882, 0.31373, 0.05882),
                (0.06275, 0.31373, 0.06275),
                (0.06667, 0.47059, 0.06667),
                (0.07059, 0.47059, 0.07059),
                (0.07451, 0.47059, 0.07451),
                (0.07843, 0.47059, 0.07843),
                (0.08235, 0.47059, 0.08235),
                (0.08627, 0.47059, 0.08627),
                (0.09020, 0.47059, 0.09020),
                (0.09412, 0.47059, 0.09412),
                (0.09804, 0.47059, 0.09804),
                (0.10196, 0.47059, 0.10196),
                (0.10588, 0.47059, 0.10588),
                (0.10980, 0.47059, 0.10980),
                (0.11373, 0.47059, 0.11373),
                (0.11765, 0.47059, 0.11765),
                (0.12157, 0.47059, 0.12157),
                (0.12549, 0.47059, 0.12549),
                (0.12941, 0.62745, 0.12941),
                (0.13333, 0.62745, 0.13333),
                (0.13725, 0.62745, 0.13725),
                (0.14118, 0.62745, 0.14118),
                (0.14510, 0.62745, 0.14510),
                (0.14902, 0.62745, 0.14902),
                (0.15294, 0.62745, 0.15294),
                (0.15686, 0.62745, 0.15686),
                (0.16078, 0.62745, 0.16078),
                (0.16471, 0.62745, 0.16471),
                (0.16863, 0.62745, 0.16863),
                (0.17255, 0.62745, 0.17255),
                (0.17647, 0.62745, 0.17647),
                (0.18039, 0.62745, 0.18039),
                (0.18431, 0.62745, 0.18431),
                (0.18824, 0.62745, 0.18824),
                (0.19216, 0.78431, 0.19216),
                (0.19608, 0.78431, 0.19608),
                (0.20000, 0.78431, 0.20000),
                (0.20392, 0.78431, 0.20392),
                (0.20784, 0.78431, 0.20784),
                (0.21176, 0.78431, 0.21176),
                (0.21569, 0.78431, 0.21569),
                (0.21961, 0.78431, 0.21961),
                (0.22353, 0.78431, 0.22353),
                (0.22745, 0.78431, 0.22745),
                (0.23137, 0.78431, 0.23137),
                (0.23529, 0.78431, 0.23529),
                (0.23922, 0.78431, 0.23922),
                (0.24314, 0.78431, 0.24314),
                (0.24706, 0.78431, 0.24706),
                (0.25098, 0.78431, 0.25098),
                (0.25490, 0.94118, 0.25490),
                (0.25882, 0.94118, 0.25882),
                (0.26275, 0.94118, 0.26275),
                (0.26667, 0.94118, 0.26667),
                (0.27059, 0.94118, 0.27059),
                (0.27451, 0.94118, 0.27451),
                (0.27843, 0.94118, 0.27843),
                (0.28235, 0.94118, 0.28235),
                (0.28627, 0.94118, 0.28627),
                (0.29020, 0.94118, 0.29020),
                (0.29412, 0.94118, 0.29412),
                (0.29804, 0.94118, 0.29804),
                (0.30196, 0.94118, 0.30196),
                (0.30588, 0.94118, 0.30588),
                (0.30980, 0.94118, 0.30980),
                (0.31373, 0.94118, 0.31373),
                (0.31765, 0.95294, 0.31765),
                (0.32157, 0.96471, 0.32157),
                (0.32549, 0.97647, 0.32549),
                (0.32941, 0.98824, 0.32941),
                (0.33333, 1.00000, 0.33333),
                (0.31373, 0.00392, 0.00392),
                (0.31373, 0.00784, 0.00784),
                (0.31373, 0.01176, 0.01176),
                (0.31373, 0.01569, 0.01569),
                (0.31373, 0.01961, 0.01961),
                (0.31373, 0.02353, 0.02353),
                (0.31373, 0.02745, 0.02745),
                (0.31373, 0.03137, 0.03137),
                (0.31373, 0.03529, 0.03529),
                (0.31373, 0.03922, 0.03922),
                (0.31373, 0.04314, 0.04314),
                (0.31373, 0.04706, 0.04706),
                (0.31373, 0.05098, 0.05098),
                (0.31373, 0.05490, 0.05490),
                (0.31373, 0.05882, 0.05882),
                (0.31373, 0.06275, 0.06275),
                (0.47059, 0.06667, 0.06667),
                (0.47059, 0.07059, 0.07059),
                (0.47059, 0.07451, 0.07451),
                (0.47059, 0.07843, 0.07843),
                (0.47059, 0.08235, 0.08235),
                (0.47059, 0.08627, 0.08627),
                (0.47059, 0.09020, 0.09020),
                (0.47059, 0.09412, 0.09412),
                (0.47059, 0.09804, 0.09804),
                (0.47059, 0.10196, 0.10196),
                (0.47059, 0.10588, 0.10588),
                (0.47059, 0.10980, 0.10980),
                (0.47059, 0.11373, 0.11373),
                (0.47059, 0.11765, 0.11765),
                (0.47059, 0.12157, 0.12157),
                (0.47059, 0.12549, 0.12549),
                (0.62745, 0.12941, 0.12941),
                (0.62745, 0.13333, 0.13333),
                (0.62745, 0.13725, 0.13725),
                (0.62745, 0.14118, 0.14118),
                (0.62745, 0.14510, 0.14510),
                (0.62745, 0.14902, 0.14902),
                (0.62745, 0.15294, 0.15294),
                (0.62745, 0.15686, 0.15686),
                (0.62745, 0.16078, 0.16078),
                (0.62745, 0.16471, 0.16471),
                (0.62745, 0.16863, 0.16863),
                (0.62745, 0.17255, 0.17255),
                (0.62745, 0.17647, 0.17647),
                (0.62745, 0.18039, 0.18039),
                (0.62745, 0.18431, 0.18431),
                (0.62745, 0.18824, 0.18824),
                (0.78431, 0.19216, 0.19216),
                (0.78431, 0.19608, 0.19608),
                (0.78431, 0.20000, 0.20000),
                (0.78431, 0.20392, 0.20392),
                (0.78431, 0.20784, 0.20784),
                (0.78431, 0.21176, 0.21176),
                (0.78431, 0.21569, 0.21569),
                (0.78431, 0.21961, 0.21961),
                (0.78431, 0.22353, 0.22353),
                (0.78431, 0.22745, 0.22745),
                (0.78431, 0.23137, 0.23137),
                (0.78431, 0.23529, 0.23529),
                (0.78431, 0.23922, 0.23922),
                (0.78431, 0.24314, 0.24314),
                (0.78431, 0.24706, 0.24706),
                (0.78431, 0.25098, 0.25098),
                (0.94118, 0.25490, 0.25490),
                (0.94118, 0.25882, 0.25882),
                (0.94118, 0.26275, 0.26275),
                (0.94118, 0.26667, 0.26667),
                (0.94118, 0.27059, 0.27059),
                (0.94118, 0.27451, 0.27451),
                (0.94118, 0.27843, 0.27843),
                (0.94118, 0.28235, 0.28235),
                (0.94118, 0.28627, 0.28627),
                (0.94118, 0.29020, 0.29020),
                (0.94118, 0.29412, 0.29412),
                (0.94118, 0.29804, 0.29804),
                (0.94118, 0.30196, 0.30196),
                (0.94118, 0.30588, 0.30588),
                (0.94118, 0.30980, 0.30980),
                (0.94118, 0.31373, 0.31373),
                (0.94902, 0.39216, 0.39216),
                (0.96078, 0.52941, 0.52941),
                (0.97255, 0.66667, 0.66667),
                (0.98431, 0.80392, 0.80392),
                (0.99216, 0.80000, 0.80000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_random = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.51765),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98431, 0.81176, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.76863, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 0.89804, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.86275, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (0.92157, 0.61961, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.78431, 0.47059, 1.00000),
                (0.65882, 0.59608, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.62745, 0.62745, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.47059, 0.78431, 1.00000),
                (0.26275, 0.87843, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 0.74118),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.65490),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.36078, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.98431, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.99608, 0.97647, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98431, 0.85098, 0.00000),
                (0.98824, 0.77647, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.36863, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.46667),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (0.91373, 0.00000, 0.97255),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.70588, 0.00000, 0.90196),
                (0.53333, 0.00000, 0.87451),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.47059, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.80392),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.13725),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
        )

cmap_blue = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00000, 0.00392),
                (0.00000, 0.00000, 0.00784),
                (0.00000, 0.00000, 0.01176),
                (0.00000, 0.00000, 0.01569),
                (0.00000, 0.00000, 0.01961),
                (0.00000, 0.00000, 0.02353),
                (0.00000, 0.00000, 0.02745),
                (0.00000, 0.00000, 0.03137),
                (0.00000, 0.00000, 0.03529),
                (0.00000, 0.00000, 0.03922),
                (0.00000, 0.00000, 0.04314),
                (0.00000, 0.00000, 0.04706),
                (0.00000, 0.00000, 0.05098),
                (0.00000, 0.00000, 0.05490),
                (0.00000, 0.00000, 0.05882),
                (0.00000, 0.00000, 0.06275),
                (0.00000, 0.00000, 0.06667),
                (0.00000, 0.00000, 0.07059),
                (0.00000, 0.00000, 0.07451),
                (0.00000, 0.00000, 0.07843),
                (0.00000, 0.00000, 0.08235),
                (0.00000, 0.00000, 0.08627),
                (0.00000, 0.00000, 0.09020),
                (0.00000, 0.00000, 0.09412),
                (0.00000, 0.00000, 0.09804),
                (0.00000, 0.00000, 0.10196),
                (0.00000, 0.00000, 0.10588),
                (0.00000, 0.00000, 0.10980),
                (0.00000, 0.00000, 0.11373),
                (0.00000, 0.00000, 0.11765),
                (0.00000, 0.00000, 0.12157),
                (0.00000, 0.00000, 0.12549),
                (0.00000, 0.00000, 0.12941),
                (0.00000, 0.00000, 0.13333),
                (0.00000, 0.00000, 0.13725),
                (0.00000, 0.00000, 0.14118),
                (0.00000, 0.00000, 0.14510),
                (0.00000, 0.00000, 0.14902),
                (0.00000, 0.00000, 0.15294),
                (0.00000, 0.00000, 0.15686),
                (0.00000, 0.00000, 0.16078),
                (0.00000, 0.00000, 0.16471),
                (0.00000, 0.00000, 0.16863),
                (0.00000, 0.00000, 0.17255),
                (0.00000, 0.00000, 0.17647),
                (0.00000, 0.00000, 0.18039),
                (0.00000, 0.00000, 0.18431),
                (0.00000, 0.00000, 0.18824),
                (0.00000, 0.00000, 0.19216),
                (0.00000, 0.00000, 0.19608),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.20392),
                (0.00000, 0.00000, 0.20784),
                (0.00000, 0.00000, 0.21176),
                (0.00000, 0.00000, 0.21569),
                (0.00000, 0.00000, 0.21961),
                (0.00000, 0.00000, 0.22353),
                (0.00000, 0.00000, 0.22745),
                (0.00000, 0.00000, 0.23137),
                (0.00000, 0.00000, 0.23529),
                (0.00000, 0.00000, 0.23922),
                (0.00000, 0.00000, 0.24314),
                (0.00000, 0.00000, 0.24706),
                (0.00000, 0.00000, 0.25098),
                (0.00000, 0.00000, 0.25490),
                (0.00000, 0.00000, 0.25882),
                (0.00000, 0.00000, 0.26275),
                (0.00000, 0.00000, 0.26667),
                (0.00000, 0.00000, 0.27059),
                (0.00000, 0.00000, 0.27451),
                (0.00000, 0.00000, 0.27843),
                (0.00000, 0.00000, 0.28235),
                (0.00000, 0.00000, 0.28627),
                (0.00000, 0.00000, 0.29020),
                (0.00000, 0.00000, 0.29412),
                (0.00000, 0.00000, 0.29804),
                (0.00000, 0.00000, 0.30196),
                (0.00000, 0.00000, 0.30588),
                (0.00000, 0.00000, 0.30980),
                (0.00000, 0.00000, 0.31373),
                (0.00000, 0.00000, 0.31765),
                (0.00000, 0.00000, 0.32157),
                (0.00000, 0.00000, 0.32549),
                (0.00000, 0.00000, 0.32941),
                (0.00000, 0.00000, 0.33333),
                (0.00000, 0.00000, 0.33725),
                (0.00000, 0.00000, 0.34118),
                (0.00000, 0.00000, 0.34510),
                (0.00000, 0.00000, 0.34902),
                (0.00000, 0.00000, 0.35294),
                (0.00000, 0.00000, 0.35686),
                (0.00000, 0.00000, 0.36078),
                (0.00000, 0.00000, 0.36471),
                (0.00000, 0.00000, 0.36863),
                (0.00000, 0.00000, 0.37255),
                (0.00000, 0.00000, 0.37647),
                (0.00000, 0.00000, 0.38039),
                (0.00000, 0.00000, 0.38431),
                (0.00000, 0.00000, 0.38824),
                (0.00000, 0.00000, 0.39216),
                (0.00000, 0.00000, 0.39608),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.40392),
                (0.00000, 0.00000, 0.40784),
                (0.00000, 0.00000, 0.41176),
                (0.00000, 0.00000, 0.41569),
                (0.00000, 0.00000, 0.41961),
                (0.00000, 0.00000, 0.42353),
                (0.00000, 0.00000, 0.42745),
                (0.00000, 0.00000, 0.43137),
                (0.00000, 0.00000, 0.43529),
                (0.00000, 0.00000, 0.43922),
                (0.00000, 0.00000, 0.44314),
                (0.00000, 0.00000, 0.44706),
                (0.00000, 0.00000, 0.45098),
                (0.00000, 0.00000, 0.45490),
                (0.00000, 0.00000, 0.45882),
                (0.00000, 0.00000, 0.46275),
                (0.00000, 0.00000, 0.46667),
                (0.00000, 0.00000, 0.47059),
                (0.00000, 0.00000, 0.47451),
                (0.00000, 0.00000, 0.47843),
                (0.00000, 0.00000, 0.48235),
                (0.00000, 0.00000, 0.48627),
                (0.00000, 0.00000, 0.49020),
                (0.00000, 0.00000, 0.49412),
                (0.00000, 0.00000, 0.49804),
                (0.00000, 0.00000, 0.50196),
                (0.00000, 0.00000, 0.50588),
                (0.00000, 0.00000, 0.50980),
                (0.00000, 0.00000, 0.51373),
                (0.00000, 0.00000, 0.51765),
                (0.00000, 0.00000, 0.52157),
                (0.00000, 0.00000, 0.52549),
                (0.00000, 0.00000, 0.52941),
                (0.00000, 0.00000, 0.53333),
                (0.00000, 0.00000, 0.53725),
                (0.00000, 0.00000, 0.54118),
                (0.00000, 0.00000, 0.54510),
                (0.00000, 0.00000, 0.54902),
                (0.00000, 0.00000, 0.55294),
                (0.00000, 0.00000, 0.55686),
                (0.00000, 0.00000, 0.56078),
                (0.00000, 0.00000, 0.56471),
                (0.00000, 0.00000, 0.56863),
                (0.00000, 0.00000, 0.57255),
                (0.00000, 0.00000, 0.57647),
                (0.00000, 0.00000, 0.58039),
                (0.00000, 0.00000, 0.58431),
                (0.00000, 0.00000, 0.58824),
                (0.00000, 0.00000, 0.59216),
                (0.00000, 0.00000, 0.59608),
                (0.00000, 0.00000, 0.60000),
                (0.00000, 0.00000, 0.60392),
                (0.00000, 0.00000, 0.60784),
                (0.00000, 0.00000, 0.61176),
                (0.00000, 0.00000, 0.61569),
                (0.00000, 0.00000, 0.61961),
                (0.00000, 0.00000, 0.62353),
                (0.00000, 0.00000, 0.62745),
                (0.00000, 0.00000, 0.63137),
                (0.00000, 0.00000, 0.63529),
                (0.00000, 0.00000, 0.63922),
                (0.00000, 0.00000, 0.64314),
                (0.00000, 0.00000, 0.64706),
                (0.00000, 0.00000, 0.65098),
                (0.00000, 0.00000, 0.65490),
                (0.00000, 0.00000, 0.65882),
                (0.00000, 0.00000, 0.66275),
                (0.00000, 0.00000, 0.66667),
                (0.00000, 0.00000, 0.67059),
                (0.00000, 0.00000, 0.67451),
                (0.00000, 0.00000, 0.67843),
                (0.00000, 0.00000, 0.68235),
                (0.00000, 0.00000, 0.68627),
                (0.00000, 0.00000, 0.69020),
                (0.00000, 0.00000, 0.69412),
                (0.00000, 0.00000, 0.69804),
                (0.00000, 0.00000, 0.70196),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.70980),
                (0.00000, 0.00000, 0.71373),
                (0.00000, 0.00000, 0.71765),
                (0.00000, 0.00000, 0.72157),
                (0.00000, 0.00000, 0.72549),
                (0.00000, 0.00000, 0.72941),
                (0.00000, 0.00000, 0.73333),
                (0.00000, 0.00000, 0.73725),
                (0.00000, 0.00000, 0.74118),
                (0.00000, 0.00000, 0.74510),
                (0.00000, 0.00000, 0.74902),
                (0.00000, 0.00000, 0.75294),
                (0.00000, 0.00000, 0.75686),
                (0.00000, 0.00000, 0.76078),
                (0.00000, 0.00000, 0.76471),
                (0.00000, 0.00000, 0.76863),
                (0.00000, 0.00000, 0.77255),
                (0.00000, 0.00000, 0.77647),
                (0.00000, 0.00000, 0.78039),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78824),
                (0.00000, 0.00000, 0.79216),
                (0.00000, 0.00000, 0.79608),
                (0.00000, 0.00000, 0.80000),
                (0.00000, 0.00000, 0.80392),
                (0.00000, 0.00000, 0.80784),
                (0.00000, 0.00000, 0.81176),
                (0.00000, 0.00000, 0.81569),
                (0.00000, 0.00000, 0.81961),
                (0.00000, 0.00000, 0.82353),
                (0.00000, 0.00000, 0.82745),
                (0.00000, 0.00000, 0.83137),
                (0.00000, 0.00000, 0.83529),
                (0.00000, 0.00000, 0.83922),
                (0.00000, 0.00000, 0.84314),
                (0.00000, 0.00000, 0.84706),
                (0.00000, 0.00000, 0.85098),
                (0.00000, 0.00000, 0.85490),
                (0.00000, 0.00000, 0.85882),
                (0.00000, 0.00000, 0.86275),
                (0.00000, 0.00000, 0.86667),
                (0.00000, 0.00000, 0.87059),
                (0.00000, 0.00000, 0.87451),
                (0.00000, 0.00000, 0.87843),
                (0.00000, 0.00000, 0.88235),
                (0.00000, 0.00000, 0.88627),
                (0.00000, 0.00000, 0.89020),
                (0.00000, 0.00000, 0.89412),
                (0.00000, 0.00000, 0.89804),
                (0.00000, 0.00000, 0.90196),
                (0.00000, 0.00000, 0.90588),
                (0.00000, 0.00000, 0.90980),
                (0.00000, 0.00000, 0.91373),
                (0.00000, 0.00000, 0.91765),
                (0.00000, 0.00000, 0.92157),
                (0.00000, 0.00000, 0.92549),
                (0.00000, 0.00000, 0.92941),
                (0.00000, 0.00000, 0.93333),
                (0.00000, 0.00000, 0.93725),
                (0.00000, 0.00000, 0.94118),
                (0.00000, 0.00000, 0.94510),
                (0.00000, 0.00000, 0.94902),
                (0.00000, 0.00000, 0.95294),
                (0.00000, 0.00000, 0.95686),
                (0.00000, 0.00000, 0.96078),
                (0.00000, 0.00000, 0.96471),
                (0.00000, 0.00000, 0.96863),
                (0.00000, 0.00000, 0.97255),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 0.98039),
                (0.00000, 0.00392, 0.98431),
                (0.00000, 0.00784, 0.98824),
                (0.00000, 0.01176, 0.99216),
                (0.00000, 0.01569, 0.99608),
                (0.00000, 0.00392, 1.00000),
        )

cmap_red = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00392, 0.00000, 0.00000),
                (0.00784, 0.00000, 0.00000),
                (0.01176, 0.00000, 0.00000),
                (0.01569, 0.00000, 0.00000),
                (0.01961, 0.00000, 0.00000),
                (0.02353, 0.00000, 0.00000),
                (0.02745, 0.00000, 0.00000),
                (0.03137, 0.00000, 0.00000),
                (0.03529, 0.00000, 0.00000),
                (0.03922, 0.00000, 0.00000),
                (0.04314, 0.00000, 0.00000),
                (0.04706, 0.00000, 0.00000),
                (0.05098, 0.00000, 0.00000),
                (0.05490, 0.00000, 0.00000),
                (0.05882, 0.00000, 0.00000),
                (0.06275, 0.00000, 0.00000),
                (0.06667, 0.00000, 0.00000),
                (0.07059, 0.00000, 0.00000),
                (0.07451, 0.00000, 0.00000),
                (0.07843, 0.00000, 0.00000),
                (0.08235, 0.00000, 0.00000),
                (0.08627, 0.00000, 0.00000),
                (0.09020, 0.00000, 0.00000),
                (0.09412, 0.00000, 0.00000),
                (0.09804, 0.00000, 0.00000),
                (0.10196, 0.00000, 0.00000),
                (0.10588, 0.00000, 0.00000),
                (0.10980, 0.00000, 0.00000),
                (0.11373, 0.00000, 0.00000),
                (0.11765, 0.00000, 0.00000),
                (0.12157, 0.00000, 0.00000),
                (0.12549, 0.00000, 0.00000),
                (0.12941, 0.00000, 0.00000),
                (0.13333, 0.00000, 0.00000),
                (0.13725, 0.00000, 0.00000),
                (0.14118, 0.00000, 0.00000),
                (0.14510, 0.00000, 0.00000),
                (0.14902, 0.00000, 0.00000),
                (0.15294, 0.00000, 0.00000),
                (0.15686, 0.00000, 0.00000),
                (0.16078, 0.00000, 0.00000),
                (0.16471, 0.00000, 0.00000),
                (0.16863, 0.00000, 0.00000),
                (0.17255, 0.00000, 0.00000),
                (0.17647, 0.00000, 0.00000),
                (0.18039, 0.00000, 0.00000),
                (0.18431, 0.00000, 0.00000),
                (0.18824, 0.00000, 0.00000),
                (0.19216, 0.00000, 0.00000),
                (0.19608, 0.00000, 0.00000),
                (0.20000, 0.00000, 0.00000),
                (0.20392, 0.00000, 0.00000),
                (0.20784, 0.00000, 0.00000),
                (0.21176, 0.00000, 0.00000),
                (0.21569, 0.00000, 0.00000),
                (0.21961, 0.00000, 0.00000),
                (0.22353, 0.00000, 0.00000),
                (0.22745, 0.00000, 0.00000),
                (0.23137, 0.00000, 0.00000),
                (0.23529, 0.00000, 0.00000),
                (0.23922, 0.00000, 0.00000),
                (0.24314, 0.00000, 0.00000),
                (0.24706, 0.00000, 0.00000),
                (0.25098, 0.00000, 0.00000),
                (0.25490, 0.00000, 0.00000),
                (0.25882, 0.00000, 0.00000),
                (0.26275, 0.00000, 0.00000),
                (0.26667, 0.00000, 0.00000),
                (0.27059, 0.00000, 0.00000),
                (0.27451, 0.00000, 0.00000),
                (0.27843, 0.00000, 0.00000),
                (0.28235, 0.00000, 0.00000),
                (0.28627, 0.00000, 0.00000),
                (0.29020, 0.00000, 0.00000),
                (0.29412, 0.00000, 0.00000),
                (0.29804, 0.00000, 0.00000),
                (0.30196, 0.00000, 0.00000),
                (0.30588, 0.00000, 0.00000),
                (0.30980, 0.00000, 0.00000),
                (0.31373, 0.00000, 0.00000),
                (0.31765, 0.00000, 0.00000),
                (0.32157, 0.00000, 0.00000),
                (0.32549, 0.00000, 0.00000),
                (0.32941, 0.00000, 0.00000),
                (0.33333, 0.00000, 0.00000),
                (0.33725, 0.00000, 0.00000),
                (0.34118, 0.00000, 0.00000),
                (0.34510, 0.00000, 0.00000),
                (0.34902, 0.00000, 0.00000),
                (0.35294, 0.00000, 0.00000),
                (0.35686, 0.00000, 0.00000),
                (0.36078, 0.00000, 0.00000),
                (0.36471, 0.00000, 0.00000),
                (0.36863, 0.00000, 0.00000),
                (0.37255, 0.00000, 0.00000),
                (0.37647, 0.00000, 0.00000),
                (0.38039, 0.00000, 0.00000),
                (0.38431, 0.00000, 0.00000),
                (0.38824, 0.00000, 0.00000),
                (0.39216, 0.00000, 0.00000),
                (0.39608, 0.00000, 0.00000),
                (0.40000, 0.00000, 0.00000),
                (0.40392, 0.00000, 0.00000),
                (0.40784, 0.00000, 0.00000),
                (0.41176, 0.00000, 0.00000),
                (0.41569, 0.00000, 0.00000),
                (0.41961, 0.00000, 0.00000),
                (0.42353, 0.00000, 0.00000),
                (0.42745, 0.00000, 0.00000),
                (0.43137, 0.00000, 0.00000),
                (0.43529, 0.00000, 0.00000),
                (0.43922, 0.00000, 0.00000),
                (0.44314, 0.00000, 0.00000),
                (0.44706, 0.00000, 0.00000),
                (0.45098, 0.00000, 0.00000),
                (0.45490, 0.00000, 0.00000),
                (0.45882, 0.00000, 0.00000),
                (0.46275, 0.00000, 0.00000),
                (0.46667, 0.00000, 0.00000),
                (0.47059, 0.00000, 0.00000),
                (0.47451, 0.00000, 0.00000),
                (0.47843, 0.00000, 0.00000),
                (0.48235, 0.00000, 0.00000),
                (0.48627, 0.00000, 0.00000),
                (0.49020, 0.00000, 0.00000),
                (0.49412, 0.00000, 0.00000),
                (0.49804, 0.00000, 0.00000),
                (0.50196, 0.00000, 0.00000),
                (0.50588, 0.00000, 0.00000),
                (0.50980, 0.00000, 0.00000),
                (0.51373, 0.00000, 0.00000),
                (0.51765, 0.00000, 0.00000),
                (0.52157, 0.00000, 0.00000),
                (0.52549, 0.00000, 0.00000),
                (0.52941, 0.00000, 0.00000),
                (0.53333, 0.00000, 0.00000),
                (0.53725, 0.00000, 0.00000),
                (0.54118, 0.00000, 0.00000),
                (0.54510, 0.00000, 0.00000),
                (0.54902, 0.00000, 0.00000),
                (0.55294, 0.00000, 0.00000),
                (0.55686, 0.00000, 0.00000),
                (0.56078, 0.00000, 0.00000),
                (0.56471, 0.00000, 0.00000),
                (0.56863, 0.00000, 0.00000),
                (0.57255, 0.00000, 0.00000),
                (0.57647, 0.00000, 0.00000),
                (0.58039, 0.00000, 0.00000),
                (0.58431, 0.00000, 0.00000),
                (0.58824, 0.00000, 0.00000),
                (0.59216, 0.00000, 0.00000),
                (0.59608, 0.00000, 0.00000),
                (0.60000, 0.00000, 0.00000),
                (0.60392, 0.00000, 0.00000),
                (0.60784, 0.00000, 0.00000),
                (0.61176, 0.00000, 0.00000),
                (0.61569, 0.00000, 0.00000),
                (0.61961, 0.00000, 0.00000),
                (0.62353, 0.00000, 0.00000),
                (0.62745, 0.00000, 0.00000),
                (0.63137, 0.00000, 0.00000),
                (0.63529, 0.00000, 0.00000),
                (0.63922, 0.00000, 0.00000),
                (0.64314, 0.00000, 0.00000),
                (0.64706, 0.00000, 0.00000),
                (0.65098, 0.00000, 0.00000),
                (0.65490, 0.00000, 0.00000),
                (0.65882, 0.00000, 0.00000),
                (0.66275, 0.00000, 0.00000),
                (0.66667, 0.00000, 0.00000),
                (0.67059, 0.00000, 0.00000),
                (0.67451, 0.00000, 0.00000),
                (0.67843, 0.00000, 0.00000),
                (0.68235, 0.00000, 0.00000),
                (0.68627, 0.00000, 0.00000),
                (0.69020, 0.00000, 0.00000),
                (0.69412, 0.00000, 0.00000),
                (0.69804, 0.00000, 0.00000),
                (0.70196, 0.00000, 0.00000),
                (0.70588, 0.00000, 0.00000),
                (0.70980, 0.00000, 0.00000),
                (0.71373, 0.00000, 0.00000),
                (0.71765, 0.00000, 0.00000),
                (0.72157, 0.00000, 0.00000),
                (0.72549, 0.00000, 0.00000),
                (0.72941, 0.00000, 0.00000),
                (0.73333, 0.00000, 0.00000),
                (0.73725, 0.00000, 0.00000),
                (0.74118, 0.00000, 0.00000),
                (0.74510, 0.00000, 0.00000),
                (0.74902, 0.00000, 0.00000),
                (0.75294, 0.00000, 0.00000),
                (0.75686, 0.00000, 0.00000),
                (0.76078, 0.00000, 0.00000),
                (0.76471, 0.00000, 0.00000),
                (0.76863, 0.00000, 0.00000),
                (0.77255, 0.00000, 0.00000),
                (0.77647, 0.00000, 0.00000),
                (0.78039, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.79216, 0.00000, 0.00000),
                (0.79608, 0.00000, 0.00000),
                (0.80000, 0.00000, 0.00000),
                (0.80392, 0.00000, 0.00000),
                (0.80784, 0.00000, 0.00000),
                (0.81176, 0.00000, 0.00000),
                (0.81569, 0.00000, 0.00000),
                (0.81961, 0.00000, 0.00000),
                (0.82353, 0.00000, 0.00000),
                (0.82745, 0.00000, 0.00000),
                (0.83137, 0.00000, 0.00000),
                (0.83529, 0.00000, 0.00000),
                (0.83922, 0.00000, 0.00000),
                (0.84314, 0.00000, 0.00000),
                (0.84706, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.85490, 0.00000, 0.00000),
                (0.85882, 0.00000, 0.00000),
                (0.86275, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.87059, 0.00000, 0.00000),
                (0.87451, 0.00000, 0.00000),
                (0.87843, 0.00000, 0.00000),
                (0.88235, 0.00000, 0.00000),
                (0.88627, 0.00000, 0.00000),
                (0.89020, 0.00000, 0.00000),
                (0.89412, 0.00000, 0.00000),
                (0.89804, 0.00000, 0.00000),
                (0.90196, 0.00000, 0.00000),
                (0.90588, 0.00000, 0.00000),
                (0.90980, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.91765, 0.00000, 0.00000),
                (0.92157, 0.00000, 0.00000),
                (0.92549, 0.00000, 0.00000),
                (0.92941, 0.00000, 0.00000),
                (0.93333, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.94118, 0.00000, 0.00000),
                (0.94510, 0.00000, 0.00000),
                (0.94902, 0.00000, 0.00000),
                (0.95294, 0.00000, 0.00000),
                (0.95686, 0.00000, 0.00000),
                (0.96078, 0.00000, 0.00000),
                (0.96471, 0.00000, 0.00000),
                (0.96863, 0.00000, 0.00000),
                (0.97255, 0.00000, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.98039, 0.00000, 0.00000),
                (0.98431, 0.00000, 0.00000),
                (0.98824, 0.00000, 0.00000),
                (0.99216, 0.00000, 0.00000),
                (0.99608, 0.00000, 0.00392),
                (1.00000, 0.00000, 0.00784),
        )

cmap_aips0 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.47451, 0.00000, 0.60784),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.00000, 0.00000, 0.78431),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.37255, 0.65490, 0.92549),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.69412, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
        )

cmap_stairs8 = (
                (0.76471, 0.00000, 1.00000),  # noqa
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (0.76471, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_idl11 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.00392, 0.00392),
                (0.00000, 0.00784, 0.00784),
                (0.00000, 0.01176, 0.01176),
                (0.00000, 0.01569, 0.01569),
                (0.00000, 0.03137, 0.03137),
                (0.00000, 0.04706, 0.04706),
                (0.00000, 0.06275, 0.06275),
                (0.00000, 0.08235, 0.08235),
                (0.00000, 0.09804, 0.09804),
                (0.00000, 0.11373, 0.11373),
                (0.00000, 0.12941, 0.12941),
                (0.00000, 0.14902, 0.14902),
                (0.00000, 0.16471, 0.16471),
                (0.00000, 0.18039, 0.18039),
                (0.00000, 0.19608, 0.19608),
                (0.00000, 0.21569, 0.21569),
                (0.00000, 0.23137, 0.23137),
                (0.00000, 0.24706, 0.24706),
                (0.00000, 0.26275, 0.26275),
                (0.00000, 0.28235, 0.28235),
                (0.00000, 0.29804, 0.29804),
                (0.00000, 0.31373, 0.31373),
                (0.00000, 0.32941, 0.32941),
                (0.00000, 0.34902, 0.34902),
                (0.00000, 0.36471, 0.36471),
                (0.00000, 0.38039, 0.38039),
                (0.00000, 0.39608, 0.39608),
                (0.00000, 0.41569, 0.41569),
                (0.00000, 0.43137, 0.43137),
                (0.00000, 0.44706, 0.44706),
                (0.00000, 0.46275, 0.46275),
                (0.00000, 0.48235, 0.48235),
                (0.00000, 0.49804, 0.49804),
                (0.00000, 0.51373, 0.51373),
                (0.00000, 0.52941, 0.52941),
                (0.00000, 0.54902, 0.54902),
                (0.00000, 0.56471, 0.56471),
                (0.00000, 0.58039, 0.58039),
                (0.00000, 0.59608, 0.59608),
                (0.00000, 0.61569, 0.61569),
                (0.00000, 0.63137, 0.63137),
                (0.00000, 0.64706, 0.64706),
                (0.00000, 0.66275, 0.66275),
                (0.00000, 0.68235, 0.68235),
                (0.00000, 0.69804, 0.69804),
                (0.00000, 0.71373, 0.71373),
                (0.00000, 0.72941, 0.72941),
                (0.00000, 0.74902, 0.74902),
                (0.00000, 0.76471, 0.76471),
                (0.00000, 0.78039, 0.78039),
                (0.00000, 0.79608, 0.79608),
                (0.00000, 0.81569, 0.81569),
                (0.00000, 0.83137, 0.83137),
                (0.00000, 0.84706, 0.84706),
                (0.00000, 0.86275, 0.86275),
                (0.00000, 0.88235, 0.88235),
                (0.00000, 0.89804, 0.89804),
                (0.00000, 0.91373, 0.91373),
                (0.00000, 0.92941, 0.92941),
                (0.00000, 0.94902, 0.94902),
                (0.00000, 0.96471, 0.96471),
                (0.00000, 0.98039, 0.98039),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 0.98431, 1.00000),
                (0.00000, 0.96863, 1.00000),
                (0.00000, 0.95294, 1.00000),
                (0.00000, 0.93725, 1.00000),
                (0.00000, 0.92157, 1.00000),
                (0.00000, 0.90588, 1.00000),
                (0.00000, 0.89020, 1.00000),
                (0.00000, 0.87451, 1.00000),
                (0.00000, 0.85882, 1.00000),
                (0.00000, 0.84314, 1.00000),
                (0.00000, 0.82745, 1.00000),
                (0.00000, 0.81176, 1.00000),
                (0.00000, 0.79608, 1.00000),
                (0.00000, 0.78039, 1.00000),
                (0.00000, 0.76471, 1.00000),
                (0.00000, 0.74902, 1.00000),
                (0.00000, 0.73333, 1.00000),
                (0.00000, 0.71765, 1.00000),
                (0.00000, 0.70196, 1.00000),
                (0.00000, 0.68627, 1.00000),
                (0.00000, 0.66667, 1.00000),
                (0.00000, 0.65098, 1.00000),
                (0.00000, 0.63529, 1.00000),
                (0.00000, 0.61961, 1.00000),
                (0.00000, 0.60392, 1.00000),
                (0.00000, 0.58824, 1.00000),
                (0.00000, 0.57255, 1.00000),
                (0.00000, 0.55686, 1.00000),
                (0.00000, 0.54118, 1.00000),
                (0.00000, 0.52549, 1.00000),
                (0.00000, 0.50980, 1.00000),
                (0.00000, 0.49412, 1.00000),
                (0.00000, 0.47843, 1.00000),
                (0.00000, 0.46275, 1.00000),
                (0.00000, 0.44706, 1.00000),
                (0.00000, 0.43137, 1.00000),
                (0.00000, 0.41569, 1.00000),
                (0.00000, 0.40000, 1.00000),
                (0.00000, 0.38431, 1.00000),
                (0.00000, 0.36863, 1.00000),
                (0.00000, 0.35294, 1.00000),
                (0.00000, 0.33333, 1.00000),
                (0.00000, 0.31765, 1.00000),
                (0.00000, 0.30196, 1.00000),
                (0.00000, 0.28627, 1.00000),
                (0.00000, 0.27059, 1.00000),
                (0.00000, 0.25490, 1.00000),
                (0.00000, 0.23922, 1.00000),
                (0.00000, 0.22353, 1.00000),
                (0.00000, 0.20784, 1.00000),
                (0.00000, 0.19216, 1.00000),
                (0.00000, 0.17647, 1.00000),
                (0.00000, 0.16078, 1.00000),
                (0.00000, 0.14510, 1.00000),
                (0.00000, 0.12941, 1.00000),
                (0.00000, 0.11373, 1.00000),
                (0.00000, 0.09804, 1.00000),
                (0.00000, 0.08235, 1.00000),
                (0.00000, 0.06667, 1.00000),
                (0.00000, 0.05098, 1.00000),
                (0.00000, 0.03529, 1.00000),
                (0.00000, 0.01961, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.01569, 0.00000, 1.00000),
                (0.03137, 0.00000, 1.00000),
                (0.04706, 0.00000, 1.00000),
                (0.06275, 0.00000, 1.00000),
                (0.07843, 0.00000, 1.00000),
                (0.09412, 0.00000, 1.00000),
                (0.10980, 0.00000, 1.00000),
                (0.12549, 0.00000, 1.00000),
                (0.14118, 0.00000, 1.00000),
                (0.15686, 0.00000, 1.00000),
                (0.17255, 0.00000, 1.00000),
                (0.18824, 0.00000, 1.00000),
                (0.20392, 0.00000, 1.00000),
                (0.21961, 0.00000, 1.00000),
                (0.23529, 0.00000, 1.00000),
                (0.25098, 0.00000, 1.00000),
                (0.26667, 0.00000, 1.00000),
                (0.28235, 0.00000, 1.00000),
                (0.29804, 0.00000, 1.00000),
                (0.31373, 0.00000, 1.00000),
                (0.33333, 0.00000, 1.00000),
                (0.34902, 0.00000, 1.00000),
                (0.36471, 0.00000, 1.00000),
                (0.38039, 0.00000, 1.00000),
                (0.39608, 0.00000, 1.00000),
                (0.41176, 0.00000, 1.00000),
                (0.42745, 0.00000, 1.00000),
                (0.44314, 0.00000, 1.00000),
                (0.45882, 0.00000, 1.00000),
                (0.47451, 0.00000, 1.00000),
                (0.49020, 0.00000, 1.00000),
                (0.50588, 0.00000, 1.00000),
                (0.52157, 0.00000, 1.00000),
                (0.53725, 0.00000, 1.00000),
                (0.55294, 0.00000, 1.00000),
                (0.56863, 0.00000, 1.00000),
                (0.58431, 0.00000, 1.00000),
                (0.60000, 0.00000, 1.00000),
                (0.61569, 0.00000, 1.00000),
                (0.63137, 0.00000, 1.00000),
                (0.64706, 0.00000, 1.00000),
                (0.66667, 0.00000, 1.00000),
                (0.68235, 0.00000, 1.00000),
                (0.69804, 0.00000, 1.00000),
                (0.71373, 0.00000, 1.00000),
                (0.72941, 0.00000, 1.00000),
                (0.74510, 0.00000, 1.00000),
                (0.76078, 0.00000, 1.00000),
                (0.77647, 0.00000, 1.00000),
                (0.79216, 0.00000, 1.00000),
                (0.80784, 0.00000, 1.00000),
                (0.82353, 0.00000, 1.00000),
                (0.83922, 0.00000, 1.00000),
                (0.85490, 0.00000, 1.00000),
                (0.87059, 0.00000, 1.00000),
                (0.88627, 0.00000, 1.00000),
                (0.90196, 0.00000, 1.00000),
                (0.91765, 0.00000, 1.00000),
                (0.93333, 0.00000, 1.00000),
                (0.94902, 0.00000, 1.00000),
                (0.96471, 0.00000, 1.00000),
                (0.98039, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.00000, 0.98431),
                (1.00000, 0.00000, 0.96863),
                (1.00000, 0.00000, 0.95294),
                (1.00000, 0.00000, 0.93725),
                (1.00000, 0.00000, 0.92157),
                (1.00000, 0.00000, 0.90588),
                (1.00000, 0.00000, 0.89020),
                (1.00000, 0.00000, 0.87451),
                (1.00000, 0.00000, 0.85490),
                (1.00000, 0.00000, 0.83922),
                (1.00000, 0.00000, 0.82353),
                (1.00000, 0.00000, 0.80784),
                (1.00000, 0.00000, 0.79216),
                (1.00000, 0.00000, 0.77647),
                (1.00000, 0.00000, 0.76078),
                (1.00000, 0.00000, 0.74510),
                (1.00000, 0.00000, 0.72941),
                (1.00000, 0.00000, 0.70980),
                (1.00000, 0.00000, 0.69412),
                (1.00000, 0.00000, 0.67843),
                (1.00000, 0.00000, 0.66275),
                (1.00000, 0.00000, 0.64706),
                (1.00000, 0.00000, 0.63137),
                (1.00000, 0.00000, 0.61569),
                (1.00000, 0.00000, 0.60000),
                (1.00000, 0.00000, 0.58431),
                (1.00000, 0.00000, 0.56471),
                (1.00000, 0.00000, 0.54902),
                (1.00000, 0.00000, 0.53333),
                (1.00000, 0.00000, 0.51765),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.48627),
                (1.00000, 0.00000, 0.47059),
                (1.00000, 0.00000, 0.45490),
                (1.00000, 0.00000, 0.43922),
                (1.00000, 0.00000, 0.41961),
                (1.00000, 0.00000, 0.40392),
                (1.00000, 0.00000, 0.38824),
                (1.00000, 0.00000, 0.37255),
                (1.00000, 0.00000, 0.35686),
                (1.00000, 0.00000, 0.34118),
                (1.00000, 0.00000, 0.32549),
                (1.00000, 0.00000, 0.30980),
                (1.00000, 0.00000, 0.29412),
                (1.00000, 0.00000, 0.27451),
                (1.00000, 0.00000, 0.25882),
                (1.00000, 0.00000, 0.24314),
                (1.00000, 0.00000, 0.22745),
                (1.00000, 0.00000, 0.21176),
                (1.00000, 0.00000, 0.19608),
                (1.00000, 0.00000, 0.18039),
                (1.00000, 0.00000, 0.16471),
                (1.00000, 0.00000, 0.14902),
                (1.00000, 0.00000, 0.12941),
                (1.00000, 0.00000, 0.11373),
                (1.00000, 0.00000, 0.09804),
                (1.00000, 0.00000, 0.08235),
                (1.00000, 0.00000, 0.06667),
                (1.00000, 0.00000, 0.05098),
                (1.00000, 0.00000, 0.03529),
                (1.00000, 0.00000, 0.01961),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
        )

cmap_stairs9 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.19608, 0.19608, 0.19608),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.60784, 0.00000, 0.47451),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.78431, 0.00000, 0.00000),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.92549, 0.65490, 0.37255),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.56863, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.69412, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
        )

cmap_backgr = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.01587, 0.01587, 0.01587),
                (0.03174, 0.03174, 0.03174),
                (0.04761, 0.04761, 0.04761),
                (0.06348, 0.06348, 0.06348),
                (0.07935, 0.07935, 0.07935),
                (0.09522, 0.09522, 0.09522),
                (0.11109, 0.11109, 0.11109),
                (0.12696, 0.12696, 0.12696),
                (0.14283, 0.14283, 0.14283),
                (0.15870, 0.15870, 0.15870),
                (0.17457, 0.17457, 0.17457),
                (0.19044, 0.19044, 0.19044),
                (0.20631, 0.20631, 0.20631),
                (0.22218, 0.22218, 0.22218),
                (0.23805, 0.23805, 0.23805),
                (0.25392, 0.25392, 0.25392),
                (0.26979, 0.26979, 0.26979),
                (0.28566, 0.28566, 0.28566),
                (0.30153, 0.30153, 0.30153),
                (0.31740, 0.31740, 0.31740),
                (0.33327, 0.33327, 0.33327),
                (0.34914, 0.34914, 0.34914),
                (0.36501, 0.36501, 0.36501),
                (0.38088, 0.38088, 0.38088),
                (0.39675, 0.39675, 0.39675),
                (0.41262, 0.41262, 0.41262),
                (0.42849, 0.42849, 0.42849),
                (0.44436, 0.44436, 0.44436),
                (0.46023, 0.46023, 0.46023),
                (0.47610, 0.47610, 0.47610),
                (0.49197, 0.49197, 0.49197),
                (0.50784, 0.50784, 0.50784),
                (0.52371, 0.52371, 0.52371),
                (0.53958, 0.53958, 0.53958),
                (0.55545, 0.55545, 0.55545),
                (0.57132, 0.57132, 0.57132),
                (0.58719, 0.58719, 0.58719),
                (0.60306, 0.60306, 0.60306),
                (0.61893, 0.61893, 0.61893),
                (0.63480, 0.63480, 0.63480),
                (0.65067, 0.65067, 0.65067),
                (0.66654, 0.66654, 0.66654),
                (0.68241, 0.68241, 0.68241),
                (0.69828, 0.69828, 0.69828),
                (0.71415, 0.71415, 0.71415),
                (0.73002, 0.73002, 0.73002),
                (0.74589, 0.74589, 0.74589),
                (0.76176, 0.76176, 0.76176),
                (0.77763, 0.77763, 0.77763),
                (0.79350, 0.79350, 0.79350),
                (0.80937, 0.80937, 0.80937),
                (0.82524, 0.82524, 0.82524),
                (0.84111, 0.84111, 0.84111),
                (0.85698, 0.85698, 0.85698),
                (0.87285, 0.87285, 0.87285),
                (0.88872, 0.88872, 0.88872),
                (0.90459, 0.90459, 0.90459),
                (0.92046, 0.92046, 0.92046),
                (0.93633, 0.93633, 0.93633),
                (0.95220, 0.95220, 0.95220),
                (0.96807, 0.96807, 0.96807),
                (0.98394, 0.98394, 0.98394),
                (0.99981, 0.99981, 0.99981),
                (0.00000, 0.00000, 0.99981),
                (0.00000, 0.01587, 0.98394),
                (0.00000, 0.03174, 0.96807),
                (0.00000, 0.04761, 0.95220),
                (0.00000, 0.06348, 0.93633),
                (0.00000, 0.07935, 0.92046),
                (0.00000, 0.09522, 0.90459),
                (0.00000, 0.11109, 0.88872),
                (0.00000, 0.12696, 0.87285),
                (0.00000, 0.14283, 0.85698),
                (0.00000, 0.15870, 0.84111),
                (0.00000, 0.17457, 0.82524),
                (0.00000, 0.19044, 0.80937),
                (0.00000, 0.20631, 0.79350),
                (0.00000, 0.22218, 0.77763),
                (0.00000, 0.23805, 0.76176),
                (0.00000, 0.25392, 0.74589),
                (0.00000, 0.26979, 0.73002),
                (0.00000, 0.28566, 0.71415),
                (0.00000, 0.30153, 0.69828),
                (0.00000, 0.31740, 0.68241),
                (0.00000, 0.33327, 0.66654),
                (0.00000, 0.34914, 0.65067),
                (0.00000, 0.36501, 0.63480),
                (0.00000, 0.38088, 0.61893),
                (0.00000, 0.39675, 0.60306),
                (0.00000, 0.41262, 0.58719),
                (0.00000, 0.42849, 0.57132),
                (0.00000, 0.44436, 0.55545),
                (0.00000, 0.46023, 0.53958),
                (0.00000, 0.47610, 0.52371),
                (0.00000, 0.49197, 0.50784),
                (0.00000, 0.50784, 0.49197),
                (0.00000, 0.52371, 0.47610),
                (0.00000, 0.53958, 0.46023),
                (0.00000, 0.55545, 0.44436),
                (0.00000, 0.57132, 0.42849),
                (0.00000, 0.58719, 0.41262),
                (0.00000, 0.60306, 0.39675),
                (0.00000, 0.61893, 0.38088),
                (0.00000, 0.63480, 0.36501),
                (0.00000, 0.65067, 0.34914),
                (0.00000, 0.66654, 0.33327),
                (0.00000, 0.68241, 0.31740),
                (0.00000, 0.69828, 0.30153),
                (0.00000, 0.71415, 0.28566),
                (0.00000, 0.73002, 0.26979),
                (0.00000, 0.74589, 0.25392),
                (0.00000, 0.76176, 0.23805),
                (0.00000, 0.77763, 0.22218),
                (0.00000, 0.79350, 0.20631),
                (0.00000, 0.80937, 0.19044),
                (0.00000, 0.82524, 0.17457),
                (0.00000, 0.84111, 0.15870),
                (0.00000, 0.85698, 0.14283),
                (0.00000, 0.87285, 0.12696),
                (0.00000, 0.88872, 0.11109),
                (0.00000, 0.90459, 0.09522),
                (0.00000, 0.92046, 0.07935),
                (0.00000, 0.93633, 0.06348),
                (0.00000, 0.95220, 0.04761),
                (0.00000, 0.96807, 0.03174),
                (0.00000, 0.98394, 0.01587),
                (0.00000, 0.99981, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.01587, 1.00000, 0.00000),
                (0.03174, 1.00000, 0.00000),
                (0.04761, 1.00000, 0.00000),
                (0.06348, 1.00000, 0.00000),
                (0.07935, 1.00000, 0.00000),
                (0.09522, 1.00000, 0.00000),
                (0.11109, 1.00000, 0.00000),
                (0.12696, 1.00000, 0.00000),
                (0.14283, 1.00000, 0.00000),
                (0.15870, 1.00000, 0.00000),
                (0.17457, 1.00000, 0.00000),
                (0.19044, 1.00000, 0.00000),
                (0.20631, 1.00000, 0.00000),
                (0.22218, 1.00000, 0.00000),
                (0.23805, 1.00000, 0.00000),
                (0.25392, 1.00000, 0.00000),
                (0.26979, 1.00000, 0.00000),
                (0.28566, 1.00000, 0.00000),
                (0.30153, 1.00000, 0.00000),
                (0.31740, 1.00000, 0.00000),
                (0.33327, 1.00000, 0.00000),
                (0.34914, 1.00000, 0.00000),
                (0.36501, 1.00000, 0.00000),
                (0.38088, 1.00000, 0.00000),
                (0.39675, 1.00000, 0.00000),
                (0.41262, 1.00000, 0.00000),
                (0.42849, 1.00000, 0.00000),
                (0.44436, 1.00000, 0.00000),
                (0.46023, 1.00000, 0.00000),
                (0.47610, 1.00000, 0.00000),
                (0.49197, 1.00000, 0.00000),
                (0.50784, 1.00000, 0.00000),
                (0.52371, 1.00000, 0.00000),
                (0.53958, 1.00000, 0.00000),
                (0.55545, 1.00000, 0.00000),
                (0.57132, 1.00000, 0.00000),
                (0.58719, 1.00000, 0.00000),
                (0.60306, 1.00000, 0.00000),
                (0.61893, 1.00000, 0.00000),
                (0.63480, 1.00000, 0.00000),
                (0.65067, 1.00000, 0.00000),
                (0.66654, 1.00000, 0.00000),
                (0.68241, 1.00000, 0.00000),
                (0.69828, 1.00000, 0.00000),
                (0.71415, 1.00000, 0.00000),
                (0.73002, 1.00000, 0.00000),
                (0.74589, 1.00000, 0.00000),
                (0.76176, 1.00000, 0.00000),
                (0.77763, 1.00000, 0.00000),
                (0.79350, 1.00000, 0.00000),
                (0.80937, 1.00000, 0.00000),
                (0.82524, 1.00000, 0.00000),
                (0.84111, 1.00000, 0.00000),
                (0.85698, 1.00000, 0.00000),
                (0.87285, 1.00000, 0.00000),
                (0.88872, 1.00000, 0.00000),
                (0.90459, 1.00000, 0.00000),
                (0.92046, 1.00000, 0.00000),
                (0.93633, 1.00000, 0.00000),
                (0.95220, 1.00000, 0.00000),
                (0.96807, 1.00000, 0.00000),
                (0.98394, 1.00000, 0.00000),
                (0.99981, 1.00000, 0.00000),
                (1.00000, 0.99981, 0.00000),
                (1.00000, 0.98394, 0.00000),
                (1.00000, 0.96807, 0.00000),
                (1.00000, 0.95220, 0.00000),
                (1.00000, 0.93633, 0.00000),
                (1.00000, 0.92046, 0.00000),
                (1.00000, 0.90459, 0.00000),
                (1.00000, 0.88872, 0.00000),
                (1.00000, 0.87285, 0.00000),
                (1.00000, 0.85698, 0.00000),
                (1.00000, 0.84111, 0.00000),
                (1.00000, 0.82524, 0.00000),
                (1.00000, 0.80937, 0.00000),
                (1.00000, 0.79350, 0.00000),
                (1.00000, 0.77763, 0.00000),
                (1.00000, 0.76176, 0.00000),
                (1.00000, 0.74589, 0.00000),
                (1.00000, 0.73002, 0.00000),
                (1.00000, 0.71415, 0.00000),
                (1.00000, 0.69828, 0.00000),
                (1.00000, 0.68241, 0.00000),
                (1.00000, 0.66654, 0.00000),
                (1.00000, 0.65067, 0.00000),
                (1.00000, 0.63480, 0.00000),
                (1.00000, 0.61893, 0.00000),
                (1.00000, 0.60306, 0.00000),
                (1.00000, 0.58719, 0.00000),
                (1.00000, 0.57132, 0.00000),
                (1.00000, 0.55545, 0.00000),
                (1.00000, 0.53958, 0.00000),
                (1.00000, 0.52371, 0.00000),
                (1.00000, 0.50784, 0.00000),
                (1.00000, 0.49197, 0.00000),
                (1.00000, 0.47610, 0.00000),
                (1.00000, 0.46023, 0.00000),
                (1.00000, 0.44436, 0.00000),
                (1.00000, 0.42849, 0.00000),
                (1.00000, 0.41262, 0.00000),
                (1.00000, 0.39675, 0.00000),
                (1.00000, 0.38088, 0.00000),
                (1.00000, 0.36501, 0.00000),
                (1.00000, 0.34914, 0.00000),
                (1.00000, 0.33327, 0.00000),
                (1.00000, 0.31740, 0.00000),
                (1.00000, 0.30153, 0.00000),
                (1.00000, 0.28566, 0.00000),
                (1.00000, 0.26979, 0.00000),
                (1.00000, 0.25392, 0.00000),
                (1.00000, 0.23805, 0.00000),
                (1.00000, 0.22218, 0.00000),
                (1.00000, 0.20631, 0.00000),
                (1.00000, 0.19044, 0.00000),
                (1.00000, 0.17457, 0.00000),
                (1.00000, 0.15870, 0.00000),
                (1.00000, 0.14283, 0.00000),
                (1.00000, 0.12696, 0.00000),
                (1.00000, 0.11109, 0.00000),
                (1.00000, 0.09522, 0.00000),
                (1.00000, 0.07935, 0.00000),
                (1.00000, 0.06348, 0.00000),
                (1.00000, 0.04761, 0.00000),
                (1.00000, 0.03174, 0.00000),
                (1.00000, 0.01587, 0.00000),
                (1.00000, 0.00000, 0.00000),
        )

cmap_idl12 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.32941, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 0.65882, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.32941),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (0.50196, 0.00000, 1.00000),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.50196),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.25098),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (0.86275, 0.74510, 0.74510),
                (0.86275, 0.74510, 0.74510),
                (0.86275, 0.74510, 0.74510),
                (0.86275, 0.74510, 0.74510),
                (0.86275, 0.74510, 0.74510),
                (0.86667, 0.74510, 0.74510),
                (0.86667, 0.74510, 0.74510),
                (0.86667, 0.74510, 0.74510),
                (0.86667, 0.74510, 0.74510),
                (0.86667, 0.74510, 0.74510),
                (0.87059, 0.74510, 0.74510),
                (0.87059, 0.74510, 0.74510),
                (0.87059, 0.74510, 0.74510),
                (0.87059, 0.74510, 0.74510),
                (0.87059, 0.74510, 0.74510),
                (0.87451, 0.74510, 0.74510),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (0.86275, 0.86275, 0.86275),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
                (1.00000, 1.00000, 1.00000),
        )

cmap_rainbow1 = (
                (0.00000, 0.00000, 0.16471),
                (0.02745, 0.00000, 0.18431),
                (0.05882, 0.00000, 0.20000),
                (0.08627, 0.00000, 0.21961),
                (0.11373, 0.00000, 0.23922),
                (0.14510, 0.00000, 0.25882),
                (0.17647, 0.00000, 0.27843),
                (0.20392, 0.00000, 0.29804),
                (0.23137, 0.00000, 0.31765),
                (0.26275, 0.00000, 0.33725),
                (0.29412, 0.00000, 0.35686),
                (0.32157, 0.00000, 0.37647),
                (0.35294, 0.00000, 0.39608),
                (0.38039, 0.00000, 0.41569),
                (0.41176, 0.00000, 0.43529),
                (0.43922, 0.00000, 0.45490),
                (0.47059, 0.00000, 0.47451),
                (0.49804, 0.00000, 0.49412),
                (0.52941, 0.00000, 0.51373),
                (0.55686, 0.00000, 0.53725),
                (0.58824, 0.00000, 0.55686),
                (0.55686, 0.00000, 0.57647),
                (0.52941, 0.00000, 0.59608),
                (0.49804, 0.00000, 0.61569),
                (0.47059, 0.00000, 0.63922),
                (0.43922, 0.00000, 0.65882),
                (0.41176, 0.00000, 0.67843),
                (0.38039, 0.00000, 0.70196),
                (0.35294, 0.00000, 0.72157),
                (0.32157, 0.00000, 0.74118),
                (0.29412, 0.00000, 0.76471),
                (0.26275, 0.00000, 0.78431),
                (0.23137, 0.00000, 0.80392),
                (0.20392, 0.00000, 0.82745),
                (0.17647, 0.00000, 0.84706),
                (0.14510, 0.00000, 0.87059),
                (0.11373, 0.00000, 0.89020),
                (0.08627, 0.00000, 0.91373),
                (0.05882, 0.00000, 0.93333),
                (0.02745, 0.00000, 0.95686),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 0.97647),
                (0.00000, 0.00784, 0.95686),
                (0.00000, 0.01569, 0.93333),
                (0.00000, 0.02353, 0.91373),
                (0.00000, 0.03137, 0.89020),
                (0.00000, 0.03922, 0.87059),
                (0.00000, 0.05098, 0.85098),
                (0.00000, 0.06275, 0.83137),
                (0.00000, 0.07843, 0.81176),
                (0.00000, 0.09804, 0.79216),
                (0.00000, 0.11765, 0.77255),
                (0.00000, 0.13725, 0.75294),
                (0.00000, 0.15686, 0.73333),
                (0.00000, 0.17647, 0.71373),
                (0.00000, 0.19608, 0.69412),
                (0.00000, 0.21569, 0.67451),
                (0.00000, 0.23529, 0.65882),
                (0.00000, 0.25490, 0.64314),
                (0.00000, 0.27059, 0.62745),
                (0.00000, 0.28627, 0.61176),
                (0.00000, 0.30196, 0.59608),
                (0.00000, 0.32157, 0.58039),
                (0.00000, 0.33333, 0.56471),
                (0.00000, 0.34510, 0.54902),
                (0.00000, 0.35686, 0.53333),
                (0.00000, 0.36863, 0.51765),
                (0.00000, 0.38039, 0.50196),
                (0.00000, 0.39216, 0.48627),
                (0.00000, 0.40392, 0.47059),
                (0.00000, 0.41176, 0.45882),
                (0.00000, 0.42353, 0.44706),
                (0.00000, 0.43529, 0.43529),
                (0.00000, 0.44706, 0.42353),
                (0.00000, 0.45882, 0.41176),
                (0.00000, 0.46667, 0.40000),
                (0.00000, 0.47843, 0.38824),
                (0.00000, 0.49020, 0.37647),
                (0.00000, 0.49804, 0.36471),
                (0.00000, 0.50980, 0.35294),
                (0.00000, 0.52157, 0.34118),
                (0.00000, 0.52941, 0.32941),
                (0.00000, 0.54118, 0.31765),
                (0.00000, 0.55294, 0.30588),
                (0.00000, 0.56078, 0.29412),
                (0.00000, 0.57255, 0.28235),
                (0.00000, 0.58431, 0.27059),
                (0.00000, 0.59216, 0.25882),
                (0.00000, 0.60392, 0.24706),
                (0.00000, 0.61176, 0.23529),
                (0.00000, 0.62353, 0.22353),
                (0.00000, 0.63137, 0.21176),
                (0.00000, 0.64314, 0.20000),
                (0.00000, 0.65098, 0.18824),
                (0.00000, 0.66275, 0.17647),
                (0.00000, 0.67059, 0.16471),
                (0.00000, 0.68235, 0.15294),
                (0.00000, 0.69020, 0.14118),
                (0.00000, 0.70196, 0.12941),
                (0.00000, 0.70980, 0.11765),
                (0.00000, 0.72157, 0.10196),
                (0.00000, 0.72941, 0.08627),
                (0.00000, 0.74118, 0.07059),
                (0.00000, 0.74902, 0.05490),
                (0.00000, 0.76078, 0.03922),
                (0.00000, 0.76863, 0.02353),
                (0.00000, 0.77647, 0.00000),
                (0.00000, 0.78824, 0.00000),
                (0.00000, 0.79608, 0.00000),
                (0.00000, 0.80784, 0.00000),
                (0.00000, 0.81569, 0.00000),
                (0.00000, 0.82353, 0.00000),
                (0.00000, 0.83529, 0.00000),
                (0.00000, 0.84314, 0.00000),
                (0.00000, 0.85490, 0.00000),
                (0.00000, 0.86275, 0.00000),
                (0.00000, 0.87059, 0.00000),
                (0.00000, 0.88235, 0.00000),
                (0.00000, 0.89020, 0.00000),
                (0.00000, 0.89804, 0.00000),
                (0.00000, 0.90980, 0.00000),
                (0.00000, 0.91765, 0.00000),
                (0.00000, 0.92549, 0.00000),
                (0.00000, 0.93725, 0.00000),
                (0.00000, 0.94510, 0.00000),
                (0.00000, 0.95294, 0.00000),
                (0.00000, 0.96078, 0.00000),
                (0.00000, 0.97255, 0.00000),
                (0.00000, 0.98039, 0.00000),
                (0.00000, 0.98824, 0.00000),
                (0.00784, 1.00000, 0.00000),
                (0.01569, 0.98824, 0.00000),
                (0.02353, 0.98039, 0.00000),
                (0.03137, 0.97255, 0.00000),
                (0.04314, 0.96078, 0.00000),
                (0.05490, 0.95294, 0.00000),
                (0.06667, 0.94510, 0.00000),
                (0.07843, 0.93725, 0.00000),
                (0.09020, 0.92549, 0.00000),
                (0.10196, 0.91765, 0.00000),
                (0.11373, 0.90980, 0.00000),
                (0.12549, 0.89804, 0.00000),
                (0.13725, 0.89020, 0.00000),
                (0.14902, 0.88235, 0.00000),
                (0.16471, 0.87059, 0.00000),
                (0.20000, 0.86275, 0.00000),
                (0.23529, 0.85490, 0.00000),
                (0.26667, 0.84314, 0.00000),
                (0.30588, 0.83529, 0.00000),
                (0.34118, 0.82353, 0.00000),
                (0.37647, 0.81569, 0.00000),
                (0.41176, 0.80784, 0.00000),
                (0.44706, 0.79608, 0.00000),
                (0.48627, 0.78824, 0.00000),
                (0.52157, 0.77647, 0.00000),
                (0.56078, 0.76863, 0.00000),
                (0.59608, 0.77647, 0.00000),
                (0.63529, 0.78824, 0.00000),
                (0.67059, 0.80000, 0.00000),
                (0.70980, 0.81176, 0.00000),
                (0.74902, 0.82745, 0.00000),
                (0.78431, 0.84314, 0.00000),
                (0.82353, 0.85882, 0.00000),
                (0.85882, 0.87059, 0.00000),
                (0.89804, 0.89020, 0.00000),
                (0.93333, 0.90196, 0.00000),
                (0.97647, 0.92157, 0.00000),
                (1.00000, 0.93333, 0.00000),
                (1.00000, 0.95294, 0.00000),
                (1.00000, 0.96863, 0.00000),
                (1.00000, 0.98824, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.99608, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 0.97647, 0.00000),
                (1.00000, 0.93725, 0.00000),
                (1.00000, 0.89804, 0.00000),
                (1.00000, 0.85882, 0.00000),
                (1.00000, 0.81961, 0.00000),
                (1.00000, 0.78039, 0.00000),
                (1.00000, 0.74118, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.66275, 0.00000),
                (1.00000, 0.62353, 0.00000),
                (1.00000, 0.58431, 0.00000),
                (1.00000, 0.54510, 0.00000),
                (1.00000, 0.50980, 0.00000),
                (1.00000, 0.46667, 0.00000),
                (1.00000, 0.43137, 0.00000),
                (1.00000, 0.39216, 0.00000),
                (1.00000, 0.35294, 0.00000),
                (1.00000, 0.31765, 0.00000),
                (1.00000, 0.27451, 0.00000),
                (1.00000, 0.23922, 0.00000),
                (1.00000, 0.20000, 0.00000),
                (1.00000, 0.16863, 0.00000),
                (1.00000, 0.12941, 0.00000),
                (1.00000, 0.09804, 0.00000),
                (1.00000, 0.08235, 0.00000),
                (1.00000, 0.06275, 0.00000),
                (1.00000, 0.04706, 0.00000),
                (1.00000, 0.02353, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (0.99216, 0.00000, 0.00000),
                (0.98431, 0.00000, 0.00000),
                (0.97647, 0.00000, 0.00000),
                (0.96863, 0.00000, 0.00000),
                (0.96078, 0.00000, 0.00000),
                (0.95294, 0.00000, 0.00000),
                (0.94510, 0.00000, 0.00000),
                (0.93725, 0.00000, 0.00000),
                (0.92941, 0.00000, 0.00000),
                (0.92157, 0.00000, 0.00000),
                (0.91373, 0.00000, 0.00000),
                (0.90588, 0.00000, 0.00000),
                (0.89804, 0.00000, 0.00000),
                (0.89020, 0.00000, 0.00000),
                (0.88235, 0.00000, 0.00000),
                (0.87451, 0.00000, 0.00000),
                (0.86667, 0.00000, 0.00000),
                (0.85882, 0.00000, 0.00000),
                (0.85098, 0.00000, 0.00000),
                (0.84314, 0.00000, 0.00000),
                (0.83529, 0.00000, 0.00000),
                (0.82745, 0.00000, 0.00000),
                (0.81961, 0.00000, 0.00000),
                (0.81176, 0.00000, 0.00000),
                (0.80392, 0.00000, 0.00000),
                (0.79608, 0.00000, 0.00000),
                (0.78824, 0.00000, 0.00000),
                (0.78039, 0.00000, 0.00000),
                (0.77255, 0.00000, 0.00000),
                (0.76471, 0.00000, 0.00000),
                (0.75686, 0.00000, 0.00000),
                (0.74902, 0.00000, 0.00000),
                (0.74118, 0.00000, 0.00000),
                (0.73333, 0.00000, 0.00000),
)

cmap_idl14 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.00000, 0.16471, 0.00000),
                (0.00000, 0.33333, 0.00000),
                (0.00000, 0.49804, 0.00000),
                (0.00000, 0.66667, 0.00000),
                (0.00000, 0.83137, 0.00000),
                (0.00000, 1.00000, 0.00000),
                (0.00000, 0.96471, 0.00000),
                (0.00000, 0.92549, 0.00000),
                (0.00000, 0.88627, 0.00000),
                (0.00000, 0.84706, 0.00000),
                (0.00000, 0.80784, 0.00000),
                (0.00000, 0.77255, 0.00000),
                (0.00000, 0.73333, 0.00000),
                (0.00000, 0.69412, 0.00000),
                (0.00000, 0.65490, 0.00000),
                (0.00000, 0.61569, 0.00000),
                (0.00000, 0.58039, 0.00000),
                (0.00000, 0.54118, 0.00000),
                (0.00000, 0.50196, 0.00000),
                (0.00000, 0.46275, 0.00000),
                (0.00000, 0.42353, 0.00000),
                (0.00000, 0.38824, 0.00000),
                (0.00000, 0.34902, 0.00000),
                (0.00000, 0.30980, 0.00000),
                (0.00000, 0.27059, 0.00000),
                (0.00000, 0.23137, 0.00000),
                (0.00000, 0.19608, 0.00000),
                (0.00000, 0.15686, 0.00000),
                (0.00000, 0.11765, 0.00000),
                (0.00000, 0.07843, 0.00000),
                (0.00000, 0.03922, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.03137),
                (0.00000, 0.00000, 0.06275),
                (0.00000, 0.00000, 0.09412),
                (0.00000, 0.00000, 0.12549),
                (0.00000, 0.00000, 0.16078),
                (0.00000, 0.00000, 0.19216),
                (0.00000, 0.00000, 0.22353),
                (0.00000, 0.00000, 0.25490),
                (0.00000, 0.00000, 0.29020),
                (0.00000, 0.00000, 0.32157),
                (0.00000, 0.00000, 0.35294),
                (0.00000, 0.00000, 0.38431),
                (0.00000, 0.00000, 0.41569),
                (0.00000, 0.00000, 0.45098),
                (0.00000, 0.00000, 0.48235),
                (0.00000, 0.00000, 0.51373),
                (0.00000, 0.00000, 0.54510),
                (0.00000, 0.00000, 0.58039),
                (0.00000, 0.00000, 0.61176),
                (0.00000, 0.00000, 0.64314),
                (0.00000, 0.00000, 0.67451),
                (0.00000, 0.00000, 0.70588),
                (0.00000, 0.00000, 0.74118),
                (0.00000, 0.00000, 0.77255),
                (0.00000, 0.00000, 0.80392),
                (0.00000, 0.00000, 0.83529),
                (0.00000, 0.00000, 0.87059),
                (0.00000, 0.00000, 0.90196),
                (0.00000, 0.00000, 0.93333),
                (0.00000, 0.00000, 0.96471),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.00000, 0.00000),
                (0.02745, 0.00000, 0.01961),
                (0.05882, 0.00000, 0.03922),
                (0.09020, 0.00000, 0.05882),
                (0.12157, 0.00000, 0.08235),
                (0.15294, 0.00000, 0.10196),
                (0.18431, 0.00000, 0.12157),
                (0.21569, 0.00000, 0.14510),
                (0.24706, 0.00000, 0.16471),
                (0.27451, 0.00000, 0.18431),
                (0.30588, 0.00000, 0.20784),
                (0.33725, 0.00000, 0.22745),
                (0.36863, 0.00000, 0.24706),
                (0.40000, 0.00000, 0.27059),
                (0.43137, 0.00000, 0.29020),
                (0.46275, 0.00000, 0.30980),
                (0.49412, 0.00000, 0.33333),
                (0.52549, 0.00000, 0.34902),
                (0.55686, 0.00000, 0.36863),
                (0.59216, 0.00000, 0.38431),
                (0.62353, 0.00000, 0.40392),
                (0.65882, 0.00000, 0.42353),
                (0.69020, 0.00000, 0.43922),
                (0.72157, 0.00000, 0.45882),
                (0.75686, 0.00000, 0.47451),
                (0.78824, 0.00000, 0.49412),
                (0.82353, 0.00000, 0.51373),
                (0.85490, 0.00000, 0.52941),
                (0.88627, 0.00000, 0.54902),
                (0.92157, 0.00000, 0.56471),
                (0.95294, 0.00000, 0.58431),
                (0.98824, 0.00000, 0.60392),
                (0.00000, 0.00000, 0.00000),
                (0.00392, 0.00000, 0.00000),
                (0.00784, 0.00000, 0.00000),
                (0.01176, 0.00000, 0.00000),
                (0.01569, 0.00000, 0.00000),
                (0.01961, 0.00000, 0.00000),
                (0.02353, 0.00000, 0.00000),
                (0.02745, 0.00000, 0.00000),
                (0.03137, 0.00000, 0.00000),
                (0.03529, 0.00000, 0.00000),
                (0.03922, 0.00000, 0.00000),
                (0.04314, 0.00000, 0.00000),
                (0.04706, 0.00000, 0.00000),
                (0.05490, 0.00000, 0.00000),
                (0.06275, 0.00000, 0.00000),
                (0.07059, 0.00000, 0.00000),
                (0.07843, 0.00000, 0.00000),
                (0.09020, 0.00000, 0.00000),
                (0.09804, 0.00000, 0.00000),
                (0.10588, 0.00000, 0.00000),
                (0.11373, 0.00000, 0.00000),
                (0.12549, 0.00000, 0.00000),
                (0.13333, 0.00000, 0.00000),
                (0.14118, 0.00000, 0.00000),
                (0.14902, 0.00000, 0.00000),
                (0.16078, 0.00000, 0.00000),
                (0.17255, 0.00000, 0.00000),
                (0.18431, 0.00000, 0.00000),
                (0.19608, 0.00000, 0.00000),
                (0.20784, 0.00000, 0.00000),
                (0.21961, 0.00000, 0.00000),
                (0.23137, 0.00000, 0.00000),
                (0.24706, 0.00000, 0.00000),
                (0.25882, 0.00000, 0.00000),
                (0.27059, 0.00000, 0.00000),
                (0.28235, 0.00000, 0.00000),
                (0.29412, 0.00000, 0.00000),
                (0.30588, 0.00000, 0.00000),
                (0.32157, 0.00000, 0.00392),
                (0.33333, 0.00000, 0.00392),
                (0.34902, 0.00000, 0.00392),
                (0.36471, 0.00000, 0.00392),
                (0.38039, 0.00000, 0.00392),
                (0.39608, 0.00000, 0.00392),
                (0.41176, 0.00000, 0.00392),
                (0.42353, 0.00000, 0.00392),
                (0.43922, 0.00000, 0.00392),
                (0.45490, 0.00000, 0.00392),
                (0.47059, 0.00000, 0.00392),
                (0.48627, 0.00000, 0.00392),
                (0.50196, 0.00392, 0.00392),
                (0.51373, 0.00392, 0.00392),
                (0.52941, 0.00392, 0.00392),
                (0.54510, 0.00392, 0.00392),
                (0.56078, 0.00392, 0.00392),
                (0.57647, 0.00392, 0.00392),
                (0.59216, 0.00392, 0.00392),
                (0.60784, 0.00392, 0.00392),
                (0.62353, 0.00392, 0.00392),
                (0.63922, 0.00392, 0.00392),
                (0.65490, 0.00392, 0.00392),
                (0.67059, 0.00392, 0.00392),
                (0.68627, 0.00392, 0.00392),
                (0.69804, 0.00392, 0.00392),
                (0.70980, 0.00392, 0.00392),
                (0.72549, 0.00392, 0.00392),
                (0.73725, 0.00392, 0.00392),
                (0.75294, 0.00392, 0.00392),
                (0.76471, 0.00392, 0.00392),
                (0.77647, 0.00392, 0.00392),
                (0.79216, 0.00392, 0.00392),
                (0.80392, 0.00392, 0.00392),
                (0.81961, 0.00392, 0.00392),
                (0.83137, 0.00392, 0.00392),
                (0.84706, 0.00392, 0.00784),
                (0.85490, 0.00392, 0.00784),
                (0.86275, 0.00392, 0.00784),
                (0.87451, 0.00392, 0.00784),
                (0.88235, 0.00392, 0.00784),
                (0.89020, 0.00392, 0.00784),
                (0.90196, 0.00392, 0.00784),
                (0.90980, 0.00392, 0.00784),
                (0.91765, 0.00392, 0.00784),
                (0.92941, 0.00392, 0.00784),
                (0.93725, 0.00392, 0.00784),
                (0.94510, 0.00392, 0.00784),
                (0.95686, 0.00784, 0.00784),
                (0.95686, 0.00784, 0.00784),
                (0.96078, 0.00784, 0.00784),
                (0.96471, 0.00784, 0.00784),
                (0.96863, 0.00784, 0.00784),
                (0.96863, 0.00784, 0.00784),
                (0.97255, 0.00784, 0.00784),
                (0.97647, 0.00784, 0.00784),
                (0.98039, 0.00784, 0.00784),
                (0.98039, 0.00784, 0.00784),
                (0.98431, 0.00784, 0.00784),
                (0.98824, 0.00784, 0.00784),
                (0.99216, 0.00784, 0.00784),
                (0.99608, 0.00392, 0.00784),
                (0.99608, 0.00392, 0.00784),
                (0.99608, 0.01176, 0.00784),
                (0.99608, 0.01961, 0.00784),
                (0.99608, 0.03137, 0.00784),
                (0.99608, 0.03922, 0.00784),
                (0.99608, 0.04706, 0.00784),
                (0.99608, 0.05882, 0.00784),
                (0.99608, 0.06667, 0.00784),
                (0.99608, 0.07451, 0.00784),
                (0.99608, 0.08627, 0.00784),
                (0.99608, 0.09412, 0.00784),
                (0.99608, 0.10196, 0.00784),
                (0.99608, 0.11373, 0.00784),
                (0.99608, 0.12157, 0.00784),
                (0.99608, 0.12941, 0.00784),
                (0.99608, 0.14118, 0.00784),
                (0.99608, 0.14118, 0.00784),
                (0.99608, 0.14902, 0.01176),
                (0.99608, 0.15686, 0.01569),
                (0.99608, 0.16471, 0.01961),
                (1.00000, 0.17647, 0.02745),
                (1.00000, 0.18824, 0.03529),
                (1.00000, 0.20000, 0.04706),
                (1.00000, 0.21176, 0.05490),
                (1.00000, 0.22745, 0.06667),
                (1.00000, 0.23922, 0.07843),
                (1.00000, 0.25098, 0.09020),
                (1.00000, 0.26275, 0.10588),
                (1.00000, 0.27451, 0.11765),
                (1.00000, 0.28627, 0.13333),
                (1.00000, 0.30196, 0.15294),
                (1.00000, 0.32157, 0.17255),
                (1.00000, 0.34118, 0.19216),
                (1.00000, 0.36078, 0.21569),
                (1.00000, 0.37647, 0.23529),
                (1.00000, 0.39216, 0.25490),
                (1.00000, 0.40784, 0.27843),
                (1.00000, 0.42353, 0.29804),
                (1.00000, 0.44314, 0.32157),
                (1.00000, 0.46667, 0.34902),
                (1.00000, 0.49020, 0.38039),
                (1.00000, 0.51373, 0.40784),
                (1.00000, 0.54118, 0.43922),
                (1.00000, 0.56471, 0.47059),
                (1.00000, 0.59216, 0.50196),
                (1.00000, 0.61569, 0.53333),
                (1.00000, 0.64314, 0.56863),
                (1.00000, 0.67059, 0.60000),
                (1.00000, 0.69804, 0.63529),
                (1.00000, 0.72549, 0.67059),
                (1.00000, 0.75686, 0.70588),
                (1.00000, 0.78431, 0.74118),
                (1.00000, 0.81569, 0.77647),
                (1.00000, 0.84314, 0.81176),
                (1.00000, 0.87451, 0.85098),
                (1.00000, 0.89804, 0.87843),
                (1.00000, 0.92157, 0.90980),
                (1.00000, 0.94902, 0.93725),
                (1.00000, 0.97255, 0.96863),
                (1.00000, 1.00000, 1.00000),
        )

cmap_rainbow2 = (
                (0.00000, 0.00000, 0.00000),
                (0.03137, 0.00000, 0.03137),
                (0.06275, 0.00000, 0.06275),
                (0.09412, 0.00000, 0.09412),
                (0.12549, 0.00000, 0.12549),
                (0.15686, 0.00000, 0.15686),
                (0.18824, 0.00000, 0.18824),
                (0.21961, 0.00000, 0.21961),
                (0.25098, 0.00000, 0.25098),
                (0.28235, 0.00000, 0.28235),
                (0.31373, 0.00000, 0.31373),
                (0.34510, 0.00000, 0.34510),
                (0.37647, 0.00000, 0.37647),
                (0.40784, 0.00000, 0.40784),
                (0.43922, 0.00000, 0.43922),
                (0.47059, 0.00000, 0.47059),
                (0.50196, 0.00000, 0.50196),
                (0.53333, 0.00000, 0.53333),
                (0.56471, 0.00000, 0.56471),
                (0.59608, 0.00000, 0.59608),
                (0.62745, 0.00000, 0.62745),
                (0.65882, 0.00000, 0.65882),
                (0.69020, 0.00000, 0.69020),
                (0.72157, 0.00000, 0.72157),
                (0.75294, 0.00000, 0.75294),
                (0.78431, 0.00000, 0.78431),
                (0.81569, 0.00000, 0.81569),
                (0.84706, 0.00000, 0.84706),
                (0.87843, 0.00000, 0.87843),
                (0.90980, 0.00000, 0.90980),
                (0.94118, 0.00000, 0.94118),
                (0.97255, 0.00000, 0.97255),
                (1.00000, 0.00000, 1.00000),
                (0.96863, 0.00000, 1.00000),
                (0.93725, 0.00000, 1.00000),
                (0.90588, 0.00000, 1.00000),
                (0.87451, 0.00000, 1.00000),
                (0.84314, 0.00000, 1.00000),
                (0.81176, 0.00000, 1.00000),
                (0.78039, 0.00000, 1.00000),
                (0.74902, 0.00000, 1.00000),
                (0.71765, 0.00000, 1.00000),
                (0.68627, 0.00000, 1.00000),
                (0.65490, 0.00000, 1.00000),
                (0.62353, 0.00000, 1.00000),
                (0.59216, 0.00000, 1.00000),
                (0.56078, 0.00000, 1.00000),
                (0.52941, 0.00000, 1.00000),
                (0.49804, 0.00000, 1.00000),
                (0.46667, 0.00000, 1.00000),
                (0.43529, 0.00000, 1.00000),
                (0.40392, 0.00000, 1.00000),
                (0.37255, 0.00000, 1.00000),
                (0.34118, 0.00000, 1.00000),
                (0.30980, 0.00000, 1.00000),
                (0.27843, 0.00000, 1.00000),
                (0.24706, 0.00000, 1.00000),
                (0.21569, 0.00000, 1.00000),
                (0.18431, 0.00000, 1.00000),
                (0.15294, 0.00000, 1.00000),
                (0.12157, 0.00000, 1.00000),
                (0.09020, 0.00000, 1.00000),
                (0.05882, 0.00000, 1.00000),
                (0.02745, 0.00000, 1.00000),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.03137, 1.00000),
                (0.00000, 0.06275, 1.00000),
                (0.00000, 0.09412, 1.00000),
                (0.00000, 0.12549, 1.00000),
                (0.00000, 0.15686, 1.00000),
                (0.00000, 0.18824, 1.00000),
                (0.00000, 0.21961, 1.00000),
                (0.00000, 0.25098, 1.00000),
                (0.00000, 0.28235, 1.00000),
                (0.00000, 0.31373, 1.00000),
                (0.00000, 0.34510, 1.00000),
                (0.00000, 0.37647, 1.00000),
                (0.00000, 0.40784, 1.00000),
                (0.00000, 0.43922, 1.00000),
                (0.00000, 0.47059, 1.00000),
                (0.00000, 0.50196, 1.00000),
                (0.00000, 0.53333, 1.00000),
                (0.00000, 0.56471, 1.00000),
                (0.00000, 0.59608, 1.00000),
                (0.00000, 0.62745, 1.00000),
                (0.00000, 0.65882, 1.00000),
                (0.00000, 0.69020, 1.00000),
                (0.00000, 0.72157, 1.00000),
                (0.00000, 0.75294, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.81569, 1.00000),
                (0.00000, 0.84706, 1.00000),
                (0.00000, 0.87843, 1.00000),
                (0.00000, 0.90980, 1.00000),
                (0.00000, 0.94118, 1.00000),
                (0.00000, 0.97255, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 0.96863),
                (0.00000, 1.00000, 0.93725),
                (0.00000, 1.00000, 0.90588),
                (0.00000, 1.00000, 0.87451),
                (0.00000, 1.00000, 0.84314),
                (0.00000, 1.00000, 0.81176),
                (0.00000, 1.00000, 0.78039),
                (0.00000, 1.00000, 0.74902),
                (0.00000, 1.00000, 0.71765),
                (0.00000, 1.00000, 0.68627),
                (0.00000, 1.00000, 0.65490),
                (0.00000, 1.00000, 0.62353),
                (0.00000, 1.00000, 0.59216),
                (0.00000, 1.00000, 0.56078),
                (0.00000, 1.00000, 0.52941),
                (0.00000, 1.00000, 0.49804),
                (0.00000, 1.00000, 0.46667),
                (0.00000, 1.00000, 0.43529),
                (0.00000, 1.00000, 0.40392),
                (0.00000, 1.00000, 0.37255),
                (0.00000, 1.00000, 0.34118),
                (0.00000, 1.00000, 0.30980),
                (0.00000, 1.00000, 0.27843),
                (0.00000, 1.00000, 0.24706),
                (0.00000, 1.00000, 0.21569),
                (0.00000, 1.00000, 0.18431),
                (0.00000, 1.00000, 0.15294),
                (0.00000, 1.00000, 0.12157),
                (0.00000, 1.00000, 0.09020),
                (0.00000, 1.00000, 0.05882),
                (0.00000, 1.00000, 0.02745),
                (0.00000, 1.00000, 0.00000),
                (0.03137, 1.00000, 0.00000),
                (0.06275, 1.00000, 0.00000),
                (0.09412, 1.00000, 0.00000),
                (0.12549, 1.00000, 0.00000),
                (0.15686, 1.00000, 0.00000),
                (0.18824, 1.00000, 0.00000),
                (0.21961, 1.00000, 0.00000),
                (0.25098, 1.00000, 0.00000),
                (0.28235, 1.00000, 0.00000),
                (0.31373, 1.00000, 0.00000),
                (0.34510, 1.00000, 0.00000),
                (0.37647, 1.00000, 0.00000),
                (0.40784, 1.00000, 0.00000),
                (0.43922, 1.00000, 0.00000),
                (0.47059, 1.00000, 0.00000),
                (0.50196, 1.00000, 0.00000),
                (0.53333, 1.00000, 0.00000),
                (0.56471, 1.00000, 0.00000),
                (0.59608, 1.00000, 0.00000),
                (0.62745, 1.00000, 0.00000),
                (0.65882, 1.00000, 0.00000),
                (0.69020, 1.00000, 0.00000),
                (0.72157, 1.00000, 0.00000),
                (0.75294, 1.00000, 0.00000),
                (0.78431, 1.00000, 0.00000),
                (0.81569, 1.00000, 0.00000),
                (0.84706, 1.00000, 0.00000),
                (0.87843, 1.00000, 0.00000),
                (0.90980, 1.00000, 0.00000),
                (0.94118, 1.00000, 0.00000),
                (0.97255, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (1.00000, 0.98431, 0.00000),
                (1.00000, 0.96863, 0.00000),
                (1.00000, 0.95294, 0.00000),
                (1.00000, 0.93725, 0.00000),
                (1.00000, 0.92157, 0.00000),
                (1.00000, 0.90588, 0.00000),
                (1.00000, 0.89020, 0.00000),
                (1.00000, 0.87451, 0.00000),
                (1.00000, 0.85882, 0.00000),
                (1.00000, 0.84314, 0.00000),
                (1.00000, 0.82745, 0.00000),
                (1.00000, 0.81176, 0.00000),
                (1.00000, 0.79608, 0.00000),
                (1.00000, 0.78039, 0.00000),
                (1.00000, 0.76471, 0.00000),
                (1.00000, 0.74902, 0.00000),
                (1.00000, 0.73333, 0.00000),
                (1.00000, 0.71765, 0.00000),
                (1.00000, 0.70196, 0.00000),
                (1.00000, 0.68627, 0.00000),
                (1.00000, 0.67059, 0.00000),
                (1.00000, 0.65490, 0.00000),
                (1.00000, 0.63922, 0.00000),
                (1.00000, 0.62353, 0.00000),
                (1.00000, 0.60784, 0.00000),
                (1.00000, 0.59216, 0.00000),
                (1.00000, 0.57647, 0.00000),
                (1.00000, 0.56078, 0.00000),
                (1.00000, 0.54510, 0.00000),
                (1.00000, 0.52941, 0.00000),
                (1.00000, 0.51373, 0.00000),
                (1.00000, 0.49804, 0.00000),
                (1.00000, 0.48235, 0.00000),
                (1.00000, 0.46667, 0.00000),
                (1.00000, 0.45098, 0.00000),
                (1.00000, 0.43529, 0.00000),
                (1.00000, 0.41961, 0.00000),
                (1.00000, 0.40392, 0.00000),
                (1.00000, 0.38824, 0.00000),
                (1.00000, 0.37255, 0.00000),
                (1.00000, 0.35686, 0.00000),
                (1.00000, 0.34118, 0.00000),
                (1.00000, 0.32549, 0.00000),
                (1.00000, 0.30980, 0.00000),
                (1.00000, 0.29412, 0.00000),
                (1.00000, 0.27843, 0.00000),
                (1.00000, 0.26275, 0.00000),
                (1.00000, 0.24706, 0.00000),
                (1.00000, 0.23137, 0.00000),
                (1.00000, 0.21569, 0.00000),
                (1.00000, 0.20000, 0.00000),
                (1.00000, 0.18431, 0.00000),
                (1.00000, 0.16863, 0.00000),
                (1.00000, 0.15294, 0.00000),
                (1.00000, 0.13725, 0.00000),
                (1.00000, 0.12157, 0.00000),
                (1.00000, 0.10588, 0.00000),
                (1.00000, 0.09020, 0.00000),
                (1.00000, 0.07451, 0.00000),
                (1.00000, 0.05882, 0.00000),
                (1.00000, 0.04314, 0.00000),
                (1.00000, 0.02745, 0.00000),
                (1.00000, 0.01176, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.03137, 0.03137),
                (1.00000, 0.06275, 0.06275),
                (1.00000, 0.09412, 0.09412),
                (1.00000, 0.12549, 0.12549),
                (1.00000, 0.15686, 0.15686),
                (1.00000, 0.18824, 0.18824),
                (1.00000, 0.21961, 0.21961),
                (1.00000, 0.25098, 0.25098),
                (1.00000, 0.28235, 0.28235),
                (1.00000, 0.31373, 0.31373),
                (1.00000, 0.34510, 0.34510),
                (1.00000, 0.37647, 0.37647),
                (1.00000, 0.40784, 0.40784),
                (1.00000, 0.43922, 0.43922),
                (1.00000, 0.47059, 0.47059),
                (1.00000, 0.50196, 0.50196),
                (1.00000, 0.53333, 0.53333),
                (1.00000, 0.56471, 0.56471),
                (1.00000, 0.59608, 0.59608),
                (1.00000, 0.62745, 0.62745),
                (1.00000, 0.65882, 0.65882),
                (1.00000, 0.69020, 0.69020),
                (1.00000, 0.72157, 0.72157),
                (1.00000, 0.75294, 0.75294),
                (1.00000, 0.78431, 0.78431),
                (1.00000, 0.81569, 0.81569),
                (1.00000, 0.84706, 0.84706),
                (1.00000, 0.87843, 0.87843),
                (1.00000, 0.90980, 0.90980),
                (1.00000, 0.94118, 0.94118),
                (1.00000, 0.97255, 0.97255),
)

cmap_real = (
                (0.00784, 0.00392, 0.00000),  # noqa
                (0.01569, 0.00784, 0.00000),
                (0.02353, 0.01176, 0.00000),
                (0.03137, 0.01569, 0.00000),
                (0.03922, 0.01961, 0.00000),
                (0.04706, 0.02353, 0.00000),
                (0.05490, 0.02745, 0.00000),
                (0.06275, 0.03137, 0.00000),
                (0.07059, 0.03529, 0.00000),
                (0.07843, 0.03922, 0.00000),
                (0.08627, 0.04314, 0.00000),
                (0.09412, 0.04706, 0.00000),
                (0.10196, 0.05098, 0.00000),
                (0.10980, 0.05490, 0.00000),
                (0.11765, 0.05882, 0.00000),
                (0.12549, 0.06275, 0.00000),
                (0.13333, 0.06667, 0.00000),
                (0.14118, 0.07059, 0.00000),
                (0.14902, 0.07451, 0.00000),
                (0.15686, 0.07843, 0.00000),
                (0.16471, 0.08235, 0.00000),
                (0.17255, 0.08627, 0.00000),
                (0.18039, 0.09020, 0.00000),
                (0.18824, 0.09412, 0.00000),
                (0.19608, 0.09804, 0.00000),
                (0.20392, 0.10196, 0.00000),
                (0.21176, 0.10588, 0.00000),
                (0.21961, 0.10980, 0.00000),
                (0.22745, 0.11373, 0.00000),
                (0.23529, 0.11765, 0.00000),
                (0.24314, 0.12157, 0.00000),
                (0.25098, 0.12549, 0.00000),
                (0.25882, 0.12941, 0.00000),
                (0.26667, 0.13333, 0.00000),
                (0.27451, 0.13725, 0.00000),
                (0.28235, 0.14118, 0.00000),
                (0.29020, 0.14510, 0.00000),
                (0.29804, 0.14902, 0.00000),
                (0.30588, 0.15294, 0.00000),
                (0.31373, 0.15686, 0.00000),
                (0.32157, 0.16078, 0.00000),
                (0.32941, 0.16471, 0.00000),
                (0.33725, 0.16863, 0.00000),
                (0.34510, 0.17255, 0.00000),
                (0.35294, 0.17647, 0.00000),
                (0.36078, 0.18039, 0.00000),
                (0.36863, 0.18431, 0.00000),
                (0.37647, 0.18824, 0.00000),
                (0.38431, 0.19216, 0.00000),
                (0.39216, 0.19608, 0.00000),
                (0.40000, 0.20000, 0.00000),
                (0.40784, 0.20392, 0.00000),
                (0.41569, 0.20784, 0.00000),
                (0.42353, 0.21176, 0.00000),
                (0.43137, 0.21569, 0.00000),
                (0.43922, 0.21961, 0.00000),
                (0.44706, 0.22353, 0.00000),
                (0.45490, 0.22745, 0.00000),
                (0.46275, 0.23137, 0.00000),
                (0.47059, 0.23529, 0.00000),
                (0.47843, 0.23922, 0.00000),
                (0.48627, 0.24314, 0.00000),
                (0.49412, 0.24706, 0.00000),
                (0.50196, 0.25098, 0.00000),
                (0.50980, 0.25490, 0.00000),
                (0.51765, 0.25882, 0.00000),
                (0.52549, 0.26275, 0.00000),
                (0.53333, 0.26667, 0.00000),
                (0.54118, 0.27059, 0.00000),
                (0.54902, 0.27451, 0.00000),
                (0.55686, 0.27843, 0.00000),
                (0.56471, 0.28235, 0.00000),
                (0.57255, 0.28627, 0.00000),
                (0.58039, 0.29020, 0.00000),
                (0.58824, 0.29412, 0.00000),
                (0.59608, 0.29804, 0.00000),
                (0.60392, 0.30196, 0.00000),
                (0.61176, 0.30588, 0.00000),
                (0.61961, 0.30980, 0.00000),
                (0.62745, 0.31373, 0.00000),
                (0.63529, 0.31765, 0.00000),
                (0.64314, 0.32157, 0.00000),
                (0.65098, 0.32549, 0.00000),
                (0.65882, 0.32941, 0.00000),
                (0.66667, 0.33333, 0.00000),
                (0.67451, 0.33725, 0.00000),
                (0.68235, 0.34118, 0.00000),
                (0.69020, 0.34510, 0.00000),
                (0.69804, 0.34902, 0.00000),
                (0.70588, 0.35294, 0.00000),
                (0.71373, 0.35686, 0.00000),
                (0.72157, 0.36078, 0.00000),
                (0.72941, 0.36471, 0.00000),
                (0.73725, 0.36863, 0.00000),
                (0.74510, 0.37255, 0.00000),
                (0.75294, 0.37647, 0.00000),
                (0.76078, 0.38039, 0.00000),
                (0.76863, 0.38431, 0.00000),
                (0.77647, 0.38824, 0.00000),
                (0.78431, 0.39216, 0.00000),
                (0.79216, 0.39608, 0.00000),
                (0.80000, 0.40000, 0.00000),
                (0.80784, 0.40392, 0.00000),
                (0.81569, 0.40784, 0.00000),
                (0.82353, 0.41176, 0.00000),
                (0.83137, 0.41569, 0.00000),
                (0.83922, 0.41961, 0.00000),
                (0.84706, 0.42353, 0.00000),
                (0.85490, 0.42745, 0.00000),
                (0.86275, 0.43137, 0.00000),
                (0.87059, 0.43529, 0.00000),
                (0.87843, 0.43922, 0.00000),
                (0.88627, 0.44314, 0.00000),
                (0.89412, 0.44706, 0.00000),
                (0.90196, 0.45098, 0.00000),
                (0.90980, 0.45490, 0.00000),
                (0.91765, 0.45882, 0.00000),
                (0.92549, 0.46275, 0.00000),
                (0.93333, 0.46667, 0.00000),
                (0.94118, 0.47059, 0.00000),
                (0.94902, 0.47451, 0.00000),
                (0.95686, 0.47843, 0.00000),
                (0.96471, 0.48235, 0.00000),
                (0.97255, 0.48627, 0.00000),
                (0.98039, 0.49020, 0.00000),
                (0.98824, 0.49412, 0.00000),
                (0.99608, 0.49804, 0.00000),
                (1.00000, 0.50196, 0.00000),
                (1.00000, 0.50588, 0.00784),
                (1.00000, 0.50980, 0.01569),
                (1.00000, 0.51373, 0.02353),
                (1.00000, 0.51765, 0.03137),
                (1.00000, 0.52157, 0.03922),
                (1.00000, 0.52549, 0.04706),
                (1.00000, 0.52941, 0.05490),
                (1.00000, 0.53333, 0.06275),
                (1.00000, 0.53725, 0.07059),
                (1.00000, 0.54118, 0.07843),
                (1.00000, 0.54510, 0.08627),
                (1.00000, 0.54902, 0.09412),
                (1.00000, 0.55294, 0.10196),
                (1.00000, 0.55686, 0.10980),
                (1.00000, 0.56078, 0.11765),
                (1.00000, 0.56471, 0.12549),
                (1.00000, 0.56863, 0.13333),
                (1.00000, 0.57255, 0.14118),
                (1.00000, 0.57647, 0.14902),
                (1.00000, 0.58039, 0.15686),
                (1.00000, 0.58431, 0.16471),
                (1.00000, 0.58824, 0.17255),
                (1.00000, 0.59216, 0.18039),
                (1.00000, 0.59608, 0.18824),
                (1.00000, 0.60000, 0.19608),
                (1.00000, 0.60392, 0.20392),
                (1.00000, 0.60784, 0.21176),
                (1.00000, 0.61176, 0.21961),
                (1.00000, 0.61569, 0.22745),
                (1.00000, 0.61961, 0.23529),
                (1.00000, 0.62353, 0.24314),
                (1.00000, 0.62745, 0.25098),
                (1.00000, 0.63137, 0.25882),
                (1.00000, 0.63529, 0.26667),
                (1.00000, 0.63922, 0.27451),
                (1.00000, 0.64314, 0.28235),
                (1.00000, 0.64706, 0.29020),
                (1.00000, 0.65098, 0.29804),
                (1.00000, 0.65490, 0.30588),
                (1.00000, 0.65882, 0.31373),
                (1.00000, 0.66275, 0.32157),
                (1.00000, 0.66667, 0.32941),
                (1.00000, 0.67059, 0.33725),
                (1.00000, 0.67451, 0.34510),
                (1.00000, 0.67843, 0.35294),
                (1.00000, 0.68235, 0.36078),
                (1.00000, 0.68627, 0.36863),
                (1.00000, 0.69020, 0.37647),
                (1.00000, 0.69412, 0.38431),
                (1.00000, 0.69804, 0.39216),
                (1.00000, 0.70196, 0.40000),
                (1.00000, 0.70588, 0.40784),
                (1.00000, 0.70980, 0.41569),
                (1.00000, 0.71373, 0.42353),
                (1.00000, 0.71765, 0.43137),
                (1.00000, 0.72157, 0.43922),
                (1.00000, 0.72549, 0.44706),
                (1.00000, 0.72941, 0.45490),
                (1.00000, 0.73333, 0.46275),
                (1.00000, 0.73725, 0.47059),
                (1.00000, 0.74118, 0.47843),
                (1.00000, 0.74510, 0.48627),
                (1.00000, 0.74902, 0.49412),
                (1.00000, 0.75294, 0.50196),
                (1.00000, 0.75686, 0.50980),
                (1.00000, 0.76078, 0.51765),
                (1.00000, 0.76471, 0.52549),
                (1.00000, 0.76863, 0.53333),
                (1.00000, 0.77255, 0.54118),
                (1.00000, 0.77647, 0.54902),
                (1.00000, 0.78039, 0.55686),
                (1.00000, 0.78431, 0.56471),
                (1.00000, 0.78824, 0.57255),
                (1.00000, 0.79216, 0.58039),
                (1.00000, 0.79608, 0.58824),
                (1.00000, 0.80000, 0.59608),
                (1.00000, 0.80392, 0.60392),
                (1.00000, 0.80784, 0.61176),
                (1.00000, 0.81176, 0.61961),
                (1.00000, 0.81569, 0.62745),
                (1.00000, 0.81961, 0.63529),
                (1.00000, 0.82353, 0.64314),
                (1.00000, 0.82745, 0.65098),
                (1.00000, 0.83137, 0.65882),
                (1.00000, 0.83529, 0.66667),
                (1.00000, 0.83922, 0.67451),
                (1.00000, 0.84314, 0.68235),
                (1.00000, 0.84706, 0.69020),
                (1.00000, 0.85098, 0.69804),
                (1.00000, 0.85490, 0.70588),
                (1.00000, 0.85882, 0.71373),
                (1.00000, 0.86275, 0.72157),
                (1.00000, 0.86667, 0.72941),
                (1.00000, 0.87059, 0.73725),
                (1.00000, 0.87451, 0.74510),
                (1.00000, 0.87843, 0.75294),
                (1.00000, 0.88235, 0.76078),
                (1.00000, 0.88627, 0.76863),
                (1.00000, 0.89020, 0.77647),
                (1.00000, 0.89412, 0.78431),
                (1.00000, 0.89804, 0.79216),
                (1.00000, 0.90196, 0.80000),
                (1.00000, 0.90588, 0.80784),
                (1.00000, 0.90980, 0.81569),
                (1.00000, 0.91373, 0.82353),
                (1.00000, 0.91765, 0.83137),
                (1.00000, 0.92157, 0.83922),
                (1.00000, 0.92549, 0.84706),
                (1.00000, 0.92941, 0.85490),
                (1.00000, 0.93333, 0.86275),
                (1.00000, 0.93725, 0.87059),
                (1.00000, 0.94118, 0.87843),
                (1.00000, 0.94510, 0.88627),
                (1.00000, 0.94902, 0.89412),
                (1.00000, 0.95294, 0.90196),
                (1.00000, 0.95686, 0.90980),
                (1.00000, 0.96078, 0.91765),
                (1.00000, 0.96471, 0.92549),
                (1.00000, 0.96863, 0.93333),
                (1.00000, 0.97255, 0.94118),
                (1.00000, 0.97647, 0.94902),
                (1.00000, 0.98039, 0.95686),
                (1.00000, 0.98431, 0.96471),
                (1.00000, 0.98824, 0.97255),
                (1.00000, 0.99216, 0.98039),
                (1.00000, 0.99608, 0.98824),
                (1.00000, 1.00000, 0.99608),
                (1.00000, 1.00000, 1.00000),
        )

cmap_idl15 = (
                (0.00000, 0.00000, 0.00000),  # noqa
                (0.07059, 0.00392, 0.00392),
                (0.14118, 0.00784, 0.01176),
                (0.21176, 0.01176, 0.01961),
                (0.28235, 0.01569, 0.02745),
                (0.35294, 0.01961, 0.03529),
                (0.42353, 0.02353, 0.04314),
                (0.49804, 0.02745, 0.05098),
                (0.56863, 0.03137, 0.05882),
                (0.63922, 0.03529, 0.06667),
                (0.70980, 0.03922, 0.07451),
                (0.78039, 0.04314, 0.08235),
                (0.85098, 0.04706, 0.09020),
                (0.92157, 0.05098, 0.09804),
                (0.99608, 0.05490, 0.10588),
                (0.97647, 0.05882, 0.11373),
                (0.95686, 0.06275, 0.12157),
                (0.93725, 0.06667, 0.12941),
                (0.91765, 0.07059, 0.13725),
                (0.89804, 0.07451, 0.14510),
                (0.87451, 0.07843, 0.15294),
                (0.85490, 0.08235, 0.16078),
                (0.83529, 0.08627, 0.16863),
                (0.81569, 0.09020, 0.17647),
                (0.79608, 0.09412, 0.18431),
                (0.77255, 0.09804, 0.19216),
                (0.75294, 0.10196, 0.20000),
                (0.73333, 0.10588, 0.20784),
                (0.71373, 0.10980, 0.21569),
                (0.69412, 0.11373, 0.22353),
                (0.67451, 0.11765, 0.23137),
                (0.65098, 0.12157, 0.23922),
                (0.63137, 0.12549, 0.24706),
                (0.61176, 0.12941, 0.25490),
                (0.59216, 0.13333, 0.26275),
                (0.57255, 0.13725, 0.27059),
                (0.54902, 0.14118, 0.27843),
                (0.52941, 0.14510, 0.28627),
                (0.50980, 0.14902, 0.29412),
                (0.49020, 0.15294, 0.30196),
                (0.47059, 0.15686, 0.30980),
                (0.45098, 0.16078, 0.31765),
                (0.42745, 0.16471, 0.32549),
                (0.40784, 0.16863, 0.33333),
                (0.38824, 0.17255, 0.34118),
                (0.36863, 0.17647, 0.34902),
                (0.34902, 0.18039, 0.35686),
                (0.32549, 0.18431, 0.36471),
                (0.30588, 0.18824, 0.37255),
                (0.28627, 0.19216, 0.38039),
                (0.26667, 0.19608, 0.38824),
                (0.24706, 0.20000, 0.39608),
                (0.22745, 0.20392, 0.40392),
                (0.20392, 0.20784, 0.41176),
                (0.18431, 0.21176, 0.41961),
                (0.16471, 0.21569, 0.42745),
                (0.14510, 0.21961, 0.43529),
                (0.12549, 0.22353, 0.44314),
                (0.10196, 0.22745, 0.45098),
                (0.08235, 0.23137, 0.45882),
                (0.06275, 0.23529, 0.46667),
                (0.04314, 0.23922, 0.47451),
                (0.02353, 0.24314, 0.48235),
                (0.00000, 0.24706, 0.49020),
                (0.25098, 0.25098, 0.49804),
                (0.25490, 0.25490, 0.50588),
                (0.25882, 0.25882, 0.51373),
                (0.26275, 0.26275, 0.52157),
                (0.26667, 0.26667, 0.52941),
                (0.27059, 0.27059, 0.53725),
                (0.27451, 0.27451, 0.54510),
                (0.27843, 0.27843, 0.55294),
                (0.28235, 0.28235, 0.56078),
                (0.28627, 0.28627, 0.56863),
                (0.29020, 0.29020, 0.57647),
                (0.29412, 0.29412, 0.58431),
                (0.29804, 0.29804, 0.59216),
                (0.30196, 0.30196, 0.60000),
                (0.30588, 0.30588, 0.60784),
                (0.30980, 0.30980, 0.61569),
                (0.31373, 0.31373, 0.62353),
                (0.31765, 0.31765, 0.63137),
                (0.32157, 0.32157, 0.63922),
                (0.32549, 0.32549, 0.64706),
                (0.32941, 0.32941, 0.65490),
                (0.33333, 0.33333, 0.66275),
                (0.33725, 0.33725, 0.67059),
                (0.34118, 0.34118, 0.67843),
                (0.34510, 0.34510, 0.68627),
                (0.34902, 0.34902, 0.69412),
                (0.35294, 0.35294, 0.70196),
                (0.35686, 0.35686, 0.70980),
                (0.36078, 0.36078, 0.71765),
                (0.36471, 0.36471, 0.72549),
                (0.36863, 0.36863, 0.73333),
                (0.37255, 0.37255, 0.74118),
                (0.37647, 0.37647, 0.74902),
                (0.38039, 0.38039, 0.75686),
                (0.38431, 0.38431, 0.76471),
                (0.38824, 0.38824, 0.77255),
                (0.39216, 0.39216, 0.78039),
                (0.39608, 0.39608, 0.78824),
                (0.40000, 0.40000, 0.79608),
                (0.40392, 0.40392, 0.80392),
                (0.40784, 0.40784, 0.81176),
                (0.41176, 0.41176, 0.81961),
                (0.41569, 0.41569, 0.82745),
                (0.41961, 0.41961, 0.83529),
                (0.42353, 0.42353, 0.84314),
                (0.42745, 0.42745, 0.85098),
                (0.43137, 0.43137, 0.85882),
                (0.43529, 0.43529, 0.86667),
                (0.43922, 0.43922, 0.87451),
                (0.44314, 0.44314, 0.88235),
                (0.44706, 0.44706, 0.89020),
                (0.45098, 0.45098, 0.89804),
                (0.45490, 0.45490, 0.90588),
                (0.45882, 0.45882, 0.91373),
                (0.46275, 0.46275, 0.92157),
                (0.46667, 0.46667, 0.92941),
                (0.47059, 0.47059, 0.93725),
                (0.47451, 0.47451, 0.94510),
                (0.47843, 0.47843, 0.95294),
                (0.48235, 0.48235, 0.96078),
                (0.48627, 0.48627, 0.96863),
                (0.49020, 0.49020, 0.97647),
                (0.49412, 0.49412, 0.98431),
                (0.49804, 0.49804, 0.99216),
                (0.50196, 0.50196, 1.00000),
                (0.50588, 0.50588, 0.98431),
                (0.50980, 0.50980, 0.96863),
                (0.51373, 0.51373, 0.95294),
                (0.51765, 0.51765, 0.93333),
                (0.52157, 0.52157, 0.91765),
                (0.52549, 0.52549, 0.90196),
                (0.52941, 0.52941, 0.88627),
                (0.53333, 0.53333, 0.86667),
                (0.53725, 0.53725, 0.85098),
                (0.54118, 0.54118, 0.83529),
                (0.54510, 0.54510, 0.81961),
                (0.54902, 0.54902, 0.80000),
                (0.55294, 0.55294, 0.78431),
                (0.55686, 0.55686, 0.76863),
                (0.56078, 0.56078, 0.75294),
                (0.56471, 0.56471, 0.73333),
                (0.56863, 0.56863, 0.71765),
                (0.57255, 0.57255, 0.70196),
                (0.57647, 0.57647, 0.68627),
                (0.58039, 0.58039, 0.66667),
                (0.58431, 0.58431, 0.65098),
                (0.58824, 0.58824, 0.63529),
                (0.59216, 0.59216, 0.61961),
                (0.59608, 0.59608, 0.60000),
                (0.60000, 0.60000, 0.58431),
                (0.60392, 0.60392, 0.56863),
                (0.60784, 0.60784, 0.55294),
                (0.61176, 0.61176, 0.53333),
                (0.61569, 0.61569, 0.51765),
                (0.61961, 0.61961, 0.50196),
                (0.62353, 0.62353, 0.48627),
                (0.62745, 0.62745, 0.46667),
                (0.63137, 0.63137, 0.45098),
                (0.63529, 0.63529, 0.43529),
                (0.63922, 0.63922, 0.41961),
                (0.64314, 0.64314, 0.40000),
                (0.64706, 0.64706, 0.38431),
                (0.65098, 0.65098, 0.36863),
                (0.65490, 0.65490, 0.35294),
                (0.65882, 0.65882, 0.33333),
                (0.66275, 0.66275, 0.31765),
                (0.66667, 0.66667, 0.30196),
                (0.67059, 0.67059, 0.28627),
                (0.67451, 0.67451, 0.26667),
                (0.67843, 0.67843, 0.25098),
                (0.68235, 0.68235, 0.23529),
                (0.68627, 0.68627, 0.21961),
                (0.69020, 0.69020, 0.20000),
                (0.69412, 0.69412, 0.18431),
                (0.69804, 0.69804, 0.16863),
                (0.70196, 0.70196, 0.15294),
                (0.70588, 0.70588, 0.13333),
                (0.70980, 0.70980, 0.11765),
                (0.71373, 0.71373, 0.10196),
                (0.71765, 0.71765, 0.08627),
                (0.72157, 0.72157, 0.06667),
                (0.72549, 0.72549, 0.05098),
                (0.72941, 0.72941, 0.03529),
                (0.73333, 0.73333, 0.01961),
                (0.73725, 0.73725, 0.00000),
                (0.74118, 0.74118, 0.01176),
                (0.74510, 0.74510, 0.02745),
                (0.74902, 0.74902, 0.04314),
                (0.75294, 0.75294, 0.05882),
                (0.75686, 0.75686, 0.07451),
                (0.76078, 0.76078, 0.08627),
                (0.76471, 0.76471, 0.10196),
                (0.76863, 0.76863, 0.11765),
                (0.77255, 0.77255, 0.13333),
                (0.77647, 0.77647, 0.14902),
                (0.78039, 0.78039, 0.16078),
                (0.78431, 0.78431, 0.17647),
                (0.78824, 0.78824, 0.19216),
                (0.79216, 0.79216, 0.20784),
                (0.79608, 0.79608, 0.22353),
                (0.80000, 0.80000, 0.23529),
                (0.80392, 0.80392, 0.25098),
                (0.80784, 0.80784, 0.26667),
                (0.81176, 0.81176, 0.28235),
                (0.81569, 0.81569, 0.29804),
                (0.81961, 0.81961, 0.30980),
                (0.82353, 0.82353, 0.32549),
                (0.82745, 0.82745, 0.34118),
                (0.83137, 0.83137, 0.35686),
                (0.83529, 0.83529, 0.37255),
                (0.83922, 0.83922, 0.38431),
                (0.84314, 0.84314, 0.40000),
                (0.84706, 0.84706, 0.41569),
                (0.85098, 0.85098, 0.43137),
                (0.85490, 0.85490, 0.44706),
                (0.85882, 0.85882, 0.45882),
                (0.86275, 0.86275, 0.47451),
                (0.86667, 0.86667, 0.49020),
                (0.87059, 0.87059, 0.50588),
                (0.87451, 0.87451, 0.52157),
                (0.87843, 0.87843, 0.53725),
                (0.88235, 0.88235, 0.54902),
                (0.88627, 0.88627, 0.56471),
                (0.89020, 0.89020, 0.58039),
                (0.89412, 0.89412, 0.59608),
                (0.89804, 0.89804, 0.61176),
                (0.90196, 0.90196, 0.62353),
                (0.90588, 0.90588, 0.63922),
                (0.90980, 0.90980, 0.65490),
                (0.91373, 0.91373, 0.67059),
                (0.91765, 0.91765, 0.68627),
                (0.92157, 0.92157, 0.69804),
                (0.92549, 0.92549, 0.71373),
                (0.92941, 0.92941, 0.72941),
                (0.93333, 0.93333, 0.74510),
                (0.93725, 0.93725, 0.76078),
                (0.94118, 0.94118, 0.77255),
                (0.94510, 0.94510, 0.78824),
                (0.94902, 0.94902, 0.80392),
                (0.95294, 0.95294, 0.81961),
                (0.95686, 0.95686, 0.83529),
                (0.96078, 0.96078, 0.84706),
                (0.96471, 0.96471, 0.86275),
                (0.96863, 0.96863, 0.87843),
                (0.97255, 0.97255, 0.89412),
                (0.97647, 0.97647, 0.90980),
                (0.98039, 0.98039, 0.92157),
                (0.98431, 0.98431, 0.93725),
                (0.98824, 0.98824, 0.95294),
                (0.99216, 0.99216, 0.96863),
                (0.99608, 0.99608, 0.98431),
                (1.00000, 1.00000, 1.00000),
)

cmap_rainbow3 = (
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.00000),
                (0.00000, 0.00000, 0.03922),
                (0.00000, 0.00000, 0.07843),
                (0.00000, 0.00000, 0.11765),
                (0.00000, 0.00000, 0.15686),
                (0.00000, 0.00000, 0.20000),
                (0.00000, 0.00000, 0.23922),
                (0.00000, 0.00000, 0.27843),
                (0.00000, 0.00000, 0.31765),
                (0.00000, 0.00000, 0.35686),
                (0.00000, 0.00000, 0.40000),
                (0.00000, 0.00000, 0.43922),
                (0.00000, 0.00000, 0.47843),
                (0.00000, 0.00000, 0.51765),
                (0.00000, 0.00000, 0.55686),
                (0.00000, 0.00000, 0.60000),
                (0.00000, 0.00000, 0.63922),
                (0.00000, 0.00000, 0.67843),
                (0.00000, 0.00000, 0.71765),
                (0.00000, 0.00000, 0.75686),
                (0.00000, 0.00000, 0.80000),
                (0.00000, 0.00000, 0.83922),
                (0.00000, 0.00000, 0.87843),
                (0.00000, 0.00000, 0.91765),
                (0.00000, 0.00000, 0.95686),
                (0.00000, 0.00000, 1.00000),
                (0.00000, 0.03137, 1.00000),
                (0.00000, 0.06275, 1.00000),
                (0.00000, 0.09412, 1.00000),
                (0.00000, 0.12549, 1.00000),
                (0.00000, 0.15686, 1.00000),
                (0.00000, 0.18824, 1.00000),
                (0.00000, 0.21961, 1.00000),
                (0.00000, 0.25490, 1.00000),
                (0.00000, 0.28627, 1.00000),
                (0.00000, 0.31765, 1.00000),
                (0.00000, 0.34902, 1.00000),
                (0.00000, 0.38039, 1.00000),
                (0.00000, 0.41176, 1.00000),
                (0.00000, 0.44314, 1.00000),
                (0.00000, 0.47843, 1.00000),
                (0.00000, 0.49804, 1.00000),
                (0.00000, 0.51765, 1.00000),
                (0.00000, 0.53725, 1.00000),
                (0.00000, 0.55686, 1.00000),
                (0.00000, 0.58039, 1.00000),
                (0.00000, 0.60000, 1.00000),
                (0.00000, 0.61961, 1.00000),
                (0.00000, 0.63922, 1.00000),
                (0.00000, 0.65882, 1.00000),
                (0.00000, 0.68235, 1.00000),
                (0.00000, 0.70196, 1.00000),
                (0.00000, 0.72157, 1.00000),
                (0.00000, 0.74118, 1.00000),
                (0.00000, 0.76078, 1.00000),
                (0.00000, 0.78431, 1.00000),
                (0.00000, 0.79608, 1.00000),
                (0.00000, 0.81176, 1.00000),
                (0.00000, 0.82745, 1.00000),
                (0.00000, 0.83922, 1.00000),
                (0.00000, 0.85490, 1.00000),
                (0.00000, 0.87059, 1.00000),
                (0.00000, 0.88235, 1.00000),
                (0.00000, 0.89804, 1.00000),
                (0.00000, 0.91373, 1.00000),
                (0.00000, 0.92549, 1.00000),
                (0.00000, 0.94118, 1.00000),
                (0.00000, 0.95686, 1.00000),
                (0.00000, 0.96863, 1.00000),
                (0.00000, 0.98431, 1.00000),
                (0.00000, 1.00000, 1.00000),
                (0.00000, 1.00000, 0.98039),
                (0.00000, 1.00000, 0.96078),
                (0.00000, 1.00000, 0.94118),
                (0.00000, 1.00000, 0.92157),
                (0.00000, 1.00000, 0.90196),
                (0.00000, 1.00000, 0.88235),
                (0.00000, 1.00000, 0.86275),
                (0.00000, 1.00000, 0.84314),
                (0.00000, 1.00000, 0.82353),
                (0.00000, 1.00000, 0.80392),
                (0.00000, 1.00000, 0.78431),
                (0.00000, 1.00000, 0.76471),
                (0.00000, 1.00000, 0.74510),
                (0.00000, 1.00000, 0.72549),
                (0.00000, 1.00000, 0.70588),
                (0.00000, 1.00000, 0.65882),
                (0.00000, 1.00000, 0.61176),
                (0.00000, 1.00000, 0.56471),
                (0.00000, 1.00000, 0.51765),
                (0.00000, 1.00000, 0.47059),
                (0.00000, 1.00000, 0.42353),
                (0.00000, 1.00000, 0.37647),
                (0.00000, 1.00000, 0.32549),
                (0.00000, 1.00000, 0.27843),
                (0.00000, 1.00000, 0.23137),
                (0.00000, 1.00000, 0.18431),
                (0.00000, 1.00000, 0.13725),
                (0.00000, 1.00000, 0.09020),
                (0.00000, 1.00000, 0.04314),
                (0.00000, 1.00000, 0.00000),
                (0.04706, 1.00000, 0.00000),
                (0.09412, 1.00000, 0.00000),
                (0.14118, 1.00000, 0.00000),
                (0.18824, 1.00000, 0.00000),
                (0.23529, 1.00000, 0.00000),
                (0.28235, 1.00000, 0.00000),
                (0.32941, 1.00000, 0.00000),
                (0.37647, 1.00000, 0.00000),
                (0.42353, 1.00000, 0.00000),
                (0.47059, 1.00000, 0.00000),
                (0.51765, 1.00000, 0.00000),
                (0.56471, 1.00000, 0.00000),
                (0.61176, 1.00000, 0.00000),
                (0.65882, 1.00000, 0.00000),
                (0.70588, 1.00000, 0.00000),
                (0.72549, 1.00000, 0.00000),
                (0.74510, 1.00000, 0.00000),
                (0.76471, 1.00000, 0.00000),
                (0.78431, 1.00000, 0.00000),
                (0.80392, 1.00000, 0.00000),
                (0.82353, 1.00000, 0.00000),
                (0.84314, 1.00000, 0.00000),
                (0.86275, 1.00000, 0.00000),
                (0.88235, 1.00000, 0.00000),
                (0.90196, 1.00000, 0.00000),
                (0.92157, 1.00000, 0.00000),
                (0.94118, 1.00000, 0.00000),
                (0.96078, 1.00000, 0.00000),
                (0.98039, 1.00000, 0.00000),
                (1.00000, 1.00000, 0.00000),
                (0.99608, 0.98039, 0.00000),
                (0.99608, 0.96078, 0.00000),
                (0.99608, 0.94510, 0.00000),
                (0.99608, 0.92549, 0.00000),
                (0.99608, 0.90588, 0.00000),
                (0.99216, 0.89020, 0.00000),
                (0.99216, 0.87059, 0.00000),
                (0.99216, 0.85098, 0.00000),
                (0.99216, 0.83529, 0.00000),
                (0.99216, 0.81569, 0.00000),
                (0.98824, 0.79608, 0.00000),
                (0.98824, 0.78039, 0.00000),
                (0.98824, 0.76078, 0.00000),
                (0.98824, 0.74118, 0.00000),
                (0.98824, 0.72549, 0.00000),
                (0.98824, 0.70588, 0.00000),
                (0.98824, 0.69020, 0.00000),
                (0.98824, 0.67451, 0.00000),
                (0.98824, 0.65490, 0.00000),
                (0.99216, 0.63922, 0.00000),
                (0.99216, 0.62353, 0.00000),
                (0.99216, 0.60392, 0.00000),
                (0.99216, 0.58824, 0.00000),
                (0.99216, 0.57255, 0.00000),
                (0.99608, 0.55294, 0.00000),
                (0.99608, 0.53725, 0.00000),
                (0.99608, 0.52157, 0.00000),
                (0.99608, 0.50196, 0.00000),
                (0.99608, 0.48627, 0.00000),
                (1.00000, 0.47059, 0.00000),
                (1.00000, 0.43922, 0.00000),
                (1.00000, 0.40784, 0.00000),
                (1.00000, 0.37647, 0.00000),
                (1.00000, 0.34510, 0.00000),
                (1.00000, 0.31373, 0.00000),
                (1.00000, 0.28235, 0.00000),
                (1.00000, 0.25098, 0.00000),
                (1.00000, 0.21569, 0.00000),
                (1.00000, 0.18431, 0.00000),
                (1.00000, 0.15294, 0.00000),
                (1.00000, 0.12157, 0.00000),
                (1.00000, 0.09020, 0.00000),
                (1.00000, 0.05882, 0.00000),
                (1.00000, 0.02745, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.00000),
                (1.00000, 0.00000, 0.04706),
                (1.00000, 0.00000, 0.09412),
                (1.00000, 0.00000, 0.14118),
                (1.00000, 0.00000, 0.18824),
                (1.00000, 0.00000, 0.23529),
                (1.00000, 0.00000, 0.28235),
                (1.00000, 0.00000, 0.32941),
                (1.00000, 0.00000, 0.37647),
                (1.00000, 0.00000, 0.42353),
                (1.00000, 0.00000, 0.47059),
                (1.00000, 0.00000, 0.51765),
                (1.00000, 0.00000, 0.56471),
                (1.00000, 0.00000, 0.61176),
                (1.00000, 0.00000, 0.65882),
                (1.00000, 0.00000, 0.70588),
                (1.00000, 0.00000, 0.72549),
                (1.00000, 0.00000, 0.74902),
                (1.00000, 0.00000, 0.77255),
                (1.00000, 0.00000, 0.79608),
                (1.00000, 0.00000, 0.81569),
                (1.00000, 0.00000, 0.83922),
                (1.00000, 0.00000, 0.86275),
                (1.00000, 0.00000, 0.88627),
                (1.00000, 0.00000, 0.90588),
                (1.00000, 0.00000, 0.92941),
                (1.00000, 0.00000, 0.95294),
                (1.00000, 0.00000, 0.97647),
                (1.00000, 0.00000, 1.00000),
                (1.00000, 0.03529, 1.00000),
                (1.00000, 0.07059, 1.00000),
                (1.00000, 0.10588, 1.00000),
                (1.00000, 0.14118, 1.00000),
                (1.00000, 0.18039, 1.00000),
                (1.00000, 0.21569, 1.00000),
                (1.00000, 0.25098, 1.00000),
                (1.00000, 0.28627, 1.00000),
                (1.00000, 0.32549, 1.00000),
                (1.00000, 0.36078, 1.00000),
                (1.00000, 0.39608, 1.00000),
                (1.00000, 0.43137, 1.00000),
                (1.00000, 0.47059, 1.00000),
                (1.00000, 0.48627, 1.00000),
                (1.00000, 0.50588, 1.00000),
                (1.00000, 0.52157, 1.00000),
                (1.00000, 0.54118, 1.00000),
                (1.00000, 0.56078, 1.00000),
                (1.00000, 0.57647, 1.00000),
                (1.00000, 0.59608, 1.00000),
                (1.00000, 0.61176, 1.00000),
                (1.00000, 0.63137, 1.00000),
                (1.00000, 0.65098, 1.00000),
                (1.00000, 0.66667, 1.00000),
                (1.00000, 0.68627, 1.00000),
                (1.00000, 0.70588, 1.00000),
                (1.00000, 0.74510, 1.00000),
                (1.00000, 0.78824, 1.00000),
                (1.00000, 0.83137, 1.00000),
                (1.00000, 0.87059, 1.00000),
                (1.00000, 0.91373, 1.00000),
                (1.00000, 0.95686, 1.00000),
                (1.00000, 1.00000, 1.00000),
)

cmap_ds9_a = (
                (0.0, 0.0, 0.0),  # noqa
                (0.0, 0.011764705882352941, 0.0),
                (0.0, 0.027450980392156862, 0.0),
                (0.0, 0.043137254901960784, 0.0),
                (0.0, 0.058823529411764705, 0.0),
                (0.0, 0.078431372549019607, 0.0),
                (0.0, 0.090196078431372548, 0.0),
                (0.0, 0.10980392156862745, 0.0),
                (0.0, 0.12156862745098039, 0.0),
                (0.0, 0.14117647058823529, 0.0),
                (0.0, 0.15294117647058825, 0.0),
                (0.0, 0.17254901960784313, 0.0),
                (0.0, 0.18431372549019609, 0.0),
                (0.0, 0.20392156862745098, 0.0),
                (0.0, 0.21568627450980393, 0.0),
                (0.0, 0.23529411764705882, 0.0),
                (0.0, 0.24705882352941178, 0.0),
                (0.0, 0.26666666666666666, 0.0),
                (0.0, 0.27843137254901962, 0.0),
                (0.0, 0.29411764705882354, 0.0),
                (0.0, 0.30980392156862746, 0.0),
                (0.0, 0.32549019607843138, 0.0),
                (0.0, 0.3411764705882353, 0.0),
                (0.0, 0.35686274509803922, 0.0),
                (0.0, 0.37254901960784315, 0.0),
                (0.0, 0.38823529411764707, 0.0),
                (0.0, 0.40392156862745099, 0.0),
                (0.0, 0.41960784313725491, 0.0),
                (0.0, 0.43529411764705883, 0.0),
                (0.0, 0.45098039215686275, 0.0),
                (0.0, 0.47058823529411764, 0.0),
                (0.0, 0.4823529411764706, 0.0),
                (0.0, 0.49803921568627452, 0.0),
                (0.0, 0.51372549019607838, 0.0078431372549019607),
                (0.0, 0.52941176470588236, 0.019607843137254902),
                (0.0, 0.54509803921568623, 0.027450980392156862),
                (0.0, 0.5607843137254902, 0.039215686274509803),
                (0.0, 0.57647058823529407, 0.050980392156862744),
                (0.0, 0.58823529411764708, 0.058823529411764705),
                (0.0, 0.60784313725490191, 0.070588235294117646),
                (0.0, 0.61960784313725492, 0.078431372549019607),
                (0.0, 0.63921568627450975, 0.090196078431372548),
                (0.0, 0.65098039215686276, 0.10196078431372549),
                (0.0, 0.6705882352941176, 0.11372549019607843),
                (0.0, 0.68235294117647061, 0.12156862745098039),
                (0.0, 0.70196078431372544, 0.13333333333333333),
                (0.0, 0.71372549019607845, 0.14117647058823529),
                (0.0, 0.73333333333333328, 0.15294117647058825),
                (0.0, 0.74509803921568629, 0.16470588235294117),
                (0.0, 0.76470588235294112, 0.17647058823529413),
                (0.0, 0.77647058823529413, 0.18431372549019609),
                (0.0, 0.79607843137254897, 0.19607843137254902),
                (0.0, 0.81176470588235294, 0.20784313725490197),
                (0.0, 0.82745098039215681, 0.21568627450980393),
                (0.0, 0.84313725490196079, 0.22745098039215686),
                (0.0, 0.85490196078431369, 0.23529411764705882),
                (0.0, 0.87450980392156863, 0.24705882352941178),
                (0.0, 0.88627450980392153, 0.25882352941176473),
                (0.0, 0.90588235294117647, 0.27058823529411763),
                (0.0, 0.91764705882352937, 0.27843137254901962),
                (0.0, 0.93725490196078431, 0.29019607843137257),
                (0.0, 0.94901960784313721, 0.29803921568627451),
                (0.0, 0.96862745098039216, 0.30980392156862746),
                (0.0, 0.98039215686274506, 0.32156862745098042),
                (0.0, 1.0, 0.33333333333333331),
                (0.011764705882352941, 0.98431372549019602, 0.3411764705882353),
                (0.027450980392156862, 0.96862745098039216, 0.35294117647058826),
                (0.043137254901960784, 0.95294117647058818, 0.36078431372549019),
                (0.058823529411764705, 0.93725490196078431, 0.37254901960784315),
                (0.074509803921568626, 0.92156862745098034, 0.38039215686274508),
                (0.090196078431372548, 0.90588235294117647, 0.39215686274509803),
                (0.10588235294117647, 0.8901960784313725, 0.40392156862745099),
                (0.12156862745098039, 0.87450980392156863, 0.41568627450980394),
                (0.13725490196078433, 0.85882352941176465, 0.42352941176470588),
                (0.15294117647058825, 0.84313725490196079, 0.43529411764705883),
                (0.16862745098039217, 0.82745098039215681, 0.44313725490196076),
                (0.18431372549019609, 0.81176470588235294, 0.45490196078431372),
                (0.20000000000000001, 0.79607843137254897, 0.46666666666666667),
                (0.21568627450980393, 0.7803921568627451, 0.47450980392156861),
                (0.23137254901960785, 0.76470588235294112, 0.48627450980392156),
                (0.24705882352941178, 0.74901960784313726, 0.49803921568627452),
                (0.2627450980392157, 0.73333333333333328, 0.50980392156862742),
                (0.27843137254901962, 0.71764705882352942, 0.51764705882352946),
                (0.29411764705882354, 0.70196078431372544, 0.52941176470588236),
                (0.30980392156862746, 0.68627450980392157, 0.53725490196078429),
                (0.32549019607843138, 0.6705882352941176, 0.5490196078431373),
                (0.3411764705882353, 0.65490196078431373, 0.5607843137254902),
                (0.35686274509803922, 0.63921568627450975, 0.5725490196078431),
                (0.37254901960784315, 0.62352941176470589, 0.58039215686274515),
                (0.38823529411764707, 0.60784313725490191, 0.59215686274509804),
                (0.40392156862745099, 0.59215686274509804, 0.59999999999999998),
                (0.41960784313725491, 0.57647058823529407, 0.61176470588235299),
                (0.43529411764705883, 0.5607843137254902, 0.62352941176470589),
                (0.44705882352941179, 0.5490196078431373, 0.63137254901960782),
                (0.46666666666666667, 0.52941176470588236, 0.64313725490196083),
                (0.47843137254901963, 0.51764705882352946, 0.65098039215686276),
                (0.49803921568627452, 0.49803921568627452, 0.66274509803921566),
                (0.50980392156862742, 0.48627450980392156, 0.6705882352941176),
                (0.52549019607843139, 0.47058823529411764, 0.68235294117647061),
                (0.54117647058823526, 0.45490196078431372, 0.69411764705882351),
                (0.55686274509803924, 0.4392156862745098, 0.70588235294117652),
                (0.5725490196078431, 0.42352941176470588, 0.71372549019607845),
                (0.58823529411764708, 0.40784313725490196, 0.72549019607843135),
                (0.60392156862745094, 0.39215686274509803, 0.73725490196078436),
                (0.62352941176470589, 0.37254901960784315, 0.74901960784313726),
                (0.63529411764705879, 0.36078431372549019, 0.75686274509803919),
                (0.65490196078431373, 0.3411764705882353, 0.7686274509803922),
                (0.66666666666666663, 0.32941176470588235, 0.77647058823529413),
                (0.68627450980392157, 0.30980392156862746, 0.78823529411764703),
                (0.69803921568627447, 0.29803921568627451, 0.80000000000000004),
                (0.71372549019607845, 0.28235294117647058, 0.80784313725490198),
                (0.72941176470588232, 0.26666666666666666, 0.81960784313725488),
                (0.74509803921568629, 0.25098039215686274, 0.82745098039215681),
                (0.76078431372549016, 0.23529411764705882, 0.83921568627450982),
                (0.77647058823529413, 0.2196078431372549, 0.85098039215686272),
                (0.792156862745098, 0.20392156862745098, 0.86274509803921573),
                (0.80784313725490198, 0.18823529411764706, 0.87058823529411766),
                (0.82352941176470584, 0.17254901960784313, 0.88235294117647056),
                (0.83921568627450982, 0.15686274509803921, 0.8901960784313725),
                (0.85490196078431369, 0.14117647058823529, 0.90196078431372551),
                (0.87058823529411766, 0.12549019607843137, 0.9137254901960784),
                (0.88627450980392153, 0.10980392156862745, 0.92549019607843142),
                (0.90196078431372551, 0.094117647058823528, 0.93333333333333335),
                (0.91764705882352937, 0.078431372549019607, 0.94509803921568625),
                (0.93333333333333335, 0.062745098039215685, 0.95294117647058818),
                (0.94901960784313721, 0.047058823529411764, 0.96470588235294119),
                (0.96470588235294119, 0.031372549019607843, 0.97647058823529409),
                (0.98039215686274506, 0.015686274509803921, 0.9882352941176471),
                (0.99607843137254903, 0.0, 0.99607843137254903),
                (1.0, 0.0, 0.9882352941176471),
                (1.0, 0.0, 0.97254901960784312),
                (1.0, 0.0, 0.96078431372549022),
                (1.0, 0.0, 0.94509803921568625),
                (1.0, 0.0, 0.93333333333333335),
                (1.0, 0.0, 0.91764705882352937),
                (1.0, 0.0, 0.90196078431372551),
                (1.0, 0.0, 0.88627450980392153),
                (1.0, 0.0, 0.87450980392156863),
                (1.0, 0.0, 0.85882352941176465),
                (1.0, 0.0, 0.84705882352941175),
                (1.0, 0.0, 0.83137254901960789),
                (1.0, 0.0, 0.81960784313725488),
                (1.0, 0.0, 0.80392156862745101),
                (1.0, 0.0, 0.792156862745098),
                (1.0, 0.0, 0.77647058823529413),
                (1.0, 0.0, 0.76470588235294112),
                (1.0, 0.0, 0.74901960784313726),
                (1.0, 0.0, 0.73725490196078436),
                (1.0, 0.0, 0.72156862745098038),
                (1.0, 0.0, 0.70980392156862748),
                (1.0, 0.0, 0.69411764705882351),
                (1.0, 0.0, 0.67843137254901964),
                (1.0, 0.0, 0.66666666666666663),
                (1.0, 0.0, 0.65098039215686276),
                (1.0, 0.0, 0.63921568627450975),
                (1.0, 0.0, 0.62352941176470589),
                (1.0, 0.0, 0.61176470588235299),
                (1.0, 0.0, 0.59607843137254901),
                (1.0, 0.0, 0.58431372549019611),
                (1.0, 0.0, 0.56862745098039214),
                (1.0, 0.0, 0.55686274509803924),
                (1.0, 0.0, 0.54117647058823526),
                (1.0, 0.0, 0.52549019607843139),
                (1.0, 0.0, 0.50980392156862742),
                (1.0, 0.0, 0.49803921568627452),
                (1.0, 0.0, 0.48627450980392156),
                (1.0, 0.0, 0.47058823529411764),
                (1.0, 0.0, 0.45490196078431372),
                (1.0, 0.0, 0.4392156862745098),
                (1.0, 0.0, 0.42745098039215684),
                (1.0, 0.0, 0.40784313725490196),
                (1.0, 0.0, 0.396078431372549),
                (1.0, 0.0, 0.38039215686274508),
                (1.0, 0.0, 0.36470588235294116),
                (1.0, 0.0, 0.34901960784313724),
                (1.0, 0.0, 0.33333333333333331),
                (1.0, 0.0, 0.31764705882352939),
                (1.0, 0.0, 0.30588235294117649),
                (1.0, 0.0, 0.28627450980392155),
                (1.0, 0.0, 0.27450980392156865),
                (1.0, 0.0, 0.25882352941176473),
                (1.0, 0.0, 0.24313725490196078),
                (1.0, 0.0, 0.22745098039215686),
                (1.0, 0.0, 0.21568627450980393),
                (1.0, 0.0, 0.20000000000000001),
                (1.0, 0.0, 0.18431372549019609),
                (1.0, 0.0, 0.17254901960784313),
                (1.0, 0.0, 0.15294117647058825),
                (1.0, 0.0, 0.14117647058823529),
                (1.0, 0.0, 0.12549019607843137),
                (1.0, 0.0, 0.10980392156862745),
                (1.0, 0.0, 0.094117647058823528),
                (1.0, 0.0, 0.082352941176470587),
                (1.0, 0.0, 0.062745098039215685),
                (1.0, 0.0, 0.050980392156862744),
                (1.0, 0.0, 0.035294117647058823),
                (1.0, 0.0, 0.019607843137254902),
                (1.0, 0.0, 0.0039215686274509803),
                (1.0, 0.0078431372549019607, 0.0),
                (1.0, 0.027450980392156862, 0.0),
                (1.0, 0.043137254901960784, 0.0),
                (1.0, 0.058823529411764705, 0.0),
                (1.0, 0.078431372549019607, 0.0),
                (1.0, 0.090196078431372548, 0.0),
                (1.0, 0.10980392156862745, 0.0),
                (1.0, 0.12549019607843137, 0.0),
                (1.0, 0.14509803921568629, 0.0),
                (1.0, 0.16078431372549021, 0.0),
                (1.0, 0.1803921568627451, 0.0),
                (1.0, 0.19215686274509805, 0.0),
                (1.0, 0.21176470588235294, 0.0),
                (1.0, 0.22745098039215686, 0.0),
                (1.0, 0.24705882352941178, 0.0),
                (1.0, 0.2627450980392157, 0.0),
                (1.0, 0.28235294117647058, 0.0),
                (1.0, 0.29411764705882354, 0.0),
                (1.0, 0.31372549019607843, 0.0),
                (1.0, 0.32941176470588235, 0.0),
                (1.0, 0.34901960784313724, 0.0),
                (1.0, 0.36470588235294116, 0.0),
                (1.0, 0.37647058823529411, 0.0),
                (1.0, 0.396078431372549, 0.0),
                (1.0, 0.41568627450980394, 0.0),
                (1.0, 0.43137254901960786, 0.0),
                (1.0, 0.44705882352941179, 0.0),
                (1.0, 0.46666666666666667, 0.0),
                (1.0, 0.4823529411764706, 0.0),
                (1.0, 0.50196078431372548, 0.0),
                (1.0, 0.51764705882352946, 0.0),
                (1.0, 0.53333333333333333, 0.0),
                (1.0, 0.5490196078431373, 0.0),
                (1.0, 0.56862745098039214, 0.0),
                (1.0, 0.58431372549019611, 0.0),
                (1.0, 0.60392156862745094, 0.0),
                (1.0, 0.61960784313725492, 0.0),
                (1.0, 0.63529411764705879, 0.0),
                (1.0, 0.65098039215686276, 0.0),
                (1.0, 0.6705882352941176, 0.0),
                (1.0, 0.68627450980392157, 0.0),
                (1.0, 0.70196078431372544, 0.0),
                (1.0, 0.72156862745098038, 0.0),
                (1.0, 0.73333333333333328, 0.0),
                (1.0, 0.75294117647058822, 0.0),
                (1.0, 0.7686274509803922, 0.0),
                (1.0, 0.78823529411764703, 0.0),
                (1.0, 0.80392156862745101, 0.0),
                (1.0, 0.82352941176470584, 0.0),
                (1.0, 0.83921568627450982, 0.0),
                (1.0, 0.85490196078431369, 0.0),
                (1.0, 0.87450980392156863, 0.0),
                (1.0, 0.8901960784313725, 0.0),
                (1.0, 0.90588235294117647, 0.0),
                (1.0, 0.92549019607843142, 0.0),
                (1.0, 0.94117647058823528, 0.0),
                (1.0, 0.96078431372549022, 0.0),
                (1.0, 0.97647058823529409, 0.0),
)

cmap_ds9_b = (
                (0.0, 0.0, 0.0),  # noqa
                (0.0, 0.0, 0.011764705882352941),
                (0.0, 0.0, 0.027450980392156862),
                (0.0, 0.0, 0.043137254901960784),
                (0.0, 0.0, 0.058823529411764705),
                (0.0, 0.0, 0.078431372549019607),
                (0.0, 0.0, 0.090196078431372548),
                (0.0, 0.0, 0.10980392156862745),
                (0.0, 0.0, 0.12156862745098039),
                (0.0, 0.0, 0.14117647058823529),
                (0.0, 0.0, 0.15294117647058825),
                (0.0, 0.0, 0.17254901960784313),
                (0.0, 0.0, 0.18431372549019609),
                (0.0, 0.0, 0.20392156862745098),
                (0.0, 0.0, 0.21568627450980393),
                (0.0, 0.0, 0.23529411764705882),
                (0.0, 0.0, 0.24705882352941178),
                (0.0, 0.0, 0.26666666666666666),
                (0.0, 0.0, 0.27843137254901962),
                (0.0, 0.0, 0.29411764705882354),
                (0.0, 0.0, 0.30980392156862746),
                (0.0, 0.0, 0.32549019607843138),
                (0.0, 0.0, 0.3411764705882353),
                (0.0, 0.0, 0.35686274509803922),
                (0.0, 0.0, 0.37254901960784315),
                (0.0, 0.0, 0.38823529411764707),
                (0.0, 0.0, 0.40392156862745099),
                (0.0, 0.0, 0.41960784313725491),
                (0.0, 0.0, 0.43529411764705883),
                (0.0, 0.0, 0.45098039215686275),
                (0.0, 0.0, 0.47058823529411764),
                (0.0, 0.0, 0.4823529411764706),
                (0.0, 0.0, 0.49803921568627452),
                (0.0, 0.0, 0.51372549019607838),
                (0.0, 0.0, 0.52941176470588236),
                (0.0, 0.0, 0.54509803921568623),
                (0.0, 0.0, 0.5607843137254902),
                (0.0, 0.0, 0.57647058823529407),
                (0.0, 0.0, 0.58823529411764708),
                (0.0, 0.0, 0.60784313725490191),
                (0.0, 0.0, 0.61960784313725492),
                (0.0, 0.0, 0.63921568627450975),
                (0.0, 0.0, 0.65098039215686276),
                (0.0, 0.0, 0.6705882352941176),
                (0.0, 0.0, 0.68235294117647061),
                (0.0, 0.0, 0.70196078431372544),
                (0.0, 0.0, 0.71372549019607845),
                (0.0, 0.0, 0.73333333333333328),
                (0.0, 0.0, 0.74509803921568629),
                (0.0, 0.0, 0.76470588235294112),
                (0.0, 0.0, 0.77647058823529413),
                (0.0, 0.0, 0.79607843137254897),
                (0.0, 0.0, 0.81176470588235294),
                (0.0, 0.0, 0.82745098039215681),
                (0.0, 0.0, 0.84313725490196079),
                (0.0, 0.0, 0.85490196078431369),
                (0.0, 0.0, 0.87450980392156863),
                (0.0, 0.0, 0.88627450980392153),
                (0.0, 0.0, 0.90588235294117647),
                (0.0, 0.0, 0.91764705882352937),
                (0.0, 0.0, 0.93725490196078431),
                (0.0, 0.0, 0.94901960784313721),
                (0.0, 0.0, 0.96862745098039216),
                (0.0, 0.0, 0.98039215686274506),
                (0.0, 0.0, 1.0),
                (0.011764705882352941, 0.0, 0.98431372549019602),
                (0.027450980392156862, 0.0, 0.96862745098039216),
                (0.043137254901960784, 0.0, 0.95294117647058818),
                (0.058823529411764705, 0.0, 0.93725490196078431),
                (0.074509803921568626, 0.0, 0.92156862745098034),
                (0.090196078431372548, 0.0, 0.90588235294117647),
                (0.10588235294117647, 0.0, 0.8901960784313725),
                (0.12156862745098039, 0.0, 0.87450980392156863),
                (0.13725490196078433, 0.0, 0.85882352941176465),
                (0.15294117647058825, 0.0, 0.84313725490196079),
                (0.16862745098039217, 0.0, 0.82745098039215681),
                (0.18431372549019609, 0.0, 0.81176470588235294),
                (0.20000000000000001, 0.0, 0.79607843137254897),
                (0.21568627450980393, 0.0, 0.7803921568627451),
                (0.23137254901960785, 0.0, 0.76470588235294112),
                (0.24705882352941178, 0.0, 0.74901960784313726),
                (0.2627450980392157, 0.0, 0.73333333333333328),
                (0.27843137254901962, 0.0, 0.71764705882352942),
                (0.29411764705882354, 0.0, 0.70196078431372544),
                (0.30980392156862746, 0.0, 0.68627450980392157),
                (0.32549019607843138, 0.0, 0.6705882352941176),
                (0.3411764705882353, 0.0, 0.65490196078431373),
                (0.35686274509803922, 0.0, 0.63921568627450975),
                (0.37254901960784315, 0.0, 0.62352941176470589),
                (0.38823529411764707, 0.0, 0.60784313725490191),
                (0.40392156862745099, 0.0, 0.59215686274509804),
                (0.41960784313725491, 0.0, 0.57647058823529407),
                (0.43529411764705883, 0.0, 0.5607843137254902),
                (0.44705882352941179, 0.0, 0.5490196078431373),
                (0.46666666666666667, 0.0, 0.52941176470588236),
                (0.47843137254901963, 0.0, 0.51764705882352946),
                (0.49803921568627452, 0.0, 0.49803921568627452),
                (0.50980392156862742, 0.0, 0.48627450980392156),
                (0.52549019607843139, 0.0, 0.47058823529411764),
                (0.54117647058823526, 0.0, 0.45490196078431372),
                (0.55686274509803924, 0.0, 0.4392156862745098),
                (0.5725490196078431, 0.0, 0.42352941176470588),
                (0.58823529411764708, 0.0, 0.40784313725490196),
                (0.60392156862745094, 0.0, 0.39215686274509803),
                (0.62352941176470589, 0.0, 0.37254901960784315),
                (0.63529411764705879, 0.0, 0.36078431372549019),
                (0.65490196078431373, 0.0, 0.3411764705882353),
                (0.66666666666666663, 0.0, 0.32941176470588235),
                (0.68627450980392157, 0.0, 0.30980392156862746),
                (0.69803921568627447, 0.0, 0.29803921568627451),
                (0.71372549019607845, 0.0, 0.28235294117647058),
                (0.72941176470588232, 0.0, 0.26666666666666666),
                (0.74509803921568629, 0.0, 0.25098039215686274),
                (0.76078431372549016, 0.0, 0.23529411764705882),
                (0.77647058823529413, 0.0, 0.2196078431372549),
                (0.792156862745098, 0.0, 0.20392156862745098),
                (0.80784313725490198, 0.0, 0.18823529411764706),
                (0.82352941176470584, 0.0, 0.17254901960784313),
                (0.83921568627450982, 0.0, 0.15686274509803921),
                (0.85490196078431369, 0.0, 0.14117647058823529),
                (0.87058823529411766, 0.0, 0.12549019607843137),
                (0.88627450980392153, 0.0, 0.10980392156862745),
                (0.90196078431372551, 0.0, 0.094117647058823528),
                (0.91764705882352937, 0.0, 0.078431372549019607),
                (0.93333333333333335, 0.0, 0.062745098039215685),
                (0.94901960784313721, 0.0, 0.047058823529411764),
                (0.96470588235294119, 0.0, 0.031372549019607843),
                (0.98039215686274506, 0.0, 0.015686274509803921),
                (0.99607843137254903, 0.0, 0.0),
                (1.0, 0.0078431372549019607, 0.0),
                (1.0, 0.027450980392156862, 0.0),
                (1.0, 0.039215686274509803, 0.0),
                (1.0, 0.058823529411764705, 0.0),
                (1.0, 0.070588235294117646, 0.0),
                (1.0, 0.090196078431372548, 0.0),
                (1.0, 0.10196078431372549, 0.0),
                (1.0, 0.12156862745098039, 0.0),
                (1.0, 0.13333333333333333, 0.0),
                (1.0, 0.15294117647058825, 0.0),
                (1.0, 0.16470588235294117, 0.0),
                (1.0, 0.18431372549019609, 0.0),
                (1.0, 0.19607843137254902, 0.0),
                (1.0, 0.21568627450980393, 0.0),
                (1.0, 0.22745098039215686, 0.0),
                (1.0, 0.24705882352941178, 0.0),
                (1.0, 0.25882352941176473, 0.0),
                (1.0, 0.27843137254901962, 0.0),
                (1.0, 0.29019607843137257, 0.0),
                (1.0, 0.30588235294117649, 0.0),
                (1.0, 0.32156862745098042, 0.0),
                (1.0, 0.33725490196078434, 0.0),
                (1.0, 0.35686274509803922, 0.0),
                (1.0, 0.36862745098039218, 0.0),
                (1.0, 0.38823529411764707, 0.0),
                (1.0, 0.40000000000000002, 0.0),
                (1.0, 0.41960784313725491, 0.0),
                (1.0, 0.43137254901960786, 0.0),
                (1.0, 0.45098039215686275, 0.0),
                (1.0, 0.46274509803921571, 0.0),
                (1.0, 0.4823529411764706, 0.0),
                (1.0, 0.49411764705882355, 0.0),
                (1.0, 0.50980392156862742, 0.0),
                (1.0, 0.52549019607843139, 0.0),
                (1.0, 0.54117647058823526, 0.0),
                (1.0, 0.55686274509803924, 0.0),
                (1.0, 0.56862745098039214, 0.0),
                (1.0, 0.58823529411764708, 0.0),
                (1.0, 0.59999999999999998, 0.0),
                (1.0, 0.61960784313725492, 0.0),
                (1.0, 0.63137254901960782, 0.0),
                (1.0, 0.65098039215686276, 0.0),
                (1.0, 0.66274509803921566, 0.0),
                (1.0, 0.68235294117647061, 0.0),
                (1.0, 0.69411764705882351, 0.0),
                (1.0, 0.71372549019607845, 0.0),
                (1.0, 0.72941176470588232, 0.0),
                (1.0, 0.74509803921568629, 0.0),
                (1.0, 0.76078431372549016, 0.0),
                (1.0, 0.77647058823529413, 0.0),
                (1.0, 0.792156862745098, 0.0),
                (1.0, 0.80784313725490198, 0.0),
                (1.0, 0.82352941176470584, 0.0),
                (1.0, 0.83921568627450982, 0.0),
                (1.0, 0.85490196078431369, 0.0),
                (1.0, 0.8666666666666667, 0.0),
                (1.0, 0.88627450980392153, 0.0),
                (1.0, 0.89803921568627454, 0.0),
                (1.0, 0.91764705882352937, 0.0),
                (1.0, 0.92941176470588238, 0.0),
                (1.0, 0.94901960784313721, 0.0),
                (1.0, 0.96078431372549022, 0.0),
                (1.0, 0.98039215686274506, 0.0),
                (1.0, 0.99215686274509807, 0.0),
                (1.0, 1.0, 0.0078431372549019607),
                (1.0, 1.0, 0.023529411764705882),
                (1.0, 1.0, 0.039215686274509803),
                (1.0, 1.0, 0.054901960784313725),
                (1.0, 1.0, 0.070588235294117646),
                (1.0, 1.0, 0.086274509803921567),
                (1.0, 1.0, 0.10196078431372549),
                (1.0, 1.0, 0.11764705882352941),
                (1.0, 1.0, 0.13333333333333333),
                (1.0, 1.0, 0.14901960784313725),
                (1.0, 1.0, 0.16470588235294117),
                (1.0, 1.0, 0.1803921568627451),
                (1.0, 1.0, 0.19607843137254902),
                (1.0, 1.0, 0.21176470588235294),
                (1.0, 1.0, 0.22745098039215686),
                (1.0, 1.0, 0.24313725490196078),
                (1.0, 1.0, 0.25882352941176473),
                (1.0, 1.0, 0.27450980392156865),
                (1.0, 1.0, 0.29019607843137257),
                (1.0, 1.0, 0.30588235294117649),
                (1.0, 1.0, 0.32156862745098042),
                (1.0, 1.0, 0.33725490196078434),
                (1.0, 1.0, 0.35294117647058826),
                (1.0, 1.0, 0.36862745098039218),
                (1.0, 1.0, 0.3843137254901961),
                (1.0, 1.0, 0.40000000000000002),
                (1.0, 1.0, 0.41568627450980394),
                (1.0, 1.0, 0.42745098039215684),
                (1.0, 1.0, 0.44705882352941179),
                (1.0, 1.0, 0.46274509803921571),
                (1.0, 1.0, 0.47843137254901963),
                (1.0, 1.0, 0.49411764705882355),
                (1.0, 1.0, 0.50980392156862742),
                (1.0, 1.0, 0.52156862745098043),
                (1.0, 1.0, 0.54117647058823526),
                (1.0, 1.0, 0.55294117647058827),
                (1.0, 1.0, 0.5725490196078431),
                (1.0, 1.0, 0.58431372549019611),
                (1.0, 1.0, 0.60392156862745094),
                (1.0, 1.0, 0.61568627450980395),
                (1.0, 1.0, 0.63529411764705879),
                (1.0, 1.0, 0.6470588235294118),
                (1.0, 1.0, 0.66666666666666663),
                (1.0, 1.0, 0.67843137254901964),
                (1.0, 1.0, 0.69803921568627447),
                (1.0, 1.0, 0.70980392156862748),
                (1.0, 1.0, 0.72549019607843135),
                (1.0, 1.0, 0.74117647058823533),
                (1.0, 1.0, 0.75686274509803919),
                (1.0, 1.0, 0.77254901960784317),
                (1.0, 1.0, 0.78823529411764703),
                (1.0, 1.0, 0.80392156862745101),
                (1.0, 1.0, 0.81960784313725488),
                (1.0, 1.0, 0.83529411764705885),
                (1.0, 1.0, 0.85098039215686272),
                (1.0, 1.0, 0.8666666666666667),
                (1.0, 1.0, 0.88235294117647056),
                (1.0, 1.0, 0.90196078431372551),
                (1.0, 1.0, 0.9137254901960784),
                (1.0, 1.0, 0.93333333333333335),
                (1.0, 1.0, 0.94509803921568625),
                (1.0, 1.0, 0.96470588235294119),
                (1.0, 1.0, 0.97647058823529409),
                )

cmap_ds9_bb = (
                (0.0, 0.0, 0.0),  # noqa
                (0.0039215686274509803, 0.0, 0.0),
                (0.011764705882352941, 0.0, 0.0),
                (0.019607843137254902, 0.0, 0.0),
                (0.027450980392156862, 0.0, 0.0),
                (0.039215686274509803, 0.0, 0.0),
                (0.043137254901960784, 0.0, 0.0),
                (0.054901960784313725, 0.0, 0.0),
                (0.058823529411764705, 0.0, 0.0),
                (0.070588235294117646, 0.0, 0.0),
                (0.074509803921568626, 0.0, 0.0),
                (0.086274509803921567, 0.0, 0.0),
                (0.090196078431372548, 0.0, 0.0),
                (0.10196078431372549, 0.0, 0.0),
                (0.10588235294117647, 0.0, 0.0),
                (0.11764705882352941, 0.0, 0.0),
                (0.12156862745098039, 0.0, 0.0),
                (0.13333333333333333, 0.0, 0.0),
                (0.13725490196078433, 0.0, 0.0),
                (0.14509803921568629, 0.0, 0.0),
                (0.15294117647058825, 0.0, 0.0),
                (0.16078431372549021, 0.0, 0.0),
                (0.16862745098039217, 0.0, 0.0),
                (0.17647058823529413, 0.0, 0.0),
                (0.18431372549019609, 0.0, 0.0),
                (0.19215686274509805, 0.0, 0.0),
                (0.20000000000000001, 0.0, 0.0),
                (0.20784313725490197, 0.0, 0.0),
                (0.21568627450980393, 0.0, 0.0),
                (0.22352941176470589, 0.0, 0.0),
                (0.23529411764705882, 0.0, 0.0),
                (0.23921568627450981, 0.0, 0.0),
                (0.24705882352941178, 0.0, 0.0),
                (0.25490196078431371, 0.0, 0.0),
                (0.2627450980392157, 0.0, 0.0),
                (0.27058823529411763, 0.0, 0.0),
                (0.27843137254901962, 0.0, 0.0),
                (0.28627450980392155, 0.0, 0.0),
                (0.29411764705882354, 0.0, 0.0),
                (0.30196078431372547, 0.0, 0.0),
                (0.30980392156862746, 0.0, 0.0),
                (0.31764705882352939, 0.0, 0.0),
                (0.32549019607843138, 0.0, 0.0),
                (0.33333333333333331, 0.0, 0.0),
                (0.3411764705882353, 0.0, 0.0),
                (0.34901960784313724, 0.0, 0.0),
                (0.35686274509803922, 0.0, 0.0),
                (0.36470588235294116, 0.0, 0.0),
                (0.37254901960784315, 0.0, 0.0),
                (0.38039215686274508, 0.0, 0.0),
                (0.38823529411764707, 0.0, 0.0),
                (0.396078431372549, 0.0, 0.0),
                (0.40392156862745099, 0.0, 0.0),
                (0.41176470588235292, 0.0, 0.0),
                (0.41960784313725491, 0.0, 0.0),
                (0.42745098039215684, 0.0, 0.0),
                (0.43529411764705883, 0.0, 0.0),
                (0.44313725490196076, 0.0, 0.0),
                (0.45098039215686275, 0.0, 0.0),
                (0.45882352941176469, 0.0, 0.0),
                (0.46666666666666667, 0.0, 0.0),
                (0.47450980392156861, 0.0, 0.0),
                (0.4823529411764706, 0.0, 0.0),
                (0.49019607843137253, 0.0, 0.0),
                (0.49803921568627452, 0.0, 0.0),
                (0.50588235294117645, 0.0039215686274509803, 0.0),
                (0.51372549019607838, 0.011764705882352941, 0.0),
                (0.52156862745098043, 0.019607843137254902, 0.0),
                (0.52941176470588236, 0.027450980392156862, 0.0),
                (0.53725490196078429, 0.035294117647058823, 0.0),
                (0.54509803921568623, 0.043137254901960784, 0.0),
                (0.55294117647058827, 0.050980392156862744, 0.0),
                (0.5607843137254902, 0.058823529411764705, 0.0),
                (0.56862745098039214, 0.066666666666666666, 0.0),
                (0.57647058823529407, 0.074509803921568626, 0.0),
                (0.58431372549019611, 0.082352941176470587, 0.0),
                (0.59215686274509804, 0.090196078431372548, 0.0),
                (0.59999999999999998, 0.098039215686274508, 0.0),
                (0.60784313725490191, 0.10588235294117647, 0.0),
                (0.61568627450980395, 0.11372549019607843, 0.0),
                (0.62352941176470589, 0.12156862745098039, 0.0),
                (0.63137254901960782, 0.12941176470588237, 0.0),
                (0.63921568627450975, 0.13725490196078433, 0.0),
                (0.6470588235294118, 0.14509803921568629, 0.0),
                (0.65490196078431373, 0.15294117647058825, 0.0),
                (0.66274509803921566, 0.16078431372549021, 0.0),
                (0.6705882352941176, 0.16862745098039217, 0.0),
                (0.67843137254901964, 0.17647058823529413, 0.0),
                (0.68627450980392157, 0.18431372549019609, 0.0),
                (0.69411764705882351, 0.19215686274509805, 0.0),
                (0.70196078431372544, 0.20000000000000001, 0.0),
                (0.70980392156862748, 0.20784313725490197, 0.0),
                (0.71764705882352942, 0.21568627450980393, 0.0),
                (0.72156862745098038, 0.22352941176470589, 0.0),
                (0.73333333333333328, 0.23137254901960785, 0.0),
                (0.73725490196078436, 0.23921568627450981, 0.0),
                (0.74901960784313726, 0.24705882352941178, 0.0),
                (0.75294117647058822, 0.25490196078431371, 0.0),
                (0.76078431372549016, 0.2627450980392157, 0.0),
                (0.7686274509803922, 0.27058823529411763, 0.0),
                (0.77647058823529413, 0.27843137254901962, 0.0),
                (0.78431372549019607, 0.28627450980392155, 0.0),
                (0.792156862745098, 0.29411764705882354, 0.0),
                (0.80000000000000004, 0.30196078431372547, 0.0),
                (0.81176470588235294, 0.30980392156862746, 0.0),
                (0.81568627450980391, 0.31764705882352939, 0.0),
                (0.82745098039215681, 0.32549019607843138, 0.0),
                (0.83137254901960789, 0.33333333333333331, 0.0),
                (0.84313725490196079, 0.3411764705882353, 0.0),
                (0.84705882352941175, 0.34901960784313724, 0.0),
                (0.85490196078431369, 0.35686274509803922, 0.0),
                (0.86274509803921573, 0.36470588235294116, 0.0),
                (0.87058823529411766, 0.37254901960784315, 0.0),
                (0.8784313725490196, 0.38039215686274508, 0.0),
                (0.88627450980392153, 0.38823529411764707, 0.0),
                (0.89411764705882357, 0.396078431372549, 0.0),
                (0.90196078431372551, 0.40392156862745099, 0.0),
                (0.90980392156862744, 0.41176470588235292, 0.0),
                (0.91764705882352937, 0.41960784313725491, 0.0),
                (0.92549019607843142, 0.42745098039215684, 0.0),
                (0.93333333333333335, 0.43529411764705883, 0.0),
                (0.94117647058823528, 0.44313725490196076, 0.0),
                (0.94901960784313721, 0.45098039215686275, 0.0),
                (0.95686274509803926, 0.45882352941176469, 0.0),
                (0.96470588235294119, 0.46666666666666667, 0.0),
                (0.97254901960784312, 0.47450980392156861, 0.0),
                (0.98039215686274506, 0.4823529411764706, 0.0),
                (0.9882352941176471, 0.49019607843137253, 0.0),
                (0.99607843137254903, 0.49803921568627452, 0.0),
                (1.0, 0.50196078431372548, 0.0039215686274509803),
                (1.0, 0.51372549019607838, 0.011764705882352941),
                (1.0, 0.51764705882352946, 0.019607843137254902),
                (1.0, 0.52941176470588236, 0.027450980392156862),
                (1.0, 0.53333333333333333, 0.035294117647058823),
                (1.0, 0.54509803921568623, 0.043137254901960784),
                (1.0, 0.5490196078431373, 0.050980392156862744),
                (1.0, 0.5607843137254902, 0.058823529411764705),
                (1.0, 0.56470588235294117, 0.066666666666666666),
                (1.0, 0.57647058823529407, 0.074509803921568626),
                (1.0, 0.58039215686274515, 0.082352941176470587),
                (1.0, 0.59215686274509804, 0.090196078431372548),
                (1.0, 0.59607843137254901, 0.098039215686274508),
                (1.0, 0.60784313725490191, 0.10588235294117647),
                (1.0, 0.61176470588235299, 0.11372549019607843),
                (1.0, 0.62352941176470589, 0.12156862745098039),
                (1.0, 0.62745098039215685, 0.12941176470588237),
                (1.0, 0.63921568627450975, 0.13725490196078433),
                (1.0, 0.64313725490196083, 0.14509803921568629),
                (1.0, 0.65098039215686276, 0.15294117647058825),
                (1.0, 0.6588235294117647, 0.16078431372549021),
                (1.0, 0.66666666666666663, 0.16862745098039217),
                (1.0, 0.67843137254901964, 0.17647058823529413),
                (1.0, 0.68235294117647061, 0.18431372549019609),
                (1.0, 0.69411764705882351, 0.19215686274509805),
                (1.0, 0.69803921568627447, 0.20000000000000001),
                (1.0, 0.70980392156862748, 0.20784313725490197),
                (1.0, 0.71372549019607845, 0.21568627450980393),
                (1.0, 0.72549019607843135, 0.22352941176470589),
                (1.0, 0.72941176470588232, 0.23137254901960785),
                (1.0, 0.74117647058823533, 0.23921568627450981),
                (1.0, 0.74509803921568629, 0.24705882352941178),
                (1.0, 0.75294117647058822, 0.25490196078431371),
                (1.0, 0.76078431372549016, 0.2627450980392157),
                (1.0, 0.7686274509803922, 0.27058823529411763),
                (1.0, 0.77647058823529413, 0.27843137254901962),
                (1.0, 0.78431372549019607, 0.28235294117647058),
                (1.0, 0.792156862745098, 0.29411764705882354),
                (1.0, 0.80000000000000004, 0.29803921568627451),
                (1.0, 0.80784313725490198, 0.30980392156862746),
                (1.0, 0.81568627450980391, 0.31372549019607843),
                (1.0, 0.82352941176470584, 0.32549019607843138),
                (1.0, 0.83137254901960789, 0.32941176470588235),
                (1.0, 0.83921568627450982, 0.3411764705882353),
                (1.0, 0.84705882352941175, 0.34509803921568627),
                (1.0, 0.85490196078431369, 0.35686274509803922),
                (1.0, 0.86274509803921573, 0.36470588235294116),
                (1.0, 0.87058823529411766, 0.37254901960784315),
                (1.0, 0.8784313725490196, 0.38039215686274508),
                (1.0, 0.88627450980392153, 0.38823529411764707),
                (1.0, 0.89411764705882357, 0.396078431372549),
                (1.0, 0.90196078431372551, 0.40392156862745099),
                (1.0, 0.90980392156862744, 0.41176470588235292),
                (1.0, 0.91764705882352937, 0.41960784313725491),
                (1.0, 0.92549019607843142, 0.42745098039215684),
                (1.0, 0.93333333333333335, 0.43137254901960786),
                (1.0, 0.94117647058823528, 0.44313725490196076),
                (1.0, 0.94901960784313721, 0.44705882352941179),
                (1.0, 0.95686274509803926, 0.45882352941176469),
                (1.0, 0.96470588235294119, 0.46274509803921571),
                (1.0, 0.97254901960784312, 0.47450980392156861),
                (1.0, 0.98039215686274506, 0.47843137254901963),
                (1.0, 0.9882352941176471, 0.49019607843137253),
                (1.0, 0.99607843137254903, 0.49411764705882355),
                (1.0, 1.0, 0.50196078431372548),
                (1.0, 1.0, 0.50980392156862742),
                (1.0, 1.0, 0.51764705882352946),
                (1.0, 1.0, 0.52549019607843139),
                (1.0, 1.0, 0.53333333333333333),
                (1.0, 1.0, 0.54117647058823526),
                (1.0, 1.0, 0.5490196078431373),
                (1.0, 1.0, 0.55686274509803924),
                (1.0, 1.0, 0.56470588235294117),
                (1.0, 1.0, 0.5725490196078431),
                (1.0, 1.0, 0.58039215686274515),
                (1.0, 1.0, 0.58823529411764708),
                (1.0, 1.0, 0.59607843137254901),
                (1.0, 1.0, 0.60392156862745094),
                (1.0, 1.0, 0.61176470588235299),
                (1.0, 1.0, 0.61960784313725492),
                (1.0, 1.0, 0.62745098039215685),
                (1.0, 1.0, 0.63529411764705879),
                (1.0, 1.0, 0.64313725490196083),
                (1.0, 1.0, 0.65098039215686276),
                (1.0, 1.0, 0.6588235294117647),
                (1.0, 1.0, 0.66666666666666663),
                (1.0, 1.0, 0.67450980392156867),
                (1.0, 1.0, 0.68235294117647061),
                (1.0, 1.0, 0.69019607843137254),
                (1.0, 1.0, 0.69803921568627447),
                (1.0, 1.0, 0.70588235294117652),
                (1.0, 1.0, 0.71372549019607845),
                (1.0, 1.0, 0.72156862745098038),
                (1.0, 1.0, 0.72941176470588232),
                (1.0, 1.0, 0.73725490196078436),
                (1.0, 1.0, 0.74509803921568629),
                (1.0, 1.0, 0.75294117647058822),
                (1.0, 1.0, 0.76078431372549016),
                (1.0, 1.0, 0.7686274509803922),
                (1.0, 1.0, 0.77647058823529413),
                (1.0, 1.0, 0.78431372549019607),
                (1.0, 1.0, 0.792156862745098),
                (1.0, 1.0, 0.80000000000000004),
                (1.0, 1.0, 0.80784313725490198),
                (1.0, 1.0, 0.81568627450980391),
                (1.0, 1.0, 0.82352941176470584),
                (1.0, 1.0, 0.83137254901960789),
                (1.0, 1.0, 0.83921568627450982),
                (1.0, 1.0, 0.84705882352941175),
                (1.0, 1.0, 0.85490196078431369),
                (1.0, 1.0, 0.86274509803921573),
                (1.0, 1.0, 0.87058823529411766),
                (1.0, 1.0, 0.8784313725490196),
                (1.0, 1.0, 0.88627450980392153),
                (1.0, 1.0, 0.89411764705882357),
                (1.0, 1.0, 0.90196078431372551),
                (1.0, 1.0, 0.90980392156862744),
                (1.0, 1.0, 0.91764705882352937),
                (1.0, 1.0, 0.92549019607843142),
                (1.0, 1.0, 0.93333333333333335),
                (1.0, 1.0, 0.94117647058823528),
                (1.0, 1.0, 0.94901960784313721),
                (1.0, 1.0, 0.95686274509803926),
                (1.0, 1.0, 0.96470588235294119),
                (1.0, 1.0, 0.97254901960784312),
                (1.0, 1.0, 0.98039215686274506),
                (1.0, 1.0, 0.9882352941176471),
                )

cmap_ds9_cool = (
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0039215686274509803),
                (0.0, 0.0, 0.011764705882352941),
                (0.0, 0.0, 0.019607843137254902),
                (0.0, 0.0, 0.027450980392156862),
                (0.0, 0.0, 0.035294117647058823),
                (0.0, 0.0, 0.043137254901960784),
                (0.0, 0.0, 0.050980392156862744),
                (0.0, 0.0, 0.058823529411764705),
                (0.0, 0.0, 0.066666666666666666),
                (0.0, 0.0, 0.070588235294117646),
                (0.0, 0.0, 0.078431372549019607),
                (0.0, 0.0, 0.086274509803921567),
                (0.0, 0.0, 0.094117647058823528),
                (0.0, 0.0, 0.10196078431372549),
                (0.0, 0.0, 0.10980392156862745),
                (0.0, 0.0, 0.11764705882352941),
                (0.0, 0.0, 0.12549019607843137),
                (0.0, 0.0, 0.12941176470588237),
                (0.0, 0.0, 0.13725490196078433),
                (0.0, 0.0, 0.14509803921568629),
                (0.0, 0.0, 0.15294117647058825),
                (0.0, 0.0, 0.16078431372549021),
                (0.0, 0.0, 0.16470588235294117),
                (0.0, 0.0, 0.17647058823529413),
                (0.0, 0.0, 0.1803921568627451),
                (0.0, 0.0, 0.18823529411764706),
                (0.0, 0.0, 0.19607843137254902),
                (0.0, 0.0, 0.20392156862745098),
                (0.0, 0.0, 0.21176470588235294),
                (0.0, 0.0, 0.2196078431372549),
                (0.0, 0.0, 0.22745098039215686),
                (0.0, 0.0, 0.23529411764705882),
                (0.0, 0.0, 0.24313725490196078),
                (0.0, 0.0, 0.25098039215686274),
                (0.0, 0.0, 0.25490196078431371),
                (0.0, 0.0, 0.2627450980392157),
                (0.0, 0.0, 0.27058823529411763),
                (0.0, 0.0, 0.27843137254901962),
                (0.0, 0.0, 0.28627450980392155),
                (0.0, 0.0, 0.29019607843137257),
                (0.0, 0.0, 0.30196078431372547),
                (0.0, 0.0, 0.30588235294117649),
                (0.0, 0.0, 0.31372549019607843),
                (0.0, 0.0, 0.32156862745098042),
                (0.0, 0.0, 0.32941176470588235),
                (0.0, 0.0, 0.33725490196078434),
                (0.0, 0.0, 0.34509803921568627),
                (0.0, 0.0, 0.34901960784313724),
                (0.0, 0.0, 0.36078431372549019),
                (0.0, 0.0, 0.36470588235294116),
                (0.0, 0.0, 0.37254901960784315),
                (0.0, 0.0, 0.38039215686274508),
                (0.0, 0.0, 0.38823529411764707),
                (0.0, 0.0, 0.396078431372549),
                (0.0, 0.0, 0.40392156862745099),
                (0.0, 0.0, 0.41176470588235292),
                (0.0, 0.0, 0.41568627450980394),
                (0.0, 0.0078431372549019607, 0.42745098039215684),
                (0.0, 0.011764705882352941, 0.43137254901960786),
                (0.0, 0.015686274509803921, 0.4392156862745098),
                (0.0, 0.023529411764705882, 0.44705882352941179),
                (0.0, 0.027450980392156862, 0.45490196078431372),
                (0.0, 0.031372549019607843, 0.46274509803921571),
                (0.0, 0.039215686274509803, 0.47058823529411764),
                (0.0, 0.043137254901960784, 0.47450980392156861),
                (0.0, 0.050980392156862744, 0.48627450980392156),
                (0.0, 0.054901960784313725, 0.49019607843137253),
                (0.0, 0.058823529411764705, 0.49803921568627452),
                (0.0, 0.062745098039215685, 0.50588235294117645),
                (0.0, 0.070588235294117646, 0.51372549019607838),
                (0.0, 0.074509803921568626, 0.52156862745098043),
                (0.0, 0.082352941176470587, 0.52941176470588236),
                (0.0, 0.086274509803921567, 0.53333333333333333),
                (0.0, 0.090196078431372548, 0.54117647058823526),
                (0.0, 0.094117647058823528, 0.5490196078431373),
                (0.0, 0.10196078431372549, 0.55686274509803924),
                (0.0, 0.10588235294117647, 0.56470588235294117),
                (0.0, 0.11372549019607843, 0.5725490196078431),
                (0.0039215686274509803, 0.11764705882352941, 0.58039215686274515),
                (0.0039215686274509803, 0.12156862745098039, 0.58823529411764708),
                (0.0039215686274509803, 0.12941176470588237, 0.59607843137254901),
                (0.0039215686274509803, 0.13333333333333333, 0.59999999999999998),
                (0.0039215686274509803, 0.13725490196078433, 0.60784313725490191),
                (0.0078431372549019607, 0.14509803921568629, 0.61568627450980395),
                (0.0078431372549019607, 0.14901960784313725, 0.62352941176470589),
                (0.0078431372549019607, 0.15294117647058825, 0.63137254901960782),
                (0.0078431372549019607, 0.16078431372549021, 0.63921568627450975),
                (0.0078431372549019607, 0.16470588235294117, 0.6470588235294118),
                (0.011764705882352941, 0.16862745098039217, 0.65490196078431373),
                (0.011764705882352941, 0.17647058823529413, 0.6588235294117647),
                (0.011764705882352941, 0.1803921568627451, 0.6705882352941176),
                (0.011764705882352941, 0.18431372549019609, 0.67450980392156867),
                (0.011764705882352941, 0.19215686274509805, 0.68235294117647061),
                (0.015686274509803921, 0.19607843137254902, 0.69019607843137254),
                (0.015686274509803921, 0.20000000000000001, 0.69803921568627447),
                (0.015686274509803921, 0.20784313725490197, 0.70588235294117652),
                (0.015686274509803921, 0.21176470588235294, 0.70980392156862748),
                (0.019607843137254902, 0.21568627450980393, 0.71764705882352942),
                (0.019607843137254902, 0.22352941176470589, 0.72549019607843135),
                (0.019607843137254902, 0.22745098039215686, 0.73333333333333328),
                (0.019607843137254902, 0.23137254901960785, 0.74117647058823533),
                (0.019607843137254902, 0.23921568627450981, 0.74901960784313726),
                (0.023529411764705882, 0.24313725490196078, 0.75686274509803919),
                (0.023529411764705882, 0.25098039215686274, 0.76470588235294112),
                (0.023529411764705882, 0.25490196078431371, 0.77254901960784317),
                (0.023529411764705882, 0.25882352941176473, 0.7803921568627451),
                (0.023529411764705882, 0.26666666666666666, 0.78431372549019607),
                (0.027450980392156862, 0.27058823529411763, 0.792156862745098),
                (0.027450980392156862, 0.27450980392156865, 0.80000000000000004),
                (0.027450980392156862, 0.27843137254901962, 0.80784313725490198),
                (0.027450980392156862, 0.28627450980392155, 0.81568627450980391),
                (0.027450980392156862, 0.29019607843137257, 0.82352941176470584),
                (0.031372549019607843, 0.29803921568627451, 0.83137254901960789),
                (0.031372549019607843, 0.30196078431372547, 0.83529411764705885),
                (0.031372549019607843, 0.30588235294117649, 0.84313725490196079),
                (0.031372549019607843, 0.30980392156862746, 0.85098039215686272),
                (0.035294117647058823, 0.31764705882352939, 0.85882352941176465),
                (0.035294117647058823, 0.32156862745098042, 0.8666666666666667),
                (0.035294117647058823, 0.32941176470588235, 0.87450980392156863),
                (0.035294117647058823, 0.33333333333333331, 0.88235294117647056),
                (0.035294117647058823, 0.33725490196078434, 0.8901960784313725),
                (0.039215686274509803, 0.34509803921568627, 0.89411764705882357),
                (0.039215686274509803, 0.34901960784313724, 0.90196078431372551),
                (0.039215686274509803, 0.35294117647058826, 0.90980392156862744),
                (0.039215686274509803, 0.36078431372549019, 0.91764705882352937),
                (0.039215686274509803, 0.36470588235294116, 0.92549019607843142),
                (0.043137254901960784, 0.36862745098039218, 0.93333333333333335),
                (0.043137254901960784, 0.37647058823529411, 0.94117647058823528),
                (0.043137254901960784, 0.38039215686274508, 0.94509803921568625),
                (0.043137254901960784, 0.38823529411764707, 0.95686274509803926),
                (0.043137254901960784, 0.39215686274509803, 0.96078431372549022),
                (0.047058823529411764, 0.396078431372549, 0.96862745098039216),
                (0.047058823529411764, 0.40000000000000002, 0.97647058823529409),
                (0.047058823529411764, 0.40784313725490196, 0.98431372549019602),
                (0.047058823529411764, 0.41176470588235292, 0.99215686274509807),
                (0.050980392156862744, 0.41960784313725491, 1.0),
                (0.050980392156862744, 0.42352941176470588, 1.0),
                (0.050980392156862744, 0.42745098039215684, 1.0),
                (0.050980392156862744, 0.43137254901960786, 1.0),
                (0.050980392156862744, 0.4392156862745098, 1.0),
                (0.054901960784313725, 0.44313725490196076, 1.0),
                (0.054901960784313725, 0.45098039215686275, 1.0),
                (0.054901960784313725, 0.45490196078431372, 1.0),
                (0.054901960784313725, 0.45882352941176469, 1.0),
                (0.054901960784313725, 0.46666666666666667, 1.0),
                (0.058823529411764705, 0.47058823529411764, 1.0),
                (0.058823529411764705, 0.47450980392156861, 1.0),
                (0.058823529411764705, 0.4823529411764706, 1.0),
                (0.058823529411764705, 0.48627450980392156, 1.0),
                (0.062745098039215685, 0.49019607843137253, 1.0),
                (0.062745098039215685, 0.49803921568627452, 1.0),
                (0.062745098039215685, 0.50196078431372548, 1.0),
                (0.062745098039215685, 0.50588235294117645, 1.0),
                (0.062745098039215685, 0.51372549019607838, 1.0),
                (0.066666666666666666, 0.51764705882352946, 1.0),
                (0.066666666666666666, 0.52156862745098043, 1.0),
                (0.066666666666666666, 0.52941176470588236, 1.0),
                (0.066666666666666666, 0.53333333333333333, 1.0),
                (0.066666666666666666, 0.54117647058823526, 1.0),
                (0.070588235294117646, 0.54509803921568623, 1.0),
                (0.070588235294117646, 0.5490196078431373, 1.0),
                (0.070588235294117646, 0.55294117647058827, 1.0),
                (0.070588235294117646, 0.5607843137254902, 1.0),
                (0.070588235294117646, 0.56470588235294117, 1.0),
                (0.074509803921568626, 0.56862745098039214, 1.0),
                (0.074509803921568626, 0.57647058823529407, 1.0),
                (0.074509803921568626, 0.58039215686274515, 1.0),
                (0.074509803921568626, 0.58431372549019611, 1.0),
                (0.078431372549019607, 0.59215686274509804, 1.0),
                (0.078431372549019607, 0.59607843137254901, 1.0),
                (0.078431372549019607, 0.59999999999999998, 1.0),
                (0.078431372549019607, 0.60784313725490191, 1.0),
                (0.078431372549019607, 0.61176470588235299, 1.0),
                (0.082352941176470587, 0.61960784313725492, 1.0),
                (0.082352941176470587, 0.62352941176470589, 1.0),
                (0.082352941176470587, 0.62745098039215685, 1.0),
                (0.082352941176470587, 0.63529411764705879, 1.0),
                (0.082352941176470587, 0.63921568627450975, 1.0),
                (0.086274509803921567, 0.64313725490196083, 1.0),
                (0.086274509803921567, 0.65098039215686276, 1.0),
                (0.086274509803921567, 0.65490196078431373, 1.0),
                (0.086274509803921567, 0.66274509803921566, 1.0),
                (0.086274509803921567, 0.66666666666666663, 1.0),
                (0.090196078431372548, 0.6705882352941176, 1.0),
                (0.090196078431372548, 0.67450980392156867, 1.0),
                (0.090196078431372548, 0.68235294117647061, 1.0),
                (0.090196078431372548, 0.68627450980392157, 1.0),
                (0.094117647058823528, 0.69019607843137254, 1.0),
                (0.094117647058823528, 0.69803921568627447, 1.0),
                (0.094117647058823528, 0.70196078431372544, 1.0),
                (0.094117647058823528, 0.70588235294117652, 1.0),
                (0.094117647058823528, 0.71372549019607845, 1.0),
                (0.098039215686274508, 0.71764705882352942, 1.0),
                (0.098039215686274508, 0.72156862745098038, 1.0),
                (0.10196078431372549, 0.72941176470588232, 1.0),
                (0.11372549019607843, 0.73333333333333328, 1.0),
                (0.12941176470588237, 0.74117647058823533, 1.0),
                (0.14117647058823529, 0.74509803921568629, 1.0),
                (0.16078431372549021, 0.74901960784313726, 1.0),
                (0.17254901960784313, 0.75686274509803919, 1.0),
                (0.18823529411764706, 0.76078431372549016, 1.0),
                (0.20392156862745098, 0.76470588235294112, 1.0),
                (0.21568627450980393, 0.7686274509803922, 1.0),
                (0.23137254901960785, 0.77647058823529413, 1.0),
                (0.24705882352941178, 0.7803921568627451, 1.0),
                (0.2627450980392157, 0.78823529411764703, 1.0),
                (0.27450980392156865, 0.792156862745098, 1.0),
                (0.29019607843137257, 0.79607843137254897, 1.0),
                (0.30588235294117649, 0.80392156862745101, 1.0),
                (0.32156862745098042, 0.80784313725490198, 1.0),
                (0.33333333333333331, 0.81176470588235294, 1.0),
                (0.34901960784313724, 0.81960784313725488, 1.0),
                (0.36078431372549019, 0.82352941176470584, 1.0),
                (0.38039215686274508, 0.82745098039215681, 1.0),
                (0.39215686274509803, 0.83529411764705885, 1.0),
                (0.40784313725490196, 0.83921568627450982, 1.0),
                (0.41960784313725491, 0.84313725490196079, 1.0),
                (0.4392156862745098, 0.85098039215686272, 1.0),
                (0.45098039215686275, 0.85490196078431369, 1.0),
                (0.46274509803921571, 0.85882352941176465, 1.0),
                (0.47843137254901963, 0.8666666666666667, 1.0),
                (0.49411764705882355, 0.87058823529411766, 1.0),
                (0.50980392156862742, 0.87450980392156863, 1.0),
                (0.52549019607843139, 0.88235294117647056, 1.0),
                (0.54117647058823526, 0.88627450980392153, 1.0),
                (0.55294117647058827, 0.8901960784313725, 1.0),
                (0.56862745098039214, 0.89803921568627454, 1.0),
                (0.58431372549019611, 0.90196078431372551, 1.0),
                (0.59999999999999998, 0.90980392156862744, 1.0),
                (0.61176470588235299, 0.9137254901960784, 1.0),
                (0.62745098039215685, 0.91764705882352937, 1.0),
                (0.63921568627450975, 0.92156862745098034, 1.0),
                (0.6588235294117647, 0.92941176470588238, 1.0),
                (0.6705882352941176, 0.93333333333333335, 1.0),
                (0.68627450980392157, 0.94117647058823528, 1.0),
                (0.69803921568627447, 0.94509803921568625, 1.0),
                (0.71764705882352942, 0.94901960784313721, 1.0),
                (0.72941176470588232, 0.95686274509803926, 1.0),
                (0.74117647058823533, 0.96078431372549022, 1.0),
                (0.75686274509803919, 0.96470588235294119, 1.0),
                (0.77254901960784317, 0.96862745098039216, 1.0),
                (0.78823529411764703, 0.97647058823529409, 1.0),
                (0.80000000000000004, 0.98039215686274506, 1.0),
                (0.81568627450980391, 0.9882352941176471, 1.0),
                (0.83137254901960789, 0.99215686274509807, 1.0),
                (0.84705882352941175, 0.99607843137254903, 1.0),
                (0.85882352941176465, 1.0, 1.0),
                (0.87450980392156863, 1.0, 1.0),
                (0.8901960784313725, 1.0, 1.0),
                (0.90588235294117647, 1.0, 1.0),
                (0.91764705882352937, 1.0, 1.0),
                (0.93725490196078431, 1.0, 1.0),
                (0.94901960784313721, 1.0, 1.0),
                (0.96470588235294119, 1.0, 1.0),
                (0.97647058823529409, 1.0, 1.0),
)

cmap_ds9_he = (
                (0.015686274509803921, 0.0, 0.0039215686274509803),  # noqa
                (0.12941176470588237, 0.0, 0.031372549019607843),
                (0.25882352941176473, 0.0, 0.062745098039215685),
                (0.38823529411764707, 0.0, 0.094117647058823528),
                (0.49803921568627452, 0.0, 0.13333333333333333),
                (0.49803921568627452, 0.0, 0.20784313725490197),
                (0.49803921568627452, 0.0, 0.2627450980392157),
                (0.49803921568627452, 0.0, 0.33725490196078434),
                (0.49803921568627452, 0.0, 0.38039215686274508),
                (0.49803921568627452, 0.0, 0.41176470588235292),
                (0.49803921568627452, 0.0, 0.4392156862745098),
                (0.49803921568627452, 0.0, 0.47058823529411764),
                (0.49803921568627452, 0.0, 0.49411764705882355),
                (0.49803921568627452, 0.0, 0.52549019607843139),
                (0.49803921568627452, 0.0, 0.5490196078431373),
                (0.49803921568627452, 0.0, 0.58039215686274515),
                (0.49803921568627452, 0.0, 0.60392156862745094),
                (0.49803921568627452, 0.015686274509803921, 0.61960784313725492),
                (0.49803921568627452, 0.043137254901960784, 0.61176470588235299),
                (0.49803921568627452, 0.070588235294117646, 0.60392156862745094),
                (0.49803921568627452, 0.10588235294117647, 0.59607843137254901),
                (0.49803921568627452, 0.13725490196078433, 0.58823529411764708),
                (0.49803921568627452, 0.17254901960784313, 0.58039215686274515),
                (0.49803921568627452, 0.20000000000000001, 0.5725490196078431),
                (0.49803921568627452, 0.23921568627450981, 0.56470588235294117),
                (0.49803921568627452, 0.26666666666666666, 0.55686274509803924),
                (0.49803921568627452, 0.30196078431372547, 0.5490196078431373),
                (0.49803921568627452, 0.33333333333333331, 0.54117647058823526),
                (0.49803921568627452, 0.36862745098039218, 0.53333333333333333),
                (0.49803921568627452, 0.40000000000000002, 0.52549019607843139),
                (0.49803921568627452, 0.43529411764705883, 0.51764705882352946),
                (0.49803921568627452, 0.46666666666666667, 0.50980392156862742),
                (0.49803921568627452, 0.49803921568627452, 0.50196078431372548),
                (0.49803921568627452, 0.50588235294117645, 0.49411764705882355),
                (0.49803921568627452, 0.51372549019607838, 0.48627450980392156),
                (0.49803921568627452, 0.52156862745098043, 0.47843137254901963),
                (0.49803921568627452, 0.52941176470588236, 0.47058823529411764),
                (0.49803921568627452, 0.53725490196078429, 0.46274509803921571),
                (0.49803921568627452, 0.54509803921568623, 0.45490196078431372),
                (0.49803921568627452, 0.55294117647058827, 0.44705882352941179),
                (0.49803921568627452, 0.5607843137254902, 0.4392156862745098),
                (0.49803921568627452, 0.56862745098039214, 0.43137254901960786),
                (0.49803921568627452, 0.57647058823529407, 0.42352941176470588),
                (0.49803921568627452, 0.58431372549019611, 0.41568627450980394),
                (0.49803921568627452, 0.59215686274509804, 0.40784313725490196),
                (0.49803921568627452, 0.59999999999999998, 0.40000000000000002),
                (0.49803921568627452, 0.60784313725490191, 0.39215686274509803),
                (0.49803921568627452, 0.61568627450980395, 0.3843137254901961),
                (0.49803921568627452, 0.62352941176470589, 0.37647058823529411),
                (0.49803921568627452, 0.63137254901960782, 0.36862745098039218),
                (0.49803921568627452, 0.63921568627450975, 0.36078431372549019),
                (0.49803921568627452, 0.6470588235294118, 0.34901960784313724),
                (0.49803921568627452, 0.65490196078431373, 0.3411764705882353),
                (0.49803921568627452, 0.66274509803921566, 0.33333333333333331),
                (0.49803921568627452, 0.6705882352941176, 0.32549019607843138),
                (0.49803921568627452, 0.67843137254901964, 0.32156862745098042),
                (0.49803921568627452, 0.68627450980392157, 0.30980392156862746),
                (0.49803921568627452, 0.69411764705882351, 0.30588235294117649),
                (0.49803921568627452, 0.70196078431372544, 0.29411764705882354),
                (0.49803921568627452, 0.70980392156862748, 0.29019607843137257),
                (0.49803921568627452, 0.71764705882352942, 0.27843137254901962),
                (0.49803921568627452, 0.72549019607843135, 0.27450980392156865),
                (0.49803921568627452, 0.73333333333333328, 0.2627450980392157),
                (0.49803921568627452, 0.74117647058823533, 0.25882352941176473),
                (0.49803921568627452, 0.74901960784313726, 0.24705882352941178),
                (0.50196078431372548, 0.74901960784313726, 0.25098039215686274),
                (0.50588235294117645, 0.74901960784313726, 0.25490196078431371),
                (0.50980392156862742, 0.74901960784313726, 0.25882352941176473),
                (0.51372549019607838, 0.75294117647058822, 0.2627450980392157),
                (0.51764705882352946, 0.75294117647058822, 0.26666666666666666),
                (0.52156862745098043, 0.75294117647058822, 0.27058823529411763),
                (0.52549019607843139, 0.75294117647058822, 0.27450980392156865),
                (0.52941176470588236, 0.75686274509803919, 0.27843137254901962),
                (0.53333333333333333, 0.75686274509803919, 0.28235294117647058),
                (0.53725490196078429, 0.75686274509803919, 0.28627450980392155),
                (0.54117647058823526, 0.75686274509803919, 0.29019607843137257),
                (0.54509803921568623, 0.76078431372549016, 0.29411764705882354),
                (0.5490196078431373, 0.76078431372549016, 0.29803921568627451),
                (0.55294117647058827, 0.76078431372549016, 0.30196078431372547),
                (0.55686274509803924, 0.76078431372549016, 0.30588235294117649),
                (0.5607843137254902, 0.76470588235294112, 0.30980392156862746),
                (0.56470588235294117, 0.76470588235294112, 0.31372549019607843),
                (0.56862745098039214, 0.76470588235294112, 0.31764705882352939),
                (0.5725490196078431, 0.76470588235294112, 0.32156862745098042),
                (0.57647058823529407, 0.7686274509803922, 0.32549019607843138),
                (0.58039215686274515, 0.7686274509803922, 0.32941176470588235),
                (0.58431372549019611, 0.7686274509803922, 0.33333333333333331),
                (0.58823529411764708, 0.7686274509803922, 0.33725490196078434),
                (0.59215686274509804, 0.7686274509803922, 0.3411764705882353),
                (0.59607843137254901, 0.77254901960784317, 0.34509803921568627),
                (0.59999999999999998, 0.77254901960784317, 0.34901960784313724),
                (0.60392156862745094, 0.77254901960784317, 0.35294117647058826),
                (0.60784313725490191, 0.77254901960784317, 0.35686274509803922),
                (0.61176470588235299, 0.77647058823529413, 0.36078431372549019),
                (0.61568627450980395, 0.77647058823529413, 0.36470588235294116),
                (0.61960784313725492, 0.77647058823529413, 0.36862745098039218),
                (0.62352941176470589, 0.77647058823529413, 0.37254901960784315),
                (0.62745098039215685, 0.7803921568627451, 0.37647058823529411),
                (0.63137254901960782, 0.7803921568627451, 0.38039215686274508),
                (0.63529411764705879, 0.7803921568627451, 0.3843137254901961),
                (0.63921568627450975, 0.7803921568627451, 0.38823529411764707),
                (0.64313725490196083, 0.78431372549019607, 0.39215686274509803),
                (0.6470588235294118, 0.78431372549019607, 0.396078431372549),
                (0.65098039215686276, 0.78431372549019607, 0.40000000000000002),
                (0.65490196078431373, 0.78431372549019607, 0.40392156862745099),
                (0.6588235294117647, 0.78823529411764703, 0.40784313725490196),
                (0.66274509803921566, 0.78823529411764703, 0.41176470588235292),
                (0.66666666666666663, 0.78823529411764703, 0.41568627450980394),
                (0.6705882352941176, 0.78823529411764703, 0.41960784313725491),
                (0.67450980392156867, 0.78823529411764703, 0.42352941176470588),
                (0.67843137254901964, 0.792156862745098, 0.42745098039215684),
                (0.68235294117647061, 0.792156862745098, 0.43137254901960786),
                (0.68627450980392157, 0.792156862745098, 0.43529411764705883),
                (0.69019607843137254, 0.792156862745098, 0.4392156862745098),
                (0.69411764705882351, 0.79607843137254897, 0.44313725490196076),
                (0.69803921568627447, 0.79607843137254897, 0.44705882352941179),
                (0.70196078431372544, 0.79607843137254897, 0.45098039215686275),
                (0.70588235294117652, 0.79607843137254897, 0.45490196078431372),
                (0.70980392156862748, 0.80000000000000004, 0.45882352941176469),
                (0.71372549019607845, 0.80000000000000004, 0.46274509803921571),
                (0.71764705882352942, 0.80000000000000004, 0.46666666666666667),
                (0.72156862745098038, 0.80000000000000004, 0.47058823529411764),
                (0.72549019607843135, 0.80392156862745101, 0.47450980392156861),
                (0.72941176470588232, 0.80392156862745101, 0.47843137254901963),
                (0.73333333333333328, 0.80392156862745101, 0.4823529411764706),
                (0.73725490196078436, 0.80392156862745101, 0.48627450980392156),
                (0.74117647058823533, 0.80784313725490198, 0.49019607843137253),
                (0.74509803921568629, 0.80784313725490198, 0.49411764705882355),
                (0.74901960784313726, 0.80784313725490198, 0.49803921568627452),
                (0.74901960784313726, 0.80784313725490198, 0.50196078431372548),
                (0.75294117647058822, 0.81176470588235294, 0.50588235294117645),
                (0.75294117647058822, 0.81176470588235294, 0.50980392156862742),
                (0.75686274509803919, 0.81568627450980391, 0.51372549019607838),
                (0.75686274509803919, 0.81568627450980391, 0.51764705882352946),
                (0.76078431372549016, 0.81568627450980391, 0.52156862745098043),
                (0.76078431372549016, 0.81960784313725488, 0.52549019607843139),
                (0.76470588235294112, 0.81960784313725488, 0.52941176470588236),
                (0.76470588235294112, 0.81960784313725488, 0.53333333333333333),
                (0.7686274509803922, 0.82352941176470584, 0.53725490196078429),
                (0.7686274509803922, 0.82352941176470584, 0.54117647058823526),
                (0.77254901960784317, 0.82745098039215681, 0.54509803921568623),
                (0.77254901960784317, 0.82745098039215681, 0.5490196078431373),
                (0.77647058823529413, 0.82745098039215681, 0.55294117647058827),
                (0.77647058823529413, 0.83137254901960789, 0.55686274509803924),
                (0.7803921568627451, 0.83137254901960789, 0.5607843137254902),
                (0.7803921568627451, 0.83137254901960789, 0.56470588235294117),
                (0.78431372549019607, 0.83529411764705885, 0.56862745098039214),
                (0.78431372549019607, 0.83529411764705885, 0.5725490196078431),
                (0.78823529411764703, 0.83921568627450982, 0.57647058823529407),
                (0.78823529411764703, 0.83921568627450982, 0.58039215686274515),
                (0.792156862745098, 0.83921568627450982, 0.58431372549019611),
                (0.792156862745098, 0.84313725490196079, 0.58823529411764708),
                (0.79607843137254897, 0.84313725490196079, 0.59215686274509804),
                (0.79607843137254897, 0.84313725490196079, 0.59607843137254901),
                (0.80000000000000004, 0.84705882352941175, 0.59999999999999998),
                (0.80000000000000004, 0.84705882352941175, 0.60392156862745094),
                (0.80392156862745101, 0.85098039215686272, 0.60784313725490191),
                (0.80392156862745101, 0.85098039215686272, 0.61176470588235299),
                (0.80784313725490198, 0.85098039215686272, 0.61568627450980395),
                (0.80784313725490198, 0.85490196078431369, 0.61960784313725492),
                (0.81176470588235294, 0.85490196078431369, 0.62352941176470589),
                (0.81176470588235294, 0.85490196078431369, 0.62745098039215685),
                (0.81568627450980391, 0.85882352941176465, 0.63137254901960782),
                (0.81568627450980391, 0.85882352941176465, 0.63529411764705879),
                (0.81960784313725488, 0.86274509803921573, 0.63921568627450975),
                (0.81960784313725488, 0.86274509803921573, 0.63921568627450975),
                (0.82352941176470584, 0.86274509803921573, 0.6470588235294118),
                (0.82352941176470584, 0.8666666666666667, 0.6470588235294118),
                (0.82745098039215681, 0.8666666666666667, 0.65490196078431373),
                (0.82745098039215681, 0.8666666666666667, 0.65490196078431373),
                (0.83137254901960789, 0.87058823529411766, 0.66274509803921566),
                (0.83137254901960789, 0.87058823529411766, 0.66274509803921566),
                (0.83529411764705885, 0.87450980392156863, 0.6705882352941176),
                (0.83529411764705885, 0.87450980392156863, 0.6705882352941176),
                (0.83921568627450982, 0.87450980392156863, 0.67843137254901964),
                (0.83921568627450982, 0.8784313725490196, 0.68235294117647061),
                (0.84313725490196079, 0.8784313725490196, 0.68627450980392157),
                (0.84313725490196079, 0.88235294117647056, 0.69019607843137254),
                (0.84705882352941175, 0.88235294117647056, 0.69411764705882351),
                (0.84705882352941175, 0.88235294117647056, 0.69803921568627447),
                (0.85098039215686272, 0.88627450980392153, 0.70196078431372544),
                (0.85098039215686272, 0.88627450980392153, 0.70588235294117652),
                (0.85490196078431369, 0.88627450980392153, 0.70980392156862748),
                (0.85490196078431369, 0.8901960784313725, 0.71372549019607845),
                (0.85490196078431369, 0.8901960784313725, 0.71372549019607845),
                (0.85882352941176465, 0.89411764705882357, 0.72156862745098038),
                (0.85882352941176465, 0.89411764705882357, 0.72156862745098038),
                (0.86274509803921573, 0.89411764705882357, 0.72941176470588232),
                (0.86274509803921573, 0.89803921568627454, 0.72941176470588232),
                (0.8666666666666667, 0.89803921568627454, 0.73725490196078436),
                (0.8666666666666667, 0.89803921568627454, 0.73725490196078436),
                (0.87058823529411766, 0.90196078431372551, 0.74509803921568629),
                (0.87058823529411766, 0.90196078431372551, 0.74509803921568629),
                (0.87450980392156863, 0.90588235294117647, 0.74901960784313726),
                (0.87450980392156863, 0.90588235294117647, 0.75294117647058822),
                (0.8784313725490196, 0.90588235294117647, 0.75686274509803919),
                (0.8784313725490196, 0.90980392156862744, 0.76078431372549016),
                (0.88235294117647056, 0.90980392156862744, 0.76470588235294112),
                (0.88235294117647056, 0.90980392156862744, 0.7686274509803922),
                (0.88627450980392153, 0.9137254901960784, 0.77254901960784317),
                (0.88627450980392153, 0.9137254901960784, 0.77647058823529413),
                (0.8901960784313725, 0.91764705882352937, 0.7803921568627451),
                (0.8901960784313725, 0.91764705882352937, 0.78431372549019607),
                (0.89411764705882357, 0.91764705882352937, 0.78823529411764703),
                (0.89411764705882357, 0.92156862745098034, 0.792156862745098),
                (0.89803921568627454, 0.92156862745098034, 0.79607843137254897),
                (0.89803921568627454, 0.92156862745098034, 0.80000000000000004),
                (0.90196078431372551, 0.92549019607843142, 0.80392156862745101),
                (0.90196078431372551, 0.92549019607843142, 0.80784313725490198),
                (0.90588235294117647, 0.92941176470588238, 0.81176470588235294),
                (0.90588235294117647, 0.92941176470588238, 0.81568627450980391),
                (0.90980392156862744, 0.92941176470588238, 0.81960784313725488),
                (0.90980392156862744, 0.93333333333333335, 0.82352941176470584),
                (0.9137254901960784, 0.93333333333333335, 0.82745098039215681),
                (0.9137254901960784, 0.93725490196078431, 0.83137254901960789),
                (0.91764705882352937, 0.93725490196078431, 0.83529411764705885),
                (0.91764705882352937, 0.93725490196078431, 0.83921568627450982),
                (0.92156862745098034, 0.94117647058823528, 0.84313725490196079),
                (0.92156862745098034, 0.94117647058823528, 0.84705882352941175),
                (0.92549019607843142, 0.94117647058823528, 0.85098039215686272),
                (0.92549019607843142, 0.94509803921568625, 0.85490196078431369),
                (0.92941176470588238, 0.94509803921568625, 0.85882352941176465),
                (0.92941176470588238, 0.94509803921568625, 0.86274509803921573),
                (0.93333333333333335, 0.94901960784313721, 0.8666666666666667),
                (0.93333333333333335, 0.94901960784313721, 0.87058823529411766),
                (0.93725490196078431, 0.95294117647058818, 0.87450980392156863),
                (0.93725490196078431, 0.95294117647058818, 0.8784313725490196),
                (0.94117647058823528, 0.95294117647058818, 0.88235294117647056),
                (0.94117647058823528, 0.95686274509803926, 0.88627450980392153),
                (0.94509803921568625, 0.95686274509803926, 0.8901960784313725),
                (0.94509803921568625, 0.96078431372549022, 0.89411764705882357),
                (0.94901960784313721, 0.96078431372549022, 0.89803921568627454),
                (0.94901960784313721, 0.96078431372549022, 0.90196078431372551),
                (0.95294117647058818, 0.96470588235294119, 0.90588235294117647),
                (0.95294117647058818, 0.96470588235294119, 0.90980392156862744),
                (0.95686274509803926, 0.96470588235294119, 0.9137254901960784),
                (0.95686274509803926, 0.96862745098039216, 0.91764705882352937),
                (0.96078431372549022, 0.96862745098039216, 0.92156862745098034),
                (0.96078431372549022, 0.97254901960784312, 0.92549019607843142),
                (0.96470588235294119, 0.97254901960784312, 0.92941176470588238),
                (0.96470588235294119, 0.97254901960784312, 0.93333333333333335),
                (0.96862745098039216, 0.97647058823529409, 0.93725490196078431),
                (0.96862745098039216, 0.97647058823529409, 0.94117647058823528),
                (0.97254901960784312, 0.97647058823529409, 0.94509803921568625),
                (0.97254901960784312, 0.98039215686274506, 0.94901960784313721),
                (0.97647058823529409, 0.98039215686274506, 0.95294117647058818),
                (0.97647058823529409, 0.98431372549019602, 0.95686274509803926),
                (0.98039215686274506, 0.98431372549019602, 0.96078431372549022),
                (0.98039215686274506, 0.98431372549019602, 0.96470588235294119),
                (0.98431372549019602, 0.9882352941176471, 0.96862745098039216),
                (0.98431372549019602, 0.9882352941176471, 0.97254901960784312),
                (0.9882352941176471, 0.9882352941176471, 0.97647058823529409),
                (0.9882352941176471, 0.99215686274509807, 0.98039215686274506),
                (0.99215686274509807, 0.99215686274509807, 0.98431372549019602),
                (0.99215686274509807, 0.99607843137254903, 0.9882352941176471),
                (0.99607843137254903, 0.99607843137254903, 0.99215686274509807),
                )

cmap_ds9_i8 = (
                (0.0, 0.0, 0.0),  # noqa
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 1.0, 0.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 0.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (0.0, 1.0, 1.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 0.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 1.0, 0.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 0.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                )

#
# the "John Tonry" colormap used by ZView
#
cmap_jt = (
                (0.0, 0.0, 0.0),  # noqa
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.0, 0.0, 0.0),
                (0.65490196078431373, 0.0, 0.72156862745098038),
                (0.65490196078431373, 0.0, 0.72156862745098038),
                (0.65490196078431373, 0.0, 0.72156862745098038),
                (0.65490196078431373, 0.0, 0.72156862745098038),
                (0.59607843137254901, 0.0, 0.73725490196078436),
                (0.59607843137254901, 0.0, 0.73725490196078436),
                (0.59607843137254901, 0.0, 0.73725490196078436),
                (0.59607843137254901, 0.0, 0.73725490196078436),
                (0.52941176470588236, 0.0, 0.75686274509803919),
                (0.52941176470588236, 0.0, 0.75686274509803919),
                (0.52941176470588236, 0.0, 0.75686274509803919),
                (0.52941176470588236, 0.0, 0.75686274509803919),
                (0.45882352941176469, 0.0, 0.7803921568627451),
                (0.45882352941176469, 0.0, 0.7803921568627451),
                (0.45882352941176469, 0.0, 0.7803921568627451),
                (0.45882352941176469, 0.0, 0.7803921568627451),
                (0.36470588235294116, 0.0, 0.81568627450980391),
                (0.36470588235294116, 0.0, 0.81568627450980391),
                (0.36470588235294116, 0.0, 0.81568627450980391),
                (0.36470588235294116, 0.0, 0.81568627450980391),
                (0.22352941176470589, 0.0, 0.86274509803921573),
                (0.22352941176470589, 0.0, 0.86274509803921573),
                (0.22352941176470589, 0.0, 0.86274509803921573),
                (0.22352941176470589, 0.0, 0.86274509803921573),
                (0.039215686274509803, 0.0, 0.84313725490196079),
                (0.039215686274509803, 0.0, 0.84313725490196079),
                (0.039215686274509803, 0.0, 0.84313725490196079),
                (0.039215686274509803, 0.0, 0.84313725490196079),
                (0.035294117647058823, 0.066666666666666666, 0.792156862745098),
                (0.035294117647058823, 0.066666666666666666, 0.792156862745098),
                (0.035294117647058823, 0.066666666666666666, 0.792156862745098),
                (0.035294117647058823, 0.066666666666666666, 0.792156862745098),
                (0.031372549019607843, 0.2196078431372549, 0.77254901960784317),
                (0.031372549019607843, 0.2196078431372549, 0.77254901960784317),
                (0.031372549019607843, 0.2196078431372549, 0.77254901960784317),
                (0.031372549019607843, 0.2196078431372549, 0.77254901960784317),
                (0.031372549019607843, 0.30980392156862746, 0.77254901960784317),
                (0.031372549019607843, 0.30980392156862746, 0.77254901960784317),
                (0.031372549019607843, 0.30980392156862746, 0.77254901960784317),
                (0.031372549019607843, 0.30980392156862746, 0.77254901960784317),
                (0.031372549019607843, 0.3843137254901961, 0.77647058823529413),
                (0.031372549019607843, 0.3843137254901961, 0.77647058823529413),
                (0.031372549019607843, 0.3843137254901961, 0.77647058823529413),
                (0.031372549019607843, 0.3843137254901961, 0.77647058823529413),
                (0.027450980392156862, 0.45490196078431372, 0.78431372549019607),
                (0.027450980392156862, 0.45490196078431372, 0.78431372549019607),
                (0.027450980392156862, 0.45490196078431372, 0.78431372549019607),
                (0.027450980392156862, 0.45490196078431372, 0.78431372549019607),
                (0.027450980392156862, 0.52156862745098043, 0.79607843137254897),
                (0.027450980392156862, 0.52156862745098043, 0.79607843137254897),
                (0.027450980392156862, 0.52156862745098043, 0.79607843137254897),
                (0.027450980392156862, 0.52156862745098043, 0.79607843137254897),
                (0.023529411764705882, 0.58823529411764708, 0.80784313725490198),
                (0.023529411764705882, 0.58823529411764708, 0.80784313725490198),
                (0.023529411764705882, 0.58823529411764708, 0.80784313725490198),
                (0.023529411764705882, 0.58823529411764708, 0.80784313725490198),
                (0.023529411764705882, 0.65490196078431373, 0.82352941176470584),
                (0.023529411764705882, 0.65490196078431373, 0.82352941176470584),
                (0.023529411764705882, 0.65490196078431373, 0.82352941176470584),
                (0.023529411764705882, 0.65490196078431373, 0.82352941176470584),
                (0.019607843137254902, 0.72549019607843135, 0.83529411764705885),
                (0.019607843137254902, 0.72549019607843135, 0.83529411764705885),
                (0.019607843137254902, 0.72549019607843135, 0.83529411764705885),
                (0.019607843137254902, 0.72549019607843135, 0.83529411764705885),
                (0.011764705882352941, 0.72549019607843135, 0.76470588235294112),
                (0.011764705882352941, 0.72549019607843135, 0.76470588235294112),
                (0.011764705882352941, 0.72549019607843135, 0.76470588235294112),
                (0.011764705882352941, 0.72549019607843135, 0.76470588235294112),
                (0.0, 0.72549019607843135, 0.69019607843137254),
                (0.0, 0.72549019607843135, 0.69019607843137254),
                (0.0, 0.72549019607843135, 0.69019607843137254),
                (0.0, 0.72549019607843135, 0.69019607843137254),
                (0.0, 0.72549019607843135, 0.61176470588235299),
                (0.0, 0.72549019607843135, 0.61176470588235299),
                (0.0, 0.72549019607843135, 0.61176470588235299),
                (0.0, 0.72549019607843135, 0.61176470588235299),
                (0.0, 0.72156862745098038, 0.53333333333333333),
                (0.0, 0.72156862745098038, 0.53333333333333333),
                (0.0, 0.72156862745098038, 0.53333333333333333),
                (0.0, 0.72156862745098038, 0.53333333333333333),
                (0.0, 0.71764705882352942, 0.45098039215686275),
                (0.0, 0.71764705882352942, 0.45098039215686275),
                (0.0, 0.71764705882352942, 0.45098039215686275),
                (0.0, 0.71764705882352942, 0.45098039215686275),
                (0.0, 0.71372549019607845, 0.36078431372549019),
                (0.0, 0.71372549019607845, 0.36078431372549019),
                (0.0, 0.71372549019607845, 0.36078431372549019),
                (0.0, 0.71372549019607845, 0.36078431372549019),
                (0.0, 0.70980392156862748, 0.25098039215686274),
                (0.0, 0.70980392156862748, 0.25098039215686274),
                (0.0, 0.70980392156862748, 0.25098039215686274),
                (0.0, 0.70980392156862748, 0.25098039215686274),
                (0.0, 0.70588235294117652, 0.043137254901960784),
                (0.0, 0.70588235294117652, 0.043137254901960784),
                (0.0, 0.70588235294117652, 0.043137254901960784),
                (0.0, 0.70588235294117652, 0.043137254901960784),
                (0.27450980392156865, 0.71372549019607845, 0.0),
                (0.27450980392156865, 0.71372549019607845, 0.0),
                (0.27450980392156865, 0.71372549019607845, 0.0),
                (0.27450980392156865, 0.71372549019607845, 0.0),
                (0.40392156862745099, 0.72156862745098038, 0.0),
                (0.40392156862745099, 0.72156862745098038, 0.0),
                (0.40392156862745099, 0.72156862745098038, 0.0),
                (0.40392156862745099, 0.72156862745098038, 0.0),
                (0.50980392156862742, 0.72941176470588232, 0.0),
                (0.50980392156862742, 0.72941176470588232, 0.0),
                (0.50980392156862742, 0.72941176470588232, 0.0),
                (0.50980392156862742, 0.72941176470588232, 0.0),
                (0.60392156862745094, 0.73725490196078436, 0.0),
                (0.60392156862745094, 0.73725490196078436, 0.0),
                (0.60392156862745094, 0.73725490196078436, 0.0),
                (0.60392156862745094, 0.73725490196078436, 0.0),
                (0.69019607843137254, 0.74509803921568629, 0.0),
                (0.69019607843137254, 0.74509803921568629, 0.0),
                (0.69019607843137254, 0.74509803921568629, 0.0),
                (0.69019607843137254, 0.74509803921568629, 0.0),
                (0.7686274509803922, 0.75294117647058822, 0.0),
                (0.7686274509803922, 0.75294117647058822, 0.0),
                (0.7686274509803922, 0.75294117647058822, 0.0),
                (0.7686274509803922, 0.75294117647058822, 0.0),
                (0.84705882352941175, 0.76078431372549016, 0.0),
                (0.84705882352941175, 0.76078431372549016, 0.0),
                (0.84705882352941175, 0.76078431372549016, 0.0),
                (0.84705882352941175, 0.76078431372549016, 0.0),
                (0.92156862745098034, 0.7686274509803922, 0.0),
                (0.92156862745098034, 0.7686274509803922, 0.0),
                (0.92156862745098034, 0.7686274509803922, 0.0),
                (0.92156862745098034, 0.7686274509803922, 0.0),
                (0.96078431372549022, 0.74509803921568629, 0.0),
                (0.96078431372549022, 0.74509803921568629, 0.0),
                (0.96078431372549022, 0.74509803921568629, 0.0),
                (0.96078431372549022, 0.74509803921568629, 0.0),
                (0.97647058823529409, 0.70196078431372544, 0.0),
                (0.97647058823529409, 0.70196078431372544, 0.0),
                (0.97647058823529409, 0.70196078431372544, 0.0),
                (0.97647058823529409, 0.70196078431372544, 0.0),
                (0.99215686274509807, 0.6588235294117647, 0.0),
                (0.99215686274509807, 0.6588235294117647, 0.0),
                (0.99215686274509807, 0.6588235294117647, 0.0),
                (0.99215686274509807, 0.6588235294117647, 0.0),
                (1.0, 0.61568627450980395, 0.0),
                (1.0, 0.61568627450980395, 0.0),
                (1.0, 0.61568627450980395, 0.0),
                (1.0, 0.61568627450980395, 0.0),
                (1.0, 0.5725490196078431, 0.0),
                (1.0, 0.5725490196078431, 0.0),
                (1.0, 0.5725490196078431, 0.0),
                (1.0, 0.5725490196078431, 0.0),
                (1.0, 0.52941176470588236, 0.0),
                (1.0, 0.52941176470588236, 0.0),
                (1.0, 0.52941176470588236, 0.0),
                (1.0, 0.52941176470588236, 0.0),
                (1.0, 0.48627450980392156, 0.0),
                (1.0, 0.48627450980392156, 0.0),
                (1.0, 0.48627450980392156, 0.0),
                (1.0, 0.48627450980392156, 0.0),
                (1.0, 0.44313725490196076, 0.0),
                (1.0, 0.44313725490196076, 0.0),
                (1.0, 0.44313725490196076, 0.0),
                (1.0, 0.44313725490196076, 0.0),
                (1.0, 0.396078431372549, 0.0),
                (1.0, 0.396078431372549, 0.0),
                (1.0, 0.396078431372549, 0.0),
                (1.0, 0.396078431372549, 0.0),
                (1.0, 0.35294117647058826, 0.0),
                (1.0, 0.35294117647058826, 0.0),
                (1.0, 0.35294117647058826, 0.0),
                (1.0, 0.35294117647058826, 0.0),
                (1.0, 0.30196078431372547, 0.0),
                (1.0, 0.30196078431372547, 0.0),
                (1.0, 0.30196078431372547, 0.0),
                (1.0, 0.30196078431372547, 0.0),
                (1.0, 0.24705882352941178, 0.0),
                (1.0, 0.24705882352941178, 0.0),
                (1.0, 0.24705882352941178, 0.0),
                (1.0, 0.24705882352941178, 0.0),
                (1.0, 0.18823529411764706, 0.0),
                (1.0, 0.18823529411764706, 0.0),
                (1.0, 0.18823529411764706, 0.0),
                (1.0, 0.18823529411764706, 0.0),
                (1.0, 0.10588235294117647, 0.0),
                (1.0, 0.10588235294117647, 0.0),
                (1.0, 0.10588235294117647, 0.0),
                (1.0, 0.10588235294117647, 0.0),
                (1.0, 0.078431372549019607, 0.070588235294117646),
                (1.0, 0.078431372549019607, 0.070588235294117646),
                (1.0, 0.078431372549019607, 0.070588235294117646),
                (1.0, 0.078431372549019607, 0.070588235294117646),
                (1.0, 0.16078431372549021, 0.16078431372549021),
                (1.0, 0.16078431372549021, 0.16078431372549021),
                (1.0, 0.16078431372549021, 0.16078431372549021),
                (1.0, 0.16078431372549021, 0.16078431372549021),
                (1.0, 0.2196078431372549, 0.22745098039215686),
                (1.0, 0.2196078431372549, 0.22745098039215686),
                (1.0, 0.2196078431372549, 0.22745098039215686),
                (1.0, 0.2196078431372549, 0.22745098039215686),
                (1.0, 0.27058823529411763, 0.28235294117647058),
                (1.0, 0.27058823529411763, 0.28235294117647058),
                (1.0, 0.27058823529411763, 0.28235294117647058),
                (1.0, 0.27058823529411763, 0.28235294117647058),
                (1.0, 0.32156862745098042, 0.33333333333333331),
                (1.0, 0.32156862745098042, 0.33333333333333331),
                (1.0, 0.32156862745098042, 0.33333333333333331),
                (1.0, 0.32156862745098042, 0.33333333333333331),
                (1.0, 0.36862745098039218, 0.3843137254901961),
                (1.0, 0.36862745098039218, 0.3843137254901961),
                (1.0, 0.36862745098039218, 0.3843137254901961),
                (1.0, 0.36862745098039218, 0.3843137254901961),
                (1.0, 0.41568627450980394, 0.43529411764705883),
                (1.0, 0.41568627450980394, 0.43529411764705883),
                (1.0, 0.41568627450980394, 0.43529411764705883),
                (1.0, 0.41568627450980394, 0.43529411764705883),
                (1.0, 0.46274509803921571, 0.48627450980392156),
                (1.0, 0.46274509803921571, 0.48627450980392156),
                (1.0, 0.46274509803921571, 0.48627450980392156),
                (1.0, 0.46274509803921571, 0.48627450980392156),
                (1.0, 0.50980392156862742, 0.53333333333333333),
                (1.0, 0.50980392156862742, 0.53333333333333333),
                (1.0, 0.50980392156862742, 0.53333333333333333),
                (1.0, 0.50980392156862742, 0.53333333333333333),
                (1.0, 0.55686274509803924, 0.58431372549019611),
                (1.0, 0.55686274509803924, 0.58431372549019611),
                (1.0, 0.55686274509803924, 0.58431372549019611),
                (1.0, 0.55686274509803924, 0.58431372549019611),
                (1.0, 0.60392156862745094, 0.63529411764705879),
                (1.0, 0.60392156862745094, 0.63529411764705879),
                (1.0, 0.60392156862745094, 0.63529411764705879),
                (1.0, 0.60392156862745094, 0.63529411764705879),
                (1.0, 0.65098039215686276, 0.68627450980392157),
                (1.0, 0.65098039215686276, 0.68627450980392157),
                (1.0, 0.65098039215686276, 0.68627450980392157),
                (1.0, 0.65098039215686276, 0.68627450980392157),
                (1.0, 0.69803921568627447, 0.73725490196078436),
                (1.0, 0.69803921568627447, 0.73725490196078436),
                (1.0, 0.69803921568627447, 0.73725490196078436),
                (1.0, 0.69803921568627447, 0.73725490196078436),
                (1.0, 0.74901960784313726, 0.78823529411764703),
                (1.0, 0.74901960784313726, 0.78823529411764703),
                (1.0, 0.74901960784313726, 0.78823529411764703),
                (1.0, 0.74901960784313726, 0.78823529411764703),
                (1.0, 0.79607843137254897, 0.83921568627450982),
                (1.0, 0.79607843137254897, 0.83921568627450982),
                (1.0, 0.79607843137254897, 0.83921568627450982),
                (1.0, 0.79607843137254897, 0.83921568627450982),
                (1.0, 0.84705882352941175, 0.8901960784313725),
                (1.0, 0.84705882352941175, 0.8901960784313725),
                (1.0, 0.84705882352941175, 0.8901960784313725),
                (1.0, 0.84705882352941175, 0.8901960784313725),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                (1.0, 1.0, 1.0),
                )


# to be eventually deprecated
cmap_ramp = cmap_gray

# needed length of a ginga color map
min_cmap_len = 256


class ColorMapError(Exception):
    pass


class ColorMap(object):
    """Class to handle color maps."""
    def __init__(self, name, clst):
        self.name = name
        self.clst = clst


def add_cmap(name, clst):
    """Add a color map."""
    global cmaps
    assert len(clst) == min_cmap_len, \
        ValueError("color map '%s' length mismatch %d != %d (needed)" % (
            name, len(clst), min_cmap_len))
    cmaps[name] = ColorMap(name, clst)


def get_cmap(name):
    """Get a color map array.
    Will raise a KeyError if a map of the given name does not exist.
    """
    return cmaps[name]


def has_cmap(name):
    """Does color map exist? Return True/False
    """
    return name in cmaps


def get_names():
    """Get colormap names."""
    res = list(cmaps.keys())
    res = sorted(res, key=lambda s: s.lower())
    return res


def matplotlib_to_ginga_cmap(cm, name=None):
    """Convert matplotlib colormap to Ginga's."""
    if name is None:
        name = cm.name
    arr = cm(np.arange(0, min_cmap_len) / np.float(min_cmap_len - 1))
    clst = arr[:, 0:3]
    return ColorMap(name, clst)


def ginga_to_matplotlib_cmap(cm, name=None):
    """Convert Ginga colormap to matplotlib's."""
    if name is None:
        name = cm.name
    from matplotlib.colors import ListedColormap
    carr = np.asarray(cm.clst)
    mpl_cm = ListedColormap(carr, name=name, N=len(carr))
    return mpl_cm


def add_matplotlib_cmap(cm, name=None):
    """Add a matplotlib colormap."""
    global cmaps
    cmap = matplotlib_to_ginga_cmap(cm, name=name)
    cmaps[cmap.name] = cmap


def add_matplotlib_cmaps(fail_on_import_error=True):
    """Add all matplotlib colormaps."""
    try:
        from matplotlib import cm as _cm
        from matplotlib.cbook import mplDeprecation
    except ImportError:
        if fail_on_import_error:
            raise
        # silently fail
        return

    for name in _cm.cmap_d:
        if not isinstance(name, six.string_types):
            continue
        try:
            # Do not load deprecated colormaps
            with warnings.catch_warnings():
                warnings.simplefilter('error', mplDeprecation)
                cm = _cm.get_cmap(name)
                add_matplotlib_cmap(cm, name=name)
        except Exception as e:
            if fail_on_import_error:
                print("Error adding colormap '%s': %s" % (name, str(e)))


# Add colormaps from this file
cmaps = {}
for name, value in list(globals().items()):
    if name.startswith('cmap_'):
        key = name[5:]
        add_cmap(key, value)

# by default add matplotlib colormaps, if available
add_matplotlib_cmaps(fail_on_import_error=False)

# END
