!* Copyright (c) 2018, NVIDIA CORPORATION.  All rights reserved.
!*
!* Licensed under the Apache License, Version 2.0 (the "License");
!* you may not use this file except in compliance with the License.
!* You may obtain a copy of the License at
!*
!*     http://www.apache.org/licenses/LICENSE-2.0
!*
!* Unless required by applicable law or agreed to in writing, software
!* distributed under the License is distributed on an "AS IS" BASIS,
!* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!* See the License for the specific language governing permissions and
!* limitations under the License.

subroutine slave_bar_checkin(pbar, nthreads)
    INTEGER, INTENT(INOUT) :: pbar
    INTEGER, INTENT(IN) :: nthreads
    INTEGER :: bar
    !$omp atomic
    pbar = pbar + 1
    !$omp end atomic
    DO
        !$omp atomic read
        bar = pbar
        !$omp end atomic
        IF (bar .ge. nthreads) then
          EXIT
        end if
    ENDDO
end subroutine

integer pbar
pbar=0

!$omp parallel
call slave_bar_checkin(pbar,4)
!$omp end parallel

print *, "PASS"
end

