/*
 * $Id: sig_cardbus.c,v 1.20 2012-07-05 21:09:30 potyra Exp $ 
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sig_cardbus.h"

struct sig_cardbus *
sig_cardbus_create(const char *name)
{
	char n[1000];
	struct sig_cardbus *c;

	c = shm_alloc(sizeof(*c));
	assert(c);

	sprintf(n, "%s-conn", name);
	c->conn = sig_boolean_create(n);
	sprintf(n, "%s-+5V", name);
	c->p5V = sig_boolean_create(n);
	sprintf(n, "%s-n_reset", name);
	c->n_reset = sig_boolean_create(n);
	sprintf(n, "%s-bus", name);
	c->bus = sig_pci_bus_main_create(n);
	sprintf(n, "%s-irq", name);
	c->irq = sig_boolean_or_create(n);

	return c;
}

void
sig_cardbus_destroy(struct sig_cardbus *sig)
{
	assert(sig);
	/* assert(sig->type == SIG_GEN_CARDBUS); */

	sig_boolean_destroy(sig->conn);
	sig_boolean_destroy(sig->p5V);
	sig_boolean_destroy(sig->n_reset);
	sig_pci_bus_main_destroy(sig->bus);
	sig_boolean_or_destroy(sig->irq);

	shm_free(sig);
}

void
sig_cardbus_suspend(struct sig_cardbus *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
	
	sig_boolean_suspend(b->conn, fSig);
	sig_boolean_suspend(b->p5V, fSig);
	sig_boolean_suspend(b->n_reset, fSig);	
	sig_pci_bus_main_suspend(b->bus, fSig);
	sig_boolean_or_suspend(b->irq, fSig);
}

void
sig_cardbus_resume(struct sig_cardbus *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
	
	sig_boolean_resume(b->conn, fSig);
	sig_boolean_resume(b->p5V, fSig);
	sig_boolean_resume(b->n_reset, fSig);	
	sig_pci_bus_main_resume(b->bus, fSig);
	sig_boolean_or_resume(b->irq, fSig);
}
