#!/bin/sh

set -e

#initial delay (ms) before faults get injected.
if [ -z $1 ]; then
	INITIAL_DELAY=1000
else
	INITIAL_DELAY=$1
fi

# source file
SOURCE_VHDL=fi.vhdl.in
# target
TARGET_VHDL=fi.vhdl

# determine what disk should be errorenous
if [ -z $3 ]; then
	FAULTY_DISK="hdb"
else
	FAULTY_DISK=$3
fi 

case $2 in 
	golden)
		FAULT_ACTIVATE_SNIPPET=""
		echo "Golden run (no faults) selected."
	;;
	disk-fault)
		X1="shortcut_int_out(err,"
		X2="\":pc:${FAULTY_DISK}\", \"disk_fault\");@NEWLINE@"

		FAULT_ACTIVATE_SNIPPET="${X1}${X2}"
		echo "Disk fault for ${FAULTY_DISK} after ${INITIAL_DELAY}" \
		     "ms selected."
	;;
	block-fault)
		FAULT_ACTIVATE_SNIPPET=""
		
		# cut range into pieces
		START=$(echo $4 | cut -f1 -d-)
		END=$(echo $4 | cut -f2 -d-)

		# loop counter
		I=${START}
		while [ $I -le $END ]; do
			# add a shortcut for every faulty block
			X1="shortcut_int_out(err,"
			X2="\":pc:${FAULTY_DISK}\", "
			X3="\"block_fault\/${I}\");"
				
			FAULT_ACTIVATE_SNIPPET="${FAULT_ACTIVATE_SNIPPET} \
					       @NEWLINE@${X1}${X2}${X3}"

			# increment loop counter
			I=$(expr ${I} + 1)
		done

		# print some information
		echo -n "Block fault for ${FAULTY_DISK} after "
		echo -n "${INITIAL_DELAY} ms on blocks "
		echo "on blocks ${START} to ${END} selected."
	;;
	*)
		echo "Invalid argument."
		echo "Usage: $0 DELAY [golden|disk-fault hdb|block-fault hdd" \
			"23-42]"
		exit 1
	;;
esac

sed -e"s/@FAULT_INITIAL_DELAY@/${INITIAL_DELAY}/" \
    -e"s/@FAULT_CONNECT@/${FAULT_ACTIVATE_SNIPPET}/" \
    -e"s/@NEWLINE@/\n/g" \
    ${SOURCE_VHDL} > ${TARGET_VHDL}
