/* $Id: declaration.c,v 1.183 2012/02/23 15:45:12 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUcc Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "setup.h"
#include "identifier.h"
#include "declaration.h"
#include "expr.h"
#include "stmt.h"
#include "cc1.h"


void
declaration_rename_structunionenum(
	struct declaration *dion,
	enum type_type type,
	const char *old,
	const char *new
)
{
	struct expr *initializer;

	type_rename_structunionenum(dion->type_name, type, old, new);

	initializer = declaration_initializer_get(dion);
	if (initializer) {
		expr_rename_structunionenum(initializer, type, old, new);
	}
}

void
declaration_rename_type(
	struct declaration *dion,
	const char *old,
	const char *new
)
{
	type_rename_type(dion->type_name, old, new);
}

struct declaration *
declaration_new(void)
{
	struct declaration *d;

	d = malloc(sizeof(*d));
	assert(d);

	memset(d, 0, sizeof(*d));

	return d;
}

void
declaration_name_set(struct declaration *d, const char *name)
{
	d->identifier = name;
}

const char *
declaration_name_get(struct declaration *d)
{
	return d->identifier;
}

void
declaration_type_get(struct type **adp, struct declaration *dor)
{
	*adp = dor->type_name;
}

void
declaration_initializer_set(struct declaration *dor, struct expr *initializer)
{
	dor->initializer = initializer;
}

struct expr *
declaration_initializer_get(struct declaration *dor)
{
	return dor->initializer;
}

struct declaration *
declaration_identifier(const char *name)
{
	struct declaration *dor;

	dor = malloc(sizeof(*dor));
	assert(dor);

	memset(dor, 0, sizeof(*dor));

	dor->identifier = name;
	dor->type_name = type_type_spec();

	return dor;
}

void
declaration_free(struct declaration *dor)
{
}
