#!/bin/sh -x

# exportsymbols.sh
# ----------------
#
# Export kdbBackendFactory entry point symbols
# for each compiled backend
#
# (c) 2006 Yannick Lecaillez

func=kdbBackendFactory
toolsfuncs='ksFromXMLfile ksFromXML ksToStream ksOutput ksGenerate keyToStream keyOutput keyGenerate'

echo '/* exported_symbols.h generated by exportsymbols.sh */

#include <kdbloader.h>

' > exported_symbols.h

for lib in "$@"
do
	if test $lib = libelektratools; then
		for toolsfunc in $toolsfuncs; do
			symbol=${lib}_LTX_${toolsfunc}
			echo "extern void $symbol (void);" >> exported_symbols.h
		done
	else
		symbol=libelektra_${lib}_LTX_${func}
		echo "extern void $symbol (void);" >> exported_symbols.h
	fi
done

echo '/* exported_symbols.c generated by exportsymbols.sh */

#include <exported_symbols.h>

kdblib_symbol kdb_exported_syms[] =
{
' > exported_symbols.c

lib="$1"
echo "Exporting symbols for default ..."
fname="libelektra-default"
symbol=libelektra_${lib}_LTX_${func}
echo "	{\"$fname\", 0 }," >> exported_symbols.c
echo "	{\"$func\", &$symbol }," >> exported_symbols.c
echo "" >> exported_symbols.c
shift

for lib in "$@"
do
	if test $lib = libelektratools; then
		fname=libelektratools
		echo "	{\"$fname\", 0 }," >> exported_symbols.c
		for toolsfunc in $toolsfuncs; do
			symbol=${fname}_LTX_${toolsfunc}
			echo "	{\"$toolsfunc\", &$symbol }," >> exported_symbols.c
		done
	else
		echo "Exporting symbols for $lib ..."
		fname="libelektra-${lib}"
		symbol=libelektra_${lib}_LTX_${func}
		echo "	{\"$fname\", 0 }," >> exported_symbols.c
		echo "	{\"$func\", &$symbol }," >> exported_symbols.c
	fi
	echo "" >> exported_symbols.c
done
echo "	{ 0 , 0 }" >> exported_symbols.c
echo "};" >> exported_symbols.c
