#ifndef __blockallocator_h__
#define __blockallocator_h__

#include <vector>
#include <iostream>

using namespace std;

typedef unsigned char byte;

//! Custom memory allocator for single items
template <class T, size_t blocksPerBatch=100, size_t blockAlignment=4>
class BlockAllocator
{
public:
    void* operator new(size_t)
    {
        //cerr << "blocknew\n";
		return s_Store.AllocateBlock();
    }

    void operator delete(void* pBlock)
    {
		//cerr << "blockdelete" << endl;
        s_Store.ReleaseBlock((T*)pBlock);
    }

    static T*	AllocateBlock()
    {
        return s_Store.AllocateBlock();
    }
    static void	ReleaseBlock(T* pBlock)
    {
        s_Store.ReleaseBlock(pBlock);
    }

private:

    struct BlockStore
    {
        BlockStore() : ppNextBlock(0)
        {}
        ;
        ~BlockStore()
        {
            size_t iNum = batches.size();
            for (size_t i=0; i<iNum; ++i)
            {
                byte* p = (byte*)batches[i];
                delete [] p;
            }
        }

        T* AllocateBlock()
        {
            if (!ppNextBlock || !*ppNextBlock)
            {
                // determine the allligned size of the blocks
                static const size_t blockSize = (sizeof(T)+blockAlignment-1)&(~(blockAlignment-1));

                // make a new batch
                byte *pNewBatch = new byte[blocksPerBatch*blockSize+15];
                batches.push_back(pNewBatch);

                //* Align the block on a 16-byte boundary
                byte* pAlignedPtr =(byte*)((uintptr_t)(pNewBatch+15)&(~15));

                // fill the pointers with the new blocks
                ppNextBlock = (byte**)pAlignedPtr;
                for (int i=0; i<blocksPerBatch-1; ++i)
                {
                    *((uintptr_t*)(pAlignedPtr + i*blockSize)) = (uintptr_t)(pAlignedPtr + (i+1)*blockSize);
                }
                *((uintptr_t*)(pAlignedPtr + (blocksPerBatch-1)*blockSize)) = (uintptr_t)0;
            }

            byte* pBlock = (byte*)ppNextBlock;
            ppNextBlock = (byte**)*ppNextBlock;
            return (T*)pBlock;
        }

        void ReleaseBlock(T* pBlock)
        {
            if(pBlock)
            {
                *((uintptr_t*)pBlock) = (uintptr_t)ppNextBlock;
                ppNextBlock = (byte**)((byte*)pBlock);
            }
        }

        typedef vector<byte*> BatchPtrVector;

        byte**			ppNextBlock;		// Pointer to the next available block pointer
        BatchPtrVector	batches;			// Array of pointers to batches
    };
	

    static BlockStore s_Store;
};

#endif

