#include "Selecter.h"
#include <iostream>
#include <signal.h>
#include <sys/poll.h>

using namespace std;

pthread_t Selecter::thread;
pthread_mutex_t Selecter::lock;
bool Selecter::exitPlease, Selecter::running;

void *Selecter::threadFunc(void *arg) {
	
	cerr << "threadFunc start" << endl;

	ServerSocket *socket = (ServerSocket *)arg;
	struct pollfd pollData;
	int retVal;
	const int TIMEOUT = 1000;

	pthread_mutex_lock(&lock);
	running = true;
	pthread_mutex_unlock(&lock);
	
	pollData.fd = socket->getSocket();
	pollData.events = (POLLIN | POLLPRI);
	pollData.revents = 0;
	while ((retVal = poll(&pollData, 1, TIMEOUT)) != -1) {
		
		if (exitPlease) {
			cerr << "threadFunc exitPlease" << endl;
			running = false;
			pthread_exit(0);
		}
		
		//0 = timeout
		if (retVal == 0) {
			// wtf
		} else {
			cerr << "threadFunc incoming" << endl;
			socket->incoming();
		}
	}

	cerr << "retval: " << retVal << endl;
	if(retVal==-1) perror("threadfunc");

	pthread_mutex_lock(&lock);
	running = false;
	pthread_mutex_unlock(&lock);
	pthread_exit(0);
}

void Selecter::doit(ServerSocket &socket) {
	exitPlease = false;
	running = false;
	pthread_mutex_init(&lock, NULL);
	pthread_create(&thread, NULL, &threadFunc, (void *)&socket);
}

void Selecter::quit() {
	cout << "Selecter::quit()" << endl;
	pthread_mutex_lock(&lock);
	if (!running) {
		pthread_mutex_unlock(&lock);
		return;
	}
	cout << "Selecter set quit" << endl;
	exitPlease = true;
	pthread_mutex_unlock(&lock);
}

