#!/usr/bin/env python

#  Copyright (C) 2008-2010 by Canonical Ltd
#  Copyright (C) 2012 Koichi Akabe <vbkaisetsu@gmail.com>
# 
#  gLogic is free software: you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
# 
#  gLogic is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#  See the GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License along
#  with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from info import *
from extras import cmdclass

if __name__ == "__main__":
    from distutils.core import setup
    series = bzr_plugin_version[:2]
    series_string = ".".join([str(x) for x in series])
    version = bzr_plugin_version[:3]
    version_string = ".".join([str(x) for x in version])
    setup(name="bzr-tweet",
          description="Tweet bazaar activities",
          keywords="plugin bzr twitter",
          version=version_string,
          url="http://launchpad.net/bzr-twitter/%s/%s/+download/bzr-tweet-%s.tar.gz" % (
            series_string, version_string, version_string),
          download_url="http://launchpad.net/bzr-twitter",
          author="Koichi Akabe",
          author_email="vbkaisetsu@gmail.com",
          license="GPLv3",
          long_description="""\
This is a plugin for Bazaar VCS that posts messages to Twitter/Identica
when you commit or push new revisions. You can authenticate with
tweet-auth command and just use commit or push commands to tweet.
""",
          package_data={"bzrlib.plugins.tweet": ["locale/*/LC_MESSAGES/bzr-tweet.mo"]},
          package_dir={"bzrlib.plugins.tweet":"."},
          packages=["bzrlib.plugins.tweet"],
          cmdclass=cmdclass,
          )
