+++
title = "Pyramid3"
+++

### Pyramid3

A truncated pyramid (frustum) with trigonal base.

<img src="/img/draw/ff/3d/Pyramid3.png" width="30%" >
<img src="/img/draw/ff/2d/Pyramid3_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Pyramid3_xz.svg" width="30%">

#### Constructor

```python
Pyramid3(L, H, alpha)
```

Parameters:
- L, edge length of the trigonal base
- H, height
- alpha, dihedral angle $\alpha$ between the base and a side face.

Constraint:

$H \le \dfrac{\tan\alpha}{2\sqrt3} L$

The orthographic projection also shows the angle $\beta$ between the base and a side edge.
It is related to the dihedral angle through $\tan\alpha = 2\tan\beta$.

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class [Pyramid3]({{% url-src %}}/Sample/HardParticle/Polyhedra.h) inherits from the interface class
{{% ref-class "Sample/Particle" "IFormfactor" %}}.

Form factor computation is based on the generic form factor of a polyhedron
provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormfactorBasicTest.cpp)
against
$$ V=\dfrac{L^3\tan\alpha}{24}\Big[1-\Big(1-\dfrac{2\sqrt3H}{L\tan\alpha}\Big)^3\Big]. $$

#### Related shapes

More special:
- [Prism3](/ref/sample/particle/ff/hard/prism3), if $\alpha=90^{\circ}$.
- [PlatonicTetrahedron](/ref/sample/particle/ff/hard/platonictetrahedron), if regular and not truncated.

#### Example

Scattering by uncorrelated, oriented pyramids for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/Pyramid3.png">

Generated by {{% ref-ex "ff/Pyramid3.py" %}}.

#### History

Was incorrectly named "Tetrahedron" up to BornAgain 1.19.

Corresponds to "Tetrahedron" in IsGISAXS [[manual](/lit/lazzari2006), Eq. 2.29;
[Renaud 2009](/lit/renaud2009), Eq. 220] and "Truncated tetrahedron" in FitGISAXS [[Babonneau 2013](/lit/babonneau2013)]. In BornAgain 1.6, redefined to let the $x$ axis lie in a mirror plane (rotated by $30^{\circ}$ with respect to the previous version).

Up to BornAgain 1.5, we computed the form factor by numeric integration, as in
IsGISAXS. Since BornAgain 1.6 higher speed and accuracy are achieved by using the
generic form factor of a polyhedron [[Wuttke 2021](/lit/wuttke2021)] with series expansions near singularities.
