//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/CoreAndShellForm.h
//! @brief     Defines class CoreAndShellForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_COREANDSHELLFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_COREANDSHELLFORM_H

#include <QComboBox>
#include <QGroupBox>
#include <memory>

class CoreAndShellItem;
class FormLayouter;
class GroupBoxCollapser;
class SampleEditorController;

//! Form for editing a core/shell particle
class CoreAndShellForm : public QGroupBox {
    Q_OBJECT
public:
    CoreAndShellForm(QWidget* parent, CoreAndShellItem* coreShellItem, SampleEditorController* ec,
                     bool allowRemove = true);

    void enableStructureEditing(bool b);
    CoreAndShellItem* coreShellItem() const;

    void createCoreWidgets();
    void createShellWidgets();

private:
    void onCoreComboChanged();
    void onShellComboChanged();

    void showCoreInRealspace();
    void showShellInRealspace();

    CoreAndShellItem* m_item;
    QAction* m_removeAction = nullptr;
    QAction* m_duplicateAction = nullptr;
    SampleEditorController* m_ec;
    struct Location {
        std::unique_ptr<FormLayouter> layouter;
        QComboBox* formfactorCombo = nullptr;
        GroupBoxCollapser* collapser = nullptr;
    };
    Location core;
    Location shell;
};


#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_COREANDSHELLFORM_H
