//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Device/Data/ArrayUtil.h
//! @brief     Defines various functions to interact from numpy on Python side
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_DEVICE_DATA_ARRAYUTIL_H
#define BORNAGAIN_DEVICE_DATA_ARRAYUTIL_H

#include <memory>
#include <vector>

class Datafield;

//! Array utility functions getShape

namespace DataUtil::Array {

//! Returns shape nrows, ncols of 2D array.
std::pair<size_t, size_t> getShape(const std::vector<std::vector<double>>& data);

std::unique_ptr<Datafield> createPField1D(const std::vector<double>& vec);

std::unique_ptr<Datafield> createPField2D(const std::vector<std::vector<double>>& vec);

//! Creates 1D vector from Datafield.
std::vector<double> createVector1D(const Datafield& data);

//! Creates 2D vector from Datafield.
std::vector<std::vector<double>> createVector2D(const Datafield& data);

} // namespace DataUtil::Array

#endif // BORNAGAIN_DEVICE_DATA_ARRAYUTIL_H
