#include "Bdef.h"

void cgupk_sum(MatInf, buff)
MATINFO  *MatInf;
char  *buff;
{
   int m, n, lda, i, j;
   float *A, *v;

   m = MatInf->M;
   n = MatInf->N;
   lda = MatInf->lda;
   A = (float *) MatInf->A;
   v = (float *) buff;

   if (m != 1)
   {
      m *= 2;
      lda *=2;
      for(j=0; j < n; j++)
      {
	 i = pvm_upkfloat(v, m, 1);
	 Mpvmerror(i, "pvm_upkfloat", __LINE__, __FILE__);
	 for (i=0; i < m; i++) A[i] += v[i];
	 A += lda;
      }
   }
   else
   {
      i = pvm_upkcplx((float *) v, n, 1);
      Mpvmerror(i, "pvm_upkcplx", __LINE__, __FILE__);
      lda *= 2;
      n *= 2;
      for (i=j=0; j < n; j += 2, i += lda)
      {
         A[i] += v[j];
         A[i+1] += v[j+1];
      }
   }
}
