/* Copyright (c) 2007  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/* Test of cos() function. 500 random cases with fabs(x) < 10.
   $Id$
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x;		/* argument	*/
    long z;		/* cos(x)	*/
} t[] = {

    /* x, cos(x)	*/
    { 0x3f5f4a23,0x3f24a3cc }, /*   1:  8.7222499e-01  6.4312434e-01 */
    { 0x1a517714,0x3f800000 }, /*   2:  4.3316378e-23  1.0000000e+00 */
    { 0x3e516a81,0x3f7aaa4c }, /*   3:  2.0450784e-01  9.7916102e-01 */
    { 0x3edceae7,0x3f68897d }, /*   4:  4.3147966e-01  9.0834790e-01 */
    { 0xbfe8ea8c,0xbe7c363e }, /*   5: -1.8196578e+00 -2.4630067e-01 */
    { 0x3f586d29,0x3f29d5ea }, /*   6:  8.4541565e-01  6.6342032e-01 */
    { 0x3e4c78b8,0x3f7ae9d1 }, /*   7:  1.9967926e-01  9.8013026e-01 */
    { 0xbf2c1fd0,0x3f484855 }, /*   8: -6.7236042e-01  7.8235370e-01 */
    { 0x3fdee763,0xbe2de37e }, /*   9:  1.7414364e+00 -1.6981313e-01 */
    { 0x3f2d056f,0x3f47b900 }, /*  10:  6.7586416e-01  7.8016663e-01 */
    { 0x3f2741a0,0x3f4b472f }, /*  11:  6.5334511e-01  7.9405493e-01 */
    { 0x3f5f0b9e,0x3f24d3a7 }, /*  12:  8.7127101e-01  6.4385456e-01 */
    { 0xbe370e47,0x3f7beb9e }, /*  13: -1.7876540e-01  9.8406398e-01 */
    { 0xbf55ec95,0x3f2bb324 }, /*  14: -8.3564121e-01  6.7070222e-01 */
    { 0x3fde213a,0xbe27c86e }, /*  15:  1.7353890e+00 -1.6385052e-01 */
    { 0xbf1f4f06,0x3f5002a2 }, /*  16: -6.2229955e-01  8.1254017e-01 */
    { 0x3ea45bf0,0x3f72ec28 }, /*  17:  3.2101393e-01  9.4891596e-01 */
    { 0xbff56f40,0xbeadf4f8 }, /*  18: -1.9174576e+00 -3.3975959e-01 */
    { 0x3fc3caf1,0x3d289104 }, /*  19:  1.5296308e+00  4.1153923e-02 */
    { 0x3fb121fe,0x3e3e51f0 }, /*  20:  1.3838499e+00  1.8585944e-01 */
    { 0xbf59ce88,0x3f28cce0 }, /*  21: -8.5080767e-01  6.5937614e-01 */
    { 0xbf298d30,0x3f49dff3 }, /*  22: -6.6231060e-01  7.8857344e-01 */
    { 0xbe309462,0x3f7c3407 }, /*  23: -1.7244104e-01  9.8516887e-01 */
    { 0x3f29ea0b,0x3f49a6cc }, /*  24:  6.6372746e-01  7.8770137e-01 */
    { 0x3f4ea304,0x3f3108e3 }, /*  25:  8.0717492e-01  6.9154185e-01 */
    { 0x3e39698b,0x3f7bd0a1 }, /*  26:  1.8106668e-01  9.8365217e-01 */
    { 0xbeef60c4,0x3f6486cd }, /*  27: -4.6753514e-01  8.9268190e-01 */
    { 0xc094b887,0xbd84bf67 }, /*  28: -4.6475253e+00 -6.4818196e-02 */
    { 0xbf64be0e,0x3f206d60 }, /*  29: -8.9352500e-01  6.2666893e-01 */
    { 0xbf55ad86,0x3f2be1e5 }, /*  30: -8.3467901e-01  6.7141563e-01 */
    { 0x3f256c4c,0x3f4c6320 }, /*  31:  6.4618373e-01  7.9838753e-01 */
    { 0x3f287b31,0x3f4a87fd }, /*  32:  6.5812975e-01  7.9113752e-01 */
    { 0xbf33382c,0x3f43c97f }, /*  33: -7.0007586e-01  7.6479334e-01 */
    { 0xbe9d4e6c,0x3f740318 }, /*  34: -3.0723894e-01  9.5317221e-01 */
    { 0xbe2089b5,0x3f7cdc43 }, /*  35: -1.5677531e-01  9.8773593e-01 */
    { 0x3fa8d940,0x3e7efea0 }, /*  36:  1.3191299e+00  2.4901819e-01 */
    { 0xbf56df6f,0x3f2afeb6 }, /*  37: -8.3934683e-01  6.6794908e-01 */
    { 0xbe5c5e48,0x3f7a1848 }, /*  38: -2.1520340e-01  9.7693300e-01 */
    { 0x3f5830c5,0x3f2a0315 }, /*  39:  8.4449416e-01  6.6410953e-01 */
    { 0x409d6d60,0x3e52ab9e }, /*  40:  4.9196014e+00  2.0573279e-01 */
    { 0xbd5a12be,0x3f7fa324 }, /*  41: -5.3240530e-02  9.9858308e-01 */
    { 0x3db55815,0x3f7eff40 }, /*  42:  8.8546909e-02  9.9608231e-01 */
    { 0x3ff2b704,0xbea3afd8 }, /*  43:  1.8962102e+00 -3.1970096e-01 */
    { 0x3f86f810,0x3efcc796 }, /*  44:  1.0544453e+00  4.9371022e-01 */
    { 0x3ef7ba5a,0x3f629d5a }, /*  45:  4.8384362e-01  8.8521349e-01 */
    { 0xbf2b6e0e,0x3f48b6db }, /*  46: -6.6964805e-01  7.8404015e-01 */
    { 0x3e932e4c,0x3f757ed2 }, /*  47:  2.8746259e-01  9.5896637e-01 */
    { 0xbf2a1010,0x3f498f5e }, /*  48: -6.6430759e-01  7.8734386e-01 */
    { 0x3ea867b1,0x3f7246d0 }, /*  49:  3.2891610e-01  9.4639301e-01 */
    { 0xc085bcfe,0xbf0217fe }, /*  50: -4.1793203e+00 -5.0817859e-01 */
    { 0x3da8854b,0x3f7f2242 }, /*  51:  8.2285486e-02  9.9661648e-01 */
    { 0x3f4b84f8,0x3f3345f8 }, /*  52:  7.9499769e-01  7.0028639e-01 */
    { 0xbf548157,0x3f2cbfe4 }, /*  53: -8.3009857e-01  6.7480302e-01 */
    { 0xbf2f6355,0x3f463bca }, /*  54: -6.8510944e-01  7.7434981e-01 */
    { 0xbef010ab,0x3f645f1c }, /*  55: -4.6887717e-01  8.9207625e-01 */
    { 0x3eeed5b7,0x3f64a61a }, /*  56:  4.6647426e-01  8.9315951e-01 */
    { 0x3e8cb1bd,0x3f76652c }, /*  57:  2.7479354e-01  9.6248126e-01 */
    { 0xc00b3e15,0xbf119345 }, /*  58: -2.1756642e+00 -5.6865340e-01 */
    { 0xbfa1acc0,0x3e9b12ef }, /*  59: -1.2630844e+00  3.0287883e-01 */
    { 0xbf8cacd4,0x3ee8afb2 }, /*  60: -1.0990243e+00  4.5446545e-01 */
    { 0x3e9561d7,0x3f752e5a }, /*  61:  2.9176208e-01  9.5773852e-01 */
    { 0x36ff6035,0x3f800000 }, /*  62:  7.6107922e-06  1.0000000e+00 */
    { 0x3fa12fab,0x3e9cef78 }, /*  63:  1.2592672e+00  3.0651450e-01 */
    { 0xbf23bc71,0x3f4d6607 }, /*  64: -6.3959414e-01  8.0233806e-01 */
    { 0xbf96e24a,0x3ec39c4c }, /*  65: -1.1787808e+00  3.8205183e-01 */
    { 0xbeb8d595,0x3f6f7fb6 }, /*  66: -3.6100450e-01  9.3554246e-01 */
    { 0xbf27141f,0x3f4b62d5 }, /*  67: -6.5265077e-01  7.9447681e-01 */
    { 0x3ec6a4b1,0x3f6cf92a }, /*  68:  3.8797525e-01  9.2567694e-01 */
    { 0x3f93bba1,0x3ecf32b2 }, /*  69:  1.1541635e+00  4.0468365e-01 */
    { 0x3e92cb3a,0x3f758cd9 }, /*  70:  2.8670675e-01  9.5918041e-01 */
    { 0x3f5b3996,0x3f27bb44 }, /*  71:  8.5634744e-01  6.5520120e-01 */
    { 0xbef88a41,0x3f626cec }, /*  72: -4.8542979e-01  8.8447452e-01 */
    { 0xbf269929,0x3f4bad6a }, /*  73: -6.5077454e-01  7.9561484e-01 */
    { 0x3f58c1d4,0x3f299687 }, /*  74:  8.4670758e-01  6.6245311e-01 */
    { 0xbfff018a,0xbed1720a }, /*  75: -1.9922345e+00 -4.0907317e-01 */
    { 0xbeabfbcd,0x3f71b157 }, /*  76: -3.3590546e-01  9.4411224e-01 */
    { 0x3fa5fcfa,0x3e8a8bc0 }, /*  77:  1.2967827e+00  2.7059746e-01 */
    { 0x40e6c2fd,0x3f196e81 }, /*  78:  7.2113023e+00  5.9934241e-01 */
    { 0xbe363aea,0x3f7bf4fe }, /*  79: -1.7795911e-01  9.8420703e-01 */
    { 0xbe081b6f,0x3f7dbdf1 }, /*  80: -1.3291715e-01  9.9117953e-01 */
    { 0x3efcd1f8,0x3f616b46 }, /*  81:  4.9378943e-01  8.8054311e-01 */
    { 0x3fff2e45,0xbed21542 }, /*  82:  1.9935995e+00 -4.1031843e-01 */
    { 0x3edea120,0x3f682d85 }, /*  83:  4.3482304e-01  9.0694457e-01 */
    { 0x40225f5f,0xbf52a152 }, /*  84:  2.5370710e+00 -8.2277405e-01 */
    { 0x4020104f,0xbf4d3ec3 }, /*  85:  2.5009954e+00 -8.0173892e-01 */
    { 0xbfae57b5,0x3e5434a2 }, /*  86: -1.3620516e+00  2.0723203e-01 */
    { 0x3ea39f26,0x3f7309e1 }, /*  87:  3.1957358e-01  9.4936949e-01 */
    { 0xc0670765,0xbf647227 }, /*  88: -3.6098263e+00 -8.9236683e-01 */
    { 0xc01d8f70,0xbf471ad5 }, /*  89: -2.4618797e+00 -7.7775317e-01 */
    { 0x40a8475a,0x3f05010c }, /*  90:  5.2587099e+00  5.1954722e-01 */
    { 0x3fa872d6,0x3e810be7 }, /*  91:  1.3160045e+00  2.5204393e-01 */
    { 0x3da5a86f,0x3f7f29b9 }, /*  92:  8.0887668e-02  9.9673039e-01 */
    { 0x3fa7b5d1,0x3e83e705 }, /*  93:  1.3102361e+00  2.5762191e-01 */
    { 0xbf2e447a,0x3f46f0d0 }, /*  94: -6.8073237e-01  7.7711201e-01 */
    { 0x40c1408d,0x3f7869e7 }, /*  95:  6.0391297e+00  9.7036594e-01 */
    { 0x3f2ad0d4,0x3f49184d }, /*  96:  6.6724896e-01  7.8552705e-01 */
    { 0x3ec1acae,0x3f6de6ea }, /*  97:  3.7827057e-01  9.2930472e-01 */
    { 0x3f0af3c5,0x3f5b34d6 }, /*  98:  5.4278213e-01  8.5627496e-01 */
    { 0xbd98c618,0x3f7f49be }, /*  99: -7.4596584e-02  9.9721897e-01 */
    { 0x3f66ee7d,0x3f1eb724 }, /* 100:  9.0207654e-01  6.1998200e-01 */
    { 0xbf5cdeca,0x3f267c2e }, /* 101: -8.6277449e-01  6.5033233e-01 */
    { 0x3f2d3a98,0x3f4797bb }, /* 102:  6.7667532e-01  7.7965897e-01 */
    { 0xbf871df0,0x3efc43cb }, /* 103: -1.0556011e+00  4.9270472e-01 */
    { 0x3f25d164,0x3f4c2631 }, /* 104:  6.4772630e-01  7.9745775e-01 */
    { 0xbeef2b82,0x3f6492cc }, /* 105: -4.6712881e-01  8.9286494e-01 */
    { 0x3ef7b1be,0x3f629f5a }, /* 106:  4.8377794e-01  8.8524401e-01 */
    { 0x3f1ae2fe,0x3f528e86 }, /* 107:  6.0502613e-01  8.2248724e-01 */
    { 0xbf186586,0x3f53f68d }, /* 108: -5.9529912e-01  8.2798082e-01 */
    { 0x3f524695,0x3f2e636d }, /* 109:  8.2138950e-01  6.8120462e-01 */
    { 0x3ed2b200,0x3f6aa0ce }, /* 110:  4.1151428e-01  9.1651618e-01 */
    { 0x3eddb75b,0x3f685eaa }, /* 111:  4.3303952e-01  9.0769446e-01 */
    { 0x31690f85,0x3f800000 }, /* 112:  3.3914784e-09  1.0000000e+00 */
    { 0x3fc332df,0x3d3b8ea9 }, /* 113:  1.5249900e+00  4.5790348e-02 */
    { 0xbf993ce1,0x3ebae072 }, /* 114: -1.1971704e+00  3.6499363e-01 */
    { 0x3e535f7d,0x3f7a90bf }, /* 115:  2.0641895e-01  9.7877115e-01 */
    { 0x3f604b6a,0x3f23de75 }, /* 116:  8.7615073e-01  6.4011317e-01 */
    { 0xbf5a9a39,0x3f283387 }, /* 117: -8.5391575e-01  6.5703624e-01 */
    { 0x3fc5b7a1,0x3cd6082c }, /* 118:  1.5446664e+00  2.6126944e-02 */
    { 0xbecf328b,0x3f6b527e }, /* 119: -4.0468249e-01  9.1922748e-01 */
    { 0xbda68794,0x3f7f2776 }, /* 120: -8.1313282e-02  9.9669588e-01 */
    { 0xc02de320,0xbf694481 }, /* 121: -2.7169876e+00 -9.1120154e-01 */
    { 0xbf269c20,0x3f4bab9e }, /* 122: -6.5081978e-01  7.9558742e-01 */
    { 0x3ff79838,0xbeb60ed3 }, /* 123:  1.9343328e+00 -3.5558185e-01 */
    { 0xbf572456,0x3f2acb68 }, /* 124: -8.4039819e-01  6.6716623e-01 */
    { 0xbffc86e8,0xbec85bb7 }, /* 125: -1.9728670e+00 -3.9132473e-01 */
    { 0x3f56cb48,0x3f2b0db5 }, /* 126:  8.3903933e-01  6.6817790e-01 */
    { 0xbe631f71,0x3f79ba93 }, /* 127: -2.2179963e-01  9.7550315e-01 */
    { 0xbf585a43,0x3f29e40e }, /* 128: -8.4512728e-01  6.6363609e-01 */
    { 0x3eea88cb,0x3f659b99 }, /* 129:  4.5807490e-01  8.9690548e-01 */
    { 0xbfc357aa,0x3d36f67d }, /* 130: -1.5261128e+00  4.4668663e-02 */
    { 0xbf6134d2,0x3f232adf }, /* 131: -8.7971222e-01  6.3737291e-01 */
    { 0xbf4a4f53,0x3f342280 }, /* 132: -7.9027289e-01  7.0365143e-01 */
    { 0x3dafed26,0x3f7f0e5a }, /* 133:  8.5901543e-02  9.9631274e-01 */
    { 0xbd42828c,0x3f7fb61e }, /* 134: -4.7487780e-02  9.9887264e-01 */
    { 0x3f2be40c,0x3f486d89 }, /* 135:  6.7144847e-01  7.8292137e-01 */
    { 0x3f54fdb2,0x3f2c6409 }, /* 136:  8.3199608e-01  6.7340142e-01 */
    { 0xbf5c950d,0x3f26b42b }, /* 137: -8.6164933e-01  6.5118665e-01 */
    { 0xbe849521,0x3f7776fc }, /* 138: -2.5895026e-01  9.6665931e-01 */
    { 0x408548a7,0xbf053631 }, /* 139:  4.1651187e+00 -5.2035815e-01 */
    { 0x3ef2a7b9,0x3f63c88d }, /* 140:  4.7393587e-01  8.8977891e-01 */
    { 0xbf4836b1,0x3f359e41 }, /* 141: -7.8208452e-01  7.0944601e-01 */
    { 0x3f636dec,0x3f2172c7 }, /* 142:  8.8839602e-01  6.3065761e-01 */
    { 0xbed4b58b,0x3f6a393b }, /* 143: -4.1544756e-01  9.1493577e-01 */
    { 0xbfbf0305,0x3da0a312 }, /* 144: -1.4922796e+00  7.8436032e-02 */
    { 0x3856cc8e,0x3f800000 }, /* 145:  5.1212082e-05  1.0000000e+00 */
    { 0x3f604aee,0x3f23ded5 }, /* 146:  8.7614334e-01  6.4011890e-01 */
    { 0x3e934499,0x3f757ba8 }, /* 147:  2.8763273e-01  9.5891809e-01 */
    { 0xbe883754,0x3f76fe4b }, /* 148: -2.6604712e-01  9.6481770e-01 */
    { 0xbf5c9b58,0x3f26af64 }, /* 149: -8.6174536e-01  6.5111375e-01 */
    { 0xbec5bf0f,0x3f6d2482 }, /* 150: -3.8622329e-01  9.2633832e-01 */
    { 0x3f234ccf,0x3f4da895 }, /* 151:  6.3789076e-01  8.0335361e-01 */
    { 0x3faea6cd,0x3e51c976 }, /* 152:  1.3644654e+00  2.0487007e-01 */
    { 0xbeeb7184,0x3f65680c }, /* 153: -4.5985043e-01  8.9611888e-01 */
    { 0xc057cb75,0xbf793f35 }, /* 154: -3.3717930e+00 -9.7362071e-01 */
    { 0x3f294589,0x3f4a0bfb }, /* 155:  6.6121727e-01  7.8924531e-01 */
    { 0xbf5cdc3f,0x3f267e1d }, /* 156: -8.6273569e-01  6.5036184e-01 */
    { 0x3fbab48c,0x3de539b2 }, /* 157:  1.4586349e+00  1.1192645e-01 */
    { 0x3ea48514,0x3f72e5aa }, /* 158:  3.2132781e-01  9.4881690e-01 */
    { 0x3fa462b2,0x3e90b4d4 }, /* 159:  1.2842619e+00  2.8262961e-01 */
    { 0x3ec5943f,0x3f6d2c92 }, /* 160:  3.8589665e-01  9.2646134e-01 */
    { 0x3fbaa845,0x3de5fce5 }, /* 161:  1.4582602e+00  1.1229876e-01 */
    { 0xbf5d298a,0x3f26435e }, /* 162: -8.6391509e-01  6.4946544e-01 */
    { 0x3f4e3f11,0x3f315108 }, /* 163:  8.0564982e-01  6.9264269e-01 */
    { 0x40f2d555,0x3e8650a5 }, /* 164:  7.5885415e+00  2.6233402e-01 */
    { 0xbf31e1ff,0x3f44a544 }, /* 165: -6.9485468e-01  7.6814675e-01 */
    { 0x3f2860a5,0x3f4a9839 }, /* 166:  6.5772468e-01  7.9138523e-01 */
    { 0xbede841f,0x3f6833a1 }, /* 167: -4.3460175e-01  9.0703779e-01 */
    { 0x40fd4892,0xbd7a3872 }, /* 168:  7.9151087e+00 -6.1088987e-02 */
    { 0x3f2b05a7,0x3f48f798 }, /* 169:  6.6805500e-01  7.8502798e-01 */
    { 0x3e59dc00,0x3f7a3a60 }, /* 170:  2.1275330e-01  9.7745323e-01 */
    { 0x3ed8f08b,0x3f695ca3 }, /* 171:  4.2371020e-01  9.1156977e-01 */
    { 0x3f57fc01,0x3f2a2a85 }, /* 172:  8.4368902e-01  6.6471130e-01 */
    { 0x3f5c2a6b,0x3f270509 }, /* 173:  8.6002225e-01  6.5242058e-01 */
    { 0xbe3ab43a,0x3f7bc1b1 }, /* 174: -1.8232813e-01  9.8342425e-01 */
    { 0x3f632ed8,0x3f21a3b6 }, /* 175:  8.8743353e-01  6.3140428e-01 */
    { 0xbfb305bd,0x3e2f723a }, /* 176: -1.3986126e+00  1.7133418e-01 */
    { 0x400a4adf,0xbf0e6ef4 }, /* 177:  2.1608198e+00 -5.5638051e-01 */
    { 0x3e2f9539,0x3f7c3ef1 }, /* 178:  1.7146768e-01  9.8533541e-01 */
    { 0x3f5c2554,0x3f2708e5 }, /* 179:  8.5994458e-01  6.5247947e-01 */
    { 0x3f5b8d45,0x3f277c03 }, /* 180:  8.5762435e-01  6.5423602e-01 */
    { 0x402e4754,0xbf69e881 }, /* 181:  2.7231035e+00 -9.1370398e-01 */
    { 0x3f27f1a2,0x3f4adc03 }, /* 182:  6.5603077e-01  7.9241961e-01 */
    { 0xbf5913ad,0x3f29592e }, /* 183: -8.4795648e-01  6.6151702e-01 */
    { 0x3edd4dbd,0x3f6874ce }, /* 184:  4.3223372e-01  9.0803230e-01 */
    { 0xbbc6533e,0x3f7ffecd }, /* 185: -6.0524037e-03  9.9998170e-01 */
    { 0x3f510650,0x3f2f4d5c }, /* 186:  8.1650257e-01  6.8477416e-01 */
    { 0x3d212143,0x3f7fcd4c }, /* 187:  3.9338361e-02  9.9922633e-01 */
    { 0xbedea090,0x3f682da4 }, /* 188: -4.3481874e-01  9.0694642e-01 */
    { 0xbf572589,0x3f2aca84 }, /* 189: -8.4041649e-01  6.6715264e-01 */
    { 0x3fabacd5,0x3e6908dc }, /* 190:  1.3412119e+00  2.2757286e-01 */
    { 0x3e369946,0x3f7bf0d0 }, /* 191:  1.7831907e-01  9.8414326e-01 */
    { 0xbf5bdbd6,0x3f27408f }, /* 192: -8.5882318e-01  6.5332884e-01 */
    { 0x38bd3071,0x3f800000 }, /* 193:  9.0212452e-05  1.0000000e+00 */
    { 0x3f376235,0x3f411413 }, /* 194:  7.1634227e-01  7.5421256e-01 */
    { 0xbe8d9820,0x3f7645d1 }, /* 195: -2.7655125e-01  9.6200281e-01 */
    { 0x3f22d0f4,0x3f4df23e }, /* 196:  6.3600087e-01  8.0447757e-01 */
    { 0xbf49e921,0x3f346b0f }, /* 197: -7.8871351e-01  7.0475858e-01 */
    { 0x3f5c92bc,0x3f26b5ed }, /* 198:  8.6161399e-01  6.5121347e-01 */
    { 0x3f0df600,0x3f59a321 }, /* 199:  5.5453491e-01  8.5014540e-01 */
    { 0x3f7d55ea,0x3f0c8d47 }, /* 200:  9.8959219e-01  5.4903072e-01 */
    { 0x3f5cfac8,0x3f2666e9 }, /* 201:  8.6320162e-01  6.5000778e-01 */
    { 0x3ffaa06b,0xbec1575c }, /* 202:  1.9580206e+00 -3.7761962e-01 */
    { 0x97714270,0x3f800000 }, /* 203: -7.7955156e-25  1.0000000e+00 */
    { 0x3f5a0c57,0x3f289e63 }, /* 204:  8.5175079e-01  6.5866679e-01 */
    { 0xc004ee4f,0xbef844d2 }, /* 205: -2.0770452e+00 -4.8490006e-01 */
    { 0xc0bc090b,0x3f6b146b }, /* 206: -5.8761039e+00  9.1828030e-01 */
    { 0xbf54ef5e,0x3f2c6ea1 }, /* 207: -8.3177745e-01  6.7356306e-01 */
    { 0xbf265cef,0x3f4bd1e0 }, /* 208: -6.4985555e-01  7.9617119e-01 */
    { 0x3f9def7a,0x3ea942b6 }, /* 209:  1.2338707e+00  3.3058709e-01 */
    { 0xbef75290,0x3f62b579 }, /* 210: -4.8305178e-01  8.8558155e-01 */
    { 0x3ed03a07,0x3f6b1e80 }, /* 211:  4.0669271e-01  9.1843414e-01 */
    { 0x3f5abf8c,0x3f281762 }, /* 212:  8.5448527e-01  6.5660679e-01 */
    { 0x3f924989,0x3ed47905 }, /* 213:  1.1428691e+00  4.1498581e-01 */
    { 0xbec89960,0x3f6c9a04 }, /* 214: -3.9179516e-01  9.2422509e-01 */
    { 0x393e0949,0x3f800000 }, /* 215:  1.8123271e-04  1.0000000e+00 */
    { 0xbf9c029f,0x3eb08252 }, /* 216: -1.2188300e+00  3.4474427e-01 */
    { 0x3fb9f542,0x3df11a13 }, /* 217:  1.4527972e+00  1.1772551e-01 */
    { 0xbe688ae9,0x3f796d5f }, /* 218: -2.2709240e-01  9.7432512e-01 */
    { 0xbf94f64f,0x3ecab139 }, /* 219: -1.1637667e+00  3.9588335e-01 */
    { 0xbf610fc4,0x3f23476b }, /* 220: -8.7914681e-01  6.3780850e-01 */
    { 0xbe4a5e75,0x3f7b045f }, /* 221: -1.9762595e-01  9.8053545e-01 */
    { 0x3fa35d53,0x3e949e80 }, /* 222:  1.2762855e+00  2.9027176e-01 */
    { 0x3fa86365,0x3e8147ac }, /* 223:  1.3155333e+00  2.5249994e-01 */
    { 0xbfca1fdd,0xbc0800c9 }, /* 224: -1.5790974e+00 -8.3009684e-03 */
    { 0xbf55de4f,0x3f2bbdba }, /* 225: -8.3542341e-01  6.7086375e-01 */
    { 0xbfddf437,0xbe26652a }, /* 226: -1.7340153e+00 -1.6249529e-01 */
    { 0xbd4c7486,0x3f7fae5f }, /* 227: -4.9915813e-02  9.9875444e-01 */
    { 0x3f2de74d,0x3f472b67 }, /* 228:  6.7931062e-01  7.7800602e-01 */
    { 0x3f58904f,0x3f29bb9c }, /* 229:  8.4595197e-01  6.6301894e-01 */
    { 0xbfe89171,0xbe79831f }, /* 230: -1.8169385e+00 -2.4366425e-01 */
    { 0xbea1646e,0x3f7362f0 }, /* 231: -3.1521934e-01  9.5072842e-01 */
    { 0xbf278f8f,0x3f4b17c7 }, /* 232: -6.5453428e-01  7.9333156e-01 */
    { 0xc0bfcc9d,0x3f75599e }, /* 233: -5.9937272e+00  9.5839870e-01 */
    { 0x3f88cc77,0x3ef663b1 }, /* 234:  1.0687398e+00  4.8122934e-01 */
    { 0xbe765d28,0x3f78a068 }, /* 235: -2.4058974e-01  9.7119761e-01 */
    { 0xbfc02759,0x3d8e6aa7 }, /* 236: -1.5012008e+00  6.9539361e-02 */
    { 0xbccbf940,0x3f7febb0 }, /* 237: -2.4899125e-02  9.9969006e-01 */
    { 0x3e95c92f,0x3f751f78 }, /* 238:  2.9255053e-01  9.5751143e-01 */
    { 0x3fa7bde2,0x3e83c7d7 }, /* 239:  1.3104823e+00  2.5738403e-01 */
    { 0xbf8d331e,0x3ee6d0b8 }, /* 240: -1.1031225e+00  4.5081115e-01 */
    { 0xbddebcb8,0x3f7e7cca }, /* 241: -1.0875839e-01  9.9409163e-01 */
    { 0x3ea041fd,0x3f738fce }, /* 242:  3.1300345e-01  9.5141304e-01 */
    { 0xbfaa7308,0x3e72929f }, /* 243: -1.3316355e+00  2.3688744e-01 */
    { 0x3f221c1c,0x3f4e5d76 }, /* 244:  6.3324142e-01  8.0611360e-01 */
    { 0x3ea6263a,0x3f72a37a }, /* 245:  3.2451040e-01  9.4780695e-01 */
    { 0xbefff5d6,0x3f60abb0 }, /* 246: -4.9992245e-01  8.7761974e-01 */
    { 0x401b00fb,0xbf408520 }, /* 247:  2.4219348e+00 -7.5203133e-01 */
    { 0xbeee3b22,0x3f64c8d2 }, /* 248: -4.6529490e-01  8.9368927e-01 */
    { 0xbeb6ba2e,0x3f6fde75 }, /* 249: -3.5688919e-01  9.3698817e-01 */
    { 0x402fea8d,0xbf6c7e49 }, /* 250:  2.7486908e+00 -9.2380196e-01 */
    { 0xbeef58b2,0x3f64889e }, /* 251: -4.6747357e-01  8.9270961e-01 */
    { 0xbf1de90e,0x3f50d280 }, /* 252: -6.1683738e-01  8.1571198e-01 */
    { 0xbf783197,0x3f10d222 }, /* 253: -9.6950668e-01  5.6570637e-01 */
    { 0x379ff9eb,0x3f800000 }, /* 254:  1.9070654e-05  1.0000000e+00 */
    { 0x3f9b06cb,0x3eb4328a }, /* 255:  1.2111448e+00  3.5194808e-01 */
    { 0x3f30cbfa,0x3f4556d2 }, /* 256:  6.9061244e-01  7.7085602e-01 */
    { 0xbff00a4b,0xbe9983bc }, /* 257: -1.8753141e+00 -2.9983318e-01 */
    { 0x37560723,0x3f800000 }, /* 258:  1.2757056e-05  1.0000000e+00 */
    { 0xbf281248,0x3f4ac817 }, /* 259: -6.5652895e-01  7.9211563e-01 */
    { 0x3ee6bce3,0x3f6670e1 }, /* 260:  4.5065984e-01  9.0015990e-01 */
    { 0xbf1dea37,0x3f50d1d4 }, /* 261: -6.1685508e-01  8.1570172e-01 */
    { 0x3eac9ca7,0x3f7196c8 }, /* 262:  3.3713266e-01  9.4370699e-01 */
    { 0x3efcf491,0x3f616313 }, /* 263:  4.9405339e-01  8.8041800e-01 */
    { 0x3e6407ea,0x3f79adc3 }, /* 264:  2.2268644e-01  9.7530764e-01 */
    { 0xbe9205d3,0x3f75a8b0 }, /* 265: -2.8520069e-01  9.5960522e-01 */
    { 0xbf898b44,0x3ef3c59b }, /* 266: -1.0745625e+00  4.7611699e-01 */
    { 0xbeebef6f,0x3f654c14 }, /* 267: -4.6081111e-01  8.9569211e-01 */
    { 0xbfd1b0ab,0xbd89f244 }, /* 268: -1.6382040e+00 -6.7356616e-02 */
    { 0xbf93379f,0x3ed11520 }, /* 269: -1.1501349e+00  4.0836430e-01 */
    { 0x3e6c62e6,0x3f79358a }, /* 270:  2.3084602e-01  9.7347319e-01 */
    { 0xbe79c094,0x3f786c63 }, /* 271: -2.4389869e-01  9.7040385e-01 */
    { 0x3fa8b87f,0x3e7ffc5f }, /* 272:  1.3181304e+00  2.4998616e-01 */
    { 0xbf569769,0x3f2b3449 }, /* 273: -8.3824784e-01  6.6876656e-01 */
    { 0x3f9db33b,0x3eaa2613 }, /* 274:  1.2320322e+00  3.3232173e-01 */
    { 0xbf56ec3e,0x3f2af52d }, /* 275: -8.3954227e-01  6.6780359e-01 */
    { 0x3eb87ba6,0x3f6f8f95 }, /* 276:  3.6031836e-01  9.3578464e-01 */
    { 0x3db9e4e7,0x3f7ef236 }, /* 277:  9.0768628e-02  9.9588335e-01 */
    { 0xbf22aeff,0x3f4e0668 }, /* 278: -6.3548273e-01  8.0478525e-01 */
    { 0xbfc196ca,0x3d6eff4f }, /* 279: -1.5124142e+00  5.8348950e-02 */
    { 0x40245b2e,0xbf5709bb }, /* 280:  2.5680652e+00 -8.3999223e-01 */
    { 0xbf2a78ed,0x3f494ea7 }, /* 281: -6.6590768e-01  7.8635639e-01 */
    { 0x401e708a,0xbf494bf9 }, /* 282:  2.4756188e+00 -7.8631550e-01 */
    { 0xbe5ccb15,0x3f7a1277 }, /* 283: -2.1561845e-01  9.7684425e-01 */
    { 0x4025661d,0xbf5945bf }, /* 284:  2.5843575e+00 -8.4872049e-01 */
    { 0xbd4f602e,0x3f7fac06 }, /* 285: -5.0628833e-02  9.9871862e-01 */
    { 0xbf399003,0x3f3fa404 }, /* 286: -7.2485369e-01  7.4859643e-01 */
    { 0x3e376818,0x3f7be79f }, /* 287:  1.7910802e-01  9.8400301e-01 */
    { 0xbe9749bb,0x3f74e7c0 }, /* 288: -2.9548439e-01  9.5666122e-01 */
    { 0x3ed362be,0x3f6a7d67 }, /* 289:  4.1286272e-01  9.1597599e-01 */
    { 0x3f9b2763,0x3eb3b87b }, /* 290:  1.2121395e+00  3.5101685e-01 */
    { 0xbe7c60e4,0x3f784397 }, /* 291: -2.4646336e-01  9.6978134e-01 */
    { 0x3ef23108,0x3f63e39c }, /* 292:  4.7303033e-01  8.9019179e-01 */
    { 0x3fb3d5ee,0x3e29086d }, /* 293:  1.4049661e+00  1.6507120e-01 */
    { 0x3ec295ca,0x3f6dbbc6 }, /* 294:  3.8004905e-01  9.2864645e-01 */
    { 0xbf2d6529,0x3f477d10 }, /* 295: -6.7732483e-01  7.7925205e-01 */
    { 0x40330f42,0xbf71052d }, /* 296:  2.7978063e+00 -9.4148523e-01 */
    { 0x1d85c160,0x3f800000 }, /* 297:  3.5404752e-21  1.0000000e+00 */
    { 0x3f22aab5,0x3f4e08f4 }, /* 298:  6.3541728e-01  8.0482411e-01 */
    { 0xbee41754,0x3f6703a6 }, /* 299: -4.4549048e-01  9.0239942e-01 */
    { 0x3f1d7073,0x3f51182d }, /* 300:  6.1499709e-01  8.1677514e-01 */
    { 0x3f8b4008,0x3eedbfc5 }, /* 301:  1.0878916e+00  4.6435371e-01 */
    { 0xbf2a4a34,0x3f496b80 }, /* 302: -6.6519475e-01  7.8679657e-01 */
    { 0xbf5ae50e,0x3f27fb17 }, /* 303: -8.5505760e-01  6.5617508e-01 */
    { 0xbefff0db,0x3f60ace1 }, /* 304: -4.9988446e-01  8.7763792e-01 */
    { 0xbfcc6eee,0xbcd7be75 }, /* 305: -1.5971353e+00 -2.6335934e-02 */
    { 0xbfe57a98,0xbe617906 }, /* 306: -1.7928038e+00 -2.2018823e-01 */
    { 0xbf541b85,0x3f2d0afb }, /* 307: -8.2854491e-01  6.7594880e-01 */
    { 0x3ee3076a,0x3f673e1b }, /* 308:  4.4341594e-01  9.0329140e-01 */
    { 0xbd3ef141,0x3f7fb8ce }, /* 309: -4.6616796e-02  9.9891365e-01 */
    { 0x3f2ac37f,0x3f49208d }, /* 310:  6.6704553e-01  7.8565294e-01 */
    { 0x3fa58077,0x3e8c6af6 }, /* 311:  1.2929829e+00  2.7425355e-01 */
    { 0xbf30b667,0x3f456490 }, /* 312: -6.9028324e-01  7.7106571e-01 */
    { 0xbf5bc1f4,0x3f275427 }, /* 313: -8.5842824e-01  6.5362781e-01 */
    { 0x3f9acc66,0x3eb50d19 }, /* 314:  1.2093627e+00  3.5361555e-01 */
    { 0xbf7b4d88,0x3f0e3f14 }, /* 315: -9.8165178e-01  5.5565000e-01 */
    { 0x3edc3ba9,0x3f68ae15 }, /* 316:  4.3014267e-01  9.0890628e-01 */
    { 0xbf24d1fb,0x3f4cbfe7 }, /* 317: -6.4382905e-01  7.9980320e-01 */
    { 0x3fcbda60,0xbcb29db8 }, /* 318:  1.5926018e+00 -2.1803722e-02 */
    { 0x3f896ed8,0x3ef4298e }, /* 319:  1.0736952e+00  4.7687954e-01 */
    { 0xbeba4495,0x3f6f3ea8 }, /* 320: -3.6380449e-01  9.3454981e-01 */
    { 0xbec551b2,0x3f6d3916 }, /* 321: -3.8538891e-01  9.2665231e-01 */
    { 0xbef9e9e5,0x3f621aad }, /* 322: -4.8811260e-01  8.8321954e-01 */
    { 0x3f2a3482,0x3f4978e4 }, /* 323:  6.6486371e-01  7.8700089e-01 */
    { 0x3f34664e,0x3f43064e }, /* 324:  7.0468605e-01  7.6181495e-01 */
    { 0xbff3f226,0xbea85844 }, /* 325: -1.9058273e+00 -3.2879841e-01 */
    { 0x3f2ccf17,0x3f47dafb }, /* 326:  6.7503494e-01  7.8068513e-01 */
    { 0xbef86f3b,0x3f627339 }, /* 327: -4.8522362e-01  8.8457066e-01 */
    { 0x3f4c5b9d,0x3f32ac7f }, /* 328:  7.9827291e-01  6.9794458e-01 */
    { 0x3f5bdc62,0x3f274025 }, /* 329:  8.5883152e-01  6.5332252e-01 */
    { 0xbfadc614,0x3e58a7d6 }, /* 330: -1.3576074e+00  2.1157774e-01 */
    { 0x3f5c763e,0x3f26cb8b }, /* 331:  8.6117923e-01  6.5154332e-01 */
    { 0xbf529648,0x3f2e290c }, /* 332: -8.2260561e-01  6.8031383e-01 */
    { 0x3f23138c,0x3f4dcaa9 }, /* 333:  6.3701701e-01  8.0387360e-01 */
    { 0xbf5ce6b9,0x3f267627 }, /* 334: -8.6289555e-01  6.5024036e-01 */
    { 0x3fcd62ba,0xbd0a552f }, /* 335:  1.6045754e+00 -3.3772644e-02 */
    { 0xbebdad06,0x3f6ea215 }, /* 336: -3.7046069e-01  9.3216068e-01 */
    { 0x411cb0ca,0xbf6ed33c }, /* 337:  9.7931614e+00 -9.3291068e-01 */
    { 0x3ee5df77,0x3f66a104 }, /* 338:  4.4897053e-01  9.0089440e-01 */
    { 0xbf45eefc,0x3f3737c7 }, /* 339: -7.7317786e-01  7.1569484e-01 */
    { 0x3e9a4425,0x3f7477ae }, /* 340:  3.0130115e-01  9.5495117e-01 */
    { 0xbda34d2d,0x3f7f2fc6 }, /* 341: -7.9737045e-02  9.9682271e-01 */
    { 0xc00397e3,0xbeeedb57 }, /* 342: -2.0561454e+00 -4.6651718e-01 */
    { 0xbe09f631,0x3f7dae1b }, /* 343: -1.3472821e-01  9.9093789e-01 */
    { 0x3f236ce4,0x3f4d9578 }, /* 344:  6.3838029e-01  8.0306196e-01 */
    { 0xc03a419c,0xbf792e27 }, /* 345: -2.9102545e+00 -9.7336048e-01 */
    { 0xbee852cc,0x3f661833 }, /* 346: -4.5375669e-01  8.9880675e-01 */
    { 0x40628bd7,0xbf6bf8af }, /* 347:  3.5397851e+00 -9.2176336e-01 */
    { 0xbfc64cd6,0x3cb0bda6 }, /* 348: -1.5492198e+00  2.1574806e-02 */
    { 0xbfdd802f,0xbe22d0fc }, /* 349: -1.7304744e+00 -1.5900034e-01 */
    { 0x3f569528,0x3f2b35f6 }, /* 350:  8.3821344e-01  6.6879213e-01 */
    { 0x3fe522a1,0xbe5eca5f }, /* 351:  1.7901193e+00 -2.1756886e-01 */
    { 0xc0667054,0xbf658060 }, /* 352: -3.6006060e+00 -8.9649010e-01 */
    { 0xb8cfa9f3,0x3f800000 }, /* 353: -9.9021847e-05  1.0000000e+00 */
    { 0x3f31013d,0x3f4534e0 }, /* 354:  6.9142514e-01  7.7033806e-01 */
    { 0xbe6b297a,0x3f79476c }, /* 355: -2.2965041e-01  9.7374606e-01 */
    { 0xbec5a130,0x3f6d2a22 }, /* 356: -3.8599539e-01  9.2642415e-01 */
    { 0x3f22e97e,0x3f4de3aa }, /* 357:  6.3637531e-01  8.0425513e-01 */
    { 0x3f5ec676,0x3f25088b }, /* 358:  8.7021577e-01  6.4466161e-01 */
    { 0xbfb57c12,0x3e1c0222 }, /* 359: -1.4178488e+00  1.5235189e-01 */
    { 0x3ee7ed41,0x3f662e6f }, /* 360:  4.5298198e-01  8.9914602e-01 */
    { 0x3ed31461,0x3f6a8d1c }, /* 361:  4.1226485e-01  9.1621566e-01 */
    { 0xbe0e2c77,0x3f7d8959 }, /* 362: -1.3884149e-01  9.9037701e-01 */
    { 0x3f534221,0x3f2daaf1 }, /* 363:  8.2522780e-01  6.7838961e-01 */
    { 0xbfafbc45,0x3e494ae5 }, /* 364: -1.3729330e+00  1.9657476e-01 */
    { 0xbf83d0f1,0x3f03d5a0 }, /* 365: -1.0298139e+00  5.1497841e-01 */
    { 0x3f28140e,0x3f4ac702 }, /* 366:  6.5655601e-01  7.9209912e-01 */
    { 0x3ef125d0,0x3f64205c }, /* 367:  4.7099161e-01  8.9111876e-01 */
    { 0x3ef71aaf,0x3f62c272 }, /* 368:  4.8262545e-01  8.8577950e-01 */
    { 0xbfad5251,0x3e5c309d }, /* 369: -1.3540746e+00  2.1502919e-01 */
    { 0x3ef30456,0x3f63b367 }, /* 370:  4.7464246e-01  8.8945621e-01 */
    { 0xbe9a583f,0x3f7474b2 }, /* 371: -3.0145451e-01  9.5490563e-01 */
    { 0xbf558718,0x3f2bfe5d }, /* 372: -8.3409262e-01  6.7185003e-01 */
    { 0x3f31f347,0x3f449a33 }, /* 373:  6.9511837e-01  7.6797789e-01 */
    { 0xbec528c2,0x3f6d40c7 }, /* 374: -3.8507658e-01  9.2676967e-01 */
    { 0x3f305dbb,0x3f459cfa }, /* 375:  6.8893021e-01  7.7192652e-01 */
    { 0x3f5a02f9,0x3f28a56f }, /* 376:  8.5160786e-01  6.5877432e-01 */
    { 0xbef80dce,0x3f6289ed }, /* 377: -4.8448032e-01  8.8491708e-01 */
    { 0xbf23c9d5,0x3f4d5e09 }, /* 378: -6.3979846e-01  8.0221611e-01 */
    { 0xbf268500,0x3f4bb9a0 }, /* 379: -6.5046692e-01  7.9580116e-01 */
    { 0x3f224cec,0x3f4e4090 }, /* 380:  6.3398623e-01  8.0567265e-01 */
    { 0x3f9323d5,0x3ed15d5f }, /* 381:  1.1495310e+00  4.0891549e-01 */
    { 0xbee2abb4,0x3f6751c4 }, /* 382: -4.4271624e-01  9.0359139e-01 */
    { 0xbf46502d,0x3f36f3d8 }, /* 383: -7.7466089e-01  7.1465826e-01 */
    { 0x3eb6d7a7,0x3f6fd94e }, /* 384:  3.5711405e-01  9.3690956e-01 */
    { 0x3c32e45c,0x3f7ffc18 }, /* 385:  1.0918703e-02  9.9994040e-01 */
    { 0xbfe722ce,0xbe6e627e }, /* 386: -1.8057497e+00 -2.3279759e-01 */
    { 0xbfceb541,0xbd349dcc }, /* 387: -1.6149064e+00 -4.4095799e-02 */
    { 0xbfd2c966,0xbd9b7267 }, /* 388: -1.6467712e+00 -7.5901799e-02 */
    { 0xbf943f18,0x3ecd5164 }, /* 389: -1.1581755e+00  4.0101159e-01 */
    { 0x3ed01119,0x3f6b2697 }, /* 390:  4.0638044e-01  9.1855758e-01 */
    { 0xbf227ed2,0x3f4e22fd }, /* 391: -6.3474762e-01  8.0522138e-01 */
    { 0x3ffd2d94,0xbecac092 }, /* 392:  1.9779534e+00 -3.9600044e-01 */
    { 0x40de2d25,0x3f4a43f1 }, /* 393:  6.9430108e+00  7.9009920e-01 */
    { 0x405139d7,0xbf7deb84 }, /* 394:  3.2691553e+00 -9.9187493e-01 */
    { 0x3f245610,0x3f4d0a31 }, /* 395:  6.4193821e-01  8.0093676e-01 */
    { 0x3ef4e99f,0x3f63441c }, /* 396:  4.7834489e-01  8.8775802e-01 */
    { 0xbfaa3e07,0x3e742e81 }, /* 397: -1.3300179e+00  2.3845865e-01 */
    { 0xbd901d55,0x3f7f5dcf }, /* 398: -7.0368446e-02  9.9752516e-01 */
    { 0x3fcc837e,0xbcdce1fd }, /* 399:  1.5977628e+00 -2.6963228e-02 */
    { 0xbe4b041d,0x3f7afc3a }, /* 400: -1.9825788e-01  9.8041117e-01 */
    { 0xbf93bbe1,0x3ecf31c7 }, /* 401: -1.1541711e+00  4.0467665e-01 */
    { 0x402bce32,0xbf65b6e2 }, /* 402:  2.6844602e+00 -8.9732182e-01 */
    { 0xbf25271a,0x3f4c8cc3 }, /* 403: -6.4512789e-01  7.9902285e-01 */
    { 0xbf84e602,0x3f01f96b }, /* 404: -1.0382693e+00  5.0771207e-01 */
    { 0xbf575d45,0x3f2aa0fb }, /* 405: -8.4126693e-01  6.6651887e-01 */
    { 0xbfac815b,0x3e62900a }, /* 406: -1.3476976e+00  2.2125259e-01 */
    { 0xbecf6678,0x3f6b4843 }, /* 407: -4.0507865e-01  9.1907138e-01 */
    { 0xbf56957a,0x3f2b35b9 }, /* 408: -8.3821833e-01  6.6878849e-01 */
    { 0x3f229d9f,0x3f4e10b8 }, /* 409:  6.3521761e-01  8.0494261e-01 */
    { 0xbf2e93a8,0x3f46bef1 }, /* 410: -6.8194056e-01  7.7635103e-01 */
    { 0x3eb9ec53,0x3f6f4e59 }, /* 411:  3.6313114e-01  9.3478924e-01 */
    { 0xbfdd359a,0xbe2083d0 }, /* 412: -1.7281983e+00 -1.5675282e-01 */
    { 0x3f272b4f,0x3f4b54bf }, /* 413:  6.5300459e-01  7.9426187e-01 */
    { 0xbe93bb1e,0x3f756ad2 }, /* 414: -2.8853697e-01  9.5866120e-01 */
    { 0xbf9aeb74,0x3eb498e2 }, /* 415: -1.2103105e+00  3.5272890e-01 */
    { 0xbfacbf33,0x3e60ad73 }, /* 416: -1.3495849e+00  2.1941166e-01 */
    { 0xbe8f06e7,0x3f76137f }, /* 417: -2.7934954e-01  9.6123499e-01 */
    { 0x3fd2188b,0xbd906c50 }, /* 418:  1.6413740e+00 -7.0519090e-02 */
    { 0xbf5f88e9,0x3f2473b5 }, /* 419: -8.7318283e-01  6.4239055e-01 */
    { 0xc08c06b5,0xbea916c1 }, /* 420: -4.3758187e+00 -3.3025172e-01 */
    { 0xbf5990a4,0x3f28fb63 }, /* 421: -8.4986329e-01  6.6008586e-01 */
    { 0xbf9b76a2,0x3eb28f88 }, /* 422: -1.2145579e+00  3.4875131e-01 */
    { 0xbfb80ab8,0x3e07c275 }, /* 423: -1.4378271e+00  1.3257773e-01 */
    { 0x3f313055,0x3f4516d6 }, /* 424:  6.9214374e-01  7.6987970e-01 */
    { 0xbf5d1381,0x3f26541f }, /* 425: -8.6357886e-01  6.4972109e-01 */
    { 0xbf94c89d,0x3ecb5905 }, /* 426: -1.1623722e+00  3.9716354e-01 */
    { 0x3f309135,0x3f457c3d }, /* 427:  6.8971568e-01  7.7142698e-01 */
    { 0xbf9e7cae,0x3ea72d41 }, /* 428: -1.2381799e+00  3.2651713e-01 */
    { 0xbf237f98,0x3f4d8a53 }, /* 429: -6.3866568e-01  8.0289191e-01 */
    { 0x3f96adf0,0x3ec45dc1 }, /* 430:  1.1771832e+00  3.8352779e-01 */
    { 0xbfad1ff6,0x3e5db9f8 }, /* 431: -1.3525379e+00  2.1652973e-01 */
    { 0x3f5c2933,0x3f2705f6 }, /* 432:  8.6000365e-01  6.5243471e-01 */
    { 0x3fbd71c7,0x3db99fec }, /* 433:  1.4800347e+00  9.0637058e-02 */
    { 0xbf2e18fe,0x3f470c2b }, /* 434: -6.8006885e-01  7.7752942e-01 */
    { 0x3ea79d96,0x3f726761 }, /* 435:  3.2737416e-01  9.4688994e-01 */
    { 0xbf631c5f,0x3f21b209 }, /* 436: -8.8715166e-01  6.3162285e-01 */
    { 0x3f82d9fc,0x3f057c0c }, /* 437:  1.0222774e+00  5.2142406e-01 */
    { 0x40d01bb1,0x3f79d1a0 }, /* 438:  6.5033803e+00  9.7585487e-01 */
    { 0x3f619702,0x3f22df2a }, /* 439:  8.8121045e-01  6.3621771e-01 */
    { 0x3ec25d0a,0x3f6dc64b }, /* 440:  3.7961608e-01  9.2880696e-01 */
    { 0xc03ad685,0xbf79b415 }, /* 441: -2.9193432e+00 -9.7540408e-01 */
    { 0x3e465a3b,0x3f7b3659 }, /* 442:  1.9370358e-01  9.8129803e-01 */
    { 0x3f7fe722,0x3f0a662d }, /* 443:  9.9962056e-01  5.4062158e-01 */
    { 0xbca8b2a5,0x3f7ff21b }, /* 444: -2.0592997e-02  9.9978799e-01 */
    { 0xbf27152c,0x3f4b6231 }, /* 445: -6.5266681e-01  7.9446703e-01 */
    { 0xbecc3ae4,0x3f6be707 }, /* 446: -3.9888680e-01  9.2149395e-01 */
    { 0xbf33d338,0x3f436576 }, /* 447: -7.0244169e-01  7.6326692e-01 */
    { 0x3f9df6c2,0x3ea92739 }, /* 448:  1.2340930e+00  3.3037737e-01 */
    { 0xbeb78b10,0x3f6fb9e4 }, /* 449: -3.5848284e-01  9.3643022e-01 */
    { 0x3f62c66d,0x3f21f4a1 }, /* 450:  8.8584024e-01  6.3263899e-01 */
    { 0xbf63c2df,0x3f2130d1 }, /* 451: -8.8969225e-01  6.2965113e-01 */
    { 0x313379d0,0x3f800000 }, /* 452:  2.6117171e-09  1.0000000e+00 */
    { 0x403b0fb0,0xbf79e619 }, /* 453:  2.9228325e+00 -9.7616726e-01 */
    { 0xc051ab13,0xbf7db057 }, /* 454: -3.2760665e+00 -9.9097198e-01 */
    { 0xc0330225,0xbf70f37a }, /* 455: -2.7970059e+00 -9.4121516e-01 */
    { 0xbfb9d8c0,0x3df2df01 }, /* 456: -1.4519272e+00  1.1858941e-01 */
    { 0x400f404a,0xbf1e7885 }, /* 457:  2.2382989e+00 -6.1902648e-01 */
    { 0x3e0ed42e,0x3f7d8388 }, /* 458:  1.3948128e-01  9.9028826e-01 */
    { 0xbed99648,0x3f693a85 }, /* 459: -4.2497468e-01  9.1104919e-01 */
    { 0x3f219ef1,0x3f4ea76f }, /* 460:  6.3133150e-01  8.0724233e-01 */
    { 0x3f54b99c,0x3f2c9659 }, /* 461:  8.3095717e-01  6.7416912e-01 */
    { 0xbec7edbf,0x3f6cbabb }, /* 462: -3.9048573e-01  9.2472428e-01 */
    { 0x3ff4e4bf,0xbeabeb83 }, /* 463:  1.9132308e+00 -3.3578119e-01 */
    { 0x3ef85aa7,0x3f627806 }, /* 464:  4.8506662e-01  8.8464391e-01 */
    { 0xbf4e25f3,0x3f316325 }, /* 465: -8.0526656e-01  6.9291908e-01 */
    { 0x3fb68cc5,0x3e1394a6 }, /* 466:  1.4261709e+00  1.4412174e-01 */
    { 0xbf7f50ea,0x3f0ae475 }, /* 467: -9.9732840e-01  5.4254848e-01 */
    { 0x3f938a87,0x3ecfe63d }, /* 468:  1.1526650e+00  4.0605345e-01 */
    { 0x3f5fccf8,0x3f243f87 }, /* 469:  8.7422132e-01  6.4159435e-01 */
    { 0x3f50394d,0x3f2fe28b }, /* 470:  8.1337434e-01  6.8705052e-01 */
    { 0x3ecaa9cf,0x3f6c34a2 }, /* 471:  3.9582679e-01  9.2267811e-01 */
    { 0x3eac32ba,0x3f71a848 }, /* 472:  3.3632451e-01  9.4397402e-01 */
    { 0x3eaf3e67,0x3f712689 }, /* 473:  3.4227297e-01  9.4199425e-01 */
    { 0xc00dc2cc,0xbf19bf2f }, /* 474: -2.2150145e+00 -6.0057348e-01 */
    { 0x3fa1f28c,0x3e9a08c5 }, /* 475:  1.2652144e+00  3.0084816e-01 */
    { 0xbfb4ae31,0x3e225d23 }, /* 476: -1.4115659e+00  1.5855841e-01 */
    { 0xbe728a6a,0x3f78da44 }, /* 477: -2.3685613e-01  9.7208047e-01 */
    { 0xc000dd4b,0xbedb55f1 }, /* 478: -2.0135067e+00 -4.2839006e-01 */
    { 0x3f5a6ad3,0x3f285740 }, /* 479:  8.5319251e-01  6.5758133e-01 */
    { 0x3e7d50f3,0x3f7834ec }, /* 480:  2.4737911e-01  9.6955752e-01 */
    { 0x3e8c697d,0x3f766ef7 }, /* 481:  2.7424231e-01  9.6263069e-01 */
    { 0x3cfb9b76,0x3f7fe117 }, /* 482:  3.0713778e-02  9.9952835e-01 */
    { 0xbf296a9b,0x3f49f535 }, /* 483: -6.6178292e-01  7.8889781e-01 */
    { 0x3e585bba,0x3f7a4e98 }, /* 484:  2.1128741e-01  9.7776175e-01 */
    { 0xbfa8ba3a,0x3e7feef7 }, /* 485: -1.3181832e+00  2.4993502e-01 */
    { 0x3f593255,0x3f29422f }, /* 486:  8.4842426e-01  6.6116613e-01 */
    { 0xbdf5cfd0,0x3f7e2882 }, /* 487: -1.2002528e-01  9.9280560e-01 */
    { 0x404cd103,0xbf7f8f43 }, /* 488:  3.2002571e+00 -9.9827975e-01 */
    { 0xbfbdb5ab,0x3db5660b }, /* 489: -1.4821066e+00  8.8573538e-02 */
    { 0xbf24f72c,0x3f4ca992 }, /* 490: -6.4439654e-01  7.9946244e-01 */
    { 0xbee45fbc,0x3f66f40a }, /* 491: -4.4604290e-01  9.0216124e-01 */
    { 0xbecb1f2f,0x3f6c1dfb }, /* 492: -3.9672229e-01  9.2233247e-01 */
    { 0xbdaea2a3,0x3f7f11e2 }, /* 493: -8.5271142e-02  9.9636662e-01 */
    { 0xbef37440,0x3f6399ce }, /* 494: -4.7549629e-01  8.8906562e-01 */
    { 0xbed0bb50,0x3f6b04e6 }, /* 495: -4.0767908e-01  9.1804349e-01 */
    { 0x3c9c5f8c,0x3f7ff410 }, /* 496:  1.9088529e-02  9.9981785e-01 */
    { 0xbe92ba6b,0x3f758f39 }, /* 497: -2.8657851e-01  9.5921665e-01 */
    { 0xbf00bd3a,0x3f604e4b }, /* 498: -5.0288737e-01  8.7619466e-01 */
    { 0xbf1b797a,0x3f5238ca }, /* 499: -6.0732234e-01  8.2117903e-01 */
    { 0x3ede9adf,0x3f682ed7 }, /* 500:  4.3477532e-01  9.0696472e-01 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = cos (x.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 2) x_exit (i+1);
    }
    return 0;
}
