// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __string_source_h__
#define __string_source_h__

#include "Puma/Source.h"
#include <string.h>

namespace Puma {


class StringSource : public Source {
  const char *_string;
  int _delivered;
  int _len;

public:
  StringSource () : _string ((const char*)0) {}
  StringSource (const char *string) : _string (string) { 
    _delivered = 0; 
    _len = strlen (string);
  }

  virtual int read (char *dest, int n) {
    int to_copy;

    if (! _string || _delivered == _len)
      return 0;

    to_copy = (n < _len - _delivered) ? n : _len - _delivered;

    memcpy (dest, _string + _delivered, to_copy);
    _delivered += to_copy;

    return to_copy;
  }
  void string (const char *string) { 
    _string = string; 
    _delivered = 0;
    _len = strlen (_string); 
  }
  const char *string () { return _string; }
  int size () { return _len; }
};


} // namespace Puma

#endif /* __string_source_h__ */
