/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cobertura.CoverageIgnore;
import net.sourceforge.cobertura.coveragedata.BranchCoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.JumpData;
import net.sourceforge.cobertura.coveragedata.SwitchData;
import net.sourceforge.cobertura.util.StringUtil;

@CoverageIgnore
public class LineData
implements Comparable<Object>,
CoverageData,
Serializable {
    private static final long serialVersionUID = 4L;
    private long hits = 0L;
    private List<JumpData> jumps = null;
    private List<SwitchData> switches;
    private final int lineNumber;
    private String methodDescriptor;
    private String methodName;

    LineData(int lineNumber) {
        this(lineNumber, null, null);
    }

    LineData(int lineNumber, String methodName, String methodDescriptor) {
        this.lineNumber = lineNumber;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
    }

    @Override
    public int compareTo(Object o) {
        if (!o.getClass().equals(LineData.class)) {
            return Integer.MAX_VALUE;
        }
        return this.lineNumber - ((LineData)o).lineNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        LineData lineData = (LineData)obj;
        return this.hits == lineData.hits && (this.jumps == lineData.jumps || this.jumps != null && ((Object)this.jumps).equals(lineData.jumps)) && (this.switches == lineData.switches || this.switches != null && ((Object)this.switches).equals(lineData.switches)) && this.lineNumber == lineData.lineNumber && this.methodDescriptor.equals(lineData.methodDescriptor) && this.methodName.equals(lineData.methodName);
    }

    @Override
    public double getBranchCoverageRate() {
        if (this.getNumberOfValidBranches() == 0) {
            return 1.0;
        }
        return (double)this.getNumberOfCoveredBranches() / (double)this.getNumberOfValidBranches();
    }

    public String getConditionCoverage() {
        StringBuffer ret = new StringBuffer();
        if (this.getNumberOfValidBranches() == 0) {
            ret.append(StringUtil.getPercentValue(1.0));
        } else {
            ret.append(StringUtil.getPercentValue(this.getBranchCoverageRate()));
            ret.append(" (").append(this.getNumberOfCoveredBranches()).append("/").append(this.getNumberOfValidBranches()).append(")");
        }
        return ret.toString();
    }

    public long getHits() {
        return this.hits;
    }

    public synchronized boolean isCovered() {
        return this.getHits() > 0L && (this.getNumberOfValidBranches() == 0 || 1.0 - this.getBranchCoverageRate() < 1.0E-4);
    }

    @Override
    public double getLineCoverageRate() {
        return this.getHits() > 0L ? 1.0 : 0.0;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public int getNumberOfCoveredLines() {
        return this.getHits() > 0L ? 1 : 0;
    }

    @Override
    public int getNumberOfValidBranches() {
        int i;
        int ret = 0;
        if (this.jumps != null) {
            for (i = this.jumps.size() - 1; i >= 0; --i) {
                ret += this.jumps.get(i).getNumberOfValidBranches();
            }
        }
        if (this.switches != null) {
            for (i = this.switches.size() - 1; i >= 0; --i) {
                ret += this.switches.get(i).getNumberOfValidBranches();
            }
        }
        return ret;
    }

    @Override
    public int getNumberOfCoveredBranches() {
        int i;
        int ret = 0;
        if (this.jumps != null) {
            for (i = this.jumps.size() - 1; i >= 0; --i) {
                ret += this.jumps.get(i).getNumberOfCoveredBranches();
            }
        }
        if (this.switches != null) {
            for (i = this.switches.size() - 1; i >= 0; --i) {
                ret += this.switches.get(i).getNumberOfCoveredBranches();
            }
        }
        return ret;
    }

    @Override
    public int getNumberOfValidLines() {
        return 1;
    }

    public int hashCode() {
        return this.lineNumber;
    }

    public boolean hasBranch() {
        return this.jumps != null || this.switches != null;
    }

    @Override
    public synchronized void merge(CoverageData coverageData) {
        int i;
        LineData lineData = (LineData)coverageData;
        this.hits += lineData.hits;
        if (lineData.jumps != null) {
            if (this.jumps == null) {
                this.jumps = lineData.jumps;
            } else {
                for (i = Math.min(this.jumps.size(), lineData.jumps.size()) - 1; i >= 0; --i) {
                    this.jumps.get(i).merge(lineData.jumps.get(i));
                }
                for (i = Math.min(this.jumps.size(), lineData.jumps.size()); i < lineData.jumps.size(); ++i) {
                    this.jumps.add(lineData.jumps.get(i));
                }
            }
        }
        if (lineData.switches != null) {
            if (this.switches == null) {
                this.switches = lineData.switches;
            } else {
                for (i = Math.min(this.switches.size(), lineData.switches.size()) - 1; i >= 0; --i) {
                    this.switches.get(i).merge(lineData.switches.get(i));
                }
                for (i = Math.min(this.switches.size(), lineData.switches.size()); i < lineData.switches.size(); ++i) {
                    this.switches.add(lineData.switches.get(i));
                }
            }
        }
        if (lineData.methodName != null) {
            this.methodName = lineData.methodName;
        }
        if (lineData.methodDescriptor != null) {
            this.methodDescriptor = lineData.methodDescriptor;
        }
    }

    void addJump(int jumpNumber) {
        this.getJumpData(jumpNumber);
    }

    void addSwitch(int switchNumber, int min, int max, int maxBranches) {
        SwitchData sd = this.getSwitchData(switchNumber, new SwitchData(switchNumber, min, max, maxBranches));
        if (sd.getMaxBranches() > maxBranches) {
            sd.setMaxBranches(maxBranches);
        }
    }

    void setMethodNameAndDescriptor(String name, String descriptor) {
        this.methodName = name;
        this.methodDescriptor = descriptor;
    }

    void touch(int new_hits) {
        this.hits += (long)new_hits;
    }

    void touchJump(int jumpNumber, boolean branch, int hits) {
        this.getJumpData(jumpNumber).touchBranch(branch, hits);
    }

    void touchSwitch(int switchNumber, int branch, int hits) {
        this.getSwitchData(switchNumber, null).touchBranch(branch, hits);
    }

    public int getConditionSize() {
        return (this.jumps == null ? 0 : this.jumps.size()) + (this.switches == null ? 0 : this.switches.size());
    }

    public Object getConditionData(int index) {
        int switchesSize;
        BranchCoverageData branchData = null;
        int jumpsSize = this.jumps == null ? 0 : this.jumps.size();
        int n = switchesSize = this.switches == null ? 0 : this.switches.size();
        if (index < jumpsSize) {
            branchData = this.jumps.get(index);
        } else if (index < jumpsSize + switchesSize) {
            branchData = this.switches.get(index - jumpsSize);
        }
        return branchData;
    }

    public String getConditionCoverage(int index) {
        Object branchData = this.getConditionData(index);
        if (branchData == null) {
            return StringUtil.getPercentValue(1.0);
        }
        if (branchData instanceof JumpData) {
            JumpData jumpData = (JumpData)branchData;
            return StringUtil.getPercentValue(jumpData.getBranchCoverageRate());
        }
        SwitchData switchData = (SwitchData)branchData;
        return StringUtil.getPercentValue(switchData.getBranchCoverageRate());
    }

    synchronized JumpData getJumpData(int jumpNumber) {
        if (this.jumps == null) {
            this.jumps = new ArrayList<JumpData>();
        }
        if (this.jumps.size() <= jumpNumber) {
            int i = this.jumps.size();
            while (i <= jumpNumber) {
                this.jumps.add(new JumpData(i++));
            }
        }
        return this.jumps.get(jumpNumber);
    }

    synchronized SwitchData getSwitchData(int switchNumber, SwitchData data) {
        if (this.switches == null) {
            this.switches = new ArrayList<SwitchData>();
        }
        if (this.switches.size() < switchNumber) {
            int i = this.switches.size();
            while (i < switchNumber) {
                this.switches.add(new SwitchData(i++, Integer.MAX_VALUE));
            }
        }
        if (this.switches.size() == switchNumber) {
            if (data != null) {
                this.switches.add(data);
            } else {
                this.switches.add(new SwitchData(switchNumber, Integer.MAX_VALUE));
            }
        }
        return this.switches.get(switchNumber);
    }
}

