/* Generated By:JavaCC: Do not edit this line. MsfParser.java */
package es.uvigo.ei.sing.alter.parser;

import es.uvigo.ei.sing.alter.types.Msf;
import es.uvigo.ei.sing.alter.types.MsfSequence;
import java.io.StringReader;
import java.util.Vector;

/**
* MSF format parser.
* @author Daniel Gomez Blanco
* @version 1.2
*/
public class MsfParser implements MsfParserConstants {
  /**
  * Static method that parses an input string and returns a MSA in MSF format.
  * @param in Input string.
  * @return MSA in MSF format.
  */
  public static Msf parseMSA (String in) throws ParseException
    {
        //Parse string and return MSA
        MsfParser parser = new MsfParser(new StringReader(in));
        return parser.Msf();
    }

/**
* Grammar's root production. Structure:<br>
* &nbsp;&nbsp;1. Any combination of spaces, tabs and new lines until
* "PileUp", "!!AA_MULTIPLE_ALIGNMENT" or "!!NA_MULTIPLE_ALIGNMENT".<br>
* &nbsp;&nbsp;2. "PileUp", "!!AA_MULTIPLE_ALIGNMENT" or
* "!!NA_MULTIPLE_ALIGNMENT".<br>
* &nbsp;&nbsp;3. Any combination of characters until "MSF:".<br>
* &nbsp;&nbsp;4. "MSF:" followed by the MSA's length, "Type:"
* followed by the MSA's type and "Check:" followed by the MSA's total checksum.
* This lines ends with ".."<br>
* &nbsp;&nbsp;5. Sequence information block made up by lines starting with
* "Name:" followed by the sequence identifier and " oo"
* as a sequence identifier end delimiter, "Len:" followed by the sequence length
* (all must be equal), "Check:" followed by the sequence checksum and
* "Weight" followed by the sequence weight.<br>
* &nbsp;&nbsp;6. "//" as an information block delimiter.<br>
* &nbsp;&nbsp;7. Aligned sequences.
* @return MSA in MSF format.
*/
  final public Msf Msf() throws ParseException {
    Vector<MsfSequence> seqs = new Vector<MsfSequence>();
    String id,data;
    Token type;
    int total_length, length, total_check, check;
    float weight;
    int cont = 0;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        jj_consume_token(BLANK);
        break;
      case EOL:
        jj_consume_token(EOL);
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 7:
      jj_consume_token(7);
      break;
    case 8:
      jj_consume_token(8);
      break;
    case 9:
      jj_consume_token(9);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
        jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        jj_consume_token(NUMBER);
        break;
      case ANY:
        jj_consume_token(ANY);
        break;
      case 10:
        jj_consume_token(10);
        break;
      case 11:
        jj_consume_token(11);
        break;
      case 12:
        jj_consume_token(12);
        break;
      case 13:
        jj_consume_token(13);
        break;
      case 14:
        jj_consume_token(14);
        break;
      case 15:
        jj_consume_token(15);
        break;
      case 16:
        jj_consume_token(16);
        break;
      case 17:
        jj_consume_token(17);
        break;
      case 18:
        jj_consume_token(18);
        break;
      case 7:
        jj_consume_token(7);
        break;
      case 8:
        jj_consume_token(8);
        break;
      case 9:
        jj_consume_token(9);
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(19);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      jj_consume_token(BLANK);
    }
    total_length = Number();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      jj_consume_token(BLANK);
    }
    jj_consume_token(20);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_5;
      }
      jj_consume_token(BLANK);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 16:
      type = jj_consume_token(16);
      break;
    case 17:
      type = jj_consume_token(17);
      break;
    case 15:
      type = jj_consume_token(15);
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
        jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        jj_consume_token(NUMBER);
        break;
      case ANY:
        jj_consume_token(ANY);
        break;
      case 10:
        jj_consume_token(10);
        break;
      case 11:
        jj_consume_token(11);
        break;
      case 12:
        jj_consume_token(12);
        break;
      case 13:
        jj_consume_token(13);
        break;
      case 14:
        jj_consume_token(14);
        break;
      case 15:
        jj_consume_token(15);
        break;
      case 16:
        jj_consume_token(16);
        break;
      case 17:
        jj_consume_token(17);
        break;
      case 18:
        jj_consume_token(18);
        break;
      case 7:
        jj_consume_token(7);
        break;
      case 8:
        jj_consume_token(8);
        break;
      case 9:
        jj_consume_token(9);
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(21);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_7;
      }
      jj_consume_token(BLANK);
    }
    total_check = Number();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_8;
      }
      jj_consume_token(BLANK);
    }
    jj_consume_token(13);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_9;
      }
      jj_consume_token(BLANK);
    }
    label_10:
    while (true) {
      jj_consume_token(EOL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_10;
      }
    }
    label_11:
    while (true) {
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_12;
        }
        jj_consume_token(BLANK);
      }
      jj_consume_token(22);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_13;
        }
        jj_consume_token(BLANK);
      }
      id = Id();
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 14:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_14;
        }
        jj_consume_token(14);
        label_15:
        while (true) {
          jj_consume_token(BLANK);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BLANK:
            ;
            break;
          default:
            jj_la1[18] = jj_gen;
            break label_15;
          }
        }
      }
      jj_consume_token(23);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_16;
        }
        jj_consume_token(BLANK);
      }
      length = Number();
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_17;
        }
        jj_consume_token(BLANK);
      }
      jj_consume_token(21);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_18;
        }
        jj_consume_token(BLANK);
      }
      check = Number();
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[22] = jj_gen;
          break label_19;
        }
        jj_consume_token(BLANK);
      }
      jj_consume_token(24);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_20;
        }
        jj_consume_token(BLANK);
      }
      weight = Float();
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[24] = jj_gen;
          break label_21;
        }
        jj_consume_token(BLANK);
      }
      label_22:
      while (true) {
        jj_consume_token(EOL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_22;
        }
      }
            seqs.add(new MsfSequence(id,length,check,weight,""));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
      case 22:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_11;
      }
    }
    jj_consume_token(11);
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_23;
      }
      jj_consume_token(BLANK);
    }
    label_24:
    while (true) {
      jj_consume_token(EOL);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[28] = jj_gen;
          break label_25;
        }
        jj_consume_token(BLANK);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_24;
      }
    }
    label_26:
    while (true) {
      IdSeq(seqs.elementAt(cont).getId());
      jj_consume_token(BLANK);
      data = DataLine();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        label_27:
        while (true) {
          jj_consume_token(EOL);
          label_28:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[30] = jj_gen;
              break label_28;
            }
            jj_consume_token(BLANK);
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            ;
            break;
          default:
            jj_la1[31] = jj_gen;
            break label_27;
          }
        }
        break;
      case 0:
        jj_consume_token(0);
        break;
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            seqs.elementAt(cont).concat(data);
            cont++;
            if (cont == seqs.size())
                cont = 0;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 15:
      case 16:
      case 17:
      case 18:
        ;
        break;
      default:
        jj_la1[33] = jj_gen;
        break label_26;
      }
    }
    jj_consume_token(0);
        {if (true) return new Msf(seqs, total_length, type.image, total_check);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a number.
* @return Parsed number.
*/
  final public int Number() throws ParseException {
    String s = "";
    Token t;
    label_29:
    while (true) {
      t = jj_consume_token(NUMBER);
            s = s.concat(t.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        ;
        break;
      default:
        jj_la1[34] = jj_gen;
        break label_29;
      }
    }
        {if (true) return Integer.parseInt(s);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a floating point number.
* @return Parsed float.
*/
  final public Float Float() throws ParseException {
    int n1, n2;
    n1 = Number();
    jj_consume_token(12);
    n2 = Number();
        {if (true) return Float.parseFloat(String.valueOf(n1) + "." + String.valueOf(n2));}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a sequence identifier. An identifier can be made up of any sequence
* of characters, including spaces and tabs, but it must not start with any of those.
* The string " oo" indicates the end of the identifier.
* @return Sequence identifier.
*/
  final public String Id() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UPPER_CASE:
      t = jj_consume_token(UPPER_CASE);
      break;
    case LOWER_CASE:
      t = jj_consume_token(LOWER_CASE);
      break;
    case NUMBER:
      t = jj_consume_token(NUMBER);
      break;
    case ANY:
      t = jj_consume_token(ANY);
      break;
    case 10:
      t = jj_consume_token(10);
      break;
    case 12:
      t = jj_consume_token(12);
      break;
    case 11:
      t = jj_consume_token(11);
      break;
    case 13:
      t = jj_consume_token(13);
      break;
    case 16:
      t = jj_consume_token(16);
      break;
    case 17:
      t = jj_consume_token(17);
      break;
    case 15:
      t = jj_consume_token(15);
      break;
    case 18:
      t = jj_consume_token(18);
      break;
    case 7:
      t = jj_consume_token(7);
      break;
    case 8:
      t = jj_consume_token(8);
      break;
    case 9:
      t = jj_consume_token(9);
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            s.append(t.image);
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 15:
      case 16:
      case 17:
      case 18:
        ;
        break;
      default:
        jj_la1[36] = jj_gen;
        break label_30;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        t = jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
        t = jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        t = jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case ANY:
        t = jj_consume_token(ANY);
        break;
      case 10:
        t = jj_consume_token(10);
        break;
      case 12:
        t = jj_consume_token(12);
        break;
      case 11:
        t = jj_consume_token(11);
        break;
      case 13:
        t = jj_consume_token(13);
        break;
      case 16:
        t = jj_consume_token(16);
        break;
      case 17:
        t = jj_consume_token(17);
        break;
      case 15:
        t = jj_consume_token(15);
        break;
      case 18:
        t = jj_consume_token(18);
        break;
      case 7:
        t = jj_consume_token(7);
        break;
      case 8:
        t = jj_consume_token(8);
        break;
      case 9:
        t = jj_consume_token(9);
        break;
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            s.append(t.image);
    }
        {if (true) return s.toString().trim();}
    throw new Error("Missing return statement in function");
  }

/**
* Same behaviour as Id(), but in this case equality between the already read
* identifier and the current one is checked.
* @param id Identifier to parse.
*/
  final public void IdSeq(String id) throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UPPER_CASE:
      t = jj_consume_token(UPPER_CASE);
      break;
    case LOWER_CASE:
      t = jj_consume_token(LOWER_CASE);
      break;
    case NUMBER:
      t = jj_consume_token(NUMBER);
      break;
    case ANY:
      t = jj_consume_token(ANY);
      break;
    case 10:
      t = jj_consume_token(10);
      break;
    case 12:
      t = jj_consume_token(12);
      break;
    case 11:
      t = jj_consume_token(11);
      break;
    case 13:
      t = jj_consume_token(13);
      break;
    case 16:
      t = jj_consume_token(16);
      break;
    case 17:
      t = jj_consume_token(17);
      break;
    case 15:
      t = jj_consume_token(15);
      break;
    case 18:
      t = jj_consume_token(18);
      break;
    case 7:
      t = jj_consume_token(7);
      break;
    case 8:
      t = jj_consume_token(8);
      break;
    case 9:
      t = jj_consume_token(9);
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            s.append(t.image);
            if (id.length() == s.length())
                if (id.equals(s.toString()))
                    {if (true) return;}
                else
                    {if (true) throw new ParseException("ID for sequence \u005c"" + id
                            + "\u005c"does not match with ID in line " + t.beginLine);}
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 15:
      case 16:
      case 17:
      case 18:
        ;
        break;
      default:
        jj_la1[39] = jj_gen;
        break label_31;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        t = jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
        t = jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        t = jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case ANY:
        t = jj_consume_token(ANY);
        break;
      case 10:
        t = jj_consume_token(10);
        break;
      case 12:
        t = jj_consume_token(12);
        break;
      case 11:
        t = jj_consume_token(11);
        break;
      case 13:
        t = jj_consume_token(13);
        break;
      case 16:
        t = jj_consume_token(16);
        break;
      case 17:
        t = jj_consume_token(17);
        break;
      case 15:
        t = jj_consume_token(15);
        break;
      case 18:
        t = jj_consume_token(18);
        break;
      case 7:
        t = jj_consume_token(7);
        break;
      case 8:
        t = jj_consume_token(8);
        break;
      case 9:
        t = jj_consume_token(9);
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            s.append(t.image);
            if (id.length() == s.length())
                if (id.equals(s.toString()))
                    {if (true) return;}
                else
                    {if (true) throw new ParseException("ID for sequence \u005c"" + id
                            + "\u005c"does not match with ID in line " + t.beginLine);}
    }
        {if (true) throw new ParseException("ID for sequence \u005c"" + id
                            + "\u005c"does not match with ID in line " + t.beginLine);}
  }

/**
* Parses a data line. A data line can be made up of characters from "A" to "Z"
* (lowercase and uppercase), "." or "?". Spaces and tabs are omitted.
* @return String with the data line (always uppercase).
*/
  final public String DataLine() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        t = jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
      case LOWER_CASE:
      case 10:
      case 12:
      case 13:
      case 15:
      case 16:
      case 17:
      case 18:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 18:
          t = jj_consume_token(18);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        default:
          jj_la1[41] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                s.append(t.image);
        break;
      default:
        jj_la1[42] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case 10:
      case 12:
      case 13:
      case 15:
      case 16:
      case 17:
      case 18:
        ;
        break;
      default:
        jj_la1[43] = jj_gen;
        break label_32;
      }
    }
        {if (true) return (s.toString().toUpperCase()).replace('.','-');}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public MsfParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[44];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x6,0x6,0x380,0x7fffe,0x7fffe,0x4,0x4,0x4,0x38000,0x7fffe,0x7fffe,0x4,0x4,0x4,0x2,0x4,0x4,0x4000,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x2,0x400004,0x4,0x4,0x2,0x4,0x2,0x3,0x7bff8,0x20,0x7bff8,0x7bffc,0x7bffc,0x7bff8,0x7bffc,0x7bffc,0x7b418,0x7b41c,0x7b41c,};
   }

  /** Constructor with InputStream. */
  public MsfParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public MsfParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new MsfParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 44; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 44; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public MsfParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new MsfParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 44; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 44; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public MsfParser(MsfParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 44; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(MsfParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 44; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[25];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 44; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 25; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
