#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test template expansion.
#
# $Id: lookup.py 8878 2007-03-14 05:38:02Z andrewm $

import unittest
import albatross
import albatross_test

class TemplateTestCase(albatross_test.AlbatrossTestCase):
    template_dir = "lookup"
    lookup_cases = (
        (0,	"Zero"),
        (1,	"One"),
        (2,	"Two"),
        (3,	"Many"),
        (4,	"Many"),
        (-1,	"Many"),
        (20,	"Many")
    )

    def test_cases(self, template, cases):
        for i, result in cases:
            self.ctx.locals.i = i
            self.html_test(template, result)

class InlineCase(TemplateTestCase):
    def check_enum(self):
        self.test_cases('inline.html', self.lookup_cases)

class FileTemplateCase(TemplateTestCase):
    def check_enum(self):
        self.test_cases('lookup.html', self.lookup_cases)

    def check_no_default(self):
        no_default_cases = (
            (0,	"Zero"),
            (1,	"One"),
            (2,	""),
            (20, ""),
        )
        self.test_cases('no-default.html', no_default_cases)

    def check_no_close(self):
        self.test_raise("no-close.html")

# This differs from the previous class because it generates the html output by
# feeding in a string to the templating code.

class StringTemplateCase(TemplateTestCase):
    template_string = '''
<al-lookup name="xlat">
 <al-item expr="0">Zero</al-item>
 <al-item expr="1">One</al-item>
 <al-item expr="2">Two</al-item>
 Many</al-lookup>
<al-value expr="i" lookup="xlat">
'''
    def check_enum(self):
        for i, result in self.lookup_cases:
            self.ctx.locals.i = i
            self.test_str_html(self.template_string, result)


class TemplateSuite(unittest.TestSuite):
    test_list = (
        "check_enum",
        "check_no_default",
        "check_no_close",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(FileTemplateCase, self.test_list))
        self.addTest(InlineCase("check_enum"))
        self.addTest(StringTemplateCase("check_enum"))

def suite():
    return TemplateSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')


