/*
 * MAPI property tag declarations
 *
 * Copyright 2004 Jon Griffiths
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

/*
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if any license choice
 * other than GPL or LGPL is available it will apply instead, Oracle elects to use only
 * the Lesser General Public License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the language indicating
 * that LGPLv2 or any later version may be used, or where a choice of which version
 * of the LGPL is applied is otherwise unspecified.
 */

#ifndef MAPITAGS_H
#define MAPITAGS_H

#define FIsTransmittable(t) (PROP_ID(t) < 0x0E00 || PROP_ID(t) >= 0x8000 || \
 (PROP_ID(t) >= 0x1000 && PROP_ID(t) < 0x6000) || \
 (PROP_ID(t) >= 0x6800 && PROP_ID(t) < 0x7C00))

#define PR_ACKNOWLEDGEMENT_MODE PROP_TAG(PT_I4,0x01)
#define PR_ALTERNATE_RECIPIENT_ALLOWED PROP_TAG(PT_BOOLEAN,0x02)
#define PR_AUTHORIZING_USERS PROP_TAG(PT_BINARY,0x03)
/* Comment on an automatically forwarded message */
#define PR_AUTO_FORWARD_COMMENT_W PROP_TAG(PT_UNICODE,0x04)
#define PR_AUTO_FORWARD_COMMENT_A PROP_TAG(PT_STRING8,0x04)
#define PR_AUTO_FORWARD_COMMENT   WINELIB_NAME_AW(PR_AUTO_FORWARD_COMMENT_)
/* Whether a message has been automatically forwarded */
#define PR_AUTO_FORWARDED PROP_TAG(PT_BOOLEAN,0x05)
#define PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID PROP_TAG(PT_BINARY,0x06)
#define PR_CONTENT_CORRELATOR PROP_TAG(PT_BINARY,0x07)
#define PR_CONTENT_IDENTIFIER_W PROP_TAG(PT_UNICODE,0x08)
#define PR_CONTENT_IDENTIFIER_A PROP_TAG(PT_STRING8,0x08)
#define PR_CONTENT_IDENTIFIER   WINELIB_NAME_AW(PR_CONTENT_IDENTIFIER_)
/* MIME content length */
#define PR_CONTENT_LENGTH PROP_TAG(PT_I4,0x09)
#define PR_CONTENT_RETURN_REQUESTED PROP_TAG(PT_BOOLEAN,0x0A)
#define PR_CONVERSATION_KEY PROP_TAG(PT_BINARY,0x0B)
#define PR_CONVERSION_EITS PROP_TAG(PT_BINARY,0x0C)
#define PR_CONVERSION_WITH_LOSS_PROHIBITED PROP_TAG(PT_BOOLEAN,0x0D)
#define PR_CONVERTED_EITS PROP_TAG(PT_BINARY,0x0E)
/* Time to deliver for delayed delivery messages */
#define PR_DEFERRED_DELIVERY_TIME PROP_TAG(PT_SYSTIME,0x0F)
#define PR_DELIVER_TIME PROP_TAG(PT_SYSTIME,0x10)
/* Reason a message was discarded */
#define PR_DISCARD_REASON PROP_TAG(PT_I4,0x11)
#define PR_DISCLOSURE_OF_RECIPIENTS PROP_TAG(PT_BOOLEAN,0x12)
#define PR_DL_EXPANSION_HISTORY PROP_TAG(PT_BINARY,0x13)
#define PR_DL_EXPANSION_PROHIBITED PROP_TAG(PT_BOOLEAN,0x14)
#define PR_EXPIRY_TIME PROP_TAG(PT_SYSTIME,0x15)
#define PR_IMPLICIT_CONVERSION_PROHIBITED PROP_TAG(PT_BOOLEAN,0x16)
/* Message importance */
#define PR_IMPORTANCE PROP_TAG(PT_I4,0x17)
#define PR_IPM_ID PROP_TAG(PT_BINARY,0x18)
#define PR_LATEST_DELIVERY_TIME PROP_TAG(PT_SYSTIME,0x19)
#define PR_MESSAGE_CLASS_W PROP_TAG(PT_UNICODE,0x1A)
#define PR_MESSAGE_CLASS_A PROP_TAG(PT_STRING8,0x1A)
#define PR_MESSAGE_CLASS   WINELIB_NAME_AW(PR_MESSAGE_CLASS_)
#define PR_MESSAGE_DELIVERY_ID PROP_TAG(PT_BINARY,0x1B)
#define PR_MESSAGE_SECURITY_LABEL PROP_TAG(PT_BINARY,0x1E)
#define PR_OBSOLETED_IPMS PROP_TAG(PT_BINARY,0x1F)
/* Person a message was originally for */
#define PR_ORIGINALLY_INTENDED_RECIPIENT_NAME PROP_TAG(PT_BINARY,0x20)
#define PR_ORIGINAL_EITS PROP_TAG(PT_BINARY,0x21)
#define PR_ORIGINATOR_CERTIFICATE PROP_TAG(PT_BINARY,0x22)
#define PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED PROP_TAG(PT_BOOLEAN,0x23)
/* Address of the message sender */
#define PR_ORIGINATOR_RETURN_ADDRESS PROP_TAG(PT_BINARY,0x24)
#define PR_PARENT_KEY PROP_TAG(PT_BINARY,0x25)
#define PR_PRIORITY PROP_TAG(PT_I4,0x26)
#define PR_ORIGIN_CHECK PROP_TAG(PT_BINARY,0x27)
#define PR_PROOF_OF_SUBMISSION_REQUESTED PROP_TAG(PT_BOOLEAN,0x28)
/* Whether a read receipt is desired */
#define PR_READ_RECEIPT_REQUESTED PROP_TAG(PT_BOOLEAN,0x29)
/* Time a message was received */
#define PR_RECEIPT_TIME PROP_TAG(PT_SYSTIME,0x2A)
#define PR_RECIPIENT_REASSIGNMENT_PROHIBITED PROP_TAG(PT_BOOLEAN,0x2B)
#define PR_REDIRECTION_HISTORY PROP_TAG(PT_BINARY,0x2C)
#define PR_RELATED_IPMS PROP_TAG(PT_BINARY,0x2D)
/* Sensitivity of the original message */
#define PR_ORIGINAL_SENSITIVITY PROP_TAG(PT_I4,0x2E)
#define PR_LANGUAGES_W PROP_TAG(PT_UNICODE,0x2F)
#define PR_LANGUAGES_A PROP_TAG(PT_STRING8,0x2F)
#define PR_LANGUAGES   WINELIB_NAME_AW(PR_LANGUAGES_)
#define PR_REPLY_TIME PROP_TAG(PT_SYSTIME,0x30)
#define PR_REPORT_TAG PROP_TAG(PT_BINARY,0x31)
#define PR_REPORT_TIME PROP_TAG(PT_SYSTIME,0x32)
#define PR_RETURNED_IPM PROP_TAG(PT_BOOLEAN,0x33)
#define PR_SECURITY PROP_TAG(PT_I4,0x34)
#define PR_INCOMPLETE_COPY PROP_TAG(PT_BOOLEAN,0x35)
#define PR_SENSITIVITY PROP_TAG(PT_I4,0x36)
/* The message subject */
#define PR_SUBJECT_W PROP_TAG(PT_UNICODE,0x37)
#define PR_SUBJECT_A PROP_TAG(PT_STRING8,0x37)
#define PR_SUBJECT   WINELIB_NAME_AW(PR_SUBJECT_)
#define PR_SUBJECT_IPM PROP_TAG(PT_BINARY,0x38)
#define PR_CLIENT_SUBMIT_TIME PROP_TAG(PT_SYSTIME,0x39)
#define PR_REPORT_NAME_W PROP_TAG(PT_UNICODE,0x3A)
#define PR_REPORT_NAME_A PROP_TAG(PT_STRING8,0x3A)
#define PR_REPORT_NAME   WINELIB_NAME_AW(PR_REPORT_NAME_)
#define PR_SENT_REPRESENTING_SEARCH_KEY PROP_TAG(PT_BINARY,0x3B)
#define PR_X400_CONTENT_TYPE PROP_TAG(PT_BINARY,0x3C)
#define PR_SUBJECT_PREFIX_W PROP_TAG(PT_UNICODE,0x3D)
#define PR_SUBJECT_PREFIX_A PROP_TAG(PT_STRING8,0x3D)
#define PR_SUBJECT_PREFIX   WINELIB_NAME_AW(PR_SUBJECT_PREFIX_)
#define PR_NON_RECEIPT_REASON PROP_TAG(PT_I4,0x3E)
#define PR_RECEIVED_BY_ENTRYID PROP_TAG(PT_BINARY,0x3F)
/* Received by: entry */
#define PR_RECEIVED_BY_NAME_W PROP_TAG(PT_UNICODE,0x40)
#define PR_RECEIVED_BY_NAME_A PROP_TAG(PT_STRING8,0x40)
#define PR_RECEIVED_BY_NAME   WINELIB_NAME_AW(PR_RECEIVED_BY_NAME_)
#define PR_SENT_REPRESENTING_ENTRYID PROP_TAG(PT_BINARY,0x41)
#define PR_SENT_REPRESENTING_NAME_W PROP_TAG(PT_UNICODE,0x42)
#define PR_SENT_REPRESENTING_NAME_A PROP_TAG(PT_STRING8,0x42)
#define PR_SENT_REPRESENTING_NAME   WINELIB_NAME_AW(PR_SENT_REPRESENTING_NAME_)
#define PR_RCVD_REPRESENTING_ENTRYID PROP_TAG(PT_BINARY,0x43)
#define PR_RCVD_REPRESENTING_NAME_W PROP_TAG(PT_UNICODE,0x44)
#define PR_RCVD_REPRESENTING_NAME_A PROP_TAG(PT_STRING8,0x44)
#define PR_RCVD_REPRESENTING_NAME   WINELIB_NAME_AW(PR_RCVD_REPRESENTING_NAME_)
#define PR_REPORT_ENTRYID PROP_TAG(PT_BINARY,0x45)
#define PR_READ_RECEIPT_ENTRYID PROP_TAG(PT_BINARY,0x46)
#define PR_MESSAGE_SUBMISSION_ID PROP_TAG(PT_BINARY,0x47)
#define PR_PROVIDER_SUBMIT_TIME PROP_TAG(PT_SYSTIME,0x48)
/* Subject of the original message */
#define PR_ORIGINAL_SUBJECT_W PROP_TAG(PT_UNICODE,0x49)
#define PR_ORIGINAL_SUBJECT_A PROP_TAG(PT_STRING8,0x49)
#define PR_ORIGINAL_SUBJECT   WINELIB_NAME_AW(PR_ORIGINAL_SUBJECT_)
#define PR_DISC_VAL PROP_TAG(PT_BOOLEAN,0x4A)
#define PR_ORIG_MESSAGE_CLASS_W PROP_TAG(PT_UNICODE,0x4B)
#define PR_ORIG_MESSAGE_CLASS_A PROP_TAG(PT_STRING8,0x4B)
#define PR_ORIG_MESSAGE_CLASS   WINELIB_NAME_AW(PR_ORIG_MESSAGE_CLASS_)
#define PR_ORIGINAL_AUTHOR_ENTRYID PROP_TAG(PT_BINARY,0x4C)
/* Author of the original message */
#define PR_ORIGINAL_AUTHOR_NAME_W PROP_TAG(PT_UNICODE,0x4D)
#define PR_ORIGINAL_AUTHOR_NAME_A PROP_TAG(PT_STRING8,0x4D)
#define PR_ORIGINAL_AUTHOR_NAME   WINELIB_NAME_AW(PR_ORIGINAL_AUTHOR_NAME_)
/* Time the original message was submitted */
#define PR_ORIGINAL_SUBMIT_TIME PROP_TAG(PT_SYSTIME,0x4E)
#define PR_REPLY_RECIPIENT_ENTRIES PROP_TAG(PT_BINARY,0x4F)
#define PR_REPLY_RECIPIENT_NAMES_W PROP_TAG(PT_UNICODE,0x50)
#define PR_REPLY_RECIPIENT_NAMES_A PROP_TAG(PT_STRING8,0x50)
#define PR_REPLY_RECIPIENT_NAMES   WINELIB_NAME_AW(PR_REPLY_RECIPIENT_NAMES_)
#define PR_RECEIVED_BY_SEARCH_KEY PROP_TAG(PT_BINARY,0x51)
#define PR_RCVD_REPRESENTING_SEARCH_KEY PROP_TAG(PT_BINARY,0x52)
#define PR_READ_RECEIPT_SEARCH_KEY PROP_TAG(PT_BINARY,0x53)
#define PR_REPORT_SEARCH_KEY PROP_TAG(PT_BINARY,0x54)
#define PR_ORIGINAL_DELIVERY_TIME PROP_TAG(PT_SYSTIME,0x55)
#define PR_ORIGINAL_AUTHOR_SEARCH_KEY PROP_TAG(PT_BINARY,0x56)
#define PR_MESSAGE_TO_ME PROP_TAG(PT_BOOLEAN,0x57)
#define PR_MESSAGE_CC_ME PROP_TAG(PT_BOOLEAN,0x58)
#define PR_MESSAGE_RECIP_ME PROP_TAG(PT_BOOLEAN,0x59)
/* Sender of the original message */
#define PR_ORIGINAL_SENDER_NAME_W PROP_TAG(PT_UNICODE,0x5A)
#define PR_ORIGINAL_SENDER_NAME_A PROP_TAG(PT_STRING8,0x5A)
#define PR_ORIGINAL_SENDER_NAME   WINELIB_NAME_AW(PR_ORIGINAL_SENDER_NAME_)
#define PR_ORIGINAL_SENDER_ENTRYID PROP_TAG(PT_BINARY,0x5B)
#define PR_ORIGINAL_SENDER_SEARCH_KEY PROP_TAG(PT_BINARY,0x5C)
#define PR_ORIGINAL_SENT_REPRESENTING_NAME_W PROP_TAG(PT_UNICODE,0x5D)
#define PR_ORIGINAL_SENT_REPRESENTING_NAME_A PROP_TAG(PT_STRING8,0x5D)
#define PR_ORIGINAL_SENT_REPRESENTING_NAME   WINELIB_NAME_AW(PR_ORIGINAL_SENT_REPRESENTING_NAME_)
#define PR_ORIGINAL_SENT_REPRESENTING_ENTRYID PROP_TAG(PT_BINARY,0x5E)
#define PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY PROP_TAG(PT_BINARY,0x5F)
#define PR_START_DATE PROP_TAG(PT_SYSTIME,0x60)
#define PR_END_DATE PROP_TAG(PT_SYSTIME,0x61)
#define PR_OWNER_APPT_ID PROP_TAG(PT_I4,0x62)
/* Whether a response to the message is desired */
#define PR_RESPONSE_REQUESTED PROP_TAG(PT_BOOLEAN,0x63)
#define PR_SENT_REPRESENTING_ADDRTYPE_W PROP_TAG(PT_UNICODE,0x64)
#define PR_SENT_REPRESENTING_ADDRTYPE_A PROP_TAG(PT_STRING8,0x64)
#define PR_SENT_REPRESENTING_ADDRTYPE   WINELIB_NAME_AW(PR_SENT_REPRESENTING_ADDRTYPE_)
#define PR_SENT_REPRESENTING_EMAIL_ADDRESS_W PROP_TAG(PT_UNICODE,0x65)
#define PR_SENT_REPRESENTING_EMAIL_ADDRESS_A PROP_TAG(PT_STRING8,0x65)
#define PR_SENT_REPRESENTING_EMAIL_ADDRESS   WINELIB_NAME_AW(PR_SENT_REPRESENTING_EMAIL_ADDRESS_)
#define PR_ORIGINAL_SENDER_ADDRTYPE_W PROP_TAG(PT_UNICODE,0x66)
#define PR_ORIGINAL_SENDER_ADDRTYPE_A PROP_TAG(PT_STRING8,0x66)
#define PR_ORIGINAL_SENDER_ADDRTYPE   WINELIB_NAME_AW(PR_ORIGINAL_SENDER_ADDRTYPE_)
/* Email of the original message sender */
#define PR_ORIGINAL_SENDER_EMAIL_ADDRESS_W PROP_TAG(PT_UNICODE,0x67)
#define PR_ORIGINAL_SENDER_EMAIL_ADDRESS_A PROP_TAG(PT_STRING8,0x67)
#define PR_ORIGINAL_SENDER_EMAIL_ADDRESS   WINELIB_NAME_AW(PR_ORIGINAL_SENDER_EMAIL_ADDRESS_)
#define PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_W PROP_TAG(PT_UNICODE,0x68)
#define PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_A PROP_TAG(PT_STRING8,0x68)
#define PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE   WINELIB_NAME_AW(PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE_)
#define PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_W PROP_TAG(PT_UNICODE,0x69)
#define PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_A PROP_TAG(PT_STRING8,0x69)
#define PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS   WINELIB_NAME_AW(PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS_)
#define PR_CONVERSATION_TOPIC_W PROP_TAG(PT_UNICODE,0x70)
#define PR_CONVERSATION_TOPIC_A PROP_TAG(PT_STRING8,0x70)
#define PR_CONVERSATION_TOPIC   WINELIB_NAME_AW(PR_CONVERSATION_TOPIC_)
#define PR_CONVERSATION_INDEX PROP_TAG(PT_BINARY,0x71)
#define PR_ORIGINAL_DISPLAY_BCC_W PROP_TAG(PT_UNICODE,0x72)
#define PR_ORIGINAL_DISPLAY_BCC_A PROP_TAG(PT_STRING8,0x72)
#define PR_ORIGINAL_DISPLAY_BCC   WINELIB_NAME_AW(PR_ORIGINAL_DISPLAY_BCC_)
#define PR_ORIGINAL_DISPLAY_CC_W PROP_TAG(PT_UNICODE,0x73)
#define PR_ORIGINAL_DISPLAY_CC_A PROP_TAG(PT_STRING8,0x73)
#define PR_ORIGINAL_DISPLAY_CC   WINELIB_NAME_AW(PR_ORIGINAL_DISPLAY_CC_)
#define PR_ORIGINAL_DISPLAY_TO_W PROP_TAG(PT_UNICODE,0x74)
#define PR_ORIGINAL_DISPLAY_TO_A PROP_TAG(PT_STRING8,0x74)
#define PR_ORIGINAL_DISPLAY_TO   WINELIB_NAME_AW(PR_ORIGINAL_DISPLAY_TO_)
#define PR_RECEIVED_BY_ADDRTYPE_W PROP_TAG(PT_UNICODE,0x75)
#define PR_RECEIVED_BY_ADDRTYPE_A PROP_TAG(PT_STRING8,0x75)
#define PR_RECEIVED_BY_ADDRTYPE   WINELIB_NAME_AW(PR_RECEIVED_BY_ADDRTYPE_)
#define PR_RECEIVED_BY_EMAIL_ADDRESS_W PROP_TAG(PT_UNICODE,0x76)
#define PR_RECEIVED_BY_EMAIL_ADDRESS_A PROP_TAG(PT_STRING8,0x76)
#define PR_RECEIVED_BY_EMAIL_ADDRESS   WINELIB_NAME_AW(PR_RECEIVED_BY_EMAIL_ADDRESS_)
#define PR_RCVD_REPRESENTING_ADDRTYPE_W PROP_TAG(PT_UNICODE,0x77)
#define PR_RCVD_REPRESENTING_ADDRTYPE_A PROP_TAG(PT_STRING8,0x77)
#define PR_RCVD_REPRESENTING_ADDRTYPE   WINELIB_NAME_AW(PR_RCVD_REPRESENTING_ADDRTYPE_)
#define PR_RCVD_REPRESENTING_EMAIL_ADDRESS_W PROP_TAG(PT_UNICODE,0x78)
#define PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A PROP_TAG(PT_STRING8,0x78)
#define PR_RCVD_REPRESENTING_EMAIL_ADDRESS   WINELIB_NAME_AW(PR_RCVD_REPRESENTING_EMAIL_ADDRESS_)
#define PR_ORIGINAL_AUTHOR_ADDRTYPE_W PROP_TAG(PT_UNICODE,0x79)
#define PR_ORIGINAL_AUTHOR_ADDRTYPE_A PROP_TAG(PT_STRING8,0x79)
#define PR_ORIGINAL_AUTHOR_ADDRTYPE   WINELIB_NAME_AW(PR_ORIGINAL_AUTHOR_ADDRTYPE_)
#define PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_W PROP_TAG(PT_UNICODE,0x7A)
#define PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_A PROP_TAG(PT_STRING8,0x7A)
#define PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS   WINELIB_NAME_AW(PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS_)
#define PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_W PROP_TAG(PT_UNICODE,0x7B)
#define PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_A PROP_TAG(PT_STRING8,0x7B)
#define PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE   WINELIB_NAME_AW(PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE_)
#define PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_W PROP_TAG(PT_UNICODE,0x7C)
#define PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_A PROP_TAG(PT_STRING8,0x7C)
#define PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS   WINELIB_NAME_AW(PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS_)
#define PR_TRANSPORT_MESSAGE_HEADERS_W PROP_TAG(PT_UNICODE,0x7D)
#define PR_TRANSPORT_MESSAGE_HEADERS_A PROP_TAG(PT_STRING8,0x7D)
#define PR_TRANSPORT_MESSAGE_HEADERS   WINELIB_NAME_AW(PR_TRANSPORT_MESSAGE_HEADERS_)
#define PR_DELEGATION PROP_TAG(PT_BINARY,0x7E)
#define PR_TNEF_CORRELATION_KEY PROP_TAG(PT_BINARY,0x7F)
#define PR_BODY_W PROP_TAG(PT_UNICODE,0x1000)
#define PR_BODY_A PROP_TAG(PT_STRING8,0x1000)
#define PR_BODY   WINELIB_NAME_AW(PR_BODY_)
#define PR_REPORT_TEXT_W PROP_TAG(PT_UNICODE,0x1001)
#define PR_REPORT_TEXT_A PROP_TAG(PT_STRING8,0x1001)
#define PR_REPORT_TEXT   WINELIB_NAME_AW(PR_REPORT_TEXT_)
#define PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY PROP_TAG(PT_BINARY,0x1002)
#define PR_REPORTING_DL_NAME PROP_TAG(PT_BINARY,0x1003)
#define PR_REPORTING_MTA_CERTIFICATE PROP_TAG(PT_BINARY,0x1004)
#define PR_RTF_SYNC_BODY_CRC PROP_TAG(PT_I4,0x1006)
#define PR_RTF_SYNC_BODY_COUNT PROP_TAG(PT_I4,0x1007)
#define PR_RTF_SYNC_BODY_TAG_W PROP_TAG(PT_UNICODE,0x1008)
#define PR_RTF_SYNC_BODY_TAG_A PROP_TAG(PT_STRING8,0x1008)
#define PR_RTF_SYNC_BODY_TAG   WINELIB_NAME_AW(PR_RTF_SYNC_BODY_TAG_)
#define PR_RTF_COMPRESSED PROP_TAG(PT_BINARY,0x1009)
#define PR_RTF_SYNC_PREFIX_COUNT PROP_TAG(PT_I4,0x1010)
#define PR_RTF_SYNC_TRAILING_COUNT PROP_TAG(PT_I4,0x1011)
#define PR_ORIGINALLY_INTENDED_RECIP_ENTRYID PROP_TAG(PT_BINARY,0x1012)
#define PR_CONTENT_INTEGRITY_CHECK PROP_TAG(PT_BINARY,0x0C00)
#define PR_EXPLICIT_CONVERSION PROP_TAG(PT_I4,0x0C01)
#define PR_IPM_RETURN_REQUESTED PROP_TAG(PT_BOOLEAN,0x0C02)
#define PR_MESSAGE_TOKEN PROP_TAG(PT_BINARY,0x0C03)
#define PR_NDR_REASON_CODE PROP_TAG(PT_I4,0x0C04)
#define PR_NDR_DIAG_CODE PROP_TAG(PT_I4,0x0C05)
#define PR_NON_RECEIPT_NOTIFICATION_REQUESTED PROP_TAG(PT_BOOLEAN,0x0C06)
#define PR_DELIVERY_POINT PROP_TAG(PT_I4,0x0C07)
#define PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED PROP_TAG(PT_BOOLEAN,0x0C08)
#define PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT PROP_TAG(PT_BINARY,0x0C09)
#define PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY PROP_TAG(PT_BOOLEAN,0x0C0A)
#define PR_PHYSICAL_DELIVERY_MODE PROP_TAG(PT_I4,0x0C0B)
#define PR_PHYSICAL_DELIVERY_REPORT_REQUEST PROP_TAG(PT_I4,0x0C0C)
#define PR_PHYSICAL_FORWARDING_ADDRESS PROP_TAG(PT_BINARY,0x0C0D)
#define PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED PROP_TAG(PT_BOOLEAN,0x0C0E)
#define PR_PHYSICAL_FORWARDING_PROHIBITED PROP_TAG(PT_BOOLEAN,0x0C0F)
#define PR_PHYSICAL_RENDITION_ATTRIBUTES PROP_TAG(PT_BINARY,0x0C10)
#define PR_PROOF_OF_DELIVERY PROP_TAG(PT_BINARY,0x0C11)
#define PR_PROOF_OF_DELIVERY_REQUESTED PROP_TAG(PT_BOOLEAN,0x0C12)
#define PR_RECIPIENT_CERTIFICATE PROP_TAG(PT_BINARY,0x0C13)
#define PR_RECIPIENT_NUMBER_FOR_ADVICE_W PROP_TAG(PT_UNICODE,0x0C14)
#define PR_RECIPIENT_NUMBER_FOR_ADVICE_A PROP_TAG(PT_STRING8,0x0C14)
#define PR_RECIPIENT_NUMBER_FOR_ADVICE   WINELIB_NAME_AW(PR_RECIPIENT_NUMBER_FOR_ADVICE_)
#define PR_RECIPIENT_TYPE PROP_TAG(PT_I4,0x0C15)
#define PR_REGISTERED_MAIL_TYPE PROP_TAG(PT_I4,0x0C16)
#define PR_REPLY_REQUESTED PROP_TAG(PT_BOOLEAN,0x0C17)
#define PR_REQUESTED_DELIVERY_METHOD PROP_TAG(PT_I4,0x0C18)
#define PR_SENDER_ENTRYID PROP_TAG(PT_BINARY,0x0C19)
#define PR_SENDER_NAME_W PROP_TAG(PT_UNICODE,0x0C1A)
#define PR_SENDER_NAME_A PROP_TAG(PT_STRING8,0x0C1A)
#define PR_SENDER_NAME   WINELIB_NAME_AW(PR_SENDER_NAME_)
#define PR_SUPPLEMENTARY_INFO_W PROP_TAG(PT_UNICODE,0x0C1B)
#define PR_SUPPLEMENTARY_INFO_A PROP_TAG(PT_STRING8,0x0C1B)
#define PR_SUPPLEMENTARY_INFO   WINELIB_NAME_AW(PR_SUPPLEMENTARY_INFO_)
#define PR_TYPE_OF_MTS_USER PROP_TAG(PT_I4,0x0C1C)
#define PR_SENDER_SEARCH_KEY PROP_TAG(PT_BINARY,0x0C1D)
#define PR_SENDER_ADDRTYPE_W PROP_TAG(PT_UNICODE,0x0C1E)
#define PR_SENDER_ADDRTYPE_A PROP_TAG(PT_STRING8,0x0C1E)
#define PR_SENDER_ADDRTYPE   WINELIB_NAME_AW(PR_SENDER_ADDRTYPE_)
#define PR_SENDER_EMAIL_ADDRESS_W PROP_TAG(PT_UNICODE,0x0C1F)
#define PR_SENDER_EMAIL_ADDRESS_A PROP_TAG(PT_STRING8,0x0C1F)
#define PR_SENDER_EMAIL_ADDRESS   WINELIB_NAME_AW(PR_SENDER_EMAIL_ADDRESS_)
#define PR_CURRENT_VERSION PROP_TAG(PT_I8,0x0E00)
#define PR_DELETE_AFTER_SUBMIT PROP_TAG(PT_BOOLEAN,0x0E01)
#define PR_DISPLAY_BCC_W PROP_TAG(PT_UNICODE,0x0E02)
#define PR_DISPLAY_BCC_A PROP_TAG(PT_STRING8,0x0E02)
#define PR_DISPLAY_BCC   WINELIB_NAME_AW(PR_DISPLAY_BCC_)
#define PR_DISPLAY_CC_W PROP_TAG(PT_UNICODE,0x0E03)
#define PR_DISPLAY_CC_A PROP_TAG(PT_STRING8,0x0E03)
#define PR_DISPLAY_CC   WINELIB_NAME_AW(PR_DISPLAY_CC_)
#define PR_DISPLAY_TO_W PROP_TAG(PT_UNICODE,0x0E04)
#define PR_DISPLAY_TO_A PROP_TAG(PT_STRING8,0x0E04)
#define PR_DISPLAY_TO   WINELIB_NAME_AW(PR_DISPLAY_TO_)
#define PR_PARENT_DISPLAY_W PROP_TAG(PT_UNICODE,0x0E05)
#define PR_PARENT_DISPLAY_A PROP_TAG(PT_STRING8,0x0E05)
#define PR_PARENT_DISPLAY   WINELIB_NAME_AW(PR_PARENT_DISPLAY_)
#define PR_MESSAGE_DELIVERY_TIME PROP_TAG(PT_SYSTIME,0x0E06)
#define PR_MESSAGE_FLAGS PROP_TAG(PT_I4,0x0E07)
#define PR_MESSAGE_SIZE PROP_TAG(PT_I4,0x0E08)
#define PR_PARENT_ENTRYID PROP_TAG(PT_BINARY,0x0E09)
#define PR_SENTMAIL_ENTRYID PROP_TAG(PT_BINARY,0x0E0A)
#define PR_CORRELATE PROP_TAG(PT_BOOLEAN,0x0E0C)
#define PR_CORRELATE_MTSID PROP_TAG(PT_BINARY,0x0E0D)
#define PR_DISCRETE_VALUES PROP_TAG(PT_BOOLEAN,0x0E0E)
#define PR_RESPONSIBILITY PROP_TAG(PT_BOOLEAN,0x0E0F)
#define PR_SPOOLER_STATUS PROP_TAG(PT_I4,0x0E10)
#define PR_TRANSPORT_STATUS PROP_TAG(PT_I4,0x0E11)
#define PR_MESSAGE_RECIPIENTS PROP_TAG(PT_OBJECT,0x0E12)
#define PR_MESSAGE_ATTACHMENTS PROP_TAG(PT_OBJECT,0x0E13)
#define PR_SUBMIT_FLAGS PROP_TAG(PT_I4,0x0E14)
#define PR_RECIPIENT_STATUS PROP_TAG(PT_I4,0x0E15)
#define PR_TRANSPORT_KEY PROP_TAG(PT_I4,0x0E16)
#define PR_MSG_STATUS PROP_TAG(PT_I4,0x0E17)
#define PR_MESSAGE_DOWNLOAD_TIME PROP_TAG(PT_I4,0x0E18)
#define PR_CREATION_VERSION PROP_TAG(PT_I8,0x0E19)
#define PR_MODIFY_VERSION PROP_TAG(PT_I8,0x0E1A)
#define PR_HASATTACH PROP_TAG(PT_BOOLEAN,0x0E1B)
#define PR_BODY_CRC PROP_TAG(PT_I4, 0x0E1C)
#define PR_NORMALIZED_SUBJECT_W PROP_TAG(PT_UNICODE,0x0E1D)
#define PR_NORMALIZED_SUBJECT_A PROP_TAG(PT_STRING8,0x0E1D)
#define PR_NORMALIZED_SUBJECT   WINELIB_NAME_AW(PR_NORMALIZED_SUBJECT_)
#define PR_RTF_IN_SYNC PROP_TAG(PT_BOOLEAN,0x0E1F)
#define PR_ATTACH_SIZE PROP_TAG(PT_I4,0x0E20)
#define PR_ATTACH_NUM PROP_TAG(PT_I4,0x0E21)
#define PR_PREPROCESS PROP_TAG(PT_BOOLEAN,0x0E22)
#define PR_ORIGINATING_MTA_CERTIFICATE PROP_TAG(PT_BINARY,0x0E25)
#define PR_PROOF_OF_SUBMISSION PROP_TAG(PT_BINARY,0x0E26)
/* A unique identifier for editing the properties of a MAPI object */
#define PR_ENTRYID PROP_TAG(PT_BINARY,0x0FFF)
/* The type of an object */
#define PR_OBJECT_TYPE PROP_TAG(PT_I4,0x0FFE)
#define PR_ICON PROP_TAG(PT_BINARY,0x0FFD)
#define PR_MINI_ICON PROP_TAG(PT_BINARY,0x0FFC)
#define PR_STORE_ENTRYID PROP_TAG(PT_BINARY,0x0FFB)
#define PR_STORE_RECORD_KEY PROP_TAG(PT_BINARY,0x0FFA)
/* Binary identifier for an individual object */
#define PR_RECORD_KEY PROP_TAG(PT_BINARY,0x0FF9)
#define PR_MAPPING_SIGNATURE PROP_TAG(PT_BINARY,0x0FF8)
#define PR_ACCESS_LEVEL PROP_TAG(PT_I4,0x0FF7)
/* The primary key of a column in a table */
#define PR_INSTANCE_KEY PROP_TAG(PT_BINARY,0x0FF6)
#define PR_ROW_TYPE PROP_TAG(PT_I4,0x0FF5)
#define PR_ACCESS PROP_TAG(PT_I4,0x0FF4)
#define PR_ROWID PROP_TAG(PT_I4,0x3000)
/* The name to display for a given MAPI object */
#define PR_DISPLAY_NAME_W PROP_TAG(PT_UNICODE,0x3001)
#define PR_DISPLAY_NAME_A PROP_TAG(PT_STRING8,0x3001)
#define PR_DISPLAY_NAME   WINELIB_NAME_AW(PR_DISPLAY_NAME_)
#define PR_ADDRTYPE_W PROP_TAG(PT_UNICODE,0x3002)
#define PR_ADDRTYPE_A PROP_TAG(PT_STRING8,0x3002)
#define PR_ADDRTYPE   WINELIB_NAME_AW(PR_ADDRTYPE_)
/* An email address */
#define PR_EMAIL_ADDRESS_W PROP_TAG(PT_UNICODE,0x3003)
#define PR_EMAIL_ADDRESS_A PROP_TAG(PT_STRING8,0x3003)
#define PR_EMAIL_ADDRESS   WINELIB_NAME_AW(PR_EMAIL_ADDRESS_)
/* A comment field */
#define PR_COMMENT_W PROP_TAG(PT_UNICODE,0x3004)
#define PR_COMMENT_A PROP_TAG(PT_STRING8,0x3004)
#define PR_COMMENT   WINELIB_NAME_AW(PR_COMMENT_)
#define PR_DEPTH PROP_TAG(PT_I4,0x3005)
/* Provider-defined display name for a service provider */
#define PR_PROVIDER_DISPLAY_W PROP_TAG(PT_UNICODE,0x3006)
#define PR_PROVIDER_DISPLAY_A PROP_TAG(PT_STRING8,0x3006)
#define PR_PROVIDER_DISPLAY   WINELIB_NAME_AW(PR_PROVIDER_DISPLAY_)
/* The time an object was created */
#define PR_CREATION_TIME PROP_TAG(PT_SYSTIME,0x3007)
/* The time an object was last modified */
#define PR_LAST_MODIFICATION_TIME PROP_TAG(PT_SYSTIME,0x3008)
/* Flags describing a service provider, message service, or status object */
#define PR_RESOURCE_FLAGS PROP_TAG(PT_I4,0x3009)
/* The name of a provider dll, minus any "32" suffix and ".dll" */
#define PR_PROVIDER_DLL_NAME_W PROP_TAG(PT_UNICODE,0x300A)
#define PR_PROVIDER_DLL_NAME_A PROP_TAG(PT_STRING8,0x300A)
#define PR_PROVIDER_DLL_NAME   WINELIB_NAME_AW(PR_PROVIDER_DLL_NAME_)
#define PR_SEARCH_KEY PROP_TAG(PT_BINARY,0x300B)
#define PR_PROVIDER_UID PROP_TAG(PT_BINARY,0x300C)
#define PR_PROVIDER_ORDINAL PROP_TAG(PT_I4,0x300D)
#define PR_FORM_VERSION_W PROP_TAG(PT_UNICODE,0x3301)
#define PR_FORM_VERSION_A PROP_TAG(PT_STRING8,0x3301)
#define PR_FORM_VERSION   WINELIB_NAME_AW(PR_FORM_VERSION_)
#define PR_FORM_CLSID PROP_TAG(PT_CLSID,0x3302)
#define PR_FORM_CONTACT_NAME_W PROP_TAG(PT_UNICODE,0x3303)
#define PR_FORM_CONTACT_NAME_A PROP_TAG(PT_STRING8,0x3303)
#define PR_FORM_CONTACT_NAME   WINELIB_NAME_AW(PR_FORM_CONTACT_NAME_)
#define PR_FORM_CATEGORY_W PROP_TAG(PT_UNICODE,0x3304)
#define PR_FORM_CATEGORY_A PROP_TAG(PT_STRING8,0x3304)
#define PR_FORM_CATEGORY   WINELIB_NAME_AW(PR_FORM_CATEGORY_)
#define PR_FORM_CATEGORY_SUB_W PROP_TAG(PT_UNICODE,0x3305)
#define PR_FORM_CATEGORY_SUB_A PROP_TAG(PT_STRING8,0x3305)
#define PR_FORM_CATEGORY_SUB   WINELIB_NAME_AW(PR_FORM_CATEGORY_SUB_)
#define PR_FORM_HOST_MAP PROP_TAG(PT_MV_LONG,0x3306)
#define PR_FORM_HIDDEN PROP_TAG(PT_BOOLEAN,0x3307)
#define PR_FORM_DESIGNER_NAME_W PROP_TAG(PT_UNICODE,0x3308)
#define PR_FORM_DESIGNER_NAME_A PROP_TAG(PT_STRING8,0x3308)
#define PR_FORM_DESIGNER_NAME   WINELIB_NAME_AW(PR_FORM_DESIGNER_NAME_)
#define PR_FORM_DESIGNER_GUID PROP_TAG(PT_CLSID,0x3309)
#define PR_FORM_MESSAGE_BEHAVIOR PROP_TAG(PT_I4,0x330A)
/* Is this row the default message store? */
#define PR_DEFAULT_STORE PROP_TAG(PT_BOOLEAN,0x3400)
#define PR_STORE_SUPPORT_MASK PROP_TAG(PT_I4,0x340D)
#define PR_STORE_STATE PROP_TAG(PT_I4,0x340E)
#define PR_IPM_SUBTREE_SEARCH_KEY PROP_TAG(PT_BINARY,0x3410)
#define PR_IPM_OUTBOX_SEARCH_KEY PROP_TAG(PT_BINARY,0x3411)
#define PR_IPM_WASTEBASKET_SEARCH_KEY PROP_TAG(PT_BINARY,0x3412)
#define PR_IPM_SENTMAIL_SEARCH_KEY PROP_TAG(PT_BINARY,0x3413)
/* Provider-defined message store type */
#define PR_MDB_PROVIDER PROP_TAG(PT_BINARY,0x3414)
#define PR_RECEIVE_FOLDER_SETTINGS PROP_TAG(PT_OBJECT,0x3415)
#define PR_VALID_FOLDER_MASK PROP_TAG(PT_I4,0x35DF)
#define PR_IPM_SUBTREE_ENTRYID PROP_TAG(PT_BINARY,0x35E0)
#define PR_IPM_OUTBOX_ENTRYID PROP_TAG(PT_BINARY,0x35E2)
#define PR_IPM_WASTEBASKET_ENTRYID PROP_TAG(PT_BINARY,0x35E3)
#define PR_IPM_SENTMAIL_ENTRYID PROP_TAG(PT_BINARY,0x35E4)
#define PR_VIEWS_ENTRYID PROP_TAG(PT_BINARY,0x35E5)
#define PR_COMMON_VIEWS_ENTRYID PROP_TAG(PT_BINARY,0x35E6)
#define PR_FINDER_ENTRYID PROP_TAG(PT_BINARY,0x35E7)
#define PR_CONTAINER_FLAGS PROP_TAG(PT_I4,0x3600)
#define PR_FOLDER_TYPE PROP_TAG(PT_I4,0x3601)
#define PR_CONTENT_COUNT PROP_TAG(PT_I4,0x3602)
#define PR_CONTENT_UNREAD PROP_TAG(PT_I4,0x3603)
#define PR_CREATE_TEMPLATES PROP_TAG(PT_OBJECT,0x3604)
#define PR_DETAILS_TABLE PROP_TAG(PT_OBJECT,0x3605)
#define PR_SEARCH PROP_TAG(PT_OBJECT,0x3607)
#define PR_SELECTABLE PROP_TAG(PT_BOOLEAN,0x3609)
#define PR_SUBFOLDERS PROP_TAG(PT_BOOLEAN,0x360A)
#define PR_STATUS PROP_TAG(PT_I4,0x360B)
#define PR_ANR_W PROP_TAG(PT_UNICODE,0x360C)
#define PR_ANR_A PROP_TAG(PT_STRING8,0x360C)
#define PR_ANR   WINELIB_NAME_AW(PR_ANR_)
#define PR_CONTENTS_SORT_ORDER PROP_TAG(PT_MV_LONG,0x360D)
#define PR_CONTAINER_HIERARCHY PROP_TAG(PT_OBJECT,0x360E)
#define PR_CONTAINER_CONTENTS PROP_TAG(PT_OBJECT,0x360F)
#define PR_FOLDER_ASSOCIATED_CONTENTS PROP_TAG(PT_OBJECT,0x3610)
#define PR_DEF_CREATE_DL PROP_TAG(PT_BINARY,0x3611)
#define PR_DEF_CREATE_MAILUSER PROP_TAG(PT_BINARY,0x3612)
#define PR_CONTAINER_CLASS_W PROP_TAG(PT_UNICODE,0x3613)
#define PR_CONTAINER_CLASS_A PROP_TAG(PT_STRING8,0x3613)
#define PR_CONTAINER_CLASS   WINELIB_NAME_AW(PR_CONTAINER_CLASS_)
#define PR_CONTAINER_MODIFY_VERSION PROP_TAG(PT_I8,0x3614)
#define PR_AB_PROVIDER_ID PROP_TAG(PT_BINARY,0x3615)
#define PR_DEFAULT_VIEW_ENTRYID PROP_TAG(PT_BINARY,0x3616)
#define PR_ASSOC_CONTENT_COUNT PROP_TAG(PT_I4,0x3617)
#define PR_IPM_DRAFTS_ENTRYID PROP_TAG(PT_BINARY,0x36D7)
#define PR_ATTACHMENT_X400_PARAMETERS PROP_TAG(PT_BINARY,0x3700)
#define PR_ATTACH_DATA_OBJ PROP_TAG(PT_OBJECT,0x3701)
#define PR_ATTACH_DATA_BIN PROP_TAG(PT_BINARY,0x3701)
#define PR_ATTACH_ENCODING PROP_TAG(PT_BINARY,0x3702)
#define PR_ATTACH_EXTENSION_W PROP_TAG(PT_UNICODE,0x3703)
#define PR_ATTACH_EXTENSION_A PROP_TAG(PT_STRING8,0x3703)
#define PR_ATTACH_EXTENSION   WINELIB_NAME_AW(PR_ATTACH_EXTENSION_)
#define PR_ATTACH_FILENAME_W PROP_TAG(PT_UNICODE,0x3704)
#define PR_ATTACH_FILENAME_A PROP_TAG(PT_STRING8,0x3704)
#define PR_ATTACH_FILENAME   WINELIB_NAME_AW(PR_ATTACH_FILENAME_)
#define PR_ATTACH_METHOD PROP_TAG(PT_I4,0x3705)
#define PR_ATTACH_LONG_FILENAME_W PROP_TAG(PT_UNICODE,0x3707)
#define PR_ATTACH_LONG_FILENAME_A PROP_TAG(PT_STRING8,0x3707)
#define PR_ATTACH_LONG_FILENAME   WINELIB_NAME_AW(PR_ATTACH_LONG_FILENAME_)
#define PR_ATTACH_PATHNAME_W PROP_TAG(PT_UNICODE,0x3708)
#define PR_ATTACH_PATHNAME_A PROP_TAG(PT_STRING8,0x3708)
#define PR_ATTACH_PATHNAME   WINELIB_NAME_AW(PR_ATTACH_PATHNAME_)
#define PR_ATTACH_RENDERING PROP_TAG(PT_BINARY, 0x3709)
#define PR_ATTACH_TAG PROP_TAG(PT_BINARY,0x370A)
#define PR_RENDERING_POSITION PROP_TAG(PT_I4,0x370B)
#define PR_ATTACH_TRANSPORT_NAME_W PROP_TAG(PT_UNICODE,0x370C)
#define PR_ATTACH_TRANSPORT_NAME_A PROP_TAG(PT_STRING8,0x370C)
#define PR_ATTACH_TRANSPORT_NAME   WINELIB_NAME_AW(PR_ATTACH_TRANSPORT_NAME_)
#define PR_ATTACH_LONG_PATHNAME_W PROP_TAG(PT_UNICODE,0x370D)
#define PR_ATTACH_LONG_PATHNAME_A PROP_TAG(PT_STRING8,0x370D)
#define PR_ATTACH_LONG_PATHNAME   WINELIB_NAME_AW(PR_ATTACH_LONG_PATHNAME_)
#define PR_ATTACH_MIME_TAG_W PROP_TAG(PT_UNICODE,0x370E)
#define PR_ATTACH_MIME_TAG_A PROP_TAG(PT_STRING8,0x370E)
#define PR_ATTACH_MIME_TAG   WINELIB_NAME_AW(PR_ATTACH_MIME_TAG_)
#define PR_ATTACH_ADDITIONAL_INFO PROP_TAG(PT_BINARY,0x370F)
#define PR_DISPLAY_TYPE PROP_TAG(PT_I4,0x3900)
#define PR_TEMPLATEID PROP_TAG(PT_BINARY,0x3902)
#define PR_PRIMARY_CAPABILITY PROP_TAG(PT_BINARY,0x3904)
#define PR_7BIT_DISPLAY_NAME PROP_TAG(PT_STRING8,0x39FF)
#define PR_ACCOUNT_W PROP_TAG(PT_UNICODE,0x3A00)
#define PR_ACCOUNT_A PROP_TAG(PT_STRING8,0x3A00)
#define PR_ACCOUNT   WINELIB_NAME_AW(PR_ACCOUNT_)
#define PR_ALTERNATE_RECIPIENT PROP_TAG(PT_BINARY,0x3A01)
#define PR_CALLBACK_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A02)
#define PR_CALLBACK_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A02)
#define PR_CALLBACK_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_CALLBACK_TELEPHONE_NUMBER_)
#define PR_CONVERSION_PROHIBITED PROP_TAG(PT_BOOLEAN,0x3A03)
#define PR_DISCLOSE_RECIPIENTS PROP_TAG(PT_BOOLEAN,0x3A04)
#define PR_GENERATION_W PROP_TAG(PT_UNICODE,0x3A05)
#define PR_GENERATION_A PROP_TAG(PT_STRING8,0x3A05)
#define PR_GENERATION   WINELIB_NAME_AW(PR_GENERATION_)
#define PR_GIVEN_NAME_W PROP_TAG(PT_UNICODE,0x3A06)
#define PR_GIVEN_NAME_A PROP_TAG(PT_STRING8,0x3A06)
#define PR_GIVEN_NAME   WINELIB_NAME_AW(PR_GIVEN_NAME_)
#define PR_GOVERNMENT_ID_NUMBER_W PROP_TAG(PT_UNICODE,0x3A07)
#define PR_GOVERNMENT_ID_NUMBER_A PROP_TAG(PT_STRING8,0x3A07)
#define PR_GOVERNMENT_ID_NUMBER   WINELIB_NAME_AW(PR_GOVERNMENT_ID_NUMBER_)
#define PR_BUSINESS_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A08)
#define PR_BUSINESS_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A08)
#define PR_BUSINESS_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_BUSINESS_TELEPHONE_NUMBER_)
#define PR_OFFICE_TELEPHONE_NUMBER_W PR_BUSINESS_TELEPHONE_NUMBER_W
#define PR_OFFICE_TELEPHONE_NUMBER_A PR_BUSINESS_TELEPHONE_NUMBER_A
#define PR_OFFICE_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_OFFICE_TELEPHONE_NUMBER_)
#define PR_HOME_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A09)
#define PR_HOME_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A09)
#define PR_HOME_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_HOME_TELEPHONE_NUMBER_)
#define PR_INITIALS_W PROP_TAG(PT_UNICODE,0x3A0A)
#define PR_INITIALS_A PROP_TAG(PT_STRING8,0x3A0A)
#define PR_INITIALS   WINELIB_NAME_AW(PR_INITIALS_)
#define PR_KEYWORD_W PROP_TAG(PT_UNICODE,0x3A0B)
#define PR_KEYWORD_A PROP_TAG(PT_STRING8,0x3A0B)
#define PR_KEYWORD   WINELIB_NAME_AW(PR_KEYWORD_)
#define PR_LANGUAGE_W PROP_TAG(PT_UNICODE,0x3A0C)
#define PR_LANGUAGE_A PROP_TAG(PT_STRING8,0x3A0C)
#define PR_LANGUAGE   WINELIB_NAME_AW(PR_LANGUAGE_)
#define PR_LOCATION_W PROP_TAG(PT_UNICODE,0x3A0D)
#define PR_LOCATION_A PROP_TAG(PT_STRING8,0x3A0D)
#define PR_LOCATION   WINELIB_NAME_AW(PR_LOCATION_)
#define PR_MAIL_PERMISSION PROP_TAG(PT_BOOLEAN,0x3A0E)
#define PR_MHS_COMMON_NAME_W PROP_TAG(PT_UNICODE,0x3A0F)
#define PR_MHS_COMMON_NAME_A PROP_TAG(PT_STRING8,0x3A0F)
#define PR_MHS_COMMON_NAME   WINELIB_NAME_AW(PR_MHS_COMMON_NAME_)
#define PR_ORGANIZATIONAL_ID_NUMBER_W PROP_TAG(PT_UNICODE,0x3A10)
#define PR_ORGANIZATIONAL_ID_NUMBER_A PROP_TAG(PT_STRING8,0x3A10)
#define PR_ORGANIZATIONAL_ID_NUMBER   WINELIB_NAME_AW(PR_ORGANIZATIONAL_ID_NUMBER_)
#define PR_SURNAME_W PROP_TAG(PT_UNICODE,0x3A11)
#define PR_SURNAME_A PROP_TAG(PT_STRING8,0x3A11)
#define PR_SURNAME   WINELIB_NAME_AW(PR_SURNAME_)
#define PR_ORIGINAL_ENTRYID PROP_TAG(PT_BINARY,0x3A12)
#define PR_ORIGINAL_DISPLAY_NAME_W PROP_TAG(PT_UNICODE,0x3A13)
#define PR_ORIGINAL_DISPLAY_NAME_A PROP_TAG(PT_STRING8,0x3A13)
#define PR_ORIGINAL_DISPLAY_NAME   WINELIB_NAME_AW(PR_ORIGINAL_DISPLAY_NAME_)
#define PR_ORIGINAL_SEARCH_KEY PROP_TAG(PT_BINARY,0x3A14)
#define PR_POSTAL_ADDRESS_W PROP_TAG(PT_UNICODE,0x3A15)
#define PR_POSTAL_ADDRESS_A PROP_TAG(PT_STRING8,0x3A15)
#define PR_POSTAL_ADDRESS   WINELIB_NAME_AW(PR_POSTAL_ADDRESS_)
#define PR_COMPANY_NAME_W PROP_TAG(PT_UNICODE,0x3A16)
#define PR_COMPANY_NAME_A PROP_TAG(PT_STRING8,0x3A16)
#define PR_COMPANY_NAME   WINELIB_NAME_AW(PR_COMPANY_NAME_)
#define PR_TITLE_W PROP_TAG(PT_UNICODE,0x3A17)
#define PR_TITLE_A PROP_TAG(PT_STRING8,0x3A17)
#define PR_TITLE   WINELIB_NAME_AW(PR_TITLE_)
#define PR_DEPARTMENT_NAME_W PROP_TAG(PT_UNICODE,0x3A18)
#define PR_DEPARTMENT_NAME_A PROP_TAG(PT_STRING8,0x3A18)
#define PR_DEPARTMENT_NAME   WINELIB_NAME_AW(PR_DEPARTMENT_NAME_)
#define PR_OFFICE_LOCATION_W PROP_TAG(PT_UNICODE,0x3A19)
#define PR_OFFICE_LOCATION_A PROP_TAG(PT_STRING8,0x3A19)
#define PR_OFFICE_LOCATION   WINELIB_NAME_AW(PR_OFFICE_LOCATION_)
#define PR_PRIMARY_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A1A)
#define PR_PRIMARY_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A1A)
#define PR_PRIMARY_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_PRIMARY_TELEPHONE_NUMBER_)
#define PR_BUSINESS2_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A1B)
#define PR_BUSINESS2_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A1B)
#define PR_BUSINESS2_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_BUSINESS2_TELEPHONE_NUMBER_)
#define PR_OFFICE2_TELEPHONE_NUMBER_W PR_BUSINESS2_TELEPHONE_NUMBER_W
#define PR_OFFICE2_TELEPHONE_NUMBER_A PR_BUSINESS2_TELEPHONE_NUMBER_A
#define PR_OFFICE2_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_OFFICE2_TELEPHONE_NUMBER_)
#define PR_MOBILE_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A1C)
#define PR_MOBILE_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A1C)
#define PR_MOBILE_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_MOBILE_TELEPHONE_NUMBER_)
#define PR_CELLULAR_TELEPHONE_NUMBER_W PR_MOBILE_TELEPHONE_NUMBER_W
#define PR_CELLULAR_TELEPHONE_NUMBER_A PR_MOBILE_TELEPHONE_NUMBER_A
#define PR_CELLULAR_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_CELLULAR_TELEPHONE_NUMBER_)
#define PR_RADIO_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A1D)
#define PR_RADIO_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A1D)
#define PR_RADIO_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_RADIO_TELEPHONE_NUMBER_)
#define PR_CAR_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A1E)
#define PR_CAR_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A1E)
#define PR_CAR_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_CAR_TELEPHONE_NUMBER_)
#define PR_OTHER_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A1F)
#define PR_OTHER_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A1F)
#define PR_OTHER_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_OTHER_TELEPHONE_NUMBER_)
#define PR_TRANSMITABLE_DISPLAY_NAME_W PROP_TAG(PT_UNICODE,0x3A20)
#define PR_TRANSMITABLE_DISPLAY_NAME_A PROP_TAG(PT_STRING8,0x3A20)
#define PR_TRANSMITABLE_DISPLAY_NAME   WINELIB_NAME_AW(PR_TRANSMITABLE_DISPLAY_NAME_)
#define PR_PAGER_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A21)
#define PR_PAGER_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A21)
#define PR_PAGER_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_PAGER_TELEPHONE_NUMBER_)
#define PR_BEEPER_TELEPHONE_NUMBER_W PR_PAGER_TELEPHONE_NUMBER_W
#define PR_BEEPER_TELEPHONE_NUMBER_A PR_PAGER_TELEPHONE_NUMBER_A
#define PR_BEEPER_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_BEEPER_TELEPHONE_NUMBER_)
#define PR_USER_CERTIFICATE PROP_TAG(PT_BINARY,0x3A22)
#define PR_PRIMARY_FAX_NUMBER_W PROP_TAG(PT_UNICODE,0x3A23)
#define PR_PRIMARY_FAX_NUMBER_A PROP_TAG(PT_STRING8,0x3A23)
#define PR_PRIMARY_FAX_NUMBER   WINELIB_NAME_AW(PR_PRIMARY_FAX_NUMBER_)
#define PR_BUSINESS_FAX_NUMBER_W PROP_TAG(PT_UNICODE,0x3A24)
#define PR_BUSINESS_FAX_NUMBER_A PROP_TAG(PT_STRING8,0x3A24)
#define PR_BUSINESS_FAX_NUMBER   WINELIB_NAME_AW(PR_BUSINESS_FAX_NUMBER_)
#define PR_HOME_FAX_NUMBER_W PROP_TAG(PT_UNICODE,0x3A25)
#define PR_HOME_FAX_NUMBER_A PROP_TAG(PT_STRING8,0x3A25)
#define PR_HOME_FAX_NUMBER   WINELIB_NAME_AW(PR_HOME_FAX_NUMBER_)
#define PR_COUNTRY_W PROP_TAG(PT_UNICODE,0x3A26)
#define PR_COUNTRY_A PROP_TAG(PT_STRING8,0x3A26)
#define PR_COUNTRY   WINELIB_NAME_AW(PR_COUNTRY_)
#define PR_BUSINESS_ADDRESS_COUNTRY_W PR_COUNTRY_W
#define PR_BUSINESS_ADDRESS_COUNTRY_A PR_COUNTRY_A
#define PR_BUSINESS_ADDRESS_COUNTRY   WINELIB_NAME_AW(PR_BUSINESS_ADDRESS_COUNTRY_)
#define PR_LOCALITY_W PROP_TAG(PT_UNICODE,0x3A27)
#define PR_LOCALITY_A PROP_TAG(PT_STRING8,0x3A27)
#define PR_LOCALITY   WINELIB_NAME_AW(PR_LOCALITY_)
#define PR_BUSINESS_ADDRESS_CITY_W PR_LOCALITY_W
#define PR_BUSINESS_ADDRESS_CITY_A PR_LOCALITY_A
#define PR_BUSINESS_ADDRESS_CITY   WINELIB_NAME_AW(PR_BUSINESS_ADDRESS_CITY_)
#define PR_STATE_OR_PROVINCE_W PROP_TAG(PT_UNICODE,0x3A28)
#define PR_STATE_OR_PROVINCE_A PROP_TAG(PT_STRING8,0x3A28)
#define PR_STATE_OR_PROVINCE   WINELIB_NAME_AW(PR_STATE_OR_PROVINCE_)
#define PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE_W PR_STATE_OR_PROVINCE_W
#define PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE_A PR_STATE_OR_PROVINCE_A
#define PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE   WINELIB_NAME_AW(PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE_)
#define PR_STREET_ADDRESS_W PROP_TAG(PT_UNICODE,0x3A29)
#define PR_STREET_ADDRESS_A PROP_TAG(PT_STRING8,0x3A29)
#define PR_STREET_ADDRESS   WINELIB_NAME_AW(PR_STREET_ADDRESS_)
#define PR_BUSINESS_ADDRESS_STREET_W PR_STREET_ADDRESS_W
#define PR_BUSINESS_ADDRESS_STREET_A PR_STREET_ADDRESS_A
#define PR_BUSINESS_ADDRESS_STREET   WINELIB_NAME_AW(PR_BUSINESS_ADDRESS_STREET_)
#define PR_POSTAL_CODE_W PROP_TAG(PT_UNICODE,0x3A2A)
#define PR_POSTAL_CODE_A PROP_TAG(PT_STRING8,0x3A2A)
#define PR_POSTAL_CODE   WINELIB_NAME_AW(PR_POSTAL_CODE_)
#define PR_BUSINESS_ADDRESS_POSTAL_CODE_W PR_POSTAL_CODE_W
#define PR_BUSINESS_ADDRESS_POSTAL_CODE_A PR_POSTAL_CODE_A
#define PR_BUSINESS_ADDRESS_POSTAL_CODE   WINELIB_NAME_AW(PR_BUSINESS_ADDRESS_POSTAL_CODE_)
#define PR_POST_OFFICE_BOX_W PROP_TAG(PT_UNICODE,0x3A2B)
#define PR_POST_OFFICE_BOX_A PROP_TAG(PT_STRING8,0x3A2B)
#define PR_POST_OFFICE_BOX   WINELIB_NAME_AW(PR_POST_OFFICE_BOX_)
#define PR_BUSINESS_ADDRESS_POST_OFFICE_BOX_W PR_POST_OFFICE_BOX_W
#define PR_BUSINESS_ADDRESS_POST_OFFICE_BOX_A PR_POST_OFFICE_BOX_A
#define PR_BUSINESS_ADDRESS_POST_OFFICE_BOX   WINELIB_NAME_AW(PR_BUSINESS_ADDRESS_POST_OFFICE_BOX_)
#define PR_TELEX_NUMBER_W PROP_TAG(PT_UNICODE,0x3A2C)
#define PR_TELEX_NUMBER_A PROP_TAG(PT_STRING8,0x3A2C)
#define PR_TELEX_NUMBER   WINELIB_NAME_AW(PR_TELEX_NUMBER_)
#define PR_ISDN_NUMBER_W PROP_TAG(PT_UNICODE,0x3A2D)
#define PR_ISDN_NUMBER_A PROP_TAG(PT_STRING8,0x3A2D)
#define PR_ISDN_NUMBER   WINELIB_NAME_AW(PR_ISDN_NUMBER_)
#define PR_ASSISTANT_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A2E)
#define PR_ASSISTANT_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A2E)
#define PR_ASSISTANT_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_ASSISTANT_TELEPHONE_NUMBER_)
#define PR_HOME2_TELEPHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A2F)
#define PR_HOME2_TELEPHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A2F)
#define PR_HOME2_TELEPHONE_NUMBER   WINELIB_NAME_AW(PR_HOME2_TELEPHONE_NUMBER_)
#define PR_ASSISTANT_W PROP_TAG(PT_UNICODE,0x3A30)
#define PR_ASSISTANT_A PROP_TAG(PT_STRING8,0x3A30)
#define PR_ASSISTANT   WINELIB_NAME_AW(PR_ASSISTANT_)
#define PR_SEND_RICH_INFO PROP_TAG(PT_BOOLEAN,0x3A40)
#define PR_WEDDING_ANNIVERSARY PROP_TAG(PT_SYSTIME,0x3A41)
#define PR_BIRTHDAY PROP_TAG(PT_SYSTIME,0x3A42)
#define PR_HOBBIES_W PROP_TAG(PT_UNICODE,0x3A43)
#define PR_HOBBIES_A PROP_TAG(PT_STRING8,0x3A43)
#define PR_HOBBIES   WINELIB_NAME_AW(PR_HOBBIES_)
#define PR_MIDDLE_NAME_W PROP_TAG(PT_UNICODE,0x3A44)
#define PR_MIDDLE_NAME_A PROP_TAG(PT_STRING8,0x3A44)
#define PR_MIDDLE_NAME   WINELIB_NAME_AW(PR_MIDDLE_NAME_)
#define PR_DISPLAY_NAME_PREFIX_W PROP_TAG(PT_UNICODE,0x3A45)
#define PR_DISPLAY_NAME_PREFIX_A PROP_TAG(PT_STRING8,0x3A45)
#define PR_DISPLAY_NAME_PREFIX   WINELIB_NAME_AW(PR_DISPLAY_NAME_PREFIX_)
#define PR_PROFESSION_W PROP_TAG(PT_UNICODE,0x3A46)
#define PR_PROFESSION_A PROP_TAG(PT_STRING8,0x3A46)
#define PR_PROFESSION   WINELIB_NAME_AW(PR_PROFESSION_)
#define PR_PREFERRED_BY_NAME_W PROP_TAG(PT_UNICODE,0x3A47)
#define PR_PREFERRED_BY_NAME_A PROP_TAG(PT_STRING8,0x3A47)
#define PR_PREFERRED_BY_NAME   WINELIB_NAME_AW(PR_PREFERRED_BY_NAME_)
#define PR_SPOUSE_NAME_W PROP_TAG(PT_UNICODE,0x3A48)
#define PR_SPOUSE_NAME_A PROP_TAG(PT_STRING8,0x3A48)
#define PR_SPOUSE_NAME   WINELIB_NAME_AW(PR_SPOUSE_NAME_)
#define PR_COMPUTER_NETWORK_NAME_W PROP_TAG(PT_UNICODE,0x3A49)
#define PR_COMPUTER_NETWORK_NAME_A PROP_TAG(PT_STRING8,0x3A49)
#define PR_COMPUTER_NETWORK_NAME   WINELIB_NAME_AW(PR_COMPUTER_NETWORK_NAME_)
#define PR_CUSTOMER_ID_W PROP_TAG(PT_UNICODE,0x3A4A)
#define PR_CUSTOMER_ID_A PROP_TAG(PT_STRING8,0x3A4A)
#define PR_CUSTOMER_ID   WINELIB_NAME_AW(PR_CUSTOMER_ID_)
#define PR_TTYTDD_PHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A4B)
#define PR_TTYTDD_PHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A4B)
#define PR_TTYTDD_PHONE_NUMBER   WINELIB_NAME_AW(PR_TTYTDD_PHONE_NUMBER_)
#define PR_FTP_SITE_W PROP_TAG(PT_UNICODE,0x3A4C)
#define PR_FTP_SITE_A PROP_TAG(PT_STRING8,0x3A4C)
#define PR_FTP_SITE   WINELIB_NAME_AW(PR_FTP_SITE_)
#define PR_GENDER PROP_TAG(PT_I2,0x3A4D)
#define PR_MANAGER_NAME_W PROP_TAG(PT_UNICODE,0x3A4E)
#define PR_MANAGER_NAME_A PROP_TAG(PT_STRING8,0x3A4E)
#define PR_MANAGER_NAME   WINELIB_NAME_AW(PR_MANAGER_NAME_)
#define PR_NICKNAME_W PROP_TAG(PT_UNICODE,0x3A4F)
#define PR_NICKNAME_A PROP_TAG(PT_STRING8,0x3A4F)
#define PR_NICKNAME   WINELIB_NAME_AW(PR_NICKNAME_)
#define PR_PERSONAL_HOME_PAGE_W PROP_TAG(PT_UNICODE,0x3A50)
#define PR_PERSONAL_HOME_PAGE_A PROP_TAG(PT_STRING8,0x3A50)
#define PR_PERSONAL_HOME_PAGE   WINELIB_NAME_AW(PR_PERSONAL_HOME_PAGE_)
#define PR_BUSINESS_HOME_PAGE_W PROP_TAG(PT_UNICODE,0x3A51)
#define PR_BUSINESS_HOME_PAGE_A PROP_TAG(PT_STRING8,0x3A51)
#define PR_BUSINESS_HOME_PAGE   WINELIB_NAME_AW(PR_BUSINESS_HOME_PAGE_)
#define PR_CONTACT_VERSION PROP_TAG(PT_CLSID,0x3A52)
#define PR_CONTACT_ENTRYIDS PROP_TAG(PT_MV_BINARY,0x3A53)
#define PR_CONTACT_ADDRTYPES_W PROP_TAG(PT_MV_UNICODE,0x3A54)
#define PR_CONTACT_ADDRTYPES_A PROP_TAG(PT_MV_STRING8,0x3A54)
#define PR_CONTACT_ADDRTYPES   WINELIB_NAME_AW(PR_CONTACT_ADDRTYPES_)
#define PR_CONTACT_DEFAULT_ADDRESS_INDEX PROP_TAG(PT_I4,0x3A55)
#define PR_CONTACT_EMAIL_ADDRESSES_W PROP_TAG(PT_MV_UNICODE,0x3A56)
#define PR_CONTACT_EMAIL_ADDRESSES_A PROP_TAG(PT_MV_STRING8,0x3A56)
#define PR_CONTACT_EMAIL_ADDRESSES   WINELIB_NAME_AW(PR_CONTACT_EMAIL_ADDRESSES_)
#define PR_COMPANY_MAIN_PHONE_NUMBER_W PROP_TAG(PT_UNICODE,0x3A57)
#define PR_COMPANY_MAIN_PHONE_NUMBER_A PROP_TAG(PT_STRING8,0x3A57)
#define PR_COMPANY_MAIN_PHONE_NUMBER   WINELIB_NAME_AW(PR_COMPANY_MAIN_PHONE_NUMBER_)
#define PR_CHILDRENS_NAMES_W PROP_TAG(PT_MV_UNICODE,0x3A58)
#define PR_CHILDRENS_NAMES_A PROP_TAG(PT_MV_STRING8,0x3A58)
#define PR_CHILDRENS_NAMES   WINELIB_NAME_AW(PR_CHILDRENS_NAMES_)
#define PR_HOME_ADDRESS_CITY_W PROP_TAG(PT_UNICODE,0x3A59)
#define PR_HOME_ADDRESS_CITY_A PROP_TAG(PT_STRING8,0x3A59)
#define PR_HOME_ADDRESS_CITY   WINELIB_NAME_AW(PR_HOME_ADDRESS_CITY_)
#define PR_HOME_ADDRESS_COUNTRY_W PROP_TAG(PT_UNICODE,0x3A5A)
#define PR_HOME_ADDRESS_COUNTRY_A PROP_TAG(PT_STRING8,0x3A5A)
#define PR_HOME_ADDRESS_COUNTRY   WINELIB_NAME_AW(PR_HOME_ADDRESS_COUNTRY_)
#define PR_HOME_ADDRESS_POSTAL_CODE_W PROP_TAG(PT_UNICODE,0x3A5B)
#define PR_HOME_ADDRESS_POSTAL_CODE_A PROP_TAG(PT_STRING8,0x3A5B)
#define PR_HOME_ADDRESS_POSTAL_CODE   WINELIB_NAME_AW(PR_HOME_ADDRESS_POSTAL_CODE_)
#define PR_HOME_ADDRESS_STATE_OR_PROVINCE_W PROP_TAG(PT_UNICODE,0x3A5C)
#define PR_HOME_ADDRESS_STATE_OR_PROVINCE_A PROP_TAG(PT_STRING8,0x3A5C)
#define PR_HOME_ADDRESS_STATE_OR_PROVINCE   WINELIB_NAME_AW(PR_HOME_ADDRESS_STATE_OR_PROVINCE_)
#define PR_HOME_ADDRESS_STREET_W PROP_TAG(PT_UNICODE,0x3A5D)
#define PR_HOME_ADDRESS_STREET_A PROP_TAG(PT_STRING8,0x3A5D)
#define PR_HOME_ADDRESS_STREET   WINELIB_NAME_AW(PR_HOME_ADDRESS_STREET_)
#define PR_HOME_ADDRESS_POST_OFFICE_BOX_W PROP_TAG(PT_UNICODE,0x3A5E)
#define PR_HOME_ADDRESS_POST_OFFICE_BOX_A PROP_TAG(PT_STRING8,0x3A5E)
#define PR_HOME_ADDRESS_POST_OFFICE_BOX   WINELIB_NAME_AW(PR_HOME_ADDRESS_POST_OFFICE_BOX_)
#define PR_OTHER_ADDRESS_CITY_W PROP_TAG(PT_UNICODE,0x3A5F)
#define PR_OTHER_ADDRESS_CITY_A PROP_TAG(PT_STRING8,0x3A5F)
#define PR_OTHER_ADDRESS_CITY   WINELIB_NAME_AW(PR_OTHER_ADDRESS_CITY_)
#define PR_OTHER_ADDRESS_COUNTRY_W PROP_TAG(PT_UNICODE,0x3A60)
#define PR_OTHER_ADDRESS_COUNTRY_A PROP_TAG(PT_STRING8,0x3A60)
#define PR_OTHER_ADDRESS_COUNTRY   WINELIB_NAME_AW(PR_OTHER_ADDRESS_COUNTRY_)
#define PR_OTHER_ADDRESS_POSTAL_CODE_W PROP_TAG(PT_UNICODE,0x3A61)
#define PR_OTHER_ADDRESS_POSTAL_CODE_A PROP_TAG(PT_STRING8,0x3A61)
#define PR_OTHER_ADDRESS_POSTAL_CODE   WINELIB_NAME_AW(PR_OTHER_ADDRESS_POSTAL_CODE_)
#define PR_OTHER_ADDRESS_STATE_OR_PROVINCE_W PROP_TAG(PT_UNICODE,0x3A62)
#define PR_OTHER_ADDRESS_STATE_OR_PROVINCE_A PROP_TAG(PT_STRING8,0x3A62)
#define PR_OTHER_ADDRESS_STATE_OR_PROVINCE   WINELIB_NAME_AW(PR_OTHER_ADDRESS_STATE_OR_PROVINCE_)
#define PR_OTHER_ADDRESS_STREET_W PROP_TAG(PT_UNICODE,0x3A63)
#define PR_OTHER_ADDRESS_STREET_A PROP_TAG(PT_STRING8,0x3A63)
#define PR_OTHER_ADDRESS_STREET   WINELIB_NAME_AW(PR_OTHER_ADDRESS_STREET_)
#define PR_OTHER_ADDRESS_POST_OFFICE_BOX_W PROP_TAG(PT_UNICODE,0x3A64)
#define PR_OTHER_ADDRESS_POST_OFFICE_BOX_A PROP_TAG(PT_STRING8,0x3A64)
#define PR_OTHER_ADDRESS_POST_OFFICE_BOX   WINELIB_NAME_AW(PR_OTHER_ADDRESS_POST_OFFICE_BOX_)
#define PR_STORE_PROVIDERS PROP_TAG(PT_BINARY,0x3D00)
#define PR_AB_PROVIDERS PROP_TAG(PT_BINARY,0x3D01)
#define PR_TRANSPORT_PROVIDERS PROP_TAG(PT_BINARY,0x3D02)
#define PR_DEFAULT_PROFILE PROP_TAG(PT_BOOLEAN,0x3D04)
#define PR_AB_SEARCH_PATH PROP_TAG(PT_MV_BINARY,0x3D05)
#define PR_AB_DEFAULT_DIR PROP_TAG(PT_BINARY,0x3D06)
#define PR_AB_DEFAULT_PAB PROP_TAG(PT_BINARY,0x3D07)
#define PR_FILTERING_HOOKS PROP_TAG(PT_BINARY, 0x3D08)
#define PR_SERVICE_NAME_W PROP_TAG(PT_UNICODE,0x3D09)
#define PR_SERVICE_NAME_A PROP_TAG(PT_STRING8,0x3D09)
#define PR_SERVICE_NAME   WINELIB_NAME_AW(PR_SERVICE_NAME_)
#define PR_SERVICE_DLL_NAME_W PROP_TAG(PT_UNICODE,0x3D0A)
#define PR_SERVICE_DLL_NAME_A PROP_TAG(PT_STRING8,0x3D0A)
#define PR_SERVICE_DLL_NAME   WINELIB_NAME_AW(PR_SERVICE_DLL_NAME_)
#define PR_SERVICE_ENTRY_NAME PROP_TAG(PT_STRING8,0x3D0B)
#define PR_SERVICE_UID PROP_TAG(PT_BINARY,0x3D0C)
#define PR_SERVICE_EXTRA_UIDS PROP_TAG(PT_BINARY,0x3D0D)
#define PR_SERVICES PROP_TAG(PT_BINARY,0x3D0E)
#define PR_SERVICE_SUPPORT_FILES_W PROP_TAG(PT_MV_UNICODE,0x3D0F)
#define PR_SERVICE_SUPPORT_FILES_A PROP_TAG(PT_MV_STRING8,0x3D0F)
#define PR_SERVICE_SUPPORT_FILES   WINELIB_NAME_AW(PR_SERVICE_SUPPORT_FILES_)
#define PR_SERVICE_DELETE_FILES_W PROP_TAG(PT_MV_UNICODE,0x3D10)
#define PR_SERVICE_DELETE_FILES_A PROP_TAG(PT_MV_STRING8,0x3D10)
#define PR_SERVICE_DELETE_FILES   WINELIB_NAME_AW(PR_SERVICE_DELETE_FILES_)
#define PR_AB_SEARCH_PATH_UPDATE PROP_TAG(PT_BINARY,0x3D11)
#define PR_PROFILE_NAME_A PROP_TAG(PT_STRING8,0x3D12)
#define PR_PROFILE_NAME_W PROP_TAG(PT_UNICODE,0x3D12)
#define PR_PROFILE_NAME   WINELIB_NAME_AW(PR_PROFILE_NAME_)
#define PR_IDENTITY_DISPLAY_W PROP_TAG(PT_UNICODE,0x3E00)
#define PR_IDENTITY_DISPLAY_A PROP_TAG(PT_STRING8,0x3E00)
#define PR_IDENTITY_DISPLAY   WINELIB_NAME_AW(PR_IDENTITY_DISPLAY_)
#define PR_IDENTITY_ENTRYID PROP_TAG(PT_BINARY,0x3E01)
#define PR_RESOURCE_METHODS PROP_TAG(PT_I4,0x3E02)
/* Service provider type */
#define PR_RESOURCE_TYPE PROP_TAG(PT_I4,0x3E03)
#define PR_STATUS_CODE PROP_TAG(PT_I4,0x3E04)
#define PR_IDENTITY_SEARCH_KEY PROP_TAG(PT_BINARY,0x3E05)
#define PR_OWN_STORE_ENTRYID PROP_TAG(PT_BINARY,0x3E06)
#define PR_RESOURCE_PATH_W PROP_TAG(PT_UNICODE,0x3E07)
#define PR_RESOURCE_PATH_A PROP_TAG(PT_STRING8,0x3E07)
#define PR_RESOURCE_PATH   WINELIB_NAME_AW(PR_RESOURCE_PATH_)
#define PR_STATUS_STRING_W PROP_TAG(PT_UNICODE,0x3E08)
#define PR_STATUS_STRING_A PROP_TAG(PT_STRING8,0x3E08)
#define PR_STATUS_STRING   WINELIB_NAME_AW(PR_STATUS_STRING_)
#define PR_X400_DEFERRED_DELIVERY_CANCEL PROP_TAG(PT_BOOLEAN,0x3E09)
#define PR_HEADER_FOLDER_ENTRYID PROP_TAG(PT_BINARY,0x3E0A)
#define PR_REMOTE_PROGRESS PROP_TAG(PT_I4,0x3E0B)
#define PR_REMOTE_PROGRESS_TEXT_W PROP_TAG(PT_UNICODE,0x3E0C)
#define PR_REMOTE_PROGRESS_TEXT_A PROP_TAG(PT_STRING8,0x3E0C)
#define PR_REMOTE_PROGRESS_TEXT   WINELIB_NAME_AW(PR_REMOTE_PROGRESS_TEXT_)
#define PR_REMOTE_VALIDATE_OK PROP_TAG(PT_BOOLEAN,0x3E0D)
#define PR_CONTROL_FLAGS PROP_TAG(PT_I4,0x3F00)
#define PR_CONTROL_STRUCTURE PROP_TAG(PT_BINARY,0x3F01)
#define PR_CONTROL_TYPE PROP_TAG(PT_I4,0x3F02)
#define PR_DELTAX PROP_TAG(PT_I4,0x3F03)
#define PR_DELTAY PROP_TAG(PT_I4,0x3F04)
#define PR_XPOS PROP_TAG(PT_I4,0x3F05)
#define PR_YPOS PROP_TAG(PT_I4,0x3F06)
#define PR_CONTROL_ID PROP_TAG(PT_BINARY,0x3F07)
#define PR_INITIAL_DETAILS_PANE PROP_TAG(PT_I4,0x3F08)

#define PROP_ID_SECURE_MIN 0x67F0
#define PROP_ID_SECURE_MAX 0x67FF

#endif /* MAPITAGS_H */
