#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Order of the Thorne
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220901.1

GAME_ID='order-of-the-thorne'
GAME_NAME='Order of the Thorne: The Kingʼs Challenge'

ARCHIVE_BASE_0='gog_order_of_the_thorne_the_king_s_challenge_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='16dde031dcfb730be1d94bde77306b0d'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='790000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.1'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/order_of_the_thorne_the_kings_challenge'

CONTENT_PATH_DEFAULT='data/noarch/game'
ARCHIVE_GAME_BIN32_SHIPPED_FILES='
ags-setup.x86
OotTTKC.bin.x86
lib'
ARCHIVE_GAME_BIN64_SHIPPED_FILES='
ags-setup.x86_64
OotTTKC.bin.x86_64
lib64'
ARCHIVE_GAME_DATA_FILES='
acsetup.cfg
agsgame.dat
modules.lst
*.vox'
ARCHIVE_DOC_DATA_FILES='
licenses'

APP_MAIN_ICONS_LIST='APP_MAIN_ICON'
APP_MAIN_ICON='oott-tkc.png'

APP_SCUMMVM_TYPE='scummvm'
APP_SCUMMVM_SCUMMID='ags:oott'

APP_SHIPPED_TYPE='native'
APP_SHIPPED_LIB_BIN32_SHIPPED='lib'
APP_SHIPPED_LIB_BIN64_SHIPPED='lib64'
APP_SHIPPED_EXE_BIN32_SHIPPED='OotTTKC.bin.x86'
APP_SHIPPED_EXE_BIN64_SHIPPED='OotTTKC.bin.x86_64'

PACKAGES_LIST='PKG_BIN_SCUMMVM PKG_BIN32_SHIPPED PKG_BIN64_SHIPPED PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="$GAME_ID"

PKG_BIN_SCUMMVM_ID="${PKG_BIN_ID}-scummvm"
PKG_BIN_SCUMMVM_PROVIDE="$PKG_BIN_ID"
PKG_BIN_SCUMMVM_DEPS="$PKG_DATA_ID scummvm"

PKG_BIN32_SHIPPED_ARCH='32'
PKG_BIN32_SHIPPED_ID="${PKG_BIN_ID}-shipped"
PKG_BIN32_SHIPPED_PROVIDE="$PKG_BIN_ID"
PKG_BIN32_SHIPPED_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6"

PKG_BIN64_SHIPPED_ARCH='64'
PKG_BIN64_SHIPPED_ID="$PKG_BIN32_SHIPPED_ID"
PKG_BIN64_SHIPPED_PROVIDE="$PKG_BIN_ID"
PKG_BIN64_SHIPPED_DEPS="$PKG_BIN32_SHIPPED_DEPS"

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion 'APP_MAIN'

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN_SCUMMVM'
launchers_write 'APP_SCUMMVM'
PKG='PKG_BIN32_SHIPPED'
launchers_write 'APP_SHIPPED'
PKG='PKG_BIN64_SHIPPED'
launchers_write 'APP_SHIPPED'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

printf '\n'
printf 'ScummVM:'
print_instructions 'PKG_DATA' 'PKG_BIN_SCUMMVM'
printf 'Shipped engine:'
print_instructions 'PKG_DATA' 'PKG_BIN32_SHIPPED' 'PKG_BIN64_SHIPPED'

exit 0
