#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Mopi
set -o errexit

###
# Norco
# send your bug reports to contact@dotslashplay.it
###

script_version=20230709.2

GAME_ID='norco'
GAME_NAME='Norco'

ARCHIVE_BASE_0='setup_norco_v1.4.4_(64bit)_(60635).exe'
ARCHIVE_BASE_0_MD5='5bfcef9964c93e24752a8e85af5df3fd'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='3400000'
ARCHIVE_BASE_0_VERSION='1.4.4-gog60635'
ARCHIVE_BASE_0_URL='https://www.gog.com/en/game/norco'

UNITY3D_NAME='norco'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_data/plugins
*.dll"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data"

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/GeographyOfRobots/norco'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Set up a WINE virtual desktop on first launch, using the current desktop resolution
## This seems to prevent focus issues leading to the inability to interact with some in-game menus.

PKG_BIN_DEPS="${PKG_BIN_DEPS:-} xrandr sed"
sed_expression='s/.*primary.* ([0-9]+x[0-9]+).*/\1/p'
sed_options="--regexp-extended --silent --expression='$sed_expression'"
APP_WINETRICKS="${APP_WINETRICKS:-} vd=\$(LANG=C xrandr | sed $sed_options)"

# Load common functions

target_version='2.24'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Delete unwanted files
	rm --recursive \
		'__redist' \
		'app' \
		'commonappdata' \
		'tmp'
)

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
