/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_LogManagesRecord.h"

CMPIObjectPath* OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_LogManagesRecord& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_LogManagesRecord_classnames[0], OpenDRIM_LogManagesRecord_NAMESPACE);

	if (!instance.Log_isNULL)
		op.addKey("Log", instance.Log);

	if (!instance.Record_isNULL)
		op.addKey("Record", instance.Record);

	_L_;
	return op.getHdl();
}

CMPIInstance* OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_LogManagesRecord& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	_L_;
	return ci.getHdl();
}

void OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_LogManagesRecord& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Record", instance.Record) == OK)
		instance.Record_isNULL = false;

	if (op.getKey("Log", instance.Log) == OK)
		instance.Log_isNULL = false;

	_L_;
}

void OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_LogManagesRecord& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Log", instance.Log) == OK)
		instance.Log_isNULL = false;

	if (inst.getProperty("Record", instance.Record) == OK)
		instance.Record_isNULL = false;

	_L_;
}

