/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.utils;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;

public class SAMSequenceDictionaryExtractor {
    public static SAMSequenceDictionary extractDictionary(File file) {
        return TYPE.forFile(file).extractDictionary(file);
    }

    static enum TYPE {
        FASTA(ReferenceSequenceFileFactory.FASTA_EXTENSIONS){

            @Override
            SAMSequenceDictionary extractDictionary(File reference) {
                SAMSequenceDictionary dict = ReferenceSequenceFileFactory.getReferenceSequenceFile(reference).getSequenceDictionary();
                if (dict == null) {
                    throw new SAMException("Could not find dictionary next to reference file " + reference.getAbsoluteFile());
                }
                return dict;
            }
        }
        ,
        DICTIONARY(new String[]{".dict"}){

            @Override
            SAMSequenceDictionary extractDictionary(File dictionary) {
                SAMSequenceDictionary sAMSequenceDictionary;
                BufferedLineReader bufferedLineReader = null;
                try {
                    bufferedLineReader = new BufferedLineReader(new FileInputStream(dictionary));
                    SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
                    SAMFileHeader header = codec.decode(bufferedLineReader, dictionary.toString());
                    sAMSequenceDictionary = header.getSequenceDictionary();
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new SAMException("Could not open sequence dictionary file: " + dictionary, e);
                    }
                    catch (Throwable throwable) {
                        CloserUtil.close(bufferedLineReader);
                        throw throwable;
                    }
                }
                CloserUtil.close(bufferedLineReader);
                return sAMSequenceDictionary;
            }
        }
        ,
        SAM(new String[]{".sam", ".bam"}){

            @Override
            SAMSequenceDictionary extractDictionary(File sam) {
                return SamReaderFactory.makeDefault().getFileHeader(sam).getSequenceDictionary();
            }
        }
        ,
        VCF(IOUtil.VCF_EXTENSIONS){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            SAMSequenceDictionary extractDictionary(File vcf) {
                SAMSequenceDictionary sAMSequenceDictionary;
                VCFFileReader vcfFileReader = null;
                try {
                    vcfFileReader = new VCFFileReader(vcf, false);
                    sAMSequenceDictionary = vcfFileReader.getFileHeader().getSequenceDictionary();
                }
                catch (Throwable throwable) {
                    CloserUtil.close(vcfFileReader);
                    throw throwable;
                }
                CloserUtil.close(vcfFileReader);
                return sAMSequenceDictionary;
            }
        }
        ,
        INTERVAL_LIST(new String[]{".interval_list"}){

            @Override
            SAMSequenceDictionary extractDictionary(File intervalList) {
                return IntervalList.fromFile(intervalList).getHeader().getSequenceDictionary();
            }
        };

        final Collection<String> applicableExtensions;

        private TYPE(String ... s) {
            this.applicableExtensions = CollectionUtil.makeSet(s);
        }

        private TYPE(Collection<String> extensions) {
            this.applicableExtensions = extensions;
        }

        abstract SAMSequenceDictionary extractDictionary(File var1);

        static TYPE forFile(File dictionaryExtractable) {
            for (TYPE type : TYPE.values()) {
                for (String s : type.applicableExtensions) {
                    if (!dictionaryExtractable.getName().endsWith(s)) continue;
                    return type;
                }
            }
            throw new SAMException("Cannot figure out type of file " + dictionaryExtractable.getAbsolutePath() + " from extension. Current implementation understands the following types: " + Arrays.toString((Object[])TYPE.values()));
        }

        public String toString() {
            return super.toString() + ": " + this.applicableExtensions.toString();
        }
    }
}

