/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTreeChildrenShowUpCondition;
import org.fest.swing.driver.JTreeClearSelectionTask;
import org.fest.swing.driver.JTreeEditableQuery;
import org.fest.swing.driver.JTreeExpandPathTask;
import org.fest.swing.driver.JTreeLocation;
import org.fest.swing.driver.JTreeMatchingPathQuery;
import org.fest.swing.driver.JTreeNodeTextQuery;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.driver.JTreeToggleExpandStateTask;
import org.fest.swing.driver.JTreeVerifySelectionTask;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Arrays;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Triple;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTION_PROPERTY = "selection";
    private final JTreeLocation location = new JTreeLocation();
    private final JTreePathFinder pathFinder = new JTreePathFinder();

    public JTreeDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void clickRow(JTree tree, int row) {
        Point p = this.scrollToRow(tree, row);
        this.robot.click((Component)tree, p);
    }

    @RunsInEDT
    public void clickRow(JTree tree, int row, MouseButton button) {
        this.validateIsNotNull(button);
        this.clickRow(tree, row, button, 1);
    }

    @RunsInEDT
    public void clickRow(JTree tree, int row, MouseClickInfo mouseClickInfo) {
        this.validateIsNotNull(mouseClickInfo);
        this.clickRow(tree, row, mouseClickInfo.button(), mouseClickInfo.times());
    }

    @RunsInEDT
    private void clickRow(JTree tree, int row, MouseButton button, int times) {
        Point p = this.scrollToRow(tree, row);
        this.robot.click(tree, p, button, times);
    }

    @RunsInEDT
    public void doubleClickRow(JTree tree, int row) {
        Point p = this.scrollToRow(tree, row);
        this.doubleClick(tree, p);
    }

    @RunsInEDT
    public void rightClickRow(JTree tree, int row) {
        Point p = this.scrollToRow(tree, row);
        this.rightClick(tree, p);
    }

    @RunsInEDT
    private Point scrollToRow(JTree tree, int row) {
        Point p = (Point)JTreeDriver.scrollToRow((JTree)tree, (int)row, (JTreeLocation)this.location).ii;
        this.robot.waitForIdle();
        return p;
    }

    @RunsInEDT
    public void clickPath(JTree tree, String path) {
        Point p = this.scrollToPath(tree, path);
        this.robot.click((Component)tree, p);
    }

    @RunsInEDT
    public void clickPath(JTree tree, String path, MouseButton button) {
        this.validateIsNotNull(button);
        this.clickPath(tree, path, button, 1);
    }

    private void validateIsNotNull(MouseButton button) {
        if (button == null) {
            throw new NullPointerException("The given MouseButton should not be null");
        }
    }

    @RunsInEDT
    public void clickPath(JTree tree, String path, MouseClickInfo mouseClickInfo) {
        this.validateIsNotNull(mouseClickInfo);
        this.clickPath(tree, path, mouseClickInfo.button(), mouseClickInfo.times());
    }

    private void validateIsNotNull(MouseClickInfo mouseClickInfo) {
        if (mouseClickInfo == null) {
            throw new NullPointerException("The given MouseClickInfo should not be null");
        }
    }

    private void clickPath(JTree tree, String path, MouseButton button, int times) {
        Point p = this.scrollToPath(tree, path);
        this.robot.click(tree, p, button, times);
    }

    @RunsInEDT
    public void doubleClickPath(JTree tree, String path) {
        Point p = this.scrollToPath(tree, path);
        this.doubleClick(tree, p);
    }

    private Point scrollToPath(JTree tree, String path) {
        Point p = (Point)this.scrollToMatchingPath((JTree)tree, (String)path).iii;
        this.robot.waitForIdle();
        return p;
    }

    private void doubleClick(JTree tree, Point p) {
        this.robot.click(tree, p, MouseButton.LEFT_BUTTON, 2);
    }

    @RunsInEDT
    public void rightClickPath(JTree tree, String path) {
        Point p = this.scrollToPath(tree, path);
        this.rightClick(tree, p);
    }

    private void rightClick(JTree tree, Point p) {
        this.robot.click(tree, p, MouseButton.RIGHT_BUTTON, 1);
    }

    @RunsInEDT
    public void expandRow(JTree tree, int row) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree, row, this.location);
        this.robot.waitForIdle();
        if (((Boolean)info.i).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)info.ii, (Integer)info.iii);
    }

    @RunsInEDT
    public void collapseRow(JTree tree, int row) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree, row, this.location);
        this.robot.waitForIdle();
        if (!((Boolean)info.i).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)info.ii, (Integer)info.iii);
    }

    @RunsInEDT
    public void toggleRow(JTree tree, int row) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree, row, this.location);
        this.robot.waitForIdle();
        this.toggleCell(tree, (Point)info.ii, (Integer)info.iii);
    }

    @RunsInEDT
    private static Triple<Boolean, Point, Integer> scrollToRowAndGetToggleInfo(final JTree tree, final int row, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Point, Integer>>(){

            @Override
            protected Triple<Boolean, Point, Integer> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                Point p = JTreeDriver.scrollToVisible(tree, row, location);
                return new Triple<Boolean, Point, Integer>(tree.isExpanded(row), p, tree.getToggleClickCount());
            }
        });
    }

    @RunsInEDT
    public void expandPath(JTree tree, String path) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToMatchingPathAndGetToggleInfo(tree, path, this.pathFinder, this.location);
        if (((Boolean)info.i).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)info.ii, (Integer)info.iii);
    }

    @RunsInEDT
    public void collapsePath(JTree tree, String path) {
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToMatchingPathAndGetToggleInfo(tree, path, this.pathFinder, this.location);
        if (!((Boolean)info.i).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)info.ii, (Integer)info.iii);
    }

    @RunsInEDT
    private static Triple<Boolean, Point, Integer> scrollToMatchingPathAndGetToggleInfo(final JTree tree, final String path, final JTreePathFinder pathFinder, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Point, Integer>>(){

            @Override
            protected Triple<Boolean, Point, Integer> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                TreePath matchingPath = JTreeMatchingPathQuery.matchingPathFor(tree, path, pathFinder);
                Point p = JTreeDriver.scrollToTreePath(tree, matchingPath, location);
                return new Triple<Boolean, Point, Integer>(tree.isExpanded(matchingPath), p, tree.getToggleClickCount());
            }
        });
    }

    @RunsInEDT
    private void toggleCell(JTree tree, Point p, int toggleClickCount) {
        if (toggleClickCount == 0) {
            JTreeDriver.toggleRowThroughTreeUI(tree, p);
            this.robot.waitForIdle();
            return;
        }
        this.robot.click(tree, p, MouseButton.LEFT_BUTTON, toggleClickCount);
    }

    @RunsInEDT
    private static void toggleRowThroughTreeUI(final JTree tree, final Point p) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                TreeUI treeUI = tree.getUI();
                if (!(treeUI instanceof BasicTreeUI)) {
                    throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Can't toggle row for ", treeUI}));
                }
                JTreeToggleExpandStateTask.toggleExpandState(tree, p);
            }
        });
    }

    @RunsInEDT
    public void selectRows(final JTree tree, final int[] rows) {
        this.validateRows(rows);
        this.clearSelection(tree);
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return rows.length;
            }

            void selectElement(int index) {
                JTreeDriver.this.selectRow(tree, rows[index]);
            }
        }.multiSelect();
    }

    private void validateRows(int[] rows) {
        if (rows == null) {
            throw new NullPointerException("The array of rows should not be null");
        }
        if (Arrays.isEmptyIntArray(rows)) {
            throw new IllegalArgumentException("The array of rows should not be empty");
        }
    }

    @RunsInEDT
    private void clearSelection(JTree tree) {
        JTreeClearSelectionTask.clearSelectionOf(tree);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectRow(JTree tree, int row) {
        this.scrollAndSelectRow(tree, row);
    }

    @RunsInEDT
    public void selectPaths(final JTree tree, final String[] paths) {
        this.validatePaths(paths);
        this.clearSelection(tree);
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return paths.length;
            }

            void selectElement(int index) {
                JTreeDriver.this.selectPath(tree, paths[index]);
            }
        }.multiSelect();
    }

    private void validatePaths(String[] paths) {
        if (paths == null) {
            throw new NullPointerException("The array of paths should not be null");
        }
        if (org.fest.util.Arrays.isEmpty((Object[])paths)) {
            throw new IllegalArgumentException("The array of paths should not be empty");
        }
    }

    @RunsInEDT
    public void selectPath(JTree tree, String path) {
        this.selectMatchingPath(tree, path);
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JTree tree, int row) {
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree, row, this.location);
        Point p = (Point)info.ii;
        return this.robot.showPopupMenu(tree, p);
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JTree tree, String path) {
        Triple<TreePath, Boolean, Point> info = this.scrollToMatchingPath(tree, path);
        this.robot.waitForIdle();
        Point where = (Point)info.iii;
        return this.robot.showPopupMenu(tree, where);
    }

    @RunsInEDT
    public void drag(JTree tree, int row) {
        Point p = this.scrollAndSelectRow(tree, row);
        this.drag((Component)tree, p);
    }

    @RunsInEDT
    private Point scrollAndSelectRow(JTree tree, int row) {
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree, row, this.location);
        Point p = (Point)info.ii;
        if (!((Boolean)info.i).booleanValue()) {
            this.robot.click((Component)tree, p);
        }
        return p;
    }

    @RunsInEDT
    public void drop(JTree tree, int row) {
        this.drop((Component)tree, (Point)JTreeDriver.scrollToRow((JTree)tree, (int)row, (JTreeLocation)this.location).ii);
    }

    @RunsInEDT
    private static Pair<Boolean, Point> scrollToRow(final JTree tree, final int row, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                Point p = JTreeDriver.scrollToVisible(tree, row, location);
                boolean selected = tree.getSelectionCount() == 1 && tree.isRowSelected(row);
                return new Pair<Boolean, Point>(selected, p);
            }
        });
    }

    @RunsInCurrentThread
    private static Point scrollToVisible(JTree tree, int row, JTreeLocation location) {
        Pair<Rectangle, Point> boundsAndCoordinates = location.rowBoundsAndCoordinates(tree, row);
        tree.scrollRectToVisible((Rectangle)boundsAndCoordinates.i);
        return (Point)boundsAndCoordinates.ii;
    }

    @RunsInEDT
    public void drag(JTree tree, String path) {
        Point p = this.selectMatchingPath(tree, path);
        this.drag((Component)tree, p);
    }

    @RunsInEDT
    private Point selectMatchingPath(JTree tree, String path) {
        Triple<TreePath, Boolean, Point> info = this.scrollToMatchingPath(tree, path);
        this.robot.waitForIdle();
        Point where = (Point)info.iii;
        if (!((Boolean)info.ii).booleanValue()) {
            this.robot.click((Component)tree, where);
        }
        return where;
    }

    @RunsInEDT
    public void drop(JTree tree, String path) {
        Point p = (Point)this.scrollToMatchingPath((JTree)tree, (String)path).iii;
        this.drop((Component)tree, p);
    }

    @RunsInEDT
    private Triple<TreePath, Boolean, Point> scrollToMatchingPath(JTree tree, String path) {
        TreePath matchingPath = JTreeMatchingPathQuery.verifyJTreeIsReadyAndFindMatchingPath(tree, path, this.pathFinder);
        this.makeVisible(tree, matchingPath, false);
        Pair<Boolean, Point> info = JTreeDriver.scrollToPathToSelect(tree, matchingPath, this.location);
        return new Triple<TreePath, Boolean, Point>(matchingPath, (Boolean)info.i, (Point)info.ii);
    }

    @RunsInEDT
    private static Pair<Boolean, Point> scrollToPathToSelect(final JTree tree, final TreePath path, final JTreeLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                boolean isSelected = tree.getSelectionCount() == 1 && tree.isPathSelected(path);
                return new Pair<Boolean, Point>(isSelected, JTreeDriver.scrollToTreePath(tree, path, location));
            }
        });
    }

    @RunsInCurrentThread
    private static Point scrollToTreePath(JTree tree, TreePath path, JTreeLocation location) {
        Pair<Rectangle, Point> boundsAndCoordinates = location.pathBoundsAndCoordinates(tree, path);
        tree.scrollRectToVisible((Rectangle)boundsAndCoordinates.i);
        return (Point)boundsAndCoordinates.ii;
    }

    @RunsInEDT
    private boolean makeParentVisible(JTree tree, TreePath path) {
        boolean changed = this.makeVisible(tree, path.getParentPath(), true);
        if (changed) {
            this.robot.waitForIdle();
        }
        return changed;
    }

    @RunsInEDT
    private boolean makeVisible(JTree tree, TreePath path, boolean expandWhenFound) {
        boolean changed = false;
        if (path.getPathCount() > 1) {
            changed = this.makeParentVisible(tree, path);
        }
        if (!expandWhenFound) {
            return changed;
        }
        JTreeExpandPathTask.expandTreePath(tree, path);
        this.waitForChildrenToShowUp(tree, path);
        return true;
    }

    @RunsInEDT
    private void waitForChildrenToShowUp(JTree tree, TreePath path) {
        int timeout = this.robot.settings().timeoutToBeVisible();
        try {
            Pause.pause((Condition)JTreeChildrenShowUpCondition.untilChildrenShowUp(tree, path), (long)timeout);
        }
        catch (WaitTimedOutError e) {
            throw new LocationUnavailableException(e.getMessage());
        }
    }

    @RunsInEDT
    public void requireSelection(JTree tree, int[] rows) {
        if (rows == null) {
            throw new NullPointerException("The array of row indices should not be null");
        }
        JTreeVerifySelectionTask.verifySelection(tree, rows, this.selectionProperty(tree));
    }

    @RunsInEDT
    public void requireSelection(JTree tree, String[] paths) {
        if (paths == null) {
            throw new NullPointerException("The array of paths should not be null");
        }
        JTreeVerifySelectionTask.verifySelection(tree, paths, this.pathFinder, this.selectionProperty(tree));
    }

    @RunsInEDT
    public void requireNoSelection(JTree tree) {
        JTreeVerifySelectionTask.verifyNoSelection(tree, this.selectionProperty(tree));
    }

    @RunsInEDT
    private Description selectionProperty(JTree tree) {
        return JTreeDriver.propertyName(tree, SELECTION_PROPERTY);
    }

    @RunsInEDT
    public void requireEditable(JTree tree) {
        this.assertEditable(tree, true);
    }

    @RunsInEDT
    public void requireNotEditable(JTree tree) {
        this.assertEditable(tree, false);
    }

    @RunsInEDT
    private void assertEditable(JTree tree, boolean editable) {
        Assertions.assertThat((boolean)JTreeEditableQuery.isEditable(tree)).as(JTreeDriver.editableProperty(tree)).isEqualTo(editable);
    }

    @RunsInEDT
    private static Description editableProperty(JTree tree) {
        return JTreeDriver.propertyName(tree, EDITABLE_PROPERTY);
    }

    public String separator() {
        return this.pathFinder.separator();
    }

    public void separator(String newSeparator) {
        if (newSeparator == null) {
            throw new NullPointerException("The path separator should not be null");
        }
        this.pathFinder.separator(newSeparator);
    }

    public void cellReader(JTreeCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.pathFinder.cellReader(newCellReader);
    }

    @RunsInEDT
    public void validateRow(JTree tree, int row) {
        this.location.validIndex(tree, row);
    }

    @RunsInEDT
    public void validatePath(JTree tree, String path) {
        JTreeMatchingPathQuery.matchingPathFor(tree, path, this.pathFinder);
    }

    @RunsInEDT
    public String nodeValue(JTree tree, String path) {
        return JTreeNodeTextQuery.nodeText(tree, path, this.pathFinder);
    }

    public String nodeValue(JTree tree, int row) {
        return JTreeNodeTextQuery.nodeText(tree, row, this.location, this.pathFinder);
    }

    @VisibleForTesting
    JTreeCellReader cellReader() {
        return this.pathFinder.cellReader();
    }
}

