/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.DefaultConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.config.StringValueReference;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.util.GenericObjectFactory;
import amazon.fws.clicommando.util.StringUtils;
import java.util.Collection;

public class DefaultCommandProcessor
implements CommandProcessor {
    public static final String REF_INDICATOR = "ref:";

    public Command process(Command process) throws CliCommandoException {
        Collection<ParamConfig> parameters = process.getCurrentCommandConfig().getAllParameters();
        for (ParamConfig param : parameters) {
            DefaultConfig defaultConfig = param.getDefaultValue();
            if (defaultConfig == null || !StringUtils.isEmpty(param.getValue())) continue;
            String defaultValue = defaultConfig.getValue();
            if (defaultValue != null && defaultValue.startsWith(REF_INDICATOR)) {
                defaultValue = this.loadReferenceDefaultValue(defaultValue);
            }
            param.setValue(defaultValue);
        }
        return process;
    }

    private String loadReferenceDefaultValue(String refDefaultValue) {
        String refValue = refDefaultValue.substring(REF_INDICATOR.length());
        GenericObjectFactory factory = new GenericObjectFactory();
        StringValueReference referenceClass = (StringValueReference)factory.newInstance(refValue);
        return referenceClass.getValue();
    }
}

