/* CrumbleEffect.c generated by valac 0.40.4, the Vala compiler
 * generated from CrumbleEffect.vala, do not modify */

/* Copyright 2010 Maxim Kartashev
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <shotwell-plugin-dev-1.0.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_SHOTWELL_TRANSITION_DESCRIPTOR (shotwell_transition_descriptor_get_type ())
#define SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptor))
#define SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define SHOTWELL_TRANSITION_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))

typedef struct _ShotwellTransitionDescriptor ShotwellTransitionDescriptor;
typedef struct _ShotwellTransitionDescriptorClass ShotwellTransitionDescriptorClass;
typedef struct _ShotwellTransitionDescriptorPrivate ShotwellTransitionDescriptorPrivate;

#define TYPE_CRUMBLE_EFFECT_DESCRIPTOR (crumble_effect_descriptor_get_type ())
#define CRUMBLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor))
#define CRUMBLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptorClass))
#define IS_CRUMBLE_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRUMBLE_EFFECT_DESCRIPTOR))
#define IS_CRUMBLE_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRUMBLE_EFFECT_DESCRIPTOR))
#define CRUMBLE_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptorClass))

typedef struct _CrumbleEffectDescriptor CrumbleEffectDescriptor;
typedef struct _CrumbleEffectDescriptorClass CrumbleEffectDescriptorClass;
typedef struct _CrumbleEffectDescriptorPrivate CrumbleEffectDescriptorPrivate;
enum  {
	CRUMBLE_EFFECT_DESCRIPTOR_0_PROPERTY,
	CRUMBLE_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* crumble_effect_descriptor_properties[CRUMBLE_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_CRUMBLE_EFFECT (crumble_effect_get_type ())
#define CRUMBLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRUMBLE_EFFECT, CrumbleEffect))
#define CRUMBLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRUMBLE_EFFECT, CrumbleEffectClass))
#define IS_CRUMBLE_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRUMBLE_EFFECT))
#define IS_CRUMBLE_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRUMBLE_EFFECT))
#define CRUMBLE_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRUMBLE_EFFECT, CrumbleEffectClass))

typedef struct _CrumbleEffect CrumbleEffect;
typedef struct _CrumbleEffectClass CrumbleEffectClass;
typedef struct _CrumbleEffectPrivate CrumbleEffectPrivate;
enum  {
	CRUMBLE_EFFECT_0_PROPERTY,
	CRUMBLE_EFFECT_NUM_PROPERTIES
};
static GParamSpec* crumble_effect_properties[CRUMBLE_EFFECT_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_rand_free0(var) ((var == NULL) ? NULL : (var = (g_rand_free (var), NULL)))

struct _ShotwellTransitionDescriptor {
	GObject parent_instance;
	ShotwellTransitionDescriptorPrivate * priv;
};

struct _ShotwellTransitionDescriptorClass {
	GObjectClass parent_class;
	const gchar* (*get_id) (ShotwellTransitionDescriptor* self);
	const gchar* (*get_pluggable_name) (ShotwellTransitionDescriptor* self);
	SpitTransitionsEffect* (*create) (ShotwellTransitionDescriptor* self, SpitHostInterface* host);
};

struct _CrumbleEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	CrumbleEffectDescriptorPrivate * priv;
};

struct _CrumbleEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _CrumbleEffect {
	GObject parent_instance;
	CrumbleEffectPrivate * priv;
};

struct _CrumbleEffectClass {
	GObjectClass parent_class;
};

struct _CrumbleEffectPrivate {
	cairo_surface_t** from_stripes;
	gint from_stripes_length1;
	gint _from_stripes_size_;
	gdouble* accelerations;
	gint accelerations_length1;
	gint _accelerations_size_;
	gint stripes_count;
};


static gpointer crumble_effect_descriptor_parent_class = NULL;
static gpointer crumble_effect_parent_class = NULL;
static SpitTransitionsEffectIface * crumble_effect_spit_transitions_effect_parent_iface = NULL;

GType shotwell_transition_descriptor_get_type (void) G_GNUC_CONST;
GType crumble_effect_descriptor_get_type (void) G_GNUC_CONST;
CrumbleEffectDescriptor* crumble_effect_descriptor_new (GFile* resource_directory);
CrumbleEffectDescriptor* crumble_effect_descriptor_construct (GType object_type,
                                                              GFile* resource_directory);
ShotwellTransitionDescriptor* shotwell_transition_descriptor_construct (GType object_type,
                                                                        GFile* resource_directory);
static const gchar* crumble_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* crumble_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* crumble_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                              SpitHostInterface* host);
CrumbleEffect* crumble_effect_new (void);
CrumbleEffect* crumble_effect_construct (GType object_type);
GType crumble_effect_get_type (void) G_GNUC_CONST;
#define CRUMBLE_EFFECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CRUMBLE_EFFECT, CrumbleEffectPrivate))
#define CRUMBLE_EFFECT_DESIRED_FPS 25
#define CRUMBLE_EFFECT_MIN_FPS 15
#define CRUMBLE_EFFECT_STRIPE_WIDTH 10
static void crumble_effect_real_get_fps (SpitTransitionsEffect* base,
                                  gint* desired_fps,
                                  gint* min_fps);
static gboolean crumble_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void crumble_effect_real_start (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion);
static void crumble_effect_real_paint (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                cairo_t* ctx,
                                gint width,
                                gint height,
                                gint frame_number);
static void crumble_effect_real_advance (SpitTransitionsEffect* base,
                                  SpitTransitionsVisuals* visuals,
                                  SpitTransitionsMotion* motion,
                                  gint frame_number);
static void crumble_effect_real_cancel (SpitTransitionsEffect* base);
static void crumble_effect_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


CrumbleEffectDescriptor*
crumble_effect_descriptor_construct (GType object_type,
                                     GFile* resource_directory)
{
	CrumbleEffectDescriptor * self = NULL;
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_val_if_fail (G_IS_FILE (resource_directory), NULL);
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = (CrumbleEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return self;
#line 175 "CrumbleEffect.c"
}


CrumbleEffectDescriptor*
crumble_effect_descriptor_new (GFile* resource_directory)
{
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return crumble_effect_descriptor_construct (TYPE_CRUMBLE_EFFECT_DESCRIPTOR, resource_directory);
#line 184 "CrumbleEffect.c"
}


static const gchar*
crumble_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	CrumbleEffectDescriptor * self;
	const gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor);
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	result = "org.yorba.shotwell.transitions.crumble";
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return result;
#line 199 "CrumbleEffect.c"
}


static const gchar*
crumble_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	CrumbleEffectDescriptor * self;
	const gchar* result = NULL;
#line 19 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor);
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	result = _ ("Crumble");
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return result;
#line 214 "CrumbleEffect.c"
}


static SpitTransitionsEffect*
crumble_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                       SpitHostInterface* host)
{
	CrumbleEffectDescriptor * self;
	SpitTransitionsEffect* result = NULL;
	CrumbleEffect* _tmp0_;
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT_DESCRIPTOR, CrumbleEffectDescriptor);
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (host), NULL);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp0_ = crumble_effect_new ();
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return result;
#line 235 "CrumbleEffect.c"
}


static void
crumble_effect_descriptor_class_init (CrumbleEffectDescriptorClass * klass)
{
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	crumble_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor *)) crumble_effect_descriptor_real_get_id;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor *)) crumble_effect_descriptor_real_get_pluggable_name;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor *, SpitHostInterface*)) crumble_effect_descriptor_real_create;
#line 250 "CrumbleEffect.c"
}


static void
crumble_effect_descriptor_instance_init (CrumbleEffectDescriptor * self)
{
}


GType
crumble_effect_descriptor_get_type (void)
{
	static volatile gsize crumble_effect_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&crumble_effect_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CrumbleEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crumble_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CrumbleEffectDescriptor), 0, (GInstanceInitFunc) crumble_effect_descriptor_instance_init, NULL };
		GType crumble_effect_descriptor_type_id;
		crumble_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "CrumbleEffectDescriptor", &g_define_type_info, 0);
		g_once_init_leave (&crumble_effect_descriptor_type_id__volatile, crumble_effect_descriptor_type_id);
	}
	return crumble_effect_descriptor_type_id__volatile;
}


CrumbleEffect*
crumble_effect_construct (GType object_type)
{
	CrumbleEffect * self = NULL;
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = (CrumbleEffect*) g_object_new (object_type, NULL);
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return self;
#line 282 "CrumbleEffect.c"
}


CrumbleEffect*
crumble_effect_new (void)
{
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return crumble_effect_construct (TYPE_CRUMBLE_EFFECT);
#line 291 "CrumbleEffect.c"
}


static void
crumble_effect_real_get_fps (SpitTransitionsEffect* base,
                             gint* desired_fps,
                             gint* min_fps)
{
	CrumbleEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 42 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_vala_desired_fps = CRUMBLE_EFFECT_DESIRED_FPS;
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_vala_min_fps = CRUMBLE_EFFECT_MIN_FPS;
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	if (desired_fps) {
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		*desired_fps = _vala_desired_fps;
#line 313 "CrumbleEffect.c"
	}
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	if (min_fps) {
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		*min_fps = _vala_min_fps;
#line 319 "CrumbleEffect.c"
	}
}


static gboolean
crumble_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	CrumbleEffect * self;
	gboolean result = FALSE;
#line 46 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	result = TRUE;
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	return result;
#line 335 "CrumbleEffect.c"
}


static void
crumble_effect_real_start (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion)
{
	CrumbleEffect * self;
	GRand* rand = NULL;
	GRand* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp0_ = g_rand_new ();
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	rand = _tmp0_;
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp1_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp2_ = _tmp1_;
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	if (_tmp2_ != NULL) {
#line 365 "CrumbleEffect.c"
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		cairo_surface_t** _tmp8_;
		gint _tmp9_;
		gdouble* _tmp10_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp3_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp4_ = _tmp3_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp5_ = gdk_pixbuf_get_width (_tmp4_);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp6_ = _tmp5_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->stripes_count = _tmp6_ / CRUMBLE_EFFECT_STRIPE_WIDTH;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp7_ = self->priv->stripes_count;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp8_ = g_new0 (cairo_surface_t*, _tmp7_ + 1);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->from_stripes = (_vala_array_free (self->priv->from_stripes, self->priv->from_stripes_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->from_stripes = _tmp8_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->from_stripes_length1 = _tmp7_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->_from_stripes_size_ = self->priv->from_stripes_length1;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp9_ = self->priv->stripes_count;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp10_ = g_new0 (gdouble, _tmp9_);
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->accelerations = (g_free (self->priv->accelerations), NULL);
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->accelerations = _tmp10_;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->accelerations_length1 = _tmp9_;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		self->priv->_accelerations_size_ = self->priv->accelerations_length1;
#line 408 "CrumbleEffect.c"
		{
			gint i = 0;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			i = 0;
#line 413 "CrumbleEffect.c"
			{
				gboolean _tmp11_ = FALSE;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
				_tmp11_ = TRUE;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
				while (TRUE) {
#line 420 "CrumbleEffect.c"
					gint _tmp13_;
					gint _tmp14_;
					cairo_surface_t** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					GdkPixbuf* _tmp17_;
					GdkPixbuf* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					cairo_surface_t* _tmp21_;
					cairo_surface_t* _tmp22_;
					cairo_t* ctx = NULL;
					cairo_surface_t** _tmp23_;
					gint _tmp23__length1;
					gint _tmp24_;
					cairo_surface_t* _tmp25_;
					cairo_t* _tmp26_;
					cairo_t* _tmp27_;
					GdkPixbuf* _tmp28_;
					GdkPixbuf* _tmp29_;
					gint _tmp30_;
					cairo_t* _tmp31_;
					gdouble* _tmp32_;
					gint _tmp32__length1;
					gint _tmp33_;
					GRand* _tmp34_;
					gdouble _tmp35_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					if (!_tmp11_) {
#line 450 "CrumbleEffect.c"
						gint _tmp12_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						_tmp12_ = i;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						i = _tmp12_ + 1;
#line 456 "CrumbleEffect.c"
					}
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp11_ = FALSE;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp13_ = i;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp14_ = self->priv->stripes_count;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					if (!(_tmp13_ < _tmp14_)) {
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						break;
#line 468 "CrumbleEffect.c"
					}
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp15_ = self->priv->from_stripes;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp15__length1 = self->priv->from_stripes_length1;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp16_ = i;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp17_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp18_ = _tmp17_;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp19_ = gdk_pixbuf_get_height (_tmp18_);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp20_ = _tmp19_;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp21_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, CRUMBLE_EFFECT_STRIPE_WIDTH, _tmp20_);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_cairo_surface_destroy0 (_tmp15_[_tmp16_]);
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp15_[_tmp16_] = _tmp21_;
#line 60 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp22_ = _tmp15_[_tmp16_];
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp23_ = self->priv->from_stripes;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp23__length1 = self->priv->from_stripes_length1;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp24_ = i;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp25_ = _tmp23_[_tmp24_];
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp26_ = cairo_create (_tmp25_);
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					ctx = _tmp26_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp27_ = ctx;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp28_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp29_ = _tmp28_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp30_ = i;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					gdk_cairo_set_source_pixbuf (_tmp27_, _tmp29_, (gdouble) ((-_tmp30_) * CRUMBLE_EFFECT_STRIPE_WIDTH), (gdouble) 0);
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp31_ = ctx;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					cairo_paint (_tmp31_);
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp32_ = self->priv->accelerations;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp32__length1 = self->priv->accelerations_length1;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp33_ = i;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp34_ = rand;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp32_[_tmp33_] = g_rand_double (_tmp34_);
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp35_ = _tmp32_[_tmp33_];
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_cairo_destroy0 (ctx);
#line 532 "CrumbleEffect.c"
				}
			}
		}
	}
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_g_rand_free0 (rand);
#line 539 "CrumbleEffect.c"
}


static void
crumble_effect_real_paint (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           cairo_t* ctx,
                           gint width,
                           gint height,
                           gint frame_number)
{
	CrumbleEffect * self;
	gdouble alpha = 0.0;
	gdouble _tmp0_;
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (ctx != NULL);
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	_tmp0_ = alpha;
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	if (_tmp0_ < 0.5) {
#line 569 "CrumbleEffect.c"
		gdouble _tmp1_;
#line 76 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp1_ = alpha;
#line 76 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		alpha = _tmp1_ * 2;
#line 575 "CrumbleEffect.c"
		{
			gint i = 0;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			i = 0;
#line 580 "CrumbleEffect.c"
			{
				gboolean _tmp2_ = FALSE;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
				_tmp2_ = TRUE;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
				while (TRUE) {
#line 587 "CrumbleEffect.c"
					gint _tmp4_;
					gint _tmp5_;
					gint x = 0;
					GdkRectangle _tmp6_ = {0};
					GdkRectangle _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					gdouble a = 0.0;
					gdouble _tmp10_;
					gdouble _tmp11_;
					gdouble* _tmp12_;
					gint _tmp12__length1;
					gint _tmp13_;
					gdouble _tmp14_;
					gint y = 0;
					GdkRectangle _tmp15_ = {0};
					GdkRectangle _tmp16_;
					gint _tmp17_;
					GdkPixbuf* _tmp18_;
					GdkPixbuf* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					gdouble _tmp22_;
					gdouble _tmp23_;
					cairo_surface_t** _tmp24_;
					gint _tmp24__length1;
					gint _tmp25_;
					cairo_surface_t* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					if (!_tmp2_) {
#line 620 "CrumbleEffect.c"
						gint _tmp3_;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						_tmp3_ = i;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						i = _tmp3_ + 1;
#line 626 "CrumbleEffect.c"
					}
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp2_ = FALSE;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp4_ = i;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp5_ = self->priv->stripes_count;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					if (!(_tmp4_ < _tmp5_)) {
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
						break;
#line 638 "CrumbleEffect.c"
					}
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					spit_transitions_visuals_get_from_pos (visuals, &_tmp6_);
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp7_ = _tmp6_;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp8_ = _tmp7_.x;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp9_ = i;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					x = _tmp8_ + (_tmp9_ * CRUMBLE_EFFECT_STRIPE_WIDTH);
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp10_ = alpha;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp11_ = alpha;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp12_ = self->priv->accelerations;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp12__length1 = self->priv->accelerations_length1;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp13_ = i;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp14_ = _tmp12_[_tmp13_];
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					a = _tmp10_ + (_tmp11_ * _tmp14_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					spit_transitions_visuals_get_from_pos (visuals, &_tmp15_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp16_ = _tmp15_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp17_ = _tmp16_.y;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp18_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp19_ = _tmp18_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp20_ = gdk_pixbuf_get_height (_tmp19_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp21_ = _tmp20_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp22_ = a;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp23_ = a;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					y = _tmp17_ + ((gint) ((_tmp21_ * _tmp22_) * _tmp23_));
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp24_ = self->priv->from_stripes;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp24__length1 = self->priv->from_stripes_length1;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp25_ = i;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp26_ = _tmp24_[_tmp25_];
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp27_ = x;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					_tmp28_ = y;
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					cairo_set_source_surface (ctx, _tmp26_, (gdouble) _tmp27_, (gdouble) _tmp28_);
#line 85 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
					cairo_paint (ctx);
#line 700 "CrumbleEffect.c"
				}
			}
		}
	} else {
		GdkPixbuf* _tmp29_;
		GdkPixbuf* _tmp30_;
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp29_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		_tmp30_ = _tmp29_;
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
		if (_tmp30_ != NULL) {
#line 713 "CrumbleEffect.c"
			gdouble _tmp31_;
			GdkPixbuf* _tmp32_;
			GdkPixbuf* _tmp33_;
			GdkRectangle _tmp34_ = {0};
			GdkRectangle _tmp35_;
			gint _tmp36_;
			GdkRectangle _tmp37_ = {0};
			GdkRectangle _tmp38_;
			gint _tmp39_;
			gdouble _tmp40_;
#line 89 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp31_ = alpha;
#line 89 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			alpha = (_tmp31_ - 0.5) * 2;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp32_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp33_ = _tmp32_;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			spit_transitions_visuals_get_to_pos (visuals, &_tmp34_);
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp35_ = _tmp34_;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp36_ = _tmp35_.x;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			spit_transitions_visuals_get_to_pos (visuals, &_tmp37_);
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp38_ = _tmp37_;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp39_ = _tmp38_.y;
#line 90 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			gdk_cairo_set_source_pixbuf (ctx, _tmp33_, (gdouble) _tmp36_, (gdouble) _tmp39_);
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			_tmp40_ = alpha;
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
			cairo_paint_with_alpha (ctx, _tmp40_);
#line 750 "CrumbleEffect.c"
		} else {
		}
	}
}


static void
crumble_effect_real_advance (SpitTransitionsEffect* base,
                             SpitTransitionsVisuals* visuals,
                             SpitTransitionsMotion* motion,
                             gint frame_number)
{
	CrumbleEffect * self;
#line 97 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 97 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 97 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 770 "CrumbleEffect.c"
}


static void
crumble_effect_real_cancel (SpitTransitionsEffect* base)
{
	CrumbleEffect * self;
#line 100 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 780 "CrumbleEffect.c"
}


static void
crumble_effect_class_init (CrumbleEffectClass * klass)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	crumble_effect_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	g_type_class_add_private (klass, sizeof (CrumbleEffectPrivate));
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	G_OBJECT_CLASS (klass)->finalize = crumble_effect_finalize;
#line 793 "CrumbleEffect.c"
}


static void
crumble_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	crumble_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->get_fps = (void (*) (SpitTransitionsEffect *, gint*, gint*)) crumble_effect_real_get_fps;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect *)) crumble_effect_real_needs_clear_background;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->start = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*)) crumble_effect_real_start;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->paint = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) crumble_effect_real_paint;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->advance = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) crumble_effect_real_advance;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	iface->cancel = (void (*) (SpitTransitionsEffect *)) crumble_effect_real_cancel;
#line 814 "CrumbleEffect.c"
}


static void
crumble_effect_instance_init (CrumbleEffect * self)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self->priv = CRUMBLE_EFFECT_GET_PRIVATE (self);
#line 823 "CrumbleEffect.c"
}


static void
crumble_effect_finalize (GObject * obj)
{
	CrumbleEffect * self;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CRUMBLE_EFFECT, CrumbleEffect);
#line 34 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self->priv->from_stripes = (_vala_array_free (self->priv->from_stripes, self->priv->from_stripes_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	self->priv->accelerations = (g_free (self->priv->accelerations), NULL);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/CrumbleEffect.vala"
	G_OBJECT_CLASS (crumble_effect_parent_class)->finalize (obj);
#line 839 "CrumbleEffect.c"
}


GType
crumble_effect_get_type (void)
{
	static volatile gsize crumble_effect_type_id__volatile = 0;
	if (g_once_init_enter (&crumble_effect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CrumbleEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crumble_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CrumbleEffect), 0, (GInstanceInitFunc) crumble_effect_instance_init, NULL };
		static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) crumble_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType crumble_effect_type_id;
		crumble_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "CrumbleEffect", &g_define_type_info, 0);
		g_type_add_interface_static (crumble_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
		g_once_init_leave (&crumble_effect_type_id__volatile, crumble_effect_type_id);
	}
	return crumble_effect_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



