/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import com.google.common.collect.testing.google.Platform;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

@GwtCompatible
public class MultisetReadsTester<E>
extends AbstractMultisetTester<E> {
    public void testCount_0() {
        MultisetReadsTester.assertEquals((String)"multiset.count(missing) didn't return 0", (int)0, (int)this.getMultiset().count(this.samples.e3));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testCount_1() {
        MultisetReadsTester.assertEquals((String)"multiset.count(present) didn't return 1", (int)1, (int)this.getMultiset().count(this.samples.e0));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testCount_3() {
        this.initThreeCopies();
        MultisetReadsTester.assertEquals((String)"multiset.count(thriceContained) didn't return 3", (int)3, (int)this.getMultiset().count(this.samples.e0));
    }

    public void testCount_null() {
        MultisetReadsTester.assertEquals((String)"multiset.count(null) didn't return 0", (int)0, (int)this.getMultiset().count(null));
    }

    public void testCount_wrongType() {
        MultisetReadsTester.assertEquals((String)"multiset.count(wrongType) didn't return 0", (int)0, (int)this.getMultiset().count((Object)WrongType.VALUE));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testElementSet_contains() {
        MultisetReadsTester.assertTrue((String)"multiset.elementSet().contains(present) returned false", (boolean)this.getMultiset().elementSet().contains(this.samples.e0));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEntrySet_contains() {
        MultisetReadsTester.assertTrue((String)"multiset.entrySet() didn't contain [present, 1]", (boolean)this.getMultiset().entrySet().contains(Multisets.immutableEntry(this.samples.e0, (int)1)));
    }

    public void testEntrySet_contains_count0() {
        MultisetReadsTester.assertFalse((String)"multiset.entrySet() contains [missing, 0]", (boolean)this.getMultiset().entrySet().contains(Multisets.immutableEntry(this.samples.e3, (int)0)));
    }

    public void testEntrySet_contains_nonentry() {
        MultisetReadsTester.assertFalse((String)"multiset.entrySet() contains a non-entry", (boolean)this.getMultiset().entrySet().contains(this.samples.e0));
    }

    public void testEntrySet_twice() {
        MultisetReadsTester.assertEquals((String)"calling multiset.entrySet() twice returned unequal sets", (Object)this.getMultiset().entrySet(), (Object)this.getMultiset().entrySet());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEntrySet_hashCode_size0() {
        MultisetReadsTester.assertEquals((String)"multiset.entrySet() has incorrect hash code", (int)0, (int)((Object)this.getMultiset().entrySet()).hashCode());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testEntrySet_hashCode_size1() {
        MultisetReadsTester.assertEquals((String)"multiset.entrySet() has incorrect hash code", (int)(1 ^ this.samples.e0.hashCode()), (int)((Object)this.getMultiset().entrySet()).hashCode());
    }

    public void testEquals_yes() {
        MultisetReadsTester.assertTrue((String)"multiset doesn't equal a multiset with the same elements", (boolean)this.getMultiset().equals(HashMultiset.create(this.getSampleElements())));
    }

    public void testEquals_differentSize() {
        HashMultiset other = HashMultiset.create(this.getSampleElements());
        other.add(this.samples.e0);
        MultisetReadsTester.assertFalse((String)"multiset equals a multiset with a different size", (boolean)this.getMultiset().equals(other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_differentElements() {
        HashMultiset other = HashMultiset.create(this.getSampleElements());
        other.remove(this.samples.e0);
        other.add(this.samples.e3);
        MultisetReadsTester.assertFalse((String)"multiset equals a multiset with different elements", (boolean)this.getMultiset().equals(other));
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testHashCode_size0() {
        MultisetReadsTester.assertEquals((String)"multiset has incorrect hash code", (int)0, (int)this.getMultiset().hashCode());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testHashCode_size1() {
        MultisetReadsTester.assertEquals((String)"multiset has incorrect hash code", (int)(1 ^ this.samples.e0.hashCode()), (int)this.getMultiset().hashCode());
    }

    public static List<Method> getReadsDuplicateInitializingMethods() {
        return Arrays.asList(Platform.getMethod(MultisetReadsTester.class, "testCount_3"));
    }
}

