/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.framework.DrawingChangeEvent;
import org.jhotdraw.framework.DrawingChangeListener;
import org.jhotdraw.framework.DrawingView;

public class MiniMapView
extends JComponent {
    private JScrollPane m_subject;
    private DrawingView myMappedDrawingView;
    private SubjectListener m_subjectListener;
    private DrawingChangeListener myDrawingChangeListener;
    private Color m_viewBoxColor = Color.red;

    public MiniMapView(DrawingView drawingView, JScrollPane jScrollPane) {
        this.m_subjectListener = new SubjectListener();
        this.setSubject(jScrollPane);
        this.setMappedDrawingView(drawingView);
        this.myDrawingChangeListener = new MappedDrawingChangeListener();
        this.getMappedDrawingView().drawing().addDrawingChangeListener(this.myDrawingChangeListener);
        MouseListener mouseListener = new MouseListener();
        this.addMouseListener(new MouseListener());
        this.addMouseMotionListener(mouseListener);
    }

    protected void setMappedDrawingView(DrawingView drawingView) {
        this.myMappedDrawingView = drawingView;
    }

    public DrawingView getMappedDrawingView() {
        return this.myMappedDrawingView;
    }

    protected void setSubject(JScrollPane jScrollPane) {
        if (this.m_subject != null) {
            this.m_subject.getViewport().removeChangeListener(this.m_subjectListener);
        }
        this.m_subject = jScrollPane;
        if (this.m_subject != null) {
            this.m_subject.getViewport().addChangeListener(this.m_subjectListener);
        }
        this.repaint();
    }

    public JScrollPane getSubject() {
        return this.m_subject;
    }

    public Color getViewBowColor() {
        return this.m_viewBoxColor;
    }

    public void setViewBoxColor(Color color) {
        this.m_viewBoxColor = color;
        this.repaint();
    }

    protected Component getMappedComponent() {
        return (Component)((Object)this.getMappedDrawingView());
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Component component = this.getMappedComponent();
        AffineTransform affineTransform = this.getViewToMiniMapTransform(component);
        graphics2D.transform(affineTransform);
        this.getMappedDrawingView().drawAll(graphics2D);
        this.drawViewRectangle(graphics2D, this.getViewRectangle());
    }

    protected void drawViewRectangle(Graphics2D graphics2D, Rectangle rectangle) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToIdentity();
        graphics2D.setTransform(affineTransform);
        graphics2D.setColor(this.m_viewBoxColor);
        graphics2D.draw(rectangle);
    }

    protected AffineTransform getViewToMiniMapTransform(Component component) {
        double d = (double)this.getWidth() / (double)component.getWidth();
        double d2 = (double)this.getHeight() / (double)component.getHeight();
        AffineTransform affineTransform = this.getInverseSubjectTransform();
        affineTransform.concatenate(AffineTransform.getScaleInstance(d, d2));
        return affineTransform;
    }

    protected AffineTransform getInverseSubjectTransform() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToIdentity();
        return affineTransform;
    }

    protected Rectangle getViewRectangle() {
        Rectangle rectangle = this.m_subject.getViewportBorderBounds();
        Point point = this.m_subject.getViewport().getViewPosition();
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        dArray[0] = (double)point.x + rectangle.getX();
        dArray[1] = (double)point.y + rectangle.getY();
        dArray[2] = (double)point.x + rectangle.getX() + rectangle.getWidth();
        dArray[3] = (double)point.y + rectangle.getY() + rectangle.getHeight();
        this.getViewToMiniMapTransform(this.getMappedComponent()).transform(dArray, 0, dArray2, 0, dArray.length / 2);
        return new Rectangle((int)dArray2[0], (int)dArray2[1], (int)(dArray2[2] - dArray2[0]), (int)(dArray2[3] - dArray2[1]));
    }

    protected void scrollSubjectTo(int n, int n2) {
        AffineTransform affineTransform = null;
        try {
            affineTransform = this.getViewToMiniMapTransform(this.getMappedComponent()).createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            return;
        }
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        dArray[0] = n;
        dArray[1] = n2;
        affineTransform.transform(dArray, 0, dArray2, 0, 1);
        if (dArray2[0] < 0.0) {
            dArray2[0] = 0.0;
        }
        if (dArray2[1] < 0.0) {
            dArray2[1] = 0.0;
        }
        this.m_subject.getViewport().setViewPosition(new Point((int)dArray2[0], (int)dArray2[1]));
    }

    protected int[] getUpperLeftPointsFromCenter(int n, int n2) {
        int[] nArray = new int[2];
        Rectangle rectangle = this.getViewRectangle();
        nArray[0] = n - rectangle.width / 2;
        nArray[1] = n2 - rectangle.height / 2;
        if (nArray[0] + rectangle.width > this.getX() + this.getWidth()) {
            nArray[0] = this.getX() + this.getWidth() - rectangle.width;
        }
        if (nArray[1] + rectangle.height > this.getY() + this.getHeight()) {
            nArray[1] = this.getY() + this.getHeight() - rectangle.height;
        }
        return nArray;
    }

    class MappedDrawingChangeListener
    implements DrawingChangeListener {
        MappedDrawingChangeListener() {
        }

        public void drawingInvalidated(DrawingChangeEvent drawingChangeEvent) {
            MiniMapView.this.repaint();
        }

        public void drawingRequestUpdate(DrawingChangeEvent drawingChangeEvent) {
            MiniMapView.this.repaint();
        }

        public void drawingTitleChanged(DrawingChangeEvent drawingChangeEvent) {
        }
    }

    class SubjectListener
    implements ChangeListener {
        SubjectListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MiniMapView.this.repaint();
        }
    }

    public class MouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            int[] nArray = MiniMapView.this.getUpperLeftPointsFromCenter(mouseEvent.getX(), mouseEvent.getY());
            MiniMapView.this.scrollSubjectTo(nArray[0], nArray[1]);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int[] nArray = MiniMapView.this.getUpperLeftPointsFromCenter(mouseEvent.getX(), mouseEvent.getY());
            MiniMapView.this.scrollSubjectTo(nArray[0], nArray[1]);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

