/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Sep 14 10:46:31 EDT 2021 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2c.native -fma -compact -variables 4 -pipeline-latency 4 -n 4 -dit -name hc2cf_4 -include rdft/scalar/hc2cf.h */

/*
 * This function contains 22 FP additions, 12 FP multiplications,
 * (or, 16 additions, 6 multiplications, 6 fused multiply/add),
 * 15 stack variables, 0 constants, and 16 memory accesses
 */
#include "rdft/scalar/hc2cf.h"

static void hc2cf_4(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 6); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 6, MAKE_VOLATILE_STRIDE(16, rs)) {
	       E T1, Tv, T7, Tu, Te, To, Tk, Tq;
	       T1 = Rp[0];
	       Tv = Rm[0];
	       {
		    E T3, T6, T4, Tt, T2, T5;
		    T3 = Rp[WS(rs, 1)];
		    T6 = Rm[WS(rs, 1)];
		    T2 = W[2];
		    T4 = T2 * T3;
		    Tt = T2 * T6;
		    T5 = W[3];
		    T7 = FMA(T5, T6, T4);
		    Tu = FNMS(T5, T3, Tt);
	       }
	       {
		    E Ta, Td, Tb, Tn, T9, Tc;
		    Ta = Ip[0];
		    Td = Im[0];
		    T9 = W[0];
		    Tb = T9 * Ta;
		    Tn = T9 * Td;
		    Tc = W[1];
		    Te = FMA(Tc, Td, Tb);
		    To = FNMS(Tc, Ta, Tn);
	       }
	       {
		    E Tg, Tj, Th, Tp, Tf, Ti;
		    Tg = Ip[WS(rs, 1)];
		    Tj = Im[WS(rs, 1)];
		    Tf = W[4];
		    Th = Tf * Tg;
		    Tp = Tf * Tj;
		    Ti = W[5];
		    Tk = FMA(Ti, Tj, Th);
		    Tq = FNMS(Ti, Tg, Tp);
	       }
	       {
		    E T8, Tl, Ts, Tw;
		    T8 = T1 + T7;
		    Tl = Te + Tk;
		    Rm[WS(rs, 1)] = T8 - Tl;
		    Rp[0] = T8 + Tl;
		    Ts = To + Tq;
		    Tw = Tu + Tv;
		    Im[WS(rs, 1)] = Ts - Tw;
		    Ip[0] = Ts + Tw;
	       }
	       {
		    E Tm, Tr, Tx, Ty;
		    Tm = T1 - T7;
		    Tr = To - Tq;
		    Rm[0] = Tm - Tr;
		    Rp[WS(rs, 1)] = Tm + Tr;
		    Tx = Tk - Te;
		    Ty = Tv - Tu;
		    Im[0] = Tx - Ty;
		    Ip[WS(rs, 1)] = Tx + Ty;
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 4 },
     { TW_NEXT, 1, 0 }
};

static const hc2c_desc desc = { 4, "hc2cf_4", twinstr, &GENUS, { 16, 6, 6, 0 } };

void X(codelet_hc2cf_4) (planner *p) {
     X(khc2c_register) (p, hc2cf_4, &desc, HC2C_VIA_RDFT);
}
#else

/* Generated by: ../../../genfft/gen_hc2c.native -compact -variables 4 -pipeline-latency 4 -n 4 -dit -name hc2cf_4 -include rdft/scalar/hc2cf.h */

/*
 * This function contains 22 FP additions, 12 FP multiplications,
 * (or, 16 additions, 6 multiplications, 6 fused multiply/add),
 * 13 stack variables, 0 constants, and 16 memory accesses
 */
#include "rdft/scalar/hc2cf.h"

static void hc2cf_4(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 6); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 6, MAKE_VOLATILE_STRIDE(16, rs)) {
	       E T1, Tp, T6, To, Tc, Tk, Th, Tl;
	       T1 = Rp[0];
	       Tp = Rm[0];
	       {
		    E T3, T5, T2, T4;
		    T3 = Rp[WS(rs, 1)];
		    T5 = Rm[WS(rs, 1)];
		    T2 = W[2];
		    T4 = W[3];
		    T6 = FMA(T2, T3, T4 * T5);
		    To = FNMS(T4, T3, T2 * T5);
	       }
	       {
		    E T9, Tb, T8, Ta;
		    T9 = Ip[0];
		    Tb = Im[0];
		    T8 = W[0];
		    Ta = W[1];
		    Tc = FMA(T8, T9, Ta * Tb);
		    Tk = FNMS(Ta, T9, T8 * Tb);
	       }
	       {
		    E Te, Tg, Td, Tf;
		    Te = Ip[WS(rs, 1)];
		    Tg = Im[WS(rs, 1)];
		    Td = W[4];
		    Tf = W[5];
		    Th = FMA(Td, Te, Tf * Tg);
		    Tl = FNMS(Tf, Te, Td * Tg);
	       }
	       {
		    E T7, Ti, Tn, Tq;
		    T7 = T1 + T6;
		    Ti = Tc + Th;
		    Rm[WS(rs, 1)] = T7 - Ti;
		    Rp[0] = T7 + Ti;
		    Tn = Tk + Tl;
		    Tq = To + Tp;
		    Im[WS(rs, 1)] = Tn - Tq;
		    Ip[0] = Tn + Tq;
	       }
	       {
		    E Tj, Tm, Tr, Ts;
		    Tj = T1 - T6;
		    Tm = Tk - Tl;
		    Rm[0] = Tj - Tm;
		    Rp[WS(rs, 1)] = Tj + Tm;
		    Tr = Th - Tc;
		    Ts = Tp - To;
		    Im[0] = Tr - Ts;
		    Ip[WS(rs, 1)] = Tr + Ts;
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 4 },
     { TW_NEXT, 1, 0 }
};

static const hc2c_desc desc = { 4, "hc2cf_4", twinstr, &GENUS, { 16, 6, 6, 0 } };

void X(codelet_hc2cf_4) (planner *p) {
     X(khc2c_register) (p, hc2cf_4, &desc, HC2C_VIA_RDFT);
}
#endif
