/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Properties;
import IceInternal.Network;

public final class DefaultsAndOverrides {
    public final String defaultHost;
    public final String defaultProtocol;
    public final String defaultRouter;
    public final String defaultLocator;
    public final boolean overrideTimeout;
    public final int overrideTimeoutValue;
    public final boolean overrideConnectTimeout;
    public final int overrideConnectTimeoutValue;

    DefaultsAndOverrides(Properties properties) {
        this.defaultProtocol = properties.getPropertyWithDefault("Ice.Default.Protocol", "tcp");
        String string = properties.getProperty("Ice.Default.Host");
        this.defaultHost = string.length() != 0 ? string : Network.getLocalHost(true);
        this.defaultRouter = properties.getProperty("Ice.Default.Router");
        string = properties.getProperty("Ice.Override.Timeout");
        if (string.length() > 0) {
            this.overrideTimeout = true;
            this.overrideTimeoutValue = properties.getPropertyAsInt("Ice.Override.Timeout");
        } else {
            this.overrideTimeout = false;
            this.overrideTimeoutValue = -1;
        }
        string = properties.getProperty("Ice.Override.ConnectTimeout");
        if (string.length() > 0) {
            this.overrideConnectTimeout = true;
            this.overrideConnectTimeoutValue = properties.getPropertyAsInt("Ice.Override.ConnectTimeout");
        } else {
            this.overrideConnectTimeout = false;
            this.overrideConnectTimeoutValue = -1;
        }
        this.defaultLocator = properties.getProperty("Ice.Default.Locator");
    }
}

