/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_compact;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_immutable;
	result = *_tmp11_;
	return result;
}

void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

void
vala_class_set_is_singleton (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_singleton);
	self->priv->_is_singleton = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SingleInstance", value, NULL);
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp23_ = _tmp28_ > 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaLocalVariable* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		_tmp29_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp30_ = _tmp29_;
		if (_tmp30_ != NULL) {
			ValaScope* _tmp31_;
			ValaScope* _tmp32_;
			ValaLocalVariable* _tmp33_;
			ValaLocalVariable* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp31_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			vala_scope_remove (_tmp32_, _tmp36_);
		}
		_tmp37_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_data_type_copy (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_local_variable_new (_tmp40_, "result", NULL, _tmp42_);
		_tmp44_ = _tmp43_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp44_);
		_vala_code_node_unref0 (_tmp44_);
		_vala_code_node_unref0 (_tmp40_);
		_tmp45_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp46_ = _tmp45_;
		vala_local_variable_set_is_result (_tmp46_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp49_ = FALSE;
		ValaCreationMethod* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		_tmp47_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp48_ = _tmp47_;
		if (_tmp48_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp50_ = cm;
		_tmp51_ = vala_creation_method_get_class_name (_tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp52_ != NULL) {
			ValaCreationMethod* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			_tmp53_ = cm;
			_tmp54_ = vala_creation_method_get_class_name (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp57_ = _tmp56_;
			_tmp49_ = g_strcmp0 (_tmp55_, _tmp57_) != 0;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			ValaSourceReference* _tmp58_;
			ValaSourceReference* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			ValaCreationMethod* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = cm;
			_tmp63_ = vala_creation_method_get_class_name (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp61_, _tmp64_);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp59_, _tmp66_);
			_g_free0 (_tmp66_);
			_g_free0 (_tmp61_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp68_ = self->priv->_is_abstract;
		if (_tmp68_) {
			ValaCreationMethod* _tmp69_;
			ValaSymbolAccessibility _tmp70_;
			ValaSymbolAccessibility _tmp71_;
			_tmp69_ = cm;
			_tmp70_ = vala_symbol_get_access ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp72_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp73_ = _tmp72_;
			if (_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp77_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp14_;
	ValaField* _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaParameter* _tmp4_;
		ValaParameter* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_parameter_new ("this", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		vala_property_set_this_parameter (prop, _tmp5_);
		_vala_code_node_unref0 (_tmp5_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_property_get_this_parameter (prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_property_get_this_parameter (prop);
		_tmp13_ = _tmp12_;
		vala_scope_add (_tmp7_, _tmp11_, (ValaSymbol*) _tmp13_);
	}
	_tmp14_ = vala_property_get_field (prop);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaField* _tmp16_;
		ValaField* _tmp17_;
		_tmp16_ = vala_property_get_field (prop);
		_tmp17_ = _tmp16_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp17_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_constructor_set_this_parameter (c, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_constructor_get_this_parameter (c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_constructor_get_this_parameter (c);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_destructor_set_this_parameter (d, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_destructor_get_this_parameter (d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_destructor_get_this_parameter (d);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp8_;
	ValaConstructor* _tmp9_;
	ValaConstructor* _tmp12_;
	ValaConstructor* _tmp13_;
	ValaConstructor* _tmp16_;
	ValaConstructor* _tmp17_;
	ValaDestructor* _tmp20_;
	ValaDestructor* _tmp21_;
	ValaDestructor* _tmp24_;
	ValaDestructor* _tmp25_;
	ValaDestructor* _tmp28_;
	ValaDestructor* _tmp29_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp8_ = vala_class_get_constructor (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaConstructor* _tmp10_;
		ValaConstructor* _tmp11_;
		_tmp10_ = vala_class_get_constructor (self);
		_tmp11_ = _tmp10_;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
	}
	_tmp12_ = vala_class_get_class_constructor (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaConstructor* _tmp14_;
		ValaConstructor* _tmp15_;
		_tmp14_ = vala_class_get_class_constructor (self);
		_tmp15_ = _tmp14_;
		vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
	}
	_tmp16_ = vala_class_get_static_constructor (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaConstructor* _tmp18_;
		ValaConstructor* _tmp19_;
		_tmp18_ = vala_class_get_static_constructor (self);
		_tmp19_ = _tmp18_;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	}
	_tmp20_ = vala_class_get_destructor (self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		ValaDestructor* _tmp22_;
		ValaDestructor* _tmp23_;
		_tmp22_ = vala_class_get_destructor (self);
		_tmp23_ = _tmp22_;
		vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
	}
	_tmp24_ = vala_class_get_static_destructor (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		ValaDestructor* _tmp26_;
		ValaDestructor* _tmp27_;
		_tmp26_ = vala_class_get_static_destructor (self);
		_tmp27_ = _tmp26_;
		vala_code_node_accept ((ValaCodeNode*) _tmp27_, visitor);
	}
	_tmp28_ = vala_class_get_class_destructor (self);
	_tmp29_ = _tmp28_;
	if (_tmp29_ != NULL) {
		ValaDestructor* _tmp30_;
		ValaDestructor* _tmp31_;
		_tmp30_ = vala_class_get_class_destructor (self);
		_tmp31_ = _tmp30_;
		vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp9_ = base_type;
			_tmp10_ = vala_data_type_get_type_symbol (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = base_type;
				_tmp13_ = vala_data_type_get_type_symbol (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_type_symbol (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp7_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prereq_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prereq_list = _tmp1_;
		_tmp2_ = _prereq_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prereq_size = _tmp4_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp5_ = _prereq_list;
			_tmp6_ = vala_list_get (_tmp5_, _prereq_index);
			prereq = (ValaDataType*) _tmp6_;
			_tmp7_ = prereq;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (_tmp9_);
			type = _tmp10_;
			_tmp11_ = type;
			if (_tmp11_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp12_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp12_);
			_tmp13_ = type;
			if (VALA_IS_INTERFACE (_tmp13_)) {
				ValaTypeSymbol* _tmp14_;
				_tmp14_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp7_ = base_type;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			if (VALA_IS_CLASS (_tmp9_)) {
				ValaDataType* _tmp10_;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp10_ = base_type;
				_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
				_tmp12_ = _tmp11_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp5_ = _base_type_list;
			_tmp6_ = vala_list_get (_tmp5_, _base_type_index);
			base_type = (ValaDataType*) _tmp6_;
			_tmp7_ = base_type;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp86_ = FALSE;
	ValaClass* _tmp87_;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp101_;
	gboolean _tmp102_;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_;
	gboolean _tmp114_;
	gboolean _tmp126_ = FALSE;
	ValaClass* _tmp127_;
	gboolean _tmp139_;
	ValaConstructor* _tmp236_;
	ValaConstructor* _tmp237_;
	ValaConstructor* _tmp240_;
	ValaConstructor* _tmp241_;
	ValaConstructor* _tmp244_;
	ValaConstructor* _tmp245_;
	ValaDestructor* _tmp248_;
	ValaDestructor* _tmp249_;
	ValaDestructor* _tmp252_;
	ValaDestructor* _tmp253_;
	ValaDestructor* _tmp256_;
	ValaDestructor* _tmp257_;
	gboolean _tmp292_;
	gboolean _tmp293_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp334_;
	ValaArrayList* _tmp335_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp350_;
	ValaArrayList* _tmp351_;
	ValaList* _tmp364_;
	gint _tmp365_;
	gint _tmp366_;
	ValaSourceFileType _tmp389_;
	ValaSourceFileType _tmp390_;
	ValaSemanticAnalyzer* _tmp611_;
	ValaSemanticAnalyzer* _tmp612_;
	ValaSourceFile* _tmp613_;
	ValaSemanticAnalyzer* _tmp614_;
	ValaSemanticAnalyzer* _tmp615_;
	ValaSymbol* _tmp616_;
	gboolean _tmp617_;
	gboolean _tmp618_;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_base_type_reference_list = _tmp25_;
		_tmp26_ = _base_type_reference_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_base_type_reference_size = _tmp28_;
		_base_type_reference_index = -1;
		while (TRUE) {
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp29_;
			gpointer _tmp30_;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaDataType* _tmp44_;
			gint n_type_args = 0;
			ValaDataType* _tmp54_;
			ValaList* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			gint n_type_params = 0;
			ValaDataType* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			ValaTypeSymbol* _tmp60_;
			ValaList* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			_base_type_reference_index = _base_type_reference_index + 1;
			if (!(_base_type_reference_index < _base_type_reference_size)) {
				break;
			}
			_tmp29_ = _base_type_reference_list;
			_tmp30_ = vala_list_get (_tmp29_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp30_;
			_tmp31_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp31_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp32_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp32_)) {
				ValaSourceReference* _tmp33_;
				ValaSourceReference* _tmp34_;
				ValaDataType* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = base_type_reference;
				_tmp36_ = vala_code_node_to_string ((ValaCodeNode*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strdup_printf ("base type `%s' of class `%s' is not an object type", _tmp37_, _tmp39_);
				_tmp41_ = _tmp40_;
				vala_report_error (_tmp34_, _tmp41_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				_g_free0 (_tmp37_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp43_, (ValaSymbol*) self, _tmp44_)) {
				ValaSourceReference* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaDataType* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp46_ = _tmp45_;
				_tmp47_ = base_type_reference;
				_tmp48_ = vala_code_node_to_string ((ValaCodeNode*) _tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strdup_printf ("base type `%s' is less accessible than class `%s'", _tmp49_, _tmp51_);
				_tmp53_ = _tmp52_;
				vala_report_error (_tmp46_, _tmp53_);
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp54_ = base_type_reference;
			_tmp55_ = vala_data_type_get_type_arguments (_tmp54_);
			_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
			_tmp57_ = _tmp56_;
			n_type_args = _tmp57_;
			_tmp58_ = base_type_reference;
			_tmp59_ = vala_data_type_get_type_symbol (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
			_tmp63_ = _tmp62_;
			n_type_params = _tmp63_;
			if (n_type_args < n_type_params) {
				ValaDataType* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaSourceReference* _tmp66_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp64_ = base_type_reference;
				_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
				_tmp66_ = _tmp65_;
				vala_report_error (_tmp66_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				if (n_type_args > n_type_params) {
					ValaDataType* _tmp67_;
					ValaSourceReference* _tmp68_;
					ValaSourceReference* _tmp69_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp67_ = base_type_reference;
					_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
					_tmp69_ = _tmp68_;
					vala_report_error (_tmp69_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp70_;
		ValaList* _tmp71_;
		gint _type_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _type_index = 0;
		_tmp70_ = self->priv->base_types;
		_tmp71_ = _vala_iterable_ref0 (_tmp70_);
		_type_list = _tmp71_;
		_tmp72_ = _type_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_type_size = _tmp74_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp75_;
			gpointer _tmp76_;
			ValaDataType* _tmp77_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp75_ = _type_list;
			_tmp76_ = vala_list_get (_tmp75_, _type_index);
			type = (ValaDataType*) _tmp76_;
			_tmp77_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp77_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp78_;
		ValaList* _tmp79_;
		gint _p_size = 0;
		ValaList* _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint _p_index = 0;
		_tmp78_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_tmp79_ = _vala_iterable_ref0 (_tmp78_);
		_p_list = _tmp79_;
		_tmp80_ = _p_list;
		_tmp81_ = vala_collection_get_size ((ValaCollection*) _tmp80_);
		_tmp82_ = _tmp81_;
		_p_size = _tmp82_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp83_;
			gpointer _tmp84_;
			ValaTypeParameter* _tmp85_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp83_ = _p_list;
			_tmp84_ = vala_list_get (_tmp83_, _p_index);
			p = (ValaTypeParameter*) _tmp84_;
			_tmp85_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp85_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp87_ = self->priv->_base_class;
	if (_tmp87_ != NULL) {
		ValaClass* _tmp88_;
		gboolean _tmp89_;
		gboolean _tmp90_;
		_tmp88_ = self->priv->_base_class;
		_tmp89_ = vala_class_get_is_singleton (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp86_ = _tmp90_;
	} else {
		_tmp86_ = FALSE;
	}
	if (_tmp86_) {
		ValaSourceReference* _tmp91_;
		ValaSourceReference* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		ValaClass* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp92_ = _tmp91_;
		_tmp93_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = self->priv->_base_class;
		_tmp96_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = g_strdup_printf ("`%s' cannot inherit from SingleInstance class `%s'", _tmp94_, _tmp97_);
		_tmp99_ = _tmp98_;
		vala_report_error (_tmp92_, _tmp99_);
		_g_free0 (_tmp99_);
		_g_free0 (_tmp97_);
		_g_free0 (_tmp94_);
	}
	_tmp101_ = vala_class_get_is_singleton (self);
	_tmp102_ = _tmp101_;
	if (_tmp102_) {
		ValaSemanticAnalyzer* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaClass* _tmp105_;
		_tmp103_ = vala_code_context_get_analyzer (context);
		_tmp104_ = _tmp103_;
		_tmp105_ = _tmp104_->object_type;
		_tmp100_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp105_);
	} else {
		_tmp100_ = FALSE;
	}
	if (_tmp100_) {
		ValaSourceReference* _tmp106_;
		ValaSourceReference* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp109_ = _tmp108_;
		_tmp110_ = g_strdup_printf ("SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp109_);
		_tmp111_ = _tmp110_;
		vala_report_error (_tmp107_, _tmp111_);
		_g_free0 (_tmp111_);
		_g_free0 (_tmp109_);
	}
	_tmp113_ = vala_class_get_is_singleton (self);
	_tmp114_ = _tmp113_;
	if (_tmp114_) {
		ValaConstructor* _tmp115_;
		ValaConstructor* _tmp116_;
		_tmp115_ = vala_class_get_constructor (self);
		_tmp116_ = _tmp115_;
		_tmp112_ = _tmp116_ == NULL;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp117_;
		ValaSourceReference* _tmp118_;
		ValaConstructor* _tmp119_;
		ValaConstructor* _tmp120_;
		ValaSourceReference* _tmp121_;
		ValaSourceReference* _tmp122_;
		ValaBlock* _tmp123_;
		ValaBlock* _tmp124_;
		ValaConstructor* _tmp125_;
		_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_constructor_new (_tmp118_);
		c = _tmp119_;
		_tmp120_ = c;
		_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_block_new (_tmp122_);
		_tmp124_ = _tmp123_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp120_, _tmp124_);
		_vala_code_node_unref0 (_tmp124_);
		_tmp125_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp125_);
		_vala_code_node_unref0 (c);
	}
	_tmp127_ = self->priv->_base_class;
	if (_tmp127_ != NULL) {
		ValaClass* _tmp128_;
		gboolean _tmp129_;
		_tmp128_ = self->priv->_base_class;
		_tmp129_ = _tmp128_->priv->_is_sealed;
		_tmp126_ = _tmp129_;
	} else {
		_tmp126_ = FALSE;
	}
	if (_tmp126_) {
		ValaSourceReference* _tmp130_;
		ValaSourceReference* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		ValaClass* _tmp134_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		gchar* _tmp138_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = self->priv->_base_class;
		_tmp135_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp134_);
		_tmp136_ = _tmp135_;
		_tmp137_ = g_strdup_printf ("`%s' cannot inherit from sealed class `%s'", _tmp133_, _tmp136_);
		_tmp138_ = _tmp137_;
		vala_report_error (_tmp131_, _tmp138_);
		_g_free0 (_tmp138_);
		_g_free0 (_tmp136_);
		_g_free0 (_tmp133_);
	}
	_tmp139_ = self->priv->_is_sealed;
	if (_tmp139_) {
		gboolean _tmp140_;
		gboolean _tmp141_;
		gboolean _tmp148_;
		gboolean _tmp155_;
		gboolean _tmp156_;
		_tmp140_ = vala_class_get_is_compact (self);
		_tmp141_ = _tmp140_;
		if (_tmp141_) {
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp145_ = _tmp144_;
			_tmp146_ = g_strdup_printf ("Sealed class `%s' cannot be compact", _tmp145_);
			_tmp147_ = _tmp146_;
			vala_report_error (_tmp143_, _tmp147_);
			_g_free0 (_tmp147_);
			_g_free0 (_tmp145_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp148_ = self->priv->_is_abstract;
		if (_tmp148_) {
			ValaSourceReference* _tmp149_;
			ValaSourceReference* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp152_ = _tmp151_;
			_tmp153_ = g_strdup_printf ("Sealed class `%s' cannot be abstract", _tmp152_);
			_tmp154_ = _tmp153_;
			vala_report_error (_tmp150_, _tmp154_);
			_g_free0 (_tmp154_);
			_g_free0 (_tmp152_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp155_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp156_ = _tmp155_;
		if (!_tmp156_) {
			ValaSourceReference* _tmp157_;
			ValaSourceReference* _tmp158_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp158_ = _tmp157_;
			vala_report_error (_tmp158_, "Sealed classes are not fully supported yet");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp159_;
		ValaList* _tmp160_;
		gint _en_size = 0;
		ValaList* _tmp161_;
		gint _tmp162_;
		gint _tmp163_;
		gint _en_index = 0;
		_tmp159_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_tmp160_ = _vala_iterable_ref0 (_tmp159_);
		_en_list = _tmp160_;
		_tmp161_ = _en_list;
		_tmp162_ = vala_collection_get_size ((ValaCollection*) _tmp161_);
		_tmp163_ = _tmp162_;
		_en_size = _tmp163_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp164_;
			gpointer _tmp165_;
			ValaEnum* _tmp166_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp164_ = _en_list;
			_tmp165_ = vala_list_get (_tmp164_, _en_index);
			en = (ValaEnum*) _tmp165_;
			_tmp166_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp166_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp167_;
		ValaList* _tmp168_;
		gint _f_size = 0;
		ValaList* _tmp169_;
		gint _tmp170_;
		gint _tmp171_;
		gint _f_index = 0;
		_tmp167_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_tmp168_ = _vala_iterable_ref0 (_tmp167_);
		_f_list = _tmp168_;
		_tmp169_ = _f_list;
		_tmp170_ = vala_collection_get_size ((ValaCollection*) _tmp169_);
		_tmp171_ = _tmp170_;
		_f_size = _tmp171_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp172_;
			gpointer _tmp173_;
			gboolean _tmp174_ = FALSE;
			gboolean _tmp175_;
			gboolean _tmp176_;
			ValaField* _tmp194_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp172_ = _f_list;
			_tmp173_ = vala_list_get (_tmp172_, _f_index);
			f = (ValaField*) _tmp173_;
			_tmp175_ = vala_class_get_is_compact (self);
			_tmp176_ = _tmp175_;
			if (_tmp176_) {
				ValaField* _tmp177_;
				ValaMemberBinding _tmp178_;
				ValaMemberBinding _tmp179_;
				_tmp177_ = f;
				_tmp178_ = vala_field_get_binding (_tmp177_);
				_tmp179_ = _tmp178_;
				_tmp174_ = _tmp179_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp174_ = FALSE;
			}
			if (_tmp174_) {
				gboolean _tmp180_ = FALSE;
				gboolean _tmp181_;
				gboolean _tmp182_;
				ValaField* _tmp188_;
				ValaMemberBinding _tmp189_;
				ValaMemberBinding _tmp190_;
				_tmp181_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp182_ = _tmp181_;
				if (!_tmp182_) {
					ValaField* _tmp183_;
					ValaSymbolAccessibility _tmp184_;
					ValaSymbolAccessibility _tmp185_;
					_tmp183_ = f;
					_tmp184_ = vala_symbol_get_access ((ValaSymbol*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp180_ = _tmp185_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp180_ = FALSE;
				}
				if (_tmp180_) {
					ValaSourceReference* _tmp186_;
					ValaSourceReference* _tmp187_;
					_tmp186_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp187_ = _tmp186_;
					vala_report_error (_tmp187_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp188_ = f;
				_tmp189_ = vala_field_get_binding (_tmp188_);
				_tmp190_ = _tmp189_;
				if (_tmp190_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp191_;
					ValaSourceReference* _tmp192_;
					ValaSourceReference* _tmp193_;
					_tmp191_ = f;
					_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp191_);
					_tmp193_ = _tmp192_;
					vala_report_error (_tmp193_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp194_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp194_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp195_;
		ValaList* _tmp196_;
		gint _c_size = 0;
		ValaList* _tmp197_;
		gint _tmp198_;
		gint _tmp199_;
		gint _c_index = 0;
		_tmp195_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_tmp196_ = _vala_iterable_ref0 (_tmp195_);
		_c_list = _tmp196_;
		_tmp197_ = _c_list;
		_tmp198_ = vala_collection_get_size ((ValaCollection*) _tmp197_);
		_tmp199_ = _tmp198_;
		_c_size = _tmp199_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp200_;
			gpointer _tmp201_;
			ValaConstant* _tmp202_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp200_ = _c_list;
			_tmp201_ = vala_list_get (_tmp200_, _c_index);
			c = (ValaConstant*) _tmp201_;
			_tmp202_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp202_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp203_;
		ValaList* _tmp204_;
		gint _m_size = 0;
		ValaList* _tmp205_;
		gint _tmp206_;
		gint _tmp207_;
		gint _m_index = 0;
		_tmp203_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_tmp204_ = _vala_iterable_ref0 (_tmp203_);
		_m_list = _tmp204_;
		_tmp205_ = _m_list;
		_tmp206_ = vala_collection_get_size ((ValaCollection*) _tmp205_);
		_tmp207_ = _tmp206_;
		_m_size = _tmp207_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp208_;
			gpointer _tmp209_;
			ValaMethod* _tmp210_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp208_ = _m_list;
			_tmp209_ = vala_list_get (_tmp208_, _m_index);
			m = (ValaMethod*) _tmp209_;
			_tmp210_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp210_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp211_;
		ValaList* _tmp212_;
		gint _prop_size = 0;
		ValaList* _tmp213_;
		gint _tmp214_;
		gint _tmp215_;
		gint _prop_index = 0;
		_tmp211_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_tmp212_ = _vala_iterable_ref0 (_tmp211_);
		_prop_list = _tmp212_;
		_tmp213_ = _prop_list;
		_tmp214_ = vala_collection_get_size ((ValaCollection*) _tmp213_);
		_tmp215_ = _tmp214_;
		_prop_size = _tmp215_;
		_prop_index = -1;
		while (TRUE) {
			ValaProperty* prop = NULL;
			ValaList* _tmp216_;
			gpointer _tmp217_;
			gboolean _tmp218_ = FALSE;
			ValaProperty* _tmp219_;
			ValaAttribute* _tmp220_;
			ValaProperty* _tmp227_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp216_ = _prop_list;
			_tmp217_ = vala_list_get (_tmp216_, _prop_index);
			prop = (ValaProperty*) _tmp217_;
			_tmp219_ = prop;
			_tmp220_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp219_, "NoAccessorMethod");
			if (_tmp220_ != NULL) {
				ValaSemanticAnalyzer* _tmp221_;
				ValaSemanticAnalyzer* _tmp222_;
				ValaClass* _tmp223_;
				_tmp221_ = vala_code_context_get_analyzer (context);
				_tmp222_ = _tmp221_;
				_tmp223_ = _tmp222_->object_type;
				_tmp218_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp223_);
			} else {
				_tmp218_ = FALSE;
			}
			if (_tmp218_) {
				ValaProperty* _tmp224_;
				ValaSourceReference* _tmp225_;
				ValaSourceReference* _tmp226_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp224_ = prop;
				_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp224_);
				_tmp226_ = _tmp225_;
				vala_report_error (_tmp226_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp227_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp227_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp228_;
		ValaList* _tmp229_;
		gint _sig_size = 0;
		ValaList* _tmp230_;
		gint _tmp231_;
		gint _tmp232_;
		gint _sig_index = 0;
		_tmp228_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_tmp229_ = _vala_iterable_ref0 (_tmp228_);
		_sig_list = _tmp229_;
		_tmp230_ = _sig_list;
		_tmp231_ = vala_collection_get_size ((ValaCollection*) _tmp230_);
		_tmp232_ = _tmp231_;
		_sig_size = _tmp232_;
		_sig_index = -1;
		while (TRUE) {
			ValaSignal* sig = NULL;
			ValaList* _tmp233_;
			gpointer _tmp234_;
			ValaSignal* _tmp235_;
			_sig_index = _sig_index + 1;
			if (!(_sig_index < _sig_size)) {
				break;
			}
			_tmp233_ = _sig_list;
			_tmp234_ = vala_list_get (_tmp233_, _sig_index);
			sig = (ValaSignal*) _tmp234_;
			_tmp235_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp235_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp236_ = vala_class_get_constructor (self);
	_tmp237_ = _tmp236_;
	if (_tmp237_ != NULL) {
		ValaConstructor* _tmp238_;
		ValaConstructor* _tmp239_;
		_tmp238_ = vala_class_get_constructor (self);
		_tmp239_ = _tmp238_;
		vala_code_node_check ((ValaCodeNode*) _tmp239_, context);
	}
	_tmp240_ = vala_class_get_class_constructor (self);
	_tmp241_ = _tmp240_;
	if (_tmp241_ != NULL) {
		ValaConstructor* _tmp242_;
		ValaConstructor* _tmp243_;
		_tmp242_ = vala_class_get_class_constructor (self);
		_tmp243_ = _tmp242_;
		vala_code_node_check ((ValaCodeNode*) _tmp243_, context);
	}
	_tmp244_ = vala_class_get_static_constructor (self);
	_tmp245_ = _tmp244_;
	if (_tmp245_ != NULL) {
		ValaConstructor* _tmp246_;
		ValaConstructor* _tmp247_;
		_tmp246_ = vala_class_get_static_constructor (self);
		_tmp247_ = _tmp246_;
		vala_code_node_check ((ValaCodeNode*) _tmp247_, context);
	}
	_tmp248_ = vala_class_get_destructor (self);
	_tmp249_ = _tmp248_;
	if (_tmp249_ != NULL) {
		ValaDestructor* _tmp250_;
		ValaDestructor* _tmp251_;
		_tmp250_ = vala_class_get_destructor (self);
		_tmp251_ = _tmp250_;
		vala_code_node_check ((ValaCodeNode*) _tmp251_, context);
	}
	_tmp252_ = vala_class_get_static_destructor (self);
	_tmp253_ = _tmp252_;
	if (_tmp253_ != NULL) {
		ValaDestructor* _tmp254_;
		ValaDestructor* _tmp255_;
		_tmp254_ = vala_class_get_static_destructor (self);
		_tmp255_ = _tmp254_;
		vala_code_node_check ((ValaCodeNode*) _tmp255_, context);
	}
	_tmp256_ = vala_class_get_class_destructor (self);
	_tmp257_ = _tmp256_;
	if (_tmp257_ != NULL) {
		ValaDestructor* _tmp258_;
		ValaDestructor* _tmp259_;
		_tmp258_ = vala_class_get_class_destructor (self);
		_tmp259_ = _tmp258_;
		vala_code_node_check ((ValaCodeNode*) _tmp259_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp260_;
		ValaList* _tmp261_;
		gint _cl_size = 0;
		ValaList* _tmp262_;
		gint _tmp263_;
		gint _tmp264_;
		gint _cl_index = 0;
		_tmp260_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_tmp261_ = _vala_iterable_ref0 (_tmp260_);
		_cl_list = _tmp261_;
		_tmp262_ = _cl_list;
		_tmp263_ = vala_collection_get_size ((ValaCollection*) _tmp262_);
		_tmp264_ = _tmp263_;
		_cl_size = _tmp264_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp265_;
			gpointer _tmp266_;
			ValaClass* _tmp267_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp265_ = _cl_list;
			_tmp266_ = vala_list_get (_tmp265_, _cl_index);
			cl = (ValaClass*) _tmp266_;
			_tmp267_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp267_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp268_;
		ValaList* _tmp269_;
		gint _iface_size = 0;
		ValaList* _tmp270_;
		gint _tmp271_;
		gint _tmp272_;
		gint _iface_index = 0;
		_tmp268_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_tmp269_ = _vala_iterable_ref0 (_tmp268_);
		_iface_list = _tmp269_;
		_tmp270_ = _iface_list;
		_tmp271_ = vala_collection_get_size ((ValaCollection*) _tmp270_);
		_tmp272_ = _tmp271_;
		_iface_size = _tmp272_;
		_iface_index = -1;
		while (TRUE) {
			ValaInterface* iface = NULL;
			ValaList* _tmp273_;
			gpointer _tmp274_;
			ValaInterface* _tmp275_;
			_iface_index = _iface_index + 1;
			if (!(_iface_index < _iface_size)) {
				break;
			}
			_tmp273_ = _iface_list;
			_tmp274_ = vala_list_get (_tmp273_, _iface_index);
			iface = (ValaInterface*) _tmp274_;
			_tmp275_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp275_, context);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp276_;
		ValaList* _tmp277_;
		gint _st_size = 0;
		ValaList* _tmp278_;
		gint _tmp279_;
		gint _tmp280_;
		gint _st_index = 0;
		_tmp276_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_tmp277_ = _vala_iterable_ref0 (_tmp276_);
		_st_list = _tmp277_;
		_tmp278_ = _st_list;
		_tmp279_ = vala_collection_get_size ((ValaCollection*) _tmp278_);
		_tmp280_ = _tmp279_;
		_st_size = _tmp280_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp281_;
			gpointer _tmp282_;
			ValaStruct* _tmp283_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp281_ = _st_list;
			_tmp282_ = vala_list_get (_tmp281_, _st_index);
			st = (ValaStruct*) _tmp282_;
			_tmp283_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp283_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp284_;
		ValaList* _tmp285_;
		gint _d_size = 0;
		ValaList* _tmp286_;
		gint _tmp287_;
		gint _tmp288_;
		gint _d_index = 0;
		_tmp284_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_tmp285_ = _vala_iterable_ref0 (_tmp284_);
		_d_list = _tmp285_;
		_tmp286_ = _d_list;
		_tmp287_ = vala_collection_get_size ((ValaCollection*) _tmp286_);
		_tmp288_ = _tmp287_;
		_d_size = _tmp288_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp289_;
			gpointer _tmp290_;
			ValaDelegate* _tmp291_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp289_ = _d_list;
			_tmp290_ = vala_list_get (_tmp289_, _d_index);
			d = (ValaDelegate*) _tmp290_;
			_tmp291_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp291_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp292_ = vala_class_get_is_compact (self);
	_tmp293_ = _tmp292_;
	if (_tmp293_) {
		gboolean _tmp310_ = FALSE;
		gboolean _tmp311_ = FALSE;
		gboolean _tmp312_ = FALSE;
		gboolean _tmp313_;
		gboolean _tmp314_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp294_;
			ValaList* _tmp295_;
			gint _base_type_size = 0;
			ValaList* _tmp296_;
			gint _tmp297_;
			gint _tmp298_;
			gint _base_type_index = 0;
			_tmp294_ = vala_class_get_base_types (self);
			_tmp295_ = _vala_iterable_ref0 (_tmp294_);
			_base_type_list = _tmp295_;
			_tmp296_ = _base_type_list;
			_tmp297_ = vala_collection_get_size ((ValaCollection*) _tmp296_);
			_tmp298_ = _tmp297_;
			_base_type_size = _tmp298_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp299_;
				gpointer _tmp300_;
				ValaDataType* _tmp301_;
				ValaTypeSymbol* _tmp302_;
				ValaTypeSymbol* _tmp303_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp299_ = _base_type_list;
				_tmp300_ = vala_list_get (_tmp299_, _base_type_index);
				base_type = (ValaDataType*) _tmp300_;
				_tmp301_ = base_type;
				_tmp302_ = vala_data_type_get_type_symbol (_tmp301_);
				_tmp303_ = _tmp302_;
				if (VALA_IS_INTERFACE (_tmp303_)) {
					ValaSourceReference* _tmp304_;
					ValaSourceReference* _tmp305_;
					gchar* _tmp306_;
					gchar* _tmp307_;
					gchar* _tmp308_;
					gchar* _tmp309_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp304_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp305_ = _tmp304_;
					_tmp306_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp307_ = _tmp306_;
					_tmp308_ = g_strdup_printf ("compact classes `%s' may not implement interfaces", _tmp307_);
					_tmp309_ = _tmp308_;
					vala_report_error (_tmp305_, _tmp309_);
					_g_free0 (_tmp309_);
					_g_free0 (_tmp307_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp313_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp314_ = _tmp313_;
		if (!_tmp314_) {
			gboolean _tmp315_;
			gboolean _tmp316_;
			_tmp315_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp316_ = _tmp315_;
			_tmp312_ = !_tmp316_;
		} else {
			_tmp312_ = FALSE;
		}
		if (_tmp312_) {
			ValaClass* _tmp317_;
			_tmp317_ = self->priv->_base_class;
			_tmp311_ = _tmp317_ != NULL;
		} else {
			_tmp311_ = FALSE;
		}
		if (_tmp311_) {
			ValaClass* _tmp318_;
			ValaSemanticAnalyzer* _tmp319_;
			ValaSemanticAnalyzer* _tmp320_;
			ValaClass* _tmp321_;
			_tmp318_ = self->priv->_base_class;
			_tmp319_ = vala_code_context_get_analyzer (context);
			_tmp320_ = _tmp319_;
			_tmp321_ = _tmp320_->gsource_type;
			_tmp310_ = _tmp318_ != _tmp321_;
		} else {
			_tmp310_ = FALSE;
		}
		if (_tmp310_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp322_;
				ValaList* _tmp323_;
				gint _f_size = 0;
				ValaList* _tmp324_;
				gint _tmp325_;
				gint _tmp326_;
				gint _f_index = 0;
				_tmp322_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_tmp323_ = _vala_iterable_ref0 (_tmp322_);
				_f_list = _tmp323_;
				_tmp324_ = _f_list;
				_tmp325_ = vala_collection_get_size ((ValaCollection*) _tmp324_);
				_tmp326_ = _tmp325_;
				_f_size = _tmp326_;
				_f_index = -1;
				while (TRUE) {
					ValaField* f = NULL;
					ValaList* _tmp327_;
					gpointer _tmp328_;
					ValaField* _tmp329_;
					ValaMemberBinding _tmp330_;
					ValaMemberBinding _tmp331_;
					_f_index = _f_index + 1;
					if (!(_f_index < _f_size)) {
						break;
					}
					_tmp327_ = _f_list;
					_tmp328_ = vala_list_get (_tmp327_, _f_index);
					f = (ValaField*) _tmp328_;
					_tmp329_ = f;
					_tmp330_ = vala_field_get_binding (_tmp329_);
					_tmp331_ = _tmp330_;
					if (_tmp331_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp332_;
						ValaSourceReference* _tmp333_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp333_ = _tmp332_;
						vala_report_error (_tmp333_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp334_ = g_direct_equal;
	_tmp335_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp334_);
	prerequisites = (ValaList*) _tmp335_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp336_;
		ValaList* _tmp337_;
		gint _base_type_size = 0;
		ValaList* _tmp338_;
		gint _tmp339_;
		gint _tmp340_;
		gint _base_type_index = 0;
		_tmp336_ = vala_class_get_base_types (self);
		_tmp337_ = _vala_iterable_ref0 (_tmp336_);
		_base_type_list = _tmp337_;
		_tmp338_ = _base_type_list;
		_tmp339_ = vala_collection_get_size ((ValaCollection*) _tmp338_);
		_tmp340_ = _tmp339_;
		_base_type_size = _tmp340_;
		_base_type_index = -1;
		while (TRUE) {
			ValaDataType* base_type = NULL;
			ValaList* _tmp341_;
			gpointer _tmp342_;
			ValaDataType* _tmp343_;
			ValaTypeSymbol* _tmp344_;
			ValaTypeSymbol* _tmp345_;
			_base_type_index = _base_type_index + 1;
			if (!(_base_type_index < _base_type_size)) {
				break;
			}
			_tmp341_ = _base_type_list;
			_tmp342_ = vala_list_get (_tmp341_, _base_type_index);
			base_type = (ValaDataType*) _tmp342_;
			_tmp343_ = base_type;
			_tmp344_ = vala_data_type_get_type_symbol (_tmp343_);
			_tmp345_ = _tmp344_;
			if (VALA_IS_INTERFACE (_tmp345_)) {
				ValaDataType* _tmp346_;
				ValaTypeSymbol* _tmp347_;
				ValaTypeSymbol* _tmp348_;
				ValaList* _tmp349_;
				_tmp346_ = base_type;
				_tmp347_ = vala_data_type_get_type_symbol (_tmp346_);
				_tmp348_ = _tmp347_;
				_tmp349_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp348_, VALA_TYPE_INTERFACE, ValaInterface), _tmp349_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp350_ = g_direct_equal;
	_tmp351_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp350_);
	missing_prereqs = (ValaList*) _tmp351_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp352_;
		ValaList* _tmp353_;
		gint _prereq_size = 0;
		ValaList* _tmp354_;
		gint _tmp355_;
		gint _tmp356_;
		gint _prereq_index = 0;
		_tmp352_ = prerequisites;
		_tmp353_ = _vala_iterable_ref0 (_tmp352_);
		_prereq_list = _tmp353_;
		_tmp354_ = _prereq_list;
		_tmp355_ = vala_collection_get_size ((ValaCollection*) _tmp354_);
		_tmp356_ = _tmp355_;
		_prereq_size = _tmp356_;
		_prereq_index = -1;
		while (TRUE) {
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp357_;
			gpointer _tmp358_;
			ValaTypeSymbol* _tmp359_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp357_ = _prereq_list;
			_tmp358_ = vala_list_get (_tmp357_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp358_;
			_tmp359_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp359_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp360_;
				ValaTypeSymbol* _tmp361_;
				gchar* _tmp362_;
				gchar* _tmp363_;
				_tmp360_ = missing_prereqs;
				_tmp361_ = prereq;
				_tmp362_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp361_);
				_tmp363_ = _tmp362_;
				vala_list_insert (_tmp360_, 0, _tmp363_);
				_g_free0 (_tmp363_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp364_ = missing_prereqs;
	_tmp365_ = vala_collection_get_size ((ValaCollection*) _tmp364_);
	_tmp366_ = _tmp365_;
	if (_tmp366_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp367_;
		gchar* _tmp368_;
		gchar* _tmp369_;
		gchar* _tmp370_;
		gboolean first = FALSE;
		const gchar* _tmp384_;
		gchar* _tmp385_;
		ValaSourceReference* _tmp386_;
		ValaSourceReference* _tmp387_;
		const gchar* _tmp388_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp367_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp368_ = _tmp367_;
		_tmp369_ = g_strdup_printf ("%s: some prerequisites (", _tmp368_);
		_tmp370_ = _tmp369_;
		_g_free0 (_tmp368_);
		error_string = _tmp370_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp371_;
			ValaList* _tmp372_;
			gint _s_size = 0;
			ValaList* _tmp373_;
			gint _tmp374_;
			gint _tmp375_;
			gint _s_index = 0;
			_tmp371_ = missing_prereqs;
			_tmp372_ = _vala_iterable_ref0 (_tmp371_);
			_s_list = _tmp372_;
			_tmp373_ = _s_list;
			_tmp374_ = vala_collection_get_size ((ValaCollection*) _tmp373_);
			_tmp375_ = _tmp374_;
			_s_size = _tmp375_;
			_s_index = -1;
			while (TRUE) {
				gchar* s = NULL;
				ValaList* _tmp376_;
				gpointer _tmp377_;
				_s_index = _s_index + 1;
				if (!(_s_index < _s_size)) {
					break;
				}
				_tmp376_ = _s_list;
				_tmp377_ = vala_list_get (_tmp376_, _s_index);
				s = (gchar*) _tmp377_;
				if (first) {
					const gchar* _tmp378_;
					const gchar* _tmp379_;
					gchar* _tmp380_;
					_tmp378_ = error_string;
					_tmp379_ = s;
					_tmp380_ = g_strdup_printf ("%s`%s'", _tmp378_, _tmp379_);
					_g_free0 (error_string);
					error_string = _tmp380_;
					first = FALSE;
				} else {
					const gchar* _tmp381_;
					const gchar* _tmp382_;
					gchar* _tmp383_;
					_tmp381_ = error_string;
					_tmp382_ = s;
					_tmp383_ = g_strdup_printf ("%s, `%s'", _tmp381_, _tmp382_);
					_g_free0 (error_string);
					error_string = _tmp383_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp384_ = error_string;
		_tmp385_ = g_strconcat (_tmp384_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp385_;
		_tmp386_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp387_ = _tmp386_;
		_tmp388_ = error_string;
		vala_report_error (_tmp387_, _tmp388_);
		_g_free0 (error_string);
	}
	_tmp389_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp390_ = _tmp389_;
	if (_tmp390_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp543_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp391_;
			ValaList* _tmp392_;
			gint _base_type_size = 0;
			ValaList* _tmp393_;
			gint _tmp394_;
			gint _tmp395_;
			gint _base_type_index = 0;
			_tmp391_ = vala_class_get_base_types (self);
			_tmp392_ = _vala_iterable_ref0 (_tmp391_);
			_base_type_list = _tmp392_;
			_tmp393_ = _base_type_list;
			_tmp394_ = vala_collection_get_size ((ValaCollection*) _tmp393_);
			_tmp395_ = _tmp394_;
			_base_type_size = _tmp395_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp396_;
				gpointer _tmp397_;
				ValaDataType* _tmp398_;
				ValaTypeSymbol* _tmp399_;
				ValaTypeSymbol* _tmp400_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp396_ = _base_type_list;
				_tmp397_ = vala_list_get (_tmp396_, _base_type_index);
				base_type = (ValaDataType*) _tmp397_;
				_tmp398_ = base_type;
				_tmp399_ = vala_data_type_get_type_symbol (_tmp398_);
				_tmp400_ = _tmp399_;
				if (VALA_IS_INTERFACE (_tmp400_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp401_;
					ValaTypeSymbol* _tmp402_;
					ValaTypeSymbol* _tmp403_;
					gboolean _tmp404_ = FALSE;
					ValaClass* _tmp405_;
					_tmp401_ = base_type;
					_tmp402_ = vala_data_type_get_type_symbol (_tmp401_);
					_tmp403_ = _tmp402_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp403_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp405_ = self->priv->_base_class;
					if (_tmp405_ != NULL) {
						ValaClass* _tmp406_;
						ValaInterface* _tmp407_;
						_tmp406_ = self->priv->_base_class;
						_tmp407_ = iface;
						_tmp404_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp406_, (ValaTypeSymbol*) _tmp407_);
					} else {
						_tmp404_ = FALSE;
					}
					if (_tmp404_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp408_;
						ValaList* _tmp409_;
						ValaList* _tmp410_;
						gint _m_size = 0;
						ValaList* _tmp411_;
						gint _tmp412_;
						gint _tmp413_;
						gint _m_index = 0;
						_tmp408_ = iface;
						_tmp409_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp408_);
						_tmp410_ = _vala_iterable_ref0 (_tmp409_);
						_m_list = _tmp410_;
						_tmp411_ = _m_list;
						_tmp412_ = vala_collection_get_size ((ValaCollection*) _tmp411_);
						_tmp413_ = _tmp412_;
						_m_size = _tmp413_;
						_m_index = -1;
						while (TRUE) {
							ValaMethod* m = NULL;
							ValaList* _tmp414_;
							gpointer _tmp415_;
							ValaMethod* _tmp416_;
							gboolean _tmp417_;
							gboolean _tmp418_;
							_m_index = _m_index + 1;
							if (!(_m_index < _m_size)) {
								break;
							}
							_tmp414_ = _m_list;
							_tmp415_ = vala_list_get (_tmp414_, _m_index);
							m = (ValaMethod*) _tmp415_;
							_tmp416_ = m;
							_tmp417_ = vala_method_get_is_abstract (_tmp416_);
							_tmp418_ = _tmp417_;
							if (_tmp418_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp419_ = FALSE;
									ValaClass* _tmp420_;
									ValaClass* _tmp472_;
									ValaClass* _tmp473_;
									_tmp420_ = base_class;
									if (_tmp420_ != NULL) {
										_tmp419_ = !implemented;
									} else {
										_tmp419_ = FALSE;
									}
									if (!_tmp419_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp421_;
										ValaList* _tmp422_;
										ValaList* _tmp423_;
										gint _impl_size = 0;
										ValaList* _tmp424_;
										gint _tmp425_;
										gint _tmp426_;
										gint _impl_index = 0;
										_tmp421_ = base_class;
										_tmp422_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp421_);
										_tmp423_ = _vala_iterable_ref0 (_tmp422_);
										_impl_list = _tmp423_;
										_tmp424_ = _impl_list;
										_tmp425_ = vala_collection_get_size ((ValaCollection*) _tmp424_);
										_tmp426_ = _tmp425_;
										_impl_size = _tmp426_;
										_impl_index = -1;
										while (TRUE) {
											ValaMethod* impl = NULL;
											ValaList* _tmp427_;
											gpointer _tmp428_;
											gboolean _tmp429_ = FALSE;
											ValaMethod* _tmp430_;
											ValaMethod* _tmp431_;
											ValaMethod* _tmp432_;
											ValaMethod* _tmp433_;
											_impl_index = _impl_index + 1;
											if (!(_impl_index < _impl_size)) {
												break;
											}
											_tmp427_ = _impl_list;
											_tmp428_ = vala_list_get (_tmp427_, _impl_index);
											impl = (ValaMethod*) _tmp428_;
											_tmp430_ = impl;
											_tmp431_ = vala_method_get_base_interface_method (_tmp430_);
											_tmp432_ = _tmp431_;
											_tmp433_ = m;
											if (_tmp432_ == _tmp433_) {
												_tmp429_ = TRUE;
											} else {
												gboolean _tmp434_ = FALSE;
												gboolean _tmp435_ = FALSE;
												gboolean _tmp436_ = FALSE;
												gboolean _tmp437_ = FALSE;
												ValaClass* _tmp438_;
												_tmp438_ = base_class;
												if (_tmp438_ != self) {
													ValaMethod* _tmp439_;
													ValaMethod* _tmp440_;
													ValaMethod* _tmp441_;
													_tmp439_ = impl;
													_tmp440_ = vala_method_get_base_interface_method (_tmp439_);
													_tmp441_ = _tmp440_;
													_tmp437_ = _tmp441_ == NULL;
												} else {
													_tmp437_ = FALSE;
												}
												if (_tmp437_) {
													ValaMethod* _tmp442_;
													const gchar* _tmp443_;
													const gchar* _tmp444_;
													ValaMethod* _tmp445_;
													const gchar* _tmp446_;
													const gchar* _tmp447_;
													_tmp442_ = impl;
													_tmp443_ = vala_symbol_get_name ((ValaSymbol*) _tmp442_);
													_tmp444_ = _tmp443_;
													_tmp445_ = m;
													_tmp446_ = vala_symbol_get_name ((ValaSymbol*) _tmp445_);
													_tmp447_ = _tmp446_;
													_tmp436_ = g_strcmp0 (_tmp444_, _tmp447_) == 0;
												} else {
													_tmp436_ = FALSE;
												}
												if (_tmp436_) {
													gboolean _tmp448_ = FALSE;
													ValaMethod* _tmp449_;
													ValaDataType* _tmp450_;
													ValaDataType* _tmp451_;
													_tmp449_ = impl;
													_tmp450_ = vala_method_get_base_interface_type (_tmp449_);
													_tmp451_ = _tmp450_;
													if (_tmp451_ == NULL) {
														_tmp448_ = TRUE;
													} else {
														ValaMethod* _tmp452_;
														ValaDataType* _tmp453_;
														ValaDataType* _tmp454_;
														ValaTypeSymbol* _tmp455_;
														ValaTypeSymbol* _tmp456_;
														ValaInterface* _tmp457_;
														_tmp452_ = impl;
														_tmp453_ = vala_method_get_base_interface_type (_tmp452_);
														_tmp454_ = _tmp453_;
														_tmp455_ = vala_data_type_get_type_symbol (_tmp454_);
														_tmp456_ = _tmp455_;
														_tmp457_ = iface;
														_tmp448_ = _tmp456_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp457_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp435_ = _tmp448_;
												} else {
													_tmp435_ = FALSE;
												}
												if (_tmp435_) {
													ValaMethod* _tmp458_;
													ValaMethod* _tmp459_;
													_tmp458_ = impl;
													_tmp459_ = m;
													_tmp434_ = vala_method_compatible_no_error (_tmp458_, _tmp459_);
												} else {
													_tmp434_ = FALSE;
												}
												_tmp429_ = _tmp434_;
											}
											if (_tmp429_) {
												ValaMethod* _tmp460_;
												ValaVersionAttribute* _tmp461_;
												ValaVersionAttribute* _tmp462_;
												ValaSourceReference* _tmp463_;
												ValaSourceReference* _tmp464_;
												ValaMethod* _tmp465_;
												ValaMethod* _tmp466_;
												ValaMethod* _tmp467_;
												ValaMethod* _tmp468_;
												_tmp460_ = impl;
												_tmp461_ = vala_symbol_get_version ((ValaSymbol*) _tmp460_);
												_tmp462_ = _tmp461_;
												_tmp463_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp464_ = _tmp463_;
												vala_version_attribute_check (_tmp462_, _tmp464_);
												_tmp465_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp465_, TRUE);
												implemented = TRUE;
												_tmp466_ = impl;
												_tmp467_ = vala_method_get_base_interface_method (_tmp466_);
												_tmp468_ = _tmp467_;
												if (_tmp468_ == NULL) {
													ValaHashMap* _tmp469_;
													ValaMethod* _tmp470_;
													ValaMethod* _tmp471_;
													_tmp469_ = self->priv->implicit_implementations;
													_tmp470_ = m;
													_tmp471_ = impl;
													vala_map_set ((ValaMap*) _tmp469_, _tmp470_, _tmp471_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp472_ = base_class;
									_tmp473_ = _tmp472_->priv->_base_class;
									base_class = _tmp473_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp474_;
									ValaSourceReference* _tmp475_;
									gchar* _tmp476_;
									gchar* _tmp477_;
									ValaMethod* _tmp478_;
									gchar* _tmp479_;
									gchar* _tmp480_;
									gchar* _tmp481_;
									gchar* _tmp482_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp474_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp475_ = _tmp474_;
									_tmp476_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp477_ = _tmp476_;
									_tmp478_ = m;
									_tmp479_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp478_);
									_tmp480_ = _tmp479_;
									_tmp481_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp477_, _tmp480_);
									_tmp482_ = _tmp481_;
									vala_report_error (_tmp475_, _tmp482_);
									_g_free0 (_tmp482_);
									_g_free0 (_tmp480_);
									_g_free0 (_tmp477_);
								}
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp483_;
						ValaList* _tmp484_;
						ValaList* _tmp485_;
						gint _prop_size = 0;
						ValaList* _tmp486_;
						gint _tmp487_;
						gint _tmp488_;
						gint _prop_index = 0;
						_tmp483_ = iface;
						_tmp484_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp483_);
						_tmp485_ = _vala_iterable_ref0 (_tmp484_);
						_prop_list = _tmp485_;
						_tmp486_ = _prop_list;
						_tmp487_ = vala_collection_get_size ((ValaCollection*) _tmp486_);
						_tmp488_ = _tmp487_;
						_prop_size = _tmp488_;
						_prop_index = -1;
						while (TRUE) {
							ValaProperty* prop = NULL;
							ValaList* _tmp489_;
							gpointer _tmp490_;
							ValaProperty* _tmp491_;
							gboolean _tmp492_;
							gboolean _tmp493_;
							_prop_index = _prop_index + 1;
							if (!(_prop_index < _prop_size)) {
								break;
							}
							_tmp489_ = _prop_list;
							_tmp490_ = vala_list_get (_tmp489_, _prop_index);
							prop = (ValaProperty*) _tmp490_;
							_tmp491_ = prop;
							_tmp492_ = vala_property_get_is_abstract (_tmp491_);
							_tmp493_ = _tmp492_;
							if (_tmp493_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp506_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp494_ = FALSE;
									ValaClass* _tmp495_;
									ValaClass* _tmp497_;
									ValaScope* _tmp498_;
									ValaScope* _tmp499_;
									ValaProperty* _tmp500_;
									const gchar* _tmp501_;
									const gchar* _tmp502_;
									ValaSymbol* _tmp503_;
									ValaClass* _tmp504_;
									ValaClass* _tmp505_;
									_tmp495_ = base_class;
									if (_tmp495_ != NULL) {
										ValaSymbol* _tmp496_;
										_tmp496_ = sym;
										_tmp494_ = !VALA_IS_PROPERTY (_tmp496_);
									} else {
										_tmp494_ = FALSE;
									}
									if (!_tmp494_) {
										break;
									}
									_tmp497_ = base_class;
									_tmp498_ = vala_symbol_get_scope ((ValaSymbol*) _tmp497_);
									_tmp499_ = _tmp498_;
									_tmp500_ = prop;
									_tmp501_ = vala_symbol_get_name ((ValaSymbol*) _tmp500_);
									_tmp502_ = _tmp501_;
									_tmp503_ = vala_scope_lookup (_tmp499_, _tmp502_);
									_vala_code_node_unref0 (sym);
									sym = _tmp503_;
									_tmp504_ = base_class;
									_tmp505_ = _tmp504_->priv->_base_class;
									base_class = _tmp505_;
								}
								_tmp506_ = sym;
								if (VALA_IS_PROPERTY (_tmp506_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp507_;
									ValaProperty* _tmp508_;
									gchar* invalid_match = NULL;
									gboolean _tmp509_ = FALSE;
									ValaProperty* _tmp510_;
									gboolean _tmp511_;
									gboolean _tmp512_;
									ValaSymbol* _tmp528_;
									ValaVersionAttribute* _tmp529_;
									ValaVersionAttribute* _tmp530_;
									ValaSourceReference* _tmp531_;
									ValaSourceReference* _tmp532_;
									ValaSymbol* _tmp533_;
									_tmp507_ = sym;
									_tmp508_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp507_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp508_;
									invalid_match = NULL;
									_tmp510_ = base_prop;
									_tmp511_ = vala_symbol_get_hides ((ValaSymbol*) _tmp510_);
									_tmp512_ = _tmp511_;
									if (!_tmp512_) {
										ValaProperty* _tmp513_;
										ValaProperty* _tmp514_;
										gchar* _tmp515_ = NULL;
										gboolean _tmp516_;
										_tmp513_ = base_prop;
										_tmp514_ = prop;
										_tmp516_ = vala_property_compatible (_tmp513_, _tmp514_, &_tmp515_);
										_g_free0 (invalid_match);
										invalid_match = _tmp515_;
										_tmp509_ = !_tmp516_;
									} else {
										_tmp509_ = FALSE;
									}
									if (_tmp509_) {
										ValaSourceReference* _tmp517_;
										ValaSourceReference* _tmp518_;
										ValaProperty* _tmp519_;
										gchar* _tmp520_;
										gchar* _tmp521_;
										ValaProperty* _tmp522_;
										gchar* _tmp523_;
										gchar* _tmp524_;
										const gchar* _tmp525_;
										gchar* _tmp526_;
										gchar* _tmp527_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp517_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp518_ = _tmp517_;
										_tmp519_ = prop;
										_tmp520_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp519_);
										_tmp521_ = _tmp520_;
										_tmp522_ = base_prop;
										_tmp523_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp522_);
										_tmp524_ = _tmp523_;
										_tmp525_ = invalid_match;
										_tmp526_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp521_, _tmp524_, _tmp525_);
										_tmp527_ = _tmp526_;
										vala_report_error (_tmp518_, _tmp527_);
										_g_free0 (_tmp527_);
										_g_free0 (_tmp524_);
										_g_free0 (_tmp521_);
									}
									_tmp528_ = sym;
									_tmp529_ = vala_symbol_get_version (_tmp528_);
									_tmp530_ = _tmp529_;
									_tmp531_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp532_ = _tmp531_;
									vala_version_attribute_check (_tmp530_, _tmp532_);
									_tmp533_ = sym;
									vala_symbol_set_used (_tmp533_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp534_;
									ValaSourceReference* _tmp535_;
									gchar* _tmp536_;
									gchar* _tmp537_;
									ValaProperty* _tmp538_;
									gchar* _tmp539_;
									gchar* _tmp540_;
									gchar* _tmp541_;
									gchar* _tmp542_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp534_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp535_ = _tmp534_;
									_tmp536_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp537_ = _tmp536_;
									_tmp538_ = prop;
									_tmp539_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp538_);
									_tmp540_ = _tmp539_;
									_tmp541_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp537_, _tmp540_);
									_tmp542_ = _tmp541_;
									vala_report_error (_tmp535_, _tmp542_);
									_g_free0 (_tmp542_);
									_g_free0 (_tmp540_);
									_g_free0 (_tmp537_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp543_ = self->priv->_is_abstract;
		if (!_tmp543_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp544_;
			_tmp544_ = self->priv->_base_class;
			base_class = _tmp544_;
			while (TRUE) {
				gboolean _tmp545_ = FALSE;
				ValaClass* _tmp546_;
				ValaClass* _tmp609_;
				ValaClass* _tmp610_;
				_tmp546_ = base_class;
				if (_tmp546_ != NULL) {
					ValaClass* _tmp547_;
					gboolean _tmp548_;
					_tmp547_ = base_class;
					_tmp548_ = _tmp547_->priv->_is_abstract;
					_tmp545_ = _tmp548_;
				} else {
					_tmp545_ = FALSE;
				}
				if (!_tmp545_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp549_;
					ValaList* _tmp550_;
					ValaList* _tmp551_;
					gint _base_method_size = 0;
					ValaList* _tmp552_;
					gint _tmp553_;
					gint _tmp554_;
					gint _base_method_index = 0;
					_tmp549_ = base_class;
					_tmp550_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp549_);
					_tmp551_ = _vala_iterable_ref0 (_tmp550_);
					_base_method_list = _tmp551_;
					_tmp552_ = _base_method_list;
					_tmp553_ = vala_collection_get_size ((ValaCollection*) _tmp552_);
					_tmp554_ = _tmp553_;
					_base_method_size = _tmp554_;
					_base_method_index = -1;
					while (TRUE) {
						ValaMethod* base_method = NULL;
						ValaList* _tmp555_;
						gpointer _tmp556_;
						ValaMethod* _tmp557_;
						gboolean _tmp558_;
						gboolean _tmp559_;
						_base_method_index = _base_method_index + 1;
						if (!(_base_method_index < _base_method_size)) {
							break;
						}
						_tmp555_ = _base_method_list;
						_tmp556_ = vala_list_get (_tmp555_, _base_method_index);
						base_method = (ValaMethod*) _tmp556_;
						_tmp557_ = base_method;
						_tmp558_ = vala_method_get_is_abstract (_tmp557_);
						_tmp559_ = _tmp558_;
						if (_tmp559_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp560_;
							const gchar* _tmp561_;
							const gchar* _tmp562_;
							ValaSymbol* _tmp563_;
							ValaMethod* _tmp564_;
							gboolean _tmp565_ = FALSE;
							ValaMethod* _tmp566_;
							_tmp560_ = base_method;
							_tmp561_ = vala_symbol_get_name ((ValaSymbol*) _tmp560_);
							_tmp562_ = _tmp561_;
							_tmp563_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp562_);
							_tmp564_ = VALA_IS_METHOD (_tmp563_) ? ((ValaMethod*) _tmp563_) : NULL;
							if (_tmp564_ == NULL) {
								_vala_code_node_unref0 (_tmp563_);
							}
							override_method = _tmp564_;
							_tmp566_ = override_method;
							if (_tmp566_ == NULL) {
								_tmp565_ = TRUE;
							} else {
								ValaMethod* _tmp567_;
								gboolean _tmp568_;
								gboolean _tmp569_;
								_tmp567_ = override_method;
								_tmp568_ = vala_method_get_overrides (_tmp567_);
								_tmp569_ = _tmp568_;
								_tmp565_ = !_tmp569_;
							}
							if (_tmp565_) {
								ValaSourceReference* _tmp570_;
								ValaSourceReference* _tmp571_;
								gchar* _tmp572_;
								gchar* _tmp573_;
								ValaMethod* _tmp574_;
								gchar* _tmp575_;
								gchar* _tmp576_;
								gchar* _tmp577_;
								gchar* _tmp578_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp570_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp571_ = _tmp570_;
								_tmp572_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp573_ = _tmp572_;
								_tmp574_ = base_method;
								_tmp575_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp574_);
								_tmp576_ = _tmp575_;
								_tmp577_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp573_, _tmp576_);
								_tmp578_ = _tmp577_;
								vala_report_error (_tmp571_, _tmp578_);
								_g_free0 (_tmp578_);
								_g_free0 (_tmp576_);
								_g_free0 (_tmp573_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp579_;
					ValaList* _tmp580_;
					ValaList* _tmp581_;
					gint _base_property_size = 0;
					ValaList* _tmp582_;
					gint _tmp583_;
					gint _tmp584_;
					gint _base_property_index = 0;
					_tmp579_ = base_class;
					_tmp580_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp579_);
					_tmp581_ = _vala_iterable_ref0 (_tmp580_);
					_base_property_list = _tmp581_;
					_tmp582_ = _base_property_list;
					_tmp583_ = vala_collection_get_size ((ValaCollection*) _tmp582_);
					_tmp584_ = _tmp583_;
					_base_property_size = _tmp584_;
					_base_property_index = -1;
					while (TRUE) {
						ValaProperty* base_property = NULL;
						ValaList* _tmp585_;
						gpointer _tmp586_;
						ValaProperty* _tmp587_;
						gboolean _tmp588_;
						gboolean _tmp589_;
						_base_property_index = _base_property_index + 1;
						if (!(_base_property_index < _base_property_size)) {
							break;
						}
						_tmp585_ = _base_property_list;
						_tmp586_ = vala_list_get (_tmp585_, _base_property_index);
						base_property = (ValaProperty*) _tmp586_;
						_tmp587_ = base_property;
						_tmp588_ = vala_property_get_is_abstract (_tmp587_);
						_tmp589_ = _tmp588_;
						if (_tmp589_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp590_;
							const gchar* _tmp591_;
							const gchar* _tmp592_;
							ValaSymbol* _tmp593_;
							ValaProperty* _tmp594_;
							gboolean _tmp595_ = FALSE;
							ValaProperty* _tmp596_;
							_tmp590_ = base_property;
							_tmp591_ = vala_symbol_get_name ((ValaSymbol*) _tmp590_);
							_tmp592_ = _tmp591_;
							_tmp593_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp592_);
							_tmp594_ = VALA_IS_PROPERTY (_tmp593_) ? ((ValaProperty*) _tmp593_) : NULL;
							if (_tmp594_ == NULL) {
								_vala_code_node_unref0 (_tmp593_);
							}
							override_property = _tmp594_;
							_tmp596_ = override_property;
							if (_tmp596_ == NULL) {
								_tmp595_ = TRUE;
							} else {
								ValaProperty* _tmp597_;
								gboolean _tmp598_;
								gboolean _tmp599_;
								_tmp597_ = override_property;
								_tmp598_ = vala_property_get_overrides (_tmp597_);
								_tmp599_ = _tmp598_;
								_tmp595_ = !_tmp599_;
							}
							if (_tmp595_) {
								ValaSourceReference* _tmp600_;
								ValaSourceReference* _tmp601_;
								gchar* _tmp602_;
								gchar* _tmp603_;
								ValaProperty* _tmp604_;
								gchar* _tmp605_;
								gchar* _tmp606_;
								gchar* _tmp607_;
								gchar* _tmp608_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp600_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp601_ = _tmp600_;
								_tmp602_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp603_ = _tmp602_;
								_tmp604_ = base_property;
								_tmp605_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp604_);
								_tmp606_ = _tmp605_;
								_tmp607_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp603_, _tmp606_);
								_tmp608_ = _tmp607_;
								vala_report_error (_tmp601_, _tmp608_);
								_g_free0 (_tmp608_);
								_g_free0 (_tmp606_);
								_g_free0 (_tmp603_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp609_ = base_class;
				_tmp610_ = _tmp609_->priv->_base_class;
				base_class = _tmp610_;
			}
		}
	}
	_tmp611_ = vala_code_context_get_analyzer (context);
	_tmp612_ = _tmp611_;
	_tmp613_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp612_, _tmp613_);
	_tmp614_ = vala_code_context_get_analyzer (context);
	_tmp615_ = _tmp614_;
	_tmp616_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp615_, _tmp616_);
	_tmp617_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp618_ = _tmp617_;
	result = !_tmp618_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GEqualFunc _tmp4_;
	ValaHashMap* _tmp5_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_, _tmp3_, _tmp4_);
	self->priv->implicit_implementations = _tmp5_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}

