# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AddonProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Addon provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CANCELLED = "Cancelled"
    """is cancelled"""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class AddonType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Addon type."""

    SRM = "SRM"
    VR = "VR"
    HCX = "HCX"
    ARC = "Arc"


class AffinityStrength(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Affinity Strength."""

    SHOULD = "Should"
    """is should"""
    MUST = "Must"
    """is must"""


class AffinityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Affinity type."""

    AFFINITY = "Affinity"
    """is affinity"""
    ANTI_AFFINITY = "AntiAffinity"
    """is anti-affinity"""


class AvailabilityStrategy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether the private clouds is available in a single zone or two zones."""

    SINGLE_ZONE = "SingleZone"
    """in single zone"""
    DUAL_ZONE = "DualZone"
    """in two zones"""


class AzureHybridBenefitType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Azure Hybrid Benefit type."""

    SQL_HOST = "SqlHost"
    """is SqlHost"""
    NONE = "None"
    """is None"""


class BlockedDatesConstraintCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Reason for blocking operation on maintenance."""

    HI_PRIORITY_EVENT = "HiPriorityEvent"
    """Hi-Priority Event"""
    QUOTA_EXHAUSTED = "QuotaExhausted"
    """Quota Exhausted"""
    HOLIDAY = "Holiday"
    """Holidays"""


class CloudLinkProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """cloud link provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class CloudLinkStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cloud Link status."""

    ACTIVE = "Active"
    """is active"""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    FAILED = "Failed"
    """is failed"""
    DISCONNECTED = "Disconnected"
    """is disconnected"""


class ClusterProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cluster provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CANCELLED = "Cancelled"
    """is cancelled"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DatastoreProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """datastore provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CANCELLED = "Cancelled"
    """is cancelled"""
    PENDING = "Pending"
    """is pending"""
    CREATING = "Creating"
    """is creating"""
    UPDATING = "Updating"
    """is updating"""
    DELETING = "Deleting"
    """is deleting"""


class DatastoreStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """datastore status."""

    UNKNOWN = "Unknown"
    """is unknown"""
    ACCESSIBLE = "Accessible"
    """is accessible"""
    INACCESSIBLE = "Inaccessible"
    """is inaccessible"""
    ATTACHED = "Attached"
    """is attached"""
    DETACHED = "Detached"
    """is detached"""
    LOST_COMMUNICATION = "LostCommunication"
    """is lost communication"""
    DEAD_OR_ERROR = "DeadOrError"
    """is dead or error"""


class DhcpTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of DHCP: SERVER or RELAY."""

    SERVER = "SERVER"
    RELAY = "RELAY"


class DnsServiceLogLevelEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DNS service log level."""

    DEBUG = "DEBUG"
    """is debug"""
    INFO = "INFO"
    """is info"""
    WARNING = "WARNING"
    """is warning"""
    ERROR = "ERROR"
    """is error"""
    FATAL = "FATAL"
    """is fatal"""


class DnsServiceStatusEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DNS service status."""

    SUCCESS = "SUCCESS"
    """is success"""
    FAILURE = "FAILURE"
    """is failure"""


class DnsZoneType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of DNS zone."""

    PUBLIC = "Public"
    """Primary DNS zone."""
    PRIVATE = "Private"
    """Private DNS zone."""


class EncryptionKeyStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether the the encryption key is connected or access denied."""

    CONNECTED = "Connected"
    """is connected"""
    ACCESS_DENIED = "AccessDenied"
    """is access denied"""


class EncryptionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether encryption is enabled or disabled."""

    ENABLED = "Enabled"
    """is enabled"""
    DISABLED = "Disabled"
    """is disabled"""


class EncryptionVersionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether the encryption version is fixed or auto-detected."""

    FIXED = "Fixed"
    """is fixed"""
    AUTO_DETECTED = "AutoDetected"
    """is auto-detected"""


class ExpressRouteAuthorizationProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Express Route Circuit Authorization provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    UPDATING = "Updating"
    """is updating"""


class GlobalReachConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Global Reach Connection provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    UPDATING = "Updating"
    """is updating"""


class GlobalReachConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Global Reach Connection status."""

    CONNECTED = "Connected"
    """is connected"""
    CONNECTING = "Connecting"
    """is connecting"""
    DISCONNECTED = "Disconnected"
    """is disconnected"""


class HcxEnterpriseSiteProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """HCX Enterprise Site provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class HcxEnterpriseSiteStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """HCX Enterprise Site status."""

    AVAILABLE = "Available"
    """is available"""
    CONSUMED = "Consumed"
    """is consumed"""
    DEACTIVATED = "Deactivated"
    """is deactivated"""
    DELETED = "Deleted"
    """is deleted"""


class HostKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of host."""

    GENERAL = "General"
    SPECIALIZED = "Specialized"


class HostMaintenance(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason for host maintenance."""

    REPLACEMENT = "Replacement"
    """The host is a replacement host."""
    UPGRADE = "Upgrade"
    """The host is for an upgrade, such as an upgrade to ESXi, NSX-T, or other component."""


class HostProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """provisioning state of the host."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class InternetEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether internet is enabled or disabled."""

    ENABLED = "Enabled"
    """is enabled"""
    DISABLED = "Disabled"
    """is disabled"""


class IscsiPathProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """private cloud provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PENDING = "Pending"
    """is pending"""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class LicenseKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of license."""

    VMWARE_FIREWALL = "VmwareFirewall"


class LicenseName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the license."""

    VMWARE_FIREWALL = "VmwareFirewall"
    """VMware Firewall license"""


class LicenseProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """provisioning state of the license."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class MaintenanceCheckType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of maintenance readiness check."""

    PRECHECK = "Precheck"
    """Pre-check maintenance readiness"""
    PREFLIGHT = "Preflight"
    """Pre-flight maintenance readiness"""


class MaintenanceManagementOperationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the type of operation."""

    SCHEDULE = "Schedule"
    """Represents a scheduling operation"""
    RESCHEDULE = "Reschedule"
    """Represents a rescheduling operation"""
    MAINTENANCE_READINESS_REFRESH = "MaintenanceReadinessRefresh"
    """Represents a maintenance readiness refresh operation"""


class MaintenanceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """provisioning state of the maintenance."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    UPDATING = "Updating"
    """is updating"""


class MaintenanceReadinessRefreshOperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of an MaintenanceReadinessRefresh operation."""

    IN_PROGRESS = "InProgress"
    """Operation is in progress"""
    NOT_STARTED = "NotStarted"
    """Operation has not started"""
    FAILED = "Failed"
    """Operation has failed"""
    NOT_APPLICABLE = "NotApplicable"
    """Operation is not applicable"""


class MaintenanceReadinessStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the readiness status of maintenance."""

    READY = "Ready"
    """The system is ready for maintenance"""
    NOT_READY = "NotReady"
    """The system is not ready for maintenance"""
    DATA_NOT_AVAILABLE = "DataNotAvailable"
    """Data is not available to determine readiness"""
    NOT_APPLICABLE = "NotApplicable"
    """Readiness check is not applicable"""


class MaintenanceStateName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Customer presentable maintenance state."""

    NOT_SCHEDULED = "NotScheduled"
    """Maintenance Not Scheduled"""
    SCHEDULED = "Scheduled"
    """Maintenance Scheduled"""
    IN_PROGRESS = "InProgress"
    """Maintenance In Progress"""
    SUCCESS = "Success"
    """Maintenance Succeeded"""
    FAILED = "Failed"
    """Maintenance Failed"""
    CANCELED = "Canceled"
    """Maintenance Cancelled"""


class MaintenanceStatusFilter(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """status filter for the maintenance."""

    ACTIVE = "Active"
    """is active"""
    INACTIVE = "Inactive"
    """is inactive"""


class MaintenanceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """type of the maintenance."""

    VCSA = "VCSA"
    """maintenance for vCenter Server Appliance"""
    ESXI = "ESXI"
    """maintenance for ESXi"""
    NSXT = "NSXT"
    """maintenance for NSX-T"""


class MountOptionEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """mount option."""

    MOUNT = "MOUNT"
    """is mount"""
    ATTACH = "ATTACH"
    """is attach"""


class NsxPublicIpQuotaRaisedEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NSX public IP quota raised."""

    ENABLED = "Enabled"
    """is enabled"""
    DISABLED = "Disabled"
    """is disabled"""


class OptionalParamEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Optional Param."""

    OPTIONAL = "Optional"
    """is optional"""
    REQUIRED = "Required"
    """is required"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PlacementPolicyProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Placement Policy provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class PlacementPolicyState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Placement Policy state."""

    ENABLED = "Enabled"
    """is enabled"""
    DISABLED = "Disabled"
    """is disabled"""


class PlacementPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Placement Policy type."""

    VM_VM = "VmVm"
    VM_HOST = "VmHost"


class PortMirroringDirectionEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Port Mirroring Direction."""

    INGRESS = "INGRESS"
    """is ingress"""
    EGRESS = "EGRESS"
    """is egress"""
    BIDIRECTIONAL = "BIDIRECTIONAL"
    """is bidirectional"""


class PortMirroringStatusEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Port Mirroring status."""

    SUCCESS = "SUCCESS"
    """is success"""
    FAILURE = "FAILURE"
    """is failure"""


class PrivateCloudProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """private cloud provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    CANCELLED = "Cancelled"
    """is cancelled"""
    PENDING = "Pending"
    """is pending"""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class ProvisionedNetworkProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """provisioned network provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class ProvisionedNetworkTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of network provisioned."""

    ESX_MANAGEMENT = "esxManagement"
    """network for ESX management"""
    ESX_REPLICATION = "esxReplication"
    """network for ESX replication"""
    HCX_MANAGEMENT = "hcxManagement"
    """network for HCX management"""
    HCX_UPLINK = "hcxUplink"
    """network for HCX uplink"""
    VCENTER_MANAGEMENT = "vcenterManagement"
    """network for vCenter management"""
    VMOTION = "vmotion"
    """network for vmotion"""
    VSAN = "vsan"
    """network for vsan"""


class PureStoragePolicyProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Pure Storage Policy Based Management policy provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class QuotaEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """quota enabled."""

    ENABLED = "Enabled"
    """is enabled"""
    DISABLED = "Disabled"
    """is disabled"""


class RescheduleOperationConstraintKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Constraints for rescheduling of maintenance."""

    AVAILABLE_WINDOW_FOR_MAINTENANCE_WHILE_RESCHEDULE_OPERATION = "AvailableWindowForMaintenance"
    """Time window in which maintenance can be rescheduled"""
    BLOCKED_WHILE_RESCHEDULE_OPERATION = "Blocked"
    """Blocked time range constraint"""


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (either system assigned, or none)."""

    NONE = "None"
    """No managed system identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed system identity."""


class ResourceSkuResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the type of resource the SKU applies to."""

    PRIVATE_CLOUDS = "privateClouds"
    """The SKU is for a private cloud."""
    PRIVATE_CLOUDS_CLUSTERS = "privateClouds/clusters"
    """The SKU is for a private cloud cluster."""


class ResourceSkuRestrictionsReasonCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the reason for SKU restriction."""

    QUOTA_ID = "QuotaId"
    """The restriction is due to exceeding a quota limitation."""
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"
    """The restriction is not available for this subscription."""


class ResourceSkuRestrictionsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the kind of SKU restrictions that can exist."""

    LOCATION = "Location"
    """SKU restricted by location."""
    ZONE = "Zone"
    """SKU restricted by availability zone."""


class ScheduleOperationConstraintKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Constraints for scheduling of maintenance."""

    SCHEDULING_WINDOW = "SchedulingWindow"
    """Time window in which Customer has option to schedule maintenance"""
    AVAILABLE_WINDOW_FOR_MAINTENANCE_WHILE_SCHEDULE_OPERATION = "AvailableWindowForMaintenance"
    """Time window in which maintenance can be scheduled"""
    BLOCKED_WHILE_SCHEDULE_OPERATION = "Blocked"
    """Blocked time range constraint"""


class ScriptCmdletAudience(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether a script cmdlet is intended to be invoked only through automation or visible
    to customers.
    """

    AUTOMATION = "Automation"
    """is automation"""
    ANY = "Any"
    """is any"""


class ScriptCmdletProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A script cmdlet provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class ScriptExecutionParameterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """script execution parameter type."""

    VALUE = "Value"
    SECURE_VALUE = "SecureValue"
    CREDENTIAL = "Credential"


class ScriptExecutionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Script Execution provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    PENDING = "Pending"
    """is pending"""
    RUNNING = "Running"
    """is running"""
    CANCELLING = "Cancelling"
    """is cancelling"""
    CANCELLED = "Cancelled"
    """is cancelled"""
    DELETING = "Deleting"
    """is deleting"""


class ScriptOutputStreamType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Script Output Stream type."""

    INFORMATION = "Information"
    """is information"""
    WARNING = "Warning"
    """is warning"""
    OUTPUT = "Output"
    """is output"""
    ERROR = "Error"
    """is error"""


class ScriptPackageProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Script Package provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class ScriptParameterTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Script Parameter types."""

    STRING = "String"
    """is string"""
    SECURE_STRING = "SecureString"
    """is secure string"""
    CREDENTIAL = "Credential"
    """is credential"""
    INT = "Int"
    """is int"""
    BOOL = "Bool"
    """is bool"""
    FLOAT = "Float"
    """is float"""


class SegmentStatusEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Segment status."""

    SUCCESS = "SUCCESS"
    """is success"""
    FAILURE = "FAILURE"
    """is failure"""


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is required to be implemented by the Resource Provider if the service has more than
    one tier, but is not required on a PUT.
    """

    FREE = "Free"
    """The Free service tier."""
    BASIC = "Basic"
    """The Basic service tier."""
    STANDARD = "Standard"
    """The Standard service tier."""
    PREMIUM = "Premium"
    """The Premium service tier."""


class SslEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether SSL is enabled or disabled."""

    ENABLED = "Enabled"
    """is enabled"""
    DISABLED = "Disabled"
    """is disabled"""


class TrialStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """trial status."""

    TRIAL_AVAILABLE = "TrialAvailable"
    """is available"""
    TRIAL_USED = "TrialUsed"
    """is used"""
    TRIAL_DISABLED = "TrialDisabled"
    """is disabled"""


class VcfLicenseKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of license."""

    VCF5 = "vcf5"
    """A VMware Cloud Foundation (VCF) 5.0 license"""


class VirtualMachineProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Virtual Machine provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class VirtualMachineRestrictMovementState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Virtual Machine Restrict Movement state."""

    ENABLED = "Enabled"
    """is enabled"""
    DISABLED = "Disabled"
    """is disabled"""


class VisibilityParameterEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Visibility Parameter."""

    VISIBLE = "Visible"
    """is visible"""
    HIDDEN = "Hidden"
    """is hidden"""


class VMGroupStatusEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VM group status."""

    SUCCESS = "SUCCESS"
    """is success"""
    FAILURE = "FAILURE"
    """is failure"""


class VMTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """VM type."""

    REGULAR = "REGULAR"
    """is regular"""
    EDGE = "EDGE"
    """is edge"""
    SERVICE = "SERVICE"
    """is service"""


class WorkloadNetworkDhcpProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Workload Network DHCP provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class WorkloadNetworkDnsServiceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Workload Network DNS Service provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class WorkloadNetworkDnsZoneProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Workload Network DNS Zone provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class WorkloadNetworkPortMirroringProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Workload Network Port Mirroring provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class WorkloadNetworkProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """base Workload Network provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class WorkloadNetworkPublicIPProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Workload Network Public IP provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class WorkloadNetworkSegmentProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Workload Network Segment provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""


class WorkloadNetworkVMGroupProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Workload Network VM Group provisioning state."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    BUILDING = "Building"
    """is building"""
    DELETING = "Deleting"
    """is deleting"""
    UPDATING = "Updating"
    """is updating"""
