/*  MikMod example player
	(c) 1999 Miodrag Vallat and others - see file AUTHORS for
	complete list.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
 
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
*/

/*==============================================================================

  $Id: mdialog.c,v 1.1.1.1 2003/09/19 13:16:01 raph Exp $

  Some common dialog types

==============================================================================*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <mikmod.h>
#include "mwidget.h"
#include "mdialog.h"

typedef struct {
	handleDlgFunc handle_dlg;
	void *input;
	void *data;
	int min,max;
} DLG_DATA;

static int handle_focus(DIALOG *d,struct WIDGET *w,int focus)
{
	if (focus==FOCUS_ACTIVATE) {
		DLG_DATA *data=w->data;
		if (data) {
			int button=0;
			if (w->type==TYPE_BUTTON) button=((WID_BUTTON*)w)->active;

			if ((!button)&&(data->min>=0)&&(data->max>=0)) {
				int value=atoi(data->input);
				if ((value<data->min)||(value>data->max))
					return focus;
			}
			data->handle_dlg(button,data->input,data->data);
			free(data);
		}
		dialog_close(d);
		return EVENT_HANDLED;
	}
	return focus;
}

static DLG_DATA* init_dlg_data(handleDlgFunc handle_dlg,void *input,void *data)
{
	DLG_DATA *dlg_data=NULL;
	if (handle_dlg) {
		dlg_data=malloc(sizeof(DLG_DATA));
		dlg_data->handle_dlg=handle_dlg;
		dlg_data->input=input;
		dlg_data->data=data;
		dlg_data->min=dlg_data->max=-1;
	}
	return dlg_data;
}

/* Opens a message box
   msg   : text to display,can contain '\n'
   button: ".&..|...|...",&: hotkey,e.g.: "&Yes|&No"
   active: active button(0...n)
   data  : passed to handle_dlg */
void dlg_message_open(char *msg,char *button,int active,handleDlgFunc handle_dlg,void *data)
{
	WIDGET *w;
	DIALOG *d=dialog_new();

	wid_label_add(d,0,msg);
	w=wid_button_add(d,1,button,active);
	if (handle_dlg)
		wid_set_func(w,NULL,handle_focus,init_dlg_data(handle_dlg,NULL,data));
	dialog_open(d,"Message");
}

/* Shows message describing the errno error code.
   txt must contain '%s'(err-txt will be inserted) */
void dlg_error_show(char *txt)
{
	if (errno) {
		char *err=strerror(errno);
		char *msg=malloc(strlen(txt)+strlen(err)+1);

		sprintf(msg,txt,err);
		dlg_message_open(msg,"&Ok",0,NULL,NULL);
		free(msg);
	}
}

/* Opens a string input dialog
   msg   : text to display,can contain '\n'
   str   : default text
   length: max allowed input length */
void dlg_input_str(char *msg,char *str,int length,handleDlgFunc handle_dlg,void *data)
{
	WIDGET *w;
	WID_STR *str_wid;
	DLG_DATA *dlg_data;
	DIALOG *d=dialog_new();

	if (msg) wid_label_add(d,0,msg);
	str_wid=(WID_STR*)wid_str_add(d,0,str,length);
	w=wid_button_add(d,1,"<&Ok>|&Cancel",0);

	dlg_data=init_dlg_data(handle_dlg,str_wid->input,data);
	wid_set_func((WIDGET*)str_wid,NULL,handle_focus,dlg_data);
	wid_set_func(w,NULL,handle_focus,dlg_data);

	dialog_open(d,"Enter string");
}

/* Opens an integer input dialog
   msg   : text to display,can contain '\n'
   value : default integer
   min,max: min,max allowed values */
void dlg_input_int(char *msg,int value,int min,int max,handleDlgFunc handle_dlg,void *data)
{
	char title[40];
	WIDGET *w;
	WID_INT *int_wid;
	DLG_DATA *dlg_data;
	DIALOG *d=dialog_new();

	if (msg) wid_label_add(d,0,msg);
	sprintf(title,"%d",max);
	int_wid=(WID_INT*)wid_int_add(d,0,value,strlen(title));
	w=wid_button_add(d,1,"<&Ok>|&Cancel",0);

	dlg_data=init_dlg_data(handle_dlg,int_wid->input,data);
	dlg_data->min=min;
	dlg_data->max=max;
	wid_set_func((WIDGET*)int_wid,NULL,handle_focus,dlg_data);
	wid_set_func(w,NULL,handle_focus,dlg_data);

	sprintf(title,"Enter value(%d - %d)",min,max);
	dialog_open(d,title);
}

/* ex:set ts=4: */
