/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.ReflectPermission;
import java.security.Permission;

public class AccessibleObject {
    private static Permission ACCESS_PERMISSION;
    private boolean override;

    private static void initAccessPermission() {
        ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    }

    public static void setAccessible(AccessibleObject[] accessibleObjectArray, boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (ACCESS_PERMISSION == null) {
                AccessibleObject.initAccessPermission();
            }
            securityManager.checkPermission(ACCESS_PERMISSION);
        }
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            AccessibleObject.setAccessible0(accessibleObjectArray[i], bl);
        }
    }

    public void setAccessible(boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (ACCESS_PERMISSION == null) {
                AccessibleObject.initAccessPermission();
            }
            securityManager.checkPermission(ACCESS_PERMISSION);
        }
        AccessibleObject.setAccessible0(this, bl);
    }

    private static void setAccessible0(AccessibleObject accessibleObject, boolean bl) throws SecurityException {
        Constructor constructor;
        if (accessibleObject instanceof Constructor && bl && (constructor = (Constructor)accessibleObject).getDeclaringClass() == Class.class) {
            throw new SecurityException("Can not make a java.lang.Class constructor accessible");
        }
        accessibleObject.override = bl;
    }

    public boolean isAccessible() {
        return this.override;
    }

    protected AccessibleObject() {
    }
}

