#include "minfo_rr.h"

namespace ADNS {

	MINFO_RR::MINFO_RR()
	{
		rr_type = RR_TYPE::MINFO;
		Rmailbx = gcnew DOMAIN_NAME();
		Emailbx = gcnew DOMAIN_NAME();
		UpdateRdata();
	}

	Void MINFO_RR::SetRmailbx(DOMAIN_NAME^ newname)
	{
		Rmailbx = gcnew DOMAIN_NAME(newname->GetName());
		UpdateRdata();
		return;
	}

	DOMAIN_NAME^ MINFO_RR::GetRmailbx()
	{
		return Rmailbx->Clone();
	}

	DOMAIN_NAME^ MINFO_RR::GetEmailbx()
	{
		return Emailbx->Clone();
	}

	Void MINFO_RR::SetEmailbx(DOMAIN_NAME^ newname)
	{
		Emailbx = gcnew DOMAIN_NAME(newname->GetName());
		UpdateRdata();
		return;
	}

	String^ MINFO_RR::Print()
	{
		String^ output;
		output = PrintHeader();
		output += " ";
		output += Rmailbx->Print();
		output+= " ";
		output += Emailbx->Print();
		
		return output;
	}

	Void MINFO_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(Rmailbx->GetName()->Length + Emailbx->GetName()->Length);
		else
			rdata->Resize(rdata,Rmailbx->GetName()->Length + Emailbx->GetName()->Length);

		Rmailbx->GetName()->CopyTo(rdata,0);
		Emailbx->GetName()->CopyTo(rdata,Rmailbx->GetName()->Length);

		return;
	}

	Void MINFO_RR::ToCanonical()
	{
		Rmailbx->MakeCanonical();
		Emailbx->MakeCanonical();
		owner->MakeCanonical();
		UpdateRdata();
		return;
	}

	MINFO_RR^ MINFO_RR::Clone()
	{
		MINFO_RR^ newrr = gcnew MINFO_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->Rmailbx = Rmailbx->Clone();
		newrr->Emailbx = Emailbx->Clone();
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ MINFO_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		MINFO_RR^ minfoout;
		array<Byte>^ tmparray;
		int reallen;
		int pos;

		minfoout = gcnew MINFO_RR();
		//Set the header info
		minfoout->owner = gcnew DOMAIN_NAME(domainname);
		minfoout->rr_class = (RR_CLASS) rr_class;
		minfoout->ttl = ttl;
		//Get RMAILBX
		tmparray = ReadDomainFromPacket(packet, rdata_start, reallen);
		minfoout->SetRmailbx(gcnew DOMAIN_NAME(tmparray));
		//Get EMAILBX
		pos = rdata_start + reallen;
		tmparray = ReadDomainFromPacket(packet, pos, reallen);
		minfoout->SetEmailbx(gcnew DOMAIN_NAME(tmparray));
		return minfoout;
	}

	String^ MINFO_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<MINFO_RR^>(rec)->Print();
	}

	ResourceRecord^ MINFO_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<MINFO_RR^>(rec)->Clone();
	}

}