#ifndef _MOVE_TREE_H
#define _MOVE_TREE_H
#include "osl/move.h"
#include <qglobal.h>
#include <Q3ListView>

class MoveTreeItem;
class QMenu;

class MoveTree : public Q3ListView
{
Q_OBJECT
public:
  MoveTree(QWidget *parent = 0, const char *name = 0) : Q3ListView(parent, name) {
    setRootIsDecorated(true);
  }
  virtual ~MoveTree();
public slots:
  void expandBest();
  void expandAll();
  void closeAll();
signals:
  void moveGenerate();
protected:
  void expandBestChildren(MoveTreeItem *item);
  virtual void contextMenuEvent(QContextMenuEvent *);
  virtual void buildContextMenu(QMenu *menu);
};

class MoveTreeItem : public Q3ListViewItem
{
  // Str1 must correspond to m.
public:
  MoveTreeItem(MoveTree *parent, osl::Move m,
	       QString str1 = QString::null, QString str2 = QString::null,
	       QString str3 = QString::null, QString str4 = QString::null,
	       QString str5 = QString::null, QString str6 = QString::null,
	       QString str7 = QString::null, QString str8 = QString::null)
    : Q3ListViewItem(parent, str1, str2, str3, str4, str5, str6, str7, str8),
      move(m) {
  }
  MoveTreeItem(MoveTreeItem *parent, osl::Move m,
	       QString str1 = QString::null, QString str2 = QString::null,
	       QString str3 = QString::null, QString str4 = QString::null,
	       QString str5 = QString::null, QString str6 = QString::null,
	       QString str7 = QString::null, QString str8 = QString::null)
    : Q3ListViewItem(parent, str1, str2, str3, str4, str5, str6, str7, str8),
      move(m) {
  }
  osl::Move getMove() const {
    return move;
  }
  virtual bool isBestMove() const {
    return true;
  }
  int compare(Q3ListViewItem *i, int col, bool ascending) const;
private:
  osl::Move move;
};

#endif // _MOVE_TREE_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
