/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * Copyright (C) 2007 - 2009 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
// #include <stdlib.h>
// #include <stdio.h>
// #include <string.h>
// #include <unistd.h>

// #include <dirent.h>
// #include <sys/stat.h>
// #include <fcntl.h>

// #include <ncursesw/ncurses.h>
// #include <ncursesw/form.h>

// #include "config.h"
// #include "main.h" /* clean_before_cdw_exit() */

// #include "gettext.h"
// #include "thread.h" /* run_command() */
// #include "cdw_widgets.h" /* nice_box() */
// #include "cdw_disc.h"
// #include "cdw_processwin.h"
// #include "cdw_config.h" /* cdw_config_t */
// #include "cdw_cdio.h"
// #include "cdw_colors.h"
// #include "cdda2wav.h"


// extern cdw_config_t config;
// extern WINDOW main_cdw_win;
// extern cdw_disc_t current_disc;

/* ISO C forbids empty files */
int cdw_dummy(void);
int cdw_dummy(void) {return 0;}

/* currently unused, replaced by commands.c::command_copy_cd_to_hdd() */
#if 0

/**
 * Copy audio tracks to separate files
 *
 * Copy all tracks from audio CD to separate files in selected directory.
 * The files are verbatim copies of disc tracks, so their parameters are
 * following:
 *
 * 2 channels
 * 44100 samples per second
 * 16 bit signed pcm
 * little endian (intel)
 *
 * You have to get disc meta information before calling
 * this function - it does not read meta information itself. The function
 * does not check for disc in drive and correct disc type either.
 *
 * This function is poor man's version of cdda2wav(), it only rips tracks,
 * user have to convert them to some other format by himself.
 *
 * Track files are written to config->audiodir directory.
 *
 * \return CDW_GEN_ERROR if function cannot open disc for reading
 * \return CDW_MEM_ERROR if malloc() fails at some point
 * \return CDW_CANCEL if user cancels preparations to ripping disc (e.g. does not provide output file name)
 * \return CDW_NO if ripping disc was performed, but there were some errors
 * \return CDW_OK if ripping disc was performed and no errors occurred
 */
cdw_rv_t poor_man_cdda2wav(void)
{
	bool success = true;
	cdw_cdio_disc_t *disc = NULL;
	cdw_rv_t op = cdw_cdio_disc_open(config.cdrw_device);
	if (op != CDW_OK) {
		/* 2TRANS: this is title of dialog window */
		dialogbox("Error",
			  /* 2TRANS: this is message in dialog window: disc
			     is in drive, but cdw cannot open it using a
			     library API */
			  "Cannot open disc.", DIALOG_OK, CDW_COLORS_ERROR);
		return CDW_GEN_ERROR;
	} else {
		disc = &(current_disc.cdio_disc);
	}


	cdw_rv_t crv = get_valid_path(
			/* 2TRANS: this is title of dialog window in which
			user has to enter path to valid dir */
			"Output directory",
			/* 2TRANS: this is label in dialog window, below
			it is input field */
			"Enter path to existing output directory",
			&(config.audiodir),
			S_IRUSR|S_IWUSR|S_IXUSR, CDW_DIR, 6); /* 6 tries */
	if (crv != CDW_OK) { /* user failed to provide correct path when
		                asked X times, or pressed ESCAPE */
		cdw_cdio_disc_close();
		return CDW_CANCEL;
	}

	/* 2TRANS: this is main part of name of audio tracks ripped from
	   audio cd, no more than TRACK_CORE_NAME_LEN = 30 chars */
	char *filename = make_n_string("track", TRACK_CORE_NAME_LEN);
	if (filename == NULL) {
		cdw_cdio_disc_close();
		return CDW_MEM_ERROR;
	}

	/* 2TRANS: this is title of dialog window where user have to
	   enter core of track file names */
	crv = inputbox("File name",
			/* 2TRANS: this is label in dialog window,
			   below it is an input field */
			"Enter core of track file names", &filename,
			0, TRACK_CORE_NAME_LEN); /* mode = 0 */
	if (crv == CDW_OK) {
		current_task.id = TASK_RIP_AUDIO_CD;
		/* 2TRANS: this is title of dialog window, it is
		   related to ripping audio CD */
		cdw_processwin_create("Copy audio CD",
				      /* 2TRANS: this is message in dialog
					 window: ripping audio cd is in
					 progress */
				      "Copying audio CD...", true);
		track_t i = 0;
		for (i = disc->first_track; i <= disc->last_track; i++) {
			char track_info[PROCESSWIN_MAX_RTEXT_LEN];
			/* 2TRANS: this is message in dialog window:
			   currently track number %d is ripped */
			sprintf(track_info, "Copying audio track %d", i);
			cdw_processwin_display_text_info(1, track_info);

			/* 7 is length of _%2.2d.raw; there can be
			   99 audio tracks on audio cd, so place for
			   2 digits will be enough */
			char ending[7 + 1];
			snprintf(ending, 7 + 1, "_%2.2d.raw", i);

			char *full_name = concat(config.audiodir, "/", filename, ending, NULL);
			/* fprintf(stderr, "\n\noutput raw file name: \"%s\"\n\n", full_name); */
			if (full_name == NULL) {
				success = false;
				continue;
			}

			int fd = open(full_name, O_RDWR | O_CREAT | O_TRUNC, S_IRUSR | S_IWUSR);
			/* perror("open: ");
			fprintf(stderr, "open returns fd = %d\n", fd); */
			cdw_rv_t rv = cdw_cdio_copy_sectors_to_file(i, fd);
			if (rv != CDW_OK) { /* if any error will occur for any track, then mark whole operation as unsuccessful */
				/* fprintf(stderr, "track read error for track %d\n", i); */
				success = false;
			}
			free(full_name);
			close(fd);
		} /* for */

		cdw_cdio_disc_close();
		free(filename);
		filename = (char *)NULL;

		current_task.id = TASK_NONE;

		if (success) {
			/* 2TRANS: this is message in dialog window:
				ripping audio cd finished successfully */
			cdw_processwin_destroy("Finished successfully", true);

			return CDW_OK;
		} else {
			/* 2TRANS: this is message in dialog window:
				ripping audio cd finished, but not entirely
				successfully */
			cdw_processwin_destroy("Finished. Some errors occurred.", true);

			return CDW_NO;
		}
	} else {
		cdw_cdio_disc_close();
		free(filename);
		filename = (char *)NULL;

		return CDW_CANCEL;
	}

}

#endif

#if 0 /* this code was not supported for some time now, I have to disable it */

int cdda2wav(void)
{
	WINDOW *cddawin;
	FILE *fp;
	DIR *directory;
	char *line;
	int start_track = 0, end_track = 0, max_track = 0, tracknum = 0;
	int ch = 0;
	int i;
	/* int bitspc, bitrate; */
	char lame[2], tmp[18], encode[255], cdinfo[255], strk[4], etrk[4], bpc[2], stereo[2], echo[2], highq[2], brate[4], cmd[255];
	/* char ogg[255]; */
	FIELD *field[18];
	FORM *form;

	sprintf(cdinfo, "%s -D%s -J -H -g", CDDA2WAV, config.cdrom);
	cdw_processwin_create("Load CD info...", (char *) NULL, false);
	run_command(cdinfo);
	cdw_processwin_destroy((char *) NULL, false);

	if ((fp = fopen(config.log_full_path, "r")) == NULL) {
		clean_before_cdw_exit();
		fprintf(stderr, "Cannot open log file...");
		exit(-1);
	}
	line = (char *) malloc(1024);

	while ((line = fgets(line, 256, fp)) != NULL) {
		/* T01:      33  2:36.25 audio linear copydenied stereo title '' from '' */
		if (sscanf(line, "T%d: %s %s audio %s", &max_track, tmp, tmp, cdinfo) == 4) {
			start_track = 1;
			end_track = max_track;
		}
	}
	cddawin = newwin(15, 60, (LINES - 15) / 2, (COLS - 60) / 2);
	keypad(cddawin, TRUE);
	wbkgd(cddawin, COLOR_PAIR(CDW_COLORS_DIALOG));
	werase(cddawin);

	nice_box(cddawin, "Grab audio CD", "");

	mvwprintw(cddawin, 14, 2, "( %s )", "Press G to start or ESC to exit");
	if (end_track != 0)
		mvwprintw(cddawin, 2, 2, "%s %d", "Number of tracks:", max_track);
	else {
		wattrset(cddawin, COLOR_PAIR(CDW_COLORS_WARNING));
		mvwprintw(cddawin, 2, 2, "No audio CD!", max_track);
	}
	wattrset(cddawin, COLOR_PAIR(CDW_COLORS_DIALOG));

	sprintf(bpc, "%s", config.bitsperchn);
	sprintf(brate, "%s", config.bitrate);
	sprintf(stereo, "%s", config.stereo);
	sprintf(echo, "%s", config.echosound);
	sprintf(encode, "%s", config.encode);
	sprintf(lame, "%s", config.lame);
	sprintf(highq, "%s", config.highq);
	sprintf(strk, "%d", start_track);
	sprintf(etrk, "%d", end_track);


	field[0] = new_field(1, 20, 1, 1, 0, 0);
	set_field_buffer(field[0], 0, "Start track");
	field[1] = new_field(1, 3, 1, 22, 0, 0);
	set_field_buffer(field[1], 0, strk);

	field[2] = new_field(1, 20, 2, 1, 0, 0);
	set_field_buffer(field[2], 0, "End track");
	field[3] = new_field(1, 3, 2, 22, 0, 0);
	set_field_buffer(field[3], 0, etrk);

	field[4] = new_field(1, 20, 4, 1, 0, 0);
	set_field_buffer(field[4], 0, "Stereo");
	field[5] = new_field(1, 1, 4, 23, 0, 0);
	set_field_buffer(field[5], 0, (!strncmp(stereo, "1", 1) ? "X" : "_"));

	field[6] = new_field(1, 24, 4, 29, 0, 0);
	set_field_buffer(field[6], 0, "Bits per channel");
	field[7] = new_field(1, 3, 4, 54, 0, 0);
	set_field_buffer(field[7], 0, bpc);

	field[8] = new_field(1, 20, 5, 1, 0, 0);
	set_field_buffer(field[8], 0, "Echo to sound dev.");
	field[9] = new_field(1, 1, 5, 23, 0, 0);
	set_field_buffer(field[9], 0, (!strncmp(echo, "1", 1) ? "X" : "_"));

	field[10] = new_field(1, 20, 6, 1, 0, 0);
	set_field_buffer(field[10], 0, "Encode to Ogg Vorbis");
	field[11] = new_field(1, 1, 6, 23, 0, 0);
	set_field_buffer(field[11], 0, (!strncmp(encode, "1", 1) ? "X" : "_"));

	field[12] = new_field(1, 24, 6, 29, 0, 0);
	set_field_buffer(field[12], 0, "High Quality");
	field[13] = new_field(1, 1, 6, 55, 0, 0);
	set_field_buffer(field[13], 0, (!strncmp(highq, "1", 1) ? "X" : "_"));

	field[14] = new_field(1, 20, 7, 1, 0, 0);
	set_field_buffer(field[14], 0, "Encode to Mp3");
	field[15] = new_field(1, 1, 7, 23, 0, 0);
	set_field_buffer(field[15], 0, (!strncmp(lame, "1", 1) ? "X" : "_"));

	field[16] = new_field(1, 24, 7, 29, 0, 0);
	set_field_buffer(field[16], 0, "Bitrate");
	field[17] = new_field(1, 4, 7, 54, 0, 0);
	set_field_buffer(field[17], 0, brate);
	field[18] = NULL;

	/* Entries */
	for (i = 1; i <= 9; i++) {
		switch (i) {
#ifndef OGGENC
		case 6:
			field_opts_off(field[(i * 2) - 1], O_ACTIVE);
			set_field_back(field[(i * 2) - 1], COLOR_PAIR(9) | A_BOLD);
			set_field_fore(field[(i * 2) - 1], COLOR_PAIR(9) | A_BOLD);
			break;
#endif
#ifndef LAME
		case 8:
			field_opts_off(field[(i * 2) - 1], O_ACTIVE);
			set_field_back(field[(i * 2) - 1], COLOR_PAIR(9) | A_BOLD);
			set_field_fore(field[(i * 2) - 1], COLOR_PAIR(9) | A_BOLD);
			break;
#endif
		case 1:
		case 2:
		case 4:
		case 9:
			switch (i) {
			case 1:
				set_field_type(field[(i * 2) - 1], TYPE_REGEXP, "[0-9]{,2}");
				break;
			case 2:
				set_field_type(field[(i * 2) - 1], TYPE_REGEXP, "[0-9]{1,2}");
				break;
			case 4:
				set_field_type(field[(i * 2) - 1], TYPE_REGEXP, "(8|12|16)+");
				break;
			case 9:
				set_field_type(field[(i * 2) - 1], TYPE_REGEXP, "(32|56|64|96|128|192|320)+");
				break;
			}
			set_field_back(field[(i * 2) - 1], COLOR_PAIR(6));
			set_field_fore(field[(i * 2) - 1], COLOR_PAIR(6));
			break;
		default:
			set_field_type(field[(i * 2) - 1], TYPE_REGEXP, "^(X|_)$");
			set_field_back(field[(i * 2) - 1], COLOR_PAIR(2));
			set_field_fore(field[(i * 2) - 1], COLOR_PAIR(2));
			break;
		}
	}
	/* Labels */
	for (i = 1; i <= 9; i++) {
		set_field_just(field[(i * 2) - 2], JUSTIFY_RIGHT);
		field_opts_off(field[(i * 2) - 2], O_ACTIVE);
		switch (i) {
#ifndef OGGENC
		case 6:
			set_field_back(field[(i * 2) - 2], COLOR_PAIR(9) | A_BOLD);
			set_field_fore(field[(i * 2) - 2], COLOR_PAIR(9) | A_BOLD);
			break;
#endif
#ifndef LAME
		case 8:
			set_field_back(field[(i * 2) - 2], COLOR_PAIR(9) | A_BOLD);
			set_field_fore(field[(i * 2) - 2], COLOR_PAIR(9) | A_BOLD);
			break;
#endif
		default:
			set_field_back(field[(i * 2) - 2], COLOR_PAIR(2));
			set_field_fore(field[(i * 2) - 2], COLOR_PAIR(2));
			break;
		}
	}
	form = new_form(field);
	set_form_win(form, cddawin);
	set_form_sub(form, derwin(cddawin, 10, 58, 3, 1));
	post_form(form);

	put_ckbox(cddawin, 7, 23);
	put_ckbox(cddawin, 8, 23);
#ifdef OGGENC
	put_ckbox(cddawin, 9, 23);
#endif
	put_ckbox(cddawin, 9, 55);
#ifdef LAME
	put_ckbox(cddawin, 10, 23);
#endif

	set_current_field(form, field[0]);
	form_driver(form, REQ_END_LINE);
	wrefresh(cddawin);

	wattrset(cddawin, COLOR_PAIR(2));
	while ((ch = wgetch(cddawin)) != 27) {
		switch (ch) {
		case KEY_HOME:
			form_driver(form, REQ_BEG_LINE);
			break;
		case KEY_END:
			form_driver(form, REQ_END_LINE);
			break;
		case KEY_LEFT:
			form_driver(form, REQ_PREV_CHAR);
			break;
		case KEY_RIGHT:
			form_driver(form, REQ_NEXT_CHAR);
			break;
		case KEY_DOWN:
			form_driver(form, REQ_NEXT_FIELD);
			form_driver(form, REQ_END_LINE);
			break;
		case KEY_UP:
			form_driver(form, REQ_PREV_FIELD);
			form_driver(form, REQ_END_LINE);
			break;
		case KEY_BACKSPACE:
			form_driver(form, REQ_DEL_PREV);
			break;
		case KEY_DC:
			form_driver(form, REQ_DEL_CHAR);
			break;
		case 'g':
		case 'G':
			/* mkdir(config.audiodir, S_IRWXU); */
			if ((directory = opendir(config.audiodir)) == NULL) {
				if (dialogbox("Directory not exist", "Audio directory not exist!\nDo you wish to create?", 3) == CDW_OK) {
					if (mkdir(config.audiodir, S_IRWXU) != 0) {
						dialogbox("Error", "Cannot create directory!", 0);
						break;
					}
				} else {
					break;
				}
			}
			(void) closedir(directory);
			wrefresh(cddawin);
			if (end_track != 0) {
				sprintf((&config)->stereo, (!strncmp(field_buffer(field[5], 0), "X", 1) ? "1" : "0"));
				sprintf((&config)->bitsperchn, rtrim(field_buffer(field[7], 0)));
				sprintf((&config)->echosound, (!strncmp(field_buffer(field[9], 0), "X", 1) ? "1" : "0"));
				sprintf((&config)->encode, (!strncmp(field_buffer(field[11], 0), "X", 1) ? "1" : "0"));
				sprintf((&config)->highq, (!strncmp(field_buffer(field[13], 0), "X", 1) ? "1" : "0"));
				sprintf((&config)->lame, (!strncmp(field_buffer(field[15], 0), "X", 1) ? "1" : "0"));
				sprintf((&config)->bitrate, rtrim(field_buffer(field[17], 0)));
				start_track = atoi(rtrim(field_buffer(field[1], 0)));
				end_track = atoi(rtrim(field_buffer(field[3], 0)));
				write_conf();
				sprintf(cdinfo, "%s ", CDDA2WAV);
				if (strncmp(config.stereo, "1", strlen(config.stereo)) == 0)
					sprintf(cdinfo, "%s -s", cdinfo);
				else
					sprintf(cdinfo, "%s -m", cdinfo);
				if (strncmp(config.echosound, "1", strlen(config.echosound)) == 0) {
					sprintf(cdinfo, "%s -e", cdinfo);
				}
				if (strncmp(config.encode, "1", strlen(config.encode)) == 0) {
#ifdef OGGENC
					char msg[30];
					wrefresh(derwin(main_cdw_win, LINES - 1, COLS - 1, 0, 0));
					sprintf(cmd, "%s", cdinfo);
					for (tracknum = start_track; tracknum <= end_track; tracknum++) {
						if (strncmp(config.highq, "1", strlen(config.highq)) == 0) {
							sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -q 8 -o %s/audio_%.2d.ogg -", cmd, config.cdrom, tracknum, config.bitsperchn, OGGENC,
								config.audiodir, tracknum);
						} else
							sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -b%s -o %s/audio_%.2d.ogg -", cmd, config.cdrom, tracknum, config.bitsperchn, OGGENC,
								config.bitrate, config.audiodir, tracknum);
						sprintf(msg, "Track: %d", tracknum);
						run_command(cdinfo, "Grab audio CD", 0, 0, 1, msg);
					}
#endif
				} else if (strncmp(config.lame, "1", strlen(config.lame)) == 0) {
#ifdef LAME
					char msg[30];
					wrefresh(derwin(main_cdw_win, LINES - 1, COLS - 1, 0, 0));
					sprintf(cmd, "%s", cdinfo);
					for (tracknum = start_track; tracknum <= end_track; tracknum++) {
						if (strncmp(config.highq, "1", strlen(config->highq)) == 0) {
							sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -h -V2 -b%s - %s/audio_%.2d.mp3 -", cmd, config.cdrom, tracknum, config.bitsperchn, LAME,
								config.bitrate, config.audiodir, tracknum);
						} else
							sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -b%s - %s/audio_%.2d.mp3 -", cmd, config.cdrom, tracknum, config.bitsperchn, LAME,
								config.bitrate, config.audiodir, tracknum);
						sprintf(msg, "Track: %d", tracknum);
						run_command(cdinfo, "Grab audio CD", 0, 0, 1, msg);
					}
#endif
				} else {
					char msg[30];
					wrefresh(derwin(&main_cdw_win, LINES - 1, COLS - 1, 0, 0));
					sprintf(cmd, "%s", cdinfo);
					for (tracknum = start_track; tracknum <= end_track; tracknum++) {
						sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H %s/audio_%.2d.wav", cmd, config.cdrom, tracknum, bpc, config.audiodir, tracknum);
						sprintf(msg, "Track: %d", tracknum);
						cdw_processwin_create("Grab Audio CD", msg, false);
						run_command(cdinfo);
						cdw_processwin_destroy((char *) NULL, false);
					}
				}
				wrefresh(derwin(cddawin, 15, 60, 0, 0));
				wrefresh(cddawin);
			}
			break;
		default:
			if (ch == ' ') {
				FIELD *cur;
				int fld_index;

				cur = current_field(form);
				fld_index = field_index(cur);
				switch (fld_index) {
				case 5:
				case 9:
				case 11:
				case 13:
				case 15:
					ch = (!strncmp(field_buffer(cur, 0), "X", 1) ? '_' : 'X');
					if ((fld_index == 11) && (!strcmp(field_buffer(field[11], 0), "_"))) {
						set_field_buffer(field[15], 0, "_");
					}
					if ((fld_index == 15) && (!strcmp(field_buffer(field[15], 0), "_"))) {
						set_field_buffer(field[11], 0, "_");
					}
					break;
				}
			}
			form_driver(form, ch);
			break;
		}
		wrefresh(cddawin);
	}

	delwin(cddawin);

	return 0;
}

#endif
