/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.samtools.util.AbstractAsyncWriter;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;

public class AsyncVariantContextWriter
extends AbstractAsyncWriter<VariantContext>
implements VariantContextWriter {
    private final VariantContextWriter underlyingWriter;

    public AsyncVariantContextWriter(VariantContextWriter out) {
        this(out, 2000);
    }

    public AsyncVariantContextWriter(VariantContextWriter out, int queueSize) {
        super(queueSize);
        this.underlyingWriter = out;
    }

    @Override
    protected void synchronouslyWrite(VariantContext item) {
        this.underlyingWriter.add(item);
    }

    @Override
    protected void synchronouslyClose() {
        this.underlyingWriter.close();
    }

    @Override
    protected final String getThreadNamePrefix() {
        return "VariantContextWriterThread-";
    }

    @Override
    public void add(VariantContext vc) {
        this.write(vc);
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.underlyingWriter.writeHeader(header);
    }

    @Override
    public boolean checkError() {
        return false;
    }

    @Override
    public void setHeader(VCFHeader header) {
        this.underlyingWriter.setHeader(header);
    }
}

