/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.cram.encoding.rans.RANS;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public class ExternalCompression {
    private static final int GZIP_COMPRESSION_LEVEL = Integer.valueOf(System.getProperty("gzip.compression.level", "5"));

    public static byte[] gzip(byte[] data) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(byteArrayOutputStream){
            {
                this.def.setLevel(GZIP_COMPRESSION_LEVEL);
            }
        };
        IOUtil.copyStream(new ByteArrayInputStream(data), gos);
        gos.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gunzip(byte[] data) throws IOException {
        GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(data));
        return InputStreamUtils.readFully(gzipInputStream);
    }

    public static byte[] bzip2(byte[] data) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BZip2CompressorOutputStream bos = new BZip2CompressorOutputStream((OutputStream)byteArrayOutputStream);
        IOUtil.copyStream(new ByteArrayInputStream(data), (OutputStream)bos);
        bos.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] unbzip2(byte[] data) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        return InputStreamUtils.readFully((InputStream)new BZip2CompressorInputStream((InputStream)byteArrayInputStream));
    }

    public static byte[] rans(byte[] data, RANS.ORDER order) {
        ByteBuffer buffer = RANS.compress(ByteBuffer.wrap(data), order, null);
        return ExternalCompression.toByteArray(buffer);
    }

    public static byte[] rans(byte[] data, int order) {
        ByteBuffer buffer = RANS.compress(ByteBuffer.wrap(data), RANS.ORDER.fromInt(order), null);
        return ExternalCompression.toByteArray(buffer);
    }

    public static byte[] unrans(byte[] data) {
        ByteBuffer buf = RANS.uncompress(ByteBuffer.wrap(data), null);
        return ExternalCompression.toByteArray(buf);
    }

    public static byte[] xz(byte[] data) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(data.length * 2);
        XZCompressorOutputStream xzCompressorOutputStream = new XZCompressorOutputStream((OutputStream)byteArrayOutputStream);
        xzCompressorOutputStream.write(data);
        xzCompressorOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] unxz(byte[] data) throws IOException {
        XZCompressorInputStream xzCompressorInputStream = new XZCompressorInputStream((InputStream)new ByteArrayInputStream(data));
        return InputStreamUtils.readFully((InputStream)xzCompressorInputStream);
    }

    private static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.array().length == buffer.limit()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }
}

