/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import org.fest.swing.util.Strings;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Arrays;

public class StringTextMatcher
implements TextMatcher {
    private final String[] values;

    public StringTextMatcher(String ... values) {
        if (values == null) {
            throw new NullPointerException("The array of values should not be null");
        }
        if (Arrays.isEmpty((Object[])values)) {
            throw new IllegalArgumentException("The array of values should not be empty");
        }
        this.values = values;
    }

    public boolean isMatching(String text) {
        for (String value : this.values) {
            if (!Strings.areEqualOrMatch(value, text)) continue;
            return true;
        }
        return false;
    }

    public String description() {
        if (this.onlyOneValue()) {
            return "value";
        }
        return "values";
    }

    public String formattedValues() {
        if (this.onlyOneValue()) {
            return org.fest.util.Strings.quote((String)this.values[0]);
        }
        return Arrays.format((Object)this.values);
    }

    private boolean onlyOneValue() {
        return this.values.length == 1;
    }
}

